/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.tree;

import com.intellij.cidr.profiling.memory.MemoryProfileNavigationData;
import com.intellij.cidr.profiling.memory.MemoryProfilePresentation;
import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileStackFrameTreeNode
extends MemoryProfileTreeNode {
    @NotNull
    private final MemoryProfileFrame myFrame;
    @NotNull
    private final Project myProject;

    public MemoryProfileStackFrameTreeNode(@NotNull MemoryProfileFrame frame, @NotNull Project project) {
        if (frame == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(1);
        }
        super(frame);
        this.myFrame = frame;
        this.myProject = project;
    }

    @NotNull
    public MemoryProfileFrame getFrame() {
        MemoryProfileFrame memoryProfileFrame = this.myFrame;
        if (memoryProfileFrame == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(2);
        }
        return memoryProfileFrame;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Debugger.Frame;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        MemoryProfileNavigationData navigationData = MemoryProfileUtil.getNavigationData(this.myFrame);
        if (navigationData == null) {
            return null;
        }
        return navigationData.isLineNumberValid() ? new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile(), navigationData.getLineNumber(), 0) : new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile());
    }

    @Override
    public boolean canBeExcluded() {
        return false;
    }

    @Override
    protected void render(@NotNull ColoredTextContainer renderer) {
        ColoredText coloredFunction;
        if (renderer == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(3);
        }
        @NlsSafe String pointer = this.myFrame.getInstructionPointer();
        @NlsSafe String file = this.myFrame.getFile();
        @NlsSafe String line = this.myFrame.getLine();
        @NlsSafe String binary = this.myFrame.getBinary();
        @NlsSafe String function = this.myFrame.getFunction();
        ColoredText coloredText = coloredFunction = StringUtil.isNotEmpty((String)function) ? MemoryProfilePresentation.getStackTraceColoredText(function) : null;
        if (StringUtil.isEmpty((String)pointer) && coloredFunction == null && StringUtil.isEmpty((String)binary) && StringUtil.isEmpty((String)file)) {
            MemoryProfileStackFrameTreeNode.appendEmptyText(renderer);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MemoryProfileStackFrameTreeNode.doRenderFunctionOrBinary(coloredFunction, binary, renderer);
            return;
        }
        if (StringUtil.isNotEmpty((String)pointer)) {
            renderer.append(pointer, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            MemoryProfileStackFrameTreeNode.appendSeparator(renderer);
        }
        MemoryProfileStackFrameTreeNode.doRenderFunctionOrBinary(coloredFunction, binary, renderer);
        MemoryProfileStackFrameTreeNode.appendSeparator(renderer);
        if (StringUtil.isNotEmpty((String)file)) {
            if (StringUtil.isNotEmpty((String)line)) {
                renderer.append(file + ":" + line, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            } else {
                renderer.append(file, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
            MemoryProfileStackFrameTreeNode.appendSeparator(renderer);
        }
    }

    private static void doRenderFunctionOrBinary(@Nullable ColoredText coloredFunction, @NlsSafe String binary, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(4);
        }
        if (coloredFunction != null) {
            renderer.append(coloredFunction);
        } else {
            renderer.append(binary, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    @NlsSafe
    @NotNull
    public String toString() {
        SimpleColoredText simpleColoredText = new SimpleColoredText();
        this.render((ColoredTextContainer)simpleColoredText);
        String string = simpleColoredText.toString();
        if (string == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/tree/MemoryProfileStackFrameTreeNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/tree/MemoryProfileStackFrameTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRenderFunctionOrBinary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

