/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileConsoleViewWrapper;
import com.intellij.cidr.profiling.memory.MemoryProfileEnvironment;
import com.intellij.cidr.profiling.memory.MemoryProfileFileReader;
import com.intellij.cidr.profiling.memory.MemoryProfileFileWatcher;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileOutputPanel;
import com.intellij.cidr.profiling.valgrind.ValgrindCommandLineParametersBuilder;
import com.intellij.cidr.profiling.valgrind.ValgrindConfigurable;
import com.intellij.cidr.profiling.valgrind.ValgrindExecutionContext;
import com.intellij.cidr.profiling.valgrind.ValgrindExecutor;
import com.intellij.cidr.profiling.valgrind.ValgrindHandler;
import com.intellij.cidr.profiling.valgrind.ValgrindOutputConsumer;
import com.intellij.cidr.profiling.valgrind.ValgrindScopeService;
import com.intellij.cidr.profiling.valgrind.ValgrindSettings;
import com.intellij.cidr.profiling.valgrind.ValgrindUtil;
import com.intellij.cidr.profiling.valgrind.actions.EditValgrindSettingsAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindConfigurationExtensionBase {
    private static final Logger LOG = Logger.getInstance(ValgrindConfigurationExtensionBase.class);
    public static final Key<Path> OUTPUT_DIRECTORY_KEY = Key.create((String)"valgrind.output_directory_key");
    public static final Key<Path> SUPPRESSION_FILES_REMOTE_DIR_KEY = Key.create((String)"valgrind.output.suppression.files.remote.dir");
    public static final Key<MemoryProfileTreeDataModel> DATA_MODEL_KEY = Key.create((String)"valgrind.data_model_key");
    public static final Key<MemoryProfileOutputPanel> OUTPUT_PANEL_KEY = Key.create((String)"valgrind.output_panel_key");

    public boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(0);
        }
        return ValgrindExecutionContext.isApplicableFor(configuration);
    }

    public boolean isEnabledFor(@NotNull RunConfigurationBase applicableConfiguration, @NotNull MemoryProfileEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(2);
        }
        return ValgrindExecutionContext.isEnabledFor(applicableConfiguration, environment, runnerSettings);
    }

    public void patchCommandLine(@NotNull RunConfigurationBase configuration, @Nullable RunnerSettings runnerSettings, @NotNull MemoryProfileEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull UserDataHolderBase context) throws ExecutionException {
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(4);
        }
        if (cmdLine == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(5);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(7);
        }
        if (!"ValgrindRunner".equals(runnerId)) {
            return;
        }
        String programPath = environment.toEnvPath(cmdLine.getExePath());
        String valgrindPath = environment.toEnvPath(ValgrindSettings.getInstance().getValgrindPath());
        if (!environment.isPathExist(programPath)) {
            throw new ExecutionException(CidrProfilingBundle.message("run.fileNotFound", programPath));
        }
        Project project = configuration.getProject();
        if (!environment.isPathExist(valgrindPath)) {
            throw new HyperlinkException(CidrProfilingBundle.message("valgrind.fileNotFound", valgrindPath), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, ValgrindConfigurable.class));
        }
        if (ValgrindExecutionContext.compiledWithSanitizerSwitch(configuration)) {
            MemoryProfileUtil.showNotification(ValgrindUtil.NOTIFICATION_GROUP, "Valgrind", CidrProfilingBundle.message("valgrind.sanitizers", new Object[0]), NotificationType.WARNING, project);
        }
        try {
            Path outputDirectory = ValgrindConfigurationExtensionBase.generateOutputDirectory(environment);
            String outputFile = FileUtil.join((String[])new String[]{outputDirectory.toString(), "valgrind_output_%p"});
            String outputFilePath = environment.toEnvPath(outputFile);
            cmdLine.setExePath(valgrindPath);
            ValgrindCommandLineParametersBuilder parametersBuilder = new ValgrindCommandLineParametersBuilder();
            List<String> suppressionFiles = this.prepareSuppressionFiles(environment, configuration, context, project);
            List<String> valgrindParameters = parametersBuilder.build(ValgrindSettings.getInstance().getAnalysisOptions(), suppressionFiles, outputFilePath);
            if (ValgrindConfigurationExtensionBase.isCTestExecution(configuration) && !parametersBuilder.tryAppend("--trace-children", "yes", valgrindParameters)) {
                MemoryProfileUtil.showNotification(ValgrindUtil.NOTIFICATION_GROUP, "Valgrind", CidrProfilingBundle.message("valgrind.ctest.invalid.trace.children.parameter", new Object[0]), NotificationType.WARNING, project);
            }
            valgrindParameters.add(programPath);
            cmdLine.getParametersList().prependAll(ArrayUtilRt.toStringArray(valgrindParameters));
            ValgrindConfigurationExtensionBase.putUserData(OUTPUT_DIRECTORY_KEY, outputDirectory, configuration, context);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public void attachToProcess(@NotNull RunConfigurationBase configuration, @NotNull ProcessHandler processHandler, @NotNull MemoryProfileEnvironment environment, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull UserDataHolderBase context) {
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(10);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(12);
        }
        Path outputDirectory = ValgrindConfigurationExtensionBase.getUserData(OUTPUT_DIRECTORY_KEY, configuration, context);
        if (!"ValgrindRunner".equals(runnerId)) {
            if (outputDirectory != null) {
                MemoryProfileUtil.deleteDirectorySilently(outputDirectory, LOG);
            }
            return;
        }
        LOG.assertTrue(outputDirectory != null, (Object)"outputDirectory is null");
        Project project = configuration.getProject();
        MemoryProfileTreeDataModel treeDataModel = ValgrindConfigurationExtensionBase.getUserData(DATA_MODEL_KEY, configuration, context);
        LOG.assertTrue(treeDataModel != null, (Object)"treeDataModel is null");
        MemoryProfileOutputPanel outputPanel = ValgrindConfigurationExtensionBase.getUserData(OUTPUT_PANEL_KEY, configuration, context);
        LOG.assertTrue(outputPanel != null, (Object)"outputPanel is null");
        final MemoryProfileTree tree = outputPanel.getTree();
        processHandler.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                MemoryProfileUtil.setTreeBusy(tree, CidrProfilingBundle.message("valgrind.progress", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase$1", "startNotified"));
            }
        });
        if (environment.isRemote()) {
            Path suppressionFilesDirectory = (Path)context.getUserData(SUPPRESSION_FILES_REMOTE_DIR_KEY);
            this.processOutputFromRemote(treeDataModel, outputPanel, outputDirectory, suppressionFilesDirectory, processHandler, environment, project);
        } else {
            this.processLocalOutput(treeDataModel, outputPanel, outputDirectory, processHandler, environment, project);
        }
    }

    private void processOutputFromRemote(final @NotNull MemoryProfileTreeDataModel treeDataModel, final @NotNull MemoryProfileOutputPanel outputPanel, final @NotNull Path outputDirectory, final @Nullable Path suppressionFilesDirectory, @NotNull ProcessHandler processHandler, final @NotNull MemoryProfileEnvironment environment, final @NotNull Project project) {
        if (treeDataModel == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(13);
        }
        if (outputPanel == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(14);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(15);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(16);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(18);
        }
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                MemoryProfileUtil.processOutputFromRemote("Valgrind", () -> {
                    Disposable disposableMarker = Disposer.newDisposable();
                    Disposer.register((Disposable)project, (Disposable)disposableMarker);
                    try {
                        List<Path> outputFilePaths = MemoryProfileUtil.getFiles(outputDirectory);
                        for (Path outputFilePath : outputFilePaths) {
                            ValgrindOutputConsumer consumer = new ValgrindOutputConsumer(new ValgrindHandler(treeDataModel, environment), ((ValgrindScopeService)project.getService(ValgrindScopeService.class)).getScope(), disposableMarker);
                            MemoryProfileFileReader reader = new MemoryProfileFileReader(outputFilePath, (Consumer<String>)consumer, "Valgrind");
                            reader.stop();
                        }
                        ValgrindConfigurationExtensionBase.this.processExportAction(outputPanel, outputDirectory);
                    }
                    catch (Exception e) {
                        LOG.error("Cannot process Valgrind output", (Throwable)e);
                    }
                    finally {
                        MemoryProfileUtil.setTreeDataReady(outputPanel.getTree());
                        Disposer.dispose((Disposable)disposableMarker);
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            MemoryProfileUtil.deleteDirectorySilently(outputDirectory, LOG);
                            if (suppressionFilesDirectory != null) {
                                MemoryProfileUtil.deleteDirectorySilently(suppressionFilesDirectory, LOG);
                            }
                        }
                        ValgrindConfigurationExtensionBase.showDebugHintIfNeeded(treeDataModel, project);
                    }
                }, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase$2", "processTerminated"));
            }
        });
    }

    private void processLocalOutput(final @NotNull MemoryProfileTreeDataModel treeDataModel, final @NotNull MemoryProfileOutputPanel outputPanel, final @NotNull Path outputDirectory, @NotNull ProcessHandler processHandler, @NotNull MemoryProfileEnvironment environment, final @NotNull Project project) {
        if (treeDataModel == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(19);
        }
        if (outputPanel == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(20);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(21);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(22);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(24);
        }
        final Disposable disposableMarker = Disposer.newDisposable();
        Disposer.register((Disposable)project, (Disposable)disposableMarker);
        Supplier<Consumer> consumerSupplier = () -> new ValgrindOutputConsumer(new ValgrindHandler(treeDataModel, environment), ((ValgrindScopeService)project.getService(ValgrindScopeService.class)).getScope(), disposableMarker);
        VirtualFile outputDirectoryVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputDirectory.toFile());
        LOG.assertTrue(outputDirectoryVirtualFile != null && outputDirectoryVirtualFile.exists(), (Object)"Output virtual directory is null or not found");
        final MemoryProfileFileWatcher watcher = new MemoryProfileFileWatcher(outputDirectoryVirtualFile, consumerSupplier, "Valgrind", project, disposableMarker);
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                try {
                    watcher.stop();
                    ValgrindConfigurationExtensionBase.this.processExportAction(outputPanel, outputDirectory);
                }
                finally {
                    MemoryProfileUtil.setTreeDataReady(outputPanel.getTree());
                    Disposer.dispose((Disposable)disposableMarker);
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        MemoryProfileUtil.deleteDirectorySilently(outputDirectory, LOG);
                    }
                    ValgrindConfigurationExtensionBase.showDebugHintIfNeeded(treeDataModel, project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase$3", "processTerminated"));
            }
        });
    }

    public void patchCommandLineState(@NotNull RunConfigurationBase configuration, @Nullable RunnerSettings runnerSettings, @NotNull MemoryProfileEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull UserDataHolderBase context) {
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(25);
        }
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(26);
        }
        if (state == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(27);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(28);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(29);
        }
        if (!"ValgrindRunner".equals(runnerId)) {
            return;
        }
        final Project project = configuration.getProject();
        MemoryProfileTreeDataModel treeDataModel = new MemoryProfileTreeDataModel("Valgrind", project);
        final MemoryProfileOutputPanel outputPanel = new MemoryProfileOutputPanel(treeDataModel, new EditValgrindSettingsAction(), "ValgrindToolWindow.TreePopup", project);
        ValgrindConfigurationExtensionBase.putUserData(DATA_MODEL_KEY, treeDataModel, configuration, context);
        ValgrindConfigurationExtensionBase.putUserData(OUTPUT_PANEL_KEY, outputPanel, configuration, context);
        CidrCoroutineHelper.runOnEDT(() -> {
            final ConsoleView console = state.getConsoleBuilder().getConsole();
            state.setConsoleBuilder((TextConsoleBuilder)new TextConsoleBuilderImpl(project){

                @NotNull
                protected ConsoleView createConsole() {
                    Icon icon = ValgrindExecutor.getExecutorInstance().getIcon();
                    return new MemoryProfileConsoleViewWrapper("Valgrind", console, outputPanel, project, icon);
                }
            });
            return null;
        });
    }

    @NotNull
    private static Path generateOutputDirectory(@NotNull MemoryProfileEnvironment environment) throws IOException {
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(30);
        }
        @NlsSafe String valgrindOutputFilePrefix = "clion-valgrind";
        String uniqueSuffix = UUID.randomUUID().toString();
        Path path = environment.createTempDirectory("clion-valgrind", uniqueSuffix);
        if (path == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(31);
        }
        return path;
    }

    private void processExportAction(@NotNull MemoryProfileOutputPanel outputPanel, @NotNull Path outputDirectory) {
        if (outputPanel == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(32);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(33);
        }
        String exportContent = this.getExportContent(outputDirectory);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (StringUtil.isNotEmpty((String)exportContent)) {
                outputPanel.setExportContent(exportContent);
            }
        });
    }

    private static boolean isCTestExecution(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(34);
        }
        return configuration.getType().getId().equals("CTestRunConfiguration");
    }

    @Nullable
    private String getExportContent(@NotNull Path outputDirectory) {
        if (outputDirectory == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(35);
        }
        try {
            List<Path> filePaths = MemoryProfileUtil.getFiles(outputDirectory);
            StringBuilder content = new StringBuilder();
            for (Path filePath : filePaths) {
                content.append(Files.readString(filePath)).append(System.lineSeparator());
            }
            return content.toString();
        }
        catch (Exception e) {
            LOG.error("Cannot load Valgrind output for Export action", (Throwable)e);
            return null;
        }
    }

    private List<String> prepareSuppressionFiles(@NotNull MemoryProfileEnvironment environment, @NotNull RunConfigurationBase configuration, @NotNull UserDataHolderBase context, @NotNull Project project) {
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(36);
        }
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(37);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(38);
        }
        if (project == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(39);
        }
        return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.doPrepareSuppressionFiles(environment, configuration, context), CidrProfilingBundle.message("valgrind.prepare.suppression.files", new Object[0]), false, project);
    }

    @NotNull
    private List<String> doPrepareSuppressionFiles(@NotNull MemoryProfileEnvironment environment, @NotNull RunConfigurationBase configuration, @NotNull UserDataHolderBase context) {
        ArrayList<String> arrayList;
        if (environment == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(40);
        }
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(41);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(42);
        }
        List<String> localSuppressionFiles = ValgrindSettings.getInstance().getSuppressionFiles();
        if (!environment.isRemote() || localSuppressionFiles.isEmpty()) {
            List<String> list = localSuppressionFiles;
            if (list == null) {
                ValgrindConfigurationExtensionBase.$$$reportNull$$$0(43);
            }
            return list;
        }
        try {
            ArrayList<String> envSuppressionFiles = new ArrayList<String>(localSuppressionFiles.size());
            Path envDirPath = environment.createTempDirectory("clion-valgrind-suppressions", null);
            ValgrindConfigurationExtensionBase.putUserData(SUPPRESSION_FILES_REMOTE_DIR_KEY, envDirPath, configuration, context);
            for (String localSuppressionFile : localSuppressionFiles) {
                if (!FileUtil.exists((String)localSuppressionFile)) continue;
                Path envSuppressionFilePath = Files.createTempFile(envDirPath, "valgrind_suppression_file", null, new FileAttribute[0]);
                Files.writeString(envSuppressionFilePath, (CharSequence)FileUtil.loadFile((File)new File(localSuppressionFile)), new OpenOption[0]);
                envSuppressionFiles.add(environment.toEnvPath(envSuppressionFilePath.toString()));
            }
            arrayList = envSuppressionFiles;
        }
        catch (Exception e) {
            LOG.error("Cannot create environment suppression files", (Throwable)e);
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ValgrindConfigurationExtensionBase.$$$reportNull$$$0(45);
            }
            return list;
        }
        if (arrayList == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    private static void showDebugHintIfNeeded(@NotNull MemoryProfileTreeDataModel model, @NotNull Project project) {
        if (model == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(46);
        }
        if (project == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(47);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (model.hasErrors() && !MemoryProfileUtil.isModelNavigatable(model)) {
                MemoryProfileUtil.showNotification(ValgrindUtil.NOTIFICATION_GROUP, "Valgrind", CidrProfilingBundle.message("valgrind.no.debug.info.hint", new Object[0]), NotificationType.INFORMATION, project);
            }
        });
    }

    private static <T> void putUserData(@NotNull Key<T> key, T value, @NotNull RunConfigurationBase configuration, @NotNull UserDataHolderBase context) {
        if (key == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(48);
        }
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(49);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(50);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            configuration.putUserData(key, value);
        } else {
            context.putUserData(key, value);
        }
    }

    private static <T> T getUserData(@NotNull Key<T> key, @NotNull RunConfigurationBase configuration, @NotNull UserDataHolderBase context) {
        if (key == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(51);
        }
        if (configuration == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(52);
        }
        if (context == null) {
            ValgrindConfigurationExtensionBase.$$$reportNull$$$0(53);
        }
        return (T)(ApplicationManager.getApplication().isUnitTestMode() ? configuration.getUserData(key) : context.getUserData(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 31, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 17: 
            case 23: 
            case 26: 
            case 30: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 6: 
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 7: 
            case 12: 
            case 29: 
            case 38: 
            case 42: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDataModel";
                break;
            }
            case 14: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPanel";
                break;
            }
            case 15: 
            case 21: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 18: 
            case 24: 
            case 39: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 31: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOutputDirectory";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "doPrepareSuppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processOutputFromRemote";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processLocalOutput";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateOutputDirectory";
                break;
            }
            case 31: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processExportAction";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCTestExecution";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExportContent";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "prepareSuppressionFiles";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "doPrepareSuppressionFiles";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "showDebugHintIfNeeded";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 31, 43, 44, 45 -> new IllegalStateException(string);
        };
    }

    private static class HyperlinkException
    extends ExecutionException
    implements HyperlinkListener {
        @NotNull
        private final Runnable myHyperlinkEventRunnable;

        HyperlinkException(@NlsContexts.DialogMessage @NotNull String cause, @NotNull Runnable hyperlinkEventRunnable) {
            if (cause == null) {
                HyperlinkException.$$$reportNull$$$0(0);
            }
            if (hyperlinkEventRunnable == null) {
                HyperlinkException.$$$reportNull$$$0(1);
            }
            super(cause);
            this.myHyperlinkEventRunnable = hyperlinkEventRunnable;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myHyperlinkEventRunnable.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hyperlinkEventRunnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/cidr/profiling/valgrind/ValgrindConfigurationExtensionBase$HyperlinkException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

