/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.parser.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.clion.profiling.CLionProfilingBundle;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceEvent;
import com.intellij.clion.profiling.eventtrace.exception.TraceEventFormatException;
import com.intellij.clion.profiling.eventtrace.holder.ClosableEventHolder;
import com.intellij.clion.profiling.eventtrace.holder.HolderFactory;
import com.intellij.clion.profiling.eventtrace.parser.ResultLogger;
import com.intellij.clion.profiling.eventtrace.parser.events.TraceEventParserTimeLine;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H&J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH&J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH&J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/profiling/eventtrace/parser/events/JSONTraceEventParser;", "Lcom/intellij/clion/profiling/eventtrace/parser/events/TraceEventParserTimeLine;", "<init>", "()V", "parseEvent", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceEvent;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseEvents", "", "eventHolder", "Lcom/intellij/clion/profiling/eventtrace/holder/ClosableEventHolder;", "getEventsNode", "mainNode", "beforeParse", "holder", "afterParse", "parse", "fileName", "", "s", "Ljava/io/File;", "intellij.clion.profiling"})
@SourceDebugExtension(value={"SMAP\nJSONTraceEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONTraceEventParser.kt\ncom/intellij/clion/profiling/eventtrace/parser/events/JSONTraceEventParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1878#2,3:110\n*S KotlinDebug\n*F\n+ 1 JSONTraceEventParser.kt\ncom/intellij/clion/profiling/eventtrace/parser/events/JSONTraceEventParser\n*L\n39#1:110,3\n*E\n"})
public abstract class JSONTraceEventParser
extends TraceEventParserTimeLine {
    @NotNull
    public abstract TraceEvent parseEvent(@NotNull JsonNode var1);

    /*
     * WARNING - void declaration
     */
    public void parseEvents(@NotNull ClosableEventHolder eventHolder, @NotNull JsonNode node) {
        Intrinsics.checkNotNullParameter((Object)eventHolder, (String)"eventHolder");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$forEachIndexed$iv = (Iterable)node;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonNode jsonNode = (JsonNode)item$iv;
            int i = n;
            boolean bl = false;
            if (this.getProgressIndicator() != null) {
                ProgressIndicator progressIndicator = this.getProgressIndicator();
                Intrinsics.checkNotNull((Object)progressIndicator);
                if (progressIndicator.isCanceled()) {
                    return;
                }
                ProgressIndicator progressIndicator2 = this.getProgressIndicator();
                Intrinsics.checkNotNull((Object)progressIndicator2);
                progressIndicator2.setFraction((double)i / (double)node.size() * 0.6666666666666666);
            }
            try {
                void it;
                Intrinsics.checkNotNull((Object)it);
                TraceEvent event = this.parseEvent((JsonNode)it);
                ResultLogger resultLogger = this.getResultLogger();
                long l = resultLogger.getCount();
                resultLogger.setCount(l + 1L);
                eventHolder.add(event);
            }
            catch (TraceEventFormatException e) {
                this.getResultLogger().addException(e);
            }
        }
        ClosableEventHolder.close$default(eventHolder, null, 1, null);
    }

    @NotNull
    public abstract JsonNode getEventsNode(@NotNull JsonNode var1);

    public abstract void beforeParse(@NotNull JsonNode var1, @NotNull ClosableEventHolder var2);

    public abstract void afterParse(@NotNull JsonNode var1, @NotNull ClosableEventHolder var2);

    @Override
    @Nullable
    public ClosableEventHolder parse(@NotNull String fileName, @NotNull File s) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.getProgressIndicator() != null) {
            ProgressIndicator progressIndicator = this.getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.setFraction(0.0);
            ProgressIndicator progressIndicator2 = this.getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator2);
            Object[] objectArray = new Object[]{fileName};
            progressIndicator2.setText(CLionProfilingBundle.message("profiler.eventtracer.progress.text.start.parse", objectArray));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode mainNode = objectMapper.readTree(s);
        Intrinsics.checkNotNull((Object)mainNode);
        JsonNode eventsNode = this.getEventsNode(mainNode);
        ClosableEventHolder holder = HolderFactory.Companion.getHolder(this.getNodes(), this.getLeaf());
        this.beforeParse(mainNode, holder);
        this.parseEvents(holder, eventsNode);
        this.afterParse(mainNode, holder);
        ResultLogger resultLogger = this.getResultLogger();
        int n = resultLogger.getCurrentCountParsers();
        resultLogger.setCurrentCountParsers(n + 1);
        if (this.getProgressIndicator() != null) {
            ProgressIndicator progressIndicator = this.getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            if (progressIndicator.isCanceled()) {
                return null;
            }
        }
        return holder;
    }
}

