/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NavigatableSymbolSearcher {
    public static final ExtensionPointName<NavigatableSymbolSearcher> EP_NAME = ExtensionPointName.create((String)"com.intellij.profiler.clion.navigatableSymbolSearcher");
    protected static final Logger LOG = Logger.getInstance(NavigatableSymbolSearcher.class);

    public static NavigatablePsiElement[] findNavigatableSymbols(@NotNull String qualifiedSignature, @NotNull Project project) {
        List searchers;
        if (qualifiedSignature == null) {
            NavigatableSymbolSearcher.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NavigatableSymbolSearcher.$$$reportNull$$$0(1);
        }
        if ((searchers = EP_NAME.getExtensionList()).isEmpty()) {
            LOG.warn("Cannot find any OCNavigatableSymbolSearcher: return empty result");
            return NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        }
        Object[] combinedElements = NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        for (NavigatableSymbolSearcher searcher : searchers) {
            combinedElements = (NavigatablePsiElement[])ArrayUtil.mergeArrays((Object[])combinedElements, (Object[])searcher.doFindNavigatableSymbols(qualifiedSignature, project));
        }
        return combinedElements;
    }

    protected abstract NavigatablePsiElement[] doFindNavigatableSymbols(@NotNull String var1, @NotNull Project var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifiedSignature";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/profiler/clion/NavigatableSymbolSearcher";
        objectArray[2] = "findNavigatableSymbols";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

