/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshPathINotifyWatchKey;
import com.pastdev.jsch.nio.file.UnixSshPathWatchKey;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshFileSystemWatchService
implements WatchService {
    private static Logger logger = LoggerFactory.getLogger(UnixSshFileSystemWatchService.class);
    private static final long DEFAULT_POLLING_INTERVAL = 10L;
    private static final TimeUnit DEFAULT_POLLING_INTERVAL_TIME_UNIT = TimeUnit.MINUTES;
    private long pollingInterval;
    private TimeUnit pollingIntervalTimeUnit;
    private volatile boolean closed;
    private final ExecutorService executorService;
    private final LinkedBlockingDeque<WatchKey> pendingKeys;
    private boolean useINotifyWatchKey = false;
    private final Map<UnixSshPath, Future<?>> watchKeyFutures;
    private final Map<UnixSshPath, UnixSshPathWatchKey> watchKeys;
    private final Lock watchKeysLock;

    private UnixSshFileSystemWatchService() {
        logger.debug("creating new watch service polling every {} {}", (Object)this.pollingInterval, (Object)this.pollingIntervalTimeUnit);
        this.pendingKeys = new LinkedBlockingDeque();
        this.executorService = Executors.newCachedThreadPool();
        this.watchKeys = new HashMap<UnixSshPath, UnixSshPathWatchKey>();
        this.watchKeyFutures = new HashMap();
        this.watchKeysLock = new ReentrantLock();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    boolean closed() {
        return this.closed;
    }

    void enqueue(WatchKey watchKey) {
        this.ensureOpen();
        this.pendingKeys.add(watchKey);
    }

    void ensureOpen() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
    }

    public static WatchService inotifyWatchService() {
        UnixSshFileSystemWatchService service = new UnixSshFileSystemWatchService();
        service.useINotifyWatchKey = true;
        return service;
    }

    private UnixSshPathWatchKey newWatchKey(UnixSshPath path, WatchEvent.Kind<?>[] events) {
        return this.useINotifyWatchKey ? new UnixSshPathINotifyWatchKey(this, path, events) : new UnixSshPathWatchKey(this, path, events, this.pollingInterval, this.pollingIntervalTimeUnit);
    }

    @Override
    public WatchKey poll() {
        this.ensureOpen();
        return this.pendingKeys.poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.ensureOpen();
        return this.pendingKeys.poll(timeout, unit);
    }

    public static UnixSshFileSystemWatchService pollingWatchService(Long pollingInterval, TimeUnit pollingIntervalTimeUnit) {
        UnixSshFileSystemWatchService service = new UnixSshFileSystemWatchService();
        service.pollingInterval = pollingInterval == null ? 10L : pollingInterval;
        service.pollingIntervalTimeUnit = pollingIntervalTimeUnit == null ? DEFAULT_POLLING_INTERVAL_TIME_UNIT : pollingIntervalTimeUnit;
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnixSshPathWatchKey register(UnixSshPath path, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        try {
            this.watchKeysLock.lock();
            if (this.watchKeys.containsKey(path)) {
                UnixSshPathWatchKey unixSshPathWatchKey = this.watchKeys.get(path);
                return unixSshPathWatchKey;
            }
            UnixSshPathWatchKey watchKey = this.newWatchKey(path, events);
            this.watchKeys.put(path, watchKey);
            this.watchKeyFutures.put(path, this.executorService.submit(watchKey));
            UnixSshPathWatchKey unixSshPathWatchKey = watchKey;
            return unixSshPathWatchKey;
        }
        finally {
            this.watchKeysLock.unlock();
        }
    }

    void unregister(UnixSshPathWatchKey watchKey) {
        try {
            this.watchKeysLock.lock();
            UnixSshPath path = watchKey.watchable();
            if (!this.watchKeys.containsKey(path)) {
                return;
            }
            this.watchKeyFutures.remove(path).cancel(true);
            this.watchKeys.remove(path);
        }
        finally {
            this.watchKeysLock.unlock();
        }
    }

    @Override
    public WatchKey take() throws InterruptedException {
        this.ensureOpen();
        return this.pendingKeys.take();
    }
}

