/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.diagnostics.CdDateUtilKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsBundle;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CdWorkspaceEvents;", "", "<init>", "()V", "events", "", "", "isEnabled", "", "workspaceChanged", "", "event", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener$OCWorkspaceEvent;", "selectedResolveConfigurationChanged", "getResult", "Companion", "intellij.clion.diagnostics"})
public final class CdWorkspaceEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> events = new ArrayList();
    private final boolean isEnabled = Registry.Companion.get("cpp.diagnostics.track.events").asBoolean();
    @NotNull
    private static final String ENABLED_KEY = "cpp.diagnostics.track.events";

    public final void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled) {
            return;
        }
        this.events.add(CdDateUtilKt.formatCurrentTimeMS() + ": " + event);
    }

    public final void selectedResolveConfigurationChanged() {
        if (!this.isEnabled) {
            return;
        }
        this.events.add(CdDateUtilKt.formatCurrentTimeMS() + ": selectedResolveConfigurationChanged");
    }

    @NotNull
    public final String getResult() {
        if (this.isEnabled) {
            return CollectionsKt.joinToString$default((Iterable)this.events, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        Object[] objectArray = new Object[]{ENABLED_KEY};
        return CppDiagnosticsBundle.message("cpp.diagnostics.was.not.logged.0", objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CdWorkspaceEvents$Companion;", "", "<init>", "()V", "ENABLED_KEY", "", "intellij.clion.diagnostics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

