/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramSelectionModePresentationModelImpl
extends DiagramPresentationModelImpl {
    protected boolean myIsSelectionModeEnabled;
    @Nullable
    protected DiagramLayoutSnapshot myLayoutBeforeModeWasActivated;

    public DiagramSelectionModePresentationModelImpl(@NotNull Graph2D graph, @NotNull Project project, @NotNull DiagramProvider provider) {
        if (graph == null) {
            DiagramSelectionModePresentationModelImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DiagramSelectionModePresentationModelImpl.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DiagramSelectionModePresentationModelImpl.$$$reportNull$$$0(2);
        }
        super(graph, project, provider);
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){
            private boolean myDataModelUpdateScheduled = false;

            public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.isNodeSelection() && !this.myDataModelUpdateScheduled) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        DiagramSelectionModePresentationModelImpl.this.updateDataPresentation();
                        this.myDataModelUpdateScheduled = false;
                    });
                    this.myDataModelUpdateScheduled = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/presentation/DiagramSelectionModePresentationModelImpl$1", "onGraph2DSelectionEvent"));
            }
        });
    }

    protected void callSelectionModeCallbacksIfNeeded(boolean expectedState) {
        if (this.myIsSelectionModeEnabled != expectedState) {
            this.myIsSelectionModeEnabled = expectedState;
            this.onSelectionModeSwitch(expectedState);
        }
    }

    protected void onSelectionModeSwitch(boolean state) {
        if (state) {
            this.setInitialLayout();
        } else {
            this.restoreInitialLayout();
        }
    }

    protected void setInitialLayout() {
        this.myLayoutBeforeModeWasActivated = DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(this.getBuilder());
    }

    protected void restoreInitialLayout() {
        Objects.requireNonNull(this.myLayoutBeforeModeWasActivated).restore(this.getBuilder());
    }

    protected void updateDataPresentation() {
        DiagramBuilder builder = this.getBuilder();
        Graph2D graph = builder.getGraph();
        DiagramDataModel<?> dataModel = builder.getDataModel();
        if (CommonDiagramExtras.isSelectionMode(builder) || CommonDiagramExtras.isPathToRootMode(builder)) {
            this.callSelectionModeCallbacksIfNeeded(true);
            DiagramSelectionModePresentationModelImpl.updateData(dataModel);
            if (graph.isSelectionEmpty()) {
                builder.queryUpdate().withDataReload().withPresentationUpdate().run();
                this.restoreInitialLayout();
            } else {
                builder.queryUpdate().withDataReload().withPresentationUpdate().withRelayout().run();
                builder.getGraphBuilder().fitContent(false);
            }
        } else {
            this.callSelectionModeCallbacksIfNeeded(false);
        }
    }

    protected static void updateData(@NotNull DiagramDataModel dataModel) {
        if (dataModel == null) {
            DiagramSelectionModePresentationModelImpl.$$$reportNull$$$0(3);
        }
        dataModel.refreshDataModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/presentation/DiagramSelectionModePresentationModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

