/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.connection.DockerConnectionConfigurator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerCliPresentationUtil;
import com.intellij.docker.remote.DockerCliTextField;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.ui.components.DockerComboWithAutoDetect;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StatusPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelperImpl;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerSettingsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.ui.MiscKt;
import com.jetbrains.cidr.cpp.toolchains.ui.ToolchainPanel;
import com.jetbrains.cidr.cpp.ui.UIUtilKt;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DockerCredentialsComponent
implements DockerSettingsConfigurable {
    private final ToolchainPanel myMainPanel;
    private final DockerComboWithAutoDetect myDockerServerCombo;
    private final SimpleColoredComponent myStatusField;
    private final JComboBox<String> myDockerImageCombo;
    @Nullable
    private Runnable myStateChangeListener;
    private final DockerContainerSettings myContainerSettings;
    @Nullable
    private HostData myHostData;
    private final DockerCliTextField myCliField;

    DockerCredentialsComponent(@NotNull ToolchainPanel mainPanel, @NotNull GridBag bag) {
        Application application;
        if (mainPanel == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(0);
        }
        if (bag == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(1);
        }
        this.myStatusField = MiscKt.createStatusField();
        this.myDockerImageCombo = new ComboBox();
        this.myCliField = new DockerCliTextField(){

            @NotNull
            protected Icon getDefaultIcon() {
                Icon icon = AllIcons.General.Gear;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            protected Icon getHoveredIcon() {
                Icon icon = AllIcons.General.GearHover;
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHoveredIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.myMainPanel = mainPanel;
        int nextTopInset = OSType.getCurrent() == OSType.WIN ? 12 : -1;
        JLabel dockerLabel = new JLabel(DockerBundle.message((String)"DockerCredentialsEditor.server.text", (Object[])new Object[0]));
        mainPanel.add((Component)dockerLabel, (Object)bag.nextLine().next().insetTop(nextTopInset));
        this.myDockerServerCombo = new DockerComboWithAutoDetect(server -> DockerCredentialsComponent.isDockerServerSupported(server));
        Disposer.register((Disposable)mainPanel, (Disposable)this.myDockerServerCombo);
        this.myDockerServerCombo.getButton().setIcon(AllIcons.General.GearPlain);
        mainPanel.add((Component)this.myDockerServerCombo, (Object)bag.next().coverLine().insetTop(nextTopInset));
        this.hideStatusPanel();
        mainPanel.add((Component)this.myStatusField, (Object)bag.nextLine().next().next().insets(0, -1, -1, -1));
        JLabel imageLabel = new JLabel(DockerBundle.message((String)"DockerTargetConfigurable.image.row.label", (Object[])new Object[0]));
        mainPanel.add((Component)imageLabel, (Object)bag.nextLine().next().insetTop(nextTopInset));
        mainPanel.add(this.myDockerImageCombo, (Object)bag.next().coverLine().insetTop(nextTopInset));
        this.myDockerServerCombo.addChangeListener(e -> {
            this.updateStatusPanel(this.myDockerServerCombo.getSelectedItem());
            this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer());
            this.notifyStateChanged();
        });
        this.myDockerServerCombo.getComboBox().addItemListener(e -> {
            this.updateStatusPanel(this.myDockerServerCombo.getSelectedItem());
            this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer());
            this.notifyStateChanged();
        });
        this.myDockerImageCombo.addItemListener(e -> this.notifyStateChanged());
        RemoteServer initItem = (RemoteServer)ContainerUtil.getFirstItem(DockerCredentialsComponent.getSupportedServers(RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance())));
        if (initItem != null) {
            this.myDockerServerCombo.selectServerInCombo(initItem.getName());
        }
        if ((application = ApplicationManager.getApplication()) != null) {
            application.getMessageBus().connect((Disposable)mainPanel).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DockerCredentialsComponent.this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)DockerCredentialsComponent.this.myDockerServerCombo.getSelectedServer());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent$2", "applicationActivated"));
                }
            });
        }
        this.myCliField.setEditable(false);
        this.myContainerSettings = DockerContainerSettings.defaultSettings((int)2);
        JLabel settingsLabel = new JLabel(DockerBundle.message((String)"DockerContainer.settings", (Object[])new Object[0]));
        SshConfig sshConfig = DockerCredentialsComponent.getSshConfig(this.getSelectedCredentialsHolder());
        this.myHostData = sshConfig == null ? null : new HostData(sshConfig);
        mainPanel.add((Component)settingsLabel, (Object)bag.nextLine().next().insetTop(nextTopInset));
        mainPanel.add((Component)this.myCliField, (Object)bag.next().coverLine().insetTop(nextTopInset));
        this.setCliOptionsText();
        this.myCliField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCredentialsComponent.this.showContainerSettingsEditor();
            }
        });
        boolean isOptionsEnabled = CidrDockerUtil.isContainerOptionsEnabled();
        settingsLabel.setVisible(isOptionsEnabled);
        this.myCliField.setVisible(isOptionsEnabled);
    }

    private void showContainerSettingsEditor() {
        RemoteServer server = this.myDockerServerCombo.getSelectedServer();
        DockerInterpreterContainerSettingsEditorDialog dialog = new DockerInterpreterContainerSettingsEditorDialog(server, this.myContainerSettings);
        if (dialog.showAndGet()) {
            this.setCliOptionsText();
        }
    }

    private void setCliOptionsText() {
        List options = DockerCliPresentationUtil.toCliPresentationOptions((DockerContainerSettings)this.myContainerSettings);
        this.myCliField.setText(StringUtil.join((Collection)options, (String)" "));
        this.myCliField.setSplittedText(options);
    }

    public void reset(@Nullable SettingsHandler settings) {
        if (settings != null) {
            this.resetInternal(DockerHelperImpl.check(settings));
            return;
        }
        if (this.myDockerServerCombo.getSelectedServer() == null) {
            this.myDockerServerCombo.selectServerInCombo(null);
        }
    }

    private void resetInternal(@NotNull DockerHelperImpl.CidrDockerSettingsHandler handler) {
        if (handler == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(2);
        }
        DockerCredentialsHolder credentials = handler.getDockerCredentials();
        this.myDockerServerCombo.selectServerInCombo(credentials.getAccountName());
        this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer(), StringUtil.nullize((String)credentials.getImageName()));
        DockerContainerSettings settings = handler.getContainerSettings();
        if (settings != null) {
            settings.copyTo(this.myContainerSettings);
        }
        this.myHostData = handler.getHostData();
        this.setCliOptionsText();
    }

    public boolean isModified(@NotNull SettingsHandler settings) {
        if (settings == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(3);
        }
        return !Objects.equals(this.getSelectedSettings(), settings);
    }

    @NotNull
    private SettingsHandler getSelectedSettings() {
        HostData data;
        DockerCredentialsHolder result = this.getSelectedCredentialsHolder();
        SshConfig sshConfig = DockerCredentialsComponent.getSshConfig(result);
        if (sshConfig == null) {
            data = null;
        } else {
            data = this.myHostData != null ? this.myHostData.update(sshConfig) : new HostData(sshConfig);
            this.myHostData = data;
        }
        return new DockerHelperImpl.CidrDockerSettingsHandler(result, this.myContainerSettings, data);
    }

    @NotNull
    private DockerCredentialsHolder getSelectedCredentialsHolder() {
        DockerComboWithAutoDetect.DockerServerItem server = this.myDockerServerCombo.getSelectedItem();
        String serverName = server == null ? null : server.getServerName();
        String imageName = StringUtil.notNullize((String)((String)this.myDockerImageCombo.getSelectedItem()));
        return new DockerCredentialsHolder(serverName, imageName, null, null);
    }

    public void apply(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CPPToolchains.Toolchain toolchain, @NotNull String toolchainName, boolean save) {
        if (toolchainName == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(4);
        }
        if (toolchain == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(5);
        }
        DockerHelperImpl.CidrDockerSettingsHandler settings = (DockerHelperImpl.CidrDockerSettingsHandler)this.getSelectedSettings();
        HostData data = HostData.updateHostData((HostData)settings.getHostData(), (HostData)this.myHostData, (String)toolchainName, (boolean)save);
        if (save) {
            this.myHostData = data;
        }
        toolchain.setDockerSettingsHandler((SettingsHandler)new DockerHelperImpl.CidrDockerSettingsHandler(settings.getDockerCredentials(), settings.getContainerSettings(), data));
    }

    public void setStateChangeListener(@Nullable Runnable listener) {
        this.myStateChangeListener = listener;
    }

    @Nullable
    private static SshConfig getSshConfig(@NotNull DockerCredentialsHolder holder) {
        String sshConfigId;
        Map data;
        String accountName;
        if (holder == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(6);
        }
        if ((accountName = holder.getAccountName()) == null) {
            return null;
        }
        RemoteServer server = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (server != null && CidrDockerUtil.isDockerOverSSH(((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId()) && (data = ((DockerCloudConfiguration)server.getConfiguration()).getContributedData()) != null && (sshConfigId = (String)data.get("DockerSshConnectionConfigurator.SshConfigId")) != null) {
            return SshConfigManager.getInstance(null).findConfigById(sshConfigId);
        }
        return null;
    }

    private void notifyStateChanged() {
        Runnable listener = this.myStateChangeListener;
        if (listener != null) {
            listener.run();
        }
    }

    private void updateDockerImagesCombo(@Nullable RemoteServer<DockerCloudConfiguration> server) {
        this.updateDockerImagesCombo(server, null);
    }

    private void updateDockerImagesCombo(@Nullable RemoteServer<DockerCloudConfiguration> server, @Nullable @NlsSafe String imageToBeSelected) {
        if (server == null) {
            return;
        }
        if (imageToBeSelected != null) {
            ComboBoxModel<String> model = this.myDockerImageCombo.getModel();
            if (model == null || model.getSize() == 0) {
                this.myDockerImageCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(new ArrayList<String>(Collections.singletonList(imageToBeSelected))));
            }
            this.myDockerImageCombo.setSelectedItem(imageToBeSelected);
        }
        StatusPanel.Action listImagesAction = new StatusPanel().progress(DockerBundle.message((String)"DockerCredentialsEditor.listing.docker.images", (Object[])new Object[0]));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List images = DockerUtil.getNotTemplateImages((DockerCloudConfiguration)((DockerCloudConfiguration)server.getConfiguration()));
                ArrayList<String> collectedImages = new ArrayList<String>();
                for (String[] repoTags : images) {
                    collectedImages.addAll(Arrays.asList(repoTags));
                }
                listImagesAction.done();
                CidrDockerUtil.LOG.debug("Docker images collected: " + String.valueOf(collectedImages));
                UIUtil.invokeLaterIfNeeded(() -> {
                    CidrDockerUtil.LOG.debug("Populating Docker images combo box: " + String.valueOf(collectedImages));
                    @NlsSafe String imageName = imageToBeSelected != null ? imageToBeSelected : (String)this.myDockerImageCombo.getSelectedItem();
                    this.myDockerImageCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(collectedImages));
                    if (imageName != null) {
                        this.myDockerImageCombo.setSelectedItem(imageName);
                    }
                });
            }
            catch (ServerRuntimeException e) {
                listImagesAction.failed(e.getMessage());
            }
            finally {
                UIUtil.invokeLaterIfNeeded(() -> this.myMainPanel.markInitialized());
            }
        });
    }

    private void updateStatusPanel(@Nullable DockerComboWithAutoDetect.DockerServerItem selectedItem) {
        String serverName;
        String string = serverName = selectedItem == null ? null : selectedItem.getServerName();
        if (!DockerCredentialsComponent.isDockerServerSupported(serverName)) {
            this.showServerIsNotSupportedMessage();
        } else {
            this.hideStatusPanel();
        }
    }

    private void showServerIsNotSupportedMessage() {
        this.myStatusField.clear();
        this.myStatusField.setVisible(true);
        this.myStatusField.setIcon(UIUtilKt.getERROR_ICON());
        this.myStatusField.append(CidrDockerBundle.message("docker.message.server.not.supported", new Object[0]), CPPToolchainsUIUtils.getERROR_TEXT_ATTRIBUTES());
    }

    private void hideStatusPanel() {
        this.myStatusField.setVisible(false);
    }

    private static @Unmodifiable @NotNull List<RemoteServer<DockerCloudConfiguration>> getSupportedServers(@NotNull List<RemoteServer<DockerCloudConfiguration>> servers) {
        if (servers == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.filter(servers, s -> DockerCredentialsComponent.isDockerServerSupported(s));
        if (list == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean isDockerServerSupported(@Nullable String serverName) {
        if (serverName == null) {
            return false;
        }
        RemoteServer server = RemoteServersManager.getInstance().findByName(serverName, (ServerType)DockerCloudType.getInstance());
        return server != null && DockerCredentialsComponent.isDockerServerSupported(server);
    }

    private static boolean isDockerServerSupported(@NotNull RemoteServer<?> server) {
        ServerConfiguration configuration;
        if (server == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(9);
        }
        if ((configuration = server.getConfiguration()) instanceof DockerCloudConfiguration) {
            DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)configuration;
            String configuratorId = dockerCloudConfiguration.getCustomConfiguratorId();
            return DockerCloudConfiguration.hasLocalConnectionConfig((DockerCloudConfiguration)dockerCloudConfiguration) || DockerConnectionConfigurator.isWsl((String)configuratorId) || DockerCredentialsComponent.isDockerOverSSHServer(server) && Registry.is((String)"clion.docker.over.ssh");
        }
        return false;
    }

    private static boolean isDockerOverSSHServer(@NotNull RemoteServer<?> server) {
        ServerConfiguration configuration;
        if (server == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(10);
        }
        if ((configuration = server.getConfiguration()) instanceof DockerCloudConfiguration) {
            DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)configuration;
            String configuratorId = dockerCloudConfiguration.getCustomConfiguratorId();
            return CidrDockerUtil.isDockerOverSSH(configuratorId);
        }
        return false;
    }

    @Nullable
    public Supplier<String> getImageArchSupplier() {
        Object image = this.myDockerImageCombo.getSelectedItem();
        if (image == null) {
            return null;
        }
        RemoteServer server = this.myDockerServerCombo.getSelectedServer();
        if (server == null) {
            return null;
        }
        return () -> {
            try {
                return DockerUtil.getImageArch((DockerCloudConfiguration)((DockerCloudConfiguration)server.getConfiguration()), (String)image.toString());
            }
            catch (ServerRuntimeException e) {
                return null;
            }
        };
    }

    public boolean isSshServerSelected() {
        RemoteServer selectedServer = this.myDockerServerCombo.getSelectedServer();
        if (selectedServer == null) {
            return false;
        }
        return DockerCredentialsComponent.isDockerOverSSHServer(selectedServer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSshConfig";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedServers";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDockerServerSupported";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDockerOverSSHServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

