/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrTranslateCodeActionKt;
import com.intellij.cidr.translateCode.CidrTranslatedCodeBlock;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u0017J\u001e\u00102\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u00101\u001a\u00020\u0017J\u001e\u00103\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u00101\u001a\u00020\u0017J\u0018\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002000\u001305J\u0010\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0017H\u0002J\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(\u00a8\u0006;"}, d2={"Lcom/intellij/cidr/translateCode/TranslatedResultUiInfo;", "", "translationResult", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "srcEditor", "Lcom/intellij/openapi/editor/Editor;", "transEditor", "<init>", "(Lcom/intellij/cidr/translateCode/CidrTranslationResult;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;)V", "getTranslationResult", "()Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "getSrcEditor", "()Lcom/intellij/openapi/editor/Editor;", "getTransEditor", "srcLine0ToBlockId", "", "transLine0ToBlockId", "colors", "", "Lkotlin/Pair;", "Ljava/awt/Color;", "[Lkotlin/Pair;", "highlightedBlockId", "", "getHighlightedBlockId", "()I", "setHighlightedBlockId", "(I)V", "currentBlockSrcHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getCurrentBlockSrcHighlighters", "()Ljava/util/List;", "currentBlockTransHighlighters", "getCurrentBlockTransHighlighters", "mouseOverRightGutter", "", "getMouseOverRightGutter", "()Z", "setMouseOverRightGutter", "(Z)V", "mouseOverDivider", "getMouseOverDivider", "setMouseOverDivider", "blockIdForSrcLine0", "srcLine0", "blockIdForTransLine0", "blockById", "Lcom/intellij/cidr/translateCode/CidrTranslatedCodeBlock;", "blockId", "colorForBlock", "colorForCurrentBlock", "blocksWithId", "", "blockIdFromIndex", "blockIndex", "clearCurrentBlockHighlighters", "", "shouldDrawBlockConnection", "intellij.cidr.translateCode"})
@SourceDebugExtension(value={"SMAP\nCidrTranslateCodeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrTranslateCodeAction.kt\ncom/intellij/cidr/translateCode/TranslatedResultUiInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1235:1\n1563#2:1236\n1634#2,3:1237\n*S KotlinDebug\n*F\n+ 1 CidrTranslateCodeAction.kt\ncom/intellij/cidr/translateCode/TranslatedResultUiInfo\n*L\n482#1:1236\n482#1:1237,3\n*E\n"})
final class TranslatedResultUiInfo {
    @NotNull
    private final CidrTranslationResult translationResult;
    @NotNull
    private final Editor srcEditor;
    @NotNull
    private final Editor transEditor;
    @NotNull
    private final int[] srcLine0ToBlockId;
    @NotNull
    private final int[] transLine0ToBlockId;
    @NotNull
    private final Pair<Color, Color>[] colors;
    private int highlightedBlockId;
    @NotNull
    private final List<RangeHighlighter> currentBlockSrcHighlighters;
    @NotNull
    private final List<RangeHighlighter> currentBlockTransHighlighters;
    private boolean mouseOverRightGutter;
    private boolean mouseOverDivider;

    public TranslatedResultUiInfo(@NotNull CidrTranslationResult translationResult, @NotNull Editor srcEditor, @NotNull Editor transEditor) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        Intrinsics.checkNotNullParameter((Object)srcEditor, (String)"srcEditor");
        Intrinsics.checkNotNullParameter((Object)transEditor, (String)"transEditor");
        this.translationResult = translationResult;
        this.srcEditor = srcEditor;
        this.transEditor = transEditor;
        this.currentBlockSrcHighlighters = new ArrayList();
        this.currentBlockTransHighlighters = new ArrayList();
        int maxSrc0Line = this.srcEditor.getDocument().getLineCount();
        int maxTrans0Line = this.transEditor.getDocument().getLineCount();
        this.srcLine0ToBlockId = new int[maxSrc0Line + 1];
        this.transLine0ToBlockId = new int[maxTrans0Line + 1];
        IntRange srcLine0Range = RangesKt.until((int)0, (int)maxSrc0Line);
        IntRange transLine0Range = RangesKt.until((int)0, (int)maxTrans0Line);
        for (Pair<Integer, CidrTranslatedCodeBlock> pair : this.blocksWithId()) {
            int blockId = ((Number)pair.component1()).intValue();
            CidrTranslatedCodeBlock block = (CidrTranslatedCodeBlock)pair.component2();
            int n = block.getSrcEndLine();
            for (int srcLine0 = block.getSrcStartLine(); srcLine0 < n; ++srcLine0) {
                int n2 = srcLine0Range.getFirst();
                boolean bl = srcLine0 <= srcLine0Range.getLast() ? n2 <= srcLine0 : false;
                if (!bl) continue;
                this.srcLine0ToBlockId[srcLine0] = blockId;
            }
            for (IntRange transRange : block.getTranslatedRanges()) {
                int n3 = transRange.getLast();
                for (int transLine0 = transRange.getFirst(); transLine0 < n3; ++transLine0) {
                    int n4 = transLine0Range.getFirst();
                    boolean bl = transLine0 <= transLine0Range.getLast() ? n4 <= transLine0 : false;
                    if (!bl) continue;
                    this.transLine0ToBlockId[transLine0] = blockId;
                }
            }
        }
        EditorColorsScheme editorColorsScheme = this.srcEditor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        this.colors = CidrTranslateCodeActionKt.getColors(editorColorsScheme);
    }

    @NotNull
    public final CidrTranslationResult getTranslationResult() {
        return this.translationResult;
    }

    @NotNull
    public final Editor getSrcEditor() {
        return this.srcEditor;
    }

    @NotNull
    public final Editor getTransEditor() {
        return this.transEditor;
    }

    public final int getHighlightedBlockId() {
        return this.highlightedBlockId;
    }

    public final void setHighlightedBlockId(int n) {
        this.highlightedBlockId = n;
    }

    @NotNull
    public final List<RangeHighlighter> getCurrentBlockSrcHighlighters() {
        return this.currentBlockSrcHighlighters;
    }

    @NotNull
    public final List<RangeHighlighter> getCurrentBlockTransHighlighters() {
        return this.currentBlockTransHighlighters;
    }

    public final boolean getMouseOverRightGutter() {
        return this.mouseOverRightGutter;
    }

    public final void setMouseOverRightGutter(boolean bl) {
        this.mouseOverRightGutter = bl;
    }

    public final boolean getMouseOverDivider() {
        return this.mouseOverDivider;
    }

    public final void setMouseOverDivider(boolean bl) {
        this.mouseOverDivider = bl;
    }

    public final int blockIdForSrcLine0(int srcLine0) {
        boolean bl = 0 <= srcLine0 ? srcLine0 < this.srcLine0ToBlockId.length : false;
        if (bl) {
            return this.srcLine0ToBlockId[srcLine0];
        }
        return 0;
    }

    public final int blockIdForTransLine0(int srcLine0) {
        boolean bl = 0 <= srcLine0 ? srcLine0 < this.transLine0ToBlockId.length : false;
        if (bl) {
            return this.transLine0ToBlockId[srcLine0];
        }
        return 0;
    }

    @Nullable
    public final CidrTranslatedCodeBlock blockById(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return this.translationResult.getBlocks().get(blockId - 1);
    }

    @NotNull
    public final Pair<Color, Color> colorForBlock(int blockId) {
        if (blockId == 0) {
            return TuplesKt.to(null, null);
        }
        return this.colors[blockId % this.colors.length];
    }

    @NotNull
    public final Pair<Color, Color> colorForCurrentBlock(int blockId) {
        if (blockId == 0) {
            return TuplesKt.to(null, null);
        }
        return TuplesKt.to((Object)this.colors[blockId % this.colors.length].getFirst(), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<Pair<Integer, CidrTranslatedCodeBlock>> blocksWithId() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)this.translationResult.getBlocks());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            CidrTranslatedCodeBlock block = (CidrTranslatedCodeBlock)indexedValue.component2();
            collection.add(TuplesKt.to((Object)this.blockIdFromIndex(index), (Object)block));
        }
        return (List)destination$iv$iv;
    }

    private final int blockIdFromIndex(int blockIndex) {
        return blockIndex + 1;
    }

    public final void clearCurrentBlockHighlighters() {
        MarkupModel markupModel = this.srcEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel srcMarkup = markupModel;
        for (RangeHighlighter h : this.currentBlockSrcHighlighters) {
            srcMarkup.removeHighlighter(h);
        }
        this.currentBlockSrcHighlighters.clear();
        MarkupModel markupModel2 = this.transEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel2, (String)"getMarkupModel(...)");
        MarkupModel transMarkup = markupModel2;
        for (RangeHighlighter h : this.currentBlockTransHighlighters) {
            transMarkup.removeHighlighter(h);
        }
        this.currentBlockTransHighlighters.clear();
    }

    public final boolean shouldDrawBlockConnection() {
        return Registry.Companion.is("cidr.translated.code.show.block.connection.on.hover") || this.mouseOverDivider || this.mouseOverRightGutter;
    }
}

