/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.CheckBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class ReferenceFilter
extends FilterAction {
    ReferenceFilter() {
        super(SSRBundle.messagePointer("reference.filter.name", new Object[0]));
    }

    @Override
    @NotNull
    public String getShortText(NamedScriptableDefinition variable) {
        if (!(variable instanceof MatchVariableConstraint)) {
            return "";
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        String ref = constraint.getReferenceConstraint();
        if (StringUtil.isEmpty((String)ref)) {
            return "";
        }
        String text = StringUtil.unquoteString((String)ref);
        String string = SSRBundle.message("reference.target.tooltip.message", constraint.isInvertReference() ? 1 : 0, text);
        if (string == null) {
            ReferenceFilter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean hasFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        return variable != null && !StringUtil.isEmpty((String)variable.getReferenceConstraint());
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        variable.setReferenceConstraintName("");
        variable.setReferenceConstraint("");
        variable.setInvertReference(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        return this.myTable.getVariable() instanceof MatchVariableConstraint && this.isApplicableConstraint("REFERENCE", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = this.myTable.getMatchVariable();
        if (constraint == null) {
            return;
        }
        Configuration referencedConfiguration = ConfigurationManager.getInstance(this.myTable.getProject()).findConfigurationByName(constraint.getReferenceConstraint());
        if (referencedConfiguration != null) {
            component.append(SSRBundle.message("reference.0.label", (constraint.isInvertReference() ? "!" : "") + referencedConfiguration.getName()));
        }
    }

    public FilterEditor<MatchVariableConstraint> getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getMatchVariable(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            @NotNull
            private final ComboBox<Configuration> myComboBox;
            private final SimpleListCellRenderer<Configuration> renderer;
            private final ContextHelpLabel myHelpLabel;
            private final CheckBox myCheckBox;
            private final Component myGlue;
            public boolean inverseTemplate;
            {
                this.myLabel = new JLabel(SSRBundle.message("reference.label", new Object[0]));
                this.myComboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(new ArrayList<Configuration>(ConfigurationManager.getInstance(ReferenceFilter.this.myTable.getProject()).getAllConfigurations())));
                this.renderer = new SimpleListCellRenderer<Configuration>(){

                    public void customize(@NotNull JList list, Configuration value, int index, boolean selected, boolean hasFocus) {
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.setIcon(value.getIcon());
                        this.setText(value.getName());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/filters/ReferenceFilter$1$1", "customize"));
                    }
                };
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("reference.filter.help.text", new Object[0]));
                this.myCheckBox = new CheckBox(SSRBundle.message("invert.filter", new Object[0]), (Object)this, "inverseTemplate");
                this.myGlue = Box.createGlue();
                this.inverseTemplate = ((MatchVariableConstraint)this.myConstraint).isInvertReference();
            }

            @Override
            protected void layoutComponents() {
                this.myComboBox.setRenderer(this.renderer);
                this.myComboBox.setPreferredSize(new Dimension(160, 28));
                this.myComboBox.setSwingPopup(false);
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)this.myComboBox)).addGroup(layout.createSequentialGroup().addComponent((Component)this.myCheckBox).addComponent(this.myGlue).addComponent((Component)this.myHelpLabel)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)this.myComboBox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.myCheckBox).addComponent(this.myGlue).addComponent((Component)this.myHelpLabel)));
            }

            @Override
            protected void loadValues() {
                this.inverseTemplate = ((MatchVariableConstraint)this.myConstraint).isInvertReference();
                this.myCheckBox.setSelected(this.inverseTemplate);
                Configuration referencedTemplate = ConfigurationManager.getInstance(ReferenceFilter.this.myTable.getProject()).findConfigurationByName(((MatchVariableConstraint)this.myConstraint).getReferenceConstraint());
                if (referencedTemplate != null) {
                    this.myComboBox.setSelectedItem((Object)referencedTemplate);
                }
            }

            @Override
            protected void saveValues() {
                Configuration item = (Configuration)this.myComboBox.getItem();
                if (item != null) {
                    ((MatchVariableConstraint)this.myConstraint).setReferenceConstraint(item.getRefName());
                    ((MatchVariableConstraint)this.myConstraint).setReferenceConstraintName(item.getName());
                    ((MatchVariableConstraint)this.myConstraint).setInvertReference(this.inverseTemplate);
                }
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myComboBox;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myComboBox, this.myCheckBox};
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/filters/ReferenceFilter", "getShortText"));
    }
}

