/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangFormat;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.cidr.radler.clangFormat.RadClangFormatHelper;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/radler/clangFormat/RadClangFormatHelperImpl;", "Lcom/jetbrains/cidr/radler/clangFormat/RadClangFormatHelper;", "<init>", "()V", "isClangFormatEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "createClangFormatConfigurationIfNeeded", "", "intellij.rider.plugins.clion.radler.clangFormat"})
public final class RadClangFormatHelperImpl
implements RadClangFormatHelper {
    public boolean isClangFormatEnabled(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyle.getProjectOrDefaultSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getProjectOrDefaultSettings(...)");
        CodeStyleSettings codeStyle = codeStyleSettings;
        CustomCodeStyleSettings customCodeStyleSettings = codeStyle.getCustomSettings(ClangFormatSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        ClangFormatSettings cfSettings = (ClangFormatSettings)customCodeStyleSettings;
        return cfSettings.ENABLED;
    }

    public void createClangFormatConfigurationIfNeeded(@NotNull Project project) {
        block1: {
            ExternalFormatProcessor extFormatProcessor;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.isClangFormatEnabled(project)) break block1;
            Optional optional = ExternalFormatProcessor.findExternalFormatter((String)"ClangFormat");
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findExternalFormatter(...)");
            ExternalFormatProcessor externalFormatProcessor = extFormatProcessor = (ExternalFormatProcessor)OptionalsKt.getOrNull((Optional)optional);
            if (externalFormatProcessor != null) {
                externalFormatProcessor.createConfiguration(project);
            }
        }
    }
}

