/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.workspace;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.external.system.ExternalBundle;
import com.jetbrains.cidr.external.system.ExternalLog;
import com.jetbrains.cidr.external.system.model.ExternalFileConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.model.ExternalResolveConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationImpl;
import com.jetbrains.cidr.external.system.ui.CompilerInfoNotificationBuilder;
import com.jetbrains.cidr.external.system.ui.CompilerInfoViewManager;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspaceListener;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspaceScope;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationUtil;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.ReloadableWorkspace;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000 Q2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005:\u0002PQB\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H&J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0014J\u0010\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0007J \u0010'\u001a\u00020\u001b2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fJ(\u0010)\u001a\u00020\u001b2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fH\u0082@\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0003J\b\u0010.\u001a\u00020\u0013H'J\"\u0010/\u001a\u00020-2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fH\u0002J'\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u001b04\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010 H\u0014J\u0018\u0010:\u001a\b\u0012\u0004\u0012\u00020 0;2\b\u00109\u001a\u0004\u0018\u00010 H\u0002J\n\u0010<\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010=\u001a\u00020\u001bH\u0016J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u0004H\u0016J\b\u0010@\u001a\u00020\u0017H\u0014J\n\u0010A\u001a\u0004\u0018\u00010BH\u0002J.\u0010C\u001a\u00020\u001b2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020F0E2\b\u0010G\u001a\u0004\u0018\u00010B2\u0006\u0010H\u001a\u00020\u0017H\u0002J$\u0010I\u001a\u00020\u001b2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020F0E2\u0006\u0010H\u001a\u00020\u0017H\u0002J.\u0010J\u001a\u00020\u001b2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020F0E2\b\u0010G\u001a\u0004\u0018\u00010B2\u0006\u0010H\u001a\u00020\u0017H\u0002J.\u0010K\u001a\b\u0012\u0004\u0012\u00020L0;2\b\b\u0001\u0010M\u001a\u00020\u00132\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0;2\u0006\u0010N\u001a\u00020OH\u0002R&\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/jetbrains/cidr/project/workspace/ReloadableWorkspace;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myReloadsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "createEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "toolchainNameOrNullForDefault", "", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "projectOpened", "", "dispose", "initializeAndStart", "initialize", "openProjectDir", "Ljava/io/File;", "unload", "projectClosing", "scheduleReload", "selectProjectDir", "newProjectDir", "Ljava/nio/file/Path;", "update", "modules", "doUpdate", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commitOCModel", "ocModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "getClientKey", "doUpdateOCModel", "updateResolveConfiguration", "resolveConfiguration", "Lcom/jetbrains/cidr/external/system/model/ExternalResolveConfiguration;", "block", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$ExternalResolveConfigurationModifiableModel;", "Lkotlin/ExtensionFunctionType;", "collectRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "contentRoot", "collectRoots", "", "getState", "noStateLoaded", "loadState", "element", "shouldReportMessages", "reportStartEvent", "Ljava/util/UUID;", "reportMessages", "messages", "Lcom/intellij/util/containers/MultiMap;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message;", "startEventId", "isCancelled", "reportMessagesAsNotification", "reportMessagesInToolWindow", "reportConfigInToolWindow", "Lcom/intellij/build/events/BuildEvent;", "configName", "parentId", "", "ExternalResolveConfigurationModifiableModel", "Companion", "intellij.cidr.externalSystem"})
@SourceDebugExtension(value={"SMAP\nExternalWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,524:1\n30#2,2:525\n1#3:527\n1869#4,2:528\n774#4:530\n865#4,2:531\n774#4:533\n865#4,2:534\n1563#4:536\n1634#4,3:537\n61#5,5:540\n1321#6,2:545\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace\n*L\n89#1:525,2\n397#1:528,2\n467#1:530\n467#1:531,2\n468#1:533\n468#1:534,2\n472#1:536\n472#1:537,3\n131#1:540,5\n453#1:545,2\n*E\n"})
public abstract class ExternalWorkspace
extends CidrWorkspace
implements ReloadableWorkspace,
PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<Collection<Pair<ModuleData, ExternalModule>>> myReloadsFlow;

    public ExternalWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myReloadsFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ExternalWorkspaceScope> serviceClass$iv = ExternalWorkspaceScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((ExternalWorkspaceScope)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            final /* synthetic */ ExternalWorkspace this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.myReloadsFlow), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>>, Continuation<? super Unit>, Object>(this.$project, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ExternalWorkspace this$0;
                            {
                                this.$project = $project;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Collection collection = (Collection)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        String string = ExternalBundle.message("external.project.reload.queue.title", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        this.label = 1;
                                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>>)it, null){
                                            int label;
                                            final /* synthetic */ ExternalWorkspace this$0;
                                            final /* synthetic */ Collection<Pair<ModuleData, ExternalModule>> $it;
                                            {
                                                this.this$0 = $receiver;
                                                this.$it = $it;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        Object object2 = this.this$0.doUpdate(this.$it, (Continuation<? super Unit>)((Continuation)this));
                                                        if (object2 != object) return Unit.INSTANCE;
                                                        return object;
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object2 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public abstract CidrToolEnvironment createEnvironment(@Nullable Project var1, @Nullable String var2, @NotNull EnvironmentProblems var3, boolean var4, @Nullable Runnable var5);

    public void projectOpened() {
        if (this.load(true)) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            v1 = CidrWorkspaceManager.Companion.getInstance(project).markLoaded((CidrWorkspace)this);
        } else {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            v1 = CidrWorkspaceManager.Companion.getInstance(project).markNotLoaded((CidrWorkspace)this);
        }
    }

    public void dispose() {
        this.unload(true);
    }

    protected boolean initializeAndStart() {
        return this.initialize(null);
    }

    public final boolean initialize(@Nullable File openProjectDir) {
        if (!super.initializeAndStart()) {
            return false;
        }
        if (!this.isLinked() && openProjectDir != null) {
            this.linkWithProject(openProjectDir.toPath(), true);
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        OCRootsSynchronizer.Companion.getInstance(project).installLegacyClasspathStorage("External");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        OCWorkspaceInitializationUtil.runWhenOrIfOCWorkspaceIsInitialized((Project)project2, (Disposable)this, () -> ExternalWorkspace.initialize$lambda$3(this));
        MessageBus messageBus = this.myProject.getMessageBus();
        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        Path path = this.getProjectPathOrNull();
        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).initialized(this, path != null ? path.toFile() : null);
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        CidrWorkspaceManager.Companion.getInstance(project3).markInitialized((CidrWorkspace)this);
        return true;
    }

    public boolean unload(boolean projectClosing) {
        boolean removed = super.unload(projectClosing);
        if (!removed) {
            return false;
        }
        this.myReloadsFlow.resetReplayCache();
        return true;
    }

    public void scheduleReload() {
        String string = ExternalSystemApiUtil.toCanonicalPath((String)String.valueOf(this.getProjectPathOrNull()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
        String path = string;
        ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(path);
    }

    @RequiresEdt
    public final void selectProjectDir(@NotNull Path newProjectDir) {
        Intrinsics.checkNotNullParameter((Object)newProjectDir, (String)"newProjectDir");
        this.linkWithProject(newProjectDir, true);
        if (!this.isInitialized()) {
            if (this.isLinked()) {
                StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ExternalWorkspace.selectProjectDir$lambda$4(this, newProjectDir));
            }
        } else {
            this.scheduleReload();
        }
    }

    public final void update(@NotNull Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        ActionsKt.runReadAction(() -> ExternalWorkspace.update$lambda$5(this));
        this.myReloadsFlow.tryEmit(modules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object doUpdate(Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doUpdate.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ExternalWorkspace this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ExternalWorkspace.access$doUpdate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.shouldLoadWorkspaceForProject()) {
                    return Unit.INSTANCE;
                }
                if (ApplicationKt.getApplication().isWriteAccessAllowed()) {
                    throw new AssertionError((Object)"Project generation should not be initiated from writeAction. Will cause a deadlock.");
                }
                v0 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                CidrWorkspaceManager.Companion.getInstance(v0).markLoading((CidrWorkspace)this);
                $continuation.L$0 = modules;
                $continuation.label = 1;
                v1 = com.intellij.openapi.application.CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doUpdate$lambda$6(), ()Lkotlin/Unit;)(), (Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = modules;
                $continuation.label = 2;
                v2 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doUpdate$lambda$7(com.jetbrains.cidr.external.system.workspace.ExternalWorkspace ), ()Lkotlin/Unit;)((ExternalWorkspace)this), (Continuation)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 3 sources

                firstModule = modules.isEmpty() != false ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)CollectionsKt.first((Iterable)modules));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)modules);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)firstModule);
                $continuation.label = 3;
                v3 = CoroutinesKt.coroutineToIndicator((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, doUpdate$lambda$8(com.jetbrains.cidr.external.system.workspace.ExternalWorkspace java.util.List com.intellij.openapi.progress.ProgressIndicator ), (Lcom/intellij/openapi/progress/ProgressIndicator;)Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;)((ExternalWorkspace)this, (List)firstModule), (Continuation)$continuation);
                ** if (v3 != var7_5) goto lbl49
lbl48:
                // 1 sources

                return var7_5;
lbl49:
                // 1 sources

                ** GOTO lbl57
            }
            case 3: {
                firstModule = (List)$continuation.L$1;
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl57:
                // 2 sources

                ocModel = (OCWorkspace.ModifiableModel)v3;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)modules);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)firstModule);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ocModel);
                $continuation.label = 4;
                v4 = com.intellij.openapi.application.CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doUpdate$lambda$9(com.jetbrains.cidr.external.system.workspace.ExternalWorkspace com.jetbrains.cidr.lang.workspace.OCWorkspace$ModifiableModel ), ()Lkotlin/Unit;)((ExternalWorkspace)this, (OCWorkspace.ModifiableModel)ocModel), (Continuation)$continuation);
                ** if (v4 != var7_5) goto lbl65
lbl64:
                // 1 sources

                return var7_5;
lbl65:
                // 1 sources

                ** GOTO lbl74
            }
            case 4: {
                ocModel = (OCWorkspace.ModifiableModel)$continuation.L$2;
                firstModule = (List)$continuation.L$1;
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl74:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)modules);
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 5;
                v5 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doUpdate$lambda$10(com.jetbrains.cidr.external.system.workspace.ExternalWorkspace ), ()Ljava/lang/Boolean;)((ExternalWorkspace)this), (Continuation)$continuation);
                if (v5 == var7_5) {
                    return var7_5;
                }
                break;
            }
            case 5: {
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
                break;
            }
        }
        catch (Throwable var3_7) {
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)modules);
            $continuation.L$1 = var3_7;
            $continuation.L$2 = null;
            $continuation.label = 6;
            v6 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doUpdate$lambda$10(com.jetbrains.cidr.external.system.workspace.ExternalWorkspace ), ()Ljava/lang/Boolean;)((ExternalWorkspace)this), (Continuation)$continuation);
            if (v6 == var7_5) {
                return var7_5;
            }
            ** GOTO lbl101
        }
        {
            case 6: {
                var3_8 = (Throwable)$continuation.L$1;
                modules = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl101:
                // 2 sources

                throw var3_8;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresWriteLock
    private final void commitOCModel(OCWorkspace.ModifiableModel ocModel) {
        ocModel.commit();
        this.updateContentRoots();
    }

    @NonNls
    @NotNull
    public abstract String getClientKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final OCWorkspace.ModifiableModel doUpdateOCModel(Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules) {
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        OCWorkspace ocWorkspace = oCWorkspace;
        OCWorkspace.ModifiableModel modifiableModel = ocWorkspace.getModifiableModel(this.getClientKey(), true);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel ocModel = modifiableModel;
        Disposer.register((Disposable)this, (Disposable)((Disposable)ocModel));
        CompilerInfoCache compilerInfoCache = new CompilerInfoCache();
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        Intrinsics.checkNotNull((Object)progressIndicator);
        CompilerInfoCache.Session compilerInfoSession = compilerInfoCache.createSession(progressIndicator);
        MultiMap messages = new MultiMap();
        boolean cancelled = false;
        HashMap configIdToName = new HashMap();
        UUID startEventId = this.reportStartEvent();
        try {
            for (Pair<? extends ModuleData, ? extends ExternalModule> pair : modules) {
                ModuleData ideaModule = (ModuleData)pair.component1();
                ExternalModule cppModule = (ExternalModule)pair.component2();
                for (ExternalResolveConfiguration configuration : cppModule.getResolveConfigurations()) {
                    OCResolveConfiguration.ModifiableModel config;
                    OCVariant oCVariant;
                    ProgressManager.checkCanceled();
                    EnvironmentProblems environmentProblems = new EnvironmentProblems();
                    CidrToolEnvironment environment = this.createEnvironment(this.myProject, configuration.getToolchainName(), environmentProblems, false, null);
                    environmentProblems.throwAsExecutionException();
                    ExternalLog.INSTANCE.getLOG().assertTrue(environment != null);
                    String string = configuration.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    String configurationId = ExternalWorkspace.Companion.configurationId(string, modules.size() > 1 ? ideaModule.getId() : null);
                    ((Map)configIdToName).put(configurationId, configuration.getId());
                    OCWorkspace.ModifiableModel modifiableModel2 = ocModel;
                    String string2 = configurationId;
                    String string3 = configuration.getConfigName();
                    if (configuration.getVariant() != null) {
                        void it;
                        String string4 = string3;
                        String string5 = string2;
                        OCWorkspace.ModifiableModel modifiableModel3 = modifiableModel2;
                        boolean bl = false;
                        OCVariant oCVariant2 = new OCVariant((List)it);
                        modifiableModel2 = modifiableModel3;
                        string2 = string5;
                        string3 = string4;
                        oCVariant = oCVariant2;
                    } else {
                        oCVariant = null;
                    }
                    CidrToolEnvironment cidrToolEnvironment = environment;
                    Intrinsics.checkNotNull((Object)cidrToolEnvironment);
                    Intrinsics.checkNotNullExpressionValue((Object)modifiableModel2.addConfiguration(string2, string3, oCVariant, cidrToolEnvironment.getSupportedFileSeparators()), (String)"addConfiguration(...)");
                    for (ExternalLanguageConfiguration configLanguage : configuration.getLanguageConfigurations()) {
                        CidrCompilerSwitches cidrCompilerSwitches;
                        OCCompilerSettings.ModifiableModel modifiableModel4;
                        OCCompilerKind oCCompilerKind;
                        ProgressManager.checkCanceled();
                        if (configLanguage instanceof ExternalLanguageConfigurationImpl) {
                            ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl = (ExternalLanguageConfigurationImpl)configLanguage;
                            Project project = this.myProject;
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                            oCCompilerKind = externalLanguageConfigurationImpl.resolveCompiler(project, environment);
                        } else {
                            oCCompilerKind = configLanguage.getCompilerKind();
                        }
                        OCCompilerKind compilerKind = oCCompilerKind;
                        OCCompilerSettings.ModifiableModel $this$doUpdateOCModel_u24lambda_u2413 = modifiableModel4 = config.getLanguageCompilerSettings(configLanguage.getLanguageKind());
                        boolean bl = false;
                        $this$doUpdateOCModel_u24lambda_u2413.setCompiler(compilerKind, configLanguage.getCompilerExecutable(), configuration.getBuildWorkingDir());
                        if (configLanguage.getCompilerSwitches() != null) {
                            List<String> it;
                            boolean bl2 = false;
                            cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(it).build();
                        } else {
                            cidrCompilerSwitches = null;
                        }
                        CidrCompilerSwitches switches = cidrCompilerSwitches;
                        $this$doUpdateOCModel_u24lambda_u2413.setCompilerSwitches(switches);
                    }
                    for (ExternalFileConfiguration configSourceFile : configuration.getFileConfigurations()) {
                        CidrCompilerSwitches cidrCompilerSwitches;
                        ProgressManager.checkCanceled();
                        if (configSourceFile.getCompilerSwitches() != null) {
                            List<String> it;
                            boolean bl = false;
                            cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(it).build();
                        } else {
                            cidrCompilerSwitches = null;
                        }
                        CidrCompilerSwitches switches = cidrCompilerSwitches;
                        config.addSource(VfsUtil.fileToUrl((File)configSourceFile.getFile()), configSourceFile.getLanguageKind()).setCompilerSwitches(switches);
                    }
                    compilerInfoSession.schedule((Object)configuration.getId(), config, environment, ((Object)this.getProjectPath()).toString());
                }
            }
            compilerInfoSession.waitForAll(messages);
            ocModel.preCommit();
        }
        catch (Throwable ex) {
            if (ex instanceof ProcessCanceledException) {
                cancelled = true;
            }
            compilerInfoSession.dispose();
            Disposer.dispose((Disposable)((Disposable)ocModel));
            throw ex;
        }
        finally {
            this.reportMessages((MultiMap<String, CompilerInfoCache.Message>)messages, startEventId, cancelled);
        }
        return ocModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateResolveConfiguration(@NotNull ExternalResolveConfiguration resolveConfiguration, @NotNull Function1<? super ExternalResolveConfigurationModifiableModel, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)resolveConfiguration, (String)"resolveConfiguration");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OCWorkspace.ModifiableModel modifiableModel = OCWorkspace.getInstance((Project)this.myProject).getModifiableModel(this.getClientKey());
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel ocModel = modifiableModel;
        try {
            String string = resolveConfiguration.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String configurationId = ExternalWorkspace.Companion.configurationId(string, null);
            OCResolveConfiguration.ModifiableModel resolveConfigurationModel = ocModel.getConfigurationById(configurationId);
            if (resolveConfigurationModel == null) {
                ExternalLog.INSTANCE.getLOG().warn("Resolve configuration model '" + configurationId + "' not found - update failed", new Throwable());
                return;
            }
            if (this.getProject().isDisposed()) {
                return;
            }
            ExternalResolveConfigurationModifiableModel model = new ExternalResolveConfigurationModifiableModel(this, ocModel, resolveConfigurationModel);
            block.invoke((Object)model);
            ocModel.preCommit();
            ApplicationManager.getApplication().invokeAndWait(() -> ExternalWorkspace.updateResolveConfiguration$lambda$16(this, ocModel));
        }
        finally {
            Disposer.dispose((Disposable)((Disposable)ocModel));
        }
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        List list = OCWorkspace.getInstance((Project)this.myProject).getConfigurations(this.getClientKey());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
        List configurations = list;
        List list2 = this.collectExcludeRoots(contentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"collectExcludeRoots(...)");
        List excludedRoots = list2;
        OCRootsSynchronizer.RootsInfo rootsInfo = CidrWorkspace.createRootsInfo((List)configurations, this.collectRoots(contentRoot), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
        rootsInfo.additionalBuildDirs.addAll(excludedRoots);
        Intrinsics.checkNotNull((Object)rootsInfo);
        return rootsInfo;
    }

    private final List<File> collectRoots(File contentRoot) {
        Object[] objectArray = new File[2];
        objectArray[0] = contentRoot;
        Path path = this.getProjectPathOrNull();
        objectArray[1] = path != null ? path.toFile() : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Nullable
    public Element getState() {
        return this.getBaseState().createElement();
    }

    public void noStateLoaded() {
        super.noStateLoaded();
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.loadBaseState(CidrWorkspace.State.loadStateElement((Element)element));
    }

    protected boolean shouldReportMessages() {
        return true;
    }

    private final UUID reportStartEvent() {
        if (!this.shouldReportMessages()) {
            return null;
        }
        if (!Registry.Companion.get("compiler.info.show.tab").asBoolean()) {
            return null;
        }
        UUID taskId = UUID.randomUUID();
        DefaultBuildDescriptor descriptor = new DefaultBuildDescriptor((Object)taskId, ExternalBundle.message("collect.compiler.info.task.display.name", new Object[0]), ((Object)this.getProjectPath()).toString(), System.currentTimeMillis());
        StartBuildEventImpl startEvent = new StartBuildEventImpl((BuildDescriptor)descriptor, ExternalBundle.message("collect.compiler.info.task.display.name", new Object[0]));
        return (UUID)ActionsKt.runReadAction(() -> ExternalWorkspace.reportStartEvent$lambda$17(this, taskId, startEvent));
    }

    private final void reportMessages(MultiMap<String, CompilerInfoCache.Message> messages, UUID startEventId, boolean isCancelled) {
        if (ExternalLog.INSTANCE.getLOG().isDebugEnabled()) {
            if (isCancelled) {
                ExternalLog.INSTANCE.getLOG().debug(CidrWorkspaceBundle.message((String)"collect.compiler.info.cancelled.message", (Object[])new Object[0]));
            }
            Collection collection = messages.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv;
                boolean bl = false;
                Logger logger = ExternalLog.INSTANCE.getLOG();
                logger.debug((switch (WhenMappings.$EnumSwitchMapping$0[it.type.ordinal()]) {
                    case 1 -> "Error: ";
                    case 2 -> "Warning: ";
                    default -> throw new NoWhenBranchMatchedException();
                }) + it.text);
            }
        }
        if (!this.shouldReportMessages()) {
            return;
        }
        if (!Registry.Companion.get("compiler.info.show.tab").asBoolean()) {
            this.reportMessagesAsNotification(messages, isCancelled);
        } else {
            this.reportMessagesInToolWindow(messages, startEventId, isCancelled);
        }
    }

    private final void reportMessagesAsNotification(MultiMap<String, CompilerInfoCache.Message> messages, boolean isCancelled) {
        CompilerInfoNotificationBuilder compilerInfoNotificationBuilder = new CompilerInfoNotificationBuilder(messages, isCancelled);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        compilerInfoNotificationBuilder.notify(project);
    }

    private final void reportMessagesInToolWindow(MultiMap<String, CompilerInfoCache.Message> messages, UUID startEventId, boolean isCancelled) {
        Object v2;
        Object object;
        Sequence configEvents;
        block3: {
            if (startEventId == null) {
                return;
            }
            Set set = messages.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            configEvents = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), ExternalWorkspace::reportMessagesInToolWindow$lambda$19), arg_0 -> ExternalWorkspace.reportMessagesInToolWindow$lambda$20(this, startEventId, arg_0)));
            Collection collection = messages.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            object = collection;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                CompilerInfoCache.Message it = (CompilerInfoCache.Message)t;
                boolean bl = false;
                if (!(it.type == CompilerInfoCache.Message.Type.ERROR)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        boolean isSuccess = v2 == null;
        object = isCancelled ? CidrWorkspaceBundle.message((String)"collect.compiler.info.cancelled.message", (Object[])new Object[0]) : (isSuccess ? ExternalBundle.message("collect.compiler.info.task.finish.successful.message", new Object[0]) : CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]));
        Intrinsics.checkNotNull((Object)object);
        Object finishMessage = object;
        String string = CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String finishDescription = string;
        FinishBuildEventImpl finishEvent = new FinishBuildEventImpl((Object)startEventId, null, System.currentTimeMillis(), (String)finishMessage, isCancelled ? (EventResult)new SkippedResultImpl() : (isSuccess ? (EventResult)new SuccessResultImpl() : (EventResult)new FailureResultImpl(finishDescription, null)));
        ActionsKt.runReadAction(() -> ExternalWorkspace.reportMessagesInToolWindow$lambda$23(this, configEvents, startEventId, finishEvent));
        if (!messages.isEmpty() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(() -> ExternalWorkspace.reportMessagesInToolWindow$lambda$24(this), this.myProject.getDisposed());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<BuildEvent> reportConfigInToolWindow(@NlsSafe String configName, List<? extends CompilerInfoCache.Message> messages, Object parentId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv$iv;
            boolean bl = false;
            if (!(it.type == CompilerInfoCache.Message.Type.ERROR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = messages;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv$iv;
            boolean bl = false;
            if (!(it.type == CompilerInfoCache.Message.Type.WARNING)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List warnings = (List)destination$iv$iv2;
        ExternalLog.INSTANCE.getLOG().assertTrue(!((Collection)errors).isEmpty() || !((Collection)warnings).isEmpty());
        $this$filter$iv2 = CollectionsKt.plus((Collection)errors, (Iterable)warnings);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String details;
            void message;
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            boolean isError = message.type == CompilerInfoCache.Message.Type.ERROR;
            String string = isError ? CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]) : CidrWorkspaceBundle.message((String)"collect.compiler.info.warning.message", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String eventMessage = string;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.replace((String)message.text, (String)"\n", (String)"\n\t"), (String)"replace(...)");
            collection.add(new MessageEventImpl(parentId, isError ? MessageEvent.Kind.ERROR : MessageEvent.Kind.WARNING, configName, eventMessage, details));
        }
        return (List)destination$iv$iv2;
    }

    private static final Unit initialize$lambda$3$lambda$2$lambda$1(ExternalWorkspace this$0) {
        Logger $this$debug_u24default$iv = ExternalLog.INSTANCE.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("ExternalWorkspace initialization. Updating content roots", e$iv);
        }
        this$0.updateContentRoots();
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3$lambda$2(ExternalWorkspace this$0) {
        ActionsKt.runWriteAction(() -> ExternalWorkspace.initialize$lambda$3$lambda$2$lambda$1(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(ExternalWorkspace this$0) {
        ActionsKt.runInEdt$default(null, () -> ExternalWorkspace.initialize$lambda$3$lambda$2(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void selectProjectDir$lambda$4(ExternalWorkspace this$0, Path $newProjectDir) {
        this$0.initialize($newProjectDir.toFile());
    }

    private static final Unit update$lambda$5(ExternalWorkspace this$0) {
        if (this$0.myProject.isDisposed()) {
            return Unit.INSTANCE;
        }
        MessageBus messageBus = this$0.myProject.getMessageBus();
        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateScheduled(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit doUpdate$lambda$6() {
        FileDocumentManager.getInstance().saveAllDocuments();
        return Unit.INSTANCE;
    }

    private static final Unit doUpdate$lambda$7(ExternalWorkspace this$0) {
        MessageBus messageBus = this$0.myProject.getMessageBus();
        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateStarted(this$0);
        return Unit.INSTANCE;
    }

    private static final OCWorkspace.ModifiableModel doUpdate$lambda$8(ExternalWorkspace this$0, List $firstModule, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.doUpdateOCModel($firstModule);
    }

    private static final Unit doUpdate$lambda$9(ExternalWorkspace this$0, OCWorkspace.ModifiableModel $ocModel) {
        this$0.commitOCModel($ocModel);
        return Unit.INSTANCE;
    }

    private static final boolean doUpdate$lambda$10(ExternalWorkspace this$0) {
        MessageBus messageBus = this$0.myProject.getMessageBus();
        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateFinished(this$0);
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return CidrWorkspaceManager.Companion.getInstance(project).markLoaded((CidrWorkspace)this$0);
    }

    private static final Unit updateResolveConfiguration$lambda$16$lambda$15(ExternalWorkspace this$0, OCWorkspace.ModifiableModel $ocModel) {
        if (this$0.myProject.isDisposed()) {
            Disposer.dispose((Disposable)((Disposable)$ocModel));
            return Unit.INSTANCE;
        }
        this$0.commitOCModel($ocModel);
        return Unit.INSTANCE;
    }

    private static final void updateResolveConfiguration$lambda$16(ExternalWorkspace this$0, OCWorkspace.ModifiableModel $ocModel) {
        ActionsKt.runWriteAction(() -> ExternalWorkspace.updateResolveConfiguration$lambda$16$lambda$15(this$0, $ocModel));
    }

    private static final UUID reportStartEvent$lambda$17(ExternalWorkspace this$0, UUID $taskId, StartBuildEventImpl $startEvent) {
        if (this$0.myProject.isDisposed()) {
            return null;
        }
        CompilerInfoViewManager viewManager = (CompilerInfoViewManager)((Object)this$0.myProject.getService(CompilerInfoViewManager.class));
        if (Disposer.isDisposed((Disposable)((Disposable)viewManager))) {
            return null;
        }
        viewManager.onEvent($taskId, (BuildEvent)$startEvent);
        return $taskId;
    }

    private static final boolean reportMessagesInToolWindow$lambda$19(Map.Entry it) {
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return !((Collection)v).isEmpty();
    }

    private static final List reportMessagesInToolWindow$lambda$20(ExternalWorkspace this$0, UUID $startEventId, Map.Entry it) {
        Object k = it.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
        String string = (String)k;
        Object v = it.getValue();
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache.Message>");
        return this$0.reportConfigInToolWindow(string, (List)v, $startEventId);
    }

    private static final Unit reportMessagesInToolWindow$lambda$23(ExternalWorkspace this$0, Sequence $configEvents, UUID $startEventId, FinishBuildEventImpl $finishEvent) {
        if (this$0.myProject.isDisposed()) {
            return Unit.INSTANCE;
        }
        CompilerInfoViewManager viewManager = (CompilerInfoViewManager)((Object)this$0.myProject.getService(CompilerInfoViewManager.class));
        if (Disposer.isDisposed((Disposable)((Disposable)viewManager))) {
            return Unit.INSTANCE;
        }
        Sequence $this$forEach$iv = $configEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildEvent it = (BuildEvent)element$iv;
            boolean bl = false;
            viewManager.onEvent($startEventId, it);
        }
        viewManager.onEvent($startEventId, (BuildEvent)$finishEvent);
        return Unit.INSTANCE;
    }

    private static final void reportMessagesInToolWindow$lambda$24(ExternalWorkspace this$0) {
        BuildContentManager.getInstance((Project)this$0.myProject).getOrCreateToolWindow().activate(null, false);
    }

    @JvmStatic
    @NotNull
    public static final Collection<Pair<ModuleData, ExternalModule>> findExternalModules(@NotNull Project project) {
        return Companion.findExternalModules(project);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DataNode<ExternalModule>> findExternalModuleNodes(@NotNull Project project) {
        return Companion.findExternalModuleNodes(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion;", "", "<init>", "()V", "findExternalModules", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "project", "Lcom/intellij/openapi/project/Project;", "findExternalModuleNodes", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "configurationId", "", "baseId", "moduleName", "intellij.cidr.externalSystem"})
    @SourceDebugExtension(value={"SMAP\nExternalWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n1563#2:525\n1634#2,3:526\n774#2:529\n865#2,2:530\n1563#2:532\n1634#2,3:533\n1563#2:536\n1634#2,3:537\n1374#2:540\n1460#2,5:541\n1563#2:546\n1634#2,3:547\n1374#2:550\n1460#2,5:551\n1374#2:556\n1460#2,5:557\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion\n*L\n497#1:525\n497#1:526,3\n498#1:529\n498#1:530,2\n499#1:532\n499#1:533,3\n504#1:536\n504#1:537,3\n508#1:540\n508#1:541,5\n511#1:546\n511#1:547,3\n516#1:550\n516#1:551,5\n517#1:556\n517#1:557,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Collection<Pair<ModuleData, ExternalModule>> findExternalModules(@NotNull Project project) {
            Iterable $this$filterTo$iv$iv;
            Pair it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<DataNode<ExternalModule>> externalModules = this.findExternalModuleNodes(project);
            Iterable $this$map$iv = externalModules;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataNode dataNode = (DataNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)ExternalSystemApiUtil.findParent((DataNode)it, (Key)ProjectKeys.MODULE), (Object)it));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(it.getFirst() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getFirst();
                Intrinsics.checkNotNull((Object)object);
                collection.add(TuplesKt.to((Object)((DataNode)object).getData(), (Object)((DataNode)it.getSecond()).getData()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Collection<DataNode<ExternalModule>> findExternalModuleNodes(@NotNull Project project) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = ExternalSystemApiUtil.getAllManagers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllManagers(...)");
            Iterable $this$map$iv2 = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                ExternalSystemManager externalSystemManager = (ExternalSystemManager)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSystemId());
            }
            List systemIds = (List)destination$iv$iv;
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            $this$mapTo$iv$iv2 = systemIds;
            boolean $i$f$flatMap22 = false;
            void $i$f$mapTo22 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                ProjectSystemId it = (ProjectSystemId)element$iv$iv;
                boolean bl = false;
                Collection collection2 = projectDataManager.getExternalProjectsData(project, it);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getExternalProjectsData(...)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List projectInfos = (List)destination$iv$iv2;
            Iterable $i$f$flatMap22 = projectInfos;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalProjectInfo bl = (ExternalProjectInfo)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(it.getExternalProjectStructure());
            }
            List projectDataNodes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
            $this$map$iv = CollectionsKt.filterNotNull((Iterable)projectDataNodes);
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl = false;
                Collection collection3 = ExternalSystemApiUtil.findAll((DataNode)it, (Key)ProjectKeys.MODULE);
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"findAll(...)");
                Iterable list$iv$iv = collection3;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv3;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl = false;
                DataNode dataNode = it;
                Intrinsics.checkNotNull((Object)dataNode);
                Collection collection4 = ExternalSystemApiUtil.findAll((DataNode)dataNode, ExternalModule.OC_MODULE_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"findAll(...)");
                Iterable list$iv$iv = collection4;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv3;
        }

        private final String configurationId(String baseId, String moduleName) {
            String string = moduleName;
            return string == null ? baseId : string + ": " + baseId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\u000e\u0010\u0016\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0017J\t\u0010\u0018\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$ExternalResolveConfigurationModifiableModel;", "", "owner", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "ocModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "configModel", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;", "<init>", "(Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;)V", "getOcModel$intellij_cidr_externalSystem", "()Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "addSource", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings$ModifiableModel;", "Lorg/jetbrains/annotations/NotNull;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "removeSource", "", "component1", "component2", "component2$intellij_cidr_externalSystem", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.externalSystem"})
    public static final class ExternalResolveConfigurationModifiableModel {
        @NotNull
        private final ExternalWorkspace owner;
        @NotNull
        private final OCWorkspace.ModifiableModel ocModel;
        @NotNull
        private final OCResolveConfiguration.ModifiableModel configModel;

        public ExternalResolveConfigurationModifiableModel(@NotNull ExternalWorkspace owner, @NotNull OCWorkspace.ModifiableModel ocModel, @NotNull OCResolveConfiguration.ModifiableModel configModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
            Intrinsics.checkNotNullParameter((Object)ocModel, (String)"ocModel");
            Intrinsics.checkNotNullParameter((Object)configModel, (String)"configModel");
            this.owner = owner;
            this.ocModel = ocModel;
            this.configModel = configModel;
        }

        @NotNull
        public final OCWorkspace.ModifiableModel getOcModel$intellij_cidr_externalSystem() {
            return this.ocModel;
        }

        @NotNull
        public final OCCompilerSettings.ModifiableModel addSource(@NotNull VirtualFile file, @NotNull OCLanguageKind languageKind) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            OCCompilerSettings.ModifiableModel modifiableModel = this.configModel.addSource(file, languageKind);
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"addSource(...)");
            return modifiableModel;
        }

        public final void removeSource(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.configModel.removeSource(file);
        }

        private final ExternalWorkspace component1() {
            return this.owner;
        }

        @NotNull
        public final OCWorkspace.ModifiableModel component2$intellij_cidr_externalSystem() {
            return this.ocModel;
        }

        private final OCResolveConfiguration.ModifiableModel component3() {
            return this.configModel;
        }

        @NotNull
        public final ExternalResolveConfigurationModifiableModel copy(@NotNull ExternalWorkspace owner, @NotNull OCWorkspace.ModifiableModel ocModel, @NotNull OCResolveConfiguration.ModifiableModel configModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
            Intrinsics.checkNotNullParameter((Object)ocModel, (String)"ocModel");
            Intrinsics.checkNotNullParameter((Object)configModel, (String)"configModel");
            return new ExternalResolveConfigurationModifiableModel(owner, ocModel, configModel);
        }

        public static /* synthetic */ ExternalResolveConfigurationModifiableModel copy$default(ExternalResolveConfigurationModifiableModel externalResolveConfigurationModifiableModel, ExternalWorkspace externalWorkspace, OCWorkspace.ModifiableModel modifiableModel, OCResolveConfiguration.ModifiableModel modifiableModel2, int n, Object object) {
            if ((n & 1) != 0) {
                externalWorkspace = externalResolveConfigurationModifiableModel.owner;
            }
            if ((n & 2) != 0) {
                modifiableModel = externalResolveConfigurationModifiableModel.ocModel;
            }
            if ((n & 4) != 0) {
                modifiableModel2 = externalResolveConfigurationModifiableModel.configModel;
            }
            return externalResolveConfigurationModifiableModel.copy(externalWorkspace, modifiableModel, modifiableModel2);
        }

        @NotNull
        public String toString() {
            return "ExternalResolveConfigurationModifiableModel(owner=" + this.owner + ", ocModel=" + this.ocModel + ", configModel=" + this.configModel + ")";
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = result * 31 + this.ocModel.hashCode();
            result = result * 31 + this.configModel.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalResolveConfigurationModifiableModel)) {
                return false;
            }
            ExternalResolveConfigurationModifiableModel externalResolveConfigurationModifiableModel = (ExternalResolveConfigurationModifiableModel)other;
            if (!Intrinsics.areEqual((Object)((Object)this.owner), (Object)((Object)externalResolveConfigurationModifiableModel.owner))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ocModel, (Object)externalResolveConfigurationModifiableModel.ocModel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configModel, (Object)externalResolveConfigurationModifiableModel.configModel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerInfoCache.Message.Type.values().length];
            try {
                nArray[CompilerInfoCache.Message.Type.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerInfoCache.Message.Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

