/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.doctest;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestElements;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestLinker;
import com.jetbrains.cidr.execution.testing.doctest.DoctestTestLanguageSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDoctestTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope((String)DoctestTestLanguageSupport.getInstance().getPatternSeparatorInCommandLine());

    public CidrDoctestTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.normalizeScopeToRunnableTestSet(this.myFailedTests.getElements(), CidrTestScopeElement::getPattern);
            if (cidrTestScope == null) {
                CidrDoctestTestCommandLineState.$$$reportNull$$$0(4);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN) {
            CidrTestScope cidrTestScope = this.createEmptyTestScope().configureForPreRenderedScope(StringUtil.notNullize((String)delegate.getTestPattern()));
            if (cidrTestScope == null) {
                CidrDoctestTestCommandLineState.$$$reportNull$$$0(5);
            }
            return cidrTestScope;
        }
        CidrTestScope cidrTestScope = this.normalizeScopeToRunnableTestSet(super.testScope().getElements(), CidrTestScopeElement::getPattern);
        if (cidrTestScope == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(6);
        }
        return cidrTestScope;
    }

    private <T> CidrTestScope normalizeScopeToRunnableTestSet(@NotNull Collection<T> patternProviders, @NotNull Function<T, String> funGetPattern) {
        if (patternProviders == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(7);
        }
        if (funGetPattern == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(8);
        }
        TreeSet<String> patterns = new TreeSet<String>();
        for (T pp : patternProviders) {
            String escapedTestOrSectionNames = CidrDoctestTestLinker.normalizePattern(funGetPattern.apply(pp));
            patterns.add(escapedTestOrSectionNames);
        }
        CidrTestScope rerunScope = this.createEmptyTestScope();
        patterns.forEach(arg_0 -> ((CidrTestScope)rerunScope).addPattern(arg_0));
        return rerunScope;
    }

    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(9);
        }
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith("doctest://")) {
                return CidrDoctestTestLinker.create(url.substring("doctest://".length())).getPatternForCommandLine();
            }
            return null;
        }, (CidrTestCommandLineState)this);
    }

    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String suiteName, @Nullable String testName) {
        CidrTestScopeElement cidrTestScopeElement = CidrDoctestTestElements.createTestScopeElementForSuiteAndTest(suiteName, testName);
        if (cidrTestScopeElement == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(10);
        }
        return cidrTestScopeElement;
    }

    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(11);
        }
        CidrTestRunConfiguration configuration = this.getConfiguration();
        CidrTestLanguageSupport language = DoctestTestLanguageSupport.getInstance();
        Project project = configuration.getProject();
        configuration.getTestData().setCommandLineTestPattern(CidrTestExecutionUtil.getAsPatternForCommandLine((Project)project, file -> language.getElementsInFile(file), EMPTY_TEST_SCOPE_PRODUCER, () -> language.areSymbolsLoaded(project), (CidrTestScope)this.testScope(), (ProgressIndicator)progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(12);
        }
        cl.addParameters(new String[]{"-r=xml"});
        String commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern();
        if (!StringUtil.isEmpty((String)commandLineTestPattern)) {
            CidrDoctestTestCommandLineState.fixtureCommandLineTestPattern(cl, commandLineTestPattern);
        }
        return cl;
    }

    @Contract(pure=true)
    @NotNull
    private static String _D(@NotNull String id) {
        if (id == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(13);
        }
        String string = StringUtil.escapeChars((String)StringUtil.unescapeStringCharacters((String)id), (char[])new char[]{','});
        if (string == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static void fixtureCommandLineTestPattern(@NotNull GeneralCommandLine cl, @NotNull String commandLineTestPattern) {
        if (cl == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(15);
        }
        if (commandLineTestPattern == null) {
            CidrDoctestTestCommandLineState.$$$reportNull$$$0(16);
        }
        List<String> testPaths = Arrays.asList(commandLineTestPattern.split("(?<!\\\\)],[ \t\n]*\\[", -1));
        HashSet files = new HashSet();
        HashSet suites = new HashSet(testPaths.size());
        HashSet tests = new HashSet(testPaths.size());
        HashSet subtests = new HashSet(testPaths.size());
        Consumer processTestPath = locationTestPath -> {
            List<String> parts = CidrDoctestTestLinker.splitLocationPathToEscapedParts(locationTestPath);
            int size = parts.size();
            if (size == 1 && !parts.get(0).isEmpty() && parts.get(0).charAt(0) == '#') {
                files.add(CidrDoctestTestCommandLineState._D(parts.get(0).substring(1)));
            } else {
                if (size > 0) {
                    String suite = parts.get(0);
                    suites.add(suite.isEmpty() ? "*" : CidrDoctestTestCommandLineState._D(suite));
                }
                if (size > 1 && !parts.get(1).isEmpty()) {
                    tests.add(CidrDoctestTestCommandLineState._D(parts.get(1)));
                }
                if (size > 2) {
                    for (int i = 2; i < size; ++i) {
                        if (parts.get(i).isEmpty()) continue;
                        subtests.add(CidrDoctestTestCommandLineState._D(parts.get(i)));
                    }
                }
            }
        };
        for (int i = 0; i < testPaths.size(); ++i) {
            Object testPath = testPaths.get(i);
            if (i < testPaths.size() - 1) {
                testPath = (String)testPath + "]";
            }
            if (i > 0) {
                testPath = "[" + (String)testPath;
            }
            processTestPath.consume(testPath);
        }
        if (!files.isEmpty()) {
            cl.addParameters(new String[]{"-sf=" + StringUtil.join(files, (String)",")});
        }
        if (!suites.isEmpty()) {
            cl.addParameters(new String[]{"-ts=" + StringUtil.join(suites, (String)",")});
        }
        if (!tests.isEmpty()) {
            cl.addParameters(new String[]{"-tc=" + StringUtil.join(tests, (String)",")});
        }
        if (testPaths.size() == 1 && !subtests.isEmpty()) {
            cl.addParameters(new String[]{"-sc=" + StringUtil.join(subtests, (String)",")});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestCommandLineState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProviders";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funGetPattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineTestPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestCommandLineState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "_D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeScopeToRunnableTestSet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "_D";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fixtureCommandLineTestPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 14 -> new IllegalStateException(string);
        };
    }
}

