/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.statistic.DeploymentActivitiesUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class AutoUploader {
    private final Object LOCK;
    @NotNull
    private final Project myProject;
    private PublishConfig myPublishConfig;
    private final WebServerConfig myServer;
    private LinkedList<TransferOperation> myQueue;
    private final Map<TransferOperation, String> myExcludedPaths;
    private ProgressIndicator myProgressIndicator;
    private boolean myTaskIsStarting;

    public AutoUploader(@NotNull Project project, PublishConfig publishConfig2, WebServerConfig server) {
        if (project == null) {
            AutoUploader.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myQueue = new LinkedList();
        this.myExcludedPaths = new HashMap<TransferOperation, String>();
        this.myTaskIsStarting = false;
        this.myPublishConfig = publishConfig2;
        this.myServer = server;
        this.myProject = project;
    }

    public WebServerConfig getServer() {
        return this.myServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUpload() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(PublishConfig publishConfig2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myPublishConfig = publishConfig2.clone();
            this.stopUpload();
        }
    }

    @Nullable
    private WebServerConfig.RemotePath getDeployPath(String localPath, @Nullable Ref<String> excludedPathRef) {
        return this.getDeployPath(localPath, excludedPathRef, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private WebServerConfig.RemotePath getDeployPath(String localPath, @Nullable Ref<String> excludedPathRef, boolean isDir) {
        PublishConfig config;
        Object object = this.LOCK;
        synchronized (object) {
            config = this.myPublishConfig;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = config.getNearestMappingForLocal(localPath, false, true, false, (Mappable)this.myServer);
        if (mappingPair.getFirst() == null) {
            if (excludedPathRef != null && Boolean.TRUE == mappingPair.getSecond()) {
                excludedPathRef.set((Object)localPath);
            }
            return null;
        }
        WebServerConfig.RemotePath remotePath = ((DeploymentPathMapping)mappingPair.getFirst()).mapToDeployPath(localPath, this.myServer, isDir);
        if (PublishConfig.isRemotePathExcluded(remotePath, (Mappable)this.myServer, config)) {
            if (excludedPathRef != null) {
                excludedPathRef.set((Object)remotePath.path);
            }
            return null;
        }
        return remotePath;
    }

    protected void handlePropertyChangeEvent(boolean sourceMuted, boolean targetMuted, String oldPath, String newPath, boolean isDirectory) {
        WebServerConfig.RemotePath remoteNewPath;
        String excludedPath = null;
        Ref excluded = new Ref();
        WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded, isDirectory);
        if (remoteOldPath == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded, isDirectory)) == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
        }
        if (remoteOldPath == null && remoteNewPath == null) {
            return;
        }
        if (remoteOldPath == null) {
            if (!targetMuted) {
                this.onCreate(newPath, isDirectory, true, excludedPath);
            }
        } else if (remoteNewPath == null) {
            if (!sourceMuted) {
                this.onDelete(oldPath, isDirectory, excludedPath);
            }
        } else if (sourceMuted && !targetMuted) {
            this.onCreate(newPath, isDirectory, true, excludedPath);
        } else if (!sourceMuted && targetMuted) {
            this.onDelete(oldPath, isDirectory, excludedPath);
        } else if (!sourceMuted && !targetMuted) {
            this.onMove(oldPath, newPath, isDirectory, excludedPath);
        }
    }

    protected void handleFileMovedEvent(boolean sourceMuted, boolean targetMuted, String oldPath, String newPath, boolean isDirectory) {
        WebServerConfig.RemotePath remoteNewPath;
        String excludedPath = null;
        Ref excluded = new Ref();
        WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded, isDirectory);
        if (remoteOldPath == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded, isDirectory)) == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if (remoteOldPath == null && remoteNewPath == null) {
            return;
        }
        if (remoteOldPath == null) {
            if (!targetMuted) {
                this.onCreate(newPath, isDirectory, true, excludedPath);
            }
        } else if (remoteNewPath == null) {
            if (!sourceMuted) {
                this.onDelete(oldPath, isDirectory, excludedPath);
            }
        } else {
            if (!targetMuted && sourceMuted) {
                this.onCreate(newPath, isDirectory, true, excludedPath);
            }
            if (!sourceMuted && targetMuted) {
                this.onDelete(oldPath, isDirectory, excludedPath);
            }
            if (!sourceMuted && !targetMuted) {
                this.onMove(oldPath, newPath, isDirectory, excludedPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void onCreate(String path, boolean isDirectory, boolean recursive, @Nullable String excludedPath) {
        Object object = this.LOCK;
        synchronized (object) {
            WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null, isDirectory);
            if (remotePath == null) {
                return;
            }
            if (isDirectory) {
                if (recursive) {
                    this.offerTransferOperation(new CopyFolder(path, remotePath){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void handle(List<TransferOperation> newOperations) {
                            Object object = AutoUploader.this.LOCK;
                            synchronized (object) {
                                AutoUploader.this.myQueue.addAll(newOperations);
                            }
                        }
                    }, new TransferOperation.RsyncCopy(DeploymentPathUtils.getLocalFile(path), remotePath), excludedPath);
                } else {
                    this.offerTransferOperation(new TransferOperation.CreateFolder(this.getDeployPath(path, null, isDirectory)), null, excludedPath);
                }
            } else {
                this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), this.getDeployPath(path, null, isDirectory)), new TransferOperation.RsyncCopy(DeploymentPathUtils.getLocalFile(path), this.getDeployPath(path, null, isDirectory)), excludedPath);
            }
            this.ensureTaskRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFileModified(String path) {
        Object object = this.LOCK;
        synchronized (object) {
            WebServerConfig.RemotePath targetPath = this.getDeployPath(path, null);
            if (targetPath == null) {
                return;
            }
            this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), targetPath), new TransferOperation.RsyncCopy(DeploymentPathUtils.getLocalFile(path), targetPath), null);
            this.ensureTaskRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMove(String oldPath, String newPath, boolean isDirectory, @Nullable String excludedPath) {
        if (oldPath.equals(newPath)) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (TransferOperation operation : this.myQueue) {
                try {
                    operation.onLocalMove(DeploymentPathUtils.getLocalFile(oldPath), DeploymentPathUtils.getLocalFile(newPath));
                }
                catch (FileSystemException e) {
                    Logger.getInstance(AutoUploader.class).error((Throwable)e);
                }
            }
            this.offerTransferOperation(new TransferOperation.RemoteMoveOrUpload(newPath, this.getDeployPath(oldPath, null, isDirectory), this.getDeployPath(newPath, null, isDirectory), isDirectory), null, excludedPath);
            this.ensureTaskRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDelete(String path, boolean isDirectory, @Nullable String excludedPath) {
        Object object = this.LOCK;
        synchronized (object) {
            WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null, isDirectory);
            if (remotePath == null) {
                return;
            }
            this.offerTransferOperation(PublishConfig.getInstance(this.myProject).isConfirmBeforeDeletion() ? new TransferOperation.UserConfirmedDelete(remotePath, isDirectory, true, true) : new TransferOperation.Delete(remotePath, isDirectory, true), null, excludedPath);
            this.ensureTaskRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerTransferOperation(TransferOperation operation, TransferOperation rsyncOperation, @Nullable String excludedFolders) {
        Object object = this.LOCK;
        synchronized (object) {
            if (rsyncOperation != null && this.myServer.isUseRsync()) {
                this.myQueue.offer(rsyncOperation);
            } else {
                this.myQueue.offer(operation);
            }
            if (excludedFolders != null) {
                this.myExcludedPaths.put(operation, excludedFolders);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTaskRunning() {
        final long startTimestamp = System.currentTimeMillis();
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myQueue.isEmpty() && this.myProgressIndicator == null && !this.myTaskIsStarting) {
                this.myTaskIsStarting = true;
                String title = WDBundle.message("auto.upload.task.title", new Object[0]);
                FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServer, title, ConsoleViewContentType.SYSTEM_OUTPUT, this.myPublishConfig.getTraceLevel());
                PublishConfig config = this.myPublishConfig;
                new TransferTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), true, config, Deployable.create(this.myServer, this.myProject), title, false, true, true, ProjectDeploymentRevisionTracker.getInstance(this.myProject)){
                    private int myProcessed;
                    private boolean myProgressIndicatorWasCleared;
                    {
                        super(project, connectionOwner, serverSideModification, publishConfig2, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker);
                        this.myProcessed = 0;
                        this.myProgressIndicatorWasCleared = false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        ArrayList<TransferOperation> operations;
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        Object object = AutoUploader.this.LOCK;
                        synchronized (object) {
                            AutoUploader.this.myTaskIsStarting = false;
                            if (AutoUploader.this.myProgressIndicator != null) {
                                return;
                            }
                            AutoUploader.this.myProgressIndicator = indicator;
                            operations = new ArrayList<TransferOperation>(AutoUploader.this.myQueue);
                        }
                        try {
                            this.doRun(indicator);
                        }
                        finally {
                            object = AutoUploader.this.LOCK;
                            synchronized (object) {
                                AutoUploader.this.myQueue.removeAll(operations);
                                if (!this.myProgressIndicatorWasCleared) {
                                    AutoUploader.this.myProgressIndicator = null;
                                }
                            }
                            DeploymentActivitiesUsageTriggerCollector.logAutoUploadFinished(AutoUploader.this.myProject, startTimestamp);
                        }
                    }

                    @Override
                    protected boolean isMultipleOperations() {
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected boolean prepareOperations(ExecutionContext context) throws FileSystemException {
                        for (int i = 0; i < AutoUploader.this.myExcludedPaths.size(); ++i) {
                            context.incCounter("transfer.details.excluded");
                        }
                        Object object = AutoUploader.this.LOCK;
                        synchronized (object) {
                            AutoUploader.this.myQueue = new LinkedList<TransferOperation>(DeploymentPathUtils.mergeIfNeeded(context, new ArrayList<TransferOperation>(AutoUploader.this.myQueue)));
                        }
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected TransferOperation getNextOperation(ExecutionContext context) {
                        Object object = AutoUploader.this.LOCK;
                        synchronized (object) {
                            TransferOperation info;
                            for (TransferOperation t : AutoUploader.this.myQueue) {
                                if (!(t instanceof TransferOperation.RsyncCopy) || t instanceof TransferOperation.RsyncMultiFileUploading || t instanceof TransferOperation.RsyncMultiFileDownloading) continue;
                                try {
                                    AutoUploader.this.myQueue = new LinkedList<TransferOperation>(DeploymentPathUtils.mergeIfNeeded(context, new ArrayList<TransferOperation>(AutoUploader.this.myQueue)));
                                }
                                catch (FileSystemException fileSystemException) {}
                                break;
                            }
                            if ((info = AutoUploader.this.myQueue.poll()) == null) {
                                this.myProgressIndicatorWasCleared = true;
                                AutoUploader.this.myProgressIndicator = null;
                                return null;
                            }
                            ++this.myProcessed;
                            String excludedPath = AutoUploader.this.myExcludedPaths.remove(info);
                            if (excludedPath != null) {
                                this.print(WDBundle.message("excluded.message", excludedPath), ConsoleViewContentType.NORMAL_OUTPUT);
                            }
                            return info;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected int getDoneStepsNumber() {
                        Object object = AutoUploader.this.LOCK;
                        synchronized (object) {
                            return this.myProcessed - 1;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected int getTotalStepsNumber() {
                        Object object = AutoUploader.this.LOCK;
                        synchronized (object) {
                            return this.myProcessed + AutoUploader.this.myQueue.size();
                        }
                    }

                    @Override
                    protected void assertAllExecuted(int totalProcessed, int failed) {
                    }

                    @Override
                    protected void showBalloon(MessageType type, @NlsContexts.NotificationContent String text, boolean isSummary) {
                        if (isSummary ? type != MessageType.INFO : type == MessageType.ERROR) {
                            super.showBalloon(type, text, isSummary);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader$2", "run"));
                    }
                }.queue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotUploading() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myProgressIndicator == null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader", "<init>"));
    }

    private static abstract class CopyFolder
    extends TransferOperation {
        private String mySourcePath;
        private final WebServerConfig.RemotePath myTargetPath;

        protected abstract void handle(List<TransferOperation> var1);

        private CopyFolder(String sourcePath, WebServerConfig.RemotePath targetPath) {
            this.mySourcePath = sourcePath;
            this.myTargetPath = targetPath;
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("collecting.files", new Object[0]);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("preparing.upload.0.to.1", this.mySourcePath, context.getServer().getPresentablePath(this.myTargetPath));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            FileObject source = DeploymentPathUtils.getLocalFile(this.mySourcePath);
            ArrayList<TransferOperation> newOperations = new ArrayList<TransferOperation>();
            DeploymentPathUtils.ErrorsAndExclusions errors = DeploymentPathUtils.processOutgoing(source, newOperations, context);
            for (String error : errors.getReadOnlyErrors()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), error, ConsoleViewContentType.SYSTEM_OUTPUT, context.getConfig().getTraceLevel());
            }
            for (String path : errors.getReadOnlyPaths()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), WDBundle.message("excluded.message", path), ConsoleViewContentType.NORMAL_OUTPUT, context.getConfig().getTraceLevel());
            }
            this.handle(newOperations);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext serverConfig, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                CopyFolder.$$$reportNull$$$0(0);
            }
            String string = WDBundle.message("preparing.upload.failed", this.mySourcePath, reason);
            if (string == null) {
                CopyFolder.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
            this.mySourcePath = CopyFolder.updateOnParentMove(this.mySourcePath, sourceFrom, sourceTo, SystemInfo.isFileSystemCaseSensitive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader$CopyFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader$CopyFolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

