/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.execution.runners.ExecutionUtil;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"icon", "Ljavax/swing/Icon;", "connectedIcon", "getIcon", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "getIconForConsole", "originalIcon", "hasSessionNode", "", "connected", "intellij.database.connectivity"})
@JvmName(name="SessionsUiUtil")
public final class SessionsUiUtil {
    @NotNull
    private static final Icon icon;
    @NotNull
    private static final Icon connectedIcon;

    @NotNull
    public static final Icon getIcon(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return SessionsUtil.needToShowProgress(session) ? SessionsUtil.getProgressIcon(session.isCancelled()) : SessionsUiUtil.getIcon(session.isConnected());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Icon getIconForConsole(@NotNull DatabaseSession session, @Nullable Icon originalIcon, boolean hasSessionNode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Icon icon = originalIcon;
        if (icon != null) {
            void var3_3;
            Icon it = icon;
            boolean bl = false;
            object = session.isConnected() && !hasSessionNode ? ExecutionUtil.getLiveIndicator((Icon)it) : var3_3;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final Icon getIcon(boolean connected) {
        return connected ? connectedIcon : icon;
    }

    static {
        Icon icon = DatabaseIcons.Connector;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Connector");
        SessionsUiUtil.icon = icon;
        Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)SessionsUiUtil.icon);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getLiveIndicator(...)");
        connectedIcon = icon2;
    }
}

