/*****
 NAME
 	fxml.h - header file for functions for libxml2
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 NOTE
  This is file described by Objective-C. But this file does not define
  the class.
 */

#if !defined(FXML_H_INCLUDED)
#define FXML_H_INCLUDED

#include <coconut/pxmltree.h>

#include <coconut/dconfig.h>
#ifdef COCONUT_HAVE_XML2_CONFIG
#	include <libxml/xmlmemory.h>
#	include <libxml/parser.h>
#else
#	error "This code requires libxml2 package"
#endif

void * extXmlMalloc(size_t size) ;
void * extXmlRealloc(void * ptr, size_t size) ;
char * extXmlStrdup(const char * str) ;
void extXmlFree(void * ptr) ;

id <PXMLNode> xmlNodePtr2Object(xmlNodePtr p) ;

id <PXMLNode> newXMLNodeObject(xmlNsPtr ns, const xmlChar * name) ;
id <PXMLNode> newXMLTextObject(const xmlChar *content) ;
void destroyXMLNodeObject(id <PXMLNode> obj) ;

#endif /* !defined(FXML_H_INCLUDED) */

