/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.CreationMethod;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Diode (plastic)", author="Branislav Stojkovic", category="Semiconductors", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="D", description="Plastic diode, like most rectifier, zener, schottky, etc.", zOrder=4.0)
public class DiodePlastic
extends AbstractLeadedComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.25), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Size MARKER_WIDTH = new Size(Double.valueOf(1.0), SizeUnit.mm);
    public static Color BODY_COLOR = Color.darkGray;
    public static Color MARKER_COLOR = Color.decode("#DDDDDD");
    public static Color LABEL_COLOR = Color.white;
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    private String value = "";
    private Color markerColor = MARKER_COLOR;

    public DiodePlastic() {
        this.labelColor = LABEL_COLOR;
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    protected boolean supportsStandingMode() {
        return true;
    }

    public Color getStandingBodyColor() {
        return this.getFlipStanding() ? this.getBodyColor() : this.getMarkerColor();
    }

    @EditableProperty(name="Reverse (standing)")
    public boolean getFlipStanding() {
        return super.getFlipStanding();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(6, height / 2 - 3, width - 12, 6);
        g2d.setColor(MARKER_COLOR);
        int markerWidth = 4 * width / 32;
        g2d.fillRect(width - 6 - markerWidth, height / 2 - 3, markerWidth, 6);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(6, height / 2 - 3, width - 12, 6);
    }

    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    protected Shape getBodyShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getLength().convertToPixels(), this.getClosestOdd(this.getWidth().convertToPixels()));
    }

    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        Color finalMarkerColor;
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalMarkerColor = theme.getOutlineColor();
        } else {
            finalMarkerColor = this.markerColor;
        }
        g2d.setColor(finalMarkerColor);
        int width = (int)this.getLength().convertToPixels();
        int markerWidth = (int)MARKER_WIDTH.convertToPixels();
        g2d.fillRect(width - markerWidth, 0, markerWidth, this.getClosestOdd(this.getWidth().convertToPixels()));
    }

    @EditableProperty(name="Marker")
    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color markerColor) {
        this.markerColor = markerColor;
    }
}

