/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.policy.model.AlgorithmWrapper;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class AlgorithmSuiteProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedAlgorithmSuite = false;

    private void initializeAlgorithmSuite(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.basic256.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic192.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic128.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.tripleDes.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic256Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic192Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic128Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.tripleDesRsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic256Sha256.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic192Sha256.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic128Sha256.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.tripleDesSha256.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic256Sha256Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic192Sha256Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.basic128Sha256Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.tripleDesSha256Rsa15.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.inclusiveC14N.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.soapNormalization10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.strTransform10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.xPath10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.xPathFilter20.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doAlgorithmSuite(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (!this.initializedAlgorithmSuite) {
                    try {
                        this.initializeAlgorithmSuite(spt);
                        this.initializedAlgorithmSuite = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                this.log.debug((Object)spt.getTokenName());
                PrimitiveAssertion pa = spc.getAssertion();
                String text = pa.getStrValue();
                if (text != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doBasic256(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic192(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic128(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doTripleDes(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic256Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic192Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic128Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doTripleDesRsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic256Sha256(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic192Sha256(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic128Sha256(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doTripleDesSha256(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic256Sha256Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic192Sha256Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doBasic128Sha256Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doTripleDesSha256Rsa15(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return this.setAlgoGroup(spc);
    }

    public Object doInclusiveC14N(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
        if (spc.getAction() == 1) {
            try {
                algoSuite.setC14n("http://www.w3.org/2001/10/xml-c14n#");
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doSoapNormalization10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
        if (spc.getAction() == 1) {
            try {
                algoSuite.setSoapNormalization("http://www.w3.org/TR/soap12-n11n");
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doStrTransform10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
        if (spc.getAction() == 1) {
            try {
                algoSuite.setStrTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doXPath10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
        if (spc.getAction() == 1) {
            try {
                algoSuite.setXPath("http://www.w3.org/TR/1999/REC-xpath-19991116");
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doXPathFilter20(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
        if (spc.getAction() == 1) {
            try {
                algoSuite.setXPath("http://www.w3.org/2002/06/xmldsig-filter2");
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    private Boolean setAlgoGroup(SecurityProcessorContext spc) {
        if (spc.getAction() == 1) {
            try {
                AlgorithmSuite algoSuite = (AlgorithmSuite)spc.readCurrentPolicyEngineData();
                algoSuite.setAlgorithmSuite(spc.getAssertion().getName().getLocalPart());
                ((AlgorithmWrapper)((Object)spc.readPreviousPolicyEngineData())).setAlgorithmSuite(algoSuite);
            }
            catch (WSSPolicyException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }
}

