/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.job.retention.ExpiredForecastsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredModelSnapshotsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredResultsRemover;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.job.retention.UnusedStateRemover;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class TransportDeleteExpiredDataAction
extends HandledTransportAction<DeleteExpiredDataAction.Request, DeleteExpiredDataAction.Response> {
    static final Duration MAX_DURATION = Duration.ofHours(8L);
    private final String executor;
    private final Client client;
    private final ClusterService clusterService;
    private final Clock clock;

    @Inject
    public TransportDeleteExpiredDataAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService) {
        this(settings, threadPool, "ml_utility", transportService, actionFilters, indexNameExpressionResolver, client, clusterService, Clock.systemUTC());
    }

    TransportDeleteExpiredDataAction(Settings settings, ThreadPool threadPool, String executor, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService, Clock clock) {
        super(settings, "cluster:admin/xpack/ml/delete_expired_data", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteExpiredDataAction.Request::new, executor);
        this.executor = executor;
        this.client = ClientHelper.clientWithOrigin((Client)client, (String)"ml");
        this.clusterService = clusterService;
        this.clock = clock;
    }

    protected void doExecute(DeleteExpiredDataAction.Request request, ActionListener<DeleteExpiredDataAction.Response> listener) {
        this.logger.info("Deleting expired data");
        Instant timeoutTime = Instant.now(this.clock).plus(MAX_DURATION);
        Supplier<Boolean> isTimedOutSupplier = () -> Instant.now(this.clock).isAfter(timeoutTime);
        this.threadPool.executor("ml_utility").execute(() -> this.deleteExpiredData(listener, isTimedOutSupplier));
    }

    private void deleteExpiredData(ActionListener<DeleteExpiredDataAction.Response> listener, Supplier<Boolean> isTimedOutSupplier) {
        Auditor auditor = new Auditor(this.client, this.clusterService.getNodeName());
        List<MlDataRemover> dataRemovers = Arrays.asList(new ExpiredResultsRemover(this.client, this.clusterService, auditor), new ExpiredForecastsRemover(this.client, this.threadPool), new ExpiredModelSnapshotsRemover(this.client, this.clusterService, this.threadPool), new UnusedStateRemover(this.client, this.clusterService));
        VolatileCursorIterator<MlDataRemover> dataRemoversIterator = new VolatileCursorIterator<MlDataRemover>(dataRemovers);
        this.deleteExpiredData(dataRemoversIterator, listener, isTimedOutSupplier, true);
    }

    void deleteExpiredData(Iterator<MlDataRemover> mlDataRemoversIterator, ActionListener<DeleteExpiredDataAction.Response> listener, Supplier<Boolean> isTimedOutSupplier, boolean haveAllPreviousDeletionsCompleted) {
        if (haveAllPreviousDeletionsCompleted && mlDataRemoversIterator.hasNext()) {
            MlDataRemover remover = mlDataRemoversIterator.next();
            ActionListener nextListener = ActionListener.wrap(booleanResponse -> this.deleteExpiredData(mlDataRemoversIterator, listener, isTimedOutSupplier, (boolean)booleanResponse), arg_0 -> listener.onFailure(arg_0));
            remover.remove((ActionListener<Boolean>)new ThreadedActionListener(this.logger, this.threadPool, this.executor, nextListener, false), isTimedOutSupplier);
        } else {
            if (haveAllPreviousDeletionsCompleted) {
                this.logger.info("Completed deletion of expired ML data");
            } else {
                this.logger.info("Halted deletion of expired ML data until next invocation");
            }
            listener.onResponse((Object)new DeleteExpiredDataAction.Response(haveAllPreviousDeletionsCompleted));
        }
    }
}

