/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.tree;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class Node<T extends Node<T>> {
    private static final int TO_STRING_MAX_PROP = 10;
    private static final int TO_STRING_MAX_WIDTH = 110;
    private final Source source;
    private final List<T> children;

    public Node(Source source, List<T> children) {
        Source source2 = this.source = source != null ? source : Source.EMPTY;
        if (children.contains(null)) {
            throw new SqlIllegalArgumentException("Null children are not allowed");
        }
        this.children = children;
    }

    public Source source() {
        return this.source;
    }

    public Location sourceLocation() {
        return this.source.source();
    }

    public String sourceText() {
        return this.source.text();
    }

    public List<T> children() {
        return this.children;
    }

    public void forEachDown(Consumer<? super T> action) {
        action.accept(this);
        this.children().forEach(c -> c.forEachDown(action));
    }

    public <E extends T> void forEachDown(Consumer<? super E> action, Class<E> typeToken) {
        this.forEachDown(t -> {
            if (typeToken.isInstance(t)) {
                action.accept((Object)t);
            }
        });
    }

    public void forEachUp(Consumer<? super T> action) {
        this.children().forEach(c -> c.forEachUp(action));
        action.accept(this);
    }

    public <E extends T> void forEachUp(Consumer<? super E> action, Class<E> typeToken) {
        this.forEachUp(t -> {
            if (typeToken.isInstance(t)) {
                action.accept((Object)t);
            }
        });
    }

    public <E> void forEachPropertiesOnly(Consumer<? super E> rule, Class<E> typeToken) {
        this.forEachProperty(rule, typeToken);
    }

    public <E> void forEachPropertiesDown(Consumer<? super E> rule, Class<E> typeToken) {
        this.forEachDown(e -> e.forEachProperty(rule, typeToken));
    }

    public <E> void forEachPropertiesUp(Consumer<? super E> rule, Class<E> typeToken) {
        this.forEachUp(e -> e.forEachProperty(rule, typeToken));
    }

    protected <E> void forEachProperty(Consumer<? super E> rule, Class<E> typeToken) {
        for (Object prop : this.info().properties()) {
            if (prop == this.children || this.children.contains(prop) || !typeToken.isInstance(prop)) continue;
            rule.accept(prop);
        }
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        boolean result = predicate.test(this);
        if (!result) {
            for (Node child : this.children) {
                if (!child.anyMatch(predicate)) continue;
                return true;
            }
        }
        return result;
    }

    public List<T> collect(Predicate<? super T> predicate) {
        ArrayList l = new ArrayList();
        this.forEachDown(n -> {
            if (predicate.test(n)) {
                l.add(n);
            }
        });
        return l.isEmpty() ? Collections.emptyList() : l;
    }

    public List<T> collectLeaves() {
        return this.collect(n -> n.children().isEmpty());
    }

    public List<T> collectFirstChildren(Predicate<? super T> predicate) {
        ArrayList matches = new ArrayList();
        this.doCollectFirst(predicate, matches);
        return matches;
    }

    protected void doCollectFirst(Predicate<? super T> predicate, List<T> matches) {
        Node t = this;
        if (predicate.test(t)) {
            matches.add(t);
        } else {
            for (Node child : this.children()) {
                child.doCollectFirst(predicate, matches);
            }
        }
    }

    public T transformDown(Function<? super T, ? extends T> rule) {
        Node root = (Node)rule.apply(this);
        Node node = this.equals(root) ? this : root;
        return (T)node.transformChildren(child -> child.transformDown(rule));
    }

    public <E extends T> T transformDown(Function<E, ? extends T> rule, Class<E> typeToken) {
        return (T)this.transformDown(t -> typeToken.isInstance(t) ? (Node)rule.apply(t) : t);
    }

    public T transformUp(Function<? super T, ? extends T> rule) {
        Node transformed = this.transformChildren(child -> child.transformUp(rule));
        Node node = this.equals(transformed) ? this : transformed;
        return (T)((Node)rule.apply(node));
    }

    public <E extends T> T transformUp(Function<E, ? extends T> rule, Class<E> typeToken) {
        return (T)this.transformUp(t -> typeToken.isInstance(t) ? (Node)rule.apply(t) : t);
    }

    protected <R extends Function<? super T, ? extends T>> T transformChildren(Function<T, ? extends T> traversalOperation) {
        boolean childrenChanged = false;
        ArrayList<Node> transformedChildren = new ArrayList<Node>(this.children().size());
        for (Node child : this.children) {
            Node next;
            if (!child.equals(next = (Node)traversalOperation.apply(child))) {
                childrenChanged = true;
            } else {
                next = child;
            }
            transformedChildren.add(next);
        }
        return (T)(childrenChanged ? this.replaceChildren(transformedChildren) : this);
    }

    public abstract T replaceChildren(List<T> var1);

    public <E> T transformPropertiesOnly(Function<? super E, ? extends E> rule, Class<E> typeToken) {
        return this.transformNodeProps(rule, typeToken);
    }

    public <E> T transformPropertiesDown(Function<? super E, ? extends E> rule, Class<E> typeToken) {
        return (T)this.transformDown(t -> t.transformNodeProps(rule, typeToken));
    }

    public <E> T transformPropertiesUp(Function<? super E, ? extends E> rule, Class<E> typeToken) {
        return (T)this.transformUp(t -> t.transformNodeProps(rule, typeToken));
    }

    protected final <E> T transformNodeProps(Function<? super E, ? extends E> rule, Class<E> typeToken) {
        return this.info().transform(rule, typeToken);
    }

    protected abstract NodeInfo<? extends T> info();

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.children(), other.children());
    }

    public String nodeName() {
        return this.getClass().getSimpleName();
    }

    public List<Object> nodeProperties() {
        return this.info().properties();
    }

    public String nodeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeName());
        sb.append("[");
        sb.append(this.propertiesToString(true));
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.treeString(new StringBuilder(), 0, new BitSet()).toString();
    }

    final StringBuilder treeString(StringBuilder sb, int depth, BitSet hasParentPerDepth) {
        if (depth > 0) {
            for (int column = 0; column < depth; ++column) {
                if (hasParentPerDepth.get(column)) {
                    sb.append("|");
                    if (column >= depth - 1) continue;
                    sb.append(" ");
                    continue;
                }
                sb.append(column == depth - 1 ? "\\" : "  ");
            }
            sb.append("_");
        }
        sb.append(this.nodeString());
        List<T> children = this.children();
        if (!children.isEmpty()) {
            sb.append("\n");
        }
        for (int i = 0; i < children.size(); ++i) {
            Node t = (Node)children.get(i);
            hasParentPerDepth.set(depth, i < children.size() - 1);
            t.treeString(sb, depth + 1, hasParentPerDepth);
            if (i >= children.size() - 1) continue;
            sb.append("\n");
        }
        return sb;
    }

    public String propertiesToString(boolean skipIfChild) {
        StringBuilder sb = new StringBuilder();
        List<T> children = this.children();
        int remainingProperties = 10;
        int maxWidth = 0;
        boolean needsComma = false;
        List<Object> props = this.nodeProperties();
        for (Object prop : props) {
            String stringValue;
            if (skipIfChild && (children.contains(prop) || children.equals(prop))) continue;
            if (remainingProperties-- < 0) {
                sb.append("...").append(props.size() - 10).append("fields not shown");
                break;
            }
            if (needsComma) {
                sb.append(",");
            }
            if (maxWidth + (stringValue = Objects.toString(prop)).length() > 110) {
                int cutoff = Math.max(0, 110 - maxWidth);
                sb.append(stringValue.substring(0, cutoff));
                sb.append("\n");
                stringValue = stringValue.substring(cutoff);
                maxWidth = 0;
            }
            maxWidth += stringValue.length();
            sb.append(stringValue);
            needsComma = true;
        }
        return sb.toString();
    }
}

