/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;

public class AuthenticateResponse
extends ActionResponse {
    private Authentication authentication;

    public AuthenticateResponse() {
    }

    public AuthenticateResponse(Authentication authentication) {
        this.authentication = authentication;
    }

    public Authentication authentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_6_0)) {
            User.writeTo(this.authentication.getUser(), out);
        } else {
            this.authentication.writeTo(out);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_6_6_0)) {
            User user = User.readFrom(in);
            Authentication.RealmRef unknownRealm = new Authentication.RealmRef("__unknown", "__unknown", "__unknown");
            this.authentication = new Authentication(user, unknownRealm, unknownRealm);
        } else {
            this.authentication = new Authentication(in);
        }
    }
}

