/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.elasticsearch.xpack.security.support.RestorableContextClassLoader;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.KeyInfoReferenceProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SamlRequestHandler {
    protected static final String SAML_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:protocol";
    private static final String[] XSD_FILES = new String[]{"/org/elasticsearch/xpack/security/authc/saml/saml-schema-protocol-2.0.xsd", "/org/elasticsearch/xpack/security/authc/saml/saml-schema-assertion-2.0.xsd", "/org/elasticsearch/xpack/security/authc/saml/xenc-schema.xsd", "/org/elasticsearch/xpack/security/authc/saml/xmldsig-core-schema.xsd"};
    private static final ThreadLocal<DocumentBuilder> THREAD_LOCAL_DOCUMENT_BUILDER = ThreadLocal.withInitial(() -> {
        try {
            return SamlUtils.getHardenedBuilder(XSD_FILES);
        }
        catch (Exception e) {
            throw SamlUtils.samlException("Could not load XSD schema file", e, new Object[0]);
        }
    });
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Nullable
    protected final Decrypter decrypter;
    private final Clock clock;
    private final IdpConfiguration idp;
    private final SpConfiguration sp;
    private final TimeValue maxSkew;
    private final UnmarshallerFactory unmarshallerFactory;

    public SamlRequestHandler(Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        this.clock = clock;
        this.idp = idp;
        this.sp = sp;
        this.maxSkew = maxSkew;
        this.unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        this.decrypter = sp.getEncryptionCredentials().isEmpty() ? null : new Decrypter(null, this.createResolverForEncryptionKeys(), this.createResolverForEncryptedKeyElements());
    }

    private KeyInfoCredentialResolver createResolverForEncryptionKeys() {
        CollectionKeyInfoCredentialResolver collectionKeyInfoCredentialResolver = new CollectionKeyInfoCredentialResolver(Collections.unmodifiableCollection(this.sp.getEncryptionCredentials()));
        LocalKeyInfoCredentialResolver localKeyInfoCredentialResolver = new LocalKeyInfoCredentialResolver(Arrays.asList(new InlineX509DataProvider(), new KeyInfoReferenceProvider(), new RSAKeyValueProvider(), new DEREncodedKeyValueProvider()), (CredentialResolver)collectionKeyInfoCredentialResolver);
        return new ChainingKeyInfoCredentialResolver(Arrays.asList(localKeyInfoCredentialResolver, collectionKeyInfoCredentialResolver));
    }

    private EncryptedKeyResolver createResolverForEncryptedKeyElements() {
        return new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver(), new SimpleKeyInfoReferenceEncryptedKeyResolver()));
    }

    protected SpConfiguration getSpConfiguration() {
        return this.sp;
    }

    protected String describe(X509Certificate certificate) {
        return "X509Certificate{Subject=" + certificate.getSubjectDN() + "; SerialNo=" + certificate.getSerialNumber().toString(16) + "}";
    }

    protected String describe(Collection<X509Credential> credentials) {
        return credentials.stream().map(credential -> this.describe(credential.getEntityCertificate())).collect(Collectors.joining(","));
    }

    void validateSignature(Signature signature) {
        String signatureText = this.text((XMLObject)signature, 32);
        SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
        try {
            profileValidator.validate(signature);
        }
        catch (SignatureException e) {
            throw this.samlSignatureException(this.idp.getSigningCredentials(), signatureText, (Exception)((Object)e));
        }
        this.checkIdpSignature((CheckedFunction<Credential, Boolean, Exception>)((CheckedFunction)credential -> {
            Boolean bl;
            RestorableContextClassLoader ignore = new RestorableContextClassLoader(SignatureValidator.class);
            try {
                SignatureValidator.validate((Signature)signature, (Credential)credential);
                this.logger.debug(() -> new ParameterizedMessage("SAML Signature [{}] matches credentials [{}] [{}]", new Object[]{signatureText, credential.getEntityId(), credential.getPublicKey()}));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (PrivilegedActionException e) {
                    this.logger.warn("SecurityException while attempting to validate SAML signature", (Throwable)e);
                    return false;
                }
            }
            ignore.close();
            return bl;
        }), signatureText);
    }

    protected void checkIdpSignature(CheckedFunction<Credential, Boolean, Exception> check, String signatureText) {
        Predicate<Credential> predicate = credential -> {
            try {
                return (Boolean)check.apply(credential);
            }
            catch (SecurityException | SignatureException e) {
                this.logger.debug(() -> SamlRequestHandler.lambda$checkIdpSignature$4(signatureText, credential, (Exception)e));
                this.logger.trace("SAML Signature failure caused by", e);
                return false;
            }
            catch (Exception e) {
                this.logger.warn("Exception while attempting to validate SAML Signature", (Throwable)e);
                return false;
            }
        };
        List<Credential> credentials = this.idp.getSigningCredentials();
        if (!credentials.stream().anyMatch(predicate)) {
            throw this.samlSignatureException(credentials, signatureText);
        }
    }

    private ElasticsearchSecurityException samlSignatureException(List<Credential> credentials, String signature, Exception cause) {
        this.logger.warn("The XML Signature of this SAML message cannot be validated. Please verify that the saml realm uses the correct SAMLmetadata file/URL for this Identity Provider");
        String msg = "SAML Signature [{}] could not be validated against [{}]";
        return SamlUtils.samlException("SAML Signature [{}] could not be validated against [{}]", cause, signature, this.describeCredentials(credentials));
    }

    private ElasticsearchSecurityException samlSignatureException(List<Credential> credentials, String signature) {
        this.logger.warn("The XML Signature of this SAML message cannot be validated. Please verify that the saml realm uses the correct SAMLmetadata file/URL for this Identity Provider");
        String msg = "SAML Signature [{}] could not be validated against [{}]";
        return SamlUtils.samlException("SAML Signature [{}] could not be validated against [{}]", signature, this.describeCredentials(credentials));
    }

    private String describeCredentials(List<Credential> credentials) {
        return credentials.stream().map(c -> {
            byte[] encoded;
            if (c == null) {
                return "<null>";
            }
            if (c instanceof X509Credential) {
                X509Credential x = (X509Credential)c;
                try {
                    encoded = x.getEntityCertificate().getEncoded();
                }
                catch (CertificateEncodingException e) {
                    encoded = c.getPublicKey().getEncoded();
                }
            } else {
                encoded = c.getPublicKey().getEncoded();
            }
            return Base64.getEncoder().encodeToString(encoded).substring(0, 64) + "...";
        }).collect(Collectors.joining(","));
    }

    protected void checkIssuer(Issuer issuer, XMLObject parent) {
        if (issuer == null) {
            throw SamlUtils.samlException("Element {} ({}) has no issuer, but expected {}", parent.getElementQName(), this.text(parent, 16), this.idp.getEntityId());
        }
        if (!this.idp.getEntityId().equals(issuer.getValue())) {
            throw SamlUtils.samlException("SAML Issuer {} does not match expected value {}", issuer.getValue(), this.idp.getEntityId());
        }
    }

    protected long maxSkewInMillis() {
        return this.maxSkew.millis();
    }

    protected Instant now() {
        return this.clock.instant();
    }

    protected Instant toInstant(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Instant.ofEpochMilli(dateTime.getMillis());
    }

    <T extends XMLObject> T buildXmlObject(Element element, Class<T> type) {
        try {
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(element);
            if (unmarshaller == null) {
                throw SamlUtils.samlException("XML element [{}] cannot be unmarshalled to SAML type [{}] (no unmarshaller)", element.getTagName(), type);
            }
            XMLObject object = unmarshaller.unmarshall(element);
            if (type.isInstance(object)) {
                return (T)((XMLObject)type.cast(object));
            }
            Object[] args = new Object[]{element.getTagName(), type.getName(), object == null ? "<null>" : object.getClass().getName()};
            throw SamlUtils.samlException("SAML object [{}] is incorrect type. Expected [{}] but was [{}]", args);
        }
        catch (UnmarshallingException e) {
            throw SamlUtils.samlException("Failed to unmarshall SAML content [{}", (Exception)((Object)e), element.getTagName());
        }
    }

    protected String text(XMLObject xml, int length) {
        Element dom = xml.getDOM();
        if (dom == null) {
            return null;
        }
        String text = dom.getTextContent().trim();
        if (text.length() >= length) {
            return Strings.cleanTruncate((String)text, (int)length) + "...";
        }
        return text;
    }

    protected Element parseSamlMessage(byte[] content) {
        Element root;
        try (ByteArrayInputStream input = new ByteArrayInputStream(content);){
            Document doc = THREAD_LOCAL_DOCUMENT_BUILDER.get().parse(input);
            root = doc.getDocumentElement();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Received SAML Message: {} \n", (Object)SamlUtils.toString(root, true));
            }
        }
        catch (IOException | SAXException e) {
            throw SamlUtils.samlException("Failed to parse SAML message", e, new Object[0]);
        }
        return root;
    }

    protected void validateNotOnOrAfter(DateTime notOnOrAfter) {
        if (notOnOrAfter == null) {
            return;
        }
        Instant now = this.now();
        Instant pastNow = now.minusMillis(this.maxSkew.millis());
        if (!pastNow.isBefore(this.toInstant(notOnOrAfter))) {
            throw SamlUtils.samlException("Rejecting SAML assertion because [{}] is on/after [{}]", pastNow, notOnOrAfter);
        }
    }

    private static /* synthetic */ Message lambda$checkIdpSignature$4(String signatureText, Credential credential, Exception e) {
        return new ParameterizedMessage("SAML Signature [{}] does not match credentials [{}] [{}] -- {}", new Object[]{signatureText, credential.getEntityId(), credential.getPublicKey(), e});
    }
}

