/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import org.flexdock.util.ResourceManager;

public class VSNetStartPage
extends JPanel {
    private Icon miscIcons;
    private Image tabsImg;
    private Color tabRunBG;
    private Color contentBG1;
    private Color contentBG2;
    private Color tableBG1;
    private Font labelFont;
    private JButton newProjButton;
    private JButton openProjButton;
    private JPanel tablePane;
    private JPanel contentPane;
    private JTabbedPane tabbedPane;

    public VSNetStartPage() {
        super(new BorderLayout(0, 0));
        this.init();
    }

    private void init() {
        this.initAttribs();
        this.newProjButton = new JButton("New Project");
        this.openProjButton = new JButton("Open Project");
        this.tablePane = this.createTablePane();
        this.contentPane = this.createContentPane();
        this.contentPane.add(this.tablePane);
        this.contentPane.add(this.newProjButton);
        this.contentPane.add(this.openProjButton);
        this.tabbedPane = this.createTabbedPane();
        this.tabbedPane.addTab("Start Page", this.contentPane);
        this.tabbedPane.setBorder(null);
        this.add((Component)this.tabbedPane, "Center");
        this.setBorder(new LineBorder(Color.GRAY, 1));
    }

    private void initAttribs() {
        this.miscIcons = ResourceManager.createIcon("org/flexdock/demos/view/ms_misc_icons001.png");
        this.tabsImg = ResourceManager.createImage("org/flexdock/demos/view/ms_tabs001.png");
        this.tabRunBG = new Color(247, 243, 233);
        this.contentBG1 = new Color(246, 246, 246);
        this.contentBG2 = new Color(102, 153, 204);
        this.tableBG1 = new Color(154, 154, 143);
        this.labelFont = new Font("Dialog", 1, 11);
    }

    private JPanel createTablePane() {
        return new JPanel(){

            protected void paintComponent(Graphics g) {
                g.setColor(VSNetStartPage.this.tableBG1);
                g.fillRect(0, 0, this.getWidth(), 20);
                g.setColor(VSNetStartPage.this.getBackground());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setColor(Color.BLACK);
                g.setFont(VSNetStartPage.this.labelFont);
                g.drawString("Name", 5, 15);
                g.drawString("Modified", 350, 15);
            }
        };
    }

    private JPanel createContentPane() {
        return new JPanel(null){

            public void doLayout() {
                int tableH = this.getHeight() - 120 - 55;
                tableH = Math.max(tableH, 25);
                VSNetStartPage.this.tablePane.setBounds(12, 120, 475, tableH);
                int buttonY = 120 + tableH + 18;
                Dimension d = VSNetStartPage.this.newProjButton.getPreferredSize();
                VSNetStartPage.this.newProjButton.setBounds(12, buttonY, d.width, d.height);
                VSNetStartPage.this.openProjButton.setBounds(24 + d.width, buttonY, ((VSNetStartPage)VSNetStartPage.this).openProjButton.getPreferredSize().width, d.height);
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int w = this.getWidth();
                Color origC = g.getColor();
                Font origF = g.getFont();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, this.getHeight());
                g.setColor(VSNetStartPage.this.contentBG1);
                g.fillRect(0, 0, w, 48);
                g.setColor(VSNetStartPage.this.contentBG2);
                g.fillRect(0, 48, w, 23);
                g.drawImage(VSNetStartPage.this.tabsImg, 0, 0, null, this);
                g.setColor(Color.BLACK);
                g.setFont(VSNetStartPage.this.labelFont);
                g.drawString("Open an Existing Project", 12, 100);
                g.setFont(origF);
                g.setColor(origC);
            }
        };
    }

    private JTabbedPane createTabbedPane() {
        return new JTabbedPane(1){

            protected void paintComponent(Graphics g) {
                Color orig = g.getColor();
                Rectangle tabBounds = this.getBoundsAt(0);
                int tabLowerY = tabBounds.y + tabBounds.height;
                g.setColor(VSNetStartPage.this.tabRunBG);
                g.fillRect(0, 0, this.getWidth(), tabLowerY);
                int iconX = this.getWidth() - VSNetStartPage.this.miscIcons.getIconWidth();
                int iconY = tabLowerY / 2 - VSNetStartPage.this.miscIcons.getIconHeight() / 2 + 1;
                VSNetStartPage.this.miscIcons.paintIcon(this, g, iconX, iconY);
                g.setColor(orig);
                super.paintComponent(g);
                g.setColor(Color.WHITE);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.drawRect(1, tabLowerY - 1, this.getWidth() - 3, this.getHeight() - tabLowerY - 1);
                g.setColor(orig);
            }
        };
    }

    public JButton getNewProjButton() {
        return this.newProjButton;
    }

    public JButton getOpenProjButton() {
        return this.openProjButton;
    }
}

