/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import javax.media.Format;
import javax.media.format.AudioFormat;

public class ElapseTime {
    public long value = 0L;

    public void setValue(long t) {
        this.value = t;
    }

    public long getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(int len, long ts, Format f2) {
        if (f2 instanceof AudioFormat) {
            long t = ((AudioFormat)f2).computeDuration(len);
            if (t > 0L) {
                this.value += t;
                return true;
            } else {
                if (ts <= 0L) return false;
                this.value = ts;
            }
            return true;
        } else {
            if (ts <= 0L) return false;
            this.value = ts;
        }
        return true;
    }

    public static long audioLenToTime(long len, AudioFormat af) {
        return af.computeDuration(len);
    }

    public static long audioTimeToLen(long duration, AudioFormat af) {
        long bytesPerSec;
        long units;
        if (af.getSampleSizeInBits() > 0) {
            units = af.getSampleSizeInBits() * af.getChannels();
            bytesPerSec = (long)((double)units * af.getSampleRate() / 8.0);
        } else if (af.getFrameSizeInBits() != -1 && af.getFrameRate() != -1.0) {
            units = af.getFrameSizeInBits();
            bytesPerSec = (long)((double)units * af.getFrameRate() / 8.0);
        } else {
            bytesPerSec = 0L;
            units = 0L;
        }
        return bytesPerSec == 0L ? 0L : duration * bytesPerSec / 1000000000L / units * units;
    }
}

