/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.restore.handlers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.state.DockingState;
import org.flexdock.perspective.RestorationManager;
import org.flexdock.perspective.restore.handlers.RestorationHandler;
import org.flexdock.util.NestedComponents;
import org.flexdock.util.RootWindow;

public class PointHandler
implements RestorationHandler,
DockingConstants {
    public boolean restore(Dockable dockable, DockingState dockingState, Map context) {
        if (DockingManager.isDocked(dockable)) {
            return false;
        }
        Component owner = RestorationManager.getRestoreContainer(dockable);
        return this.restoreDockable(dockable, owner, dockingState);
    }

    private boolean restoreDockable(Dockable dockable, Component win, DockingState dockingState) {
        RootWindow window = RootWindow.getRootContainer(win);
        Container contentPane = window.getContentPane();
        Point dropPoint = this.getDropPoint(dockable, contentPane, dockingState);
        if (dropPoint == null) {
            return false;
        }
        Component deep = SwingUtilities.getDeepestComponentAt(contentPane, dropPoint.x, dropPoint.y);
        NestedComponents dropTargets = NestedComponents.find(deep, Dockable.class, DockingPort.class);
        DockingPort port = dropTargets == null ? null : (DockingPort)((Object)dropTargets.parent);
        Point mousePoint = port == null ? null : SwingUtilities.convertPoint(contentPane, dropPoint, (Component)((Object)port));
        String region = port == null ? "UNKNOWN" : port.getRegion(mousePoint);
        return DockingManager.dock(dockable, port, region);
    }

    private Point getDropPoint(Dockable dockable, Container contentPane, DockingState dockingState) {
        if (!dockingState.hasCenterPoint()) {
            return null;
        }
        float percentX = (float)dockingState.getCenterX() / 100.0f;
        float percentY = (float)dockingState.getCenterY() / 100.0f;
        Point dropPoint = new Point();
        dropPoint.x = Math.round((float)contentPane.getWidth() * percentX);
        dropPoint.y = Math.round((float)contentPane.getHeight() * percentY);
        return dropPoint;
    }
}

