/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.theme;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.plaf.Configurator;
import org.flexdock.plaf.IFlexViewComponentUI;
import org.flexdock.plaf.PlafManager;
import org.flexdock.plaf.PropertySet;
import org.flexdock.plaf.XMLConstants;
import org.flexdock.plaf.theme.ButtonUI;
import org.flexdock.plaf.theme.Theme;
import org.flexdock.plaf.theme.TitlebarUI;
import org.flexdock.plaf.theme.ViewUI;
import org.w3c.dom.Element;

public class UIFactory
implements XMLConstants {
    private static Log log = LogFactory.getLog((Class)UIFactory.class);
    public static final String DEFAULT = "default";
    public static final String THEME_KEY = "theme";
    public static final String VIEW_KEY = "view-ui";
    public static final String TITLEBAR_KEY = "titlebar-ui";
    public static final String BUTTON_KEY = "button-ui";
    private static final HashMap VIEW_UI_CACHE = new HashMap();
    private static final HashMap TITLEBAR_UI_CACHE = new HashMap();
    private static final HashMap BUTTON_UI_CACHE = new HashMap();
    private static final HashMap THEME_UI_CACHE = new HashMap();

    public static ViewUI getViewUI(String name) {
        return (ViewUI)UIFactory.getUI(name, VIEW_UI_CACHE, VIEW_KEY, ViewUI.class);
    }

    public static ViewUI getViewUI(Properties p) {
        return (ViewUI)UIFactory.getUI(p, VIEW_UI_CACHE, VIEW_KEY, ViewUI.class);
    }

    public static TitlebarUI getTitlebarUI(String name) {
        return (TitlebarUI)UIFactory.getUI(name, TITLEBAR_UI_CACHE, TITLEBAR_KEY, TitlebarUI.class);
    }

    public static TitlebarUI getTitlebarUI(Properties p) {
        return (TitlebarUI)UIFactory.getUI(p, TITLEBAR_UI_CACHE, TITLEBAR_KEY, TitlebarUI.class);
    }

    public static ButtonUI getButtonUI(String name) {
        return (ButtonUI)UIFactory.getUI(name, BUTTON_UI_CACHE, BUTTON_KEY, ButtonUI.class);
    }

    public static ButtonUI getButtonUI(Properties p) {
        return (ButtonUI)UIFactory.getUI(p, BUTTON_UI_CACHE, BUTTON_KEY, ButtonUI.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme getTheme(String name) {
        if (Configurator.isNull(name)) {
            return null;
        }
        Theme theme = (Theme)THEME_UI_CACHE.get(name);
        if (theme == null && (theme = UIFactory.loadTheme(name)) != null) {
            HashMap hashMap = THEME_UI_CACHE;
            synchronized (hashMap) {
                THEME_UI_CACHE.put(name, theme);
            }
        }
        return theme;
    }

    private static IFlexViewComponentUI getUI(Properties p, HashMap cache, String tagName, Class rootClass) {
        if (p == null || !p.containsKey(tagName)) {
            return null;
        }
        String name = p.getProperty(tagName);
        return UIFactory.getUI(name, cache, tagName, rootClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IFlexViewComponentUI getUI(String name, HashMap cache, String tagName, Class rootClass) {
        if (Configurator.isNull(name)) {
            return null;
        }
        IFlexViewComponentUI ui = (IFlexViewComponentUI)cache.get(name);
        if (ui == null && (ui = UIFactory.loadUI(name, tagName, rootClass)) != null) {
            HashMap hashMap = cache;
            synchronized (hashMap) {
                cache.put(name, ui);
            }
        }
        return ui;
    }

    private static IFlexViewComponentUI loadUI(String name, String tagName, Class rootClass) {
        PropertySet properties = Configurator.getProperties(name, tagName);
        String classname = properties.getString("classname");
        Class implClass = UIFactory.loadUIClass(classname, rootClass);
        try {
            IFlexViewComponentUI ui = (IFlexViewComponentUI)implClass.newInstance();
            ui.setCreationParameters(properties);
            return ui;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Class loadUIClass(String classname, Class rootClass) {
        if (Configurator.isNull(classname)) {
            return rootClass;
        }
        Class<?> implClass = null;
        try {
            implClass = Class.forName(classname);
            if (!rootClass.isAssignableFrom(implClass)) {
                log.warn((Object)("Invalid UI class " + implClass + ".  Using '" + rootClass + "' instead."));
                implClass = null;
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Unable to load " + classname + ".  Using '" + rootClass + "' instead."), (Throwable)e);
            implClass = null;
        }
        return implClass == null ? rootClass : implClass;
    }

    private static Theme loadTheme(String themeName) {
        HashMap map = Configurator.getNamedElementsByTagName(THEME_KEY);
        if (map == null) {
            return null;
        }
        return UIFactory.loadTheme(themeName, map);
    }

    private static Theme loadTheme(String themeName, HashMap cache) {
        Theme theme;
        Element themeElem = (Element)cache.get(themeName);
        if (themeElem == null) {
            return null;
        }
        String redirect = themeElem.getAttribute("ref");
        if (!Configurator.isNull(redirect)) {
            return UIFactory.loadTheme(redirect, cache);
        }
        String parentName = themeElem.getAttribute("extends");
        Theme theme2 = theme = Configurator.isNull(parentName) ? new Theme() : UIFactory.loadTheme(parentName, cache);
        if (theme == null) {
            theme = new Theme();
        }
        String name = themeElem.getAttribute("name");
        String desc = themeElem.getAttribute("description");
        String view = themeElem.getAttribute(VIEW_KEY);
        theme.setName(name);
        theme.setDescription(desc);
        ViewUI viewUI = Configurator.isNull(view) ? UIFactory.getViewUI(DEFAULT) : UIFactory.getViewUI(view);
        TitlebarUI titlebarUI = viewUI == null ? UIFactory.getTitlebarUI(DEFAULT) : UIFactory.getTitlebarUI(viewUI.getPreferredTitlebarUI());
        ButtonUI buttonUI = titlebarUI == null ? UIFactory.getButtonUI(DEFAULT) : UIFactory.getButtonUI(titlebarUI.getPreferredButtonUI());
        theme.setViewUI(viewUI);
        theme.setTitlebarUI(titlebarUI);
        theme.setButtonUI(buttonUI);
        return theme;
    }

    public static Theme createTheme(Properties p) {
        ButtonUI button;
        TitlebarUI titlebar;
        if (p == null) {
            return null;
        }
        Theme base = UIFactory.getTheme(PlafManager.getSystemThemeName());
        ViewUI view = UIFactory.getViewUI(p);
        if (view == null) {
            view = base.getViewUI();
        }
        if (view == null) {
            view = UIFactory.getViewUI(DEFAULT);
        }
        if ((titlebar = UIFactory.getTitlebarUI(p)) == null) {
            titlebar = UIFactory.getTitlebarUI(view.getPreferredTitlebarUI());
        }
        if (titlebar == null) {
            titlebar = base.getTitlebarUI();
        }
        if (titlebar == null) {
            titlebar = UIFactory.getTitlebarUI(DEFAULT);
        }
        if ((button = UIFactory.getButtonUI(p)) == null) {
            button = UIFactory.getButtonUI(titlebar.getPreferredButtonUI());
        }
        if (button == null) {
            button = base.getButtonUI();
        }
        if (button == null) {
            button = UIFactory.getButtonUI(DEFAULT);
        }
        Theme theme = new Theme();
        theme.setName(p.getProperty("name", "custom"));
        theme.setDescription(p.getProperty("description", "Custom Theme"));
        theme.setViewUI(view);
        theme.setTitlebarUI(titlebar);
        theme.setButtonUI(button);
        return theme;
    }
}

