//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _D109_WPT_TYPE_H
#define _D109_WPT_TYPE_H

#include "wpt_type.h"
#include "packet.h"
#include "endianmess.h"
#include "newsymbols.h"


#include <iomanip>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


// garmin d109 waypoint type class
class D109_Wpt_Type : public Wpt_Type, Endianmess, NewSymbols
{
   public:

      virtual ~D109_Wpt_Type(){}

      virtual void set(Packet);

      virtual Packet makePacket(void);

   protected:

   private:
#if 0
      char ident[6]; /* identifier */                     // 0-5
      g_long lat;                                         // 6-9   
      g_long lon;                                         // 10-13
      g_longword unused; /* should be set to zero */      // 14-17   
      char cmnt[40]; /* comment */                        // 18-57
      g_byte smbl; /* symbol id */                        // 58
      g_byte dspl; /* display option */                   // 59
#endif 

};

}

#endif 
