/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.deserializer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import jd.core.loader.Loader;
import jd.core.loader.LoaderException;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.Attribute;
import jd.core.model.classfile.attribute.AttributeInnerClasses;
import jd.core.model.classfile.attribute.InnerClass;
import jd.core.model.classfile.constant.Constant;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantDouble;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantFloat;
import jd.core.model.classfile.constant.ConstantInteger;
import jd.core.model.classfile.constant.ConstantInterfaceMethodref;
import jd.core.model.classfile.constant.ConstantLong;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.classfile.constant.ConstantString;
import jd.core.model.classfile.constant.ConstantUtf8;
import jd.core.process.deserializer.AttributeDeserializer;
import jd.core.process.deserializer.ClassFormatException;

public class ClassFileDeserializer {
    public static ClassFile Deserialize(Loader loader, String internalClassPath) throws LoaderException {
        ClassFile classFile = ClassFileDeserializer.LoadSingleClass(loader, internalClassPath);
        if (classFile == null) {
            return null;
        }
        AttributeInnerClasses aics = classFile.getAttributeInnerClasses();
        if (aics == null) {
            return classFile;
        }
        String internalClassPathPrefix = internalClassPath.substring(0, internalClassPath.length() - ".class".length());
        String innerInternalClassNamePrefix = String.valueOf(internalClassPathPrefix) + '$';
        ConstantPool constants = classFile.getConstantPool();
        InnerClass[] cs = aics.classes;
        int length = cs.length;
        ArrayList<ClassFile> innerClassFiles = new ArrayList<ClassFile>(length);
        int i = 0;
        while (i < length) {
            String tmpInnerInternalClassPath;
            int offsetInternalInnerSeparator;
            String innerInternalClassPath = constants.getConstantClassName(cs[i].inner_class_index);
            if (innerInternalClassPath.startsWith(innerInternalClassNamePrefix) && ((offsetInternalInnerSeparator = innerInternalClassPath.indexOf(36, innerInternalClassNamePrefix.length())) == -1 || !loader.canLoad(tmpInnerInternalClassPath = String.valueOf(innerInternalClassPath.substring(0, offsetInternalInnerSeparator)) + ".class"))) {
                try {
                    ClassFile innerClassFile = ClassFileDeserializer.Deserialize(loader, String.valueOf(innerInternalClassPath) + ".class");
                    if (innerClassFile != null) {
                        innerClassFile.setAccessFlags(cs[i].inner_access_flags);
                        innerClassFile.setOuterClass(classFile);
                        innerClassFiles.add(innerClassFile);
                    }
                }
                catch (LoaderException loaderException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (innerClassFiles != null) {
            classFile.setInnerClassFiles(innerClassFiles);
        }
        return classFile;
    }

    private static ClassFile LoadSingleClass(Loader loader, String internalClassPath) throws LoaderException {
        ClassFile classFile;
        block13: {
            DataInputStream dis = null;
            classFile = null;
            try {
                try {
                    dis = loader.load(internalClassPath);
                    if (dis != null) {
                        classFile = ClassFileDeserializer.Deserialize(dis);
                    }
                }
                catch (IOException e) {
                    classFile = null;
                    if (dis == null) break block13;
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return classFile;
    }

    private static ClassFile Deserialize(DataInput di) throws IOException {
        ClassFileDeserializer.CheckMagic(di);
        int minor_version = di.readUnsignedShort();
        int major_version = di.readUnsignedShort();
        Constant[] constants = ClassFileDeserializer.DeserializeConstants(di);
        ConstantPool constantPool = new ConstantPool(constants);
        int access_flags = di.readUnsignedShort();
        int this_class = di.readUnsignedShort();
        int super_class = di.readUnsignedShort();
        int[] interfaces = ClassFileDeserializer.DeserializeInterfaces(di);
        Field[] fieldInfos = ClassFileDeserializer.DeserializeFields(di, constantPool);
        Method[] methodInfos = ClassFileDeserializer.DeserializeMethods(di, constantPool);
        Attribute[] attributeInfos = AttributeDeserializer.Deserialize(di, constantPool);
        return new ClassFile(minor_version, major_version, constantPool, access_flags, this_class, super_class, interfaces, fieldInfos, methodInfos, attributeInfos);
    }

    private static Constant[] DeserializeConstants(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Constant[] constants = new Constant[count];
        int i = 1;
        while (i < count) {
            byte tag = di.readByte();
            switch (tag) {
                case 7: {
                    constants[i] = new ConstantClass(tag, di.readUnsignedShort());
                    break;
                }
                case 9: {
                    constants[i] = new ConstantFieldref(tag, di.readUnsignedShort(), di.readUnsignedShort());
                    break;
                }
                case 10: {
                    constants[i] = new ConstantMethodref(tag, di.readUnsignedShort(), di.readUnsignedShort());
                    break;
                }
                case 11: {
                    constants[i] = new ConstantInterfaceMethodref(tag, di.readUnsignedShort(), di.readUnsignedShort());
                    break;
                }
                case 8: {
                    constants[i] = new ConstantString(tag, di.readUnsignedShort());
                    break;
                }
                case 3: {
                    constants[i] = new ConstantInteger(tag, di.readInt());
                    break;
                }
                case 4: {
                    constants[i] = new ConstantFloat(tag, di.readFloat());
                    break;
                }
                case 5: {
                    constants[i++] = new ConstantLong(tag, di.readLong());
                    break;
                }
                case 6: {
                    constants[i++] = new ConstantDouble(tag, di.readDouble());
                    break;
                }
                case 12: {
                    constants[i] = new ConstantNameAndType(tag, di.readUnsignedShort(), di.readUnsignedShort());
                    break;
                }
                case 1: {
                    constants[i] = new ConstantUtf8(tag, di.readUTF());
                    break;
                }
                default: {
                    throw new ClassFormatException("Invalid constant pool entry");
                }
            }
            ++i;
        }
        return constants;
    }

    private static int[] DeserializeInterfaces(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        int[] interfaces = new int[count];
        int i = 0;
        while (i < count) {
            interfaces[i] = di.readUnsignedShort();
            ++i;
        }
        return interfaces;
    }

    private static Field[] DeserializeFields(DataInput di, ConstantPool constantPool) throws IOException {
        int count = di.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Field[] fieldInfos = new Field[count];
        int i = 0;
        while (i < count) {
            fieldInfos[i] = new Field(di.readUnsignedShort(), di.readUnsignedShort(), di.readUnsignedShort(), AttributeDeserializer.Deserialize(di, constantPool));
            ++i;
        }
        return fieldInfos;
    }

    private static Method[] DeserializeMethods(DataInput di, ConstantPool constants) throws IOException {
        int count = di.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Method[] methodInfos = new Method[count];
        int i = 0;
        while (i < count) {
            methodInfos[i] = new Method(di.readUnsignedShort(), di.readUnsignedShort(), di.readUnsignedShort(), AttributeDeserializer.Deserialize(di, constants));
            ++i;
        }
        return methodInfos;
    }

    private static void CheckMagic(DataInput di) throws IOException {
        int magic = di.readInt();
        if (magic != -889275714) {
            throw new ClassFormatException("Invalid Java .class file");
        }
    }
}

