/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;

public class Open
extends IQ {
    public static final String ELEMENT = "open";
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    private final String sessionID;
    private final int blockSize;
    private final InBandBytestreamManager.StanzaType stanza;

    public Open(String sessionID, int blockSize, InBandBytestreamManager.StanzaType stanza) {
        super(ELEMENT, NAMESPACE);
        if (sessionID == null || "".equals(sessionID)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size must be greater than zero");
        }
        this.sessionID = sessionID;
        this.blockSize = blockSize;
        this.stanza = stanza;
        this.setType(IQ.Type.set);
    }

    public Open(String sessionID, int blockSize) {
        this(sessionID, blockSize, InBandBytestreamManager.StanzaType.IQ);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public InBandBytestreamManager.StanzaType getStanza() {
        return this.stanza;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.attribute("block-size", Integer.toString(this.blockSize));
        xml.attribute("sid", this.sessionID);
        xml.attribute("stanza", this.stanza.toString().toLowerCase(Locale.US));
        xml.setEmptyElement();
        return xml;
    }
}

