/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.ParticipantProperties;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH&J2\u0010\u000e\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ<\u0010\u000f\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u0012\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J2\u0010\u0013\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ8\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J2\u0010\u0017\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u0018\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ<\u0010\u0019\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u001a\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u001b\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u001c\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J<\u0010\u001d\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u001f*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nH\u0002J \u0010!\u001a\u00020\u001f*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "doSelect", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridges", "", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "leastLoaded", "leastLoadedAlreadyInConferenceInRegion", "desiredRegion", "", "leastLoadedInRegion", "leastLoadedNotMaxedAlreadyInConference", "logSelection", "", "bridge", "notLoaded", "notLoadedAlreadyInConference", "notLoadedAlreadyInConferenceInRegion", "notLoadedAlreadyInConferenceInRegionGroup", "notLoadedInRegion", "notLoadedInRegionGroup", "select", "allowMultiBridge", "", "hasMaxParticipantsInConference", "isOverloaded", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nBridgeSelectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeSelectionStrategy.kt\norg/jitsi/jicofo/bridge/BridgeSelectionStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n819#2:334\n847#2,2:335\n288#2,2:337\n819#2:339\n847#2,2:340\n288#2,2:342\n819#2:344\n847#2,2:345\n288#2,2:347\n819#2:349\n847#2,2:350\n288#2,2:352\n288#2,2:354\n288#2,2:356\n288#2,2:358\n288#2,2:360\n819#2:362\n847#2,2:363\n*S KotlinDebug\n*F\n+ 1 BridgeSelectionStrategy.kt\norg/jitsi/jicofo/bridge/BridgeSelectionStrategy\n*L\n97#1:334\n97#1:335,2\n99#1:337,2\n114#1:339\n114#1:340,2\n116#1:342,2\n154#1:344\n154#1:345,2\n155#1:347,2\n170#1:349\n170#1:350,2\n171#1:352,2\n183#1:354,2\n210#1:356,2\n224#1:358,2\n247#1:360,2\n269#1:362\n269#1:363,2\n*E\n"})
public abstract class BridgeSelectionStrategy {
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);

    @Nullable
    public Bridge select(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, boolean allowMultiBridge) {
        Bridge bridge2;
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        if (conferenceBridges.isEmpty()) {
            Bridge bridge3 = this.doSelect(bridges, conferenceBridges, participantProperties);
            if (bridge3 != null) {
                this.logger.info((Object)("Selected initial bridge " + bridge3 + " with reported stress=" + bridge3.getLastReportedStressLevel() + " for participantProperties=" + participantProperties));
            } else {
                this.logger.warn((Object)("Failed to select initial bridge for participantProperties=" + participantProperties));
            }
            bridge2 = bridge3;
        } else {
            Bridge existingBridge = (Bridge)CollectionsKt.first((Iterable)conferenceBridges.keySet());
            if (!allowMultiBridge || existingBridge.getRelayId() == null) {
                this.logger.info((Object)"Existing bridge does not have a relay, will not consider other bridges.");
                return existingBridge;
            }
            Bridge bridge4 = this.doSelect(bridges, conferenceBridges, participantProperties);
            if (bridge4 != null) {
                this.logger.info((Object)("Selected bridge " + bridge4 + " with stress=" + bridge4.getLastReportedStressLevel() + " for participantProperties=" + participantProperties));
            } else {
                this.logger.warn((Object)("Failed to select bridge for participantProperties=" + participantProperties));
            }
            bridge2 = bridge4;
        }
        return bridge2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedAlreadyInConferenceInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default((String)it.getRegion(), (String)desiredRegion, (boolean)false, (int)2, null))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedAlreadyInConferenceInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Set<String> regionGroup = BridgeConfig.config.getRegionGroup(desiredRegion);
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, (Object)it.getRegion())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    private final void logSelection(Bridge bridge2, Map<Bridge, ConferenceBridgeProperties> conferenceBridges, ParticipantProperties participantProperties, String desiredRegion) {
        String method = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.logger.debug(() -> BridgeSelectionStrategy.logSelection$lambda$4(method, desiredRegion, participantProperties, bridge2, conferenceBridges));
    }

    static /* synthetic */ void logSelection$default(BridgeSelectionStrategy bridgeSelectionStrategy, Bridge bridge2, Map map, ParticipantProperties participantProperties, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logSelection");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        bridgeSelectionStrategy.logSelection(bridge2, map, participantProperties, string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default((String)it.getRegion(), (String)desiredRegion, (boolean)false, (int)2, null))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Set<String> regionGroup = BridgeConfig.config.getRegionGroup(desiredRegion);
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, (Object)it.getRegion())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    @Nullable
    public final Bridge notLoaded(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable $this$firstOrNull$iv = bridges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(!it.isOverloaded())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedAlreadyInConferenceInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable iterable = CollectionsKt.intersect((Iterable)bridges, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default((String)it.getRegion(), (String)desiredRegion, (boolean)false, (int)2, null))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedNotMaxedAlreadyInConference(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable iterable = CollectionsKt.intersect((Iterable)bridges, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(!this.hasMaxParticipantsInConference(it, conferenceBridges))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
            Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default((String)it.getRegion(), (String)desiredRegion, (boolean)false, (int)2, null))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedAlreadyInConference(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        Iterable iterable = bridges;
        boolean $i$f$filterNot = false;
        void var7_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Bridge it = (Bridge)element$iv$iv;
            boolean bl = false;
            if (this.isOverloaded(it, conferenceBridges)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Bridge result = (Bridge)CollectionsKt.firstOrNull((Iterable)CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)conferenceBridges.keySet()));
        if (result != null) {
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    @Nullable
    public final Bridge leastLoaded(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        Bridge result = (Bridge)CollectionsKt.firstOrNull(bridges);
        if (result != null) {
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    @Nullable
    public abstract Bridge doSelect(@NotNull List<Bridge> var1, @NotNull Map<Bridge, ConferenceBridgeProperties> var2, @NotNull ParticipantProperties var3);

    private final boolean isOverloaded(Bridge $this$isOverloaded, Map<Bridge, ConferenceBridgeProperties> conferenceBridges) {
        return $this$isOverloaded.isOverloaded() || this.hasMaxParticipantsInConference($this$isOverloaded, conferenceBridges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMaxParticipantsInConference(Bridge $this$hasMaxParticipantsInConference, Map<Bridge, ConferenceBridgeProperties> conferenceBridges) {
        if (BridgeConfig.config.getMaxBridgeParticipants() <= 0) return false;
        if (!conferenceBridges.containsKey($this$hasMaxParticipantsInConference)) return false;
        ConferenceBridgeProperties conferenceBridgeProperties = conferenceBridges.get($this$hasMaxParticipantsInConference);
        Intrinsics.checkNotNull((Object)conferenceBridgeProperties);
        if (conferenceBridgeProperties.getParticipantCount() < BridgeConfig.config.getMaxBridgeParticipants()) return false;
        return true;
    }

    private static final String logSelection$lambda$4(String $method, String $desiredRegion, ParticipantProperties $participantProperties, Bridge $bridge, Map $conferenceBridges) {
        Intrinsics.checkNotNullParameter((Object)$participantProperties, (String)"$participantProperties");
        Intrinsics.checkNotNullParameter((Object)$bridge, (String)"$bridge");
        Intrinsics.checkNotNullParameter((Object)$conferenceBridges, (String)"$conferenceBridges");
        return "Bridge selected: method=" + $method + ", desiredRegion=" + $desiredRegion + ", participantProperties=" + $participantProperties + ", bridge=" + $bridge + ", conference_bridges=" + CollectionsKt.joinToString$default((Iterable)$conferenceBridges.keySet(), null, null, null, (int)0, null, null, (int)63, null);
    }
}

