/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimatorConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.BitrateProber;
import org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcNetworkController;
import org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcNetworkControllerFactory;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkAvailability;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControlUpdate;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControllerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControllerInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacedPacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeClusterConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProcessInterval;
import org.jitsi.nlj.rtp.bandwidthestimation2.RoundTripTimeUpdate;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacket;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.TargetRateConstraints;
import org.jitsi.nlj.rtp.bandwidthestimation2.TargetTransferRate;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportFeedbackAdapter;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportLossReport;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportPacketsFeedback;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 I2\u00020\u0001:\u0003HIJBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\t\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u001e\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020*2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\u0018\u00107\u001a\u00020#2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020-H\u0016J\u0018\u0010;\u001a\u00020#2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020-H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020#2\u0006\u0010?\u001a\u00020!H\u0016J\b\u0010A\u001a\u00020#H\u0016J\b\u0010B\u001a\u00020#H\u0016J\u0010\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\n 0*\u0004\u0018\u00010*0*X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00101\u00a8\u0006K"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine;", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "sendProbing", "Lkotlin/Function2;", "Lorg/jitsi/nlj/util/DataSize;", "", "", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function2;Ljava/time/Clock;)V", "getDiagnosticContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "getClock", "()Ljava/time/Clock;", "logger", "feedbackAdapter", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter;", "networkController", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControllerInterface;", "bitrateProber", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber;", "probeTask", "Ljava/util/concurrent/ScheduledFuture;", "processTask", "listeners", "Ljava/util/LinkedList;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "onRttUpdate", "", "rtt", "Ljava/time/Duration;", "rtcpPacketReceived", "rtcpPacket", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "Ljava/time/Instant;", "lastReportBlocks", "Ljava/util/HashMap;", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine$LossReport;", "lastReportBlockTime", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "onReport", "receiveTime", "reportBlocks", "", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "mediaPacketTagged", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "tccSeqNum", "mediaPacketSent", "getStatistics", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine$StatisticsSnapshot;", "addBandwidthListener", "listener", "removeBandwidthListener", "start", "stop", "processUpdate", "update", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControlUpdate;", "maybeScheduleProbing", "now", "LossReport", "Companion", "StatisticsSnapshot", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nGoogCcTransportCcEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogCcTransportCcEngine.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,368:1\n1863#2:369\n1863#2,2:370\n1864#2:372\n1863#2,2:373\n1863#2,2:375\n1863#2,2:377\n68#3,6:379\n68#3,6:385\n68#3,6:391\n*S KotlinDebug\n*F\n+ 1 GoogCcTransportCcEngine.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine\n*L\n98#1:369\n99#1:370,2\n98#1:372\n148#1:373,2\n270#1:375,2\n285#1:377,2\n344#1:379,6\n347#1:385,6\n350#1:391,6\n*E\n"})
public final class GoogCcTransportCcEngine
extends TransportCcEngine {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final ScheduledExecutorService scheduledExecutor;
    @NotNull
    private final Function2<DataSize, Object, Integer> sendProbing;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TransportFeedbackAdapter feedbackAdapter;
    @NotNull
    private final NetworkControllerInterface networkController;
    @NotNull
    private final BitrateProber bitrateProber;
    @Nullable
    private ScheduledFuture<?> probeTask;
    @Nullable
    private ScheduledFuture<?> processTask;
    @NotNull
    private final LinkedList<TransportCcEngine.BandwidthListener> listeners;
    @NotNull
    private final HashMap<Long, LossReport> lastReportBlocks;
    private Instant lastReportBlockTime;
    @NotNull
    private static final GoogCcNetworkControllerFactory factory;
    private static final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private static final ConfigDelegate<Duration> defaultRateTrackerWindowSize$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> defaultRateTrackerBucketSize$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> defaultInitialIgnoreBwePeriod$delegate;

    public GoogCcTransportCcEngine(@NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, @NotNull ScheduledExecutorService scheduledExecutor, @NotNull Function2<? super DataSize, Object, Integer> sendProbing, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(scheduledExecutor, "scheduledExecutor");
        Intrinsics.checkNotNullParameter(sendProbing, "sendProbing");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.diagnosticContext = diagnosticContext;
        this.scheduledExecutor = scheduledExecutor;
        this.sendProbing = sendProbing;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.feedbackAdapter = new TransportFeedbackAdapter(this.logger);
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        Instant instant2 = instant;
        long l = BandwidthEstimatorConfig.Companion.getInitBw-rlWvAKk();
        long l2 = BandwidthEstimatorConfig.Companion.getMaxBw-rlWvAKk();
        long l3 = BandwidthEstimatorConfig.Companion.getMinBw-rlWvAKk();
        this.networkController = factory.create(new NetworkControllerConfig(this.logger, this.diagnosticContext, new TargetRateConstraints(instant2, Bandwidth.box-impl(l3), Bandwidth.box-impl(l2), Bandwidth.box-impl(l), null), null, 8, null));
        this.bitrateProber = new BitrateProber(this.logger, null, 2, null);
        this.listeners = new LinkedList();
        this.lastReportBlocks = new HashMap();
        this.lastReportBlockTime = this.clock.instant();
    }

    public /* synthetic */ GoogCcTransportCcEngine(DiagnosticContext diagnosticContext, Logger logger, ScheduledExecutorService scheduledExecutorService, Function2 function2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x10) != 0) {
            clock = Clock.systemUTC();
        }
        this(diagnosticContext, logger, scheduledExecutorService, function2, clock);
    }

    @NotNull
    public final DiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    public synchronized void onRttUpdate(@NotNull Duration rtt) {
        Intrinsics.checkNotNullParameter(rtt, "rtt");
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        NetworkControlUpdate update = this.networkController.onRoundTripTimeUpdate(new RoundTripTimeUpdate(instant, rtt, false, 4, null));
        this.processUpdate(update);
    }

    @Override
    public synchronized void rtcpPacketReceived(@NotNull RtcpPacket rtcpPacket, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
        RtcpPacket rtcpPacket2 = rtcpPacket;
        if (rtcpPacket2 instanceof RtcpFbTccPacket) {
            Instant instant = receivedTime;
            if (instant == null) {
                instant = this.clock.instant();
            }
            Instant time = instant;
            RtcpFbTccPacket rtcpFbTccPacket = (RtcpFbTccPacket)rtcpPacket;
            Intrinsics.checkNotNull(time);
            TransportPacketsFeedback feedback = this.feedbackAdapter.processTransportFeedback(rtcpFbTccPacket, time);
            if (feedback != null) {
                NetworkControlUpdate update = this.networkController.onTransportPacketsFeedback(feedback);
                this.processUpdate(update);
                Iterable $this$forEach$iv = feedback.getPacketFeedbacks();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PacketResult fb = (PacketResult)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = this.getLossListeners();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        LossListener l = (LossListener)element$iv2;
                        boolean bl2 = false;
                        if (fb.isReceived()) {
                            l.packetReceived(fb.getPreviouslyReportedLost());
                            continue;
                        }
                        if (fb.getPreviouslyReportedLost()) continue;
                        l.packetLost(1);
                    }
                }
            }
        } else if (!(rtcpPacket2 instanceof RtcpFbRembPacket)) {
            if (rtcpPacket2 instanceof RtcpSrPacket) {
                Instant instant = receivedTime;
                if (instant == null) {
                    instant = this.clock.instant();
                }
                Instant time = instant;
                Intrinsics.checkNotNull(time);
                this.onReport(time, ((RtcpSrPacket)rtcpPacket).getReportBlocks());
            } else if (rtcpPacket2 instanceof RtcpRrPacket) {
                Instant instant = receivedTime;
                if (instant == null) {
                    instant = this.clock.instant();
                }
                Instant time = instant;
                Intrinsics.checkNotNull(time);
                this.onReport(time, ((RtcpRrPacket)rtcpPacket).getReportBlocks());
            }
        }
    }

    private final void onReport(Instant receiveTime, List<RtcpReportBlock> reportBlocks) {
        if (reportBlocks.isEmpty()) {
            return;
        }
        long totalPacketsLostDelta = 0L;
        long totalPacketsDelta = 0L;
        Iterable $this$forEach$iv = reportBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LossReport lossReport;
            RtcpReportBlock reportBlock = (RtcpReportBlock)element$iv;
            boolean bl = false;
            LossReport newLossReport = new LossReport();
            LossReport lastLossReport = this.lastReportBlocks.putIfAbsent(reportBlock.getSsrc(), newLossReport);
            if (lastLossReport != null) {
                totalPacketsDelta += reportBlock.getExtendedHighestSeqNum() - lastLossReport.getExtendedHighestSequenceNumber();
                totalPacketsLostDelta += (long)(reportBlock.getCumulativePacketsLost() - lastLossReport.getCumulativeLost());
            }
            if ((lossReport = lastLossReport) == null) {
                lossReport = newLossReport;
            }
            LossReport lossReport2 = lossReport;
            lossReport2.setExtendedHighestSequenceNumber(reportBlock.getExtendedHighestSeqNum());
            lossReport2.setCumulativeLost(reportBlock.getCumulativePacketsLost());
        }
        if (totalPacketsDelta == 0L) {
            return;
        }
        long packetsReceivedDelta = totalPacketsDelta - totalPacketsLostDelta;
        if (packetsReceivedDelta < 1L) {
            return;
        }
        long element$iv = totalPacketsLostDelta;
        Instant instant = this.lastReportBlockTime;
        Intrinsics.checkNotNullExpressionValue(instant, "lastReportBlockTime");
        Instant instant2 = instant;
        TransportLossReport msg = new TransportLossReport(receiveTime, instant2, receiveTime, element$iv, packetsReceivedDelta);
        NetworkControlUpdate update = this.networkController.onTransportLossReport(msg);
        this.processUpdate(update);
        this.lastReportBlockTime = receiveTime;
    }

    @Override
    public synchronized void mediaPacketTagged(@NotNull org.jitsi.nlj.PacketInfo packetInfo, long tccSeqNum) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Instant now = this.clock.instant();
        DataSize length = DataSizeKt.getBytes(packetInfo.getPacket().length);
        Object object = packetInfo.getProbingInfo();
        PacedPacketInfo pacedPacketInfo = object instanceof PacedPacketInfo ? (PacedPacketInfo)object : null;
        DataSize dataSize = DataSize.Companion.getZERO();
        Intrinsics.checkNotNull(now);
        this.feedbackAdapter.addPacket(packetInfo, tccSeqNum, dataSize, now);
        if (pacedPacketInfo == null) {
            this.bitrateProber.onIncomingPacket(length);
        }
        this.maybeScheduleProbing(now);
    }

    @Override
    public synchronized void mediaPacketSent(@NotNull org.jitsi.nlj.PacketInfo packetInfo, long tccSeqNum) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Instant now = this.clock.instant();
        long length = packetInfo.getPacket().length;
        Intrinsics.checkNotNull(now);
        SentPacketInfo sentPacketInfo = new SentPacketInfo(tccSeqNum, now, new PacketInfo(true, true, length));
        SentPacket sentPacket = this.feedbackAdapter.processSentPacket(sentPacketInfo);
        if (sentPacket != null) {
            NetworkControlUpdate update = this.networkController.onSentPacket(sentPacket);
            this.processUpdate(update);
        }
    }

    @Override
    @NotNull
    public synchronized StatisticsSnapshot getStatistics() {
        Instant now = this.clock.instant();
        TransportFeedbackAdapter.StatisticsSnapshot statisticsSnapshot = this.feedbackAdapter.getStatisitics();
        NetworkControllerInterface networkControllerInterface = this.networkController;
        Intrinsics.checkNotNull(networkControllerInterface, "null cannot be cast to non-null type org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcNetworkController");
        GoogCcNetworkController googCcNetworkController = (GoogCcNetworkController)networkControllerInterface;
        Intrinsics.checkNotNull(now);
        return new StatisticsSnapshot(statisticsSnapshot, googCcNetworkController.getStatistics(now));
    }

    @Override
    public synchronized void addBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void start() {
        Instant startTime = this.clock.instant();
        Ref.ObjectRef update = new Ref.ObjectRef();
        Intrinsics.checkNotNull(startTime);
        update.element = this.networkController.onNetworkAvailability(new NetworkAvailability(startTime, true));
        this.processUpdate((NetworkControlUpdate)update.element);
        update.element = this.networkController.onProcessInterval(new ProcessInterval(startTime, null, 2, null));
        this.processUpdate((NetworkControlUpdate)update.element);
        long processInterval = factory.getProcessInterval().toMillis();
        this.processTask = this.scheduledExecutor.scheduleAtFixedRate(() -> GoogCcTransportCcEngine.start$lambda$4(this, update), processInterval, processInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void stop() {
        block1: {
            this.bitrateProber.setEnabled(false);
            ScheduledFuture<?> scheduledFuture = this.probeTask;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            ScheduledFuture<?> scheduledFuture2 = this.processTask;
            if (scheduledFuture2 == null) break block1;
            scheduledFuture2.cancel(false);
        }
    }

    private final void processUpdate(NetworkControlUpdate update) {
        TargetTransferRate targetTransferRate = update.getTargetRate();
        if (targetTransferRate != null) {
            TargetTransferRate targetRate = targetTransferRate;
            boolean bl = false;
            this.logger.debug(() -> GoogCcTransportCcEngine.processUpdate$lambda$7$lambda$5(targetRate));
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransportCcEngine.BandwidthListener it = (TransportCcEngine.BandwidthListener)element$iv;
                boolean bl2 = false;
                it.bandwidthEstimationChanged-_2icLw0(targetRate.getTargetRate-rlWvAKk());
            }
        }
        DataSize dataSize = update.getCongestionWindow();
        if (dataSize != null) {
            DataSize congestionWindow = dataSize;
            boolean bl = false;
            this.logger.trace(() -> GoogCcTransportCcEngine.processUpdate$lambda$9$lambda$8(congestionWindow));
        }
        PacerConfig pacerConfig = update.getPacerConfig();
        if (pacerConfig != null) {
            PacerConfig pacerConfig2 = pacerConfig;
            boolean bl = false;
            this.logger.trace(() -> GoogCcTransportCcEngine.processUpdate$lambda$11$lambda$10(pacerConfig2));
        }
        List<ProbeClusterConfig> configs = update.getProbeClusterConfigs();
        boolean bl = false;
        if (!((Collection)configs).isEmpty()) {
            this.logger.debug(() -> GoogCcTransportCcEngine.processUpdate$lambda$14$lambda$12(configs));
            Iterable $this$forEach$iv = configs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProbeClusterConfig config = (ProbeClusterConfig)element$iv;
                boolean bl3 = false;
                this.bitrateProber.createProbeCluster(config);
            }
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
            this.maybeScheduleProbing(instant);
        }
        if (timeSeriesLogger.isTraceEnabled() && update.isNotEmpty()) {
            Instant instant = update.getAtTime();
            if (instant == null) {
                instant = this.clock.instant();
            }
            Instant now = instant;
            NetworkControllerInterface networkControllerInterface = this.networkController;
            Intrinsics.checkNotNull(networkControllerInterface, "null cannot be cast to non-null type org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcNetworkController");
            GoogCcNetworkController googCcNetworkController = (GoogCcNetworkController)networkControllerInterface;
            Intrinsics.checkNotNull(now);
            GoogCcNetworkController.StatisticsSnapshot stats = googCcNetworkController.getStatistics(now);
            DiagnosticContext.TimeSeriesPoint statsPoint = this.diagnosticContext.makeTimeSeriesPoint("goog_cc_stats", now);
            Intrinsics.checkNotNull(statsPoint);
            stats.addToTimeSeriesPoint(statsPoint);
            timeSeriesLogger.trace(statsPoint);
            DiagnosticContext.TimeSeriesPoint updatePoint = this.diagnosticContext.makeTimeSeriesPoint("goog_cc_update", now);
            Intrinsics.checkNotNull(updatePoint);
            update.addToTimeSeriesPoint(updatePoint);
            timeSeriesLogger.trace(updatePoint);
        }
    }

    private final void maybeScheduleProbing(Instant now) {
        if (this.bitrateProber.isProbing() && this.probeTask == null) {
            Instant nextProbeTime = this.bitrateProber.nextProbeTime(now);
            if (Intrinsics.areEqual(nextProbeTime, Instant.MAX)) {
                return;
            }
            long delay = Intrinsics.areEqual(nextProbeTime, Instant.MIN) ? 0L : RangesKt.coerceAtLeast(Duration.between(now, nextProbeTime).toMillis(), 0L);
            this.probeTask = this.scheduledExecutor.schedule(() -> GoogCcTransportCcEngine.maybeScheduleProbing$lambda$16(this), delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$4(GoogCcTransportCcEngine this$0, Ref.ObjectRef $update) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($update, "$update");
        GoogCcTransportCcEngine googCcTransportCcEngine = this$0;
        synchronized (googCcTransportCcEngine) {
            boolean bl = false;
            Instant now = this$0.clock.instant();
            NetworkControllerInterface networkControllerInterface = this$0.networkController;
            Intrinsics.checkNotNull(now);
            $update.element = networkControllerInterface.onProcessInterval(new ProcessInterval(now, null, 2, null));
            this$0.processUpdate((NetworkControlUpdate)$update.element);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final String processUpdate$lambda$7$lambda$5(TargetTransferRate $targetRate) {
        Intrinsics.checkNotNullParameter($targetRate, "$targetRate");
        return "GoogleCcEstimator setting TargetRate to " + $targetRate;
    }

    private static final String processUpdate$lambda$9$lambda$8(DataSize $congestionWindow) {
        Intrinsics.checkNotNullParameter($congestionWindow, "$congestionWindow");
        return "GoogleCcEstimator wants to set CongestionWindow to " + $congestionWindow;
    }

    private static final String processUpdate$lambda$11$lambda$10(PacerConfig $pacerConfig) {
        Intrinsics.checkNotNullParameter($pacerConfig, "$pacerConfig");
        return "GoogleCcEstimator wants to set PacerConfig to " + $pacerConfig;
    }

    private static final String processUpdate$lambda$14$lambda$12(List $configs) {
        Intrinsics.checkNotNullParameter($configs, "$configs");
        return "GoogleCcEstimator creating " + $configs.size() + " ProbeClusterConfigs: " + $configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void maybeScheduleProbing$lambda$16(GoogCcTransportCcEngine this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        PacedPacketInfo cluster = null;
        DataSize probeSize = null;
        GoogCcTransportCcEngine googCcTransportCcEngine = this$0;
        synchronized (googCcTransportCcEngine) {
            boolean bl = false;
            this$0.probeTask = null;
            Instant now = this$0.clock.instant();
            BitrateProber bitrateProber = this$0.bitrateProber;
            Intrinsics.checkNotNull(now);
            PacedPacketInfo pacedPacketInfo = bitrateProber.currentCluster(now);
            if (pacedPacketInfo == null) {
                pacedPacketInfo = new PacedPacketInfo(0, 0, 0, 0L, 15, null);
            }
            if ((cluster = pacedPacketInfo).getProbeClusterId() == -1) {
                return;
            }
            probeSize = this$0.bitrateProber.recommendedMinProbeSize();
            int probeSent = ((Number)this$0.sendProbing.invoke(probeSize, cluster)).intValue();
            this$0.bitrateProber.probeSent(now, DataSizeKt.getBytes(probeSent));
            this$0.maybeScheduleProbing(now);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        factory = new GoogCcNetworkControllerFactory(null, 1, null);
        timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(GoogCcTransportCcEngine.class);
        boolean $i$f$config = false;
        SupplierBuilder $this$defaultRateTrackerWindowSize_delegate_u24lambda_u2417 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl = false;
        $this$defaultRateTrackerWindowSize_delegate_u24lambda_u2417.from("jmt.bwe.estimator.GoogleCc2.default-window-size", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        defaultRateTrackerWindowSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$defaultRateTrackerBucketSize_delegate_u24lambda_u2418 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl2 = false;
        $this$defaultRateTrackerBucketSize_delegate_u24lambda_u2418.from("jmt.bwe.estimator.GoogleCc2.default-bucket-size", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        defaultRateTrackerBucketSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$defaultInitialIgnoreBwePeriod_delegate_u24lambda_u2419 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl3 = false;
        $this$defaultInitialIgnoreBwePeriod_delegate_u24lambda_u2419.from("jmt.bwe.estimator.GoogleCc2.default-initial-ignore-bwe-period", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        defaultInitialIgnoreBwePeriod$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR\u001b\u0010\u0013\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine$Companion;", "", "<init>", "()V", "factory", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkControllerFactory;", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "defaultRateTrackerWindowSize", "Ljava/time/Duration;", "getDefaultRateTrackerWindowSize", "()Ljava/time/Duration;", "defaultRateTrackerWindowSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "defaultRateTrackerBucketSize", "getDefaultRateTrackerBucketSize", "defaultRateTrackerBucketSize$delegate", "defaultInitialIgnoreBwePeriod", "getDefaultInitialIgnoreBwePeriod", "defaultInitialIgnoreBwePeriod$delegate", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Duration getDefaultRateTrackerWindowSize() {
            return (Duration)defaultRateTrackerWindowSize$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Duration getDefaultRateTrackerBucketSize() {
            return (Duration)defaultRateTrackerBucketSize$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @NotNull
        public final Duration getDefaultInitialIgnoreBwePeriod() {
            return (Duration)defaultInitialIgnoreBwePeriod$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "defaultRateTrackerWindowSize", "getDefaultRateTrackerWindowSize()Ljava/time/Duration;", 0)), Reflection.property1(new PropertyReference1Impl(Companion.class, "defaultRateTrackerBucketSize", "getDefaultRateTrackerBucketSize()Ljava/time/Duration;", 0)), Reflection.property1(new PropertyReference1Impl(Companion.class, "defaultInitialIgnoreBwePeriod", "getDefaultInitialIgnoreBwePeriod()Ljava/time/Duration;", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine$LossReport;", "", "<init>", "()V", "extendedHighestSequenceNumber", "", "getExtendedHighestSequenceNumber", "()J", "setExtendedHighestSequenceNumber", "(J)V", "cumulativeLost", "", "getCumulativeLost", "()I", "setCumulativeLost", "(I)V", "jitsi-media-transform"})
    private static final class LossReport {
        private long extendedHighestSequenceNumber;
        private int cumulativeLost;

        public final long getExtendedHighestSequenceNumber() {
            return this.extendedHighestSequenceNumber;
        }

        public final void setExtendedHighestSequenceNumber(long l) {
            this.extendedHighestSequenceNumber = l;
        }

        public final int getCumulativeLost() {
            return this.cumulativeLost;
        }

        public final void setCumulativeLost(int n) {
            this.cumulativeLost = n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcTransportCcEngine$StatisticsSnapshot;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "transportAdapterState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$StatisticsSnapshot;", "networkControllerState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$StatisticsSnapshot;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$StatisticsSnapshot;Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$StatisticsSnapshot;)V", "getTransportAdapterState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$StatisticsSnapshot;", "getNetworkControllerState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$StatisticsSnapshot;", "toJson", "", "jitsi-media-transform"})
    public static final class StatisticsSnapshot
    extends TransportCcEngine.StatisticsSnapshot {
        @NotNull
        private final TransportFeedbackAdapter.StatisticsSnapshot transportAdapterState;
        @NotNull
        private final GoogCcNetworkController.StatisticsSnapshot networkControllerState;

        public StatisticsSnapshot(@NotNull TransportFeedbackAdapter.StatisticsSnapshot transportAdapterState, @NotNull GoogCcNetworkController.StatisticsSnapshot networkControllerState) {
            Intrinsics.checkNotNullParameter(transportAdapterState, "transportAdapterState");
            Intrinsics.checkNotNullParameter(networkControllerState, "networkControllerState");
            this.transportAdapterState = transportAdapterState;
            this.networkControllerState = networkControllerState;
        }

        @NotNull
        public final TransportFeedbackAdapter.StatisticsSnapshot getTransportAdapterState() {
            return this.transportAdapterState;
        }

        @NotNull
        public final GoogCcNetworkController.StatisticsSnapshot getNetworkControllerState() {
            return this.networkControllerState;
        }

        @Override
        @NotNull
        public Map<?, ?> toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            String string = GoogCcTransportCcEngine.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
            $this$toJson_u24lambda_u240.put("name", string);
            $this$toJson_u24lambda_u240.put("transport_adapter", this.transportAdapterState.toJson());
            $this$toJson_u24lambda_u240.put("network_controller", this.networkControllerState.toJson());
            return orderedJsonObject;
        }
    }
}

