/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.lang.ref.Cleaner;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.jitsi.srtp.crypto.JitsiOpenSslProvider;

public abstract class OpenSslAesCipherSpi
extends CipherSpi
implements AutoCloseable {
    protected static final int BLKLEN = 16;
    private Key key;
    private final String cipherMode;
    protected final OpenSslAesCipherSpiCleanable ctx;
    private final Cleaner.Cleanable ctxCleanable;
    protected byte[] iv;
    protected int opmode = 0;

    private static native long EVP_CIPHER_CTX_new();

    private static native void EVP_CIPHER_CTX_free(long var0);

    private native boolean EVP_CipherInit(long var1, long var3, byte[] var5, byte[] var6, int var7);

    private native boolean EVP_CipherUpdate(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7);

    protected OpenSslAesCipherSpi(String cipherMode) {
        if (!JitsiOpenSslProvider.isLoaded()) {
            throw new RuntimeException("OpenSSL wrapper not loaded");
        }
        this.ctx = new OpenSslAesCipherSpiCleanable();
        this.ctx.ptr = OpenSslAesCipherSpi.EVP_CIPHER_CTX_new();
        if (this.ctx.ptr == 0L) {
            throw new RuntimeException("EVP_CIPHER_CTX_create");
        }
        this.ctxCleanable = JitsiOpenSslProvider.CLEANER.register(this, this.ctx);
        this.cipherMode = cipherMode;
    }

    @Override
    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!this.cipherMode.equalsIgnoreCase(mode)) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    protected abstract long getOpenSSLCipher(Key var1) throws InvalidKeyException;

    @Override
    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!"nopadding".equalsIgnoreCase(padding)) {
            throw new NoSuchPaddingException("No padding support");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    protected int getOutputSize(int inputLen, boolean forFinal) {
        return inputLen;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.getOutputSize(inputLen, true);
    }

    @Override
    protected byte[] engineGetIV() {
        return Arrays.copyOf(this.iv, this.iv.length);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("could not create params", e);
        }
    }

    protected void doEngineInit(int opmode, Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int openSslEncryptMode;
        switch (opmode) {
            case 1: {
                openSslEncryptMode = 1;
                break;
            }
            case 2: {
                openSslEncryptMode = 0;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported opmode " + opmode);
            }
        }
        this.opmode = opmode;
        byte[] keyParam = null;
        long cipherType = 0L;
        if (key != this.key) {
            if (!key.getAlgorithm().equalsIgnoreCase("AES") || !key.getFormat().equalsIgnoreCase("RAW") || key.getEncoded().length != 16 && key.getEncoded().length != 24 && key.getEncoded().length != 32) {
                throw new InvalidKeyException("AES SecretKeySpec expected, got " + key.getEncoded().length + " " + key.getAlgorithm() + "/" + key.getFormat());
            }
            this.key = key;
            keyParam = key.getEncoded();
            cipherType = this.getOpenSSLCipher(key);
        }
        if (!this.EVP_CipherInit(this.ctx.ptr, cipherType, keyParam, this.iv, openSslEncryptMode)) {
            throw new InvalidKeyException("EVP_CipherInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int bufNeeded = this.getOutputSize(inputLen, false);
        byte[] buf = new byte[bufNeeded];
        try {
            int len = this.engineUpdate(input, inputOffset, inputLen, buf, 0);
            assert (len == bufNeeded);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException(e);
        }
        return buf;
    }

    protected void doCipherUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (!this.EVP_CipherUpdate(this.ctx.ptr, input, inputOffset, inputLen, output, outputOffset)) {
            throw new IllegalStateException("Failure in EVP_CipherUpdate");
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int needed = this.getOutputSize(inputLen, false);
        if (output.length - outputOffset < needed) {
            throw new ShortBufferException("Output buffer needs at least " + needed + "bytes");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        this.doCipherUpdate(input, inputOffset, inputLen, output, outputOffset);
        return inputLen;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws AEADBadTagException {
        int bufNeeded = this.getOutputSize(inputLen, true);
        byte[] buf = new byte[bufNeeded];
        try {
            int len = this.engineDoFinal(input, inputOffset, inputLen, buf, 0);
            assert (len == bufNeeded);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException(e);
        }
        return buf;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, AEADBadTagException {
        int needed = this.getOutputSize(inputLen, false);
        if (output.length - outputOffset < needed) {
            throw new ShortBufferException("Output buffer needs at least " + needed + "bytes");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        this.doCipherUpdate(input, inputOffset, inputLen, output, outputOffset);
        return inputLen;
    }

    @Override
    public void close() {
        this.ctxCleanable.clean();
    }

    protected static class OpenSslAesCipherSpiCleanable
    implements Runnable {
        long ptr;

        protected OpenSslAesCipherSpiCleanable() {
        }

        @Override
        public void run() {
            if (this.ptr != 0L) {
                OpenSslAesCipherSpi.EVP_CIPHER_CTX_free(this.ptr);
                this.ptr = 0L;
            }
        }
    }
}

