/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ret!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u00037Q\b\u0019AA\u000f\u0003\u00111\u0017\u000e\\3\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t%\u0003\tIw.\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0002$jY\u0016Dq!a\u000b\n\t\u0013\ti#A\u0007xe&$Xm\u00158baNDw\u000e\u001e\u000b\u0007\u0003_\t)$a\u000e\u0011\u00075\t\t$C\u0002\u000249\u0011A!\u00168ji\"A\u00111DA\u0015\u0001\u0004\ti\u0002\u0003\u0005\u0002:\u0005%\u0002\u0019AA\u001e\u0003\u001d)g\u000e\u001e:jKN\u0004\u0002\"!\u0010\u0002H\u0005-\u00131C\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00059Q.\u001e;bE2,'bAA#\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0004\u001b\u0006\u0004\bcA\u0007\u0002N%\u0019\u0011q\n\b\u0003\t1{gn\u001a\u0005\b\u0003'JA\u0011BA+\u00039I7o\u00158baNDw\u000e\u001e$jY\u0016$B!a\u0016\u0002^A\u0019Q\"!\u0017\n\u0007\u0005mcBA\u0004C_>dW-\u00198\t\u0011\u0005m\u0011\u0011\u000ba\u0001\u0003;A\u0001\"!\u0019\n\t\u0003\u0011\u00111M\u0001\u0012Y&\u001cHo\u00158baNDw\u000e\u001e$jY\u0016\u001cH\u0003BA3\u0003W\u0002RA`A4\u0003;IA!!\u001b\u0002\u0012\t\u00191+Z9\t\u0011\u00055\u0014q\fa\u0001\u0003;\t1\u0001Z5s\u0011!\t\t(\u0003C\u0001\u0005\u0005M\u0014!\u00063fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u000b\u0007\u0003_\t)(a\u001e\t\u0011\u00055\u0014q\u000ea\u0001\u0003;A\u0001\"!\u001f\u0002p\u0001\u0007\u00111J\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005u\u0014\u0002\"\u0003\u0002\u0000\u0005\u0019B-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fgR1\u0011qFAA\u0003\u0007C\u0001\"!\u001c\u0002|\u0001\u0007\u0011Q\u0004\u0005\u000b\u0003\u000b\u000bY\b%AA\u0002\u0005\u001d\u0015!\u00039sK\u0012L7-\u0019;f!\u001di\u0011\u0011RA&\u0003/J1!a#\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0002\u0010&\t\n\u0011\"\u0001\u0002\u0012\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007U\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tKD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI+CI\u0001\n\u0013\tY+A\u000feK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiK\u000b\u0003\u0002\b\u0006Ue!\u0002\u0006\u0003\u0001\u0005E6#BAX\u0019\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005eF!A\u0003vi&d7/\u0003\u0003\u0002>\u0006]&a\u0002'pO\u001eLgn\u001a\u0005\f\u0003\u0003\fyK!b\u0001\n\u0003\t\u0019-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u0013l\u0011a[\u0005\u0004\u0003\u0017\\'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\f\u0003\u001f\fyK!A!\u0002\u0013\t)-A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011-\t\u0019.a,\u0003\u0002\u0004%\t!!6\u0002\r1|w\rR5s+\t\ti\u0002C\u0006\u0002Z\u0006=&\u00111A\u0005\u0002\u0005m\u0017A\u00037pO\u0012K'o\u0018\u0013fcR!\u0011qFAo\u0011)\ty.a6\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0004bCAr\u0003_\u0013\t\u0011)Q\u0005\u0003;\tq\u0001\\8h\t&\u0014\b\u0005\u000b\u0003\u0002b\u0006\u001d\bcA\u0007\u0002j&\u0019\u00111\u001e\b\u0003\u0011Y|G.\u0019;jY\u0016D!\"a<\u00020\n\u0015\r\u0011\"\u0001U\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\t\u0015\u0005M\u0018q\u0016B\u0001B\u0003%Q+\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004\u0014\u0003_#\t!a>\u0015\u0011\u0005e\u00181`A\u007f\u0003\u007f\u00042\u0001CAX\u0011!\t\t-!>A\u0002\u0005\u0015\u0007\u0002CAj\u0003k\u0004\r!!\b\t\u0013\u0005=\u0018Q\u001fI\u0001\u0002\u0004)\u0006B\u0003B\u0002\u0003_\u0013\r\u0011\"\u0003\u0003\u0006\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003wA\u0011B!\u0003\u00020\u0002\u0006I!a\u000f\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0003\u0006\u0003\u000e\u0005=\u0006\u0019!C\u0005\u0005\u001f\tQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAA&\u0011)\u0011\u0019\"a,A\u0002\u0013%!QC\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0005/A!\"a8\u0003\u0012\u0005\u0005\t\u0019AA&\u0011%\u0011Y\"a,!B\u0013\tY%\u0001\bmCN$X*\u00199PM\u001a\u001cX\r\u001e\u0011\t\u0015\t}\u0011q\u0016a\u0001\n\u0013\u0011y!\u0001\bmCN$8K\\1q\u001f\u001a47/\u001a;\t\u0015\t\r\u0012q\u0016a\u0001\n\u0013\u0011)#\u0001\nmCN$8K\\1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0005OA!\"a8\u0003\"\u0005\u0005\t\u0019AA&\u0011%\u0011Y#a,!B\u0013\tY%A\bmCN$8K\\1q\u001f\u001a47/\u001a;!\u0011)\u0011y#a,C\u0002\u0013%!\u0011G\u0001\f_:<w.\u001b8h)bt7/\u0006\u0002\u00034AA!Q\u0007B\u001e\u0003\u0017\u0012y$\u0004\u0002\u00038)\u0019!\u0011\b\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005{\u00119DA\u0004Ue\u0016,W*\u00199\u0011\u0007!\u0011\t%C\u0002\u0003D\t\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\"I!qIAXA\u0003%!1G\u0001\r_:<w.\u001b8h)bt7\u000f\t\u0005\u000b\u0005\u0017\nyK1A\u0005\n\tE\u0012\u0001E;oe\u0016\u0004H.[2bi\u0016$G\u000b\u001f8t\u0011%\u0011y%a,!\u0002\u0013\u0011\u0019$A\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0002B\u0001Ba\u0015\u00020\u0012\u0005!QK\u0001\u0014M&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^\u000b\u0003\u0005/\u0002R!\u0004B-\u0005;J1Aa\u0017\u000f\u0005\u0019y\u0005\u000f^5p]B!!q\fB3\u001b\t\u0011\tGC\u0002\u0003d\u0011\taa]3sm\u0016\u0014\u0018\u0002\u0002B4\u0005C\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011!\u0011Y'a,\u0005\u0002\t5\u0014AF8o\u0011&<\u0007nV1uKJl\u0017M]6Va\u0012\fG/\u001a3\u0015\t\u0005=\"q\u000e\u0005\t\u0005c\u0012I\u00071\u0001\u0002L\u0005i\u0001.[4i/\u0006$XM]7be.D\u0001B!\u001e\u00020\u0012\u0005!qO\u0001\u0015M&\u00148\u000f^+oI\u0016\u001c\u0017\u000eZ3e\u001f\u001a47/\u001a;\u0016\u0005\te\u0004#B\u0007\u0003Z\u0005-\u0003\u0002\u0003B?\u0003_#\tAa\u0004\u0002\u00195\f\u0007/\u00128e\u001f\u001a47/\u001a;\t\u0011\t\u0005\u0015q\u0016C\u0001\u0005\u0007\u000bq\"Y2uSZ,\u0007K]8ek\u000e,'o]\u000b\u0003\u0005\u000b\u0003\u0002Ba\"\u0003\u000e\u0006-\u00131C\u0007\u0003\u0005\u0013SAAa#\u0002D\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0013\u0012I\t\u0003\u0005\u0003\u0012\u0006=F\u0011\u0001BJ\u0003\u001dI7/R7qif,\"!a\u0016\t\u0011\t]\u0015q\u0016C\u0005\u00053\u000b\u0001\u0003\\8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;\u0015\r\u0005=\"1\u0014BP\u0011!\u0011iJ!&A\u0002\u0005-\u0013A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0005C\u0013)\n1\u0001\u0002L\u0005Y1-\u001e:sK:$H+[7f\u0011%\u0011)+a,\u0005\u0002\t\u00119+A\tm_\u0006$\u0007K]8ek\u000e,'/\u00128uef$B!a\f\u0003*\"A!1\u0016BR\u0001\u0004\t\u0019\"A\u0003f]R\u0014\u0018\u0010\u0003\u0005\u00030\u0006=F\u0011\u0002BY\u0003EI7\u000f\u0015:pIV\u001cWM]#ya&\u0014X\r\u001a\u000b\u0007\u0003/\u0012\u0019La.\t\u0011\tU&Q\u0016a\u0001\u0003\u0017\nQbY;se\u0016tG\u000fV5nK6\u001b\b\u0002\u0003B]\u0005[\u0003\r!a\u0005\u0002\u001bA\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u0011!\u0011i,a,\u0005\u0002\t}\u0016A\u0006:f[>4X-\u0012=qSJ,G\r\u0015:pIV\u001cWM]:\u0015\t\u0005=\"\u0011\u0019\u0005\t\u0005k\u0013Y\f1\u0001\u0002L!A!QYAX\t\u0003\u00119-A\tueVt7-\u0019;f\u0003:$'+\u001a7pC\u0012$\u0002\"a\f\u0003J\n-'q\u001a\u0005\t\u0005;\u0013\u0019\r1\u0001\u0002L!A!Q\u001aBb\u0001\u0004\tY%\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0003\u0005\u00036\n\r\u0007\u0019AA&\u0011!\u0011\u0019.a,\u0005\u0002\tU\u0017!\u00049sKB\f'/Z+qI\u0006$X\r\u0006\u0004\u0003X\nu'\u0011\u001d\t\u0004\u0011\te\u0017b\u0001Bn\u0005\t\u0011\u0002K]8ek\u000e,'/\u00119qK:$\u0017J\u001c4p\u0011!\u0011yN!5A\u0002\u0005-\u0013A\u00039s_\u0012,8-\u001a:JI\"A!1\u001dBi\u0001\u0004\t9&\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000f\u0003\u0005\u0003h\u0006=F\u0011\u0001Bu\u0003\u0019)\b\u000fZ1uKR!\u0011q\u0006Bv\u0011!\u0011iO!:A\u0002\t]\u0017AC1qa\u0016tG-\u00138g_\"A!\u0011_AX\t\u0003\u0011\u00190\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA\u0018\u0005kD\u0001Ba>\u0003p\u0002\u0007\u00111J\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\b\u0002\u0003B~\u0003_#\tA!@\u0002\u00131\f7\u000f^#oiJLH\u0003\u0002B\u0000\u0007\u0003\u0001R!\u0004B-\u0003'A\u0001Ba8\u0003z\u0002\u0007\u00111\n\u0005\t\u0007\u000b\ty\u000b\"\u0001\u0004\b\u0005aA/Y6f':\f\u0007o\u001d5piR\u0011\u0011q\u0006\u0005\t\u0007\u0017\ty\u000b\"\u0001\u0003x\u0005!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD\u0001ba\u0004\u00020\u0012\u0005!qO\u0001\u0015_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\t\u0011\rM\u0011q\u0016C\u0005\u0007+\t!#[:Qe>$WoY3s%\u0016$\u0018-\u001b8fIR1\u0011qKB\f\u00077A\u0001b!\u0007\u0004\u0012\u0001\u0007\u00111C\u0001\u0013aJ|G-^2feN#\u0018\r^3F]R\u0014\u0018\u0010\u0003\u0005\u0003\u001e\u000eE\u0001\u0019AA&\u0011!\u0019y\"a,\u0005\u0002\r\u0005\u0012\u0001\u0004;sk:\u001c\u0017\r^3IK\u0006$G\u0003BA\u0018\u0007GA\u0001B!(\u0004\u001e\u0001\u0007\u00111\n\u0005\t\u0007O\ty\u000b\"\u0003\u0004*\u0005\u0001#/Z7pm\u0016,e/[2uK\u0012|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\tyca\u000b\t\u0011\r52Q\u0005a\u0001\u0007_\t!#\u001a=qSJ,G\r\u0015:pIV\u001cWM]%egB11\u0011GB\u001a\u0003\u0017j!!a\u0011\n\t\rU\u00121\t\u0002\u0004'\u0016$\b\u0002CB\u001d\u0003_#Iaa\u000f\u0002=I,Wn\u001c<f+:\u0014X\r\u001d7jG\u0006$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003BA\u0018\u0007{A\u0001\"!\u001f\u00048\u0001\u0007\u00111\n\u0005\t\u0007\u0003\ny\u000b\"\u0001\u0004\b\u0005AAO];oG\u0006$X\r\u0003\u0005\u0004F\u0005=F\u0011AB$\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005-3\u0011\n\u0005\t\u0007\u0017\u001a\u0019\u00051\u0001\u0004N\u0005a1m\\7qY\u0016$X\r\u001a+y]B\u0019\u0001ba\u0014\n\u0007\rE#A\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000e\u0003\u0005\u0002r\u0005=F\u0011AB+)\u0011\tyca\u0016\t\u0011\u0005e41\u000ba\u0001\u0003\u0017BCaa\u0015\u0004\\A!\u0011QWB/\u0013\u0011\u0019y&a.\u0003\u0015QD'/Z1eg\u00064W\r\u0003\u0005\u0004d\u0005=F\u0011BB3\u0003IyG\u000eZ3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0016\u0005\r\u001d\u0004#B\u0007\u0003Z\u0005u\u0001\u0002CB6\u0003_#Ia!\u001a\u0002%1\fG/Z:u':\f\u0007o\u001d5pi\u001aKG.\u001a\u0005\t\u0003C\ny\u000b\"\u0003\u0004pU\u0011\u0011Q\r\u0015\u0005\u0003_\u001b\u0019\b\u0005\u0003\u00026\u000eU\u0014\u0002BB<\u0003o\u0013QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, logStartOffset, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, e.getMessage()})));
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$2), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (!isFromClient) {
            product = ValidationType$None$.MODULE$;
        } else {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        BoxedUnit boxedUnit;
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId()), appendInfo})));
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            ProducerStateEntry currentEntry = (ProducerStateEntry)some.value();
            currentEntry.update(updatedEntry);
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastMapOffset())})));
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    private boolean isProducerRetained(ProducerStateEntry producerStateEntry, long logStartOffset) {
        producerStateEntry.removeBatchesOlderThan(logStartOffset);
        return producerStateEntry.lastDataOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$truncateHead$1(this, logStartOffset, x0$3)));
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.ongoingTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to complete transaction ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completedTxn, this.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which was not started"})).s((Seq)Nil$.MODULE$));
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long logStartOffset$3, long currentTime$1, ProducerStateEntry producerEntry) {
        return $this.isProducerRetained(producerEntry, logStartOffset$3) && !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$2, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$2, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$2, ProducerStateEntry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$truncateHead$1(ProducerStateManager $this, long logStartOffset$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry producerState = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerRetained(producerState, logStartOffset$2);
        return bl;
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ProducerStateManager partition=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

