/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrRichCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/AvoidLocalFOsInInlineFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public final class AvoidLocalFOsInInlineFunctionsLowering
implements BodyLoweringPass {
    @NotNull
    private final LoweringContext context;

    public AvoidLocalFOsInInlineFunctionsLowering(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElement irElement = container instanceof IrValueParameter ? (IrValueParameter)container : null;
        IrElement irElement2 = irElement != null && (irElement = irElement.getParent()) != null ? (IrElement)irElement : (IrElement)container;
        IrFunction irFunction = irElement2 instanceof IrFunction ? (IrFunction)irElement2 : null;
        if (irFunction == null) {
            return;
        }
        IrFunction function2 = irFunction;
        if (!function2.isInline()) {
            return;
        }
        IrVisitorsKt.acceptVoid((IrElement)irBody, new IrVisitorVoid(){

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                IrSymbol irSymbol = this.findOverriddenNonLocalFo(callee);
                if (irSymbol != null) {
                    IrSymbol newSymbol = irSymbol;
                    boolean bl = false;
                    expression2.setSymbol((IrSimpleFunctionSymbol)newSymbol);
                    IrValueParameter irValueParameter = ((IrSimpleFunction)((IrSimpleFunctionSymbol)newSymbol).getOwner()).getDispatchReceiverParameter();
                    if (irValueParameter != null) {
                        T element$iv2;
                        IrValueParameter dispatchParam;
                        block3: {
                            dispatchParam = irValueParameter;
                            boolean bl2 = false;
                            IrClass superClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrSimpleFunctionSymbol)newSymbol).getOwner());
                            Iterable $this$first$iv = IrTypeUtilsKt.getAllSubstitutedSupertypes(IrUtilsKt.getParentAsClass(callee));
                            boolean $i$f$first = false;
                            for (T element$iv2 : $this$first$iv) {
                                IrSimpleType it = (IrSimpleType)element$iv2;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(it.getClassifier(), superClass.getSymbol())) continue;
                                break block3;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        IrSimpleType newDispatcherType = (IrSimpleType)element$iv2;
                        IrExpression irExpression = expression2.getArguments().get(dispatchParam);
                        expression2.getArguments().set(dispatchParam, irExpression != null ? IrExpressionsKt.implicitCastTo(irExpression, newDispatcherType) : null);
                    }
                }
                super.visitMemberAccess(expression2);
            }

            public void visitRichCallableReference(IrRichCallableReference<?> expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                super.visitRichCallableReference(expression2);
                ? obj = expression2.getReflectionTargetSymbol();
                IrSymbolOwner irSymbolOwner = obj != null ? obj.getOwner() : null;
                IrOverridableDeclaration irOverridableDeclaration = irSymbolOwner instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)irSymbolOwner : null;
                if (irOverridableDeclaration == null) {
                    return;
                }
                IrOverridableDeclaration target = irOverridableDeclaration;
                IrSymbol irSymbol = this.findOverriddenNonLocalFo(target);
                if (irSymbol != null) {
                    IrSymbol it = irSymbol;
                    boolean bl = false;
                    IrRichCallableReference<?> irRichCallableReference = expression2;
                    if (irRichCallableReference instanceof IrRichFunctionReference) {
                        ((IrRichFunctionReference)expression2).setReflectionTargetSymbol((IrSymbol)((IrSimpleFunctionSymbol)it));
                    } else if (irRichCallableReference instanceof IrRichPropertyReference) {
                        ((IrRichPropertyReference)expression2).setReflectionTargetSymbol((IrSymbol)((IrPropertySymbol)it));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private final IrSymbol findOverriddenNonLocalFo(IrOverridableDeclaration<?> member) {
                IrOverridableDeclaration properMember = member;
                while (AdditionalIrUtilsKt.isLocal(properMember) && properMember.isFakeOverride()) {
                    IrSymbol irSymbol = (IrSymbol)CollectionsKt.getOrNull(properMember.getOverriddenSymbols(), 0);
                    IrSymbolOwner irSymbolOwner = irSymbol != null ? irSymbol.getOwner() : null;
                    if ((irSymbolOwner instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)irSymbolOwner : null) == null) break;
                    properMember = properMember;
                }
                return properMember == member ? null : (IrSymbol)properMember.getSymbol();
            }
        });
    }
}

