# $MirOS: contrib/code/mirmake/dist/scripts/bsd.own.mk.ed,v 1.14 2007/03/09 10:24:52 tg Exp $
# $MirOS: src/share/mk/bsd.own.mk,v 1.64 2014/11/26 19:29:29 tg Exp $
# $OpenBSD: bsd.own.mk,v 1.92 2005/01/18 00:28:42 mickey Exp $
# $NetBSD: bsd.own.mk,v 1.24 1996/04/13 02:08:09 thorpej Exp $

.if !defined(BSD_OWN_MK)
BSD_OWN_MK=1

# Host-specific overrides
.if defined(MAKECONF) && exists(${MAKECONF})
.  include "${MAKECONF}"
.elif exists(/etc/${MAKE:T}.cfg)
.  include "/etc/${MAKE:T}.cfg"
.endif

DEFFLAGS?=	Yes
.if ${DEFFLAGS:L} != "no"
COPTS?=		${_DEFCOPTS} ${GCEXTRA}
.else
COPTS?=		# at least define it
.endif

.ifdef __CRAZY
WARNINGS=	yes
CFLAGS+=	-Wall -Wextra -Wunused -Wdeclaration-after-statement -Wundef \
		-Wendif-labels -Wshadow -Wpointer-arith -Wbad-function-cast \
		-Wcast-qual -Wcast-align -Wwrite-strings -Wstrict-prototypes \
		-Wold-style-definition -Wmissing-prototypes -Winline \
		-Wmissing-declarations -Wmissing-noreturn -Winit-self \
		-Wmissing-format-attribute -Wredundant-decls
.endif

# Set to yes to add CDIAGFLAGS to CFLAGS
WARNINGS?=		No
# Set to yes to build shared libraries with basic debugging information
DEBUGLIBS?=		No	# yes, we have this twice
# Set to sudo to automatically switch to root and only if needed
SUDO?=
# where the system object and source trees are kept; can be configurable
# by the user in case they want them in ~/foosrc and ~/fooobj, for example
BSDSRCDIR?=		/usr/src
BSDOBJDIR?=		/usr/obj
BSDRELDIR?=		/usr/releng
# Shared files for system GNU configure and build process
GNUSYSTEM_AUX_DIR?=	${BSDSRCDIR}/gnu/share
LTMIRMAKE?=		No


BINOWN?=	pbulk
BINGRP?=	users
CONFGRP?=	users
BINMODE?=	555
NONBINMODE?=	444
DIRMODE?=	755

BSD_PREFIX?=	/usr

SHAREDIR?=	${BSD_PREFIX}/share
SHAREOWN?=	${BINOWN}
SHAREGRP?=	${BINGRP}
SHAREMODE?=	${NONBINMODE}

.if ${BSD_PREFIX} == "/usr"
MANDIR?=	${BSD_PREFIX}/share/man/cat
.else
MANDIR?=	${BSD_PREFIX}/man/cat
.endif
MANOWN?=	${SHAREOWN}
MANGRP?=	${SHAREGRP}
MANMODE?=	${NONBINMODE}

LIBDIR?=	${BSD_PREFIX}/lib
LINTLIBDIR?=	${BSD_PREFIX}/libdata/lint
LIBOWN?=	${BINOWN}
LIBGRP?=	${BINGRP}
LIBMODE?=	${NONBINMODE}

DOCDIR?=	${SHAREDIR}/doc
DOCOWN?=	${SHAREOWN}
DOCGRP?=	${SHAREGRP}
DOCMODE?=	${NONBINMODE}

LKMDIR?=	${BSD_PREFIX}/lkm
LKMOWN?=	${BINOWN}
LKMGRP?=	${BINGRP}
LKMMODE?=	${NONBINMODE}

NOLINT?=	yes
NOMAN?=		no
NOOBJ?=		no
NOPIC?=		no

LDFLAGS?=
.if ${NOPIC:L} != "no"
LDSTATIC=	-static
.endif

OBJECT_FMT=	ELF
RTLD_TYPE=	BSD

.if ${OBJECT_FMT} == "Mach-O"
PICFLAG=	-fno-common
.elif ${OBJECT_FMT} == "PE"
PICFLAG=	# not needed; -fpic/-fPIC generates broken code
.elif (${MACHINE_ARCH} == "sparc") || (${MACHINE_ARCH} == "sparc64")
PICFLAG=	-fPIC
.else
PICFLAG=	-fpic
.endif

.if ${MACHINE_ARCH} == "sparc"
ASPICFLAG=	-KPIC
.elif ${OBJECT_FMT} == "a.out"
ASPICFLAG=	-k
.endif

INSTALL_COPY?=	-c
.ifndef DEBUG
.  if ${OBJECT_FMT} == "Mach-O"
INSTALL_STRIP?=
STRIP?=		strip -x
.  else
INSTALL_STRIP?=	-s
STRIP?=		strip
.  endif
.endif
INSTALL_STRIP?=
STRIP?=		:

# XXX fixme
PIC?=		cat --
BIB?=		cat --

BIB?=		bib
EQN?=		neqn
GREMLIN?=	grn
GRIND?=		vgrind -f
INDXBIB?=	indxbib
MKDEP_SH?=	mkdep
MKSH?=		/usr/pkg/bin/mksh
NROFF?=		nroff -c ${MACROS} ${PAGES}
PIC?=		pic
REFER?=		refer
ROFF?=		groff -Tps ${MACROS} ${PAGES}
SOELIM?=	soelim
TBL?=		tbl

.PHONY: spell clean cleandir obj manpages print all \
	depend beforedepend afterdepend cleandepend \
	all lint cleanman includes \
	beforeinstall realinstall maninstall afterinstall install

.endif
