/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.ExpandTabsReader;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.archive.BZip2AnalyzerFactory;
import org.opensolaris.opengrok.analysis.archive.GZIPAnalyzerFactory;
import org.opensolaris.opengrok.analysis.archive.TarAnalyzerFactory;
import org.opensolaris.opengrok.analysis.archive.ZipAnalyzerFactory;
import org.opensolaris.opengrok.analysis.c.CAnalyzerFactory;
import org.opensolaris.opengrok.analysis.c.CxxAnalyzerFactory;
import org.opensolaris.opengrok.analysis.csharp.CSharpAnalyzerFactory;
import org.opensolaris.opengrok.analysis.data.IgnorantAnalyzerFactory;
import org.opensolaris.opengrok.analysis.data.ImageAnalyzerFactory;
import org.opensolaris.opengrok.analysis.document.TroffAnalyzerFactory;
import org.opensolaris.opengrok.analysis.executables.ELFAnalyzerFactory;
import org.opensolaris.opengrok.analysis.executables.JarAnalyzerFactory;
import org.opensolaris.opengrok.analysis.executables.JavaClassAnalyzerFactory;
import org.opensolaris.opengrok.analysis.fortran.FortranAnalyzerFactory;
import org.opensolaris.opengrok.analysis.java.JavaAnalyzerFactory;
import org.opensolaris.opengrok.analysis.javascript.JavaScriptAnalyzerFactory;
import org.opensolaris.opengrok.analysis.lisp.LispAnalyzerFactory;
import org.opensolaris.opengrok.analysis.perl.PerlAnalyzerFactory;
import org.opensolaris.opengrok.analysis.php.PhpAnalyzerFactory;
import org.opensolaris.opengrok.analysis.plain.PlainAnalyzerFactory;
import org.opensolaris.opengrok.analysis.plain.XMLAnalyzerFactory;
import org.opensolaris.opengrok.analysis.python.PythonAnalyzerFactory;
import org.opensolaris.opengrok.analysis.scala.ScalaAnalyzerFactory;
import org.opensolaris.opengrok.analysis.sh.ShAnalyzerFactory;
import org.opensolaris.opengrok.analysis.sql.PLSQLAnalyzerFactory;
import org.opensolaris.opengrok.analysis.sql.SQLAnalyzerFactory;
import org.opensolaris.opengrok.analysis.tcl.TclAnalyzerFactory;
import org.opensolaris.opengrok.analysis.uue.UuencodeAnalyzerFactory;
import org.opensolaris.opengrok.analysis.vb.VBAnalyzerFactory;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.history.HistoryReader;
import org.opensolaris.opengrok.web.Util;

public class AnalyzerGuru {
    private static final FileAnalyzerFactory DEFAULT_ANALYZER_FACTORY;
    private static final Map<String, FileAnalyzerFactory> FILE_NAMES;
    private static final Map<String, FileAnalyzerFactory> ext;
    private static final Map<String, FileAnalyzerFactory> pre;
    private static final SortedMap<String, FileAnalyzerFactory> magics;
    private static final List<FileAnalyzerFactory.Matcher> matchers;
    private static final List<FileAnalyzerFactory> factories;
    public static final Reader dummyR;
    public static final String dummyS = "";
    public static final FieldType string_ft_stored_nanalyzed_norms;
    public static final FieldType string_ft_nstored_nanalyzed_norms;
    private static final Map<String, byte[]> BOMS;

    public List<FileAnalyzerFactory> getAnalyzerFactories() {
        return factories;
    }

    private static void registerAnalyzer(FileAnalyzerFactory factory) {
        FileAnalyzerFactory old;
        for (String name : factory.getFileNames()) {
            old = FILE_NAMES.put(name, factory);
            assert (old == null) : "name '" + name + "' used in multiple analyzers";
        }
        for (String prefix : factory.getPrefixes()) {
            old = pre.put(prefix, factory);
            assert (old == null) : "prefix '" + prefix + "' used in multiple analyzers";
        }
        for (String suffix : factory.getSuffixes()) {
            old = ext.put(suffix, factory);
            assert (old == null) : "suffix '" + suffix + "' used in multiple analyzers";
        }
        for (String magic : factory.getMagicStrings()) {
            old = magics.put(magic, factory);
            assert (old == null) : "magic '" + magic + "' used in multiple analyzers";
        }
        matchers.addAll(factory.getMatchers());
        factories.add(factory);
    }

    public static void addPrefix(String prefix, FileAnalyzerFactory factory) {
        if (factory == null) {
            pre.remove(prefix);
        } else {
            pre.put(prefix, factory);
        }
    }

    public static void addExtension(String extension, FileAnalyzerFactory factory) {
        if (factory == null) {
            ext.remove(extension);
        } else {
            ext.put(extension, factory);
        }
    }

    public static FileAnalyzer getAnalyzer() {
        return DEFAULT_ANALYZER_FACTORY.getAnalyzer();
    }

    public static FileAnalyzer getAnalyzer(InputStream in, String file) throws IOException {
        FileAnalyzerFactory factory = AnalyzerGuru.find(in, file);
        if (factory == null) {
            return AnalyzerGuru.getAnalyzer();
        }
        return factory.getAnalyzer();
    }

    public void populateDocument(Document doc, File file, String path, FileAnalyzer fa, Writer xrefOut) throws IOException {
        String date = DateTools.timeToString((long)file.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        doc.add((IndexableField)new Field("u", Util.path2uid(path, date), string_ft_stored_nanalyzed_norms));
        doc.add((IndexableField)new Field("fullpath", file.getAbsolutePath(), string_ft_nstored_nanalyzed_norms));
        try {
            HistoryReader hr = HistoryGuru.getInstance().getHistoryReader(file);
            if (hr != null) {
                doc.add((IndexableField)new TextField("hist", (Reader)hr));
            }
        }
        catch (HistoryException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "An error occurred while reading history: ", e);
        }
        doc.add((IndexableField)new Field("date", date, string_ft_stored_nanalyzed_norms));
        if (path != null) {
            doc.add((IndexableField)new TextField("path", path, Field.Store.YES));
            Project project = Project.getProject(path);
            if (project != null) {
                doc.add((IndexableField)new TextField("project", project.getPath(), Field.Store.YES));
            }
        }
        if (fa != null) {
            FileAnalyzer.Genre g = fa.getGenre();
            if (g == FileAnalyzer.Genre.PLAIN || g == FileAnalyzer.Genre.XREFABLE || g == FileAnalyzer.Genre.HTML) {
                doc.add((IndexableField)new Field("t", g.typeName(), string_ft_stored_nanalyzed_norms));
            }
            fa.analyze(doc, StreamSource.fromFile(file), xrefOut);
            String type = fa.getFileTypeName();
            doc.add((IndexableField)new StringField("type", type, Field.Store.YES));
        }
    }

    public static String getContentType(InputStream in, String file) throws IOException {
        FileAnalyzerFactory factory = AnalyzerGuru.find(in, file);
        String type = null;
        if (factory != null) {
            type = factory.getContentType();
        }
        return type;
    }

    public static void writeXref(FileAnalyzerFactory factory, Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        Reader input = in;
        if (factory.getGenre() == FileAnalyzer.Genre.PLAIN) {
            input = ExpandTabsReader.wrap(in, project);
        }
        factory.writeXref(input, out, defs, annotation, project);
    }

    public static FileAnalyzer.Genre getGenre(String file) {
        return AnalyzerGuru.getGenre(AnalyzerGuru.find(file));
    }

    public static FileAnalyzer.Genre getGenre(InputStream in) throws IOException {
        return AnalyzerGuru.getGenre(AnalyzerGuru.find(in));
    }

    public static FileAnalyzer.Genre getGenre(FileAnalyzerFactory factory) {
        if (factory != null) {
            return factory.getGenre();
        }
        return null;
    }

    public static FileAnalyzerFactory findFactory(String factoryClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return AnalyzerGuru.findFactory(Class.forName(factoryClassName));
    }

    private static FileAnalyzerFactory findFactory(Class<?> factoryClass) throws InstantiationException, IllegalAccessException {
        for (FileAnalyzerFactory f : factories) {
            if (f.getClass() != factoryClass) continue;
            return f;
        }
        FileAnalyzerFactory f = (FileAnalyzerFactory)factoryClass.newInstance();
        AnalyzerGuru.registerAnalyzer(f);
        return f;
    }

    public static FileAnalyzerFactory find(InputStream in, String file) throws IOException {
        FileAnalyzerFactory factory = AnalyzerGuru.find(file);
        if (factory != null) {
            return factory;
        }
        return AnalyzerGuru.find(in);
    }

    public static FileAnalyzerFactory find(String file) {
        int dotpos;
        String path = file;
        int i = path.lastIndexOf(File.separatorChar);
        if (i > 0 && i + 1 < path.length()) {
            path = path.substring(i + 1);
        }
        if ((dotpos = path.lastIndexOf(46)) >= 0) {
            FileAnalyzerFactory factory;
            if (dotpos > 0 && (factory = pre.get(path.substring(0, dotpos).toUpperCase(Locale.getDefault()))) != null) {
                return factory;
            }
            factory = ext.get(path.substring(dotpos + 1).toUpperCase(Locale.getDefault()));
            if (factory != null) {
                return factory;
            }
        }
        return FILE_NAMES.get(path.toUpperCase(Locale.getDefault()));
    }

    public static FileAnalyzerFactory find(InputStream in) throws IOException {
        FileAnalyzerFactory factory;
        in.mark(8);
        byte[] content = new byte[8];
        int len = in.read(content);
        in.reset();
        if (len < 8) {
            if (len < 4) {
                return null;
            }
            content = Arrays.copyOf(content, len);
        }
        if ((factory = AnalyzerGuru.find(content)) != null) {
            return factory;
        }
        for (FileAnalyzerFactory.Matcher matcher : matchers) {
            FileAnalyzerFactory fac = matcher.isMagic(content, in);
            if (fac == null) continue;
            return fac;
        }
        return null;
    }

    private static FileAnalyzerFactory find(byte[] signature) throws IOException {
        char[] chars = new char[signature.length > 8 ? 8 : signature.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(0xFF & signature[i]);
        }
        String sig = new String(chars);
        FileAnalyzerFactory a = (FileAnalyzerFactory)magics.get(sig);
        if (a == null) {
            String sigWithoutBOM = AnalyzerGuru.stripBOM(signature);
            for (Map.Entry<String, FileAnalyzerFactory> entry : magics.entrySet()) {
                if (sig.startsWith(entry.getKey())) {
                    return entry.getValue();
                }
                if (sigWithoutBOM == null || entry.getValue().getGenre() != FileAnalyzer.Genre.PLAIN || !sigWithoutBOM.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return a;
    }

    public static String stripBOM(byte[] sig) throws IOException {
        for (Map.Entry<String, byte[]> entry : BOMS.entrySet()) {
            int i;
            String encoding = entry.getKey();
            byte[] bom = entry.getValue();
            if (sig.length <= bom.length) continue;
            for (i = 0; i < bom.length && sig[i] == bom[i]; ++i) {
            }
            if (i != bom.length) continue;
            return new String(sig, bom.length, sig.length - bom.length, encoding);
        }
        return null;
    }

    static {
        FileAnalyzerFactory[] analyzers;
        DEFAULT_ANALYZER_FACTORY = new FileAnalyzerFactory();
        FILE_NAMES = new HashMap<String, FileAnalyzerFactory>();
        ext = new HashMap<String, FileAnalyzerFactory>();
        pre = new HashMap<String, FileAnalyzerFactory>();
        magics = new TreeMap<String, FileAnalyzerFactory>();
        matchers = new ArrayList<FileAnalyzerFactory.Matcher>();
        factories = new ArrayList<FileAnalyzerFactory>();
        dummyR = new StringReader(dummyS);
        string_ft_stored_nanalyzed_norms = new FieldType(StringField.TYPE_STORED);
        string_ft_nstored_nanalyzed_norms = new FieldType(StringField.TYPE_NOT_STORED);
        for (FileAnalyzerFactory analyzer : analyzers = new FileAnalyzerFactory[]{DEFAULT_ANALYZER_FACTORY, new IgnorantAnalyzerFactory(), new BZip2AnalyzerFactory(), new XMLAnalyzerFactory(), new TroffAnalyzerFactory(), new ELFAnalyzerFactory(), new JavaClassAnalyzerFactory(), new ImageAnalyzerFactory(), JarAnalyzerFactory.DEFAULT_INSTANCE, ZipAnalyzerFactory.DEFAULT_INSTANCE, new TarAnalyzerFactory(), new CAnalyzerFactory(), new CSharpAnalyzerFactory(), new VBAnalyzerFactory(), new CxxAnalyzerFactory(), new ShAnalyzerFactory(), PlainAnalyzerFactory.DEFAULT_INSTANCE, new UuencodeAnalyzerFactory(), new GZIPAnalyzerFactory(), new JavaAnalyzerFactory(), new JavaScriptAnalyzerFactory(), new PythonAnalyzerFactory(), new PerlAnalyzerFactory(), new PhpAnalyzerFactory(), new LispAnalyzerFactory(), new TclAnalyzerFactory(), new ScalaAnalyzerFactory(), new SQLAnalyzerFactory(), new PLSQLAnalyzerFactory(), new FortranAnalyzerFactory()}) {
            AnalyzerGuru.registerAnalyzer(analyzer);
        }
        string_ft_stored_nanalyzed_norms.setOmitNorms(false);
        string_ft_nstored_nanalyzed_norms.setOmitNorms(false);
        BOMS = new HashMap<String, byte[]>();
        BOMS.put("UTF-8", new byte[]{-17, -69, -65});
        BOMS.put("UTF-16BE", new byte[]{-2, -1});
        BOMS.put("UTF-16LE", new byte[]{-1, -2});
    }
}

