/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.AccuRevRepository;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class AccuRevHistoryParser
implements Executor.StreamHandler {
    private AccuRevRepository repository;
    private History history;
    private boolean foundHistory;

    History parse(File file, Repository repos) throws HistoryException {
        this.repository = (AccuRevRepository)repos;
        this.history = null;
        this.foundHistory = false;
        String relPath = this.repository.getDepotRelativePath(file);
        if (relPath.equals("/./")) {
            ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
            entries.add(new HistoryEntry("", new Date(), "OpenGrok", null, "Workspace Root", true));
            this.history = new History(entries);
        } else {
            try {
                Executor executor = this.repository.getHistoryLogExecutor(file);
                executor.exec(true, this);
                if (!this.foundHistory) {
                    executor = this.repository.getHistoryLogExecutor(file);
                    executor.exec(true, this);
                }
            }
            catch (IOException e) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"" + e);
            }
        }
        return this.history;
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        DateFormat df = this.repository.getDateFormat();
        HistoryEntry entry = null;
        this.history = new History();
        while ((line = in.readLine()) != null) {
            String[] data;
            if (line.startsWith("e")) continue;
            if (line.startsWith("t")) {
                data = line.split("; ");
                entry = new HistoryEntry();
                this.foundHistory = true;
                String user = data[3].replaceFirst("user: ", "");
                entry.setMessage("");
                entry.setAuthor(user);
                try {
                    Date date = df.parse(data[2]);
                    entry.setDate(date);
                }
                catch (ParseException pe) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Could not parse date: " + line, pe);
                }
                continue;
            }
            if (line.startsWith("  #")) {
                entry.appendMessage(line.substring(3));
                continue;
            }
            if (!line.startsWith("  v")) continue;
            data = line.split("\\s+");
            entry.setRevision(data[2]);
            entry.setActive(true);
            entries.add(entry);
        }
        this.history.setHistoryEntries(entries);
    }
}

