/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryCache;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.IOUtils;

class FileHistoryCache
implements HistoryCache {
    private final Object lock = new Object();
    private String historyCacheDirName = "historycache";
    private String latestRevFileName = "OpenGroklatestRev";
    private boolean historyIndexDone = false;

    FileHistoryCache() {
    }

    @Override
    public void setHistoryIndexDone() {
        this.historyIndexDone = true;
    }

    @Override
    public boolean isHistoryIndexDone() {
        return this.historyIndexDone;
    }

    private void doFileHistory(Map.Entry<String, List<HistoryEntry>> map_entry, RuntimeEnvironment env, Repository repository, File test, File root, boolean renamed) throws HistoryException {
        File file;
        History hist = null;
        if (renamed) {
            hist = repository.getHistory(test);
        }
        if (hist == null) {
            hist = new History();
            for (HistoryEntry ent : map_entry.getValue()) {
                ent.strip();
            }
            hist.setHistoryEntries(map_entry.getValue());
        } else {
            for (HistoryEntry ent : hist.getHistoryEntries()) {
                ent.strip();
            }
        }
        if (env.isTagsEnabled() && repository.hasFileBasedTags()) {
            repository.assignTagsInHistory(hist);
        }
        if (!(file = new File(root, map_entry.getKey())).isDirectory()) {
            this.storeFile(hist, file, repository);
        }
    }

    private boolean isRenamedFile(Map.Entry<String, List<HistoryEntry>> map_entry, RuntimeEnvironment env, Repository repository, History history) throws IOException {
        String fullfile = map_entry.getKey();
        String repodir = env.getPathRelativeToSourceRoot(new File(repository.getDirectoryName()), 0);
        String shortestfile = fullfile.substring(repodir.length() + 1);
        return history.isRenamed(shortestfile);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void optimize() {
    }

    @Override
    public boolean supportsRepository(Repository repository) {
        return true;
    }

    private static File getCachedFile(File file) throws HistoryException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(env.getDataRootPath());
        sb.append(File.separatorChar);
        sb.append("historycache");
        try {
            String add = env.getPathRelativeToSourceRoot(file, 0);
            if (add.length() == 0) {
                add = File.separator;
            }
            sb.append(add);
            sb.append(".gz");
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get path relative to source root for " + file, e);
        }
        return new File(sb.toString());
    }

    private static History readCache(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(new GZIPInputStream(in)));
        return (History)d.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFile(History histNew, File file, Repository repo) throws HistoryException {
        File output;
        File cache = FileHistoryCache.getCachedFile(file);
        History history = histNew;
        File dir = cache.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new HistoryException("Unable to create cache directory '" + dir + "'.");
        }
        try {
            History histOld = FileHistoryCache.readCache(cache);
            List<HistoryEntry> listOld = histOld.getHistoryEntries();
            if (!listOld.isEmpty()) {
                RuntimeEnvironment env = RuntimeEnvironment.getInstance();
                List<HistoryEntry> listNew = histNew.getHistoryEntries();
                ListIterator<HistoryEntry> li = listNew.listIterator(listNew.size());
                while (li.hasPrevious()) {
                    listOld.add(0, li.previous());
                }
                history = new History(listOld);
                if (env.isTagsEnabled() && repo.hasFileBasedTags()) {
                    for (HistoryEntry ent : history.getHistoryEntries()) {
                        ent.setTags(null);
                    }
                    repo.assignTagsInHistory(history);
                }
            }
        }
        catch (IOException listOld) {
            // empty catch block
        }
        try {
            output = File.createTempFile("oghist", null, dir);
            try (FileOutputStream out = new FileOutputStream(output);){
                XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new GZIPOutputStream(out)));
                Object object = null;
                try {
                    e.setPersistenceDelegate(File.class, new FilePersistenceDelegate());
                    e.writeObject(history);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (e != null) {
                        if (object != null) {
                            try {
                                e.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            e.close();
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new HistoryException("Failed to write history", ioe);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!cache.delete() && cache.exists()) {
                if (!output.delete()) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to remove temporary history cache file");
                }
                throw new HistoryException("Cachefile exists, and I could not delete it.");
            }
            if (!output.renameTo(cache)) {
                if (!output.delete()) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to remove temporary history cache file");
                }
                throw new HistoryException("Failed to rename cache tmpfile.");
            }
        }
    }

    private void finishStore(Repository repository, String latestRev) {
        this.storeLatestCachedRevision(repository, latestRev);
        OpenGrokLogger.getLogger().log(Level.FINE, "Done storing history for repo {0}", new Object[]{repository.getDirectoryName()});
    }

    @Override
    public void store(History history, Repository repository) throws HistoryException {
        final RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        String latestRev = null;
        List<HistoryEntry> entries = history.getHistoryEntries();
        if (entries.isEmpty()) {
            return;
        }
        OpenGrokLogger.getLogger().log(Level.FINE, "Storing history for repo {0}", new Object[]{repository.getDirectoryName()});
        HashMap map = new HashMap();
        for (HistoryEntry historyEntry : history.getHistoryEntries()) {
            if (latestRev == null) {
                latestRev = historyEntry.getRevision();
            }
            for (String string : historyEntry.getFiles()) {
                File test = new File(env.getSourceRootPath() + string);
                if (!test.exists()) continue;
                ArrayList<HistoryEntry> list = (ArrayList<HistoryEntry>)map.get(string);
                if (list == null) {
                    list = new ArrayList<HistoryEntry>();
                    map.put(string, list);
                }
                if (env.isTagsEnabled() && repository.hasFileBasedTags()) {
                    list.add(new HistoryEntry(historyEntry));
                    continue;
                }
                list.add(historyEntry);
            }
        }
        final File root = RuntimeEnvironment.getInstance().getSourceRootFile();
        for (Map.Entry<String, List<HistoryEntry>> entry : map.entrySet()) {
            try {
                if (RuntimeEnvironment.isRenamedFilesEnabled() && this.isRenamedFile(entry, env, repository, history)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "isRenamedFile() got exception: " + iOException);
            }
            this.doFileHistory(entry, env, repository, null, root, false);
        }
        if (!RuntimeEnvironment.isRenamedFilesEnabled()) {
            this.finishStore(repository, latestRev);
            return;
        }
        HashMap<String, List<HistoryEntry>> hashMap = new HashMap<String, List<HistoryEntry>>();
        for (Map.Entry<String, List<HistoryEntry>> entry : map.entrySet()) {
            try {
                if (!this.isRenamedFile(entry, env, repository, history)) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
            catch (IOException ex) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "isRenamedFile() got exception: " + ex);
            }
        }
        for (String string : hashMap.keySet()) {
            File cache = FileHistoryCache.getCachedFile(new File(env.getSourceRootPath() + string));
            File dir = cache.getParentFile();
            if (dir.isDirectory() || dir.mkdirs()) continue;
            OpenGrokLogger.getLogger().log(Level.WARNING, "Unable to create cache directory '" + dir + "'.");
        }
        final Repository repository2 = repository;
        final CountDownLatch countDownLatch = new CountDownLatch(hashMap.size());
        for (final Map.Entry map_entry : hashMap.entrySet()) {
            RuntimeEnvironment.getHistoryRenamedExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileHistoryCache.this.doFileHistory(map_entry, env, repository2, new File(env.getSourceRootPath() + (String)map_entry.getKey()), root, true);
                    }
                    catch (Exception ex) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "doFileHistory() got exception: " + ex);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "latch exception" + ex);
        }
        this.finishStore(repository, latestRev);
    }

    @Override
    public History get(File file, Repository repository, boolean withFiles) throws HistoryException {
        History history;
        long time;
        File cache = FileHistoryCache.getCachedFile(file);
        if (this.isUpToDate(file, cache)) {
            try {
                return FileHistoryCache.readCache(cache);
            }
            catch (Exception e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Error when reading cache file '" + cache, e);
            }
        }
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (this.isHistoryIndexDone() && repository.hasHistoryForDirectories() && !env.isFetchHistoryWhenNotInCache()) {
            return null;
        }
        try {
            time = System.currentTimeMillis();
            history = repository.getHistory(file);
            time = System.currentTimeMillis() - time;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        if (!file.isDirectory() && cache != null && (cache.exists() || time > (long)env.getHistoryReaderTimeLimit())) {
            this.storeFile(history, file, repository);
        }
        return history;
    }

    private boolean isUpToDate(File file, File cachedFile) {
        return cachedFile != null && cachedFile.exists() && file.lastModified() <= cachedFile.lastModified();
    }

    @Override
    public boolean hasCacheForDirectory(File directory, Repository repository) throws HistoryException {
        assert (directory.isDirectory());
        Repository repos = HistoryGuru.getInstance().getRepository(directory);
        if (repos == null) {
            return true;
        }
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        File dir = env.getDataRootFile();
        dir = new File(dir, this.historyCacheDirName);
        try {
            dir = new File(dir, env.getPathRelativeToSourceRoot(new File(repos.getDirectoryName()), 0));
        }
        catch (IOException e) {
            throw new HistoryException("Could not resolve " + repos.getDirectoryName() + " relative to source root", e);
        }
        return dir.exists();
    }

    public String getRepositoryHistDataDirname(Repository repository) {
        String repoDirBasename;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        Logger logger = OpenGrokLogger.getLogger();
        try {
            repoDirBasename = env.getPathRelativeToSourceRoot(new File(repository.getDirectoryName()), 0);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not resolve " + repository.getDirectoryName() + " relative to source root", ex);
            return null;
        }
        return env.getDataRootPath() + File.separatorChar + this.historyCacheDirName + repoDirBasename;
    }

    private String getRepositoryCachedRevPath(Repository repository) {
        return this.getRepositoryHistDataDirname(repository) + File.separatorChar + this.latestRevFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLatestCachedRevision(Repository repository, String rev) {
        Writer writer = null;
        Logger logger = OpenGrokLogger.getLogger();
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getRepositoryCachedRevPath(repository))));
            writer.write(rev);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "cannot write latest cached revision to file: " + ex.getCause());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.INFO, "cannot close file: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLatestCachedRevision(Repository repository) {
        String rev = null;
        Logger logger = OpenGrokLogger.getLogger();
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.getRepositoryCachedRevPath(repository)));
            try {
                rev = input.readLine();
                return rev;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "failed to load: {0}", e);
                String string = null;
                return string;
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e4) {
                    logger.log(Level.INFO, "failed to close: {0}", e4);
                }
            }
        }
        catch (FileNotFoundException e3) {
            logger.log(Level.FINE, "not loading latest cached revision file from " + this.getRepositoryCachedRevPath(repository));
            return null;
        }
    }

    @Override
    public Map<String, Date> getLastModifiedTimes(File directory, Repository repository) {
        return Collections.emptyMap();
    }

    @Override
    public void clear(Repository repository) {
        File cachedRevFile = new File(this.getRepositoryCachedRevPath(repository));
        cachedRevFile.delete();
        try {
            IOUtils.removeRecursive(Paths.get(this.getRepositoryHistDataDirname(repository), new String[0]));
        }
        catch (IOException ex) {
            Logger.getLogger(FileHistoryCache.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getInfo() {
        return this.getClass().getSimpleName();
    }

    static class FilePersistenceDelegate
    extends PersistenceDelegate {
        FilePersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            File f = (File)oldInstance;
            return new Expression(oldInstance, f.getClass(), "new", new Object[]{f.toString()});
        }
    }
}

