/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.PerforceHistoryParser;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class PerforceRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.Perforce";
    public static final String CMD_FALLBACK = "p4";
    private static final Pattern annotation_pattern = Pattern.compile("^(\\d+): .*");
    private static final PerforceRepository testRepo = new PerforceRepository();

    public PerforceRepository() {
        this.type = "Perforce";
    }

    @Override
    public Annotation annotate(File file, String rev) throws IOException {
        Annotation a = new Annotation(file.getName());
        List<HistoryEntry> revisions = PerforceHistoryParser.getRevisions(file, rev).getHistoryEntries();
        HashMap<String, String> revAuthor = new HashMap<String, String>();
        for (HistoryEntry entry : revisions) {
            revAuthor.put(entry.getRevision(), entry.getAuthor());
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("annotate");
        cmd.add("-q");
        cmd.add(file.getPath() + (rev == null ? "" : "#" + rev));
        Executor executor = new Executor(cmd, file.getParentFile());
        executor.exec();
        int lineno = 0;
        try (BufferedReader reader = new BufferedReader(executor.getOutputReader());){
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineno;
                Matcher matcher = annotation_pattern.matcher(line);
                if (matcher.find()) {
                    String revision = matcher.group(1);
                    String author = (String)revAuthor.get(revision);
                    a.addLine(revision, author, true);
                    continue;
                }
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotation in line " + lineno + ": [" + line + "]");
            }
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: Could not read annotations for " + file, e);
        }
        return a;
    }

    @Override
    InputStream getHistoryGet(String parent, String basename, String rev) {
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("print");
        cmd.add("-q");
        cmd.add(basename + (rev == null ? "" : "#" + rev));
        Executor executor = new Executor(cmd, new File(parent));
        executor.exec();
        return new ByteArrayInputStream(executor.getOutputString().getBytes());
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.getDirectoryName());
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("sync");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    @Override
    boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    public static boolean isInP4Depot(File file) {
        boolean status = false;
        if (testRepo.isWorking()) {
            Executor executor;
            ArrayList<String> cmd = new ArrayList<String>();
            String name = file.getName();
            File dir = file.getParentFile();
            if (file.isDirectory()) {
                dir = file;
                name = "*";
                cmd.add(PerforceRepository.testRepo.cmd);
                cmd.add("dirs");
                cmd.add(name);
                executor = new Executor(cmd, dir);
                executor.exec();
                boolean bl = status = executor.getOutputString().indexOf("//") != -1;
            }
            if (!status) {
                cmd.clear();
                cmd.add(PerforceRepository.testRepo.cmd);
                cmd.add("files");
                cmd.add(name);
                executor = new Executor(cmd, dir);
                executor.exec();
                status = executor.getOutputString().indexOf("//") != -1;
            }
        }
        return status;
    }

    @Override
    boolean isRepositoryFor(File file) {
        return PerforceRepository.isInP4Depot(file);
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = PerforceRepository.checkCmd(this.cmd, "help");
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new PerforceHistoryParser().parse(file, this);
    }
}

