/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.index;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.opensolaris.opengrok.Info;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.configuration.Configuration;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.RepositoryFactory;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.index.CommandLineOptions;
import org.opensolaris.opengrok.index.DefaultIndexChangedListener;
import org.opensolaris.opengrok.index.IndexChangedListener;
import org.opensolaris.opengrok.index.IndexDatabase;
import org.opensolaris.opengrok.index.IndexerException;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.util.Getopt;
import org.opensolaris.opengrok.util.Statistics;

public final class Indexer {
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String DIRBASED = "dirbased";
    private static final String UIONLY = "uionly";
    private static final Indexer index = new Indexer();
    static final Logger log = Logger.getLogger(Indexer.class.getName());
    private static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DERBY_CLIENT_DRIVER = "org.apache.derby.jdbc.ClientDriver";

    public static Indexer getInstance() {
        return index;
    }

    private static void A_usage() {
        System.err.println("ERROR: You must specify: -A .extension:class or -A prefix.:class");
        System.err.println("       Ex: -A .foo:org.opensolaris.opengrok.analysis.c.CAnalyzer");
        System.err.println("           will use the C analyzer for all files ending with .foo");
        System.err.println("       Ex: -A bar.:org.opensolaris.opengrok.analysis.c.CAnalyzer");
        System.err.println("           will use the C analyzer for all files starting with bar.");
        System.err.println("       Ex: -A .c:-");
        System.err.println("           will disable the c-analyzer for for all files ending with .c");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Statistics stats = new Statistics();
        boolean runIndex = true;
        boolean update = true;
        boolean optimizedChanged = false;
        ArrayList<String> zapCache = new ArrayList<String>();
        CommandLineOptions cmdOptions = new CommandLineOptions();
        if (argv.length == 0) {
            System.err.println(cmdOptions.getUsage());
            System.exit(1);
        } else {
            Executor.registerErrorHandler();
            boolean searchRepositories = false;
            ArrayList<String> subFiles = new ArrayList<String>();
            ArrayList<String> subFilesList = new ArrayList<String>();
            ArrayList<String> repositories = new ArrayList<String>();
            HashSet<String> allowedSymlinks = new HashSet<String>();
            String configFilename = null;
            String configHost = null;
            boolean addProjects = false;
            boolean refreshHistory = false;
            String defaultProject = null;
            boolean listFiles = false;
            boolean listRepos = false;
            boolean createDict = false;
            int noThreads = 2 + 2 * Runtime.getRuntime().availableProcessors();
            Getopt getopt = new Getopt(argv, cmdOptions.getCommandString());
            try {
                getopt.parse();
            }
            catch (ParseException ex) {
                System.err.println("OpenGrok: " + ex.getMessage());
                System.err.println(cmdOptions.getUsage());
                System.exit(1);
            }
            try {
                int optind;
                File sourceRootFile;
                File[] projectDirs;
                String fn;
                int cmd;
                Configuration cfg = null;
                while ((cmd = getopt.getOpt()) != -1) {
                    if (cmd != 82) continue;
                    cfg = Configuration.read(new File(getopt.getOptarg()));
                    break;
                }
                if (cfg == null) {
                    cfg = new Configuration();
                }
                String databaseDriver = cfg.getDatabaseDriver();
                String databaseURL = cfg.getDatabaseUrl();
                getopt.reset();
                block77: while ((cmd = getopt.getOpt()) != -1) {
                    switch (cmd) {
                        case 65: {
                            String[] arg = getopt.getOptarg().split(":");
                            boolean prefix = false;
                            if (arg.length != 2) {
                                Indexer.A_usage();
                            }
                            if (arg[0].endsWith(".")) {
                                arg[0] = arg[0].substring(0, arg[0].lastIndexOf(46)).toUpperCase();
                                prefix = true;
                            } else if (arg[0].startsWith(".")) {
                                arg[0] = arg[0].substring(arg[0].lastIndexOf(46) + 1).toUpperCase();
                            } else {
                                Indexer.A_usage();
                            }
                            if (arg[1].equals("-")) {
                                if (prefix) {
                                    AnalyzerGuru.addPrefix(arg[0], null);
                                    continue block77;
                                }
                                AnalyzerGuru.addExtension(arg[0], null);
                                continue block77;
                            }
                            if (prefix) {
                                try {
                                    AnalyzerGuru.addPrefix(arg[0], AnalyzerGuru.findFactory(arg[1]));
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "Unable to use {0} as a FileAnalyzerFactory", arg[1]);
                                    log.log(Level.SEVERE, "Stack: ", e.fillInStackTrace());
                                    System.exit(1);
                                }
                                continue block77;
                            }
                            try {
                                AnalyzerGuru.addExtension(arg[0], AnalyzerGuru.findFactory(arg[1]));
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "Unable to use {0} as a FileAnalyzerFactory", arg[1]);
                                log.log(Level.SEVERE, "Stack: ", e.fillInStackTrace());
                                System.exit(1);
                            }
                            continue block77;
                        }
                        case 97: {
                            if (getopt.getOptarg().equalsIgnoreCase(ON)) {
                                cfg.setAllowLeadingWildcard(true);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(OFF)) {
                                cfg.setAllowLeadingWildcard(false);
                                continue block77;
                            }
                            System.err.println("ERROR: You should pass either \"on\" or \"off\" as argument to -a");
                            System.err.println("       Ex: \"-a on\" will allow a search to start with a wildcard");
                            System.err.println("           \"-a off\" will disallow a search to start with a wildcard");
                            System.exit(1);
                            continue block77;
                        }
                        case 66: {
                            cfg.setUserPage(getopt.getOptarg());
                            continue block77;
                        }
                        case 67: {
                            cfg.setPrintProgress(true);
                            continue block77;
                        }
                        case 99: {
                            cfg.setCtags(getopt.getOptarg());
                            continue block77;
                        }
                        case 68: {
                            cfg.setHistoryCacheInDB(true);
                            continue block77;
                        }
                        case 100: {
                            File dataRoot = new File(getopt.getOptarg());
                            if (!dataRoot.exists() && !dataRoot.mkdirs()) {
                                System.err.println("ERROR: Cannot create data root");
                                System.exit(1);
                            }
                            if (!dataRoot.isDirectory()) {
                                System.err.println("ERROR: Data root must be a directory");
                                System.exit(1);
                            }
                            cfg.setDataRoot(dataRoot.getCanonicalPath());
                            continue block77;
                        }
                        case 101: {
                            cfg.setGenerateHtml(false);
                            continue block77;
                        }
                        case 71: {
                            cfg.setTagsEnabled(true);
                            continue block77;
                        }
                        case 72: {
                            refreshHistory = true;
                            continue block77;
                        }
                        case 104: {
                            repositories.add(getopt.getOptarg());
                            continue block77;
                        }
                        case 73: {
                            cfg.getIncludedNames().add(getopt.getOptarg());
                            continue block77;
                        }
                        case 105: {
                            cfg.getIgnoredNames().add(getopt.getOptarg());
                            continue block77;
                        }
                        case 106: {
                            switch (databaseDriver = getopt.getOptarg()) {
                                case "client": {
                                    databaseDriver = DERBY_CLIENT_DRIVER;
                                    break;
                                }
                                case "embedded": {
                                    databaseDriver = DERBY_EMBEDDED_DRIVER;
                                }
                            }
                            continue block77;
                        }
                        case 75: {
                            listRepos = true;
                            continue block77;
                        }
                        case 107: {
                            zapCache.add(getopt.getOptarg());
                            continue block77;
                        }
                        case 76: {
                            cfg.setWebappLAF(getopt.getOptarg());
                            continue block77;
                        }
                        case 108: {
                            if (getopt.getOptarg().equalsIgnoreCase(ON)) {
                                cfg.setUsingLuceneLocking(true);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(OFF)) {
                                cfg.setUsingLuceneLocking(false);
                                continue block77;
                            }
                            System.err.println("ERROR: You should pass either \"on\" or \"off\" as argument to -l");
                            System.err.println("       Ex: \"-l on\" will enable locks in Lucene");
                            System.err.println("           \"-l off\" will disable locks in Lucene");
                            continue block77;
                        }
                        case 109: {
                            try {
                                cfg.setRamBufferSize(Double.parseDouble(getopt.getOptarg()));
                            }
                            catch (NumberFormatException exp) {
                                System.err.println("ERROR: Failed to parse argument to \"-m\": " + exp.getMessage());
                                System.exit(1);
                            }
                            continue block77;
                        }
                        case 78: {
                            allowedSymlinks.add(getopt.getOptarg());
                            continue block77;
                        }
                        case 110: {
                            runIndex = false;
                            continue block77;
                        }
                        case 79: {
                            boolean oldval = cfg.isOptimizeDatabase();
                            if (getopt.getOptarg().equalsIgnoreCase(ON)) {
                                cfg.setOptimizeDatabase(true);
                            } else if (getopt.getOptarg().equalsIgnoreCase(OFF)) {
                                cfg.setOptimizeDatabase(false);
                            } else {
                                System.err.println("ERROR: You should pass either \"on\" or \"off\" as argument to -O");
                                System.err.println("       Ex: \"-O on\" will optimize the database as part of the index generation");
                                System.err.println("           \"-O off\" disable optimization of the index database");
                            }
                            if (oldval == cfg.isOptimizeDatabase()) continue block77;
                            optimizedChanged = true;
                            continue block77;
                        }
                        case 111: {
                            String CTagsExtraOptionsFile = getopt.getOptarg();
                            File CTagsFile = new File(CTagsExtraOptionsFile);
                            if (!CTagsFile.isFile() || !CTagsFile.canRead()) {
                                System.err.println("ERROR: File '" + CTagsExtraOptionsFile + "' not found for the -o option");
                                System.exit(1);
                            }
                            System.err.println("INFO: file with extra options for ctags: " + CTagsExtraOptionsFile);
                            cfg.setCTagsExtraOptionsFile(CTagsExtraOptionsFile);
                            continue block77;
                        }
                        case 80: {
                            addProjects = true;
                            continue block77;
                        }
                        case 112: {
                            defaultProject = getopt.getOptarg();
                            continue block77;
                        }
                        case 81: {
                            if (getopt.getOptarg().equalsIgnoreCase(ON)) {
                                cfg.setQuickContextScan(true);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(OFF)) {
                                cfg.setQuickContextScan(false);
                                continue block77;
                            }
                            System.err.println("ERROR: You should pass either \"on\" or \"off\" as argument to -Q");
                            System.err.println("       Ex: \"-Q on\" will just scan a \"chunk\" of the file and insert \"[..all..]\"");
                            System.err.println("           \"-Q off\" will try to build a more accurate list by reading the complete file.");
                            continue block77;
                        }
                        case 113: {
                            cfg.setVerbose(false);
                            OpenGrokLogger.setOGConsoleLogLevel(Level.WARNING);
                            continue block77;
                        }
                        case 82: {
                            continue block77;
                        }
                        case 114: {
                            if (getopt.getOptarg().equalsIgnoreCase(ON)) {
                                cfg.setRemoteScmSupported(Configuration.RemoteSCM.ON);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(OFF)) {
                                cfg.setRemoteScmSupported(Configuration.RemoteSCM.OFF);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(DIRBASED)) {
                                cfg.setRemoteScmSupported(Configuration.RemoteSCM.DIRBASED);
                                continue block77;
                            }
                            if (getopt.getOptarg().equalsIgnoreCase(UIONLY)) {
                                cfg.setRemoteScmSupported(Configuration.RemoteSCM.UIONLY);
                                continue block77;
                            }
                            System.err.println("ERROR: You should pass either \"on\" or \"off\" or \"uionly\" as argument to -r");
                            System.err.println("       Ex: \"-r on\" will allow retrieval for remote SCM systems");
                            System.err.println("           \"-r off\" will ignore SCM for remote systems");
                            System.err.println("           \"-r dirbased\" will allow retrieval during history index only for repositories which allow getting history for directories");
                            System.err.println("           \"-r uionly\" will support remote SCM for UI only");
                            continue block77;
                        }
                        case 83: {
                            searchRepositories = true;
                            continue block77;
                        }
                        case 115: {
                            File sourceRoot = new File(getopt.getOptarg());
                            if (!sourceRoot.isDirectory()) {
                                System.err.println("ERROR: Source root must be a directory");
                                System.exit(1);
                            }
                            cfg.setSourceRoot(sourceRoot.getCanonicalPath());
                            continue block77;
                        }
                        case 84: {
                            try {
                                noThreads = Integer.parseInt(getopt.getOptarg());
                            }
                            catch (NumberFormatException exp) {
                                System.err.println("ERROR: Failed to parse argument to \"-T\": " + exp.getMessage());
                                System.exit(1);
                            }
                            continue block77;
                        }
                        case 116: {
                            try {
                                int tmp = Integer.parseInt(getopt.getOptarg());
                                cfg.setTabSize(tmp);
                            }
                            catch (NumberFormatException exp) {
                                System.err.println("ERROR: Failed to parse argument to \"-t\": " + exp.getMessage());
                                System.exit(1);
                            }
                            continue block77;
                        }
                        case 85: {
                            configHost = getopt.getOptarg();
                            continue block77;
                        }
                        case 117: {
                            databaseURL = getopt.getOptarg();
                            continue block77;
                        }
                        case 86: {
                            System.out.println(Info.getFullVersion());
                            System.exit(0);
                            continue block77;
                        }
                        case 118: {
                            cfg.setVerbose(true);
                            OpenGrokLogger.setOGConsoleLogLevel(Level.INFO);
                            continue block77;
                        }
                        case 87: {
                            configFilename = getopt.getOptarg();
                            continue block77;
                        }
                        case 119: {
                            String webapp = getopt.getOptarg();
                            if (webapp.charAt(0) != '/' && !webapp.startsWith("http")) {
                                webapp = "/" + webapp;
                            }
                            if (webapp.endsWith("/")) {
                                cfg.setUrlPrefix(webapp + "s?");
                                continue block77;
                            }
                            cfg.setUrlPrefix(webapp + "/s?");
                            continue block77;
                        }
                        case 88: {
                            cfg.setUserPageSuffix(getopt.getOptarg());
                            continue block77;
                        }
                        case 122: {
                            try {
                                cfg.setScanningDepth(Integer.parseInt(getopt.getOptarg()));
                            }
                            catch (NumberFormatException exp) {
                                System.err.println("ERROR: Failed to parse argument to \"-z\": " + exp.getMessage());
                                System.exit(1);
                            }
                            continue block77;
                        }
                        case 63: {
                            System.err.println(cmdOptions.getUsage());
                            System.exit(0);
                            continue block77;
                        }
                    }
                    System.err.println("Internal Error - Unimplemented cmdline option: " + (char)cmd);
                    System.exit(1);
                }
                List<Class<? extends Repository>> repositoryClasses = RepositoryFactory.getRepositoryClasses();
                for (Class<? extends Repository> clazz : repositoryClasses) {
                    try {
                        Field f = clazz.getDeclaredField("CMD_PROPERTY_KEY");
                        File[] key = f.get(null);
                        if (key == null) continue;
                        cfg.setRepoCmd(clazz.getCanonicalName(), System.getProperty(key.toString()));
                    }
                    catch (Exception f) {}
                }
                if (cfg.isVerbose() && (fn = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern")) != null) {
                    System.out.println("Logging filehandler pattern: " + fn);
                }
                if (cfg.isHistoryCacheInDB()) {
                    if (databaseDriver == null) {
                        databaseDriver = DERBY_CLIENT_DRIVER;
                    }
                    if (databaseURL == null) {
                        StringBuilder defaultURL = new StringBuilder();
                        defaultURL.append("jdbc:derby:");
                        if (databaseDriver.equals(DERBY_EMBEDDED_DRIVER)) {
                            defaultURL.append(cfg.getDataRoot()).append(File.separator);
                        } else {
                            defaultURL.append("//localhost/");
                        }
                        defaultURL.append("cachedb;create=true");
                        databaseURL = defaultURL.toString();
                    }
                }
                cfg.setDatabaseDriver(databaseDriver);
                cfg.setDatabaseUrl(databaseURL);
                String file = cfg.getSourceRoot();
                if (file != null && (projectDirs = (sourceRootFile = new File(file)).listFiles()) != null) {
                    for (File projectDir : projectDirs) {
                        if (projectDir.getCanonicalPath().equals(projectDir.getAbsolutePath())) continue;
                        allowedSymlinks.add(projectDir.getAbsolutePath());
                    }
                }
                allowedSymlinks.addAll(cfg.getAllowedSymlinks());
                cfg.setAllowedSymlinks(allowedSymlinks);
                int orig_optind = optind = getopt.getOptind();
                if (optind != -1) {
                    while (optind < argv.length) {
                        subFilesList.add(cfg.getSourceRoot() + argv[optind++]);
                    }
                }
                RuntimeEnvironment env = RuntimeEnvironment.getInstance();
                env.setConfiguration(cfg, subFilesList);
                for (String path : subFilesList) {
                    path = path.substring(env.getSourceRootPath().length());
                    if (env.hasProjects()) {
                        if (Project.getProject(path) != null) {
                            subFiles.add(path);
                            continue;
                        }
                        System.err.println("The path " + path + " does not correspond to a project");
                        continue;
                    }
                    subFiles.add(path);
                }
                if (!subFilesList.isEmpty() && subFiles.isEmpty()) {
                    System.err.println("None of the paths were added, exiting");
                    System.exit(1);
                }
                if (RuntimeEnvironment.isRenamedFilesEnabled() && cfg.isHistoryCacheInDB()) {
                    System.out.println("History stored in DB and renamed file handling is on - possible performance degradation");
                }
                Indexer.getInstance().prepareIndexer(env, searchRepositories, addProjects, defaultProject, configFilename, refreshHistory, listFiles, createDict, subFiles, repositories, zapCache, listRepos);
                if (listRepos || !zapCache.isEmpty()) {
                    return;
                }
                if (runIndex || optimizedChanged && env.isOptimizeDatabase()) {
                    DefaultIndexChangedListener progress = new DefaultIndexChangedListener();
                    Indexer.getInstance().doIndexerExecution(update, noThreads, subFiles, progress);
                }
                Indexer.getInstance().sendToConfigHost(env, configHost);
            }
            catch (IndexerException ex) {
                log.log(Level.SEVERE, "Exception running indexer", ex);
                System.err.println(cmdOptions.getUsage());
                System.exit(1);
            }
            catch (Throwable e) {
                System.err.println("Exception: " + e.getLocalizedMessage());
                log.log(Level.SEVERE, "Unexpected Exception", e);
                System.exit(1);
            }
            finally {
                stats.report(log);
            }
        }
    }

    public void prepareIndexer(RuntimeEnvironment env, boolean searchRepositories, boolean addProjects, String defaultProject, String configFilename, boolean refreshHistory, boolean listFiles, boolean createDict, List<String> subFiles, List<String> repositories, List<String> zapCache, boolean listRepoPathes) throws IndexerException, IOException {
        if (env.getDataRootPath() == null) {
            throw new IndexerException("ERROR: Please specify a DATA ROOT path");
        }
        if (env.getSourceRootFile() == null) {
            throw new IndexerException("ERROR: please specify a SRC_ROOT with option -s !");
        }
        if (!env.validateExuberantCtags()) {
            throw new IndexerException("Didn't find Exuberant Ctags");
        }
        if (zapCache == null) {
            throw new IndexerException("Internal error, zapCache shouldn't be null");
        }
        if (searchRepositories || listRepoPathes || !zapCache.isEmpty()) {
            log.log(Level.INFO, "Scanning for repositories...");
            long start = System.currentTimeMillis();
            HistoryGuru.getInstance().addRepositories(env.getSourceRootPath());
            long time = (System.currentTimeMillis() - start) / 1000L;
            log.log(Level.INFO, "Done scanning for repositories ({0}s)", time);
            if (listRepoPathes || !zapCache.isEmpty()) {
                List<RepositoryInfo> repos = env.getRepositories();
                String prefix = env.getSourceRootPath();
                if (listRepoPathes) {
                    if (repos.isEmpty()) {
                        System.out.println("No repositories found.");
                        return;
                    }
                    System.out.println("Repositories in " + prefix + ":");
                    for (RepositoryInfo info : env.getRepositories()) {
                        String dir = info.getDirectoryName();
                        System.out.println(dir.substring(prefix.length()));
                    }
                }
                if (!zapCache.isEmpty()) {
                    HashSet<String> toZap = new HashSet<String>(zapCache.size() << 1);
                    boolean all = false;
                    for (String repo : zapCache) {
                        if ("*".equals(repo)) {
                            all = true;
                            break;
                        }
                        if (repo.startsWith(prefix)) {
                            repo = repo.substring(prefix.length());
                        }
                        toZap.add(repo);
                    }
                    if (all) {
                        toZap.clear();
                        for (RepositoryInfo info : env.getRepositories()) {
                            toZap.add(info.getDirectoryName().substring(prefix.length()));
                        }
                    }
                    try {
                        HistoryGuru.getInstance().removeCache(toZap);
                    }
                    catch (HistoryException e) {
                        log.log(Level.WARNING, "Clearing history cache failed: {0}", e.getLocalizedMessage());
                    }
                }
                return;
            }
        }
        if (addProjects) {
            File[] files = env.getSourceRootFile().listFiles();
            List<Project> projects = env.getProjects();
            HashMap<String, Project> oldProjects = new HashMap<String, Project>();
            for (Project p : projects) {
                oldProjects.put(p.getPath(), p);
            }
            projects.clear();
            for (File file : files) {
                String name = file.getName();
                String path = "/" + name;
                if (oldProjects.containsKey(path)) {
                    projects.add((Project)oldProjects.get(path));
                    continue;
                }
                if (name.startsWith(".") || !file.isDirectory()) continue;
                Project p = new Project();
                p.setDescription(name);
                p.setPath(path);
                p.setTabSize(env.getConfiguration().getTabSize());
                projects.add(p);
            }
            Collections.sort(projects, new Comparator<Project>(){

                @Override
                public int compare(Project p1, Project p2) {
                    String s1 = p1.getDescription();
                    String s2 = p2.getDescription();
                    int ret = s1 == null ? (s2 == null ? 0 : 1) : s1.compareTo(s2);
                    return ret;
                }
            });
        }
        if (defaultProject != null) {
            for (Project p : env.getProjects()) {
                if (!p.getPath().equals(defaultProject)) continue;
                env.setDefaultProject(p);
                break;
            }
        }
        if (configFilename != null) {
            log.log(Level.INFO, "Writing configuration to {0}", configFilename);
            env.writeConfiguration(new File(configFilename));
            log.info("Done...");
        }
        if (refreshHistory) {
            log.log(Level.INFO, "Generating history cache for all repositories ...");
            HistoryGuru.getInstance().createCache();
            log.info("Done...");
        } else if (repositories != null && !repositories.isEmpty()) {
            log.log(Level.INFO, "Generating history cache for specified repositories ...");
            HistoryGuru.getInstance().createCache(repositories);
            log.info("Done...");
        }
        if (listFiles) {
            IndexDatabase.listAllFiles(subFiles);
        }
        if (createDict) {
            IndexDatabase.listFrequentTokens(subFiles);
        }
    }

    public void doIndexerExecution(final boolean update, int noThreads, List<String> subFiles, IndexChangedListener progress) throws IOException {
        ExecutorService executor;
        Statistics elapsed;
        block12: {
            RuntimeEnvironment env;
            block10: {
                block11: {
                    elapsed = new Statistics();
                    env = RuntimeEnvironment.getInstance().register();
                    log.info("Starting indexing");
                    executor = Executors.newFixedThreadPool(noThreads);
                    if (subFiles != null && !subFiles.isEmpty()) break block10;
                    if (!update) break block11;
                    IndexDatabase.updateAll(executor, progress);
                    break block12;
                }
                if (!env.isOptimizeDatabase()) break block12;
                IndexDatabase.optimizeAll(executor);
                break block12;
            }
            ArrayList<IndexDatabase> dbs = new ArrayList<IndexDatabase>();
            for (String path : subFiles) {
                Project project = Project.getProject(path);
                if (project == null && env.hasProjects()) {
                    log.log(Level.WARNING, "Could not find a project for \"{0}\"", path);
                    continue;
                }
                IndexDatabase db = project == null ? new IndexDatabase() : new IndexDatabase(project);
                int idx = dbs.indexOf(db);
                if (idx != -1) {
                    db = (IndexDatabase)dbs.get(idx);
                }
                if (db.addDirectory(path)) {
                    if (idx != -1) continue;
                    dbs.add(db);
                    continue;
                }
                log.log(Level.WARNING, "Directory does not exist \"{0}\"", path);
            }
            for (final IndexDatabase db : dbs) {
                final boolean optimize = env.isOptimizeDatabase();
                db.addIndexChangedListener(progress);
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (update) {
                                db.update();
                            } else if (optimize) {
                                db.optimize();
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, "An error occured while " + (update ? "updating" : "optimizing") + " index", e);
                        }
                    }
                });
            }
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                executor.awaitTermination(999L, TimeUnit.DAYS);
            }
            catch (InterruptedException exp) {
                log.log(Level.WARNING, "Received interrupt while waiting for executor to finish", exp);
            }
        }
        try {
            RuntimeEnvironment.destroyRenamedHistoryExecutor();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, "destroying of renamed thread pool failed", ex);
        }
        elapsed.report(log, "Done indexing data of all repositories");
    }

    public void sendToConfigHost(RuntimeEnvironment env, String configHost) {
        if (configHost != null) {
            String[] cfg = configHost.split(":");
            log.log(Level.INFO, "Send configuration to: {0}", configHost);
            if (cfg.length == 2) {
                try {
                    InetAddress host = InetAddress.getByName(cfg[0]);
                    env.writeConfiguration(host, Integer.parseInt(cfg[1]));
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Failed to send configuration to " + configHost + " (is web application server running with opengrok deployed?)", ex);
                }
            } else {
                log.severe("Syntax error: ");
                for (String s : cfg) {
                    log.log(Level.SEVERE, "[{0}]", s);
                }
            }
            log.info("Configuration update routine done, check log output for errors.");
        }
    }

    private Indexer() {
    }
}

