/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.index.IndexChangedListener;
import org.opensolaris.opengrok.index.Indexer;
import org.opensolaris.opengrok.management.AgentIndexRunnerMBean;
import org.opensolaris.opengrok.management.Management;
import org.opensolaris.opengrok.management.NotificationHolder;

public final class AgentIndexRunner
implements AgentIndexRunnerMBean,
NotificationListener,
MBeanRegistration,
Runnable,
IndexChangedListener,
NotificationEmitter {
    private static transient AgentIndexRunner indexerInstance = null;
    private static final String NOTIFICATIONACTIONTYPE = "ogaaction";
    private static final String NOTIFICATIONEXCEPTIONTYPE = "ogaexception";
    private static final String NOTIFICATIONINFOSTRINGTYPE = "ogainfostring";
    private static final String NOTIFICATIONINFOLONGTYPE = "ogainfolong";
    private boolean enabled;
    private transient Thread indexThread = null;
    private static final Logger log = Logger.getLogger("org.opensolaris.opengrok");
    private RuntimeEnvironment env = null;
    private long lastIndexStart = 0L;
    private long lastIndexFinish = 0L;
    private long lastIndexUsedTime = 0L;
    private Exception lastException = null;
    private final Set<NotificationHolder> notifListeners = new HashSet<NotificationHolder>();
    private static long sequenceNo = 0L;
    private final StringBuilder notifications = new StringBuilder();
    private static final int MAXMESSAGELENGTH = 50000;

    private AgentIndexRunner(boolean enabledParam) {
        this.enabled = enabledParam;
    }

    public static synchronized AgentIndexRunner getInstance(boolean enabledParam) {
        if (indexerInstance == null) {
            indexerInstance = new AgentIndexRunner(enabledParam);
        }
        return indexerInstance;
    }

    @Override
    public ObjectName preRegister(MBeanServer serverParam, ObjectName name) {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void run() {
        try {
            File cfgFile;
            log.info("Running...");
            this.lastIndexStart = System.currentTimeMillis();
            this.lastException = null;
            this.doNotify(NOTIFICATIONINFOLONGTYPE, "StartIndexing", this.lastIndexStart);
            String configfile = Management.getInstance().getConfigurationFile();
            if (configfile == null) {
                this.doNotify(NOTIFICATIONEXCEPTIONTYPE, "Missing Configuration file", "");
            }
            if ((cfgFile = new File(configfile)).exists()) {
                this.env = RuntimeEnvironment.getInstance();
                log.log(Level.INFO, "Running indexer with configuration {0}", configfile);
                this.env.readConfiguration(cfgFile);
                Indexer index = Indexer.getInstance();
                int noThreads = Management.getInstance().getNumberOfThreads();
                boolean update = Management.getInstance().getUpdateIndexDatabase();
                String[] sublist = Management.getInstance().getSubFiles();
                log.info("Update source repositories");
                HistoryGuru.getInstance().updateRepositories();
                List<String> subFiles = Arrays.asList(sublist);
                log.log(Level.INFO, "Starting index, update {0} noThreads {1} subfiles {2}", new Object[]{String.valueOf(update), String.valueOf(noThreads), String.valueOf(subFiles.size())});
                index.doIndexerExecution(update, noThreads, subFiles, this);
                log.info("Finished indexing");
                this.lastIndexFinish = System.currentTimeMillis();
                this.sendNotifications();
                this.doNotify(NOTIFICATIONINFOLONGTYPE, "FinishedIndexing", this.lastIndexFinish);
                this.lastIndexUsedTime = this.lastIndexFinish - this.lastIndexStart;
                String publishhost = Management.getInstance().getPublishServerURL();
                if (publishhost == null || publishhost.equals("")) {
                    log.warning("No publishhost given, not sending updates");
                } else {
                    index.sendToConfigHost(this.env, publishhost);
                    this.doNotify(NOTIFICATIONINFOSTRINGTYPE, "Published index", publishhost);
                }
            } else {
                log.log(Level.WARNING, "Cannot Run indexing without proper configuration file {0}", configfile);
                this.doNotify(NOTIFICATIONEXCEPTIONTYPE, "Configuration file not valid", configfile);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception running indexing ", e);
            this.lastException = e;
        }
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void handleNotification(Notification n, Object hb) {
        if (n.getType().equals("timer.notification")) {
            log.finer("Received timer notification");
            if (this.enabled) {
                this.index(false);
            } else {
                log.info("Indexing is disabled, doing nothing");
            }
        } else {
            log.log(Level.WARNING, "Received unknown notification type: {0}", n.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(boolean waitForFinished) {
        log.info("Starting indexing.");
        AgentIndexRunner agentIndexRunner = this;
        synchronized (agentIndexRunner) {
            if (this.indexThread != null) {
                if (this.indexThread.isAlive()) {
                    log.warning("Previous indexer is still alive, will not start another.");
                    return;
                }
                log.fine("Previous indexer is no longer alive, starting a new one.");
            }
            this.indexThread = new Thread(this);
            try {
                this.indexThread.start();
                if (!waitForFinished) {
                    return;
                }
                log.fine("Waiting for indexer to finish...");
                this.indexThread.join();
                log.fine("indexer finished.");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Caught Exception while waiting for indexing to finish.", e);
            }
            return;
        }
    }

    @Override
    public void fileAdd(String path, String analyzer) {
        log.log(Level.INFO, "Add {0} analyzer {1}", new Object[]{path, analyzer});
    }

    @Override
    public void fileRemove(String path) {
        log.log(Level.INFO, "File remove {0}", path);
    }

    @Override
    public void fileUpdate(String path) {
        log.log(Level.INFO, "File updated {0}", path);
        this.addFileAction("U:", path);
    }

    @Override
    public void fileAdded(String path, String analyzer) {
        log.log(Level.INFO, "Added {0} analyzer {1}", new Object[]{path, analyzer});
        this.addFileAction("A:", path);
    }

    @Override
    public void fileRemoved(String path) {
        log.log(Level.INFO, "File removed {0}", path);
        this.addFileAction("R:", path);
    }

    private void addFileAction(String type, String path) {
        this.notifications.append('\n');
        this.notifications.append(type);
        this.notifications.append(path);
        if (this.notifications.length() > 50000) {
            this.sendNotifications();
        }
    }

    private void sendNotifications() {
        if (this.notifications.length() > 0) {
            this.doNotify(NOTIFICATIONACTIONTYPE, "FilesInfo", this.notifications.toString());
            this.notifications.delete(0, this.notifications.length());
        }
    }

    @Override
    public long lastIndexTimeFinished() {
        return this.lastIndexFinish;
    }

    @Override
    public long lastIndexTimeStarted() {
        return this.lastIndexStart;
    }

    @Override
    public long lastIndexTimeUsed() {
        return this.lastIndexUsedTime;
    }

    @Override
    public Exception getExceptions() {
        return this.lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener notiflistener, NotificationFilter notfilt, Object obj) throws IllegalArgumentException {
        log.log(Level.CONFIG, "Adds a notiflistner, with obj {0}", obj.toString());
        if (notiflistener == null) {
            throw new IllegalArgumentException("Must have legal NotificationListener");
        }
        Set<NotificationHolder> set = this.notifListeners;
        synchronized (set) {
            this.notifListeners.add(new NotificationHolder(notiflistener, notfilt, obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notiflistener) throws ListenerNotFoundException {
        log.info("removes a notiflistener, no obj");
        boolean removed = false;
        Set<NotificationHolder> set = this.notifListeners;
        synchronized (set) {
            Iterator<NotificationHolder> it = this.notifListeners.iterator();
            while (it.hasNext()) {
                NotificationHolder mnf = it.next();
                if (!mnf.getNL().equals(notiflistener)) continue;
                it.remove();
                removed = true;
            }
        }
        if (!removed) {
            throw new ListenerNotFoundException("Didn't remove the given NotificationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notiflistener, NotificationFilter filt, Object obj) throws ListenerNotFoundException {
        log.log(Level.CONFIG, "removes a notiflistener obj {0}", obj);
        boolean removed = false;
        Set<NotificationHolder> set = this.notifListeners;
        synchronized (set) {
            Iterator<NotificationHolder> it = this.notifListeners.iterator();
            while (it.hasNext()) {
                NotificationHolder mnf = it.next();
                if (!mnf.getNL().equals(notiflistener) || mnf.getFilter() != null && !mnf.getFilter().equals(filt) || mnf.getFilter() != null && !mnf.getObj().equals(obj)) continue;
                it.remove();
                removed = true;
            }
        }
        if (!removed) {
            throw new ListenerNotFoundException("Didn't remove the given NotificationListener");
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo minfo;
        MBeanNotificationInfo[] info = new MBeanNotificationInfo[1];
        String[] supptypes = new String[]{NOTIFICATIONACTIONTYPE, NOTIFICATIONINFOLONGTYPE, NOTIFICATIONINFOSTRINGTYPE};
        String name = "AgentIndexRunner";
        String descr = "OpenGrok Indexer Notifications";
        info[0] = minfo = new MBeanNotificationInfo(supptypes, name, descr);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify(String type, String msg, Object userdata) {
        try {
            log.log(Level.CONFIG, "start notifying {0} listeners", this.notifListeners.size());
            long ts = System.currentTimeMillis();
            Notification notif = new Notification(type, this, ++sequenceNo, ts, msg);
            notif.setUserData(userdata);
            Set<NotificationHolder> set = this.notifListeners;
            synchronized (set) {
                for (NotificationHolder nl : this.notifListeners) {
                    log.log(Level.FINE, "having one with obj {0}", nl.getObj());
                    try {
                        if (nl.getFilter() != null && !nl.getFilter().isNotificationEnabled(notif)) continue;
                        nl.getNL().handleNotification(notif, nl.getObj());
                    }
                    catch (Exception exnot) {
                        log.log(Level.WARNING, "Ex " + exnot, exnot);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception during notification sending: " + ex.getMessage(), ex);
        }
    }
}

