/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.parosproxy.paros.db.AbstractTable;
import org.parosproxy.paros.db.RecordAlert;

public class TableAlert
extends AbstractTable {
    private static final String ALERTID = "ALERTID";
    private static final String SCANID = "SCANID";
    private static final String PLUGINID = "PLUGINID";
    private static final String ALERT = "ALERT";
    private static final String RISK = "RISK";
    private static final String RELIABILITY = "RELIABILITY";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String URI = "URI";
    private static final String PARAM = "PARAM";
    private static final String OTHERINFO = "OTHERINFO";
    private static final String SOLUTION = "SOLUTION";
    private static final String REFERENCE = "REFERENCE";
    private static final String HISTORYID = "HISTORYID";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert1 = null;
    private CallableStatement psInsert2 = null;
    private PreparedStatement psDeleteAlert = null;
    private PreparedStatement psDeleteScan = null;

    protected void reconnect(Connection connection) throws SQLException {
        this.psRead = connection.prepareStatement("SELECT TOP 1 * FROM ALERT WHERE ALERTID = ?");
        this.psInsert1 = connection.prepareStatement("INSERT INTO ALERT (SCANID,PLUGINID,ALERT,RISK,RELIABILITY,DESCRIPTION,URI,PARAM,OTHERINFO,SOLUTION,REFERENCE,HISTORYID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.psInsert2 = connection.prepareCall("CALL IDENTITY();");
        this.psDeleteAlert = connection.prepareStatement("DELETE FROM ALERT WHERE ALERTID = ?");
    }

    public synchronized RecordAlert read(int n) throws SQLException {
        this.psRead.setInt(1, n);
        this.psRead.execute();
        ResultSet resultSet = this.psRead.getResultSet();
        return this.build(resultSet);
    }

    public synchronized RecordAlert write(int n, int n2, String string, int n3, int n4, String string2, String string3, String string4, String string5, String string6, String string7, int n5) throws SQLException {
        this.psInsert1.setInt(1, n);
        this.psInsert1.setInt(2, n2);
        this.psInsert1.setString(3, string);
        this.psInsert1.setInt(4, n3);
        this.psInsert1.setInt(5, n4);
        this.psInsert1.setString(6, string2);
        this.psInsert1.setString(7, string3);
        this.psInsert1.setString(8, string4);
        this.psInsert1.setString(9, string5);
        this.psInsert1.setString(10, string6);
        this.psInsert1.setString(11, string7);
        this.psInsert1.setInt(12, n5);
        this.psInsert1.executeUpdate();
        this.psInsert2.executeQuery();
        ResultSet resultSet = this.psInsert2.getResultSet();
        resultSet.next();
        int n6 = resultSet.getInt(1);
        return this.read(n6);
    }

    private RecordAlert build(ResultSet resultSet) throws SQLException {
        RecordAlert recordAlert = null;
        if (resultSet.next()) {
            recordAlert = new RecordAlert(resultSet.getInt(ALERTID), resultSet.getInt(SCANID), resultSet.getInt(PLUGINID), resultSet.getString(ALERT), resultSet.getInt(RISK), resultSet.getInt(RELIABILITY), resultSet.getString(DESCRIPTION), resultSet.getString(URI), resultSet.getString(PARAM), resultSet.getString(OTHERINFO), resultSet.getString(SOLUTION), resultSet.getString(REFERENCE), resultSet.getInt(HISTORYID));
        }
        return recordAlert;
    }

    public Vector getAlertListByScan(int n) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT WHERE SCANID = ?");
        Vector<Integer> vector = new Vector<Integer>();
        preparedStatement.setInt(1, n);
        preparedStatement.executeQuery();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            vector.add(new Integer(resultSet.getInt(ALERTID)));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public Vector getAlertListBySession(long l) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT INNER JOIN SCAN ON ALERT.SCANID = SCAN.SCANID WHERE SESSIONID = ?");
        Vector<Integer> vector = new Vector<Integer>();
        preparedStatement.setLong(1, l);
        preparedStatement.executeQuery();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n = resultSet.getInt(ALERTID);
            vector.add(new Integer(n));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public void deleteAlert(int n) throws SQLException {
        this.psDeleteAlert.setInt(1, n);
        this.psDeleteAlert.executeQuery();
    }
}

