<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) && isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
    die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
}

if (PHP_VERSION_ID < 80100) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
*                  .box/bin/check-requirements.php  fh  ^ʨ         .box/.requirements.phpY  fhY  BN﫤         .box/vendor/autoload.php   fh   s      ,   .box/vendor/composer/autoload_namespaces.php   fh   t!פ         .box/vendor/composer/LICENSE.  fh.         $   .box/vendor/composer/ClassLoader.php>  fh>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  fh6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  fh,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  fhK  ?      &   .box/vendor/composer/autoload_real.php   fh   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  fhu  	74      *   .box/vendor/composer/semver/src/Semver.php  fh  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  fh9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  fh  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  fh~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  fh'&  `         .box/src/Terminal.php
  fh
  %V         .box/src/IO.php   fh   [l%      !   .box/src/IsExtensionFulfilled.phpv  fhv  '0Ҥ         .box/src/Checker.php  fh  )W>      "   .box/src/IsPhpVersionFulfilled.php  fh  !83      "   .box/src/RequirementCollection.php  fh  Wb?         .box/src/Printer.php  fh  )8AV         .box/src/IsFulfilled.phpv   fhv   %*H         .box/src/Requirement.phpm  fhm  B         LICENSE  fh  p         dist/index.htmlH'  fhH'  ı         dist/api.php--  fh  L|R         dist/css/367.25211792.cssl  fhl  A         dist/css/app.166c0ebc.css  fh  JW         dist/css/10.71b41ac9.css  fh  ?         dist/css/909.2589534e.css  fh           dist/css/335.e18cb2b2.css  fh  26&         dist/css/826.11002f25.css  fh  +      #   dist/css/chunk-vendors.4b9d8264.cssu  fhu  wb         dist/css/275.ce753a3c.css?  fh?  Ld         dist/css/904.3a60e65a.css  fh  i_Ӥ         dist/css/347.9aa9997d.css  fh  %v         dist/js/769.5c14eb80.js  fh  ^         dist/js/44.c0c8c95e.jsخ  fhخ           dist/js/553.eda0ff3f.js  fh  ~d:         dist/js/542.e182a07d.jsN
  fhN
  EJˤ         dist/js/874.4606147f.jst  fht   O         dist/js/139.c5a9161d.jsU  fhU  x0L6         dist/js/638.8a383a62.js  fh  ¤         dist/js/560.7f91420f.jsU  fhU  ĜP         dist/js/551.1034c75f.js  fh  n^⊤         dist/js/830.05890cd9.js+O  fh+O  _"         dist/js/710.f0c86332.jsu| fhu| 0
         dist/js/669.6b0e80e8.js  fh           dist/js/581.6ae34674.js  fh  6         dist/js/851.8572e554.js֫  fh֫  Kͤ         dist/js/335.d92f9040.jse
  fhe
  	U         dist/js/28.b52b635a.jsw  fhw  Ig0         dist/js/486.fb0ed794.jsz  fhz  25         dist/js/523.ff2fd5c8.js  fh           dist/js/518.86f9f2d7.js  fh  ?MD         dist/js/140.e4ffde26.js=  fh=  3N         dist/js/721.a16cfeb1.js1  fh1  ڬ
j         dist/js/60.7ad170b9.jsC"  fhC"  !         dist/js/app.26b2f97d.js" fh" E{         dist/js/164.13f14642.jsܧ  fhܧ  :RD      !   dist/js/chunk-vendors.dd31abe1.jsKt fhKt EZY         dist/js/219.b20fd6c4.js  fh  q伤         dist/js/194.904ed20f.js  fh  Τ         dist/js/748.76aeaa8b.js  fh  	;         dist/js/606.6fd3bda7.js7  fh7  *d         dist/js/953.202bd9d7.js  fh  '3         dist/js/554.48c95a4a.js  fh  DW         dist/js/180.b89f7e5c.js=  fh=  N::B         dist/js/275.9cf88d25.jsb  fhb  V         dist/js/347.e06b6350.jsXP  fhXP  )         dist/js/367.9f262155.js[
  fh[
  p         dist/js/909.7d4e20a6.js  fh  n         dist/js/958.e4504427.jsS  fhS  CIsƤ         dist/js/540.df4fba52.jsy  fhy  ~y         dist/js/477.609f47f5.js  fh           dist/js/904.07d8a4c7.js%  fh%  
B         dist/js/52.8ccaa14f.js  fh  |         dist/js/120.c98d0708.js  fh  v"         dist/js/643.09f5239c.js}  fh}  Z?         dist/js/826.5c7bb000.js,  fh,            dist/js/716.76e8e69b.js  fh  1         dist/js/557.83bada25.js&  fh&  Ru/         dist/js/715.7396741a.js  fh  >         dist/js/706.1bae6418.js|  fh|  s_^      !   dist/img/button-show.2336e1d9.svgS  fhS  U         dist/img/warning.9a7cd776.svg   fh   fh         dist/img/logo.d9707286.svg  fh  ;w          dist/img/button-add.759df12e.svg   fh   O
         dist/img/favers.056e2836.svgH  fhH  y,ͤ      #   dist/img/server-config.1a2d0888.svgg  fhg  RN      %   dist/img/button-database.5282fc7e.svg   fh   P      "   dist/img/symfony-logo.5c162c73.svg
  fh
  Os@      !   dist/img/button-link.dd42e161.svg   fh   ֖>      (   dist/img/button-maintenance.93830369.svgE  fhE  O      $   dist/img/create-project.b22522ee.svg   fh   ʅ      )   dist/img/button-incompatible.3eb2b686.svg  fh  /$      #   dist/img/document-root.0e6dd2e4.svg   fh   D      '   dist/img/search-by-algolia.72f0ac9a.svg  fh           dist/img/boot.92149bf5.svg   fh   So      #   dist/img/button-search.44ce1d4b.svgL  fhL  w         dist/img/oauth.1243e742.svg.  fh.  @
         dist/img/private.a1c65662.svg  fh  _50w      %   dist/img/button-download.e1ba6f25.svg1  fh1  O#         dist/img/person.00d78897.svg   fh   w*      )   dist/img/widget-checkbox--on.8b830157.svg   fh   #;      !   dist/img/button-lock.98988f08.svgc  fhc  5=6z      "   dist/img/button-check.7a3b5ada.svg   fh   ]R         dist/img/user.129e863d.svg   fh   cǤ         dist/img/offline.0c23d1ce.svg  fh  У-      $   dist/img/button-passkey.3806f98a.svg=  fh=  }      (   dist/img/symfony-logo--dark.ea265042.svg  fh  溤      #   dist/img/private--dark.41b90022.svg  fh  b      &   dist/img/button-cloud-off.dd8ba18e.svg  fh  ܡ<      "   dist/img/button-power.298a8072.svg6  fh6  Kb      %   dist/img/downloads--dark.034bf7a3.svg-  fh-  	Ǥ      "   dist/img/button-trash.855f57fa.svgt  fht  2}          dist/img/link-blank.eb57b3fa.svg   fh   f^      &   dist/img/button-clipboard.9ef63d39.svgJ  fhJ  v,N      '   dist/img/widget-radio--off.4e93f443.svg  fh           dist/img/task.e9e5333f.svg{  fh{  Jl      #   dist/img/button-update.ad79c617.svg\  fh\  Į         dist/img/hint.ba2ac97e.svg!  fh!        !   dist/img/button-hide.d23f6533.svg  fh  m3(         dist/img/database.7f0a8c49.svg  fh  <	         dist/img/updated.3b47bebb.svgH  fhH  ʦ      $   dist/img/language--dark.a24e849e.svgx  fhx  G7?      !   dist/img/button-save.3b5224de.svg  fh           dist/img/lock.3c42a55f.svgf  fhf  gG      $   dist/img/button-details.8ce780e9.svg  fh  `         dist/img/downloads.c1db2a9e.svg0  fh0  ¤      "   dist/img/color_scheme.d527d153.svg   fh   t         dist/img/recovery.70ee118a.svg   fh   OTM`      #   dist/img/button-upload.ca8e9cfc.svg3  fh3  0U      !   dist/img/button-edit.40a4be06.svg  fh  !.      &   dist/img/link-blank--dark.07eeaee6.svg   fh   B|         dist/img/funding.cf78a0a0.svgJ  fhJ  `1_      #   dist/img/button-unlock.51b76e07.svgi  fhi  
         dist/img/php-logo.7376e212.svg	  fh	  k9q      #   dist/img/updated--dark.c21fdd5b.svgE  fhE  Ey      "   dist/img/button-cloud.bc42f267.svg  fh  I[      "   dist/img/favers--dark.4765f7d4.svgE  fhE        !   dist/img/button-more.e3eb2622.svg  fh  v         dist/img/language.582b2920.svg{  fh{  tW      &   dist/img/widget-radio--on.181461b6.svg:  fh:  j
M      $   dist/img/button-console.05dcdfc4.svg   fh   >y      (   dist/img/color_scheme--dark.ef0f0aed.svg:  fh:  <      !   dist/img/button-gear.a2dc1f09.svg  fh  0         dist/img/sad.c7de6e95.svg5  fh5  h          dist/img/button-run.b6310c5a.svg  fh           dist/img/close.8b27dbcb.svg   fh   e      "   dist/img/link-funding.b25cd92d.svg  fh  PԤ      *   dist/img/widget-checkbox--off.73856538.svg   fh   ~      (   dist/icons/task-active/favicon-16x16.png3  fh3  K       "   dist/icons/task-active/favicon.ico:  fh:  8      (   dist/icons/task-active/favicon-32x32.pngF  fhF  )fx      '   dist/icons/task-error/favicon-16x16.png;  fh;        !   dist/icons/task-error/favicon.ico:  fh:  u      '   dist/icons/task-error/favicon-32x32.pngB  fhB        )   dist/icons/task-success/favicon-16x16.pngU  fhU  {ؤ      #   dist/icons/task-success/favicon.ico:  fh:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  fhq  ?.         dist/api.php  fh  C¾         dist/assets/favicon-16x16.png  fh           dist/assets/mstile-310x310.png%  fh%  xH      &   dist/assets/android-chrome-384x384.png%  fh%  1|&      3   dist/assets/apple-touch-startup-image-1125x2436.png  fh  5      2   dist/assets/apple-touch-startup-image-1792x828.png  fh  8Q      2   dist/assets/apple-touch-startup-image-1334x750.png}y  fh}y  Դ         dist/assets/mstile-144x144.png  fh        3   dist/assets/apple-touch-startup-image-1290x2796.pngu  fhu  ^v         dist/assets/favicon.ico  fh  }*~      (   dist/assets/apple-touch-icon-120x120.png
  fh
        3   dist/assets/apple-touch-startup-image-2732x2048.png fh .uE      &   dist/assets/android-chrome-192x192.png3  fh3  '\          dist/assets/apple-touch-icon.png  fh  :5      3   dist/assets/apple-touch-startup-image-1242x2688.png&  fh&  :Pg      &   dist/assets/android-chrome-256x256.pngh  fhh  j't      3   dist/assets/apple-touch-startup-image-2436x1125.png  fh  5x         dist/assets/mstile-70x70.png  fh  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngP  fhP  n      3   dist/assets/apple-touch-startup-image-1170x2532.png@  fh@  ˨      *   dist/assets/apple-touch-icon-1024x1024.pngr|  fhr|  T      (   dist/assets/apple-touch-icon-152x152.png  fh  o      3   dist/assets/apple-touch-startup-image-1620x2160.pngb  fhb  RE      3   dist/assets/apple-touch-startup-image-1668x2388.png  fh  I      2   dist/assets/apple-touch-startup-image-828x1792.pngv  fhv  >H      3   dist/assets/apple-touch-startup-image-2048x1536.pngn fhn xEy      (   dist/assets/apple-touch-icon-180x180.png  fh  :5      (   dist/assets/yandex-browser-manifest.json   fh   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.pngv  fhv  <o      3   dist/assets/apple-touch-startup-image-2224x1668.png+ fh+       3   dist/assets/apple-touch-startup-image-1179x2556.pngZ  fhZ           dist/assets/favicon-48x48.png  fh  .i         dist/assets/mstile-310x150.png  fh  ƒܤ      3   dist/assets/apple-touch-startup-image-1242x2208.pngٸ  fhٸ  &Nf      (   dist/assets/apple-touch-icon-114x114.pngR	  fhR	  M      &   dist/assets/apple-touch-icon-76x76.png)  fh)  b      &   dist/assets/android-chrome-512x512.pngL6  fhL6  x9      3   dist/assets/apple-touch-startup-image-2556x1179.png  fh  jW      2   dist/assets/apple-touch-startup-image-1136x640.pngd  fhd  %¤      3   dist/assets/apple-touch-startup-image-2532x1170.png  fh  Ҫ      3   dist/assets/apple-touch-startup-image-2208x1242.png  fh  PQ      3   dist/assets/apple-touch-startup-image-1488x2266.pngb  fhb  Wzۤ      &   dist/assets/apple-touch-icon-57x57.png  fh  1@      2   dist/assets/apple-touch-startup-image-750x1334.pnga  fha  ΃      3   dist/assets/apple-touch-startup-image-2266x1488.pngP fhP aФ      ,   dist/assets/apple-touch-icon-precomposed.png  fh  :5      3   dist/assets/apple-touch-startup-image-2160x1620.png" fh" A'      3   dist/assets/apple-touch-startup-image-1284x2778.pngh  fhh  eX:      3   dist/assets/apple-touch-startup-image-1668x2224.pngl  fhl  N      3   dist/assets/apple-touch-startup-image-2688x1242.png  fh  v      &   dist/assets/apple-touch-icon-72x72.png  fh  ^F W      3   dist/assets/apple-touch-startup-image-2778x1284.png  fh   Z      3   dist/assets/apple-touch-startup-image-1536x2048.pngW  fhW  q)ݤ      3   dist/assets/apple-touch-startup-image-2388x1668.png1 fh1 [3j         dist/assets/mstile-150x150.png  fh  	          dist/assets/manifest.webmanifest  fh  `l      3   dist/assets/apple-touch-startup-image-2796x1290.png  fh  3ق      $   dist/assets/android-chrome-36x36.png+  fh+        $   dist/assets/android-chrome-96x96.png  fh  l@w      (   dist/assets/apple-touch-icon-167x167.png
  fh
  dP      $   dist/assets/android-chrome-72x72.png  fh  hQ\      &   dist/assets/apple-touch-icon-60x60.png  fh        3   dist/assets/apple-touch-startup-image-2160x1640.pngV& fhV& 7E      3   dist/assets/apple-touch-startup-image-2048x2732.pngDE fhDE bpF      (   dist/assets/apple-touch-icon-144x144.png	  fh	  Np      $   dist/assets/yandex-browser-50x50.pngX  fhX  X         dist/assets/browserconfig.xmlr  fhr  v,      $   dist/assets/android-chrome-48x48.png  fh  .i         dist/assets/favicon-32x32.png  fh  ɹ      &   dist/assets/android-chrome-144x144.png  fh        %   api/HttpKernel/ApiProblemResponse.php	  fh	        
   api/console--A  fhA  C~Ƥ         api/Config/UploadsConfig.php9  fh9  Bɤ         api/Config/UserConfig.php%  fh%  bf         api/Config/ManagerConfig.php9  fh9  v         api/Config/AbstractConfig.phpk  fhk  L@         api/Config/ComposerConfig.php  fh  5[
         api/Config/PartialConfig.php  fh  +tŅ         api/Config/AuthConfig.php  fh  $Ĥ      *   api/Security/PasswordlessAuthenticator.php
  fh
  E&      &   api/Security/WebauthnAuthenticator.phpr)  fhr)  If      #   api/Security/TokenAuthenticator.php  fh  <U7      ,   api/Security/AuthenticationTrustResolver.php  fh  M*Ѥ         api/Security/UserProvider.php  fh  &N}         api/Security/User.php/
  fh/
  [      !   api/Security/JwtAuthenticator.php	  fh	  %Ȥ      -   api/Security/AbstractBrowserAuthenticator.php  fh  ,         api/Security/TotpBadge.php;  fh;  lz      #   api/Security/LoginAuthenticator.php  fh  b         api/Security/JwtManager.php  fh        .   api/TaskOperation/Composer/RemoveOperation.php  fh  -8      2   api/TaskOperation/Composer/ClearCacheOperation.php  fh  [Ǥ      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  fh        /   api/TaskOperation/Composer/InstallOperation.php  fh  Y      .   api/TaskOperation/Composer/UpdateOperation.php  fh        /   api/TaskOperation/Composer/RequireOperation.phpJ  fhJ        5   api/TaskOperation/Composer/CreateProjectOperation.php  fh  2F=      -   api/TaskOperation/Composer/CloudOperation.phpC9  fhC9  ]$      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  fh  *դ      9   api/TaskOperation/Filesystem/RemoveArtifactsOperation.php  fh  dm-      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  fh  Nx      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php  fh        5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  fh  (٤      1   api/TaskOperation/Manager/SelfUpdateOperation.php  fh  3:      -   api/TaskOperation/AbstractInlineOperation.php
  fh
  \.      1   api/TaskOperation/SponsoredOperationInterface.php"  fh"  :      #   api/TaskOperation/ConsoleOutput.php?  fh?  Tv      .   api/TaskOperation/AbstractProcessOperation.phpK
  fhK
  KG      5   api/TaskOperation/Contao/MaintenanceModeOperation.phps  fhs  m6ͤ      2   api/TaskOperation/Contao/BackupCreateOperation.php<  fh<  w      1   api/TaskOperation/Contao/CacheWarmupOperation.phpX  fhX  hzۤ      2   api/TaskOperation/Contao/CreateContaoOperation.php  fh  g%+      3   api/TaskOperation/Contao/BackupRestoreOperation.php{  fh{  n<!      0   api/TaskOperation/Contao/CacheClearOperation.phpo  fho  n      ,   api/TaskOperation/TaskOperationInterface.php  fh  6         api/Composer/CloudResolver.phpM  fhM  ~2         api/Composer/CloudChanges.phpe  fhe  #l֤         api/Composer/CloudJob.php	  fh	  yP         api/Composer/CloudException.php  fh  ߬         api/Composer/Environment.php.  fh.        2   api/Resources/cache/url_generating_routes.php.meta!  fh!  w3      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  fh  wcA      %   api/Resources/cache/serialization.phpx   fhx   [J      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    fh              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.meta9y fh9y x      -   api/Resources/cache/url_generating_routes.phpv  fhv  w      +   api/Resources/cache/url_matching_routes.php5  fh5  v݈      0   api/Resources/cache/url_matching_routes.php.meta!  fh!  w3      T   api/Resources/cache/ContainerKdV5JCH/getSecurity_Firewall_Map_Context_ApiService.php\
  fh\
  9      W   api/Resources/cache/ContainerKdV5JCH/getContainer_GetRoutingConditionServiceService.php  fh  }Ѥ      F   api/Resources/cache/ContainerKdV5JCH/getComposerController2Service.php  fh        N   api/Resources/cache/ContainerKdV5JCH/getSecurity_UserCheckerLocatorService.php  fh  }Nդ      N   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsListService.php  fh  gk1      P   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsRemoveService.php  fh        C   api/Resources/cache/ContainerKdV5JCH/getGraphicsLibCheckService.php  fh  ډg      C   api/Resources/cache/ContainerKdV5JCH/getPhpCliControllerService.php  fh  A      Y   api/Resources/cache/ContainerKdV5JCH/getSecurity_Authenticator_ManagersLocatorService.php  fh  a      D   api/Resources/cache/ContainerKdV5JCH/getTaskDeleteCommandService.php  fh  
ۤ      `   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsEncryptFromLocal_LazyService.php~  fh~  R:      G   api/Resources/cache/ContainerKdV5JCH/getConstraintControllerService.php  fh  8&      V   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_BackedEnumResolverService.php  fh  b9      4   api/Resources/cache/ContainerKdV5JCH/removed-ids.phpI  fhI  y      G   api/Resources/cache/ContainerKdV5JCH/getProcessRunnerCommandService.php/  fh/  uWӟ      C   api/Resources/cache/ContainerKdV5JCH/getJwtAuthenticatorService.php  fh  Vz      C   api/Resources/cache/ContainerKdV5JCH/getContaoControllerService.php?  fh?  3      E   api/Resources/cache/ContainerKdV5JCH/getSecurity_AccessMapService.php*  fh*  RW      H   api/Resources/cache/ContainerKdV5JCH/getIntegrityCheckFactoryService.php?  fh?  Hw      Q   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_ContainerDebugService.php)  fh)  Ϣq      W   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_ContainerDebug_LazyService.php(  fh(  ђ*      H   api/Resources/cache/ContainerKdV5JCH/getWebauthnAuthenticatorService.php	  fh	  Dɤ      F   api/Resources/cache/ContainerKdV5JCH/getJwtCookieControllerService.php:  fh:  #      E   api/Resources/cache/ContainerKdV5JCH/getRouter_CacheWarmerService.phpu  fhu  ,      D   api/Resources/cache/ContainerKdV5JCH/getBackupRestoreTaskService.phpL  fhL  l0{      H   api/Resources/cache/ContainerKdV5JCH/getConsole_CommandLoaderService.phpN'  fhN'  r      <   api/Resources/cache/ContainerKdV5JCH/getCache_AppService.phpb  fhb  ?      M   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsSetService.php  fh  jL(      T   api/Resources/cache/ContainerKdV5JCH/getSecurity_Command_UserPasswordHashService.php  fh  K8      H   api/Resources/cache/ContainerKdV5JCH/getConsoleProcessFactoryService.phpd  fhd  !)
      \   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_ConfigDumpReference_LazyService.php^  fh^  _      C   api/Resources/cache/ContainerKdV5JCH/getCache_AppClearerService.php  fh  _Ť      A   api/Resources/cache/ContainerKdV5JCH/getUserControllerService.php  fh  x8s      N   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_RouterDebugService.php  fh  $      Q   api/Resources/cache/ContainerKdV5JCH/Contao_ManagerApi_ApiKernelProdContainer.phpa  fha  sѤ      W   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CachePoolPrune_LazyService.php  fh  %
      D   api/Resources/cache/ContainerKdV5JCH/getTaskUpdateCommandService.php  fh        A   api/Resources/cache/ContainerKdV5JCH/getTaskControllerService.php  fh  ZQ      L   api/Resources/cache/ContainerKdV5JCH/getMaintenanceModeControllerService.php  fh  aT      A   api/Resources/cache/ContainerKdV5JCH/getFileControllerService.php/  fh/  ߉      J   api/Resources/cache/ContainerKdV5JCH/get_ServiceLocator_Y_Xs7MwService.phpT  fhT  F      A   api/Resources/cache/ContainerKdV5JCH/getRouting_LoaderService.phpN
  fhN
  7      >   api/Resources/cache/ContainerKdV5JCH/getEnvironmentService.php  fh  ׫      T   api/Resources/cache/ContainerKdV5JCH/getSecurity_Listener_UserChecker_ApiService.php  fh  * +      C   api/Resources/cache/ContainerKdV5JCH/getServicesResetterService.php~  fh~  Iݬ      e   api/Resources/cache/ContainerKdV5JCH/getCache_SecurityIsGrantedAttributeExpressionLanguageService.php  fh  y{      D   api/Resources/cache/ContainerKdV5JCH/getOpcacheControllerService.php  fh  liw      P   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_AssetsInstallService.php  fh  p      Q   api/Resources/cache/ContainerKdV5JCH/getSerializer_Mapping_CacheWarmerService.php  fh        E   api/Resources/cache/ContainerKdV5JCH/getLoginAuthenticatorService.php  fh         O   api/Resources/cache/ContainerKdV5JCH/getSecurity_EventDispatcher_ApiService.php&  fh&  YM      ?   api/Resources/cache/ContainerKdV5JCH/getCache_SystemService.php  fh  5_      A   api/Resources/cache/ContainerKdV5JCH/getMonolog_LoggerService.php  fh  \KN      X   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CachePoolDelete_LazyService.php+  fh+  `;      J   api/Resources/cache/ContainerKdV5JCH/getMonolog_Logger_SecurityService.php  fh  HB      @   api/Resources/cache/ContainerKdV5JCH/getUpdateCommandService.php  fh  eӤ      Q   api/Resources/cache/ContainerKdV5JCH/getDebug_ErrorHandlerConfiguratorService.php\  fh\        I   api/Resources/cache/ContainerKdV5JCH/getTaskDeleteCommand_LazyService.php  fh  	      U   api/Resources/cache/ContainerKdV5JCH/getSecurity_Access_AuthenticatedVoterService.phpJ  fhJ  '      ?   api/Resources/cache/ContainerKdV5JCH/getProcessCheckService.php
  fh
  x.      D   api/Resources/cache/ContainerKdV5JCH/getSessionControllerService.php  fh  7z      V   api/Resources/cache/ContainerKdV5JCH/getSecurity_Listener_PasswordMigratingService.php$  fh$  nb@g      A   api/Resources/cache/ContainerKdV5JCH/getSelfUpdateTaskService.php*  fh*  D      X   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SerializerDebug_LazyService.php  fh        F   api/Resources/cache/ContainerKdV5JCH/getCache_GlobalClearerService.phpn  fhn  :b      >   api/Resources/cache/ContainerKdV5JCH/getTaskManagerService.php  fh  
m      H   api/Resources/cache/ContainerKdV5JCH/getConsole_ErrorListenerService.php  fh  ݺ{      K   api/Resources/cache/ContainerKdV5JCH/getUploadPackagesControllerService.php  fh  X      <   api/Resources/cache/ContainerKdV5JCH/getContaoApiService.php^  fh^  iB7      C   api/Resources/cache/ContainerKdV5JCH/getMemoryLimitCheckService.php  fh         W   api/Resources/cache/ContainerKdV5JCH/get_Security_Command_DebugFirewall_LazyService.php+  fh+  eD      B   api/Resources/cache/ContainerKdV5JCH/getSysTempDirCheckService.php  fh  j       V   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsRemove_LazyService.php  fh  <
<r      _   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_QueryParameterValueResolverService.php  fh  yx      I   api/Resources/cache/ContainerKdV5JCH/getTaskUpdateCommand_LazyService.php  fh  0      C   api/Resources/cache/ContainerKdV5JCH/getConfigControllerService.php  fh  @w      =   api/Resources/cache/ContainerKdV5JCH/getSelfUpdateService.php  fh  0!      C   api/Resources/cache/ContainerKdV5JCH/getTaskAbortCommandService.php  fh  T      @   api/Resources/cache/ContainerKdV5JCH/getCloudResolverService.php  fh  *      ^   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsDecryptToLocal_LazyService.php|  fh|  4      F   api/Resources/cache/ContainerKdV5JCH/getAccessKeyControllerService.php:  fh:  Z:H      S   api/Resources/cache/ContainerKdV5JCH/getPropertyInfo_SerializerExtractorService.php$  fh$        ?   api/Resources/cache/ContainerKdV5JCH/getUserProviderService.php  fh  ?)Wu      C   api/Resources/cache/ContainerKdV5JCH/getPhpWebControllerService.phpJ  fhJ  g      D   api/Resources/cache/ContainerKdV5JCH/getAboutCommand_LazyService.php  fh  AA      P   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_ContainerLintService.php<  fh<  бR      N   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_About_LazyService.php  fh  SŤ      T   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_RouterMatch_LazyService.php  fh  V      =   api/Resources/cache/ContainerKdV5JCH/getTranslatorService.php  fh  z      G   api/Resources/cache/ContainerKdV5JCH/getSelfUpdateControllerService.php  fh  ֻYS      K   api/Resources/cache/ContainerKdV5JCH/getSecurity_ChannelListenerService.php  fh  @^      L   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_VariadicService.php  fh  >
Ƥ      D   api/Resources/cache/ContainerKdV5JCH/getManagerControllerService.php7  fh7  ft[      C   api/Resources/cache/ContainerKdV5JCH/getBackupControllerService.php  fh  ^D      B   api/Resources/cache/ContainerKdV5JCH/getSecurity_HelperService.php;  fh;  8a      Q   api/Resources/cache/ContainerKdV5JCH/getSecurity_Listener_UserProviderService.php  fh        Q   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_YamlLint_LazyService.php  fh  I      @   api/Resources/cache/ContainerKdV5JCH/getSecrets_VaultService.phpE  fhE  ڴ&      V   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_ConfigDumpReferenceService.phpN  fhN  )=      N   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CacheWarmupService.phpS  fhS  C      U   api/Resources/cache/ContainerKdV5JCH/getSecurity_Access_RoleHierarchyVoterService.php*  fh*  S$      T   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_RequestAttributeService.php  fh  <      C   api/Resources/cache/ContainerKdV5JCH/getBackupCreateTaskService.phpG  fhG  w       L   api/Resources/cache/ContainerKdV5JCH/getProcessRunnerCommand_LazyService.php  fh  -oC      R   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CachePoolDeleteService.phpt  fht  ]?      B   api/Resources/cache/ContainerKdV5JCH/getCloudControllerService.php	  fh	  SeK      <   api/Resources/cache/ContainerKdV5JCH/getSetupTaskService.phpX  fhX  O       S   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsSet_LazyService.php  fh  A      E   api/Resources/cache/ContainerKdV5JCH/getTemplateControllerService.php  fh  fH      Z   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CachePoolInvalidateTagsService.php  fh  V3      ]   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_EventDispatcherDebug_LazyService.phpg  fhg  /xV      V   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CachePoolList_LazyService.php  fh   P      W   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_EventDispatcherDebugService.php  fh  iH      K   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_ServiceService.php  fh  *      `   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CachePoolInvalidateTags_LazyService.php  fh  G      T   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CacheWarmup_LazyService.php  fh  <!      F   api/Resources/cache/ContainerKdV5JCH/getCache_SystemClearerService.php  fh  }      J   api/Resources/cache/ContainerKdV5JCH/get_ServiceLocator_BvkMlPlService.phpP  fhP  p&      G   api/Resources/cache/ContainerKdV5JCH/getMonolog_Logger_TasksService.php  fh  	X°      F   api/Resources/cache/ContainerKdV5JCH/getAdminUserControllerService.phpB  fhB  N؉      H   api/Resources/cache/ContainerKdV5JCH/getIntegrityCheckCommandService.php  fh  ac9      V   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_AssetsInstall_LazyService.php)  fh)  B      [   api/Resources/cache/ContainerKdV5JCH/getSecurity_Firewall_EventDispatcherLocatorService.php  fh        R   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SerializerDebugService.php  fh  [f6O      E   api/Resources/cache/ContainerKdV5JCH/getPhpExtensionsCheckService.php(  fh(  )a      K   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_DefaultService.php  fh  -BK7      A   api/Resources/cache/ContainerKdV5JCH/getAuthControllerService.php  fh  $Ϧ      L   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_DatetimeService.php  fh  \WϹ      G   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_UidService.php  fh  g-      L   api/Resources/cache/ContainerKdV5JCH/getInstallToolLockControllerService.php  fh  X      E   api/Resources/cache/ContainerKdV5JCH/getUpdateCommand_LazyService.php  fh  sQ      E   api/Resources/cache/ContainerKdV5JCH/getComposerControllerService.php>  fh>  8p      K   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_SessionService.php  fh  ש      >   api/Resources/cache/ContainerKdV5JCH/getCacheWarmerService.php  fh  ]K      E   api/Resources/cache/ContainerKdV5JCH/getRedirectControllerService.php  fh  !K֤      @   api/Resources/cache/ContainerKdV5JCH/getUploadsConfigService.php  fh  Lň.      N   api/Resources/cache/ContainerKdV5JCH/getDatabaseMigrationControllerService.php=  fh=  XZ1u      K   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_YamlLintService.php	  fh	  f      G   api/Resources/cache/ContainerKdV5JCH/getConfigBuilder_WarmerService.php  fh  +Uz      L   api/Resources/cache/ContainerKdV5JCH/getPasswordlessAuthenticatorService.php  fh  X>      A   api/Resources/cache/ContainerKdV5JCH/getClearCacheTaskService.phpE  fhE        H   api/Resources/cache/ContainerKdV5JCH/getRootPackageControllerService.phpQ  fhQ  ̤      E   api/Resources/cache/ContainerKdV5JCH/getCache_App_TaggableService.php  fh  =L      @   api/Resources/cache/ContainerKdV5JCH/getContaoConsoleService.php  fh  ä      @   api/Resources/cache/ContainerKdV5JCH/getManagerConfigService.php  fh  L]      M   api/Resources/cache/ContainerKdV5JCH/getSecurity_UserValueResolverService.php  fh  EK      X   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_DebugAutowiring_LazyService.php8  fh8  $)E      Q   api/Resources/cache/ContainerKdV5JCH/getSecurity_Command_DebugFirewallService.php  fh  =w	      b   api/Resources/cache/ContainerKdV5JCH/getSecurity_Listener_CheckAuthenticatorCredentialsService.phpH  fhH  z[      W   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CachePoolClear_LazyService.php  fh  COD      M   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CacheClearService.php  fh  ǩ      D   api/Resources/cache/ContainerKdV5JCH/getPhpinfoControllerService.php  fh  ٽ      P   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CachePoolListService.php  fh  i
v      U   api/Resources/cache/ContainerKdV5JCH/getSecurity_Authenticator_Manager_ApiService.php  fh  ]>      E   api/Resources/cache/ContainerKdV5JCH/getAllowUrlFopenCheckService.php(  fh(  >      C   api/Resources/cache/ContainerKdV5JCH/getRebuildCacheTaskService.phpp  fhp  _.h      V   api/Resources/cache/ContainerKdV5JCH/getSecurity_Firewall_Authenticator_ApiService.php  fh  7"(      [   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsGenerateKey_LazyService.phpE  fhE  unH+      T   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_RouterDebug_LazyService.php  fh  ֤      Q   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CachePoolClearService.php_  fh_  lo      @   api/Resources/cache/ContainerKdV5JCH/getLogControllerService.php*  fh*  U      L   api/Resources/cache/ContainerKdV5JCH/getContainer_EnvVarProcessorService.php,  fh,  3      U   api/Resources/cache/ContainerKdV5JCH/getSecurity_Listener_Api_UserProviderService.php!  fh!  ݂      >   api/Resources/cache/ContainerKdV5JCH/getInstallTaskService.php#  fh#  `      T   api/Resources/cache/ContainerKdV5JCH/getContainer_EnvVarProcessorsLocatorService.php
  fh
  N      D   api/Resources/cache/ContainerKdV5JCH/getExceptionListenerService.php  fh        ?   api/Resources/cache/ContainerKdV5JCH/getSymlinkCheckService.php  fh  8ؔ      :   api/Resources/cache/ContainerKdV5JCH/getRequestService.php  fh  W\      ?   api/Resources/cache/ContainerKdV5JCH/getSessionCheckService.php
  fh
  [Ǥ      L   api/Resources/cache/ContainerKdV5JCH/getMissingPackagesControllerService.phpe  fhe  Xٜ      U   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsGenerateKeyService.php8  fh8  w      =   api/Resources/cache/ContainerKdV5JCH/getUpdateTaskService.php  fh  ,)      T   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_SecretsList_LazyService.php  fh  J      A   api/Resources/cache/ContainerKdV5JCH/getComposerConfigService.php   fh   O      Z   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsEncryptFromLocalService.php`  fh`  eN      J   api/Resources/cache/ContainerKdV5JCH/getSecurity_AccessListenerService.php  fh  SPA      Q   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_CachePoolPruneService.php  fh  	(      Z   api/Resources/cache/ContainerKdV5JCH/get_Security_Command_UserPasswordHash_LazyService.php6  fh6  @֤      N   api/Resources/cache/ContainerKdV5JCH/getSecurity_RouteLoader_LogoutService.php  fh  >B      T   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_ConfigDebug_LazyService.php  fh        e   api/Resources/cache/ContainerKdV5JCH/getContaoManager_Security_AuthenticationTrustResolverService.php  fh  Z٤      E   api/Resources/cache/ContainerKdV5JCH/getDatabaseControllerService.php  fh  G?Hh      X   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_SecretsDecryptToLocalService.phpd  fhd  OV      J   api/Resources/cache/ContainerKdV5JCH/getLocalPackagesControllerService.php[  fh[  hu      ?   api/Resources/cache/ContainerKdV5JCH/getAboutCommandService.php  fh  _
      H   api/Resources/cache/ContainerKdV5JCH/getTaskAbortCommand_LazyService.php  fh  Ǵ      V   api/Resources/cache/ContainerKdV5JCH/getSecurity_SecurityTokenValueResolverService.php@  fh@  /#(n      E   api/Resources/cache/ContainerKdV5JCH/getTokenAuthenticatorService.php  fh  ad      R   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_DebugAutowiringService.php  fh  Dr      =   api/Resources/cache/ContainerKdV5JCH/getServerInfoService.php  fh  0Y      N   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_RouterMatchService.php  fh  $9      M   api/Resources/cache/ContainerKdV5JCH/getIntegrityCheckCommand_LazyService.php  fh  f      J   api/Resources/cache/ContainerKdV5JCH/get_ServiceLocator_AH5O6SdService.phph  fhh  kN_      B   api/Resources/cache/ContainerKdV5JCH/getErrorControllerService.php  fh  DY      J   api/Resources/cache/ContainerKdV5JCH/get_ServiceLocator_EZsc_DOService.phpb  fhb  T      S   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_CacheClear_LazyService.php  fh  rZA"      K   api/Resources/cache/ContainerKdV5JCH/getArgumentResolver_RequestService.php  fh  c      P   api/Resources/cache/ContainerKdV5JCH/RequestPayloadValueResolverGhost8d82153.phpX  fhX  5      H   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_AboutService.php  fh  yS]      C   api/Resources/cache/ContainerKdV5JCH/getDumpAutoloadTaskService.phpO  fhO  {      V   api/Resources/cache/ContainerKdV5JCH/get_Console_Command_ContainerLint_LazyService.php8  fh8  Ƚ=Ǥ      N   api/Resources/cache/ContainerKdV5JCH/getConsole_Command_ConfigDebugService.php  fh  rW      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.php6v  fh6v  0J<      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php#  fh#  
1      F   api/Resources/cache/Symfony/Config/Framework/Webhook/RoutingConfig.phpv  fhv  j3      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php$  fh$  Ah;      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  fh
  	[b      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  fh  7eG      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.phpE  fhE  X      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  fh        d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php
  fh
  E      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.phpr  fhr         N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php=S  fh=S  >)
      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  fh  ,@Ϥ      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  fh	   !j      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php^  fh^  C"      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.phpF  fhF  $v      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php&  fh&  j      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.php	  fh	        U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpm  fhm  $S      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php  fh  9§      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  fh  -.-      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  fh  `o      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php7  fh7  g	      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php+  fh+  (      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpZ  fhZ  ¾      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.php^(  fh^(  2!ä      >   api/Resources/cache/Symfony/Config/Framework/WebhookConfig.php  fh  &J      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  fh  Ǚw      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.phpy   fhy         @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  fh  :i      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.php)  fh)  N      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpN  fhN  VN      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  fh	  h4      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php]  fh]  Eg :      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  fh  i:      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php-  fh-  5      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php1  fh1        F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  fh  R      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php,  fh,  lu      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php-  fh-  (      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php  fh  |Њ      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php
  fh
  ܤ      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  fh  pé      @   api/Resources/cache/Symfony/Config/Framework/SemaphoreConfig.php  fh  R8      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php  fh  |1      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  fh  S(      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php  fh  W      ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php  fh  +]      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.php  fh  Ot      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php?  fh?  [T      H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php]  fh]  zT      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  fh  i      \   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/DefaultMiddlewareConfig.php
  fh
  Ԥ      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php  fh        C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php5  fh5        =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php;  fh;        :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php  fh  ե      B   api/Resources/cache/Symfony/Config/Framework/RemoteeventConfig.php5  fh5  `      B   api/Resources/cache/Symfony/Config/Framework/AssetMapperConfig.phpY(  fhY(  Pm      D   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizerConfig.php*
  fh*
  
?      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpO  fhO        >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php`2  fh`2        N   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizer/SanitizerConfig.php9  fh9  ,      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.phpv  fhv  1      @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  fh  .m      ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.phpS  fhS  6S2      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.phpg  fhg  Ϊ      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php  fh  c:Ĥ      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php!  fh!  `      X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php9  fh9  r9`      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.phpF  fhF  Һ      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpn  fhn  }      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  fh  $      @   api/Resources/cache/Symfony/Config/Framework/SchedulerConfig.php3  fh3        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php
  fh
  ܥ;      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  fh  K      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php  fh  OK      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpO  fhO  >]      J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.php  fh  y4      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  fh  j{쾤      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  fh  73      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.php/n  fh/n  %k      P   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessTokenConfig.php  fh  dä      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php1  fh1  P'      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  fhA  ǌ       R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.php,*  fh,*  Ex      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  fh  j      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandlerConfig.php  fh  
Ƕ      j   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcUserInfoConfig.php
  fh
  
      b   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcConfig.php  fh  .}e      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  fh  \      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php  fh  8x      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php  fh  j a      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  fh
  >      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php3  fh3  ~1      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  fh  =      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php[  fh[  6O      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpNN  fhNN  jN      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  fh  B      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php  fh  I      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  fh  U8      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php   fh   E㲤      K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  fh  O^      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  fh  XAL      5   api/Resources/cache/Symfony/Config/SecurityConfig.php1  fh1  ?      4   api/Resources/cache/Symfony/Config/MonologConfig.php  fh  j%      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php>) fh>) 	      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  fh
  U      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php"  fh"  -      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  fh  ע      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  fh  !a      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpZ  fhZ  q:_      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  fh  =o      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  fh  =1ޤ      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php:  fh:  f ɤ      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php~  fh~  4:T      K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  fh  у      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php fh ?>      #   api/Resources/cache/annotations.map  fh  r'      "   api/Resources/config/services.yaml  fh  Q]      $   api/Resources/config/config_dev.yaml  fh        %   api/Resources/config/config_prod.yaml   fh   H          api/Resources/config/config.yaml*  fh*  "H         api/Resources/i18n/cs.yml  fh  Ւ         api/Resources/i18n/br.yml  fh           api/Resources/i18n/es.ymlj  fhj  X?         api/Resources/i18n/pt.yml  fh  hǤ         api/Resources/i18n/de.yml  fh  V=         api/Resources/i18n/it.yml  fh  `         api/Resources/i18n/pl.yml3  fh3  fi         api/Resources/i18n/fa.yml;	  fh;	  1,         api/Resources/i18n/sv.ymlN  fhN  tGDW         api/Resources/i18n/en.ymlm  fhm  hDh>         api/Resources/i18n/ja.yml  fh  8E~         api/Resources/i18n/ru.yml  fh  (         api/Resources/i18n/sr.yml  fh  jU         api/Resources/i18n/fr.yml7  fh7  	         api/Resources/i18n/lv.yml  fh           api/Resources/i18n/tr.yml  fh  ݇         api/Resources/i18n/nl.yml  fh  դ         api/Resources/i18n/zh.yml
  fh
  ^a         api/ApiApplication.php  fh  -r      #   api/Tests/Composer/CloudJobTest.php  fh  !L      '   api/Tests/Controller/LogPatternTest.php0  fh0  Ly      !   api/Controller/FileController.php  fh        !   api/Controller/UserController.phpC  fhC  Mh&          api/Controller/LogController.php  fh  '%      (   api/Controller/Config/AuthController.phpg  fhg  rI6      2   api/Controller/Config/AbstractConfigController.php  fh  <V      ,   api/Controller/Config/ComposerController.php  fh  gƤ      +   api/Controller/Config/ManagerController.php  fh  ݤ      !   api/Controller/TaskController.phpy  fhy  fId      *   api/Controller/Server/PhpWebController.phpD  fhD  1eŤ      *   api/Controller/Server/ContaoController.php"  fh"  ͚v      ,   api/Controller/Server/DatabaseController.php2
  fh2
  W?      -   api/Controller/Server/AdminUserController.php
  fh
  DV      +   api/Controller/Server/PhpinfoController.phpr  fhr  %E      +   api/Controller/Server/OpcacheController.php  fh  "      *   api/Controller/Server/ConfigController.php  fh  $      ,   api/Controller/Server/ComposerController.php?  fh?  j$Np      *   api/Controller/Server/PhpCliController.php  fh  K|Q      .   api/Controller/Server/SelfUpdateController.php  fh  $w      $   api/Controller/SessionController.phps  fhs  YK~      5   api/Controller/Packages/MissingPackagesController.php
  fh
  2c      4   api/Controller/Packages/UploadPackagesController.php'  fh'  O      1   api/Controller/Packages/RootPackageController.php'  fh'  &H)      +   api/Controller/Packages/CloudController.php  fh  a      3   api/Controller/Packages/LocalPackagesController.phpN  fhN        '   api/Controller/ConstraintController.phpY  fhY  kۤ      3   api/Controller/Contao/InstallToolLockController.php3  fh3  AÖ      5   api/Controller/Contao/DatabaseMigrationController.php%  fh%  Zb      -   api/Controller/Contao/AccessKeyController.php0  fh0  I>      *   api/Controller/Contao/BackupController.php,  fh,  >]6      3   api/Controller/Contao/MaintenanceModeController.php  fh  $iW      -   api/Controller/Contao/JwtCookieController.php  fh  bˤ         api/ApiKernel.php>&  fh>&  l         api/System/ServerInfo.phpq  fhq  ƾq         api/System/Request.php[  fh[  y9[<         api/System/SelfUpdate.phpD  fhD  qׂ         api/Task/TaskStatus.php=  fh=  %s      &   api/Task/Composer/DumpAutoloadTask.php  fh  Wj      $   api/Task/Composer/ClearCacheTask.php  fh        #   api/Task/Manager/SelfUpdateTask.php  fh  @?&         api/Task/AbstractTask.php  fh  ߪO         api/Task/Packages/SetupTask.php
  fh
  f          api/Task/Packages/UpdateTask.phpF+  fhF+  .      !   api/Task/Packages/InstallTask.php-  fh-  }~BC      *   api/Task/Packages/AbstractPackagesTask.php
  fh
  #c      $   api/Task/Contao/BackupCreateTask.php  fh  E      %   api/Task/Contao/BackupRestoreTask.php  fh  UF      $   api/Task/Contao/RebuildCacheTask.php  fh  lK         api/Task/TaskManager.phpC  fhC  W         api/Task/TaskInterface.php  fh  r         api/Task/TaskConfig.php	  fh	  /ʤ      %   api/Command/IntegrityCheckCommand.php	  fh	           api/Command/UpdateCommand.php  fh  %          api/Command/TaskAbortCommand.phpJ  fhJ  {P峤      !   api/Command/TaskUpdateCommand.phpz  fhz  k      $   api/Command/ProcessRunnerCommand.phpy  fhy  `݃y         api/Command/AboutCommand.php  fh  pSe      !   api/Command/TaskDeleteCommand.phpa  fha  
W         api/I18n/Translator.php
  fh
  q
      %   api/Exception/ApiProblemException.php5  fh5  W{       (   api/Exception/ProcessOutputException.php  fh  o      &   api/Exception/InvalidTotpException.php  fh  ʤ      &   api/Exception/InvalidJsonException.php
  fh
  8Y      "   api/Exception/RequestException.php  fh  Ű      )   api/IntegrityCheck/AllowUrlFopenCheck.php%  fh%  z2Ť      '   api/IntegrityCheck/GraphicsLibCheck.php  fh  kp¤         api/IntegrityCheck/ZipCheck.php  fh  k"      &   api/IntegrityCheck/SysTempDirCheck.php  fh  Ƥ      .   api/IntegrityCheck/IntegrityCheckInterface.php~  fh~        #   api/IntegrityCheck/ProcessCheck.php  fh  \.sg      #   api/IntegrityCheck/SymlinkCheck.php  fh  ;W      #   api/IntegrityCheck/SessionCheck.php  fh  ˭K      '   api/IntegrityCheck/MemoryLimitCheck.phpK  fhK  ^      )   api/IntegrityCheck/PhpExtensionsCheck.php  fh  	:      -   api/IntegrityCheck/AbstractIntegrityCheck.php  fh        ,   api/IntegrityCheck/IntegrityCheckFactory.php  fh  R,         api/Process/ContaoApi.phpF  fhF  B      !   api/Process/ProcessController.php  fh  ٧e      %   api/Process/Forker/AbstractForker.php
  fh
  ȮH      &   api/Process/Forker/ForkerInterface.phpn  fhn  |5oq      #   api/Process/Forker/DisownForker.php  fh  w4h      "   api/Process/Forker/NohupForker.php  fh  ZA      )   api/Process/Forker/WindowsStartForker.php  fh  a\"      #   api/Process/Forker/InlineForker.php  fh  Ѷ#         api/Process/Utf8Process.php  fh  x         api/Process/ProcessRunner.php  fh  |E         api/Process/AbstractProcess.php  fh  6?=         api/Process/ContaoConsole.php   fh   v)1      #   api/Process/PhpExecutableFinder.php  fh  r      %   api/Process/ConsoleProcessFactory.php  fh  k         api/console8  fh8  i.      $   api/EventListener/LocaleListener.php.  fh.        '   api/EventListener/ExceptionListener.php~
  fh~
  
      &   api/EventListener/SecurityListener.php  fh  O      '   api/EventListener/CheckTotpListener.php  fh  5%T      )   api/EventListener/JsonRequestListener.phpM  fhM  ä      
   downgrade.php0  fh0  8-ˤ      $   vendor/seld/phar-utils/composer.lock/  fh/  cւ(         vendor/seld/phar-utils/LICENSE"  fh"  ?e          vendor/seld/phar-utils/README.mde  fhe  :N      $   vendor/seld/phar-utils/composer.json;  fh;  =      %   vendor/seld/phar-utils/src/Linter.php
  fh
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  fhk  F         vendor/seld/jsonlint/LICENSE"  fh"  asy      !   vendor/seld/jsonlint/bin/jsonlint  fh   
      !   vendor/seld/jsonlint/CHANGELOG.md	  fh	  ݣʤ         vendor/seld/jsonlint/README.md
  fh
  f      "   vendor/seld/jsonlint/composer.jsonU  fhU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  fh  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  fh  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  fh"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  fh*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  fh,_  v      "   vendor/seld/signal-handler/LICENSE"  fh"  ?e      (   vendor/seld/signal-handler/composer.json  fh  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  fhO  ,C         vendor/autoload.php  fh  hU%u      $   vendor/phpstan/phpdoc-parser/LICENSEQ  fhQ  w      &   vendor/phpstan/phpdoc-parser/README.md  fh  {N      )   vendor/phpstan/phpdoc-parser/UPGRADING.md#  fh#  &~g      *   vendor/phpstan/phpdoc-parser/composer.json  fh  R	      0   vendor/phpstan/phpdoc-parser/src/Lexer/Lexer.php  fh  &eo      5   vendor/phpstan/phpdoc-parser/src/Printer/DiffElem.php  fh  
      3   vendor/phpstan/phpdoc-parser/src/Printer/Differ.phpj  fhj  yT      4   vendor/phpstan/phpdoc-parser/src/Printer/Printer.php7  fh7  x)      ;   vendor/phpstan/phpdoc-parser/src/Parser/ParserException.php	  fh	  2Ф      8   vendor/phpstan/phpdoc-parser/src/Parser/PhpDocParser.php  fh  ^      ;   vendor/phpstan/phpdoc-parser/src/Parser/ConstExprParser.php!  fh!  HH      ;   vendor/phpstan/phpdoc-parser/src/Parser/StringUnescaper.php\
  fh\
  k'#      6   vendor/phpstan/phpdoc-parser/src/Parser/TypeParser.php  fh  L      9   vendor/phpstan/phpdoc-parser/src/Parser/TokenIterator.php8)  fh8)  \j      1   vendor/phpstan/phpdoc-parser/src/ParserConfig.php`  fh`  Kä      V   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PureUnlessCallableIsImpureTagValueNode.php  fh  ;      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MixinTagValueNode.php  fh  0      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TemplateTagValueNode.php  fh        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagValueNode.php:  fh:  
f      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ThrowsTagValueNode.php  fh  }      U   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamLaterInvokedCallableTagValueNode.php  fh  OS^      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagValueNode.php   fh   ck      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagPropertyValueNode.php  fh  -      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireImplementsTagValueNode.php  fh  Z3      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SealedTagValueNode.php  fh  C      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ImplementsTagValueNode.php  fh  ^Ĥ      >   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTextNode.php  fh  h%      :   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocNode.php*  fh*  M0      L   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamClosureThisTagValueNode.php-  fh-  =H      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/GenericTagValueNode.php  fh  ~T      E   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasTagValueNode.phpc  fhc        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ReturnTagValueNode.php  fh  ^T      @   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/UsesTagValueNode.php  fh  Z!K      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueParameterNode.php4  fh4  ܤ      I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArgument.php  fh  =      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineAnnotation.php  fh  ;k      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineTagValueNode.php  fh  j$Ѥ      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArrayItem.php  fh  K      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArray.php  fh  (Ҥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/InvalidTagValueNode.php  fh  ^ߤ      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/VarTagValueNode.phpL  fhL  KHx      =   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagNode.php  fh  ɿ      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamOutTagValueNode.php%  fh%        I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypelessParamTagValueNode.php  fh  m#w      H   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagMethodValueNode.php  fh  {֤      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasImportTagValueNode.php  fh  jW      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PropertyTagValueNode.php   fh   7b!      [   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamImmediatelyInvokedCallableTagValueNode.php  fh  'D      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocChildNode.php   fh   )5Q      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ExtendsTagValueNode.php  fh  ݤ      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamTagValueNode.phpU  fhU  ~,      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueNode.php  fh  7Ǥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SelfOutTagValueNode.php  fh  L~      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/DeprecatedTagValueNode.php  fh  K]C      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireExtendsTagValueNode.php  fh  >      A   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstFetchNode.php  fh  "iT      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayNode.phpF  fhF  Y7      @   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNode.php   fh         F   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprStringNode.php  fh  &m      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprTrueNode.php5  fh5  #6      G   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprIntegerNode.php  fh  80      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFalseNode.php7  fh7  c󷯤      I   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayItemNode.php  fh  ۋ      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNullNode.php5  fh5  "      N   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/DoctrineConstExprStringNode.phpt  fht  <      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFloatNode.php  fh  Gʤ      4   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor.php
  fh
  һc      C   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor/CloningVisitor.php  fh        2   vendor/phpstan/phpdoc-parser/src/Ast/Attribute.phpp  fhp  B      -   vendor/phpstan/phpdoc-parser/src/Ast/Node.php  fh  I       ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/UnionTypeNode.php  fh  '¤      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/IntersectionTypeNode.php
  fh
  m      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/IdentifierTypeNode.php  fh  z21      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeItemNode.php  fh  ZҤ      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConstTypeNode.php  fh  V0	      G   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeParameterNode.php  fh        >   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeNode.phpz  fhz  z"      6   vendor/phpstan/phpdoc-parser/src/Ast/Type/TypeNode.php   fh   9      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeItemNode.php  fh  [Z      :   vendor/phpstan/phpdoc-parser/src/Ast/Type/ThisTypeNode.php'  fh'  |      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeNode.phpR  fhR  7Nf      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/InvalidTypeNode.phpg  fhg  L      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/OffsetAccessTypeNode.php  fh  4      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeNode.php  fh  Rפ      H   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeUnsealedTypeNode.php  fh  t       M   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeForParameterNode.php  fh  +$      >   vendor/phpstan/phpdoc-parser/src/Ast/Type/NullableTypeNode.php  fh  qo      <   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeNode.php  fh  \鿤      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/GenericTypeNode.php.  fh.  3      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayTypeNode.phpi  fhi  <p      <   vendor/phpstan/phpdoc-parser/src/Ast/AbstractNodeVisitor.php  fh  }$      0   vendor/phpstan/phpdoc-parser/src/Ast/Comment.php  fh  c軤      7   vendor/phpstan/phpdoc-parser/src/Ast/NodeAttributes.php+  fh+        6   vendor/phpstan/phpdoc-parser/src/Ast/NodeTraverser.php*  fh*           vendor/lcobucci/clock/LICENSE.  fh.  >z      #   vendor/lcobucci/clock/renovate.json   fh   ]G(      #   vendor/lcobucci/clock/composer.json,  fh,  ;      #   vendor/lcobucci/clock/src/Clock.php   fh   *	      )   vendor/lcobucci/clock/src/FrozenClock.php*  fh*  8o      )   vendor/lcobucci/clock/src/SystemClock.php  fh            vendor/bin/yaml-lint
  fh
  8<h      "   vendor/bin/patch-type-declarations`
  fh`
  +դ         vendor/bin/validate-json0
  fh0
  ̤         vendor/bin/composer	
  fh	
  k?ۤ         vendor/bin/var-dump-server?
  fh?
  &j         vendor/bin/jsonlint  fh  X      $   vendor/web-auth/webauthn-lib/LICENSE1  fh1  2      *   vendor/web-auth/webauthn-lib/composer.json	  fh	  =K      <   vendor/web-auth/webauthn-lib/src/FakeCredentialGenerator.php1  fh1  cF,Ȥ      1   vendor/web-auth/webauthn-lib/src/StringStream.php'  fh'  K1ۤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAlgorithm.php$  fh$  $      D   vendor/web-auth/webauthn-lib/src/CeremonyStep/TopOriginValidator.php   fh   Q      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserHandle.php  fh         P   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckHasAttestedCredentialData.phpC  fhC  $Q      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManager.php  fh  \TP      G   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserVerification.php3  fh3  PX,      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAllowedCredentialList.php  fh        C   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCredentialId.php  fh  \	      W   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAttestationFormatIsKnownAndValid.phpH  fhH  $@s      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckSignature.php  fh  !Ǥ      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/HostTopOriginValidator.php
  fh
  #o      K   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckRelyingPartyIdIdHash.php
  fh
  Oû      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckBackupBitsAreConsistent.php  fh  a      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserWasPresent.php  fh  w      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckClientDataCollectorType.php  fh  =&      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckChallenge.php  fh  g      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStep.php  fh  ujv      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCounter.php  fh  ʤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckTopOrigin.php  fh  "      =   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckOrigin.php  fh  Ť      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckExtensions.phpt  fht  =      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckMetadataStatement.php	   fh	   `      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManagerFactory.php  fh  ^fr      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialUserEntity.php  fh  yP      7   vendor/web-auth/webauthn-lib/src/CertificateToolbox.php  fh  µ      V   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensions.php  fh  ;k      [   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputCheckerHandler.php}  fh}  %}h      b   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientInputs.php  fh  `i      R   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputError.php  fh  H'      U   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtension.php  fh  R      T   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputChecker.php   fh   DA      c   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputs.php  fh  
QT      i   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputsLoader.php  fh  D+      e   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidSafetyNetAttestationStatementSupport.php66  fh66  v      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/FidoU2FAttestationStatementSupport.phpZ  fhZ  T      Z   vendor/web-auth/webauthn-lib/src/AttestationStatement/AppleAttestationStatementSupport.phpR  fhR  9      Y   vendor/web-auth/webauthn-lib/src/AttestationStatement/NoneAttestationStatementSupport.phpz  fhz  |       U   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupport.php  fh  0Hä      Q   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObjectLoader.php  fh  a      [   vendor/web-auth/webauthn-lib/src/AttestationStatement/PackedAttestationStatementSupport.php+  fh+  ɯ      K   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObject.php  fh  _f      _   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidKeyAttestationStatementSupport.phpM"  fhM"  O~O      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupportManager.php  fh  o      X   vendor/web-auth/webauthn-lib/src/AttestationStatement/TPMAttestationStatementSupport.php=  fh=  $3Y      N   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatement.php  fh  *      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialLoader.php  fh  x&      B   vendor/web-auth/webauthn-lib/src/SimpleFakeCredentialGenerator.php  fh  Aݤ      >   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBinding.php  fh  jhդ      H   vendor/web-auth/webauthn-lib/src/TokenBinding/SecTokenBindingHandler.php  fh        K   vendor/web-auth/webauthn-lib/src/TokenBinding/IgnoreTokenBindingHandler.php  fh  ɗCڤ      Q   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingNotSupportedHandler.php  fh  W      E   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingHandler.phph  fhh        <   vendor/web-auth/webauthn-lib/src/Util/CoseSignatureFixer.php`  fh`  _nW      0   vendor/web-auth/webauthn-lib/src/Util/Base64.phps  fhs  ݤ      ;   vendor/web-auth/webauthn-lib/src/AttestedCredentialData.php
  fh
  sr      /   vendor/web-auth/webauthn-lib/src/Credential.php  fh  h      N   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponseValidator.phpd2  fhd2  s      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialParameters.php	  fh	  #8r      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptor.php 
  fh 
  9\o      @   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRpEntity.phpX  fhX  {B      E   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponse.php  fh  J      ?   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialOptions.php  fh  ^9      6   vendor/web-auth/webauthn-lib/src/AuthenticatorData.phpo
  fho
  Wo      L   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptorCollection.php  fh  
?Ҥ      :   vendor/web-auth/webauthn-lib/src/AuthenticatorResponse.php  fh  J      L   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponseValidator.php0  fh0  Dߤ      C   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponse.php=  fh=  Ȫ       W   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/PhpCertificateChainChecker.php  fh  {Ϥ      T   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/CertificateChainChecker.php  fh  2Ƥ      F   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRequestOptions.php.  fh.  Dg      <   vendor/web-auth/webauthn-lib/src/AuthenticatorDataLoader.php  fh  Lڤ      H   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSourceRepository.php   fh   z      >   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPathLoader.php  fh  @b      B   vendor/web-auth/webauthn-lib/src/TrustPath/EcdaaKeyIdTrustPath.php  fh  ,q      8   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPath.php  fh  "ߣ      =   vendor/web-auth/webauthn-lib/src/TrustPath/EmptyTrustPath.php  fh  b_      C   vendor/web-auth/webauthn-lib/src/TrustPath/CertificateTrustPath.php  fh  A#      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialEntity.php  fh         L   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollector.phpA  fhA  У      S   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollectorManager.php  fh  [6      X   vendor/web-auth/webauthn-lib/src/ClientDataCollector/WebauthnAuthenticationCollector.php  fh  =m      D   vendor/web-auth/webauthn-lib/src/Counter/ThrowExceptionIfInvalid.phpw  fhw  <Sڤ      ;   vendor/web-auth/webauthn-lib/src/Counter/CounterChecker.php  fh        V   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionsDenormalizer.php	  fh	  Jo0Ӥ      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationStatementDenormalizer.php  fh        S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionNormalizer.php  fh  9A      G   vendor/web-auth/webauthn-lib/src/Denormalizer/TrustPathDenormalizer.php  fh        Q   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDenormalizer.php  fh  ژؤ      K   vendor/web-auth/webauthn-lib/src/Denormalizer/WebauthnSerializerFactory.phpF
  fhF
  y      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/CollectedClientDataDenormalizer.php  fh  ߺ䥤      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialParametersDenormalizer.php  fh  1      ^   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAttestationResponseDenormalizer.php:  fh:  .֤      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestedCredentialDataNormalizer.phpj  fhj  !wJ      Y   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDescriptorNormalizer.phpy  fhy  薆      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorDataDenormalizer.php  fh  IV      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationObjectDenormalizer.php|  fh|  =G      W   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialSourceDenormalizer.php  fh  h2eԤ      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialUserEntityDenormalizer.php  fh  Wݤ      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/ExtensionDescriptorDenormalizer.php(  fh(  PwФ      _   vendor/web-auth/webauthn-lib/src/Denormalizer/VerificationMethodANDCombinationsDenormalizer.php  fh  Eڵ      \   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAssertionResponseDenormalizer.php  fh  s2P      S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorResponseDenormalizer.php  fh  Wi      X   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialOptionsDenormalizer.php  fh  w~      8   vendor/web-auth/webauthn-lib/src/PublicKeyCredential.php  fh        D   vendor/web-auth/webauthn-lib/src/MetadataService/Psr18HttpClient.phpf  fhf  	\      K   vendor/web-auth/webauthn-lib/src/MetadataService/StatusReportRepository.php3  fh3  |`4&      _   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateChainValidator.phpT  fhT  Ѓv      X   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateToolbox.php  fh  W֮y      b   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/PhpCertificateChainValidator.php'  fh'  K%C      ?   vendor/web-auth/webauthn-lib/src/MetadataService/CanLogData.php   fh   .j       P   vendor/web-auth/webauthn-lib/src/MetadataService/MetadataStatementRepository.php  fh  8T      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/ExtensionDescriptor.php  fh  I      U   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/CodeAccuracyDescriptor.php	  fh	  P2      X   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/PatternAccuracyDescriptor.php	  fh	  7\      P   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/MetadataStatement.phpQ  fhQ  02      S   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorGetInfo.php  fh  ;T      `   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodANDCombinations.php  fh  J      T   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricStatusReport.php  fh  t%{      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorStatus.php  fh  IJ>      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AbstractDescriptor.phpC  fhC  e0@      O   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/EcdaaTrustAnchor.php0
  fh0
  Ҩ      K   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/StatusReport.php7  fh7  P	      [   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodDescriptor.php!  fh!   +9      V   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AlternativeDescriptions.php+  fh+  c      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricAccuracyDescriptor.php	  fh	  nX}}      F   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/Version.phpV	  fhV	        N   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RgbPaletteEntry.php\	  fh\	  Pnu      M   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RogueListEntry.php  fh  x"#      b   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/DisplayPNGCharacteristicsDescriptor.php  fh  ꠼      @   vendor/web-auth/webauthn-lib/src/MetadataService/ValueFilter.phpo  fho  jPOϤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/ExtensionDescriptorDenormalizer.php  fh  Ћz      d   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/MetadataStatementSerializerFactory.php  fh  yx      a   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FidoAllianceCompliantMetadataService.php'  fh'  +X5դ      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/JsonMetadataService.php	  fh	  K      R   vendor/web-auth/webauthn-lib/src/MetadataService/Service/StringMetadataService.php  fh  :)Ĥ      U   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayloadEntry.php  fh  7      [   vendor/web-auth/webauthn-lib/src/MetadataService/Service/DistantResourceMetadataService.php  fh  fB      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayload.php  fh  4n      L   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataService.php  fh        Y   vendor/web-auth/webauthn-lib/src/MetadataService/Service/LocalResourceMetadataService.php

  fh

  i      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/ChainedMetadataServices.php  fh        Z   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FolderResourceMetadataService.php
  fh
  -NZ      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/InMemoryMetadataService.phpA  fhA  T      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/InvalidCertificateException.php  fh  z]      W   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataServiceException.php  fh  Y1ص      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/ExpiredCertificateException.php  fh  g/      S   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateException.phpq  fhq  h      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MissingMetadataStatementException.php  fh  m %      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/RevokedCertificateException.php  fh  /      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementLoadingException.php  fh  /V      Y   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementException.php  fh  c       X   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateChainException.php  fh  ]ཤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateRevocationListException.php  fh  [      L   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CanDispatchEvents.phpU  fhU  x      H   vendor/web-auth/webauthn-lib/src/MetadataService/Event/WebauthnEvent.phpA  fhA  o      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/BeforeCertificateChainValidation.php  fh  <s
      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationFailed.php  fh  @2      ^   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationSucceeded.php  fh  
$      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Event/MetadataStatementFound.phpp  fhp  3	      N   vendor/web-auth/webauthn-lib/src/MetadataService/Event/NullEventDispatcher.phpa  fha  D
      C   vendor/web-auth/webauthn-lib/src/AuthenticatorSelectionCriteria.phpH   fhH   EѤ      X   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementVerificationException.phpn  fhn  66      J   vendor/web-auth/webauthn-lib/src/Exception/InvalidCertificateException.php  fh  ,s      S   vendor/web-auth/webauthn-lib/src/Exception/InvalidAttestationStatementException.php  fh        G   vendor/web-auth/webauthn-lib/src/Exception/MetadataServiceException.php1  fh1  \	      O   vendor/web-auth/webauthn-lib/src/Exception/AuthenticationExtensionException.php:  fh:  CVs      @   vendor/web-auth/webauthn-lib/src/Exception/WebauthnException.php*  fh*  m2      H   vendor/web-auth/webauthn-lib/src/Exception/InvalidTrustPathException.php3  fh3  ".      Y   vendor/web-auth/webauthn-lib/src/Exception/AuthenticatorResponseVerificationException.php>  fh>  
      J   vendor/web-auth/webauthn-lib/src/Exception/ExpiredCertificateException.php  fh  p      J   vendor/web-auth/webauthn-lib/src/Exception/UnsupportedFeatureException.php5  fh5  G      C   vendor/web-auth/webauthn-lib/src/Exception/CertificateException.phpO  fhO  Zl      P   vendor/web-auth/webauthn-lib/src/Exception/MissingMetadataStatementException.php;  fh;  )<Ԥ      J   vendor/web-auth/webauthn-lib/src/Exception/RevokedCertificateException.php   fh   cO      L   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementException.php   fh   n      P   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementLoadingException.phpz  fhz  $BC      ?   vendor/web-auth/webauthn-lib/src/Exception/CounterException.phpL  fhL        I   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementException.php   fh   ng      H   vendor/web-auth/webauthn-lib/src/Exception/CertificateChainException.php  fh  [4ۤ      S   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementLoadingException.php  fh        C   vendor/web-auth/webauthn-lib/src/Exception/InvalidDataException.php  fh  ޘ+      Q   vendor/web-auth/webauthn-lib/src/Exception/CertificateRevocationListException.php  fh  q9      I   vendor/web-auth/webauthn-lib/src/Exception/InvalidUserHandleException.phpe  fhe  |      1   vendor/web-auth/webauthn-lib/src/U2FPublicKey.php  fh  T      <   vendor/web-auth/webauthn-lib/src/Event/CanDispatchEvents.php  fh  ':      c   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationSucceededEvent.php7  fh7  \Z      8   vendor/web-auth/webauthn-lib/src/Event/WebauthnEvent.phpg   fhg   >G      B   vendor/web-auth/webauthn-lib/src/Event/AttestationObjectLoaded.php  fh  ob      a   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationSucceededEvent.php  fh         ^   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationFailedEvent.php  fh  o~֤      K   vendor/web-auth/webauthn-lib/src/Event/BeforeCertificateChainValidation.phpX  fhX  /      K   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationFailed.phpX  fhX  p      N   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationSucceeded.php[  fh[  (ɤ      A   vendor/web-auth/webauthn-lib/src/Event/MetadataStatementFound.php  fh  
      >   vendor/web-auth/webauthn-lib/src/Event/NullEventDispatcher.php8  fh8  }o      `   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationFailedEvent.php  fh  <?      E   vendor/web-auth/webauthn-lib/src/Event/AttestationStatementLoaded.php  fh  |7      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSource.php"  fh"  Ik      G   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialCreationOptions.phpo)  fho)  í      8   vendor/web-auth/webauthn-lib/src/CollectedClientData.phpr  fhr  +Ĥ          vendor/web-auth/cose-lib/LICENSE,  fh,  C      "   vendor/web-auth/cose-lib/README.md  fh  Ŭ      &   vendor/web-auth/cose-lib/composer.json  fh  uN      $   vendor/web-auth/cose-lib/SECURITY.md  fh  Y{      %   vendor/web-auth/cose-lib/src/Hash.php  fh  8pȤ      (   vendor/web-auth/cose-lib/src/Key/Key.php*	  fh*	  4      +   vendor/web-auth/cose-lib/src/Key/RsaKey.php
  fh
  ZΤ      1   vendor/web-auth/cose-lib/src/Key/SymmetricKey.php  fh  f      +   vendor/web-auth/cose-lib/src/Key/Ec2Key.php'  fh'  n      +   vendor/web-auth/cose-lib/src/Key/OkpKey.php
  fh
  ?      9   vendor/web-auth/cose-lib/src/Algorithm/ManagerFactory.php  fh  7]4      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256.php  fh  U0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECDSA.php  fh  Af      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES384.php  fh  "8      F   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECSignature.php  fh  3y      A   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256K.php  fh  8      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES512.php  fh  ˤ      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS1.php  fh  ]2      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RSA.php  fh  #2      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS384.php  fh  
f¤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS256.php  fh  掤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS384.php  fh  {      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS256.php  fh        >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS512.php  fh  *(z      ?   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PSSRSA.php\  fh\  i"      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS512.php  fh  kJ      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed512.php  fh  ƩK      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/EdDSA.php  fh         @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed256.php  fh  Xy      B   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed25519.php@  fh@  	      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/Signature.phpV  fhV  ;      4   vendor/web-auth/cose-lib/src/Algorithm/Algorithm.php   fh   =
h      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS512.php  fh  4X e      3   vendor/web-auth/cose-lib/src/Algorithm/Mac/Hmac.php  fh  Jd      2   vendor/web-auth/cose-lib/src/Algorithm/Mac/Mac.phpJ  fhJ  l'      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS384.php  fh  5YF      ?   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256Truncated64.php  fh  y      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256.php  fh        2   vendor/web-auth/cose-lib/src/Algorithm/Manager.php  fh  ,      +   vendor/web-auth/cose-lib/src/BigInteger.php  fh  Yy      +   vendor/web-auth/cose-lib/src/Algorithms.phpX  fhX  S@      '   vendor/composer/autoload_namespaces.php   fh   /t      &   vendor/composer/xdebug-handler/LICENSE)  fh)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  fh  !YsK      (   vendor/composer/xdebug-handler/README.md4  fh4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  fhy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  fh  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  fhz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  fhKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  fhH  G      +   vendor/composer/class-map-generator/LICENSE  fh  DӤ      -   vendor/composer/class-map-generator/README.mdN  fhN  K(      1   vendor/composer/class-map-generator/composer.json  fh  |(~      =   vendor/composer/class-map-generator/src/ClassMapGenerator.php{6  fh{6  Gf      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php  fh  @Ҥ      4   vendor/composer/class-map-generator/src/FileList.phpc  fhc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  fh  G)8      4   vendor/composer/class-map-generator/src/ClassMap.php
  fh
  Q         vendor/composer/LICENSE.  fh.            vendor/composer/ClassLoader.php?  fh?  2@u      +   vendor/composer/composer/phpstan/rules.neon  fh  ~d      1   vendor/composer/composer/res/composer-schema.json  fh  -Zy       6   vendor/composer/composer/res/composer-lock-schema.json
  fh
  rf      <   vendor/composer/composer/res/composer-repository-schema.json   fh   븂      &   vendor/composer/composer/composer.lockK fhK R          vendor/composer/composer/LICENSE,  fh,  Vg      %   vendor/composer/composer/bin/composer  fh  -0~      $   vendor/composer/composer/bin/compile  fh  \0      &   vendor/composer/composer/composer.json  fh  Sv'      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  fh
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.phpL"  fhL"  W      1   vendor/composer/composer/src/Composer/Factory.php  fh  z0      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php  fh  й      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  fh  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  fhl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  fh  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  fh  ,+      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php$   fh$   8l      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  fh  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  fh@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  fh
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  fh  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  fh  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  fhw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  fh	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.phpR  fhR  Bq      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php1 fh1 h)      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  fh`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  fhA  _O      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  fh  e      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  fh:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  fh  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpZ  fhZ  U s      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  fh  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php3  fh3  ʍE      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php6  fh6         G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  fh  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  fh8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php!  fh!  Zf      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.php4R  fh4R  \6L      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  fh
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php\  fh\  b:      C   vendor/composer/composer/src/Composer/Repository/PathRepository.phpK"  fhK"  -Ƥ      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  fhd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  fh  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  fh  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.phpI3  fhI3  ̤      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  fh  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php??  fh??  W      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  fh  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  fh  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  fh  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  fhN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  fh[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpqi  fhqi        2   vendor/composer/composer/src/Composer/Util/Svn.php&  fh&  sH      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  fh)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpW	  fhW	  ~w      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  fhA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  fh8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  fhR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php/  fh/  <      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpd{  fhd{  d}`      2   vendor/composer/composer/src/Composer/Util/Tar.php  fh  
Ǥ      5   vendor/composer/composer/src/Composer/Util/GitHub.php!  fh!  j\	v      5   vendor/composer/composer/src/Composer/Util/GitLab.php/  fh/  |!      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php9&  fh9&  	ǽ      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  fh)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  fhm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php*  fh*  hP      C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  fh"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  fh  5FϤ      2   vendor/composer/composer/src/Composer/Util/Url.php  fh  ʉ٤      7   vendor/composer/composer/src/Composer/Util/Perforce.php2L  fh2L  
Ǥ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php  fh  ewY      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  fha  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  fh  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpy  fhy  'B      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  fh  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  fh  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  fh  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.phpE  fhE  5U      1   vendor/composer/composer/src/Composer/Util/Hg.php  fh  Q5      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.php?l  fh?l  q'      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php,
  fh,
  JC      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  fh
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  fh2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  fhv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  fhf  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  fh  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  fh  -*      /   vendor/composer/composer/src/Composer/Cache.php+  fh+  @U      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  fh  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  fh  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.php4  fh4  Dפ      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  fhu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.php'
  fh'
  c      :   vendor/composer/composer/src/Composer/Platform/Runtime.php
	  fh
	  :K(      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  fh  H껥      :   vendor/composer/composer/src/Composer/Platform/Version.php
  fh
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  fh  '˄      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  fhK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.phpX#  fhX#        3   vendor/composer/composer/src/Composer/IO/NullIO.php	  fh	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   fhZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  fhe  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  fh2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  fh  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  fh  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  fh  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  fhy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  fh?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpP  fhP  .r      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  fh9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  fh
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  fh  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  fh  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php	  fh	  "Ĥ      R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  fhC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php4  fh4  \4=      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  fh  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  fhR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  fh  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  fh  WΤ      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  fh  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  fh  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpQ  fhQ  aYŤ      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  fh  p      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  fh"  rv      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phpCS  fhCS  R      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  fh'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  fh  ʤ      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  fh!  {Z      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  fh6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  fh  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php6  fh6  ,_      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  fh
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpa  fha  5Ȥ      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.phpL9  fhL9  0      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  fh  S      0   vendor/composer/composer/src/Composer/Config.phpCa  fhCa  ~s      6   vendor/composer/composer/src/Composer/Script/Event.php  fh  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  fh  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  fh  `a      2   vendor/composer/composer/src/Composer/Composer.php  fh  o]Ƥ      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  fhl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.phpe  fhe        7   vendor/composer/composer/src/Composer/Json/JsonFile.php3  fh3  N      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.php8S  fh8S  WT      ;   vendor/composer/composer/src/Composer/InstalledVersions.phpIB  fhIB   "      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  fhz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  fhx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  fh  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  fhw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  fh  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  fhb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  fh~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php8  fh8  |Ԥ      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.php  fh         Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  fh(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  fhA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  fh  >>MV      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  fh  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phph  fhh  s      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  fhN  d ۤ      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  fh
  dײ      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php  fh  18M      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  fh  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php(  fh(  
8      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  fh  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.phpX  fhX  q      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   fh   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.phpq  fhq  S8e      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.php!  fh!  1      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpM  fhM  	zA      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  fh6  w      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  fh  Q      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.php  fh  	dA"      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.php-  fh-  3C      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.phpC
  fhC
  r      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  fh  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.phpM  fhM  pN      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  fhg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  fh  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  fh;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  fh  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php&  fh&  r      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php*!  fh*!  sM      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php3  fh3  jl      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.phpm$  fhm$  撌r      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  fh  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  fhO  G:      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  fh
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php^  fh^  4Ѥ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpB  fhB  ?a      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.phpB  fhB  G      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.php  fh        =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpC  fhC  rj      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php#  fh#  "       ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  fh;        =   vendor/composer/composer/src/Composer/Command/ShowCommand.php% fh% 	EO      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  fh  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php([  fh([  (!#ͤ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  fh  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.phpȜ  fhȜ  J瑤      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  fh  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpeN  fheN  J(      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.php{   fh{   C      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.php3  fh3        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  fh  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  fh   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  fh  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phpi  fhi        @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  fhs  ^;      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php#  fh#  "i      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  fhX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpF  fhF  Þ      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  fh  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  fh  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  fh>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  fh  MI      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  fh         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  fh  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  fh  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  fh  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  fh  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  fh"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  fh8  b>      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  fhw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  fh  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  fh  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  fh  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  fh  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  fh&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  fh1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  fh  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  fh
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  fh  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php`  fh`  @!      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  fhY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  fh  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  fh  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php=  fh=  ̶Ҥ      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  fhk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  fh        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  fh  ;P      2   vendor/composer/composer/src/Composer/Compiler.php-  fh-  zq      9   vendor/composer/composer/src/Composer/Package/Package.phpD  fhD  i?f      6   vendor/composer/composer/src/Composer/Package/Link.php
  fh
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  fh  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  fh$        P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.phpq  fhq  ߶q      G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  fh  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  fh  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  fh  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  fh  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  fh  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  fh  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  fh  L      F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  fh  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  fhe'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.php/X  fh/X        B   vendor/composer/composer/src/Composer/Package/PackageInterface.php00  fh00  "'      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.phpS  fhS  p      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.php  fh  5      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpWH  fhWH  kS      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.php0  fh0  
      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  fh  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpu  fhu  _U      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  fho  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  fhF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  fhj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.phpO.  fhO.  pk      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  fhc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  fh  $8      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.php  fh  fɋ      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  fh  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  fh@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  fh  S      =   vendor/composer/composer/src/Composer/Package/RootPackage.phpZ  fhZ  k      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  fh  )=      =   vendor/composer/composer/src/Composer/Console/Application.php$  fh$  d      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  fhl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  fh
  &o      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  fh  (C      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  fh1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  fh7  t      (   vendor/composer/ca-bundle/res/cacert.pemOz fhOz %ߤ      !   vendor/composer/ca-bundle/LICENSE  fh  *!^`      #   vendor/composer/ca-bundle/README.md1  fh1  >VuĤ      '   vendor/composer/ca-bundle/composer.json5  fh5  y:      *   vendor/composer/ca-bundle/src/CaBundle.php+  fh+  d      !   vendor/composer/autoload_psr4.php  fh        %   vendor/composer/autoload_classmap.php fh ̢      "   vendor/composer/platform_check.php  fh        #   vendor/composer/autoload_static.phpH fhH -;      !   vendor/composer/autoload_real.php  fh  Ӥ         vendor/composer/semver/LICENSE  fh  Bh      #   vendor/composer/semver/CHANGELOG.mdi'  fhi'  [L          vendor/composer/semver/README.mdH
  fhH
   }Τ      $   vendor/composer/semver/composer.json  fh  z)      /   vendor/composer/semver/src/CompilingMatcher.php
  fh
  F      '   vendor/composer/semver/src/Interval.phpu  fhu         )   vendor/composer/semver/src/Comparator.php<
  fh<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  fhLP  K.      %   vendor/composer/semver/src/Semver.php
  fh
  4`ä      ,   vendor/composer/semver/src/VersionParser.phpSU  fhSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  fh  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  fh#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  fh2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  fh,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  fh(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  fh
        "   vendor/composer/autoload_files.phpD  fhD  VV2      %   vendor/composer/InstalledVersions.phpC  fhC  Ȱ         vendor/composer/installed.phpGa  fhGa  L}         vendor/composer/pcre/LICENSE  fh  hg^         vendor/composer/pcre/README.md!  fh!  B      #   vendor/composer/pcre/extension.neon  fh  &&1      "   vendor/composer/pcre/composer.json  fh  r7      E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.php  fh  UJl      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php`
  fh`
  |~      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  fh        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  fhV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php		  fh		  wD3B      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  fh
  tCs      (   vendor/composer/pcre/src/MatchResult.php  fh  ڇҤ      "   vendor/composer/pcre/src/Regex.php  fh  ɤ      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  fh        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  fh  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  fhw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  fh"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  fh        +   vendor/composer/pcre/src/MatchAllResult.php  fh  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  fh  /      !   vendor/composer/pcre/src/Preg.phpE  fhE  ]G      *   vendor/composer/pcre/src/PcreException.phpw  fhw  'v      )   vendor/composer/metadata-minifier/LICENSE  fh  hg^      +   vendor/composer/metadata-minifier/README.mdL  fhL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   fhB   #f      /   vendor/composer/metadata-minifier/composer.json  fh  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  fh
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  fh  L(      4   vendor/composer/spdx-licenses/res/spdx-licenses.json! fh!       %   vendor/composer/spdx-licenses/LICENSE  fh  Bh      '   vendor/composer/spdx-licenses/README.md<  fh<  se      +   vendor/composer/spdx-licenses/composer.json  fh  Ť      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  fh%  ]H
      .   vendor/phpdocumentor/reflection-common/LICENSE9  fh9  *2Ȑ      0   vendor/phpdocumentor/reflection-common/README.mdO  fhO  
һ      4   vendor/phpdocumentor/reflection-common/composer.json  fh  k6      6   vendor/phpdocumentor/reflection-common/src/Element.php  fh  7      =   vendor/phpdocumentor/reflection-common/src/ProjectFactory.phpf  fhf        3   vendor/phpdocumentor/reflection-common/src/File.php  fh  s      6   vendor/phpdocumentor/reflection-common/src/Project.php  fh  c=      4   vendor/phpdocumentor/reflection-common/src/Fqsen.php  fh  p      7   vendor/phpdocumentor/reflection-common/src/Location.php  fh  ;      *   vendor/phpdocumentor/type-resolver/LICENSE8  fh8  ʤ      2   vendor/phpdocumentor/type-resolver/phpdoc.dist.xml  fh  DA낤      ,   vendor/phpdocumentor/type-resolver/README.md#  fh#  ܵ\      0   vendor/phpdocumentor/type-resolver/composer.json  fh  \[      7   vendor/phpdocumentor/type-resolver/src/TypeResolver.phpc]  fhc]  v      ;   vendor/phpdocumentor/type-resolver/src/Types/Expression.phpF  fhF  PM      8   vendor/phpdocumentor/type-resolver/src/Types/Boolean.php|  fh|  M65      8   vendor/phpdocumentor/type-resolver/src/Types/Integer.phpx  fhx  jJ&      6   vendor/phpdocumentor/type-resolver/src/Types/Self_.php  fh  SY      6   vendor/phpdocumentor/type-resolver/src/Types/Void_.php  fh  Dk'٤      6   vendor/phpdocumentor/type-resolver/src/Types/Null_.php  fh  G      :   vendor/phpdocumentor/type-resolver/src/Types/Resource_.php  fh  JϤ      7   vendor/phpdocumentor/type-resolver/src/Types/Float_.phpu  fhu  Hդ      8   vendor/phpdocumentor/type-resolver/src/Types/Object_.php  fh  "]!      8   vendor/phpdocumentor/type-resolver/src/Types/String_.php  fh  V̤      9   vendor/phpdocumentor/type-resolver/src/Types/Nullable.php`  fh`  uy      :   vendor/phpdocumentor/type-resolver/src/Types/Callable_.php  fh  l      @   vendor/phpdocumentor/type-resolver/src/Types/InterfaceString.php  fh  >^      :   vendor/phpdocumentor/type-resolver/src/Types/Iterable_.phpF  fhF   'y      B   vendor/phpdocumentor/type-resolver/src/Types/CallableParameter.php  fh  /      9   vendor/phpdocumentor/type-resolver/src/Types/ArrayKey.php  fh  ?n)      7   vendor/phpdocumentor/type-resolver/src/Types/Never_.php  fh  	'      8   vendor/phpdocumentor/type-resolver/src/Types/Static_.php  fh  {6@      <   vendor/phpdocumentor/type-resolver/src/Types/ClassString.php_  fh_  g      8   vendor/phpdocumentor/type-resolver/src/Types/Parent_.php  fh  ip      7   vendor/phpdocumentor/type-resolver/src/Types/Scalar.php  fh  ؤ      8   vendor/phpdocumentor/type-resolver/src/Types/Context.php  fh  fYK      =   vendor/phpdocumentor/type-resolver/src/Types/AbstractList.php  fh  &      ;   vendor/phpdocumentor/type-resolver/src/Types/Collection.php  fh  䅝      =   vendor/phpdocumentor/type-resolver/src/Types/Intersection.php$  fh$        ?   vendor/phpdocumentor/type-resolver/src/Types/ContextFactory.php7  fh7  v#      ?   vendor/phpdocumentor/type-resolver/src/Types/AggregatedType.php
  fh
  C`      9   vendor/phpdocumentor/type-resolver/src/Types/Compound.php  fh        5   vendor/phpdocumentor/type-resolver/src/Types/This.phpg  fhg  ~+6      7   vendor/phpdocumentor/type-resolver/src/Types/Array_.php  fh   NK      7   vendor/phpdocumentor/type-resolver/src/Types/Mixed_.php  fh        /   vendor/phpdocumentor/type-resolver/src/Type.php  fh  q4      8   vendor/phpdocumentor/type-resolver/src/FqsenResolver.php	  fh	  ͢      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/StringValue.php  fh  FI      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/List_.php  fh  O      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyString.php}  fh}   i      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ShapeItem.php+  fh+  NG      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerRange.phpA  fhA  ֭Z$      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/CallableString.php|  fh|        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShapeItem.php   fh   곤      ?   vendor/phpdocumentor/type-resolver/src/PseudoTypes/Numeric_.php(  fh(  ^6      =   vendor/phpdocumentor/type-resolver/src/PseudoTypes/False_.php  fh  /      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShapeItem.php   fh   IC3      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/TraitString.phpv  fhv  {      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/FloatValue.php  fh  4AY      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NumericString.phpz  fhz  *      H   vendor/phpdocumentor/type-resolver/src/PseudoTypes/HtmlEscapedString.php  fh  y"Ѥ      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerValue.php  fh  R4      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LiteralString.phpz  fhz        C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyList.php  fh  I      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ConstExpression.php  fh  oe4      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShape.php  fh  frd      N   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyLowercaseString.php  fh        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyArray.php  fh  ,      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LowercaseString.php~  fh~  kc      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/True_.php  fh  W      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShape.php3  fh3  p      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NegativeInteger.phpw  fhw  p      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShapeItem.phpe  fhe  7      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShape.phpM  fhM  *9      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/PositiveInteger.phpw  fhw  .      5   vendor/phpdocumentor/type-resolver/src/PseudoType.php|  fh|  }      0   vendor/phpdocumentor/reflection-docblock/LICENSE8  fh8  ʤ      2   vendor/phpdocumentor/reflection-docblock/README.md  fh  }      6   vendor/phpdocumentor/reflection-docblock/composer.json  fh        @   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactory.php0  fh0  O?&      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Serializer.phpH  fhH  gդ      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/ExampleFinder.phpI  fhI  	T      =   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tag.php  fh  ῤ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/TagFactory.php
  fh
  ROJ      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/DescriptionFactory.php<  fh<  FJ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Since.php
  fh
  ,      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyWrite.php  fh  ֻ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/MethodParameter.php  fh  K銤      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Link.php  fh  j
      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/InvalidTag.phpx  fhx  Vj      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/BaseTag.php  fh  y{      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Var_.php  fh  x֤      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Param.php9  fh9  ֩      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Mixin.php  fh        P   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateCovariant.php  fh  ͤ      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Method.php'  fh'  ʤ      H   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter.php,  fh,  <c      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Uses.phpV
  fhV
  .Ѥ      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Return_.php  fh  }þ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/PassthroughFormatter.php  fh  ZL      W   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/AlignFormatter.php  fh  e&A      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateImplements.php  fh  r      K   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyRead.php  fh  )r      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Property.php  fh  q}      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Version.php
  fh
  .2      B   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/See.php5  fh5  
      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Extends_.php,  fh,  gE      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Generic.php	  fh	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TagWithType.php	  fh	  _UG      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Source.php  fh  cM      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Template.phpM	  fhM	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Implements_.php5  fh5  q      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Author.php	  fh	  8"      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Throws.php  fh        X   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ImplementsFactory.php  fh  5      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/Factory.phpJ  fhJ  \Τ      Z   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyReadFactory.php*  fh*  )܈      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ExtendsFactory.php  fh  if      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/StaticMethod.php%  fh%  cTg      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/AbstractPHPStanFactory.php  fh  )9      [   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyWriteFactory.php.  fh.  k      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/VarFactory.php  fh  $      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodFactory.phpC
  fhC
  [<      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateFactory.phpJ  fhJ  !rs      `   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateImplementsFactory.php  fh  {׮      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ParamFactory.php  fh  j      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodParameterFactory.phpN	  fhN	  ^E      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PHPStanFactory.php  fh  gɉ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateExtendsFactory.php  fh  %?      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyFactory.php  fh  dB      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ReturnFactory.php  fh  z      R   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Reference.php  fh  g      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Url.php  fh  ޛ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Fqsen.php*  fh*        N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateExtends.php  fh        F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Example.php  fh  c      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Deprecated.php  fh  v      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Covers.php
  fh
  
C      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/StandardTagFactory.php4  fh4  ~      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Description.php<  fh<  TT|      6   vendor/phpdocumentor/reflection-docblock/src/Utils.php	  fh	  Ԥ      I   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactoryInterface.php  fh  δ      9   vendor/phpdocumentor/reflection-docblock/src/DocBlock.php  fh  Zr      H   vendor/phpdocumentor/reflection-docblock/src/Exception/PcreException.php  fh  ~	g      1   vendor/paragonie/constant_time_encoding/README.md~
  fh~
  uLR      3   vendor/paragonie/constant_time_encoding/LICENSE.txte	  fhe	  |[      5   vendor/paragonie/constant_time_encoding/composer.json  fh  `Zo>      =   vendor/paragonie/constant_time_encoding/src/Base64UrlSafe.phpm  fhm  W}¤      9   vendor/paragonie/constant_time_encoding/src/Base32Hex.php9
  fh9
  fm      >   vendor/paragonie/constant_time_encoding/src/Base64DotSlash.php  fh  %o      8   vendor/paragonie/constant_time_encoding/src/Encoding.php,  fh,  R2~      @   vendor/paragonie/constant_time_encoding/src/EncoderInterface.php  fh  s:      6   vendor/paragonie/constant_time_encoding/src/Base32.php<  fh<  $HC      3   vendor/paragonie/constant_time_encoding/src/Hex.php  fh  bFǤ      E   vendor/paragonie/constant_time_encoding/src/Base64DotSlashOrdered.php
  fh
  ?Na      6   vendor/paragonie/constant_time_encoding/src/Binary.php
  fh
  ތ      7   vendor/paragonie/constant_time_encoding/src/RFC4648.php  fh        6   vendor/paragonie/constant_time_encoding/src/Base64.phpc$  fhc$  K      #   vendor/spomky-labs/cbor-php/LICENSE,  fh,  C      %   vendor/spomky-labs/cbor-php/README.md[+  fh[+        )   vendor/spomky-labs/cbor-php/composer.json[  fh[  n*      '   vendor/spomky-labs/cbor-php/SECURITY.md  fh  Ǥ      0   vendor/spomky-labs/cbor-php/src/StringStream.phpy  fhy  .      :   vendor/spomky-labs/cbor-php/src/OtherObject/TrueObject.php  fh  b1F      ;   vendor/spomky-labs/cbor-php/src/OtherObject/BreakObject.phpX  fhX  &c      D   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectInterface.phpt  fht  аȤ      J   vendor/spomky-labs/cbor-php/src/OtherObject/SinglePrecisionFloatObject.phpQ  fhQ  t      =   vendor/spomky-labs/cbor-php/src/OtherObject/GenericObject.php  fh  ku5      ;   vendor/spomky-labs/cbor-php/src/OtherObject/FalseObject.php  fh  =
      ?   vendor/spomky-labs/cbor-php/src/OtherObject/UndefinedObject.phpd  fhd  IM(      J   vendor/spomky-labs/cbor-php/src/OtherObject/DoublePrecisionFloatObject.php  fh  ]      K   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManagerInterface.php   fh   I      H   vendor/spomky-labs/cbor-php/src/OtherObject/HalfPrecisionFloatObject.phpq  fhq  WF       <   vendor/spomky-labs/cbor-php/src/OtherObject/SimpleObject.php	  fh	  :j      :   vendor/spomky-labs/cbor-php/src/OtherObject/NullObject.php  fh  .      B   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManager.php~  fh~  =*F      4   vendor/spomky-labs/cbor-php/src/DecoderInterface.php   fh   \f      4   vendor/spomky-labs/cbor-php/src/ByteStringObject.php  fh  Bl      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthTextStringObject.php*  fh*  `갤      '   vendor/spomky-labs/cbor-php/src/Tag.phpc  fhc  }      +   vendor/spomky-labs/cbor-php/src/Decoder.php#  fh#  Yu      9   vendor/spomky-labs/cbor-php/src/UnsignedIntegerObject.php  fh  򽩜      6   vendor/spomky-labs/cbor-php/src/AbstractCBORObject.phpY  fhY  @z>      0   vendor/spomky-labs/cbor-php/src/Normalizable.php   fh   xӤ      4   vendor/spomky-labs/cbor-php/src/LengthCalculator.php|  fh|  N`      /   vendor/spomky-labs/cbor-php/src/OtherObject.php  fh  ?73      *   vendor/spomky-labs/cbor-php/src/Stream.php   fh   $c      4   vendor/spomky-labs/cbor-php/src/TextStringObject.php  fh  1aM      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthByteStringObject.php3  fh3  Q      >   vendor/spomky-labs/cbor-php/src/IndefiniteLengthListObject.php  fh  cR¤      =   vendor/spomky-labs/cbor-php/src/IndefiniteLengthMapObject.php  fh  y8      +   vendor/spomky-labs/cbor-php/src/MapItem.php  fh         )   vendor/spomky-labs/cbor-php/src/Utils.phpv  fhv  p#      .   vendor/spomky-labs/cbor-php/src/ListObject.php  fh  0S      -   vendor/spomky-labs/cbor-php/src/MapObject.phpg  fhg  /k      .   vendor/spomky-labs/cbor-php/src/CBORObject.php~  fh~  4      .   vendor/spomky-labs/cbor-php/src/Tag/UriTag.php  fh  )      <   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlEncodingTag.php  fh  ܤ      =   vendor/spomky-labs/cbor-php/src/Tag/NegativeBigIntegerTag.php_  fh_  [ؠd      :   vendor/spomky-labs/cbor-php/src/Tag/DecimalFractionTag.php
  fh
        ;   vendor/spomky-labs/cbor-php/src/Tag/TagManagerInterface.php  fh  cG      4   vendor/spomky-labs/cbor-php/src/Tag/TagInterface.phph  fhh        4   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlTag.php  fh  }       3   vendor/spomky-labs/cbor-php/src/Tag/BigFloatTag.php
  fh
  M@Ǥ      /   vendor/spomky-labs/cbor-php/src/Tag/CBORTag.php}  fh}  %Ƥ      /   vendor/spomky-labs/cbor-php/src/Tag/MimeTag.php  fh  <,      3   vendor/spomky-labs/cbor-php/src/Tag/DatetimeTag.php  fh  bʤ      7   vendor/spomky-labs/cbor-php/src/Tag/CBOREncodingTag.php  fh   lM      1   vendor/spomky-labs/cbor-php/src/Tag/Base64Tag.php  fh  |㨤      9   vendor/spomky-labs/cbor-php/src/Tag/Base16EncodingTag.php  fh  M9      =   vendor/spomky-labs/cbor-php/src/Tag/UnsignedBigIntegerTag.php  fh  |}      2   vendor/spomky-labs/cbor-php/src/Tag/TagManager.phpE  fhE  a      4   vendor/spomky-labs/cbor-php/src/Tag/TimestampTag.php  fh  qJ      2   vendor/spomky-labs/cbor-php/src/Tag/GenericTag.php  fh  22      9   vendor/spomky-labs/cbor-php/src/Tag/Base64EncodingTag.php  fh   k      9   vendor/spomky-labs/cbor-php/src/NegativeIntegerObject.php  fh  bx7      (   vendor/spomky-labs/pki-framework/LICENSES  fhS  t      *   vendor/spomky-labs/pki-framework/README.md  fh  7/V      .   vendor/spomky-labs/pki-framework/composer.json
  fh
  ;      ,   vendor/spomky-labs/pki-framework/SECURITY.mdI  fhI  ,)      5   vendor/spomky-labs/pki-framework/src/ASN1/Element.php<  fh<  9t      9   vendor/spomky-labs/pki-framework/src/ASN1/Util/BigInt.php  fh  `}      8   vendor/spomky-labs/pki-framework/src/ASN1/Util/Flags.php  fh  
      B   vendor/spomky-labs/pki-framework/src/ASN1/Component/Identifier.php  fh  J=      >   vendor/spomky-labs/pki-framework/src/ASN1/Component/Length.php  fh  ri
      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveType.php,  fh,  SZe2      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseString.php  fh  M"~      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BMPString.php_  fh_  .      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Boolean.php9  fh9  p@      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Integer.phpa  fha  @n      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/RelativeOID.php  fh  lb      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VisibleString.php  fh  wn      C   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Number.php  fh  zڡ      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTF8String.php  fh  b      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BitString.php  fh  +      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/IA5String.php  fh  c&k      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UniversalString.php  fh  l0ޤ      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GraphicString.php  fh  W      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectDescriptor.php  fh  Y1      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Real.phpQ  fhQ  ~^      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/PrintableString.php  fh  iTȘ      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/EOC.php  fh  !¤      E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NullType.php  fh  o      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectIdentifier.php  fh  z&      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Enumerated.php:  fh:  N      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NumericString.php  fh  y{      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/OctetString.php2  fh2  y      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralizedTime.php7  fh7  l
      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTCTime.php:	  fh:	  3W-N      K   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VideotexString.php  fh  =đ      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/CharacterString.php>  fh>         F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/T61String.php  fh  _      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralString.php  fh  wӺ      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/TimeType.php;  fh;  -R
      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitTagging.php  fh  Wq      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ContextSpecificType.php   fh   X      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitlyTaggedType.php&  fh&        E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/PrivateType.php   fh   4eY      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ApplicationType.php   fh   CF      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitlyTaggedType.php@  fh@        G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/DERTaggedType.php  fh  }LV      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/TaggedTypeWrap.php'  fh'  :      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitTagging.php  fh  \      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Sequence.php[  fh[  x       B   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Set.php$  fh$  ~      P   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/ConstructedString.php  fh  2L:      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveString.php  fh  @$      <   vendor/spomky-labs/pki-framework/src/ASN1/Type/Structure.phpM  fhM  f<      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseTime.php  fh  CLb      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/UnspecifiedType.php/?  fh/?  ?qФ      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/TaggedType.php	  fh	  m      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/StringType.php  fh  &      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/UniversalClass.php  fh  o      5   vendor/spomky-labs/pki-framework/src/ASN1/DERData.php  fh  ($Ĥ      A   vendor/spomky-labs/pki-framework/src/ASN1/Feature/ElementBase.php  fh  }<t      @   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Stringable.phps  fhs  FM      ?   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Encodable.php   fh   ܴ;      G   vendor/spomky-labs/pki-framework/src/ASN1/Exception/DecodeException.php   fh   }Ӥ      ;   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEM.php  fh  |f"ˤ      A   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEMBundle.php  fh  La      J   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto/OpenSSLCrypto.php  fh        <   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto.php  fh  @      >   vendor/spomky-labs/pki-framework/src/X509/Certificate/Time.php3  fh3  Ħ      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CRLDistributionPointsExtension.php
  fh
  X      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectDirectoryAttributesExtension.php&  fh&  K+Y      n   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/SubjectAccessDescription.phpw  fhw  e\      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AccessDescription.php  fh        p   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AuthorityAccessDescription.phpJ  fhJ  (~s      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NoRevocationAvailableExtension.php  fh        ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyConstraintsExtension.php  fh  v!      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityInformationAccessExtension.php
  fh
        e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectInformationAccessExtension.php'
  fh'
   .î      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/TargetInformationExtension.phpN
  fhN
  tc(      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/KeyUsageExtension.php  fh  W).      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetName.php  fh  HA      R   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Targets.php
  fh
  `%      Q   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Target.phps  fhs  G]b      V   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetGroup.php  fh  1*      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappings/PolicyMapping.phph  fhh  Ť      \   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraintsExtension.phpp  fhp  i      X   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/FreshestCRLExtension.phpU  fhU  E      T   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/UnknownExtension.php  fh  m      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/IssuerAlternativeNameExtension.php  fh  7@A^      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePoliciesExtension.phpx
  fhx
        ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/InhibitAnyPolicyExtension.phpf  fhf  UP      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/RelativeName.phpe  fhe  iwX      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPoint.php  fh  pӿ      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/FullName.php  fh  4      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/ReasonFlags.php  fh  dŤ      k   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPointName.php  fh  TQ      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtrees.php  fh  hL\      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtree.php
  fh
  Du      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/ExtendedKeyUsageExtension.php  fh  WL      W   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AAControlsExtension.php  fh  er      e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/NoticeReference.phpa  fha  
      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyQualifierInfo.php  fh  Dr      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/UserNoticeQualifier.php	  fh	  4s      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyInformation.phpt  fht  ҫ       a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/DisplayText.php6  fh6  Ť      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/CPSQualifier.phpK  fhK  $vu      [   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappingsExtension.php  fh  p'i      M   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Extension.php'  fh'  b      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityKeyIdentifierExtension.php  fh  pT      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectAlternativeNameExtension.php  fh  6+      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/BasicConstraintsExtension.php	  fh	  ?z      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectKeyIdentifierExtension.php  fh  )VS      E   vendor/spomky-labs/pki-framework/src/X509/Certificate/Certificate.php  fh  7;      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/UniqueIdentifier.php  fh  q      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateChain.php  fh  N8      B   vendor/spomky-labs/pki-framework/src/X509/Certificate/Validity.phpx  fhx  $Ҥ      K   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateBundle.phpC  fhC        H   vendor/spomky-labs/pki-framework/src/X509/Certificate/TBSCertificate.php8  fh8  b^      D   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extensions.php$  fh$  [      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RegisteredID.php  fh  Z3      G   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DirectoryName.php]  fh]  ^      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/EDIPartyName.php  fh  Noߤ      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/OtherName.php  fh  V$d      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPAddress.php  fh  ?U      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/X400Address.php  fh  T      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv4Address.php!  fh!  #      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralNames.php  fh  \֤      S   vendor/spomky-labs/pki-framework/src/X509/GeneralName/UniformResourceIdentifier.php  fh  e      D   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RFC822Name.php  fh  Mpn      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralName.phpD
  fhD
        E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv6Address.php  fh   Ip      A   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DNSName.php(  fh(  Yj      D   vendor/spomky-labs/pki-framework/src/X509/Feature/DateTimeHelper.php  fh  $u      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationConfig.php  fh  U\      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationResult.php\  fh\  c[      ]   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/ValidatorState.php)  fh)  0p      \   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidator.phpB  fhB  ~i      e   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathBuilding/CertificationPathBuilder.php  fh  h      _   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathBuildingException.php  fh  v      a   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathValidationException.phpC  fhC  Wb'      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyNode.phpT  fhT  Rn      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyTree.php+5  fh+5  1ؤ      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/CertificationPath.php  fh  s      O   vendor/spomky-labs/pki-framework/src/X509/Exception/X509ValidationException.php   fh   ?$      i   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AccessIdentityAttributeValue.php5  fh5  3c      Z   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrValue.php  fh  f#       Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/SvceAuthInfo.php	  fh	  Gh      m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AuthenticationInfoAttributeValue.phpN  fhN  ˯Ť      k   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/ChargingIdentityAttributeValue.php  fh  d      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/GroupAttributeValue.php  fh  vR      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrSyntax.php  fh        _   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/RoleAttributeValue.php  fh  q1      M   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attributes.php   fh   pr      O   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/IssuerSerial.php  fh  hU      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Holder.php  fh  pS      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/V2Form.php  fh  ~      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificateInfo.phpK&  fhK&  lz      S   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/ObjectDigestInfo.php	  fh	  >      P   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertIssuer.phpB  fhB  y0      W   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificate.php  fh        X   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertValidityPeriod.php$  fh$  t      Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidator.php  fh        m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/Exception/ACValidationException.php
  fh
  K      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidationConfig.php  fh  6      W   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequest.php  fh  `      b   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attribute/ExtensionRequestValue.phpD  fhD  
      M   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attributes.php  fh        [   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequestInfo.php  fh  X      6   vendor/spomky-labs/pki-framework/src/X501/ASN1/RDN.php  fh  u晤      @   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeType.php@  fh@  7P      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SequenceOfAttributes.php  fh  xDc      M   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SetOfAttributes.php2  fh2  %      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/AttributeCollection.php"  fh"  ,L      <   vendor/spomky-labs/pki-framework/src/X501/ASN1/Attribute.php#  fh#  9      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/LocalityNameValue.php  fh  `      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/GivenNameValue.php  fh  g      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationNameValue.php  fh  09      L   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/TitleValue.php  fh  f2      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SerialNumberValue.php  fh  G      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/AttributeValue.php  fh  Sg&      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/DescriptionValue.php  fh  GϤ      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CountryNameValue.php  fh  k      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CommonNameValue.php  fh  40L      N   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SurnameValue.php  fh  l      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/PseudonymValue.php  fh        Z   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/StateOrProvinceNameValue.php  fh  ˤ      ^   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/PrintableStringValue.php  fh  Rp      Y   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/DirectoryString.php  fh  W      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/UnknownAttributeValue.php<	  fh<	  %U      ]   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationalUnitNameValue.php  fh  6ۺ      K   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/NameValue.php  fh        H   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeTypeAndValue.phpe  fhe  z\      7   vendor/spomky-labs/pki-framework/src/X501/ASN1/Name.phpP  fhP  :      9   vendor/spomky-labs/pki-framework/src/X501/DN/DNParser.phpd(  fhd(        G   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/MatchingRule.phpP  fhP  ~j2      J   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseIgnoreMatch.php  fh   Eʤ      I   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseExactMatch.php  fh  }      Q   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/StringPrepMatchingRule.php{  fh{  峿      F   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/BinaryMatch.php  fh  	r      @   vendor/spomky-labs/pki-framework/src/X501/StringPrep/MapStep.phpn  fhn  T      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/NormalizeStep.php
  fh
  q      D   vendor/spomky-labs/pki-framework/src/X501/StringPrep/PrepareStep.php  fh  o*      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/TranscodeStep.phpA	  fhA	  B      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/CheckBidiStep.php  fh  tId      G   vendor/spomky-labs/pki-framework/src/X501/StringPrep/StringPreparer.php  fh  o<I      E   vendor/spomky-labs/pki-framework/src/X501/StringPrep/ProhibitStep.php  fh        [   vendor/spomky-labs/pki-framework/src/X501/StringPrep/InsignificantNonSubstringSpaceStep.php!  fh!  Q6|      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed25519Signature.php  fh        M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed448Signature.php  fh  Pb      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/GenericSignature.phpB  fhB   ~      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/ECSignature.php  fh        K   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/RSASignature.phpY  fhY  ފ-      H   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Signature.php  fh  U(      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/OneAsymmetricKey.php)  fh)  NM@      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/Attribute/OneAsymmetricKeyAttributes.php  fh  H      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPublicKey.php
  fh
  3:      Q   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPrivateKey.phpO  fhO  U      W   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSASSAPSSPrivateKey.phpj  fhj  f*      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPublicKey.phpm  fhm  Ҥ      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPrivateKey.php*  fh*  QOM2      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECConversion.php  fh  Ғ      I   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKey.php3  fh3  Zh      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKeyInfo.php  fh  Ln+      Y   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PrivateKey.phpj
  fhj
  "      X   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PublicKey.php  fh  ;.      ^   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PublicKey.php  fh  O      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PublicKey.php  fh  +/      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PrivateKey.php  fh  Q      `   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PrivateKey.php  fh  	      b   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PublicKey.php  fh  .)      f   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PublicKey.php  fh  4I      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PrivateKey.php  fh  vV      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PrivateKey.php3  fh3  D3      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PublicKey.php  fh  ʙ      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PrivateKey.php  fh  .:      M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKeyInfo.php  fh  3D      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKey.php0  fh0  Ix      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/SpecificAlgorithmIdentifier.phpW  fhW  y      \   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifier.phpp  fhp  %H      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA384WithRSAEncryptionAlgorithmIdentifier.php  fh  O+      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD2WithRSAEncryptionAlgorithmIdentifier.php  fh  Qߕޤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA256AlgorithmIdentifier.php  fh  -      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA224AlgorithmIdentifier.php  fh  
      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD5WithRSAEncryptionAlgorithmIdentifier.php  fh  +      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC3279RSASignatureAlgorithmIdentifier.php  fh  )af      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD4WithRSAEncryptionAlgorithmIdentifier.php  fh  wl      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC4055RSASignatureAlgorithmIdentifier.phpl  fhl  _esԤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA512AlgorithmIdentifier.php  fh  6f{      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RSASignatureAlgorithmIdentifier.php  fh  |Ǥ      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA256WithRSAEncryptionAlgorithmIdentifier.php  fh  `%      s   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA1AlgorithmIdentifier.php  fh  bd      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA384AlgorithmIdentifier.php  fh  ,P      q   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECSignatureAlgorithmIdentifier.php  fh  _<      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA512WithRSAEncryptionAlgorithmIdentifier.php  fh        {   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA1WithRSAEncryptionAlgorithmIdentifier.php  fh  1      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA224WithRSAEncryptionAlgorithmIdentifier.php  fh  &n      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA224AlgorithmIdentifier.php  fh  Ф      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA224AlgorithmIdentifier.php  fh  1]̤      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA256AlgorithmIdentifier.php  fh  L      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA256AlgorithmIdentifier.php  fh  F      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/RFC4231HMACAlgorithmIdentifier.phps  fhs  TE      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA512AlgorithmIdentifier.php  fh  N      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA512AlgorithmIdentifier.php  fh  Iˤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA1AlgorithmIdentifier.php  fh  l	d      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA2AlgorithmIdentifier.php  fh  	      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/MD5AlgorithmIdentifier.php  fh  :      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA1AlgorithmIdentifier.phpy  fhy        o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA384AlgorithmIdentifier.php  fh  /4      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA384AlgorithmIdentifier.php  fh  MaA4      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/RC2CBCAlgorithmIdentifier.php  fh        m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESEDE3CBCAlgorithmIdentifier.phpg  fhg  p      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES192CBCAlgorithmIdentifier.php  fh        i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AESCBCAlgorithmIdentifier.php  fh  qz      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/CipherAlgorithmIdentifier.php8  fh8   "¤      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESCBCAlgorithmIdentifier.php  fh  HY      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/BlockCipherAlgorithmIdentifier.phpd  fhd  ~      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES128CBCAlgorithmIdentifier.php|  fh|  Wϸ      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES256CBCAlgorithmIdentifier.php  fh  |Ĥ      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/ECPublicKeyAlgorithmIdentifier.php/  fh/  D      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X25519AlgorithmIdentifier.php+  fh+  0Ŕ      k   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X448AlgorithmIdentifier.php#  fh#  oœ#      p   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410EdAlgorithmIdentifier.php  fh   ߎ      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAEncryptionAlgorithmIdentifier.php  fh  seR      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed448AlgorithmIdentifier.php  fh  ְ      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410XAlgorithmIdentifier.php  fh  L~.      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAPSSSSAEncryptionAlgorithmIdentifier.php  fh  Z      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed25519AlgorithmIdentifier.php  fh         c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierFactory.php$  fh$  #ꨤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/SignatureAlgorithmIdentifier.php  fh  3!      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/PRFAlgorithmIdentifier.php   fh   !$      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AsymmetricCryptoAlgorithmIdentifier.php
  fh
  C      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/HashAlgorithmIdentifier.php   fh   &-      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/EncryptionAlgorithmIdentifier.php   fh   bO      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AlgorithmIdentifierType.phpy  fhy  l̤      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierProvider.php  fh  k\d      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/GenericAlgorithmIdentifier.php  fh  CI	          vendor/spomky-labs/otphp/LICENSE@  fh@  xi      "   vendor/spomky-labs/otphp/README.md%  fh%  z@      &   vendor/spomky-labs/otphp/composer.json  fh  ;       $   vendor/spomky-labs/otphp/SECURITY.md  fh  ?	m      %   vendor/spomky-labs/otphp/src/TOTP.php  fh  >s?      (   vendor/spomky-labs/otphp/src/Factory.php+  fh+  0$      -   vendor/spomky-labs/otphp/src/OTPInterface.php
  fh
  zr      .   vendor/spomky-labs/otphp/src/TOTPInterface.php  fh  *      $   vendor/spomky-labs/otphp/src/OTP.php  fh  B      %   vendor/spomky-labs/otphp/src/HOTP.php=
  fh=
  hct      .   vendor/spomky-labs/otphp/src/HOTPInterface.php=  fh=  ߤ      1   vendor/spomky-labs/otphp/src/FactoryInterface.phpr  fhr  ¤      /   vendor/spomky-labs/otphp/src/ParameterTrait.php  fh  da&      $   vendor/spomky-labs/otphp/src/Url.php#
  fh#
  >쐡      .   vendor/spomky-labs/otphp/src/InternalClock.php5  fh5  GƤ      $   vendor/doctrine/deprecations/LICENSE)  fh)  "0      &   vendor/doctrine/deprecations/README.md
  fh
  {      *   vendor/doctrine/deprecations/composer.json
  fh
        ?   vendor/doctrine/deprecations/src/PHPUnit/VerifyDeprecations.php  fh  jϤ      0   vendor/doctrine/deprecations/src/Deprecation.php$  fh$  )         vendor/firebase/php-jwt/LICENSE  fh  #      $   vendor/firebase/php-jwt/CHANGELOG.md(  fh(  D      !   vendor/firebase/php-jwt/README.md4  fh4  !Uk      %   vendor/firebase/php-jwt/composer.json  fh  ܤ      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   fhu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpt  fht  u0      ,   vendor/firebase/php-jwt/src/CachedKeySet.php  fh   ؤ      #   vendor/firebase/php-jwt/src/Key.php  fh  lx+      #   vendor/firebase/php-jwt/src/JWK.phpA,  fhA,        @   vendor/firebase/php-jwt/src/JWTExceptionWithPayloadInterface.php  fh  ky      0   vendor/firebase/php-jwt/src/ExpiredException.phpp  fhp  7      #   vendor/firebase/php-jwt/src/JWT.php\  fh\  2ב         vendor/brick/math/LICENSEA  fhA  ݸL         vendor/brick/math/CHANGELOG.md`O  fh`O        $   vendor/brick/math/psalm-baseline.xml	  fh	           vendor/brick/math/composer.jsonR  fhR  IG      &   vendor/brick/math/src/RoundingMode.php
  fh
        ;   vendor/brick/math/src/Internal/Calculator/GmpCalculator.php'
  fh'
  ;0      >   vendor/brick/math/src/Internal/Calculator/BcMathCalculator.php  fh  ,1      >   vendor/brick/math/src/Internal/Calculator/NativeCalculator.php7  fh7  #.      -   vendor/brick/math/src/Internal/Calculator.phpI  fhI  }      $   vendor/brick/math/src/BigInteger.php  fh  oa      #   vendor/brick/math/src/BigNumber.php>  fh>  Eä      $   vendor/brick/math/src/BigDecimal.phpW  fhW  87      1   vendor/brick/math/src/Exception/MathException.php   fh   }&      9   vendor/brick/math/src/Exception/NumberFormatException.php  fh  ojQ      ;   vendor/brick/math/src/Exception/NegativeNumberException.php  fh  +;      ;   vendor/brick/math/src/Exception/DivisionByZeroException.php  fh  Ɓj      <   vendor/brick/math/src/Exception/IntegerOverflowException.php,  fh,  1C>*      >   vendor/brick/math/src/Exception/RoundingNecessaryException.php  fh  A      %   vendor/brick/math/src/BigRational.php.  fh.  2h      (   vendor/justinrainbow/json-schema/LICENSE   fh         2   vendor/justinrainbow/json-schema/bin/validate-json  fh        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  fh  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  fh  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  fhz  ˱      .   vendor/justinrainbow/json-schema/composer.json  fh  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  fh  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  fh
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  fh  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  fh{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  fh  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  fh
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  fh  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   fh   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  fh  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  fh  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  fh3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  fh  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  fh  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  fh.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  fh  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  fh:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  fh  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  fh<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  fh!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  fh4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   fh   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  fh
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  fh  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  fh  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  fh  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  fh  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  fh^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  fh
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  fh$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  fh  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  fhb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   fhX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  fho  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  fhj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  fh  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  fh  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  fh'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  fh_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  fh  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  fh\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  fhX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  fhe  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  fh.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile   fh   D1      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   fhl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   fh   lc¤      !   vendor/crell/api-problem/Makefile]  fh]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   fh0   b      +   vendor/crell/api-problem/docker-compose.ymlb  fhb  Ruv      &   vendor/crell/api-problem/composer.json  fh  VN+      $   vendor/crell/api-problem/SECURITY.mdw	  fhw	  _yU      %   vendor/crell/api-problem/default-.env  fh  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   fh   ewF      .   vendor/crell/api-problem/src/HttpConverter.php6
  fh6
  1B      3   vendor/crell/api-problem/src/JsonParseException.phpH  fhH  %P(      .   vendor/crell/api-problem/src/JsonException.php  fh  5-      +   vendor/crell/api-problem/src/ApiProblem.phpdH  fhdH  'M         vendor/psr/cache/CHANGELOG.md  fh  -	G         vendor/psr/cache/README.md"  fh"  (AcӤ         vendor/psr/cache/LICENSE.txt8  fh8  Df         vendor/psr/cache/composer.json4  fh4  C      /   vendor/psr/cache/src/CacheItemPoolInterface.php  fh  Y      +   vendor/psr/cache/src/CacheItemInterface.php&  fh&  =b      1   vendor/psr/cache/src/InvalidArgumentException.php:  fh:  MY      '   vendor/psr/cache/src/CacheException.php   fh   BJ      #   vendor/psr/event-dispatcher/LICENSE(  fh(  }]      %   vendor/psr/event-dispatcher/README.mdE  fhE  S      )   vendor/psr/event-dispatcher/composer.jsonb  fhb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  fh  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  fh        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  fh!  T>q         vendor/psr/http-message/LICENSE=  fh=        $   vendor/psr/http-message/CHANGELOG.md3  fh3  :\Y      !   vendor/psr/http-message/README.md  fh        %   vendor/psr/http-message/composer.json  fh  7      6   vendor/psr/http-message/src/ServerRequestInterface.phpH(  fhH(  #      ,   vendor/psr/http-message/src/UriInterface.php/2  fh/2  קY      /   vendor/psr/http-message/src/StreamInterface.php  fh        5   vendor/psr/http-message/src/UploadedFileInterface.php  fh  	      0   vendor/psr/http-message/src/RequestInterface.phpG  fhG  ir      1   vendor/psr/http-message/src/ResponseInterface.phpZ
  fhZ
  aG      0   vendor/psr/http-message/src/MessageInterface.php  fh  |C         vendor/psr/container/LICENSEy  fhy  Op         vendor/psr/container/README.mdB  fhB  g?      "   vendor/psr/container/composer.json  fh  nY      7   vendor/psr/container/src/NotFoundExceptionInterface.php   fh   B@      /   vendor/psr/container/src/ContainerInterface.php%  fh%  )      8   vendor/psr/container/src/ContainerExceptionInterface.php   fh              vendor/psr/http-client/LICENSE=  fh=  S      #   vendor/psr/http-client/CHANGELOG.md  fh  z򪌤          vendor/psr/http-client/README.md%  fh%  F      $   vendor/psr/http-client/composer.json  fh  bϤ      8   vendor/psr/http-client/src/NetworkExceptionInterface.php  fh  6SB      8   vendor/psr/http-client/src/RequestExceptionInterface.phph  fhh  *c=      .   vendor/psr/http-client/src/ClientInterface.php!  fh!  {0      7   vendor/psr/http-client/src/ClientExceptionInterface.php   fh   xz         vendor/psr/log/LICENSE=  fh=  pO         vendor/psr/log/README.mdB  fhB  '         vendor/psr/log/composer.json`  fh`  ],      +   vendor/psr/log/src/LoggerAwareInterface.php   fh   ow         vendor/psr/log/src/LogLevel.phpH  fhH  u      '   vendor/psr/log/src/LoggerAwareTrait.phpj  fhj  dz      /   vendor/psr/log/src/InvalidArgumentException.phpo   fho   MWd      !   vendor/psr/log/src/NullLogger.php  fh   <      &   vendor/psr/log/src/LoggerInterface.php
  fh
  c=      "   vendor/psr/log/src/LoggerTrait.php
  fh
  
      %   vendor/psr/log/src/AbstractLogger.php  fh  q         vendor/psr/clock/LICENSE8  fh8  l         vendor/psr/clock/CHANGELOG.md   fh   <         vendor/psr/clock/README.md  fh  GL[         vendor/psr/clock/composer.json2  fh2  $DCM      '   vendor/psr/clock/src/ClockInterface.php   fh   H%         vendor/psr/http-factory/LICENSE(  fh(  }]      !   vendor/psr/http-factory/README.md,  fh,  zwf      %   vendor/psr/http-factory/composer.json8  fh8        8   vendor/psr/http-factory/src/ResponseFactoryInterface.php2  fh2  ձ}      6   vendor/psr/http-factory/src/StreamFactoryInterface.php  fh  e      <   vendor/psr/http-factory/src/UploadedFileFactoryInterface.phpJ  fhJ  nʉ      3   vendor/psr/http-factory/src/UriFactoryInterface.phpU  fhU        =   vendor/psr/http-factory/src/ServerRequestFactoryInterface.php  fh  w9      7   vendor/psr/http-factory/src/RequestFactoryInterface.php  fh  4(         vendor/monolog/monolog/LICENSE'  fh'        #   vendor/monolog/monolog/CHANGELOG.md  fh  nr          vendor/monolog/monolog/README.mdA  fhA  o      $   vendor/monolog/monolog/composer.json3
  fh3
        >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.php  fh  
FϤ      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  fh  &      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  fh  )Bs      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.php  fh  ps      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  fh  cJ      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.phpY/  fhY/  q]      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpJ  fhJ  H      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  fh  :      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.phpy  fhy  ,Z̤      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  fh  ~      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php
  fh
  kVʤ      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.phpz   fhz   U6X      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.php  fh  8      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpO
  fhO
        Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  fh  z.      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php  fh         \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  fh	  ;Ӥ      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  fh  Y      C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  fh         >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.phpz  fhz  E^      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  fh  |      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  fh
  7m      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.phpG
  fhG
  
B      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.phpJ  fhJ  1      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  fh  'W      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  fh   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php  fh  
$      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.php4  fh4        D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  fh$   Aߤ      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php  fh        9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  fh  -
M      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php>  fh>  ^n      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  fh  <      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  fh  .t      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php	  fh	  nD      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpU  fhU  ٤      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php  fh  N'x~      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  fh  ca      A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php  fh        @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.phpQ0  fhQ0  v֤      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.php
  fh
  *rʤ      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  fh  D      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php	  fh	  go      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.phpY  fhY  h      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  fh        8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.php  fh  A      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  fh  O!֤      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php  fh  %Tg      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php  fh        A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.php  fh  ޤ      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.php  fh  Nv      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php5   fh5   EW      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.phpa  fha  Ӥ      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  fh  Kdﮤ      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php  fh        F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  fh  f      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php/  fh/  m      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  fh'        9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  fh	  |cU      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.php)  fh)  ̤      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  fh  PK      ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php
  fh
  2      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.php  fh  '      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.phpI
  fhI
   T      :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php|  fh|  Wb      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php%  fh%  paĤ      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php$  fh$  39      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php
  fh
  \+w      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  fh  cl      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php	  fh	  (ٌ      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php
  fh
        :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.phpF  fhF  !fB      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  fh  bH      H   vendor/monolog/monolog/src/Monolog/JsonSerializableDateTimeImmutable.php  fh  kܤ      -   vendor/monolog/monolog/src/Monolog/Logger.php;Y  fh;Y  {      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  fh  b      C   vendor/monolog/monolog/src/Monolog/Attribute/WithMonologChannel.php  fh  GL      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phph  fhh  x\G      ;   vendor/monolog/monolog/src/Monolog/Test/MonologTestCase.php@  fh@  (-      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  fh  >7)      /   vendor/monolog/monolog/src/Monolog/Registry.php  fh  =      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  fh  	'1      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.phpI  fhI        =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.phpU
  fhU
  8      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.php|  fh|  _`x      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.php  fh  +@      E   vendor/monolog/monolog/src/Monolog/Processor/LoadAverageProcessor.php\  fh\  s      H   vendor/monolog/monolog/src/Monolog/Processor/ClosureContextProcessor.php  fh  :Eg      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.php  fh  O      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.php  fh  G?o      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  fh  \@      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php  fh  )      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php\  fh\  h      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php  fh  Hz      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php]  fh]  l(      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.phpi  fhi  3;w      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  fh  Z̤      4   vendor/monolog/monolog/src/Monolog/SignalHandler.phpZ  fhZ  N      ,   vendor/monolog/monolog/src/Monolog/Level.php\  fh\  $رn      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php;  fh;  
ؤ      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php  fh  q*      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.phph&  fhh&  ؃      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.phpm  fhm  l S      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.phpC	  fhC	  mӼ      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  fh  ̍Q      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.phpQ
  fhQ
  n@      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php  fh  א      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpF  fhF  pz      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  fh  Pa      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php  fh  դ      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  fh        A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  fh  (QG      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.phpY  fhY  9Pi      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php  fh  :      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  fh        @   vendor/monolog/monolog/src/Monolog/Formatter/SyslogFormatter.php  fh  氂      D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php'  fh'  6xq      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  fh  x       0   vendor/monolog/monolog/src/Monolog/LogRecord.php
  fh
  
      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php'  fh'  4_      ,   vendor/monolog/monolog/src/Monolog/Utils.phpr"  fhr"  c      !   vendor/studio24/rotate/LICENSE.md>  fh>  3ä      "   vendor/studio24/rotate/phpunit.xml   fh   gE          vendor/studio24/rotate/README.md  fh  ?/      $   vendor/studio24/rotate/composer.json  fh  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   fh_    ;      %   vendor/studio24/rotate/src/Rotate.php#  fh#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  fh  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  fh  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   fhg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  fh|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  fhk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php  fh  xϤ      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.phpD  fhD  }      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  fhU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  fh,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.php
  fh
  C>      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  fh  eNʤ      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.phpe  fhe  }w      D   vendor/symfony/framework-bundle/Test/NotificationAssertionsTrait.php%  fh%  *      B   vendor/symfony/framework-bundle/Test/HttpClientAssertionsTrait.php  fh  ~s      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php!  fh!  탤      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.php  fh  ¾      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  fh  5      ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  fh  *      6   vendor/symfony/framework-bundle/Test/TestContainer.phpP  fhP  Ԕq      ,   vendor/symfony/framework-bundle/CHANGELOG.md  fh  ķ      :   vendor/symfony/framework-bundle/Translation/Translator.phpR  fhR  
H      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.phpK#  fhK#  ?/      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.php8  fh8  U:      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  fh  ~p      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  fh  1      A   vendor/symfony/framework-bundle/Resources/config/asset_mapper.php$  fh$  O)      8   vendor/symfony/framework-bundle/Resources/config/esi.php  fh        @   vendor/symfony/framework-bundle/Resources/config/translation.phpM   fhM   Tפ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.phpy'  fhy'  PF      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  fh  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php  fh  iL6Ǥ      >   vendor/symfony/framework-bundle/Resources/config/semaphore.php  fh  4.      @   vendor/symfony/framework-bundle/Resources/config/annotations.php
  fh
  ݋\      >   vendor/symfony/framework-bundle/Resources/config/profiling.php=  fh=  +      ;   vendor/symfony/framework-bundle/Resources/config/mailer.php
  fh
  븤      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  fhw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  fh  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  fh  w0      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  fh  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  fh  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php  fh  W      @   vendor/symfony/framework-bundle/Resources/config/http_client.phpx
  fhx
  ^?Ϥ      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  fh  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php]#  fh]#  k      :   vendor/symfony/framework-bundle/Resources/config/cache.php"  fh"  -l7      <   vendor/symfony/framework-bundle/Resources/config/session.php  fh  wr      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php  fh  i?
      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php	  fh	  ?H      :   vendor/symfony/framework-bundle/Resources/config/debug.php  fh  L_      E   vendor/symfony/framework-bundle/Resources/config/notifier_webhook.php  fh  ,      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  fh	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpZ  fhZ  Oj      <   vendor/symfony/framework-bundle/Resources/config/routing.php  fh  A      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsd  fh  gD1      =   vendor/symfony/framework-bundle/Resources/config/notifier.php  fh  Ec      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  fh  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  fh  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  fh        <   vendor/symfony/framework-bundle/Resources/config/webhook.php  fh  P쌤      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  fh  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  fh/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  fh  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php?#  fh?#  Y      <   vendor/symfony/framework-bundle/Resources/config/console.php3  fh3  uҤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  fh=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  fh	  j      >   vendor/symfony/framework-bundle/Resources/config/scheduler.php  fh  1@w      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  fh  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  fh  k?֓      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  fh  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpq  fhq  %(      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  fh  >      D   vendor/symfony/framework-bundle/Resources/config/routing/webhook.xml  fh  Vc      C   vendor/symfony/framework-bundle/Resources/config/html_sanitizer.php  fh  Pդ      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  fh  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  fh  m17      E   vendor/symfony/framework-bundle/Resources/config/serializer_debug.php  fh        C   vendor/symfony/framework-bundle/Resources/config/workflow_debug.php  fh  RRT      C   vendor/symfony/framework-bundle/Resources/config/mailer_webhook.php
  fh
  dea      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  fhD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  fh  #m7Y      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php  fh  ~ܤ      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php^3  fh^3  |      ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  fh  _Q      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  fh  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.php  fh  v'      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  fh  %]      A   vendor/symfony/framework-bundle/Resources/config/remote_event.php  fh  
ä      <   vendor/symfony/framework-bundle/Resources/config/process.phpc  fhc        1   vendor/symfony/framework-bundle/KernelBrowser.php  fh        D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php^
  fh^
  hr      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpc  fhc  gp      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  fh
  $bΤ      A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php  fh  )      G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  fh  2e      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php  fh  ^M      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  fh  ҧ      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php  fh  l      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpH  fhH        A   vendor/symfony/framework-bundle/Controller/TemplateController.php	  fh	  k      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.php3  fh3  0      A   vendor/symfony/framework-bundle/Controller/RedirectController.php  fh  HǤ      )   vendor/symfony/framework-bundle/README.md!  fh!  q      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  fh
  R      3   vendor/symfony/framework-bundle/FrameworkBundle.php3  fh3  ب       >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  fh
  cc4      J   vendor/symfony/framework-bundle/Command/CachePoolInvalidateTagsCommand.phpK  fhK  ,ؤ      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.phpu
  fhu
  zBX      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php(  fh(  ~      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  fh  vtc      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php
  fh
        A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.phpi  fhi  VP      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  fh  s`i      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.php/D  fh/D  F%      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php8  fh8  !      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php'  fh'  ]3%      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  fh  ~T}      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  fh  ZQ~      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.php\  fh\  ]6      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php1	  fh1	  dƃ|      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  fh  \      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php  fh  B ؤ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.phpD  fhD  &      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.php  fh   ّY      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.phps<  fhs<  _ q      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpa<  fha<  $      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.phpA  fhA  Fs      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.php  fh  ;q      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.php  fh  3-      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  fh  yUɤ      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.php
  fh
  ҥ      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  fh  n٤      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.php7  fh7  }S      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php:  fh:        >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php4)  fh4)  E^%      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php!  fh!  )\      J   vendor/symfony/framework-bundle/Routing/AttributeRouteControllerLoader.php  fh  v1)      O   vendor/symfony/framework-bundle/Routing/Attribute/AsRoutingConditionService.php  fh  ny      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  fh  b       2   vendor/symfony/framework-bundle/Routing/Router.php  fh  ~Un      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  fh
  դ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php
  fh
  y,      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php7A fh7A R      J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php/ fh/ D[      O   vendor/symfony/framework-bundle/DependencyInjection/VirtualRequestStackPass.php  fh  
w      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.phpS  fhS  n>.      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.php	  fh	  j(v      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpW  fhW  W*ͤ      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpt  fht  b"      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  fh  o      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  fh  9/      ]   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TranslationUpdateCommandPass.php  fh        Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php#  fh#  ,      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/EnableLoggerDebugModePass.php  fh  }V      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php@	  fh@	  y`1      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.phpY  fhY  Nx      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.phpV  fhV  0#      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  fh  ~Y      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  fh	  &1      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php   fh   k)̤      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  fh  `:W      -   vendor/symfony/framework-bundle/composer.json  fh  cFD
      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.phpf   fhf   ૦      7   vendor/symfony/framework-bundle/Console/Application.phpE   fhE   '23      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpm  fhm  JL      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpj  fhj  ksnU      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.php6  fh6        E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.phpD  fhD  vF      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.php8I  fh8I  h      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  fh  *      I   vendor/symfony/framework-bundle/EventListener/ConsoleProfilerListener.php  fh  g(Ҥ      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php	  fh	  Su      %   vendor/symfony/monolog-bundle/LICENSE)  fh)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  fh  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  fh.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  fh'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  fh        '   vendor/symfony/monolog-bundle/README.mdY  fhY        /   vendor/symfony/monolog-bundle/MonologBundle.php  fh  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  fhi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  fh  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  fh  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  fh        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  fh
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  fh  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  fh   *Q      +   vendor/symfony/monolog-bundle/composer.json  fh  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  fh,        '   vendor/symfony/polyfill-php73/Php73.phps  fhs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  fhE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  fh  |      '   vendor/symfony/polyfill-php73/README.md/  fh/  m      +   vendor/symfony/polyfill-php73/composer.json  fh  t      C   vendor/symfony/serializer/DataCollector/SerializerDataCollector.php?  fh?  8      (   vendor/symfony/serializer/Serializer.phpH  fhH  |      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.phpu
  fhu
  5      <   vendor/symfony/serializer/Mapping/ClassMetadataInterface.php3  fh3  闙      3   vendor/symfony/serializer/Mapping/ClassMetadata.phpV
  fhV
  ŏ=      <   vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php+5  fh+5  y      7   vendor/symfony/serializer/Mapping/Loader/FileLoader.phpF  fhF  hդ      <   vendor/symfony/serializer/Mapping/Loader/LoaderInterface.phpY  fhY  
lޤ      ;   vendor/symfony/serializer/Mapping/Loader/YamlFileLoader.php  fh  rF      a   vendor/symfony/serializer/Mapping/Loader/schema/dic/serializer-mapping/serializer-mapping-1.0.xsd  fh  7      :   vendor/symfony/serializer/Mapping/Loader/XmlFileLoader.php  fh  W      8   vendor/symfony/serializer/Mapping/Loader/LoaderChain.php  fh  S*      =   vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php  fh  a      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php  fh  2      @   vendor/symfony/serializer/Mapping/AttributeMetadataInterface.php  fh  v5      ?   vendor/symfony/serializer/Mapping/ClassDiscriminatorMapping.php  fh  2q      J   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryCompiler.phpp  fhp  A
      @   vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php+  fh+  u鏤      B   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php  fh  5      G   vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php  fh        J   vendor/symfony/serializer/Mapping/Factory/CompiledClassMetadataFactory.php7  fh7  @IP      K   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php  fh  /      7   vendor/symfony/serializer/Mapping/AttributeMetadata.php  fh  j\      1   vendor/symfony/serializer/SerializerInterface.php}  fh}  WY      F   vendor/symfony/serializer/Context/Encoder/CsvEncoderContextBuilder.php  fh  H      F   vendor/symfony/serializer/Context/Encoder/XmlEncoderContextBuilder.php  fh  |̤      G   vendor/symfony/serializer/Context/Encoder/YamlEncoderContextBuilder.php  fh  \      G   vendor/symfony/serializer/Context/Encoder/JsonEncoderContextBuilder.php  fh  ;b      9   vendor/symfony/serializer/Context/ContextBuilderTrait.php  fh  W6      >   vendor/symfony/serializer/Context/SerializerContextBuilder.php  fh  ޵R      =   vendor/symfony/serializer/Context/ContextBuilderInterface.php  fh  n
      O   vendor/symfony/serializer/Context/Normalizer/ObjectNormalizerContextBuilder.php#  fh#  D      Q   vendor/symfony/serializer/Context/Normalizer/DateTimeNormalizerContextBuilder.php  fh  ,P      R   vendor/symfony/serializer/Context/Normalizer/FormErrorNormalizerContextBuilder.php  fh  sڤ      U   vendor/symfony/serializer/Context/Normalizer/GetSetMethodNormalizerContextBuilder.php/  fh/  gB      Y   vendor/symfony/serializer/Context/Normalizer/JsonSerializableNormalizerContextBuilder.php1  fh1  z      P   vendor/symfony/serializer/Context/Normalizer/ProblemNormalizerContextBuilder.php  fh  \oq      W   vendor/symfony/serializer/Context/Normalizer/AbstractObjectNormalizerContextBuilder.phpQ  fhQ  2      S   vendor/symfony/serializer/Context/Normalizer/BackedEnumNormalizerContextBuilder.phpg  fhg  S      `   vendor/symfony/serializer/Context/Normalizer/ConstraintViolationListNormalizerContextBuilder.php7  fh7  gO      U   vendor/symfony/serializer/Context/Normalizer/UnwrappingDenormalizerContextBuilder.php!  fh!  t;9      Q   vendor/symfony/serializer/Context/Normalizer/AbstractNormalizerContextBuilder.php  fh  r㽤      L   vendor/symfony/serializer/Context/Normalizer/UidNormalizerContextBuilder.php  fh  B4      Q   vendor/symfony/serializer/Context/Normalizer/PropertyNormalizerContextBuilder.php  fh  8      U   vendor/symfony/serializer/Context/Normalizer/DateIntervalNormalizerContextBuilder.phpB  fhB  Ѥ      6   vendor/symfony/serializer/Attribute/SerializedName.php  fh  pl      .   vendor/symfony/serializer/Attribute/Ignore.php  fh        /   vendor/symfony/serializer/Attribute/Context.php	  fh	  Oq'      8   vendor/symfony/serializer/Attribute/DiscriminatorMap.php  fh  Ӥ      6   vendor/symfony/serializer/Attribute/SerializedPath.php  fh  <      0   vendor/symfony/serializer/Attribute/MaxDepth.php  fh  [v      .   vendor/symfony/serializer/Attribute/Groups.php  fh  !x
      !   vendor/symfony/serializer/LICENSE,  fh,  U      &   vendor/symfony/serializer/CHANGELOG.md6<  fh6<  qSx      0   vendor/symfony/serializer/Encoder/CsvEncoder.php'  fh'  8zڤ      B   vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php  fh  o׍      2   vendor/symfony/serializer/Encoder/ChainEncoder.phpg  fhg  A0      6   vendor/symfony/serializer/Encoder/DecoderInterface.php/  fh/  
      B   vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php  fh  Q{N      A   vendor/symfony/serializer/Encoder/NormalizationAwareInterface.phpv  fhv  
/g      6   vendor/symfony/serializer/Encoder/EncoderInterface.php  fh  _J      2   vendor/symfony/serializer/Encoder/ChainDecoder.php  fh  }[      0   vendor/symfony/serializer/Encoder/JsonEncode.php  fh  ۤ      1   vendor/symfony/serializer/Encoder/JsonEncoder.php  fh  w      0   vendor/symfony/serializer/Encoder/JsonDecode.php<  fh<  Dh$      1   vendor/symfony/serializer/Encoder/YamlEncoder.phpq
  fhq
  !y]      0   vendor/symfony/serializer/Encoder/XmlEncoder.phpH  fhH  pbR      J   vendor/symfony/serializer/CacheWarmer/CompiledClassMetadataCacheWarmer.php7  fh7  Ƭc      7   vendor/symfony/serializer/Annotation/SerializedName.php[  fh[  PR      /   vendor/symfony/serializer/Annotation/Ignore.phpC  fhC  𽩤      0   vendor/symfony/serializer/Annotation/Context.php  fh  ;i*      9   vendor/symfony/serializer/Annotation/DiscriminatorMap.phpB  fhB  R?      7   vendor/symfony/serializer/Annotation/SerializedPath.php[  fh[  ޢ6X      1   vendor/symfony/serializer/Annotation/MaxDepth.phpI  fhI  BY      /   vendor/symfony/serializer/Annotation/Groups.php^  fh^  wLN      L   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractorInterface.php^  fh^  $7      C   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractor.php{  fh{  E      6   vendor/symfony/serializer/SerializerAwareInterface.php  fh  M      #   vendor/symfony/serializer/README.mdJ  fhJ  Mc%      B   vendor/symfony/serializer/NameConverter/NameConverterInterface.php  fh  pvEq      J   vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php  fh  6      F   vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php  fh  .]      M   vendor/symfony/serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php8  fh8  \Ѥ      2   vendor/symfony/serializer/Command/DebugCommand.phpy  fhy  2 3      ;   vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php  fh  aZ      >   vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.phpD  fhD  Br͌      @   vendor/symfony/serializer/Normalizer/DenormalizableInterface.phpv  fhv        :   vendor/symfony/serializer/Normalizer/ProblemNormalizer.php  fh  K      I   vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php"  fh"  Jgɤ      >   vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php-  fh-  Ґ~}      <   vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php	  fh	  cI      J   vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php7  fh7  #      :   vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php  fh        A   vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php  fh  .      ?   vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php  fh  6Ǥ      ?   vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php}
  fh}
  /)      =   vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.phpk  fhk  #      A   vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php%  fh%  :]R      C   vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php1
  fh1
  PC      :   vendor/symfony/serializer/Normalizer/DataUriNormalizer.php  fh  %      H   vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php  fh  +      9   vendor/symfony/serializer/Normalizer/CustomNormalizer.phpB  fhB  O(      C   vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php/  fh/  <ǖ      ?   vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php  fh  zԋ      ;   vendor/symfony/serializer/Normalizer/PropertyNormalizer.php#  fh#        9   vendor/symfony/serializer/Normalizer/ObjectNormalizer.php!  fh!  cRb      ;   vendor/symfony/serializer/Normalizer/AbstractNormalizer.phpa  fha  Pt      ?   vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php  fh  Z7(G      6   vendor/symfony/serializer/Normalizer/UidNormalizer.php  fh   ru      >   vendor/symfony/serializer/Normalizer/DenormalizerInterface.php
  fh
  Vi3      >   vendor/symfony/serializer/Normalizer/NormalizableInterface.php  fh        ?   vendor/symfony/serializer/Normalizer/GetSetMethodNormalizer.php  fh  ṗ      =   vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php,  fh,  g      J   vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php  fh  o      <   vendor/symfony/serializer/Normalizer/NormalizerInterface.php  fh  e      ?   vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php{  fh{  o      2   vendor/symfony/serializer/SerializerAwareTrait.php`  fh`  ĝ|      @   vendor/symfony/serializer/DependencyInjection/SerializerPass.php
  fh
        6   vendor/symfony/serializer/Exception/LogicException.php  fh  A      :   vendor/symfony/serializer/Exception/ExceptionInterface.php  fh  Za      L   vendor/symfony/serializer/Exception/MissingConstructorArgumentsException.php  fh  a      @   vendor/symfony/serializer/Exception/UnexpectedValueException.php  fh  rǤ      8   vendor/symfony/serializer/Exception/RuntimeException.php  fh  VX      E   vendor/symfony/serializer/Exception/NotNormalizableValueException.phpc  fhc  N͜      @   vendor/symfony/serializer/Exception/InvalidArgumentException.php  fh  n      B   vendor/symfony/serializer/Exception/CircularReferenceException.php  fh  s5      >   vendor/symfony/serializer/Exception/BadMethodCallException.php  fh  }
      8   vendor/symfony/serializer/Exception/MappingException.php  fh  Ǡۤ      <   vendor/symfony/serializer/Exception/UnsupportedException.php  fh         B   vendor/symfony/serializer/Exception/NotEncodableValueException.php  fh  \53      G   vendor/symfony/serializer/Exception/PartialDenormalizationException.phpM  fhM  D      B   vendor/symfony/serializer/Exception/UnsupportedFormatException.php  fh  G`k      @   vendor/symfony/serializer/Exception/ExtraAttributesException.php  fh  3ٌ      '   vendor/symfony/serializer/composer.json	  fh	  ɮ      4   vendor/symfony/serializer/Debug/TraceableEncoder.php'  fh'  hͤ      7   vendor/symfony/serializer/Debug/TraceableSerializer.php  fh  ɸ      7   vendor/symfony/serializer/Debug/TraceableNormalizer.phpa  fha  ;ݤ      *   vendor/symfony/polyfill-php80/PhpToken.php  fh  dF      %   vendor/symfony/polyfill-php80/LICENSE,  fh,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  fhw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  fh>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  fh  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  fhG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  fh  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  fh  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  fh  "tF      '   vendor/symfony/polyfill-php80/Php80.php  fh  H      +   vendor/symfony/polyfill-php80/composer.jsonb  fhb  F      7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  fh  1d      H   vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php  fh        8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php  fh  Ѻ	      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  fh  c      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.phpT  fhT  s      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.php  fh  \~      >   vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php  fh  !E      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php	  fh	  %ˤ      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  fh  J      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.php0  fh0  ݤ      F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  fh  ]ڤ      (   vendor/symfony/monolog-bridge/Logger.php-
  fh-
  y      %   vendor/symfony/monolog-bridge/LICENSE,  fh,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  fh
  `s      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.php<  fh<  ]      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php  fh  A܊      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  fh        B   vendor/symfony/monolog-bridge/Processor/CompatibilityProcessor.php!  fh!  6$      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php	  fh	  <      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpJ  fhJ  ZU      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php  fh  dC      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  fh  c4      '   vendor/symfony/monolog-bridge/README.md  fh  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  fh  Pp      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php0  fh0  r~ݤ      B   vendor/symfony/monolog-bridge/Formatter/CompatibilityFormatter.php  fh  ˦k      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.php  fh        +   vendor/symfony/monolog-bridge/composer.json  fh  -}b      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  fh        "   vendor/symfony/cache/CacheItem.php  fh  =g      #   vendor/symfony/cache/Psr16Cache.php=  fh=  8`c         vendor/symfony/cache/LICENSE,  fh,  X      +   vendor/symfony/cache/PruneableInterface.php  fh  a]      !   vendor/symfony/cache/CHANGELOG.mdo  fho  ʗXJ      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.php  fh  &yF      /   vendor/symfony/cache/Traits/RelayProxyTrait.php  fh  R      *   vendor/symfony/cache/Traits/RedisTrait.phpju  fhju  ?Τ      +   vendor/symfony/cache/Traits/Redis5Proxy.php׷  fh׷  \٤      2   vendor/symfony/cache/Traits/RedisCluster6Proxy.phps  fhs  Q      *   vendor/symfony/cache/Traits/ProxyTrait.php%  fh%  P      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php9  fh9        1   vendor/symfony/cache/Traits/RedisClusterProxy.php  fh  `"      *   vendor/symfony/cache/Traits/RedisProxy.php  fh  G.r      .   vendor/symfony/cache/Traits/ContractsTrait.php&  fh&  .M=      *   vendor/symfony/cache/Traits/RelayProxy.php^  fh^        0   vendor/symfony/cache/Traits/Redis6ProxyTrait.php  fh  P      ,   vendor/symfony/cache/Traits/ValueWrapper.phpE  fhE  i7      2   vendor/symfony/cache/Traits/RedisCluster5Proxy.php\  fh\  UҤ      /   vendor/symfony/cache/Traits/FilesystemTrait.php  fh  7      +   vendor/symfony/cache/Traits/Redis6Proxy.php  fh  X      4   vendor/symfony/cache/Traits/Relay/GeosearchTrait.php'  fh'  7      /   vendor/symfony/cache/Traits/Relay/MoveTrait.php  fh  [r      2   vendor/symfony/cache/Traits/Relay/PfcountTrait.php  fh  D      /   vendor/symfony/cache/Traits/Relay/CopyTrait.php  fh  ѽ      9   vendor/symfony/cache/Traits/Relay/NullableReturnTrait.phpZ  fhZ  *zʤ      2   vendor/symfony/cache/Traits/Relay/Relay11Trait.phpv  fhv  n      /   vendor/symfony/cache/Traits/Relay/HsetTrait.php  fh  E      1   vendor/symfony/cache/Traits/Relay/SwapdbTrait.php  fh  b      3   vendor/symfony/cache/Traits/Relay/GetrangeTrait.php  fh  XԖ      4   vendor/symfony/cache/Traits/Relay/IsTrackedTrait.php  fh  5      -   vendor/symfony/cache/Traits/Relay/FtTrait.php  fh  0C      6   vendor/symfony/cache/Traits/Relay/GetWithMetaTrait.php  fh  ^D      1   vendor/symfony/cache/Traits/Relay/BgsaveTrait.php  fh  )¤      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php\0  fh\0  1Ť      7   vendor/symfony/cache/Traits/RedisCluster6ProxyTrait.php  fh  Xm      -   vendor/symfony/cache/Adapter/ProxyAdapter.php_  fh_  <      ,   vendor/symfony/cache/Adapter/ApcuAdapter.php?
  fh?
  [/      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.php  fh  ƫ}      1   vendor/symfony/cache/Adapter/TraceableAdapter.php  fh  
bJ6      +   vendor/symfony/cache/Adapter/PdoAdapter.phpA  fhA        -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  fh,  ߍ       5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php0  fh0  1      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.php  fh  <^      ,   vendor/symfony/cache/Adapter/NullAdapter.php  fh  :@      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  fh  +      0   vendor/symfony/cache/Adapter/TagAwareAdapter.php,  fh,  mX      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  fh(   &      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpA  fhA  nƬq      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php	  fh	  ?      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php4  fh4  N9T      -   vendor/symfony/cache/Adapter/RedisAdapter.php/  fh/  -U=$      1   vendor/symfony/cache/Adapter/AdapterInterface.php  fh  $B      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.php#  fh#  ˤ      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  fh  6s:      -   vendor/symfony/cache/Adapter/Psr16Adapter.php*  fh*  $\      -   vendor/symfony/cache/Adapter/ChainAdapter.php]"  fh]"  x      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  fh  (Acb      0   vendor/symfony/cache/Adapter/AbstractAdapter.php2  fh2  @2      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php1  fh1  ;,      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php/  fh/   Ť      %   vendor/symfony/cache/LockRegistry.php  fh  )?Ӥ      ,   vendor/symfony/cache/ResettableInterface.php  fh  NR         vendor/symfony/cache/README.md  fh  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php7
  fh7
  r      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php
  fh
  %      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.php	  fh	  q      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.phpK  fhK  h&      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  fh  C      7   vendor/symfony/cache/Marshaller/MarshallerInterface.php3  fh3  Ǚ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php  fh  t      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php`	  fh`	  F      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.php'  fh'  1i      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  fh  m}      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  fh  t      A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.php  fh  Ł:      1   vendor/symfony/cache/Exception/LogicException.php  fh  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  fh  j      1   vendor/symfony/cache/Exception/CacheException.php  fh  Q4      "   vendor/symfony/cache/composer.json  fh  Fw      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  fhr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  fh,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  fh@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  fh^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  fh   /      +   vendor/symfony/polyfill-ctype/composer.json  fh  9      %   vendor/symfony/polyfill-php81/LICENSE,  fh,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  fh  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  fh  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  fh  <P      '   vendor/symfony/polyfill-php81/README.md  fh        '   vendor/symfony/polyfill-php81/Php81.php  fh  3E      +   vendor/symfony/polyfill-php81/composer.json  fh  #@      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php>.  fh>.  n      &   vendor/symfony/security-bundle/LICENSE,  fh,  U      +   vendor/symfony/security-bundle/CHANGELOG.mdCD  fhCD  ;      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  fh	  Ӈ      =   vendor/symfony/security-bundle/Security/UserAuthenticator.php>  fh>  @      ;   vendor/symfony/security-bundle/Security/FirewallContext.php  fh  	͢      7   vendor/symfony/security-bundle/Security/FirewallMap.php;	  fh;	  5r\      :   vendor/symfony/security-bundle/Security/FirewallConfig.php	  fh	  `9p      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  fh  s      W   vendor/symfony/security-bundle/Resources/config/security_authenticator_access_token.php  fh  43MU      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  fh  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  fh  Ne      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  fh	  +      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  fh3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   fh         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdX  fhX  f#      ;   vendor/symfony/security-bundle/Resources/config/console.php  fh  ,      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  fh  J      >   vendor/symfony/security-bundle/Resources/config/collectors.php  fh  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php  fh  VQ      <   vendor/symfony/security-bundle/Resources/config/security.php	.  fh	.  អ      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php  fh  K      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  fh  0צ      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twige  fhe  Y      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.phpq  fhq  50      1   vendor/symfony/security-bundle/SecurityBundle.php  fh  7-X      (   vendor/symfony/security-bundle/README.md  fh  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php^  fh^  H:y      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  fh@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.php"  fh"  ž&x      <   vendor/symfony/security-bundle/Routing/LogoutRouteLoader.php=  fh=  פ      +   vendor/symfony/security-bundle/Security.php1&  fh1&  ~,      J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php	  fh	  ߡ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpS9  fhS9  |      c   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcTokenHandlerFactory.php3  fh3  V      k   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcUserInfoTokenHandlerFactory.php
  fh
  ~G      f   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/ServiceTokenHandlerFactory.php  fh  CWߤ      h   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/TokenHandlerFactoryInterface.php  fh  w(      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.php	  fh	  HX      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php  fh  bHq      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  fh  vi      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.phpm  fhm  pSʤ      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  fh  (腊      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.php  fh  Rz      Z   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AccessTokenFactory.php  fh  AY      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.phpv  fhv  zä      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.phpK  fhK  pR      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  fh  Xi      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.php  fh  :Pդ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.phpG  fhG  3S      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.php*  fh*  隤      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  fh  p      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  fh  Vr@      a   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SignatureAlgorithmFactory.phpf  fhf  P      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.php  fh  }/      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  fh  
      n   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/StatelessAuthenticatorFactoryInterface.php	  fh	  9̤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php  fh  soF      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  fhm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  fh  .b      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.php  fh  A      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  fh  ߐ*7      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.php	  fh	  І;      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpW  fhW  9k      h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php 
  fh 
  Ǔ      Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.phpO  fhO  դ      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  fh	  >y      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  fh  x      U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  fh
  rҤ      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  fh  d%      i   vendor/symfony/security-bundle/DependencyInjection/Compiler/MakeFirewallsEventDispatcherTraceablePass.php`
  fh`
  U
p3      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  fh  "*A      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php	  fh	  8I      ,   vendor/symfony/security-bundle/composer.json  fh  ֛      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.phpN  fhN  Z.      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  fh  D      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.phpj  fhj  qU      <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.php  fh  
9      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  fh  +C      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpB  fhB  <ˊϤ      4   vendor/symfony/config/ResourceCheckerConfigCache.php~  fh~  p         vendor/symfony/config/LICENSE,  fh,  U      '   vendor/symfony/config/Util/XmlUtils.php$  fh$  U6      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  fh  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  fh4        "   vendor/symfony/config/CHANGELOG.mde  fhe  (,      .   vendor/symfony/config/ConfigCacheInterface.php  fh  	1      .   vendor/symfony/config/FileLocatorInterface.php  fh        %   vendor/symfony/config/ConfigCache.php  fh  S      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  fh  ^&      %   vendor/symfony/config/FileLocator.php4
  fh4
  =      2   vendor/symfony/config/ResourceCheckerInterface.php  fh  åؤ         vendor/symfony/config/README.mdT  fhT        '   vendor/symfony/config/Loader/Loader.php  fh  IѤ      >   vendor/symfony/config/Loader/DirectoryAwareLoaderInterface.php  fh  j=      +   vendor/symfony/config/Loader/FileLoader.php  fh  bUL      2   vendor/symfony/config/Loader/ParamConfigurator.phpq  fhq  n݁      0   vendor/symfony/config/Loader/LoaderInterface.phpy  fhy  ঽ      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  fh  G/3      /   vendor/symfony/config/Loader/LoaderResolver.phpF  fhF  )%%      1   vendor/symfony/config/Loader/DelegatingLoader.php  fh  Κ%      /   vendor/symfony/config/Loader/GlobFileLoader.php  fh  [      .   vendor/symfony/config/Definition/FloatNode.php  fh  Ť      -   vendor/symfony/config/Definition/BaseNode.php:  fh:  qY6      0   vendor/symfony/config/Definition/NumericNode.php)  fh)  	ä      :   vendor/symfony/config/Definition/ConfigurableInterface.phpo  fho  jש,      0   vendor/symfony/config/Definition/IntegerNode.phpV  fhV  (      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpp  fhp  <5@      2   vendor/symfony/config/Definition/Configuration.php  fh  j      8   vendor/symfony/config/Definition/PrototypedArrayNode.php,  fh,  d#      .   vendor/symfony/config/Definition/Processor.php	  fh	   \      @   vendor/symfony/config/Definition/Loader/DefinitionFileLoader.php  fh   "      2   vendor/symfony/config/Definition/NodeInterface.phpL  fhL  Q      -   vendor/symfony/config/Definition/EnumNode.php
  fh
  |      0   vendor/symfony/config/Definition/BooleanNode.php  fh  
B      H   vendor/symfony/config/Definition/Configurator/DefinitionConfigurator.phpy  fhy  =      .   vendor/symfony/config/Definition/ArrayNode.php.  fh.  ͤ      /   vendor/symfony/config/Definition/ScalarNode.php}  fh}  GrI      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  fh  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.phpL  fhL  :^      ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  fh  <      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  fh  |      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.phpm  fhm  Mg      8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  fh  |פ      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpg  fhg  ?      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php=  fh=  M}      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpl  fhl  %      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  fh  ]
      8   vendor/symfony/config/Definition/Builder/TreeBuilder.phpE  fhE  O      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php  fh  \+F}      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  fh  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  fh  Xä      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php  fh  YDq      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  fh  Σ      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  fh  *@      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php  fh  ю      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.phpf  fhf  3Ԥ      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  fhS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  fh  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  fh  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  fh*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.php  fh  i      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  fh_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  fh  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  fh
  o      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   fh   0      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.php'  fh'        @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  fh  2Ф      /   vendor/symfony/config/Resource/FileResource.php  fh  a      :   vendor/symfony/config/Resource/ReflectionClassResource.php7  fh7        >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php}  fh}  r      3   vendor/symfony/config/Resource/ComposerResource.php2  fh2  3Pu      8   vendor/symfony/config/Resource/FileExistenceResource.php  fh  w}      4   vendor/symfony/config/Resource/ResourceInterface.php  fh  8I      9   vendor/symfony/config/Resource/ClassExistenceResource.php   fh   T$      4   vendor/symfony/config/Resource/DirectoryResource.php
  fh
  C      /   vendor/symfony/config/Resource/GlobResource.phpW!  fhW!  ׏3      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  fh  {O      (   vendor/symfony/config/Builder/Method.php  fh  @֤      .   vendor/symfony/config/Builder/ClassBuilder.php  fh        *   vendor/symfony/config/Builder/Property.php,  fh,  _      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  fh        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpvS  fhvS  U(      7   vendor/symfony/config/Exception/LoaderLoadException.php  fh  /z      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php[  fh[  `ܤ      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.phpK  fhK  f      #   vendor/symfony/config/composer.json   fh   M      ,   vendor/symfony/config/ConfigCacheFactory.phpS  fhS  cġ      ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php5  fh5  Yb      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php  fh  b      4   vendor/symfony/security-http/Attribute/IsGranted.php  fh  `A      6   vendor/symfony/security-http/Attribute/CurrentUser.php!  fh!  C      $   vendor/symfony/security-http/LICENSE,  fh,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpb  fhb  6=Y      )   vendor/symfony/security-http/CHANGELOG.md  fh  k      ,   vendor/symfony/security-http/FirewallMap.php  fh  A
C      )   vendor/symfony/security-http/Firewall.php1  fh1  o:      J   vendor/symfony/security-http/AccessToken/AccessTokenExtractorInterface.phpf  fhf  }P      H   vendor/symfony/security-http/AccessToken/AccessTokenHandlerInterface.php  fh  msl      G   vendor/symfony/security-http/AccessToken/HeaderAccessTokenExtractor.php8  fh8  h      F   vendor/symfony/security-http/AccessToken/ChainAccessTokenExtractor.php'  fh'  g
      J   vendor/symfony/security-http/AccessToken/Oidc/OidcUserInfoTokenHandler.phpc	  fhc	        ;   vendor/symfony/security-http/AccessToken/Oidc/OidcTrait.php  fh  ̤      B   vendor/symfony/security-http/AccessToken/Oidc/OidcTokenHandler.php  fh        U   vendor/symfony/security-http/AccessToken/Oidc/Exception/InvalidSignatureException.php  fh  +FL      Q   vendor/symfony/security-http/AccessToken/Oidc/Exception/MissingClaimException.php  fh  	      E   vendor/symfony/security-http/AccessToken/FormEncodedBodyExtractor.phpm  fhm  }      F   vendor/symfony/security-http/AccessToken/QueryAccessTokenExtractor.php  fh  w      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.phpv  fhv  +      /   vendor/symfony/security-http/SecurityEvents.php  fh  7      8   vendor/symfony/security-http/Firewall/AccessListener.php
  fh
  8ä      9   vendor/symfony/security-http/Firewall/ContextListener.php5  fh5  d`ۤ      :   vendor/symfony/security-http/Firewall/AbstractListener.phpq  fhq        F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpj  fhj  ʯ      ;   vendor/symfony/security-http/Firewall/ExceptionListener.phpf(  fhf(  ti      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php=  fh=  9      9   vendor/symfony/security-http/Firewall/ChannelListener.php  fh  2      <   vendor/symfony/security-http/Firewall/SwitchUserListener.phpg$  fhg$  4
n      8   vendor/symfony/security-http/Firewall/LogoutListener.php  fh  (3\      F   vendor/symfony/security-http/Controller/SecurityTokenValueResolver.php  fh  J;Y      =   vendor/symfony/security-http/Controller/UserValueResolver.php  fh  ؉M      &   vendor/symfony/security-http/README.md  fh  k      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  fh         G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.php   fh   V      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  fh
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.phpQ  fhQ  Gk<[      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.phpX  fhX  a*      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php
  fh
  xo$f      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  fh  3i      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php  fh  (6      *   vendor/symfony/security-http/HttpUtils.php  fh  e      5   vendor/symfony/security-http/FirewallMapInterface.phpP  fhP  !      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.phpT  fhT  H      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpj  fhj  9      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  fh	  e      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.phpS
  fhS
  v
      A   vendor/symfony/security-http/Authenticator/FallbackUserLoader.php  fh  ٤      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php  fh   R      E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.phpe  fhe  Z      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php?  fh?  !6      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php  fh  7$;      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  fh  YWW      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php$  fh$   ;!2      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  fh  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  fh  @1      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.phpV  fhV  R      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  fh  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.phpi  fhi  $      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.phpV  fhV  Ĥ      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php  fh  V5פ      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.phpK  fhK  p"      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  fh  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php	  fh	  }      G   vendor/symfony/security-http/Authenticator/AccessTokenAuthenticator.php  fh  YTS      F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  fh  _]z      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpS  fhS  eQ8      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  fh  hʆ`      K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.phpO  fhO  ӊ2      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.phpg  fhg        F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.php  fh  Au      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.phpz  fhz  (      3   vendor/symfony/security-http/AccessMapInterface.phpi  fhi  HY%      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpe  fhe  Z/      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  fh  ąy      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  fh
  ֽ      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  fh  \S      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  fh  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  fh        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  fh  <Yķ      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  fhI  Z      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.phph  fhh  [)-G      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  fh  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php  fh  W"¤      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php>  fh>        C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php	  fh	  ج      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  fh  c      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.phpI  fhI  &4Q      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  fh  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php6  fh6  c
9      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php  fh  N"      *   vendor/symfony/security-http/AccessMap.php~  fh~  t<y      8   vendor/symfony/security-http/Event/LoginFailureEvent.php;
  fh;
  (Ϥ      8   vendor/symfony/security-http/Event/LoginSuccessEvent.php<  fh<  .      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  fh  /H
      6   vendor/symfony/security-http/Event/SwitchUserEvent.php  fh  U      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.phpW  fhW  c|      9   vendor/symfony/security-http/Event/CheckPassportEvent.php  fh  g      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.phpG  fhG  <KB      2   vendor/symfony/security-http/Event/LogoutEvent.php  fh        @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  fh  X2      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php%  fh%  ./ U      2   vendor/symfony/security-http/ParameterBagUtils.php  fh  [7b      *   vendor/symfony/security-http/composer.json\  fh\  7      :   vendor/symfony/security-http/SecurityRequestAttributes.php  fh  J      J   vendor/symfony/security-http/EventListener/ClearSiteDataLogoutListener.php  fh  jͤ      D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  fh  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.phpm  fhm        H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  fh  £פ      A   vendor/symfony/security-http/EventListener/RememberMeListener.php  fh  vx.ʤ      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php
  fh
  L      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpf  fhf  6i      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  fh  o[      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  fh  );L      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  fh  .      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpp  fhp  u      B   vendor/symfony/security-http/EventListener/UserCheckerListener.phpi  fhi  g%      I   vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php  fh  5D      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.php  fh        P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  fh
  wj      O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.phpC  fhC  'ʤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php]  fh]  Q         vendor/symfony/uid/UuidV8.phpK  fhK  {dL      !   vendor/symfony/uid/BinaryUtil.php-  fh-   Ҥ         vendor/symfony/uid/NilUuid.php  fh  MzĤ         vendor/symfony/uid/LICENSE,  fh,  K         vendor/symfony/uid/NilUlid.php  fh  [         vendor/symfony/uid/CHANGELOG.md  fh        "   vendor/symfony/uid/AbstractUid.php[  fh[  boO         vendor/symfony/uid/Ulid.phpP  fhP  ݤ         vendor/symfony/uid/Uuid.php  fh  t0[O         vendor/symfony/uid/MaxUlid.php  fh  >Z         vendor/symfony/uid/MaxUuid.php  fh  Sw4         vendor/symfony/uid/README.md\  fh\        2   vendor/symfony/uid/Command/GenerateUuidCommand.php(  fh(  vF@      2   vendor/symfony/uid/Command/GenerateUlidCommand.php  fh  ->      1   vendor/symfony/uid/Command/InspectUuidCommand.php
  fh
  +}      1   vendor/symfony/uid/Command/InspectUlidCommand.php  fh  0>Ȉ         vendor/symfony/uid/UuidV1.phpV  fhV  ʤ         vendor/symfony/uid/UuidV3.php^  fh^  (L         vendor/symfony/uid/UuidV6.phpN  fhN  ͤ         vendor/symfony/uid/UuidV7.php  fh  C/      3   vendor/symfony/uid/Factory/TimeBasedUuidFactory.php-  fh-  i`mU      *   vendor/symfony/uid/Factory/UuidFactory.php>
  fh>
   Xw      5   vendor/symfony/uid/Factory/RandomBasedUuidFactory.php[  fh[  \(R      *   vendor/symfony/uid/Factory/UlidFactory.php  fh  )ݿ      3   vendor/symfony/uid/Factory/NameBasedUuidFactory.php  fh  0 A          vendor/symfony/uid/composer.json  fh  s	ۤ      ,   vendor/symfony/uid/TimeBasedUidInterface.php  fh  Q         vendor/symfony/uid/UuidV5.php^  fh^  A         vendor/symfony/uid/UuidV4.php  fh  <      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  fh  a      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  fh  $      '   vendor/symfony/event-dispatcher/LICENSE,  fh,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md]  fh]  uE~      3   vendor/symfony/event-dispatcher/EventDispatcher.php9#  fh9#  ή&      )   vendor/symfony/event-dispatcher/README.mdW  fhW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  fh  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  fh  w      0   vendor/symfony/event-dispatcher/GenericEvent.php
  fh
  d      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php   fh   i٤      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  fh  &{      -   vendor/symfony/event-dispatcher/composer.json  fh  R      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php0  fh0  Js       9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php  fh  okŤ      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  fhH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php)  fh)  
      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  fh  ze      7   vendor/symfony/var-dumper/Cloner/Internal/NoDefault.php4  fh4  ߞ      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpo  fho  k      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php]  fh]  $^      )   vendor/symfony/var-dumper/Cloner/Data.php5  fh5  G      )   vendor/symfony/var-dumper/Cloner/Stub.phpk  fhk  Xܤ      !   vendor/symfony/var-dumper/LICENSE,  fh,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.phpV
  fhV
  F      &   vendor/symfony/var-dumper/CHANGELOG.md	  fh	  "D      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  fh
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php;  fh;  -,      /   vendor/symfony/var-dumper/Caster/StubCaster.php	  fh	  @v      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php|  fh|  c      .   vendor/symfony/var-dumper/Caster/FrameStub.php  fh  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php#  fh#  DJ      .   vendor/symfony/var-dumper/Caster/FFICaster.php  fh  ь      /   vendor/symfony/var-dumper/Caster/DateCaster.php;  fh;  C7>      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  fh  ɤ      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.php|	  fh|	        3   vendor/symfony/var-dumper/Caster/ResourceCaster.php  fh  ~      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpmA  fhmA  SL      6   vendor/symfony/var-dumper/Caster/UninitializedStub.phpy  fhy  0:      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  fhS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpH
  fhH
  ϼ      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php  fh  Y#g	      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.phpG  fhG  55      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  fh  9#      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  fh        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  fh  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php?  fh?  7V      .   vendor/symfony/var-dumper/Caster/TraceStub.php  fh  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  fh  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.php  fh  pv      +   vendor/symfony/var-dumper/Caster/Caster.php*  fh*  n      .   vendor/symfony/var-dumper/Caster/SplCaster.php]  fh]  4Dӻ      .   vendor/symfony/var-dumper/Caster/ConstStub.php   fh   3Ôk      /   vendor/symfony/var-dumper/Caster/ScalarStub.phpF  fhF  fA      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpn  fhn  0
      /   vendor/symfony/var-dumper/Caster/IntlCaster.php  fh        0   vendor/symfony/var-dumper/Caster/RedisCaster.php  fh  $OP      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpf  fhf  K      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  fh  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.phpH  fhH        .   vendor/symfony/var-dumper/Caster/DOMCaster.phpN  fhN  t      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  fh  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php  fh  5      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  fh	  O      -   vendor/symfony/var-dumper/Caster/EnumStub.php  fh  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  fh        7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  fh  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  fh  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  fhb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.php5  fh5  j1      /   vendor/symfony/var-dumper/Server/Connection.php
  fh
  xΤ      /   vendor/symfony/var-dumper/Server/DumpServer.php  fh  U駤      #   vendor/symfony/var-dumper/README.md_  fh_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  fh  S+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  fh  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  fh
  d      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  fh  	      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  fh  ä      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php  fh  DZ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php@  fh@  o/      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  fh(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php
  fh
  뉤      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  fh  B߫u      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  fh  u      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.phpq  fhq  	      .   vendor/symfony/var-dumper/Dumper/CliDumper.phpZ  fhZ  '      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  fh  U      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.php<  fh<   F      '   vendor/symfony/var-dumper/composer.json]  fh]        '   vendor/symfony/var-dumper/VarDumper.php  fh  Ϥ      !   vendor/symfony/filesystem/LICENSE,  fh,  U      &   vendor/symfony/filesystem/CHANGELOG.md  fh  I      (   vendor/symfony/filesystem/Filesystem.phpt  fht  @WI      "   vendor/symfony/filesystem/Path.php
f  fh
f  ׀s      #   vendor/symfony/filesystem/README.md  fh        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  fh        :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  fh  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  fh  A      3   vendor/symfony/filesystem/Exception/IOException.php  fh  0      @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  fh  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  fh   [:      '   vendor/symfony/filesystem/composer.json{  fh{  zq      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  fh
  .פ      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.phpK  fhK  <_      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php3  fh3        C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php  fh  7䭤      $   vendor/symfony/security-csrf/LICENSE,  fh,  U      )   vendor/symfony/security-csrf/CHANGELOG.md  fh  >*      *   vendor/symfony/security-csrf/CsrfToken.php  fh  3      &   vendor/symfony/security-csrf/README.md  fh        :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  fh  yɤ      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  fh  1      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php  fh  <xx      1   vendor/symfony/security-csrf/CsrfTokenManager.php  fh  Zؤ      A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  fh   U      *   vendor/symfony/security-csrf/composer.json  fh  -      ,   vendor/symfony/polyfill-uuid/bootstrap80.php  fh  jx      $   vendor/symfony/polyfill-uuid/LICENSE,  fh,        %   vendor/symfony/polyfill-uuid/Uuid.phpqB  fhqB  E      *   vendor/symfony/polyfill-uuid/bootstrap.php#  fh#  )      &   vendor/symfony/polyfill-uuid/README.md[  fh[  Ƥ      *   vendor/symfony/polyfill-uuid/composer.json  fh  {Ĥ      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  fh  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  fh,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  fh8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  fh  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  fh.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  fhx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  fh=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  fh  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  fh  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  fh  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  fhx        F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php,  fh,  ۃf      3   vendor/symfony/event-dispatcher-contracts/Event.php  fh  +Vg      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  fh,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   fh   h{#      3   vendor/symfony/event-dispatcher-contracts/README.mdZ  fhZ  9{Am      7   vendor/symfony/event-dispatcher-contracts/composer.json?  fh?  ׿s      8   vendor/symfony/property-access/PropertyPathInterface.php  fh  z      7   vendor/symfony/property-access/PropertyPathIterator.php  fh  ax      &   vendor/symfony/property-access/LICENSE,  fh,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php  fh  
M      +   vendor/symfony/property-access/CHANGELOG.md
  fh
  <4      <   vendor/symfony/property-access/PropertyAccessorInterface.php  fh  {Q      /   vendor/symfony/property-access/PropertyPath.php  fh        :   vendor/symfony/property-access/PropertyAccessorBuilder.php  fh  zH;       (   vendor/symfony/property-access/README.md1  fh1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpq{  fhq{  Egݤ      1   vendor/symfony/property-access/PropertyAccess.php  fh        6   vendor/symfony/property-access/PropertyPathBuilder.php!  fh!  2{      <   vendor/symfony/property-access/Exception/AccessException.php  fh  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  fh  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  fh  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  fh  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  fh  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  fh  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  fh  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phpy  fhy  bR      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  fh  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  fh  ?      ,   vendor/symfony/property-access/composer.json~  fh~        %   vendor/symfony/finder/SplFileInfo.php  fh  9$̤      5   vendor/symfony/finder/Comparator/NumberComparator.php
  fh
        /   vendor/symfony/finder/Comparator/Comparator.php  fh  @x      3   vendor/symfony/finder/Comparator/DateComparator.php  fh  ~Q          vendor/symfony/finder/Finder.phpPb  fhPb  F̲         vendor/symfony/finder/LICENSE,  fh,  U      "   vendor/symfony/finder/CHANGELOG.md
  fh
  3g         vendor/symfony/finder/Glob.php2  fh2  A         vendor/symfony/finder/README.md  fh  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  fh  Wđ      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php'  fh'  n!      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  fh  \v:c      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  fh  N      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.phpk  fhk  4-      9   vendor/symfony/finder/Iterator/FilenameFilterIterator.phpn  fhn  MNQ      :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  fh  9z֤      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php  fh  	ʤ      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.phpO  fhO        A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php5
  fh5
  `      3   vendor/symfony/finder/Iterator/SortableIterator.php3  fh3  뛽       ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.phpn  fhn  O      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php|  fh|  Aj      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  fh  (      #   vendor/symfony/finder/Gitignore.php  fh  Q)      9   vendor/symfony/finder/Exception/AccessDeniedException.php  fh        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  fh  )      #   vendor/symfony/finder/composer.json*  fh*  _      -   vendor/symfony/polyfill-php83/bootstrap81.php  fh  p$      %   vendor/symfony/polyfill-php83/LICENSE,  fh,  t=      B   vendor/symfony/polyfill-php83/Resources/stubs/SQLite3Exception.phpH  fhH  <ܐ      ;   vendor/symfony/polyfill-php83/Resources/stubs/DateError.php=  fh=  ˤ      :   vendor/symfony/polyfill-php83/Resources/stubs/Override.php  fh  NsE      ?   vendor/symfony/polyfill-php83/Resources/stubs/DateException.phpE  fhE        O   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidOperationException.phpY  fhY  Mߤ      A   vendor/symfony/polyfill-php83/Resources/stubs/DateObjectError.phpG  fhG  
.I      T   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedPeriodStringException.php^  fh^  K      N   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedStringException.phpX  fhX  Wߤ      @   vendor/symfony/polyfill-php83/Resources/stubs/DateRangeError.phpF  fhF  L;      N   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidTimeZoneException.phpX  fhX  g      V   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedIntervalStringException.php`  fh`  6      +   vendor/symfony/polyfill-php83/bootstrap.php  fh  {Jc      '   vendor/symfony/polyfill-php83/README.md  fh  }      '   vendor/symfony/polyfill-php83/Php83.php  fh        +   vendor/symfony/polyfill-php83/composer.json  fh  {V      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php%+  fh%+  p	q      @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php  fh  ]%      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php/  fh/  D
      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php	  fh	  NO      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php
  fh
  R       C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  fh        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.phpo>  fho>  se      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.phpl  fhl  kD      :   vendor/symfony/http-kernel/DataCollector/DataCollector.phpB  fhB  r      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.phpV)  fhV)  >W      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php<  fh<        ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.phpG  fhG  Jݤ      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.phpU  fhU  	      5   vendor/symfony/http-kernel/Attribute/AsController.php  fh  UT      @   vendor/symfony/http-kernel/Attribute/AsTargetedValueResolver.php
  fh
  w      .   vendor/symfony/http-kernel/Attribute/Cache.phpX
  fhX
  LҌ      7   vendor/symfony/http-kernel/Attribute/MapQueryString.php  fh  u~      7   vendor/symfony/http-kernel/Attribute/WithHttpStatus.php^  fh^  
      4   vendor/symfony/http-kernel/Attribute/MapDateTime.php   fh   j      :   vendor/symfony/http-kernel/Attribute/MapRequestPayload.php)  fh)  -"y      5   vendor/symfony/http-kernel/Attribute/WithLogLevel.php  fh  FH      6   vendor/symfony/http-kernel/Attribute/ValueResolver.php  fh  \      :   vendor/symfony/http-kernel/Attribute/MapQueryParameter.php\  fh\  %      "   vendor/symfony/http-kernel/LICENSE,  fh,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  fh  ͞1      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  fh  S      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php  fh  D{\Ǥ      '   vendor/symfony/http-kernel/CHANGELOG.mdQ  fhQ        1   vendor/symfony/http-kernel/Config/FileLocator.phpw  fhw        /   vendor/symfony/http-kernel/HttpClientKernel.php  fh  u*D      2   vendor/symfony/http-kernel/TerminableInterface.php  fh        A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php*  fh*  雗      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.phpJ  fhJ  7      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  fh  r2      5   vendor/symfony/http-kernel/Resources/welcome.html.php  fh  i      )   vendor/symfony/http-kernel/HttpKernel.php-  fh-  ¤      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php  fh  Q      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  fh  QĤ      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php3  fh3  P@ˤ      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  fh  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.php  fh  ~o      5   vendor/symfony/http-kernel/Bundle/BundleInterface.php  fh  "z      4   vendor/symfony/http-kernel/Bundle/AbstractBundle.php  fh  |`      5   vendor/symfony/http-kernel/Bundle/BundleExtension.php	  fh	  Y]=      .   vendor/symfony/http-kernel/KernelInterface.php  fh  J:      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  fh  <n      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  fh5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php>  fh>  B      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php  fh  f      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php@  fh@  S      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.php|  fh|  wS      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  fh  ^(2      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/QueryParameterValueResolver.php  fh  g,      K   vendor/symfony/http-kernel/Controller/ArgumentResolver/UidValueResolver.php  fh  ybޤ      R   vendor/symfony/http-kernel/Controller/ArgumentResolver/BackedEnumValueResolver.php0  fh0  Ns      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.phpD"  fhD"  rn      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/DateTimeValueResolver.php
  fh
  7      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  fh  05      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  fh  o      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  fh  q?柤      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php:
  fh:
  <      Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php3  fh3  8?      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpt  fht  q/m      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phpy  fhy  5ݰʤ      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php  fh  D      @   vendor/symfony/http-kernel/Controller/ValueResolverInterface.php  fh  @9      <   vendor/symfony/http-kernel/Controller/ControllerResolver.php0(  fh0(  7nl      E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.phpJ  fhJ  #@      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  fh  %      $   vendor/symfony/http-kernel/README.md  fh  7      E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php:  fh:  Ze      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php  fh  b^b      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.php%  fh%  	      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.php  fh  ,J      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  fh  Ǜ<      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php$  fh$        ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.php%  fh%  p      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php/
  fh/
  r0      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  fh  <̤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php+  fh+  rT      +   vendor/symfony/http-kernel/KernelEvents.phpd  fhd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php
  fh
  
K\      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpRk  fhRk  $ˏ      .   vendor/symfony/http-kernel/HttpCache/Store.php9  fh9  j=      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  fh  r      G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php:  fh:  )Ou      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php!  fh!  Xפ      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  fh  +      ,   vendor/symfony/http-kernel/HttpCache/Ssi.phpR
  fhR
  Y      @   vendor/symfony/http-kernel/HttpCache/CacheWasLockedException.phpy  fhy  Lv      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  fh  ڄ      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  fh1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  fh   Z      )   vendor/symfony/http-kernel/Log/Logger.php2  fh2  Y8X      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.phpD  fhD  'V      :   vendor/symfony/http-kernel/Log/DebugLoggerConfigurator.phpH  fhH  ,      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php(  fh(  |r      /   vendor/symfony/http-kernel/Profiler/Profile.phpo  fho   #      0   vendor/symfony/http-kernel/Profiler/Profiler.php  fh  27ya      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  fh  0Ĥ      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php  fh  P      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.php  fh  /v      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php  fh  2@      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php  fh  &ˏ      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  fh  T
      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.php  fh  :      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  fh  6v      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php)  fh)  Q*      <   vendor/symfony/http-kernel/DependencyInjection/Extension.php_  fh_  ʍ/      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.phpY  fhY  FT      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php.  fh.  8      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php
  fh
  5
դ      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  fh        E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  fh  <      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.phpc  fhc        6   vendor/symfony/http-kernel/Exception/HttpException.phpN  fhN  դ      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  fh  8      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  fhj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.phpi  fhi  
l      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.phpw  fhw  3      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.phpm  fhm  m%      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php_  fh_  ey      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.phpo  fho  aM}      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  fh  Zis      <   vendor/symfony/http-kernel/Exception/LockedHttpException.phpe  fhe  peh      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.phpm  fhm  =      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php}  fh}  ֚5      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php  fh  6HHg      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.phpe  fhe  Ց      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.php  fh  t<
e      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.phph  fhh  (ޤ      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php  fh  cԤ      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.phpj  fhj  Vz      F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  fh  iנ      B   vendor/symfony/http-kernel/Exception/ResolverNotFoundException.php  fh  y	+      4   vendor/symfony/http-kernel/Event/ControllerEvent.phpj  fhj  w.Ƥ      3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  fh  p-      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  fh  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  fh  ,7      3   vendor/symfony/http-kernel/Event/TerminateEvent.php  fh  VC      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.php  fh  nT      0   vendor/symfony/http-kernel/Event/KernelEvent.php  fh  DBc      1   vendor/symfony/http-kernel/Event/RequestEvent.php  fh  ׁ      .   vendor/symfony/http-kernel/Event/ViewEvent.php  fh        (   vendor/symfony/http-kernel/composer.jsonm  fhm  -m      2   vendor/symfony/http-kernel/RebootableInterface.php<  fh<  pLX1      %   vendor/symfony/http-kernel/Kernel.phpw  fhw  NAA      (   vendor/symfony/http-kernel/UriSigner.php  fh  2[{      8   vendor/symfony/http-kernel/Debug/VirtualRequestStack.phpI  fhI  U&      =   vendor/symfony/http-kernel/Debug/ErrorHandlerConfigurator.php  fh  P      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php  fh  ]`>      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php  fh        0   vendor/symfony/http-kernel/HttpKernelBrowser.php  fh  i\      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  fh  }>Ť      =   vendor/symfony/http-kernel/EventListener/ResponseListener.php  fh  PUȤ      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  fh  7)<      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php8  fh8  v      C   vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php1  fh1  ۤ      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.phpd0  fhd0  o!      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  fh  x      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.phpo  fho  >JȤ      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  fh  q       =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php<  fh<  <3W      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.phpU  fhU  M      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php  fh  n      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  fh	        9   vendor/symfony/http-kernel/EventListener/DumpListener.php%  fh%  ۤ      :   vendor/symfony/http-kernel/EventListener/ErrorListener.php!  fh!  	O      <   vendor/symfony/http-kernel/EventListener/SessionListener.php  fh        ;   vendor/symfony/http-kernel/EventListener/RouterListener.php  fh  G]9         vendor/symfony/yaml/LICENSE,  fh,  U         vendor/symfony/yaml/Parser.php  fh  i          vendor/symfony/yaml/CHANGELOG.md  fh  Ĥ         vendor/symfony/yaml/Escaper.php  fh  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  fh  3VԈ         vendor/symfony/yaml/README.md  fh  ـT      !   vendor/symfony/yaml/Unescaper.phpK  fhK   脱         vendor/symfony/yaml/Dumper.php  fh  h         vendor/symfony/yaml/Inline.php  fh  z@#         vendor/symfony/yaml/Yaml.php  fh  LϽ      +   vendor/symfony/yaml/Command/LintCommand.php'  fh'  te      /   vendor/symfony/yaml/Exception/DumpException.php  fh  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  fh  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  fh  #OU      0   vendor/symfony/yaml/Exception/ParseException.php  fh  mFB      '   vendor/symfony/yaml/Tag/TaggedValue.php  fh  s$      !   vendor/symfony/yaml/composer.json  fh   Zܦ      )   vendor/symfony/string/CodePointString.phpN  fhN  J         vendor/symfony/string/LICENSE,  fh,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdz  fhz  ub      (   vendor/symfony/string/AbstractString.phpI  fhI  k      -   vendor/symfony/string/Resources/functions.phpc  fhc  Ȥ      <   vendor/symfony/string/Resources/data/wcswidth_table_zero.phpF  fhF  MI      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.phpk  fhk  /      3   vendor/symfony/string/Inflector/FrenchInflector.php  fh  Q      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  fhR  _      4   vendor/symfony/string/Inflector/EnglishInflector.php.E  fh.E  ^ƫ         vendor/symfony/string/README.md+  fh+  L      /   vendor/symfony/string/AbstractUnicodeString.phpxc  fhxc  7q      $   vendor/symfony/string/LazyString.php  fh        $   vendor/symfony/string/ByteString.phpv9  fhv9  }      '   vendor/symfony/string/UnicodeString.php1  fh1        6   vendor/symfony/string/Exception/ExceptionInterface.php_  fh_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  fh~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  fh  B;8      #   vendor/symfony/string/composer.json  fh  #      2   vendor/symfony/string/Slugger/SluggerInterface.php  fh        .   vendor/symfony/string/Slugger/AsciiSlugger.php  fh  [=M      4   vendor/symfony/security-core/Role/SwitchUserRole.php  fh  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  fh]  Բ'      *   vendor/symfony/security-core/Role/Role.php  fh  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  fh  UՈ      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php"  fh"  <0      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.php~
  fh~
  ^      $   vendor/symfony/security-core/LICENSE,  fh,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  fh	  A      B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  fh  `5      N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  fh  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  fh  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  fh  d5A      )   vendor/symfony/security-core/CHANGELOG.md  fh  &      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfS  fhS  B&^      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  fh  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  fh  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  fhU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  fh  IѤ      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  fh  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  fh  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  fh8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  fh        C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  fhl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  fh  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  fh  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  fh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  fh,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  fh  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  fh  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  fh  "֤      C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  fhv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  fh  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlfc  fhc  @ۤ      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  fh  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  fh)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  fh  0˵      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  fhv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  fh  D      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  fh  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlfX  fhX  \ä      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  fh  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  fhl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  fh  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  fh  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  fh  d캤      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf6  fh6  dξ      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  fh  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  fh  Ȉf      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  fh  S0k3      C   vendor/symfony/security-core/Resources/translations/security.tl.xlfW  fhW        C   vendor/symfony/security-core/Resources/translations/security.my.xlf  fh  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  fh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  fh  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  fh^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  fh  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlfh  fhh  u      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  fh[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  fh  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  fh  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  fhV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  fh  A      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  fh  a      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  fh8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlf0  fh0  |񗢤      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  fh:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  fh  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  fh   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  fh  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  fh  ^P      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  fhy  Aze      J   vendor/symfony/security-core/User/AttributesBasedUserProviderInterface.phpN  fhN  u      .   vendor/symfony/security-core/User/OidcUser.php  fh        9   vendor/symfony/security-core/User/InMemoryUserChecker.php  fh  l      3   vendor/symfony/security-core/User/UserInterface.php  fh  K-      ;   vendor/symfony/security-core/User/UserProviderInterface.phpI	  fhI	  ̤      9   vendor/symfony/security-core/User/MissingUserProvider.php  fh  E      6   vendor/symfony/security-core/User/ChainUserChecker.phpd  fhd  OϤ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  fh1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  fh  }m      2   vendor/symfony/security-core/User/InMemoryUser.phpX  fhX  H      :   vendor/symfony/security-core/User/InMemoryUserProvider.php  fh  ,aR      8   vendor/symfony/security-core/User/EquatableInterface.phpm  fhm  C      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  fh  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.phpb  fhb  P      7   vendor/symfony/security-core/User/ChainUserProvider.php	  fh	         &   vendor/symfony/security-core/README.md  fh  {u!      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php2  fh2  O      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.phpV  fhV  @)5      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php
  fh
  T(      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpl  fhl  0ո      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php}  fh}  ,t      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  fh  ])      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  fh~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php3
  fh3
        G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpl  fhl  H??      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php)  fh)  'J      :   vendor/symfony/security-core/Authorization/Voter/Voter.phpf  fhf  5~      >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  fh  Pj^      G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpC  fhC  A      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  fh  8Cy      C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  fh  w      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php  fh   7^      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.php/  fh/        K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php  fh  
م      I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  fh  դ      W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  fh]  pf      )   vendor/symfony/security-core/Security.php
	  fh
	        @   vendor/symfony/security-core/Exception/AccessDeniedException.phpZ  fhZ  pth      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php}  fh}  O      :   vendor/symfony/security-core/Exception/LogoutException.php  fh  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  fh  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  fh  .'      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php	  fh	  qHV      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  fh  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  fh  h	      ;   vendor/symfony/security-core/Exception/RuntimeException.php  fh  >
      <   vendor/symfony/security-core/Exception/DisabledException.phpv  fhv  Ϥֽ      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  fh  (      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  fh  R      F   vendor/symfony/security-core/Exception/SessionUnavailableException.phpz  fhz  {Y      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  fh  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  fh  O
      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpG  fhG  %.D      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php}  fh}  j      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  fh  m	      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  fh  t%      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  fhJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.php  fh  c%      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  fh  *
      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.php&  fh&  [d      :   vendor/symfony/security-core/Exception/LockedException.phpl  fhl  0믤      B   vendor/symfony/security-core/Exception/AuthenticationException.php+  fh+  l      @   vendor/symfony/security-core/Exception/UserNotFoundException.php@  fh@  򼓤      U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  fh  bb      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  fh  8h      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.phpb  fhb  ߤ7	      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php   fh   iƤ      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php	  fh	  l	      J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php4  fh4  g      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  fh  %N      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  fh  
5Lq      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpm  fhm  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  fh  .      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.php1	  fh1	  =N*ݤ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php  fh  z      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php`  fh`  J      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.phpw  fhw  4
      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php  fh        P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php'  fh'  =      M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  fh	  -Lu      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  fh  Ij       Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  fh  Ҥ      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  fh  ܪ      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  fhu        :   vendor/symfony/security-core/Event/AuthenticationEvent.php  fh  :7x      0   vendor/symfony/security-core/Event/VoteEvent.php-  fh-        *   vendor/symfony/security-core/composer.json  fh  x4      5   vendor/symfony/security-core/AuthenticationEvents.php  fh  "a䚤      ,   vendor/symfony/deprecation-contracts/LICENSE,  fh,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   fh   h{#      1   vendor/symfony/deprecation-contracts/function.php  fh  Oݤ      .   vendor/symfony/deprecation-contracts/README.md  fh  X      2   vendor/symfony/deprecation-contracts/composer.jsonS  fhS  No      (   vendor/symfony/routing/CompiledRoute.php6  fh6  k栤      *   vendor/symfony/routing/Attribute/Route.php  fh  MT|         vendor/symfony/routing/LICENSE,  fh,  U      (   vendor/symfony/routing/RouteCompiler.php8  fh8  u      #   vendor/symfony/routing/CHANGELOG.md6  fh6  V^      )   vendor/symfony/routing/RequestContext.php`  fh`  )-ͤ      +   vendor/symfony/routing/Annotation/Route.php  fh  m\      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php+  fh+  <      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  fh  ~      -   vendor/symfony/routing/Matcher/UrlMatcher.php'  fh'  #Ф      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.phpo  fho  0
H      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  fh  P-2Ȥ      5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  fh  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.phpJ  fhJ  @      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.phpJ  fhJ   3I      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php  fh  \Pܤ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.phpg  fhg  xI{$      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php  fh  kR      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  fh  ˥      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php<  fh<  ðKʤ          vendor/symfony/routing/README.md  fh  rɤ      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  fh
  XA~      1   vendor/symfony/routing/Generator/UrlGenerator.php;  fh;  Yn'      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  fh  dfФ      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  fh
  Y3
8      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.phpi  fhi  fE      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  fh        ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php$  fh$  αh      *   vendor/symfony/routing/RouteCollection.phpO+  fhO+  u      6   vendor/symfony/routing/Requirement/EnumRequirement.php  fh        2   vendor/symfony/routing/Requirement/Requirement.phpR  fhR  1$      7   vendor/symfony/routing/RequestContextAwareInterface.php6  fh6  t      7   vendor/symfony/routing/Loader/AnnotationClassLoader.php  fh  tD0      :   vendor/symfony/routing/Loader/AttributeDirectoryLoader.php  fh  Tst      5   vendor/symfony/routing/Loader/AttributeFileLoader.php  fh  MKI      0   vendor/symfony/routing/Loader/YamlFileLoader.php/  fh/  14%      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php  fh        <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd9  fh9  *#      /   vendor/symfony/routing/Loader/PhpFileLoader.php  fh  @      5   vendor/symfony/routing/Loader/Psr4DirectoryLoader.php  fh  *>      /   vendor/symfony/routing/Loader/XmlFileLoader.phpF  fhF  =k      .   vendor/symfony/routing/Loader/ObjectLoader.phpq  fhq  !v|      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php!  fh!        A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php
  fh
  (      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php3
  fh3
  }2       @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php9  fh9  ,s      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.phpS  fhS  Ӥ      @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  fh  {      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  fh  ֠P      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  fh        B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  fh  a      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  fh  O      6   vendor/symfony/routing/Loader/AttributeClassLoader.php>  fh>  K      1   vendor/symfony/routing/Loader/ContainerLoader.php  fh  :      1   vendor/symfony/routing/Loader/DirectoryLoader.php  fh  ]/      0   vendor/symfony/routing/Loader/GlobFileLoader.php  fh  .]      /   vendor/symfony/routing/Loader/ClosureLoader.php  fh  
       ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php  fh  7
h          vendor/symfony/routing/Route.php/  fh/  _      *   vendor/symfony/routing/RouterInterface.php"  fh"  WF      !   vendor/symfony/routing/Router.phpt/  fht/  -X      1   vendor/symfony/routing/RouteCompilerInterface.php  fh  T          vendor/symfony/routing/Alias.php	  fh	  ä      Q   vendor/symfony/routing/DependencyInjection/AddExpressionLanguageProvidersPass.php  fh  Tw      B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php"  fh"  K˶      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  fh2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  fh  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  fh  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  fh  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.phpC  fhC  jYKФ      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  fh  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpp  fhp  .ִ      =   vendor/symfony/routing/Exception/NoConfigurationException.php  fh  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  fh>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  fh  !N      $   vendor/symfony/routing/composer.jsony  fhy  P      ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php
  fh
  }uP      ?   vendor/symfony/service-contracts/ServiceCollectionInterface.php  fh  }V      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php  fh  i      7   vendor/symfony/service-contracts/Attribute/Required.php  fh  `e      (   vendor/symfony/service-contracts/LICENSE,  fh,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.phpI  fhI  RisY      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  fh  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   fh   h{#      *   vendor/symfony/service-contracts/README.mdJ  fhJ  Г      3   vendor/symfony/service-contracts/ResetInterface.php  fh  B4      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  fh  B쯇      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php(
  fh(
        B   vendor/symfony/service-contracts/ServiceMethodsSubscriberTrait.php>  fh>  ۳N      8   vendor/symfony/service-contracts/ServiceLocatorTrait.phpG  fhG  m:      .   vendor/symfony/service-contracts/composer.json  fh  0_      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  fh  r      2   vendor/symfony/property-info/PhpStan/NameScope.php  fh  d)ݤ      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  fh  U-R      %   vendor/symfony/property-info/Type.php  fh  1ɤ      $   vendor/symfony/property-info/LICENSE,  fh,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php  fh  0Ƥ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php#  fh#  >       )   vendor/symfony/property-info/CHANGELOG.md  fh  .      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.phpE  fhE  ؍      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  fh  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  fh  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  fhQ        1   vendor/symfony/property-info/PropertyReadInfo.php  fh  
      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php.  fh.  G      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  fh        ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  fh  -U      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  fh  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php  fh        :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php&0  fh&0  VŤ      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php   fh   
8      2   vendor/symfony/property-info/PropertyWriteInfo.php  fh  C      &   vendor/symfony/property-info/README.md  fh  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  fh  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  fh  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php  fh  yh      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  fh  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.phpY  fhY  [c      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php)  fh)         *   vendor/symfony/property-info/composer.json  fh  j      3   vendor/symfony/http-foundation/StreamedResponse.php  fh  <      :   vendor/symfony/http-foundation/RequestMatcherInterface.php|  fh|  3Q      5   vendor/symfony/http-foundation/BinaryFileResponse.php2  fh2  y      +   vendor/symfony/http-foundation/InputBag.php7  fh7  sĤ      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php	  fh	  -3      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  fh
  ¤      R   vendor/symfony/http-foundation/RateLimiter/PeekableRequestRateLimiterInterface.php  fh  U      &   vendor/symfony/http-foundation/LICENSE,  fh,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.phpL  fhL  f_      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.phpJ  fhJ  Z^      M   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderLocationSame.php  fh  U      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.php  fh  I[x`      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php.  fh.  P      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.phpE  fhE  K¤      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php,  fh,        D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php<  fh<  &      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  fh  '`7      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.php  fh  ^)      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php  fh  <پJ      ,   vendor/symfony/http-foundation/ServerBag.php  fh        +   vendor/symfony/http-foundation/CHANGELOG.mduL  fhuL  M      ,   vendor/symfony/http-foundation/File/File.php  fh  ޯԤ      .   vendor/symfony/http-foundation/File/Stream.php  fh  x      4   vendor/symfony/http-foundation/File/UploadedFile.php^'  fh^'  b[      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  fhi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  fh  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  fh  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  fh  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  fh  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  fh  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  fh  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php9  fh9  d-      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  fh  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  fhY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  fh  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  fh  n      +   vendor/symfony/http-foundation/Response.php  fh  u      )   vendor/symfony/http-foundation/Cookie.phpJ/  fhJ/  "f      /   vendor/symfony/http-foundation/AcceptHeader.php{
  fh{
  G      1   vendor/symfony/http-foundation/RequestMatcher.php  fh  յnҤ      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  fh  4֭      .   vendor/symfony/http-foundation/HeaderUtils.php$  fh$  4      F   vendor/symfony/http-foundation/RequestMatcher/MethodRequestMatcher.php>  fh>        D   vendor/symfony/http-foundation/RequestMatcher/PathRequestMatcher.phpd  fhd  w|      F   vendor/symfony/http-foundation/RequestMatcher/IsJsonRequestMatcher.php  fh  TK      D   vendor/symfony/http-foundation/RequestMatcher/PortRequestMatcher.php  fh  2      D   vendor/symfony/http-foundation/RequestMatcher/HostRequestMatcher.phpR  fhR  s      J   vendor/symfony/http-foundation/RequestMatcher/AttributesRequestMatcher.php  fh  d      J   vendor/symfony/http-foundation/RequestMatcher/ExpressionRequestMatcher.php  fh  Q̤      F   vendor/symfony/http-foundation/RequestMatcher/SchemeRequestMatcher.php,  fh,  s>M      C   vendor/symfony/http-foundation/RequestMatcher/IpsRequestMatcher.php2  fh2  ti      /   vendor/symfony/http-foundation/RequestStack.php  fh   J      3   vendor/symfony/http-foundation/RedirectResponse.php9
  fh9
  V      /   vendor/symfony/http-foundation/JsonResponse.phpj  fhj  OP/      (   vendor/symfony/http-foundation/README.md  fh  &      *   vendor/symfony/http-foundation/Request.php fh kaФ      ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  fh  |*      /   vendor/symfony/http-foundation/ParameterBag.php  fh  6      *   vendor/symfony/http-foundation/IpUtils.php   fh   6      3   vendor/symfony/http-foundation/AcceptHeaderItem.php  fh  :6      7   vendor/symfony/http-foundation/StreamedJsonResponse.php  fh  ؕSҤ      ,   vendor/symfony/http-foundation/UrlHelper.phpq  fhq  `Kl      6   vendor/symfony/http-foundation/ChainRequestMatcher.phpx  fhx  X!      ,   vendor/symfony/http-foundation/HeaderBag.php  fh  ZdL      *   vendor/symfony/http-foundation/FileBag.php  fh  "4Ϥ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  fh  ,Ň      E   vendor/symfony/http-foundation/Exception/UnexpectedValueException.phpx  fhx   ȕ      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  fh  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  fh  Uڤ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  fh  '      :   vendor/symfony/http-foundation/Exception/JsonException.php  fh        E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  fhY  1      ,   vendor/symfony/http-foundation/composer.jsonv  fhv  ^D      ,   vendor/symfony/http-foundation/UriSigner.php!
  fh!
         J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  fh  Gf=      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php
  fh
        H   vendor/symfony/http-foundation/Session/FlashBagAwareSessionInterface.php4  fh4        B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  fh  f*      2   vendor/symfony/http-foundation/Session/Session.php  fh  <)      7   vendor/symfony/http-foundation/Session/SessionUtils.php  fh  '      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  fh  r@      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php  fh  դ      P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php)  fh)  o      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  fh  AS      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.php~  fh~  |%      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  fh  wb      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.php  fh  Dt|      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  fh  Gҭq      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.phpG  fhG  $      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  fh  G      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php	  fh	  mI      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.php  fh  oڤ      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php7  fh7  tJ      J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php/  fh/  {      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  fh  YPZ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpB	  fhB	        F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php  fh  <      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php!  fh!  	      J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  fh  f      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  fhw  ]n      I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  fh  *8      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  fh  ɤ      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php
  fh
        J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php	  fh	  Q3U      ;   vendor/symfony/http-foundation/Session/SessionInterface.php  fh  OY>      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php  fh  Ԗޤ      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.php  fh  u1Ф      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php	  fh	  vɅ      9   vendor/symfony/http-foundation/Session/SessionFactory.phpG  fhG  
      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php  fh  
      >   vendor/symfony/http-foundation/Session/SessionBagInterface.phpW  fhW  #9      ,   vendor/symfony/var-exporter/Instantiator.php	  fh	  
      +   vendor/symfony/var-exporter/ProxyHelper.php_  fh_  )      #   vendor/symfony/var-exporter/LICENSE,  fh,        (   vendor/symfony/var-exporter/CHANGELOG.md  fh  t?      (   vendor/symfony/var-exporter/Hydrator.php  fh  Lф      8   vendor/symfony/var-exporter/Internal/LazyObjectState.php(  fh(  P      ;   vendor/symfony/var-exporter/Internal/LazyObjectRegistry.phpT  fhT  x      /   vendor/symfony/var-exporter/Internal/Values.php  fh  `ǿ      8   vendor/symfony/var-exporter/Internal/LazyObjectTrait.php)  fh)  ;ޣ      1   vendor/symfony/var-exporter/Internal/Hydrator.php.  fh.         1   vendor/symfony/var-exporter/Internal/Registry.php@  fh@  #      2   vendor/symfony/var-exporter/Internal/Reference.php
  fh
  #Jn      1   vendor/symfony/var-exporter/Internal/Exporter.phpsA  fhsA  Kk#      .   vendor/symfony/var-exporter/LazyGhostTrait.php;  fh;  Y      %   vendor/symfony/var-exporter/README.md-  fh-  "      .   vendor/symfony/var-exporter/LazyProxyTrait.php2  fh2  jˤ      +   vendor/symfony/var-exporter/VarExporter.phpR  fhR  eH      3   vendor/symfony/var-exporter/LazyObjectInterface.phpa  fha  @#      8   vendor/symfony/var-exporter/Exception/LogicException.php  fh  -ʤ      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  fhd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  fh1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  fh>  }      )   vendor/symfony/var-exporter/composer.jsonr  fhr  ~j      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  fh	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.phpR  fhR        M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php*  fh*  ^z      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  fh  1'      $   vendor/symfony/error-handler/LICENSE,  fh,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md  fh  D9      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  fh
  d"m      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   fh   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php/  fh/        <   vendor/symfony/error-handler/Resources/views/traces.html.php
  fh
  n       A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  fh  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  fh)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.php`  fh`  39      ;   vendor/symfony/error-handler/Resources/views/error.html.phpd  fhd  x      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  fh  Eޤ      ?   vendor/symfony/error-handler/Resources/assets/css/exception.css	B  fh	B  R      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  fh
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  fh  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  fhQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  fh        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  fhz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  fh        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   fh   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  fh  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  fh  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  fh	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  fh  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  fh  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  fh  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  fh4  C#      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  fh        &   vendor/symfony/error-handler/Debug.phps  fhs  4\H      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php
  fh
  <      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  fh  
+2      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  fh  sۤ      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php'^  fh'^  ZO      @   vendor/symfony/error-handler/ErrorRenderer/FileLinkFormatter.phpP  fhP  Y      &   vendor/symfony/error-handler/README.md=  fh=  \      1   vendor/symfony/error-handler/DebugClassLoader.phpT  fhT  *W>      0   vendor/symfony/error-handler/BufferingLogger.phpA  fhA  Z      -   vendor/symfony/error-handler/ErrorHandler.phppk  fhpk  l_      /   vendor/symfony/error-handler/ThrowableUtils.php{  fh{  -F      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  fh[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php  fh  V[      1   vendor/symfony/error-handler/Error/FatalError.php
  fh
  Ff      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php  fh  lnB      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php  fh  Ep      ;   vendor/symfony/error-handler/Exception/FlattenException.phpI.  fhI.  ޱњ      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.phpr  fhr  +      *   vendor/symfony/error-handler/composer.json  fh  ny&      4   vendor/symfony/cache-contracts/CallbackInterface.php]  fh]  oW$      0   vendor/symfony/cache-contracts/ItemInterface.php6  fh6  #
      &   vendor/symfony/cache-contracts/LICENSE,  fh,        +   vendor/symfony/cache-contracts/CHANGELOG.md   fh   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php2	  fh2	  5      :   vendor/symfony/cache-contracts/NamespacedPoolInterface.php  fh  N      (   vendor/symfony/cache-contracts/README.mdF  fhF  _      -   vendor/symfony/cache-contracts/CacheTrait.php	  fh	  iW      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php  fh  1swc      ,   vendor/symfony/cache-contracts/composer.json  fh  /      7   vendor/symfony/dependency-injection/EnvVarProcessor.php2  fh2  sF      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpO  fhO  4rS      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php\  fh\  lD      1   vendor/symfony/dependency-injection/Container.php6  fh6  S      8   vendor/symfony/dependency-injection/ReverseContainer.php	  fh	  4)Ȥ      0   vendor/symfony/dependency-injection/Variable.php  fh  hp      P   vendor/symfony/dependency-injection/Extension/ConfigurableExtensionInterface.php#  fh#  ᅋ~      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php`  fh`  ^
N      C   vendor/symfony/dependency-injection/Extension/AbstractExtension.php  fh  W$      @   vendor/symfony/dependency-injection/Extension/ExtensionTrait.php  fh  V      ;   vendor/symfony/dependency-injection/Extension/Extension.php  fh  0B      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.phpS  fhS  NC6      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  fhS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php  fh  ZӤ      B   vendor/symfony/dependency-injection/Attribute/AutowireIterator.php  fh  o      =   vendor/symfony/dependency-injection/Attribute/AsDecorator.phpo  fho  Y|      H   vendor/symfony/dependency-injection/Attribute/AutowireServiceClosure.php  fh  ^#5      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  fh  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  fh  A      6   vendor/symfony/dependency-injection/Attribute/When.php  fh  Xˤ      C   vendor/symfony/dependency-injection/Attribute/AutowireDecorated.php  fh  +h      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php  fh  u      A   vendor/symfony/dependency-injection/Attribute/AutowireLocator.phpe
  fhe
        B   vendor/symfony/dependency-injection/Attribute/AutowireCallable.phpT  fhT  鼎`      :   vendor/symfony/dependency-injection/Attribute/Autowire.php]
  fh]
  sO      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  fh  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php  fh  鱞      >   vendor/symfony/dependency-injection/Attribute/MapDecorated.phpb  fhb  \      9   vendor/symfony/dependency-injection/Attribute/Exclude.php  fh  a)      9   vendor/symfony/dependency-injection/Attribute/AsAlias.php  fh        +   vendor/symfony/dependency-injection/LICENSE,  fh,  U      0   vendor/symfony/dependency-injection/CHANGELOG.mdhI  fhhI  Z[      Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.php)  fh)  }~      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  fh  5      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.php	  fh	  /      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  fh  1i      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  fh  s      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.php  fh  /c=      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  fh  >))      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php6  fh6  2Ҥ      <   vendor/symfony/dependency-injection/Argument/LazyClosure.php=
  fh=
  EK      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.phpu
  fhu
        B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpN  fhN        ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php#  fh#  ěs@      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php*  fh*  k      8   vendor/symfony/dependency-injection/ContainerBuilder.php  fh  ܉      7   vendor/symfony/dependency-injection/ChildDefinition.phpp
  fhp
  /o      1   vendor/symfony/dependency-injection/Reference.php  fh  ͯ      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php	  fh	  U]      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php  fh  !      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php$  fh$  AҤ      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php  fh        A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  fh  #O      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php  fh  0P      2   vendor/symfony/dependency-injection/Definition.phpP  fhP  D      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  fh  90      -   vendor/symfony/dependency-injection/README.mdC  fhC  <      :   vendor/symfony/dependency-injection/ContainerInterface.phpd	  fhd	  ʤ      9   vendor/symfony/dependency-injection/Loader/FileLoader.php<  fh<  (٤      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php  fh  ȶ_      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdB  fhB  o      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.php!  fh!  g      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  fh  Thm      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  fh  j}      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php4  fh4  g      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php9	  fh9	  Ca      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  fh  w      T   vendor/symfony/dependency-injection/Loader/Configurator/FromCallableConfigurator.php  fh  6n      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php1  fh1  D      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpN  fhN  X_^      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  fh  .      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpl  fhl  
s_      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  fh  
      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  fh  M      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  fh  (      O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.phpd  fhd  'D      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  fh  p       N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  fh        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.php{  fh{  2Ѥ      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpE  fhE  ^7      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FromCallableTrait.php	  fh	  \      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpb  fhb  *'Ѥ      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.php[  fh[  Bf      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.phpD  fhD  5R      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpG  fhG  F8      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  fh  ge      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpL  fhL  b      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpM  fhM  P      S   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConstructorTrait.phpU  fhU  86$      P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  fh  ԏ)      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  fh  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.phpj  fhj        W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  fh  fۤ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  fh  !R      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  fh  4      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  fh  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.phpR  fhR  <      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  fh
  o      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  fh  "      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php  fh  A[_v      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.php2  fh2  	      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php`  fh`        <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  fh  5      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php  fh  Ğ}      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  fh  5=      M   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/LazyServiceDumper.php  fh  p<      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  fh  vOΤ      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/LazyServiceInstantiator.php  fh  (d      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.phpd  fhd  翓      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.php~  fh~  0ND      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpb  fhb  !UO      6   vendor/symfony/dependency-injection/ServiceLocator.php  fh  9x"D      6   vendor/symfony/dependency-injection/TypedReference.php3  fh3  adt      -   vendor/symfony/dependency-injection/Alias.php  fh  nZԤ      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  fh  t9      @   vendor/symfony/dependency-injection/Exception/LogicException.php  fh  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  fh  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.php"  fh"  
      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  fh~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  fh  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php_  fh_  Ke&      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php  fh  Ф      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  fh	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  fh'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  fh  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  fh  M      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  fh0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  fh  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  fh  J.      1   vendor/symfony/dependency-injection/Parameter.phpf  fhf  sD      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  fh  'f      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.php  fh  ]      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  fh        M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php@  fh@  p脤      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  fh        L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php!  fh!  gPK      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.phpm  fhm  1&      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php
  fh
  j      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpK  fhK  7ɤ      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php  fh        J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  fh1  W       M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php  fh  m      H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php   fh   %d      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php$*  fh$*  
B      H   vendor/symfony/dependency-injection/Compiler/AutowireAsDecoratorPass.php  fh  3      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  fh  v3      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php  fh  QY      F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php8*  fh8*  c3      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php  fh  Hl      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.php8  fh8  y      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  fh  cW      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.php3  fh3  췤      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  fh  1x      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php-
  fh-
  zh      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php'  fh'  $      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.php  fh  XB      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.php!  fh!  ?      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.phpi  fhi  ^n      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.php
  fh
  B      L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.php  fh  xp      =   vendor/symfony/dependency-injection/Compiler/AutowirePass.php8{  fh8{  an+      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.php  fh  J      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.phpq  fhq  ?      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.php  fh  ]      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php  fh  uV      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  fh  Lפ      J   vendor/symfony/dependency-injection/Compiler/RemoveBuildParametersPass.php  fh  vg      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  fh  zp
      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  fh  F0      A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php]  fh]  v`      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  fh  Q      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php6  fh6  YB      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  fh  a%      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php<	  fh<	  sY[      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  fh  lD      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  fh  ٭v      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  fh  &      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.phpa  fha  p6      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.php&  fh&  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  fh
  ˤ      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  fh        M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  fh  ^0      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  fh  `#{      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php#  fh#  sO      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.php	9  fh	9  I)%      8   vendor/symfony/dependency-injection/Dumper/Preloader.php  fh  v{      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.phpH  fhH  ]߸      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpV  fhV  s#      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  fh  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.php` fh`       1   vendor/symfony/dependency-injection/composer.json  fh  X~      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  fh  bkr      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php  fh  =>         vendor/symfony/clock/LICENSE,  fh,  t=      1   vendor/symfony/clock/Test/ClockSensitiveTrait.php  fh  I      !   vendor/symfony/clock/CHANGELOG.md  fh  CJ      &   vendor/symfony/clock/Resources/now.php  fh  5䏤      (   vendor/symfony/clock/ClockAwareTrait.php  fh  3         vendor/symfony/clock/README.md  fh  I      "   vendor/symfony/clock/MockClock.php  fh  $i         vendor/symfony/clock/Clock.phpS	  fhS	  *R'      '   vendor/symfony/clock/MonotonicClock.php
  fh
  }Z      '   vendor/symfony/clock/ClockInterface.phpL  fhL  z֚&      "   vendor/symfony/clock/DatePoint.php  fh  Ф      "   vendor/symfony/clock/composer.json  fh  GPҤ      $   vendor/symfony/clock/NativeClock.php/  fh/  ur+      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  fh  -<      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  fh  ^~      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.php  fh  B+.      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.phpK  fhK  r,Ф      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  fh  S8      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  fh  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  fh  Q      E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php 
  fh 
  r6k      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.phpr  fhr  4Τ      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php[	  fh[	        H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php  fh  @      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.php  fh  rG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php&!  fh&!  FA      &   vendor/symfony/password-hasher/LICENSE,  fh,  U      +   vendor/symfony/password-hasher/CHANGELOG.md   fh   ڰ      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.php  fh  t      (   vendor/symfony/password-hasher/README.md  fh  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php'  fh'  8      ;   vendor/symfony/password-hasher/Exception/LogicException.php  fh  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  fh  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  fh  L      ,   vendor/symfony/password-hasher/composer.json  fh           vendor/symfony/process/LICENSE,  fh,  U      +   vendor/symfony/process/ExecutableFinder.php
  fh
  wt      #   vendor/symfony/process/CHANGELOG.md  fh   %8          vendor/symfony/process/README.md  fh  \3$Ϥ      *   vendor/symfony/process/Pipes/UnixPipes.php  fh  6      -   vendor/symfony/process/Pipes/WindowsPipes.php  fh  Q      .   vendor/symfony/process/Pipes/AbstractPipes.php  fh  p      /   vendor/symfony/process/Pipes/PipesInterface.php  fh        &   vendor/symfony/process/InputStream.php	  fh	  6ee      6   vendor/symfony/process/Messenger/RunProcessContext.php|  fh|  ɔ      6   vendor/symfony/process/Messenger/RunProcessMessage.php  fh  2$      =   vendor/symfony/process/Messenger/RunProcessMessageHandler.php%  fh%  0      %   vendor/symfony/process/PhpProcess.php	  fh	  3x      (   vendor/symfony/process/PhpSubprocess.php  fh  :1      .   vendor/symfony/process/PhpExecutableFinder.php%	  fh%	  ޏx      =   vendor/symfony/process/Exception/ProcessSignaledException.php  fh  -n_      3   vendor/symfony/process/Exception/LogicException.php  fh  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  fh  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpp  fhp   ۋ      5   vendor/symfony/process/Exception/RuntimeException.php  fh  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.php  fh  8^Q      =   vendor/symfony/process/Exception/InvalidArgumentException.php  fh  ڴ      >   vendor/symfony/process/Exception/RunProcessFailedException.php  fh  ؤ      $   vendor/symfony/process/composer.json  fh  S.t      '   vendor/symfony/process/ProcessUtils.php  fh  a鍤      "   vendor/symfony/process/Process.php  fh  8      =   vendor/symfony/console/DataCollector/CommandDataCollector.php  fh  &      (   vendor/symfony/console/ConsoleEvents.php  fh  .
      !   vendor/symfony/console/Cursor.php  fh  \Fä      &   vendor/symfony/console/Application.php  fh  U"      /   vendor/symfony/console/Logger/ConsoleLogger.phpY  fhY  Ġ      .   vendor/symfony/console/Attribute/AsCommand.phpJ  fhJ  c         vendor/symfony/console/LICENSE,  fh,  U      #   vendor/symfony/console/CHANGELOG.md)  fh)   b_e      9   vendor/symfony/console/Input/StreamableInputInterface.php  fh  3y-      +   vendor/symfony/console/Input/ArrayInput.phpH  fhH  ůx      *   vendor/symfony/console/Input/ArgvInput.php0  fh0  #      .   vendor/symfony/console/Input/InputArgument.php:  fh:  bŮ      4   vendor/symfony/console/Input/InputAwareInterface.phpc  fhc  Q      ,   vendor/symfony/console/Input/InputOption.php!  fh!  <      0   vendor/symfony/console/Input/InputDefinition.phpU.  fhU.  )ͤ      ,   vendor/symfony/console/Input/StringInput.php
  fh
  G      &   vendor/symfony/console/Input/Input.phpl  fhl  ;      /   vendor/symfony/console/Input/InputInterface.php|  fh|  kx'      #   vendor/symfony/console/Terminal.php  fh  `HN      2   vendor/symfony/console/CI/GithubActionReporter.php+  fh+  @      0   vendor/symfony/console/Resources/completion.bash  fh  %}      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  fh $  v      /   vendor/symfony/console/Resources/completion.zsh  fh  ʤ      0   vendor/symfony/console/Resources/completion.fish  fh  Keդ      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpY  fhY  G>d      8   vendor/symfony/console/Output/ConsoleOutputInterface.php=  fh=  B:      0   vendor/symfony/console/Output/BufferedOutput.phpQ  fhQ  *AS      1   vendor/symfony/console/Output/OutputInterface.php6  fh6  j8q      /   vendor/symfony/console/Output/AnsiColorMode.php
  fh
  oi+      (   vendor/symfony/console/Output/Output.php  fh  \Τ      6   vendor/symfony/console/Output/ConsoleSectionOutput.php9!  fh9!         /   vendor/symfony/console/Output/ConsoleOutput.php  fh  :*      ,   vendor/symfony/console/Output/NullOutput.phpO  fhO  p       .   vendor/symfony/console/Output/StreamOutput.php  fh  +%ؤ      A   vendor/symfony/console/Completion/Output/FishCompletionOutput.php  fh  `      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  fh	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  fh  :]      @   vendor/symfony/console/Completion/Output/ZshCompletionOutput.php1  fh1        0   vendor/symfony/console/Completion/Suggestion.php7  fh7  /)	Ϥ      ;   vendor/symfony/console/Completion/CompletionSuggestions.php^  fh^  lx      5   vendor/symfony/console/Completion/CompletionInput.php   fh   jfO      ,   vendor/symfony/console/Style/OutputStyle.php  fh  Vy      -   vendor/symfony/console/Style/SymfonyStyle.php;  fh;  
&ˤ      /   vendor/symfony/console/Style/StyleInterface.php
  fh
  .      2   vendor/symfony/console/Question/ChoiceQuestion.php1  fh1  JY      ,   vendor/symfony/console/Question/Question.php>  fh>  upq      8   vendor/symfony/console/Question/ConfirmationQuestion.php,  fh,  %          vendor/symfony/console/README.md  fh  Æf      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  fh  yM      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.php  fh  ǡ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.phpl  fhl        =   vendor/symfony/console/Formatter/OutputFormatterInterface.php"  fh"  7V6_      4   vendor/symfony/console/Formatter/OutputFormatter.php"  fh"  )      8   vendor/symfony/console/Formatter/NullOutputFormatter.php  fh  B[      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  fh  *
      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php?
  fh?
  :;      6   vendor/symfony/console/Messenger/RunCommandMessage.php  fh  
M      6   vendor/symfony/console/Messenger/RunCommandContext.php  fh  !B      =   vendor/symfony/console/Messenger/RunCommandMessageHandler.php  fh  F          vendor/symfony/console/Color.php(  fh(  -      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php  fh  G,eͤ      3   vendor/symfony/console/SignalRegistry/SignalMap.php  fh  N+QѤ      3   vendor/symfony/console/SingleCommandApplication.php>  fh>  OA      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpV  fhV  X2      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php  fh  ƒ      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.phpK  fhK  <      4   vendor/symfony/console/Descriptor/TextDescriptor.php0  fh0  f      <   vendor/symfony/console/Descriptor/ApplicationDescription.php(  fh(  #1      3   vendor/symfony/console/Descriptor/XmlDescriptor.php&  fh&  ,Eb      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpm  fhm  B      0   vendor/symfony/console/Descriptor/Descriptor.php
  fh
  j      @   vendor/symfony/console/Descriptor/ReStructuredTextDescriptor.php')  fh')  Ǿ4      4   vendor/symfony/console/Descriptor/JsonDescriptor.php]  fh]  r"z      8   vendor/symfony/console/Descriptor/MarkdownDescriptor.php  fh  4Qj      /   vendor/symfony/console/Tester/CommandTester.phpL	  fhL	  5Ykؤ      -   vendor/symfony/console/Tester/TesterTrait.php  fh  OJl      3   vendor/symfony/console/Tester/ApplicationTester.php
  fh
  Z3      9   vendor/symfony/console/Tester/CommandCompletionTester.phpD  fhD  T      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php+  fh+  1      3   vendor/symfony/console/Command/TraceableCommand.phpe(  fhe(  -2`      .   vendor/symfony/console/Command/LazyCommand.php  fh  oͤ      0   vendor/symfony/console/Command/LockableTrait.php3  fh3        .   vendor/symfony/console/Command/HelpCommand.php	  fh	  6_3      2   vendor/symfony/console/Command/CompleteCommand.php#  fh#  sJ!      .   vendor/symfony/console/Command/ListCommand.php	  fh	  e\{      8   vendor/symfony/console/Command/DumpCompletionCommand.php  fh  +CQ      =   vendor/symfony/console/Command/SignalableCommandInterface.phpE  fhE  bO      *   vendor/symfony/console/Command/Command.php!Z  fh!Z  a 啤      ,   vendor/symfony/console/Helper/TableStyle.php!1  fh!1  'p,      +   vendor/symfony/console/Helper/TableRows.php[  fh[  {m֤      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php)
  fh)
  7N      1   vendor/symfony/console/Helper/HelperInterface.phpV  fhV  ̊      +   vendor/symfony/console/Helper/TableCell.php  fh  e9S      /   vendor/symfony/console/Helper/ProcessHelper.php  fh  e      0   vendor/symfony/console/Helper/TableSeparator.php!  fh!  n2      /   vendor/symfony/console/Helper/OutputWrapper.php  fh  lؤ      1   vendor/symfony/console/Helper/FormatterHelper.php  fh  0ɤ      0   vendor/symfony/console/Helper/TableCellStyle.php)  fh)  KӘ      -   vendor/symfony/console/Helper/ProgressBar.phpKN  fhKN  F@{      6   vendor/symfony/console/Helper/DebugFormatterHelper.php

  fh

  &      +   vendor/symfony/console/Helper/HelperSet.phpc  fhc  V.      (   vendor/symfony/console/Helper/Dumper.phpz  fhz  `      2   vendor/symfony/console/Helper/InputAwareHelper.php  fh  pc      0   vendor/symfony/console/Helper/QuestionHelper.phpL  fhL        (   vendor/symfony/console/Helper/Helper.phpl  fhl  5      '   vendor/symfony/console/Helper/Table.php  fh  C2Ӷ      3   vendor/symfony/console/Helper/ProgressIndicator.php  fh  bN&      2   vendor/symfony/console/Helper/DescriptorHelper.phpd
  fhd
        D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  fh  4      3   vendor/symfony/console/Exception/LogicException.php  fh  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  fh  %:      >   vendor/symfony/console/Exception/RunCommandFailedException.php>  fh>  ~      7   vendor/symfony/console/Exception/ExceptionInterface.php  fh  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  fh        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  fh  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  fh  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  fh  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  fh  ͆Ť      6   vendor/symfony/console/Event/ConsoleTerminateEvent.php  fh  [5Ť      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  fh  z      4   vendor/symfony/console/Event/ConsoleCommandEvent.php>  fh>  y      -   vendor/symfony/console/Event/ConsoleEvent.php  fh  8(M      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  fh  =|Ѯ      $   vendor/symfony/console/composer.jsonH  fhH  +      +   vendor/symfony/console/Debug/CliRequest.phpq  fhq  ekX      6   vendor/symfony/console/EventListener/ErrorListener.php  fh  h
      0   vendor/symfony/polyfill-mbstring/bootstrap80.php'  fh'  	~
      (   vendor/symfony/polyfill-mbstring/LICENSE,  fh,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  fh  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  fhU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  fh  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  fhO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.php  fh        .   vendor/symfony/polyfill-mbstring/bootstrap.php!  fh!  d      *   vendor/symfony/polyfill-mbstring/README.mdr  fhr  A`      .   vendor/symfony/polyfill-mbstring/composer.jsonR  fhR  `P
      5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpR  fhR  i`      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  fh,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.phpt)  fht)  Qm      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.phpY	  fhY	  IH1      /   vendor/symfony/polyfill-intl-grapheme/README.md  fh  6      3   vendor/symfony/polyfill-intl-grapheme/composer.json   fh   +          vendor/ramsey/collection/LICENSE7  fh7  ŸԤ      "   vendor/ramsey/collection/README.md  fh  3 Ӥ      &   vendor/ramsey/collection/composer.json|  fh|   v֤      $   vendor/ramsey/collection/SECURITY.md  fh        1   vendor/ramsey/collection/src/DoubleEndedQueue.php  fh  e      ,   vendor/ramsey/collection/src/AbstractSet.php  fh  <!      /   vendor/ramsey/collection/src/QueueInterface.php  fh  *      3   vendor/ramsey/collection/src/AbstractCollection.phpa+  fha+  d?      .   vendor/ramsey/collection/src/AbstractArray.php  fh  z P      &   vendor/ramsey/collection/src/Queue.php3  fh3  D      $   vendor/ramsey/collection/src/Set.php0  fh0  H      :   vendor/ramsey/collection/src/DoubleEndedQueueInterface.php(  fh(  6'&      6   vendor/ramsey/collection/src/Map/TypedMapInterface.php2  fh2  z      5   vendor/ramsey/collection/src/Map/AbstractTypedMap.phpc  fhc  cͤ      1   vendor/ramsey/collection/src/Map/MapInterface.php  fh  OA      -   vendor/ramsey/collection/src/Map/TypedMap.php
  fh
  >)      8   vendor/ramsey/collection/src/Map/AssociativeArrayMap.php0  fh0  PǤ      6   vendor/ramsey/collection/src/Map/NamedParameterMap.php   fh   `@Q      0   vendor/ramsey/collection/src/Map/AbstractMap.php  fh  I?      -   vendor/ramsey/collection/src/GenericArray.php  fh        /   vendor/ramsey/collection/src/ArrayInterface.php'  fh'  5a      %   vendor/ramsey/collection/src/Sort.php{  fh{  Ȥ      +   vendor/ramsey/collection/src/Collection.php	  fh	  0       4   vendor/ramsey/collection/src/CollectionInterface.php$  fh$  űʤ      H   vendor/ramsey/collection/src/Exception/UnsupportedOperationException.phpL  fhL  ff      ?   vendor/ramsey/collection/src/Exception/OutOfBoundsException.phpw  fhw        >   vendor/ramsey/collection/src/Exception/CollectionException.php  fh  Ĵ@      C   vendor/ramsey/collection/src/Exception/InvalidArgumentException.phps  fhs  ڤ      A   vendor/ramsey/collection/src/Exception/NoSuchElementException.phpD  fhD  	Ln      B   vendor/ramsey/collection/src/Exception/InvalidPropertyOrMethod.php  fh        F   vendor/ramsey/collection/src/Exception/CollectionMismatchException.phpM  fhM  \ć      8   vendor/ramsey/collection/src/Tool/ValueToStringTrait.php	  fh	  ;5      /   vendor/ramsey/collection/src/Tool/TypeTrait.phpD  fhD  e      9   vendor/ramsey/collection/src/Tool/ValueExtractorTrait.php  fh  q          vendor/ramsey/uuid/LICENSE7  fh7  <[         vendor/ramsey/uuid/README.md.  fh.            vendor/ramsey/uuid/composer.json  fh  8>r      $   vendor/ramsey/uuid/src/functions.php  fh  /      5   vendor/ramsey/uuid/src/Validator/GenericValidator.php)  fh)  ر      7   vendor/ramsey/uuid/src/Validator/ValidatorInterface.php  fh  L      >   vendor/ramsey/uuid/src/Converter/Time/GenericTimeConverter.php  fh  }      ;   vendor/ramsey/uuid/src/Converter/Time/UnixTimeConverter.php!
  fh!
  u:      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.phpN  fhN        ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.phpv  fhv  
פ      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.phpu  fhu  Ϫ24      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php}  fh}  Y{      >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php  fh  @      B   vendor/ramsey/uuid/src/Converter/Number/GenericNumberConverter.php  fh  6Q      ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.php  fh  )      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php  fh  uVt       5   vendor/ramsey/uuid/src/DeprecatedUuidMethodsTrait.php3  fh3  h      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php  fh  s3٩      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php
  fh
  
M      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php  fh  D8ڤ      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php  fh  ܤ      ,   vendor/ramsey/uuid/src/Codec/StringCodec.php5  fh5        7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php  fh  e8         vendor/ramsey/uuid/src/Uuid.php^  fh^  n$Ϥ      @   vendor/ramsey/uuid/src/Provider/DceSecurityProviderInterface.php  fh  jf      A   vendor/ramsey/uuid/src/Provider/Dce/SystemDceSecurityProvider.php0  fh0  M_=      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  fh  	"      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php   fh   a      :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  fh  eˤ      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.phpS  fhS  m+      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.phpo  fho  L_      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.phpw  fhw        ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php  fh  r犤      ?   vendor/ramsey/uuid/src/Provider/Node/NodeProviderCollection.phpE  fhE  7      ;   vendor/ramsey/uuid/src/Provider/Node/StaticNodeProvider.php4  fh4  ]q      %   vendor/ramsey/uuid/src/FeatureSet.php2  fh2  rI|Ф      2   vendor/ramsey/uuid/src/Rfc4122/FieldsInterface.php   fh   w      )   vendor/ramsey/uuid/src/Rfc4122/UuidV8.php	  fh	  RE      ,   vendor/ramsey/uuid/src/Rfc4122/Validator.php[  fh[  -=      +   vendor/ramsey/uuid/src/Rfc4122/MaxTrait.phpW  fhW  r`      /   vendor/ramsey/uuid/src/Rfc4122/VersionTrait.php  fh  O;      +   vendor/ramsey/uuid/src/Rfc4122/NilTrait.phpC  fhC  `ܤ      )   vendor/ramsey/uuid/src/Rfc4122/Fields.php  fh  ;      *   vendor/ramsey/uuid/src/Rfc4122/NilUuid.php  fh        *   vendor/ramsey/uuid/src/Rfc4122/MaxUuid.php  fh  oޤ      0   vendor/ramsey/uuid/src/Rfc4122/UuidInterface.php  fh  :J}      ,   vendor/ramsey/uuid/src/Rfc4122/TimeTrait.phpA  fhA  P*      /   vendor/ramsey/uuid/src/Rfc4122/VariantTrait.php!  fh!        .   vendor/ramsey/uuid/src/Rfc4122/UuidBuilder.phpy  fhy  MSZ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV1.php  fh  )]ߤ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV3.php>  fh>  H<      )   vendor/ramsey/uuid/src/Rfc4122/UuidV2.php  fh  O      )   vendor/ramsey/uuid/src/Rfc4122/UuidV6.php  fh  e`      )   vendor/ramsey/uuid/src/Rfc4122/UuidV7.php  fh  gE      )   vendor/ramsey/uuid/src/Rfc4122/UuidV5.phpC  fhC  X      )   vendor/ramsey/uuid/src/Rfc4122/UuidV4.php  fh        (   vendor/ramsey/uuid/src/UuidInterface.php  fh  s      ,   vendor/ramsey/uuid/src/Math/RoundingMode.php1  fh1  {k3      3   vendor/ramsey/uuid/src/Math/CalculatorInterface.php"  fh"  "      3   vendor/ramsey/uuid/src/Math/BrickMathCalculator.phpQ  fhQ  q      /   vendor/ramsey/uuid/src/UuidFactoryInterface.php  fh  {      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.phpU  fhU  7      9   vendor/ramsey/uuid/src/Generator/NameGeneratorFactory.php  fh  zݤ      6   vendor/ramsey/uuid/src/Generator/UnixTimeGenerator.phpF  fhF  5c      ;   vendor/ramsey/uuid/src/Generator/NameGeneratorInterface.php:  fh:  Hf      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.php  fh  ,q      9   vendor/ramsey/uuid/src/Generator/DceSecurityGenerator.php  fh  P~f      B   vendor/ramsey/uuid/src/Generator/DceSecurityGeneratorInterface.php  fh  8      9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.phpx  fhx  76i      9   vendor/ramsey/uuid/src/Generator/DefaultNameGenerator.phpU  fhU  x-      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php  fh  YO      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php7  fh7  ю      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  fh  CkO      2   vendor/ramsey/uuid/src/Generator/CombGenerator.phpZ
  fhZ
        =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  fh  Il      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.php<  fh<  18      :   vendor/ramsey/uuid/src/Generator/PeclUuidNameGenerator.php  fh  f      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.php{  fh{  Ҥ      &   vendor/ramsey/uuid/src/BinaryUtils.php%  fh%  rT      &   vendor/ramsey/uuid/src/UuidFactory.phpl<  fhl<        '   vendor/ramsey/uuid/src/Type/Integer.php7  fh7  RM      $   vendor/ramsey/uuid/src/Type/Time.php&
  fh&
        +   vendor/ramsey/uuid/src/Type/Hexadecimal.php  fh  _}^      /   vendor/ramsey/uuid/src/Type/NumberInterface.php  fh  B1      -   vendor/ramsey/uuid/src/Type/TypeInterface.php  fh  |3:A      '   vendor/ramsey/uuid/src/Type/Decimal.php  fh        $   vendor/ramsey/uuid/src/Guid/Guid.php		  fh		  M      &   vendor/ramsey/uuid/src/Guid/Fields.php   fh   8mF      +   vendor/ramsey/uuid/src/Guid/GuidBuilder.phpM	  fhM	  awߤ      2   vendor/ramsey/uuid/src/Lazy/LazyUuidFromString.php5  fh5  ȚS      '   vendor/ramsey/uuid/src/DegradedUuid.php[  fh[  ?^      1   vendor/ramsey/uuid/src/Fields/FieldsInterface.php  fh  5l      9   vendor/ramsey/uuid/src/Fields/SerializableFieldsTrait.phpz  fhz  P	      2   vendor/ramsey/uuid/src/DeprecatedUuidInterface.php  fh  >      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.phph  fhh  :2ͤ      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php$  fh$  !      4   vendor/ramsey/uuid/src/Builder/BuilderCollection.php	  fh	  =      2   vendor/ramsey/uuid/src/Builder/FallbackBuilder.phpo  fho  D+.      5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.phpU  fhU  "      :   vendor/ramsey/uuid/src/Exception/RandomSourceException.php  fh        2   vendor/ramsey/uuid/src/Exception/NodeException.php`  fh`  ]      6   vendor/ramsey/uuid/src/Exception/DateTimeException.phpa  fha  \      8   vendor/ramsey/uuid/src/Exception/TimeSourceException.phpQ  fhQ        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.phpV  fhV  JN      :   vendor/ramsey/uuid/src/Exception/InvalidBytesException.php_  fh_  /٤      9   vendor/ramsey/uuid/src/Exception/DceSecurityException.phpm  fhm  IC      2   vendor/ramsey/uuid/src/Exception/NameException.phpc  fhc  sOS      =   vendor/ramsey/uuid/src/Exception/InvalidArgumentException.phpi  fhi  v'ä      =   vendor/ramsey/uuid/src/Exception/BuilderNotFoundException.phpQ  fhQ  @c      ?   vendor/ramsey/uuid/src/Exception/UnableToBuildUuidException.phpO  fhO  Ro      ;   vendor/ramsey/uuid/src/Exception/UuidExceptionInterface.php  fh  K;Ҥ      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  fh  <1i      -   vendor/ramsey/uuid/src/Nonstandard/Fields.php2
  fh2
        +   vendor/ramsey/uuid/src/Nonstandard/Uuid.php  fh        2   vendor/ramsey/uuid/src/Nonstandard/UuidBuilder.phpv	  fhv	         -   vendor/ramsey/uuid/src/Nonstandard/UuidV6.php
  fh
  !b         vendor/webmozart/assert/LICENSE<  fh<  t}      $   vendor/webmozart/assert/CHANGELOG.md  fh        !   vendor/webmozart/assert/README.md>  fh>  |Ϥ      %   vendor/webmozart/assert/composer.json  fh  3p      %   vendor/webmozart/assert/src/Mixin.php5 fh5 9(      8   vendor/webmozart/assert/src/InvalidArgumentException.phpi  fhi  {Lä      &   vendor/webmozart/assert/src/Assert.php  fh  =         vendor/react/promise/LICENSEg  fhg  F      !   vendor/react/promise/CHANGELOG.md9  fh9  OT:         vendor/react/promise/README.mdQY  fhQY  1      "   vendor/react/promise/composer.json  fh  T?      -   vendor/react/promise/src/PromiseInterface.php  fh  MFx8      &   vendor/react/promise/src/functions.php1-  fh1-  t      .   vendor/react/promise/src/functions_include.php   fh   dx\      $   vendor/react/promise/src/Promise.php(  fh(  XF<      %   vendor/react/promise/src/Deferred.php0  fh0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  fh
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.phpT	  fhT	  ϊK      7   vendor/react/promise/src/Internal/CancellationQueue.php  fh  r2      6   vendor/react/promise/src/Exception/LengthException.php^   fh^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  fha  '         vendor/sebastian/diff/LICENSE  fh  ܡ7      "   vendor/sebastian/diff/ChangeLog.md  fh  A         vendor/sebastian/diff/README.mdx   fhx   Z      #   vendor/sebastian/diff/composer.json  fh  H      !   vendor/sebastian/diff/SECURITY.mdu  fhu  KJ      "   vendor/sebastian/diff/src/Diff.php^  fh^  D1Ѥ      $   vendor/sebastian/diff/src/Parser.php  fh  թ      M   vendor/sebastian/diff/src/TimeEfficientLongestCommonSubsequenceCalculator.php5	  fh5	  0OԤ      :   vendor/sebastian/diff/src/Output/DiffOnlyOutputBuilder.php  fh        ?   vendor/sebastian/diff/src/Output/DiffOutputBuilderInterface.php  fh        =   vendor/sebastian/diff/src/Output/UnifiedDiffOutputBuilder.php  fh        C   vendor/sebastian/diff/src/Output/StrictUnifiedDiffOutputBuilder.phpm(  fhm(  ˌ      ?   vendor/sebastian/diff/src/Output/AbstractChunkOutputBuilder.php  fh  J5|      @   vendor/sebastian/diff/src/LongestCommonSubsequenceCalculator.php  fh  !J9      #   vendor/sebastian/diff/src/Chunk.php	  fh	  8      $   vendor/sebastian/diff/src/Differ.php  fh  ԕL      "   vendor/sebastian/diff/src/Line.php  fh  >      >   vendor/sebastian/diff/src/Exception/ConfigurationException.php)  fh)  2ܤ      @   vendor/sebastian/diff/src/Exception/InvalidArgumentException.php  fh  +U/ܤ      1   vendor/sebastian/diff/src/Exception/Exception.phpq  fhq  Z      O   vendor/sebastian/diff/src/MemoryEfficientLongestCommonSubsequenceCalculator.php+
  fh+
  ٤      3   vendor/terminal42/composer-lock-validator/README.md#
  fh#
  QG      7   vendor/terminal42/composer-lock-validator/composer.json#  fh#  B      ;   vendor/terminal42/composer-lock-validator/src/Validator.php$  fh$  sҤ      E   vendor/terminal42/composer-lock-validator/src/ValidationException.php1  fh1  V      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^8.1',
    'message' => 'The application requires the version "^8.1" or greater.',
    'helpMessage' => 'The application requires the version "^8.1" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/cose-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "json".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'session',
    'message' => 'The application requires the extension "session". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "session".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/cose-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "openssl".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "openssl".',
  ),
  9 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  10 => 
  array (
    'type' => 'extension',
    'condition' => 'filter',
    'message' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter". Enable it or install a polyfill.',
    'helpMessage' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter".',
  ),
  11 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  12 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
  13 => 
  array (
    'type' => 'extension',
    'condition' => 'iconv',
    'message' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.dd31abe1.js"></script><script defer="defer" src="js/app.26b2f97d.js"></script><link href="css/chunk-vendors.4b9d8264.css" rel="stylesheet"><link href="css/app.166c0ebc.css" rel="stylesheet"></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    // @phpstan-ignore identical.alwaysFalse
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $throwable) {
    ApiProblemResponse::createFromException($throwable, '@symfony_env@' !== 'prod')->send();
}
.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}body.nav-active{overflow:hidden!important}#app{transition:transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;transform:translateX(-280px)}.nav-active #app .navigation__group--main{visibility:visible}@media(min-width:1024px){.nav-active #app{transform:none}}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;background:none;border:none;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{transition-duration:75ms;transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{transform:rotate(45deg);transition-delay:.12s;transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;visibility:hidden;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a,.navigation__item button{display:block;margin:0;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre;background:none;border:none}.navigation__item a:hover,.navigation__item button:hover{text-decoration:none}.navigation__item a[href]:hover,.navigation__item button[href]:hover{color:var(--link)}.navigation__item--main>a,.navigation__item--main>button{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{display:flex;visibility:visible;position:inherit;inset:auto;width:auto;padding:0;overflow:visible;background:none;border:none;box-shadow:none;transform:none;transition:none}.navigation__group--sub{position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;transform:translateX(-50%);z-index:100;box-shadow:0 0 2px var(--shadow);transition:opacity var(--am-close-transition-duration) ease}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--sub.hide{display:none!important}.navigation__group--sub.transitioning{display:block!important;opacity:0}.navigation__group--sub.show{display:block!important;opacity:1;transition:opacity var(--am-open-transition-duration) ease}.navigation__group--right{left:auto;right:7px;transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2) 0;padding:0 2px;border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>button{padding-top:7px}.navigation__item--icon>button svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>button:hover svg{fill:var(--link)}.navigation__item--icon>button span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{text-align:center}.logout-warning__countdown{margin:20px 0;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:flex;flex-flow:column;justify-content:center;gap:10px}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{display:flex;justify-content:space-between;height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:flex;justify-content:center;align-items:center;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main__news a,.layout-main__news img{display:block}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{display:flex;justify-content:space-between}.layout-main__has-badge-title .layout-main__logo{display:flex}.layout-main__has-badge-title .layout-main__title{display:flex;flex-wrap:wrap;align-items:center;line-height:1;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:flex;justify-content:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:flex;flex-wrap:wrap;justify-content:flex-end;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) center center/20px 20px no-repeat}.package__actions{display:flex;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{display:flex;align-items:stretch;padding:0}.package__headline--badge{display:flex;gap:6px;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;flex-flow:row;gap:4%;text-align:right}.package__actions>*{flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:flex;align-self:center;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{--progress-color:var(--btn-warning);position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--progress-color);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--progress-color)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.progress-bar--primary{--progress-color:var(--btn-primary)}.progress-bar--alert{--progress-color:var(--btn-alert)}.feature-package{display:flex;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none;line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{flex-grow:1;display:flex;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px;border:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-bc2a3b20]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-bc2a3b20]::placeholder{color:#fff;-webkit-text-fill-color:#fff;opacity:1}.package-constraint input[type=text][data-v-bc2a3b20]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-bc2a3b20]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].incompatible[data-v-bc2a3b20]{background:var(--btn-alert);border-color:var(--btn-alert)}.package-constraint input[type=text].error[data-v-bc2a3b20]{animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-bc2a3b20],.package-constraint>input[type=text][data-v-bc2a3b20]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-bc2a3b20]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-bc2a3b20]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-bc2a3b20]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.incompatible[data-v-bc2a3b20]{background:var(--btn-alert)}.package-constraint button.rotate[data-v-bc2a3b20]:before{animation:release-validating-bc2a3b20 2s linear infinite}@keyframes release-validating-bc2a3b20{to{transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-bc2a3b20],.package-constraint input[type=text][data-v-bc2a3b20]{height:30px}}.button-group{display:flex;gap:1px;position:relative}.button-group__primary.widget-button{flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;padding-top:3px;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--versions{display:inline-flex;flex-wrap:wrap;gap:5px;list-style:none;margin:0 15px 0 0;padding:0}.composer-package__stats--version{padding:3px 5px;line-height:1;border:1px solid var(--border);border-radius:4px}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.cf78a0a0.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:54px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.widget-checkbox input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-checkbox label{position:relative;display:block;padding-left:25px;text-align:left}.widget-checkbox label:before{content:"";position:absolute;left:0;width:20px;height:20px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px}.widget-checkbox input:checked+label:before{background-image:url(../img/widget-checkbox--on.8b830157.svg)}.widget-checkbox input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox .widget__description{padding-left:25px}.widget-checkbox .widget__description--disabled{opacity:.5}.user-scope__label{margin:0;padding:0}.user-scope__item{padding:5px 0 0}.user-scope__item--required label{opacity:1!important}.user-scope__item--required label:before{opacity:.5}.view-oauth__header{max-width:280px;margin:0 auto 40px;padding-top:40px;text-align:center}.view-oauth__icon{background:var(--contao);border-radius:10px;padding:10px}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 60px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__scopes{text-align:left}.view-oauth__warning{color:var(--btn-alert);margin-top:2em;margin-bottom:2em}.view-oauth__button{margin-top:1em}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;filter:blur(2px);transition:opacity .5s,filter .5s}.message-overlay__overlay{position:absolute;display:flex;justify-content:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}@media(min-width:1024px){.maintenance__inside{display:grid;grid-template:auto/90px auto 300px;column-gap:20px;padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;border-radius:var(--border-radius);overflow:hidden;aspect-ratio:1;object-fit:contain}@media(min-width:1024px){.maintenance__image{display:flex;align-items:center}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px;display:flex;flex-wrap:wrap;column-gap:.5em;align-items:baseline}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;padding:4px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}.maintenance__actions{display:flex;flex-direction:column;row-gap:10px;column-gap:20px}@media(min-width:600px){.maintenance__actions{flex-direction:row-reverse}}@media(min-width:1024px){.maintenance__actions{flex-direction:column;margin-left:20px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{width:calc(50% - 10px)}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.9a7cd776.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{display:flex;justify-content:space-between;flex-wrap:wrap;gap:20px}.log-viewer__filters>div{display:flex;align-items:flex-end;gap:20px}.log-viewer__filters a{flex-shrink:0}.log-viewer__file{flex-shrink:1;display:flex;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5;white-space:pre-wrap}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:flex;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:flex;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.invite-user__check{text-align:center}.invite-user__check svg{width:60px;height:60px;fill:var(--btn-primary)}.invite-user__check,.invite-user__text{margin-bottom:1em}.invite-user__url{display:block;margin-top:2em}.invite-user__help{display:block;margin-top:1em;font-size:12px}.invite-user__clipboard{margin:1em 0}.widget-text input::-webkit-inner-spin-button,.widget-text input::-webkit-outer-spin-button{display:none}.widget-text input[type=number]{appearance:textfield!important}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.setup-totp__qr{margin:2em;text-align:center}.setup-totp__qr svg{width:200px;height:200px}.setup-totp__uri{display:block;margin:1em 0;word-break:break-all}.setup-totp .sk-circle{margin:20px auto}.disable-totp__text{margin-bottom:1em}.change-password .widget{margin:1em 0 0}.user-manager__loading{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.user-manager__loading .sk-circle{width:100px;height:100px;margin:0 auto 40px}.user-manager__list{display:grid;grid-template:1fr/1fr;gap:20px}@media(min-width:600px){.user-manager__list{grid-template:1fr/repeat(2,1fr)}}@media(min-width:800px){.user-manager__list{grid-template:1fr/repeat(3,1fr)}}@media(min-width:1200px){.user-manager__list{grid-template:1fr/repeat(4,1fr)}}.user-manager__item{position:relative;overflow:hidden;display:flex;flex-direction:column;padding:16px;background:var(--tiles-bg);border:1px solid 1px solid var(--tiles-bdr);border-radius:14px}.user-manager__ribbon{position:absolute;top:18px;right:-22px;width:100px;font-size:12px;color:#fff;font-weight:600;line-height:1.5;text-align:center;background:var(--btn-info);transform-origin:center center;transform:rotate(45deg)}.user-manager__ribbon--hint{cursor:help}.user-manager__ribbon--primary{background:var(--btn-primary)}.user-manager__ribbon--warning{background:var(--btn-warning)}.user-manager__ribbon--alert{background:var(--btn-alert)}.user-manager__new{margin-top:60px;text-align:center}.user-manager__spacer{flex-grow:1;min-height:1em}.user-manager__username{font-size:18px;font-weight:600}.user-manager__scope{margin-top:1em}.user-manager .widget-button{margin-top:5px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__close{display:flex;justify-content:center;align-items:center}.view-error__close{position:absolute;top:15px;right:10px;width:35px;height:35px;background:none;border:none;cursor:pointer;z-index:10}.view-error__close:hover{border:1px solid #fff}.view-error__content{display:flex;flex-direction:column;align-items:center;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__content--dump{text-align:left!important;overflow:auto!important;max-width:none!important;width:100vw!important;height:calc(100vh - 40px)!important;display:block!important;z-index:-1}.view-error__content--dump .sf-dump{background:none!important}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{align-self:flex-start;width:100%;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:flex;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;box-sizing:border-box}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;animation:console-active 1s linear infinite}@keyframes console-active{0%{transform:rotate(0deg)}50%{transform:rotate(180deg)}to{transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative;overflow-y:auto;max-height:280px}.console-operation__lines{padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:sticky;left:0;right:0;display:flex;justify-content:center;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:flex;flex-wrap:nowrap;justify-content:space-between;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:flex;flex-wrap:nowrap;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 20px;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}:root{--text:#535353;--link:#f47c00;--placeholder:#a9a9a9;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.eb57b3fa.svg);--svg--private:url(../img/private.a1c65662.svg);--svg--updated:url(../img/updated.3b47bebb.svg);--svg--downloads:url(../img/downloads.c1db2a9e.svg);--svg--favers:url(../img/favers.056e2836.svg);--svg--language:url(../img/language.582b2920.svg);--svg--color-scheme:url(../img/color_scheme.d527d153.svg)}html[data-color-scheme=dark]{color-scheme:dark;--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.07eeaee6.svg);--svg--private:url(../img/private--dark.41b90022.svg);--svg--updated:url(../img/updated--dark.c21fdd5b.svg);--svg--downloads:url(../img/downloads--dark.034bf7a3.svg);--svg--favers:url(../img/favers--dark.4765f7d4.svg);--svg--language:url(../img/language--dark.a24e849e.svg);--svg--color-scheme:url(../img/color_scheme--dark.ef0f0aed.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}html{box-sizing:border-box}*,:after,:before{box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}input::placeholder,select::placeholder,textarea::placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;transform:translateY(6px);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:30px;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+*+.widget__error,input:focus+.widget__error,input:hover+*+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}.widget__description{margin-top:2px;font-size:12px}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:6px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}.widget-button--anchor{height:auto;background:none!important;line-height:inherit;font-weight:inherit;color:var(--link);text-decoration:none;cursor:pointer}.widget-button--anchor:hover{text-decoration:underline!important}.widget-button--anchor.disabled,.widget-button--anchor:disabled{background:none!important}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);transition:background-color 5000s ease-in-out 0s}.widget-button--details:before{background-image:url(../img/button-details.8ce780e9.svg)}.widget-button--link:before{background-image:url(../img/button-link.dd42e161.svg)}.widget-button--search:before{background-image:url(../img/button-search.44ce1d4b.svg)}.widget-button--add:before,.widget-button--check:before,.widget-button--clipboard:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--passkey:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:18px 18px;content:""}.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--clipboard:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--passkey:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.animate-initializing{animation:initializing 1s linear infinite}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;filter:blur(4px);transition:opacity .35s,filter .5s}.animate-blur-out{opacity:1;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{transition-duration:.2s;transition-property:opacity;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{transform-style:preserve-3d;backface-visibility:hidden;transition-duration:.5s;transition-property:transform,opacity}.animate-flip-leave-active{transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{transform:perspective(600px) rotateY(90deg);transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{transform:perspective(400px) rotateY(1turn);transition-timing-function:ease-out;opacity:1}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--link-footer:#fff;--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.app-hint{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-info);color:#fff;text-align:center;z-index:100}.app-hint--warning{background:var(--btn-warning)}.app-hint--alert{background:var(--btn-alert)}.app-hint__description{display:none}@media(min-width:600px){.app-hint__description{display:inline}}.app-hint__link{margin:0;padding:0;background:none;border:none;color:#fff;text-decoration:underline;cursor:pointer}.app-hint+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.7a3b5ada.svg)}.widget-button--clipboard:before{background-image:url(../img/button-clipboard.9ef63d39.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.bc42f267.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.dd8ba18e.svg)}.widget-button--console:before{background-image:url(../img/button-console.05dcdfc4.svg)}.widget-button--database:before{background-image:url(../img/button-database.5282fc7e.svg)}.widget-button--download:before{background-image:url(../img/button-download.e1ba6f25.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.40a4be06.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.a2dc1f09.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.d23f6533.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.93830369.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--passkey:before{background-image:url(../img/button-passkey.3806f98a.svg)}.widget-button--power:before{background-image:url(../img/button-power.298a8072.svg)}.widget-button--run:before{background-image:url(../img/button-run.b6310c5a.svg)}.widget-button--save:before{background-image:url(../img/button-save.3b5224de.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.855f57fa.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.ad79c617.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.ca8e9cfc.svg)}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{padding:10px 20px 10px 50px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{display:flex;justify-content:space-between;align-items:center;gap:10px;padding:10px 10px 10px 50px;background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible button{flex-shrink:0}.package-popup__funding+.package-popup__update{margin-top:-10px}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 60px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:20px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px;margin-bottom:10px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:2em;font-size:12px;text-align:center}.view-login__button{margin:3px 0}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login__or{display:grid;gap:15px;grid-template-columns:1fr auto 1fr;padding:12px}.view-login__or:after,.view-login__or:before{align-self:center;border-top:1px solid var(--border);content:""}.view-login .fragment-footer{display:block}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.popup-overlay__popup{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;background:var(--popup-bg);z-index:10;opacity:1;transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.popup-overlay__headline{position:relative;margin-bottom:0;padding:7px 30px 6px;background:var(--popup-hl-bg);font-size:18px;color:#fff;font-weight:300;line-height:1.5em;text-align:center}.popup-overlay__headline--primary{background-color:var(--btn-primary)}.popup-overlay__headline--alert{background-color:var(--btn-alert)}.popup-overlay__content{padding:2em 20px}.popup-overlay__actions{display:flex;justify-content:center;gap:10px;flex-wrap:wrap;padding:0 20px 2em}.popup-overlay__actions .widget-button{width:auto;height:35px;padding:0 30px;line-height:35px}@media(min-width:550px){.popup-overlay__actions,.popup-overlay__content{padding-left:40px;padding-right:40px}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);animation:loading 1.4s ease-in-out infinite both}.loader__item--20{animation-delay:-.64s}.loader__item--40{animation-delay:-.48s}.loader__item--60{animation-delay:-.32s}.loader__item--80{animation-delay:-.16s}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{transform:rotate(30deg)}.sk-circle .sk-circle3{transform:rotate(60deg)}.sk-circle .sk-circle4{transform:rotate(90deg)}.sk-circle .sk-circle5{transform:rotate(120deg)}.sk-circle .sk-circle6{transform:rotate(150deg)}.sk-circle .sk-circle7{transform:rotate(180deg)}.sk-circle .sk-circle8{transform:rotate(210deg)}.sk-circle .sk-circle9{transform:rotate(240deg)}.sk-circle .sk-circle10{transform:rotate(270deg)}.sk-circle .sk-circle11{transform:rotate(300deg)}.sk-circle .sk-circle12{transform:rotate(330deg)}.sk-circle .sk-circle2:before{animation-delay:-1.1s}.sk-circle .sk-circle3:before{animation-delay:-1s}.sk-circle .sk-circle4:before{animation-delay:-.9s}.sk-circle .sk-circle5:before{animation-delay:-.8s}.sk-circle .sk-circle6:before{animation-delay:-.7s}.sk-circle .sk-circle7:before{animation-delay:-.6s}.sk-circle .sk-circle8:before{animation-delay:-.5s}.sk-circle .sk-circle9:before{animation-delay:-.4s}.sk-circle .sk-circle10:before{animation-delay:-.3s}.sk-circle .sk-circle11:before{animation-delay:-.2s}.sk-circle .sk-circle12:before{animation-delay:-.1s}@keyframes sk-circleBounceDelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.link-menu{position:absolute;display:grid;grid-template:1fr/1fr;left:50%;gap:2px;margin:0;padding:2px;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;box-shadow:0 0 1px var(--shadow);outline:none}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;width:100%;border-radius:5px;padding:8px 16px;color:var(--text);font-size:inherit;text-align:center;background:none;border:none;cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.link-menu__action--active{font-weight:600;background:var(--focus)}.footer-languages{position:relative;display:inline-block}.footer-languages__toggle{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.footer-languages__toggle:hover{color:var(--black)}.footer-languages__menu{display:grid;grid-template:auto/1fr 1fr;bottom:25px;white-space:nowrap;transform:translateX(-50%)}.footer-languages__menu button{margin:0;padding:6px;text-align:left;font-size:inherit}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-9c1c5f6c]{display:flex;justify-content:center;align-items:center}svg[data-v-9c1c5f6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:flex;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.discover-package__details{display:flex;flex-direction:column;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:flex;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:inline-flex;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:flex;flex-flow:row wrap;align-items:flex-end;flex-grow:1;gap:4px;line-height:28px}.discover-package__counts{flex-grow:1;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{flex-grow:1;display:flex;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:flex;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{flex-direction:row}.discover-package__actions{justify-content:end}}.vueperslide{white-space:normal;background-size:cover;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:flex;flex-direction:column;align-items:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;transition:opacity ease-in-out;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{transform:rotateY(90deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{transform:rotateY(90deg) translate(50%);transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{transform:rotateY(270deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{transform:rotateY(270deg) translate(-50%);transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;box-shadow:0 0 20px #00000040;z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;box-shadow:0 0 1px #00000080,0 0 3px #0000004d;transition:.4s ease-in-out;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:flex;flex:1 1 auto;flex-direction:column;align-items:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;justify-content:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;perspective:100em}.vueperslides__track-inner{white-space:nowrap;transition:transform .5s ease-in-out;height:100%;display:flex}.vueperslides--no-animation .vueperslides__track-inner{transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;transition:none}.vueperslides--3d .vueperslides__track-inner{transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{transition:transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;transform:translateY(-50%);transition:.3s ease-in-out;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;transition:.3s ease-in-out;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;transition:.3s ease-in-out}.vueperslides__bullets{display:flex;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;display:flex;justify-content:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:#fff3;color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:#000000b3}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;transition:.3s ease-in-out}@media(min-width:1200px){.ads{margin:59px 0 69px}}.ads .link{padding-top:5px;text-align:right}.ads .link a{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.ads .container{position:relative;background:var(--popup-bg);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.ads .container a,.ads .container img{display:block}.ads .container img{width:100%;aspect-ratio:2}.vueperslides__arrow:focus-visible{outline:5px auto Highlight!important;outline:5px auto -webkit-focus-ring-color!important}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:inline-flex;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}.package-sorting__item button{margin:0;padding:0;background:none;border:none;text-transform:uppercase;cursor:pointer}@media(min-width:600px){.package-sorting__group{flex-direction:row;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:5px;right:5px;display:flex;align-items:center;width:38px;height:40px;margin:0;padding:7px;line-height:36px;border:none;border-radius:0 50px 50px 0;background:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff;border-radius:4px}.vjs-tree-node.is-highlight .vjs-tree-node-actions,.vjs-tree-node:hover .vjs-tree-node-actions{display:block}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-tree-node .vjs-tree-node-actions{display:none;position:absolute;right:0;top:0;padding:0 4px;background-color:#e6f7ff;border-radius:4px}.vjs-tree-node .vjs-tree-node-actions .vjs-tree-node-actions-item{cursor:pointer}.vjs-tree-node .vjs-tree-node-actions .vjs-tree-node-actions-item:hover{color:#1890ff}.vjs-tree-node.dark .vjs-tree-node-actions,.vjs-tree-node.dark.is-highlight,.vjs-tree-node.dark:hover{background-color:#2e4558}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}[data-notivue=promise-resolve],[data-notivue=success]{--nv-bg:var(--nv-success-bg);--nv-fg:var(--nv-success-fg);--nv-accent:var(--nv-success-accent,var(--nv-global-accent));--nv-border:var(--nv-success-border)}[data-notivue=error],[data-notivue=promise-reject]{--nv-bg:var(--nv-error-bg);--nv-fg:var(--nv-error-fg);--nv-accent:var(--nv-error-accent,var(--nv-global-accent));--nv-border:var(--nv-error-border)}[data-notivue=warning]{--nv-bg:var(--nv-warning-bg);--nv-fg:var(--nv-warning-fg);--nv-accent:var(--nv-warning-accent,var(--nv-global-accent));--nv-border:var(--nv-warning-border)}[data-notivue=info]{--nv-bg:var(--nv-info-bg);--nv-fg:var(--nv-info-fg);--nv-accent:var(--nv-info-accent,var(--nv-global-accent));--nv-border:var(--nv-info-border)}[data-notivue=promise]{--nv-bg:var(--nv-promise-bg);--nv-fg:var(--nv-promise-fg);--nv-accent:var(--nv-promise-accent,var(--nv-global-accent));--nv-border:var(--nv-promise-border)}.Notivue__notification{--tip-width:calc(var(--tip-width-fx, 1)*var(--nv-tip-width, 0px));box-sizing:border-box;position:relative;width:var(--nv-min-width,auto);max-width:var(--nv-width,100%);background-color:var(--nv-bg,var(--nv-global-bg));display:flex;align-items:var(--nv-y-align);border-radius:var(--nv-radius,0);border:var(--nv-border-width,0) solid var(--nv-border,var(--nv-global-border));box-shadow:var(--nv-shadow,0 0 transparent),inset var(--tip-width) 0 0 var(--nv-accent)}.Notivue__notification *{box-sizing:border-box;touch-action:manipulation}.Notivue__notification[data-notivue-has-title=true]{align-items:var(--nv-y-align-has-title,var(--nv-y-align))}.Notivue__icon{display:flex;justify-content:center;align-items:center;overflow:visible;min-width:var(--nv-icon-size);width:var(--nv-icon-size);height:var(--nv-icon-size);margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing);color:var(--nv-accent)}.Notivue__content{--nv-content-space:calc(var(--nv-spacing) + var(--nv-spacing)*0.15);display:flex;flex-direction:column;flex-grow:1;text-align:inherit;padding:var(--nv-content-space)}.Notivue__content-title{line-height:1.15;font-weight:700;color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-title-size);margin:0 0 .33em;padding:0}.Notivue__transition-enter-active{--dur-easing:.5s cubic-bezier(.16,1,.3,1);transition:opacity var(--dur-easing),transform var(--dur-easing)}@media (prefers-reduced-motion:reduce){.Notivue__transition-enter-active{transition:none}}.Notivue__transition-enter-from{opacity:0;transform:scale(.8)}.Notivue__transition-enter-to{opacity:1;transform:scale(1)}.Notivue__transition-leave-active{transition:opacity 0ms ease}.Notivue__transition-leave-from,.Notivue__transition-leave-to{opacity:0}.Notivue__content-message{max-height:250px;overflow:auto;line-height:1.375;margin:0;padding:0;white-space:pre-line}.Notivue__close,.Notivue__content-message{color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-message-size)}.Notivue__close{position:relative;cursor:pointer;padding:calc(var(--nv-spacing)/2);margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0;font-weight:700;border:none;background:none;line-height:1;-webkit-tap-highlight-color:rgba(0,0,0,0)}.Notivue__close:after{content:"";position:absolute;top:0;right:0;bottom:0;left:0;width:100%;height:100%;background-color:var(--nv-fg,var(--nv-global-fg));opacity:0;border-radius:calc(var(--nv-radius)/2);transition:opacity .1s ease-out}@media (hover:hover){.Notivue__close:hover{opacity:1}.Notivue__close:hover:after{opacity:.1}.Notivue__close:hover .Notivue__close-icon{opacity:1}}.Notivue__close-icon{width:var(--nv-icon-size);height:var(--nv-icon-size);display:flex;color:var(--nv-fg,var(--nv-global-fg));pointer-events:none;opacity:.65}.Notivue__spinner{transform-origin:center;animation:Notivue__spinner-kf .75s linear infinite}@keyframes Notivue__spinner-kf{to{transform:rotate(1turn)}}@media (prefers-reduced-motion:reduce){.Notivue__duplicate,.Notivue__spinner{animation:none}}[dir=rtl] .Notivue__notification{--tip-width-fx:-1}[dir=rtl] .Notivue__icon{margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0}[dir=rtl] .Notivue__content-message{font-size:calc(var(--nv-message-size) + .1em)}[dir=rtl] .Notivue__content-title{font-size:calc(var(--nv-title-size) + .1em)}[dir=rtl] .Notivue__close{margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing)}.Notivue__duplicate{animation:Notivue__duplicate-kf .3s cubic-bezier(.16,1,.3,1) forwards}@keyframes Notivue__duplicate-kf{0%{transform:scale(1);opacity:1}50%{transform:scale(1.035);opacity:.8}to{transform:scale(1);opacity:1}}[data-notivue-align=top] .Notivue__enter,[data-notivue-align=top] .Notivue__leave{--notivue-ty:-200%}[data-notivue-align=bottom] .Notivue__enter,[data-notivue-align=bottom] .Notivue__leave{--notivue-ty:200%}.Notivue__enter{animation:Notivue__enter-kf .35s cubic-bezier(.5,1,.25,1)}.Notivue__leave{animation:Notivue__leave-kf .35s ease}.Notivue__clearAll{animation:Notivue__clearAll-kf .5s cubic-bezier(.22,1,.36,1)}@keyframes Notivue__enter-kf{0%{transform:translate3d(0,var(--notivue-ty),0) scale(.25);opacity:0}to{transform:translateZ(0) scale(1);opacity:1}}@keyframes Notivue__leave-kf{0%{transform:translateZ(0) scale(1);opacity:.7}to{transform:translate3d(0,var(--notivue-ty),0) scale(0);opacity:0}}@keyframes Notivue__clearAll-kf{0%{opacity:1}to{opacity:0}}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{padding:10px 20px 10px 50px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{display:flex;justify-content:space-between;align-items:center;gap:10px;padding:10px 10px 10px 50px;background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible button{flex-shrink:0}.package-popup__funding+.package-popup__update{margin-top:-10px}.theme-details__constraint{flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);transition:transform .1s ease-in-out}.file-tree__folder--open:before{transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:flex}.setup__tab-control{flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__theme-upload{padding:0 50px;text-align:center}@media(min-width:960px){.setup__theme-upload{padding:0 150px}}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{display:flex;margin:0;padding:0;list-style-type:none}.view-setup__steps li{display:flex;justify-content:center;align-items:center;flex-grow:1;position:relative;height:6px;margin:0;padding:0}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:flex;justify-content:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:flex;flex-wrap:wrap;gap:10px}.setup__actions--center{justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form,.view-account__totp{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-button,.view-account__totp .widget-button{margin-top:1.5em}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:flex;flex-flow:row wrap;align-items:center;padding-top:50px}.view-account__form,.view-account__header,.view-account__totp{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .button-group,.view-account__form .widget-button--anchor{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check ul.boot-check__description{padding:0 0 0 1em;list-style:"- "}.boot-check ul.boot-check__description li{padding:0;margin:0}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank) left center no-repeat;background-size:16px 16px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[769],{4769:function(i){i.exports=JSON.parse('{"ui.app.title":"Estensioni Contao","ui.app.loading":"Caricamento lista estensioni...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Pubblicità nell\'elenco delle estensioni","ui.discover.loading":"Caricamento in corso ...","ui.discover.offline":"Non è stato possibile ottenere alcun risultato.","ui.discover.offlineExplain":"Controlla la tua connessione internet e disabilita i blocchi JavaScript nel tuo browser.","ui.discover.offlineButton":"Riprova","ui.discover.searchPlaceholder":"Cerca in {conti} estensioni ...","ui.discover.empty":"Nessun risultato per {query}","ui.discover.more":"Ulteriori risultati","ui.discover.sortBy":"Ordina per","ui.discover.sortReleased":"Rilasciato","ui.discover.sortReleasedTitle":"Ordina i risultati per data di rilascio","ui.discover.sortLatest":"Aggiornamento eseguito","ui.discover.sortLatestTitle":"Ordina i risultati per ultimo aggiornamento","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ordina i risultati per numero di download","ui.discover.sortFavers":"Valutazione","ui.discover.sortFaversTitle":"Ordina i risultati per valutazione","ui.discover.detailsButton":"Dettagli","ui.discover.latestPackages":"Estensioni più recenti e aggiornate","ui.discover.faversPackages":"Estensioni più votate","ui.discover.downloadsPackages":"Estensioni più scaricate","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Sito web del progetto","ui.package.private":"Pacchetto privato","ui.package.privateTitle":"I pacchetti privati sono disponibili solo attraverso il fornitore (ad es. Come download ZIP). Per ulteriori informazioni, visitare il sito Web.","ui.package.abandoned":"dismesso","ui.package.abandonedText":"Questo pacchetto è abbandonato e non è più mantenuto.","ui.package.abandonedReplace":"Questo pacchetto è abbandonato e non è più mantenuto. L\'autore suggerisce di usare il pacchetto {sostituzione}.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Dettagli estensione precedente","ui.package-details.close":"Chiudi dettagli estensione","ui.package-details.loading":"Caricamento in corso ...","ui.package-details.tabDescription":"Descrizione","ui.package-details.tabRequire":"Requisiti","ui.package-details.tabFeatures":"Caratteristiche","ui.package-details.tabSuggest":"Suggerimenti","ui.package-details.tabConflict":"Conflitti","ui.package-details.tabDependents":"Dipendenti","ui.package-details.linkRequires":"richiede","ui.package-details.linkReplaces":"sostituisce","ui.package-details.linkProvides":"fornisce","ui.package-details.linkConflicts":"Conflitti","ui.package-details.funding":"Manutenzione del pacchetto!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Ultima versione","ui.package-details.released":"rilasciato il","ui.package-details.license":"Licenza","ui.package-details.authors":"da","ui.package-details.more":"Altro","ui.package-details.packagist":"Dettagli del pacchetto","ui.package-details.metadata":"Modifica metadati","ui.package-details.support_docs":"Documentazione","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forum di supporto","ui.package-details.support_issues":"Problemi / Bug Report","ui.package-details.support_source":"Source Code","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"E-Mail di supporto","ui.package-details.support_rss":"Feed RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[44],{44:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Bağlantı güvenli değil !!","ui.app.httpsDescription":"HTTPS olmadan verileriniz şifrelenmeden aktarılır ve başkaları tarafından görülebilir.","ui.app.httpsLink":"Ayrıntılı bilgi alın","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Güvenli kip etkin !!","ui.app.safeModeDescription":"Bazı Contao Manager özellikleri kullanılamaz.","ui.app.safeModeExit":"Güvenli kipten çık","ui.app.limitedHeadline":"Uzaktan kimlik doğrulama","ui.app.limitedDescription":"Parolasız oturum açma kullandığınızdan izinleriniz sınırlı.","ui.app.limitedLogout":"Kimliği yeniden doğrula","ui.app.totpHeadline":"Güvenlik bildirimi","ui.app.totpDescription":"Hesabınızın güvenliğini sağlamak için iki adımlı doğrulamayı yapılandırın.","ui.app.totpSetup":"Kurulum","ui.app.loading":"Contao Manager yükleniyor…","ui.app.apiError":"Beklenmeyen API durumu","ui.app.configSecurity1":"GÜVENLİK UYARISI !!! Yapılandırma klasörünün korunmadığı algılandı","ui.app.configSecurity2":"Contao Manager, yapılandırma dosyalarının herkese açık olduğunu algıladı. Klasörün güvenliği sağlanana kadar tüm işlemler etkisizleştirilecek. Yoksa bir saldırgan kurulumunuzun hassas verilerine erişebilir.\\n\\nBu sorunu gidermek için sunucunuzdaki \\"contao-manager\\" klasörüne erişimi engellediğinizden emin olun. Bunu nasıl yapacağınızı öğrenmek için site sunucunuzun belgelerine bakın veya barındırma hizmeti sağlayıcınızla görüşün.","ui.account.welcome":"Hoş geldiniz","ui.account.intro1":"Contao açık kaynaklı içerik yönetimi sistemini kurmak ve yönetmek için kullanılan Contao Manager uygulamasına hoş geldiniz. İlk kez kullanıyorsanız {readTheManualToGetStarted}.","ui.account.introGetStarted":"Başlamak için {readTheManualToGetStarted}.","ui.account.introManual":"rehberi okuyun","ui.account.intro2":"Herhangi bir sorunla karşılaşırsanız,  {ourGithubIssues} bakın ve henüz bildirilmemiş bir sorunu bildirmekten çekinmeyin.","ui.account.introIssues":"GitHub sorunlarımıza","ui.account.headline":"Kullanıcı hesabı","ui.account.description":"Kuurlumunuzu yönetmek için bir Contao Manager hesabı açın. Bu hesabın Contao ön yüzü ve yönetim bölümü ile ilgili olmadığını unutmayın. ","ui.account.username":"Kullanıcı adı","ui.account.password":"Parola","ui.account.passwordPlaceholder":"en az 8 karakter","ui.account.passwordLength":"Lütfen en az 8 karakter yazın.","ui.account.loginInvalid":"Hesap açılırken bir sorun çıktı. Başka bir kullanıcı adı deneyin.","ui.account.submit":"Hesap aç","ui.account.usePassword":"Parola ile oturum aç","ui.account.usePasskey":"Geçiş anahtarı ile oturum aç","ui.account.totpHeadline":"İki adımlı doğrulama","ui.account.totpDescription":"Hesabınıza ek bir güvenlik katmanı ekleyen iki adımlı doğrulamayı açın. Kullanıcı adınız ve parolanıza ek olarak, 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator veya başka herhangi bir tek kullanımlık parola uygulaması gibi bir iki adımlı doğrulama uygulaması tarafından oluşturulan bir kodu yazmanız gerekir.","ui.account.totpSetup":"Şimdi yapılandır","ui.account.totpSkip":"Sonra yapılandır","ui.account.login":"Daveti reddet","ui.account.contribute1":"Contao ve Contao Manager kar amacı gütmeyen Contao Association tarafından desteklenmektedir.","ui.account.contribute2":"Lütfen {donate} açık kaynak dünyasına destek vermeyi değerlendirin.","ui.account.contributeDonate":"bir bağış yaparak","ui.login.headline":"Oturum aç","ui.login.description":"Kurulumunuzu yönetmek için oturum açın.","ui.login.username":"Kullanıcı adı","ui.login.password":"Parola","ui.login.totpHeadline":"İki adımlı doğrulama","ui.login.totpDescription":"Oturum açmak için lütfen doğrulama kodunuzu yazın.","ui.login.totp":"Doğrulama kodu","ui.login.forgotPassword":"Parolamı unuttum","ui.login.button":"Oturum aç","ui.login.passkey":"Geçiş anahtarı ile oturum aç","ui.login.cancel":"İptal","ui.login.or":"ya da","ui.login.locked":"Contao Manager kilitlenmiş olduğundan erişim reddedildi. Kilidi açmak için Contao kök klasöründeki {lockFile} dosyasını silin.","ui.logout.headline":"Oturum zaman aşımına uğradı","ui.logout.warning":"25 dakikadan uzun süredir işlem yapmadınız. Güvenlik nedeniyle oturumunuz kısa bir süre içinde sonlandırılacak.","ui.logout.expired":"30 dakikadan uzun süredir işlem yapmadığınız için oturumunuz otomatik olarak sonlandırıldı.","ui.logout.renew":"Oturumu açık tut","ui.logout.logout":"Oturumu kapat","ui.logout.login":"Oturum açmaya dön","ui.oauth.error":"OAuth girişimi geçersiz. İstek parametrelerini denetleyin.","ui.oauth.https":"Yönlendirme adresi, kimlik doğrulama belirtecinin düz yazı olarak iletilmesini önlemek için güvenli bir iletişim kuralı (https:) kullanmalıdır.","ui.oauth.headline":"Uzaktan kimlik doğrulama","ui.oauth.description":"Şu uygulama ya da hizmet Contao Manager kopyanıza uzaktan erişmek istiyor.","ui.oauth.domain":"Erişim izni vermeden önce bu adresi bildiğinizden ve sahibine güvendiğinizden emin olun!","ui.oauth.outOfScope":"Ne yazık ki, bu izni vermek için yeterli izinleriniz yok.","ui.oauth.allow":"Erişme izni ver","ui.oauth.deny":"Erişimi reddet","ui.oauth.switchUser":"Kullanıcıyı değiştir","ui.scope.admin":"Yönetici erişiminde kullanıcı yönetimi bulunur","ui.scope.install":"Yeni paketleri kurun ve Contao yapılandırmasını değiştirin","ui.scope.update":"Paketleri güncelleyin ve bakım görevlerini yürütün","ui.scope.read":"Paketleri ve yapılandırmayı okuyun","ui.boot.headline":"Sistem denetimi","ui.boot.description":"Lütfen sunucunuz incelenirken bekleyin…","ui.boot.issue1":"Kurulum sorunları algılandı","ui.boot.issue2":"Kurulumunuzda Contao Manager kullanabilmek için düzeltmeniz gereken sorunlar var.","ui.boot.run":"Contao Manager uygulamasını başlat","ui.boot.safeMode":"Güvenli kipte başlat","ui.recovery.headline":"Sistem kurtarma","ui.recovery.description":"Contao Manager, Contao kurulumuna benzeyen dosyalar algıladı, ancak komut satırı arabirimi beklendiği gibi çalışmıyor.","ui.recovery.console":"Konsol çıktısı","ui.recovery.repairOptions":"Lütfen kurulumunuzu onarmak için bir seçim yapın.","ui.recovery.repairHeadline":"Otomatik onarım","ui.recovery.repairDescription":"Uygulama ön belleğini yeniden oluşturup Composer paketlerini yeniden kurarak kurulumu otomatik olarak onarmayı dener.","ui.recovery.repairWarning":"İşlem sırasında üretici dosyalarında yapılmış herhangi bir değişiklik silinebilir!","ui.recovery.repairFailed":"Otomatik onarım başarılı olmadı. Kurulumu el ile onarmak için güvenli kipi deneyin.","ui.recovery.repairButton":"Sistem onarımını başlat","ui.recovery.safeModeHeadline":"Güvenli kip","ui.recovery.safeModeDescription":"Contao Manager güvenli kipte çalıştırıldığında, paketlerin yönetimine ve belirli bakım işlemlerine izin verir. Ancak çalışan bir Contao kurulumu ile ilgili özellikleri kullanılamaz.","ui.recovery.safeModeButton":"Güvenli kipte başlat","ui.server.pending":"Bekleniyor…","ui.server.running":"İnceleniyor…","ui.server.error":"Sunucudan alınan beklenmeyen bir yanıt nedeniyle denetim tamamlanamadı.","ui.server.details":"Ayrıntılar","ui.server.prerequisite":"Eksik bir ön koşul nedeniyle denetim iptal edildi.","ui.server.selfUpdate.title":"Contao Manager güncellemeleri","ui.server.selfUpdate.update":"Yeni Contao Manager {latest} sürümü yayınlanmış.","ui.server.selfUpdate.manualUpdate":"Yeni Contao Manager {latest} sürümü yayınlanmış. Sunucunuz otomatik güncellemeleri desteklemiyor. Lütfen {download} adresinden yeni sürümü indirin.","ui.server.selfUpdate.latest":"Güncel {current} sürümünü kullanıyorsunuz.","ui.server.selfUpdate.dev":"Geliştirme yapımları otomatik güncellemeleri desteklemez.","ui.server.selfUpdate.unsupported":"Yeni bir sürüm yayınlanmış ancak PHP sürümünüzü desteklemiyor.","ui.server.selfUpdate.button":"Otomatik güncelle","ui.server.selfUpdate.continue":"İlerle","ui.server.config.title":"Sunucu yapılandırması","ui.server.config.setup":"Yapılandır","ui.server.config.change":"Değiştir","ui.server.config.save":"Kaydet","ui.server.config.cancel":"İptal","ui.server.config.customOption":"Diğer…","ui.server.config.description":"Arka plan görevlerini doğru bir şekilde çalıştırmak için Contao Manager uygulamasının, PHP komut satırı binary dosyasını nerede bulacağını ve site sürecinden ayrı olarak komutları nasıl çalıştıracağını bilmesi gerekir.","ui.server.config.formTitle":"Sunucu yapılandırması","ui.server.config.formText":"Lütfen PHP binary dosyanızın yolunu yazın. Binary programın PHP sürümünün site işleminizle aynı olduğundan emin olun.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud, sunucunuz yeterli yerel bellek sunmasa bile Composer bağımlılıklarının kurulmasını sağlar. Paket bilgilerinizin Contao Association tarafından işletilen bir bulut sunucusuna aktarılacağını unutmayın.","ui.server.config.cloud":"Composer Resolver Cloud kullanılsın","ui.server.config.cli":"PHP binary dosyası","ui.server.config.stateErrorCli":"Sunucuda geçerli bir PHP binary dosyası bulunamadı.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud desteklenmiyor.","ui.server.config.stateSuccess":"PHP binary dosyası {php_cli} konumunda.","ui.server.config.cloudEnabled":"Package dependencies will be resolved using the Composer Resolver Cloud.","ui.server.config.cloudDisabled":"The Composer Resolver Cloud is disabled.","ui.server.php_web.title":"PHP site işlemi","ui.server.php_web.below7":"PHP {version} sürümü bulundu. Lütfen en kısa sürede PHP 7 sürümüne geçin!","ui.server.php_web.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.php_cli.title":"PHP komut satırı arayüzü","ui.server.php_cli.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.composer.title":"Composer ortamı","ui.server.composer.success":"Bilinen bir sorun bulunamadı.","ui.server.composer.install":"Composer bağımlılıkları kurulmamış.","ui.server.composer.button":"Kur","ui.server.contao.title":"Contao kurulumu","ui.server.contao.setup":"Kurulum","ui.server.contao.check":"Veri tabanını denetle","ui.server.contao.empty":"Herhangi bir Contao sürümünü bulunamadı.","ui.server.contao.old":"Contao {version} sürümü Contao Manager ile uyumlu değil. Lütfen kurulumunuzu el ile güncelleyin.","ui.server.contao.found":"Contao {version} sürümü bulundu (API sürümü {api}).","ui.server.contao.connectionError":"Veri tabanı sunucusu ile bağlantı kurulamadı.","ui.server.contao.connectionProblem":"Veri tabanı sorunu bulundu.","ui.server.contao.missingUser":"Yönetici hesabı bulunamadı.","ui.setup.continue":"İlerle","ui.setup.manager":"Contao Manager uygulamasını başlat","ui.setup.cancel":"İptal","ui.setup.welcome":"Hoş geldiniz","ui.setup.welcome1":"Bu yardımcı, açık kaynaklı Contao içerik yönetimi sistemi kurulumunu yapmanız için gerekli adımlarda size yol gösterecek.","ui.setup.welcome2":"Herhangi bir sorunuz varsa belgelere, forumlara, Slack kanalına ve {destek} sayfasına bakabilirsiniz.","ui.setup.support":"topluluk desteği","ui.setup.start":"Başlayalım","ui.setup.complete":"Tebrikler!","ui.setup.complete1":"Contao {version} kuruldu.","ui.setup.complete2":"Kurulum işlemini tamamlamak için gereken veri tabanı bağlantısını yapılandırmak ve yönetim bölümü kullanıcısı oluşturacak kurulum aracını açın.","ui.setup.complete3":"Artık Contao yönetim bölümüne giderek sitenizi oluşturmaya başlayabilirsiniz. Çeşitli eklentilere gerek duyuyorsanız Contao Manager ile ilerleyin.","ui.setup.installTool":"Kurulum aracını açın","ui.setup.login":"Contao oturumu açın","ui.setup.funding":"Özgür yazılım, \\"konuşma özgürlüğü\\" ifadesindeki gibi \\"özgürdür\\". \\"Ücretsiz\\" olmasına rağmen o anlama gelmez. Contao gibi bir açık kaynaklı proje, tek bir kişi veya şirket tarafından toplanamayacak miktarda para gerektirir.\\nContao ile oluşturulmuş bir siteniz varsa veya böyle siteler satıyorsanız, işinizin destekleyen ürüne mali katkıda bulunduğunuzu görmek isteriz.","ui.setup.fundingLink":"Ayrıntılı bilgi alın","ui.setup.document-root.headline":"Site sunucusu kurulumu","ui.setup.document-root.warning":"Contao Manager ile Contao kurmak için site sunucusunun belge kök klasörünü düzeltmeniz gerekir.","ui.setup.document-root.description1":"Contao, herkese açık dosyalar için ayrı bir klasör kullanır. Uygulama dosyaları bu klasörün üst klasörüne kurulur. Klasör yapısı doğru değilse veya klasörler boş değilse Contao kurulamaz.","ui.setup.document-root.description2":"Belge kök klasörünüzü nasıl yapılandıracağınızı bilmiyorsanız, Contao belgelerini okuyun ya da barındırma hizmeti sağlayıcınızla görüşün.","ui.setup.document-root.documentation":"Belgeleri okuyun","ui.setup.document-root.conflictsTitle":"Kurulum klasörü boş değil","ui.setup.document-root.conflictsDirectory":"Gelecekteki Contao kurulumunuzun kök klasörü boş değil. Kurulum işlemi tarafından üzerine yazılabilecek {count} dosya bulundu. Contao için boş bir klasör yapısı oluşturmanız önerilir. Ancak kullanılmadıklarından eminseniz aşağıdaki dosyaları silerek yeniden denetleyebilirsiniz.","ui.setup.document-root.ignoreConflicts":"Boş olmayan bir klasöre Contao kurmak istiyorum. Bu işlemin site alanımdaki var olabilecek dosyaların üzerine yazabileceğini anlıyorum.","ui.setup.document-root.check":"Yeniden denetle","ui.setup.document-root.create":"Klasörleri oluştur","ui.setup.document-root.change":"Klasörleri değiştir","ui.setup.document-root.formTitle":"Klasör kurulumu","ui.setup.document-root.formText1":"Contao Manager, otomatik olarak sunucuda yeni bir klasör yapısı oluşturabilir.","ui.setup.document-root.formText2":"Yeni belge kök klasörünü el ile yapılandırmanız gerekir (örneğin, bir barındırma hizmeti yönetim panosu üzerinden).","ui.setup.document-root.autoconfig":"Sunucu yapılandırmamı değiştirmem gerektiğini anlıyorum. Belge kök klasörünü yapılandırmamak Contao Manager uygulamasını bozacak ve yapılandırma dosyalarını (hesap bilgileri ve parolalar ile birlikte) açığa çıkaracak!","ui.setup.document-root.directory":"Yeni klasör","ui.setup.document-root.currentRoot":"Geçerli belge kök klasörü","ui.setup.document-root.newRoot":"Yeni belge kök klasörü","ui.setup.document-root.finish":"Klasörleri kur","ui.setup.document-root.publicDir":"Herkese açık dosyalar için {dir} klasörünü kullanın (Contao {version} için)","ui.setup.document-root.directoryInvalid":"Lütfen geçerli bir klasör adı yazın.","ui.setup.document-root.directoryExists":"Hedef klasör zaten var. Lütfen farklı bir ad yazın.","ui.setup.document-root.confirmation":"Contao Manager, Contao kurulumunuz için gerekli klasörü oluşturdu. Şimdi site sunucunuzda belge kök klasörünü yapılandırmanız gerekiyor. Bu işlemi yapana kadar bu sayfayı yeniden yüklemeyin.","ui.setup.document-root.reload":"Sayfayı yeniden yükle","ui.setup.document-root.success":"Site sunucunuzdaki klasör yapısı doğru şekilde hazırlanmış!","ui.setup.document-root.installingProjectDir":"Uygulama dosyaları {dir} klasörüne kurulacak.","ui.setup.document-root.installingPublicDir":"Herkese açık dosyalar {dir} klasörüne kurulacak.","ui.setup.document-root.installedProjectDir":"Uygulama dosyaları {dir} klasörüne kuruldu.","ui.setup.document-root.installedPublicDir":"Herkese açık dosyalar {dir} klasörüne kuruldu.","ui.setup.create-project.headline":"Contao kurulumu","ui.setup.create-project.description":"Contao geliştirmesi {semver} ilkesini izler. Her altı ayda bir yeni bir küçük sürüm yayınlanır. Şu anda desteklenen sürümler şunlardır:","ui.setup.create-project.semver":"Anlamsal sürümleme","ui.setup.create-project.latestTitle":"Güncel","ui.setup.create-project.ltsTitle":"Uzun dönemli destek","ui.setup.create-project.latestQ1":"Güncel sürümümüz en fazla özelliği sunar ve {year} Şubat ayına kadar desteklenir.","ui.setup.create-project.latestQ3":"Güncel sürümümüz en fazla özelliği sunar ve {year} Ağustos ayına kadar desteklenir.","ui.setup.create-project.ltsText":"Güncel uzun dönem desteklenen sürümümümüz, kararlılık isteyenler içindir. {year} Şubat ayına kadar uzun dönem desteği sunar.","ui.setup.create-project.pltsText":"Önceki uzun dönem desteklenen sürümümüz. Hala {year} Şubat ayına kadar uzun dönem desteği sunuyor.","ui.setup.create-project.requiresPHP":"En az PHP {version} sürümü gereklidir. Sizin sürümünüz PHP {current}.","ui.setup.create-project.releaseplan":"Ayrıntılı bilgi almak için {contaoReleasePlan} bölümüne bakabilirsiniz.","ui.setup.create-project.releaseplanLink":"Contao yayınlanma planı","ui.setup.create-project.installed":"Contao {version} sunucuya kuruldu. Veri tabanınızı kurmaya geçin ya da farklı bir sürüm kurmak için Contao Manager uygulamasını başlatın.","ui.setup.create-project.formTitle":"Bir dağıtım seçin","ui.setup.create-project.formText":"Lütfen kurmak istediğiniz sürümü seçin.","ui.setup.create-project.version":"Sürüm","ui.setup.create-project.demo":"Contao tanıtım sitesini kur","ui.setup.create-project.demoDescription":"Tanıtım sitesi Contao ve onun tüm temel özelliklerini tanımanıza yardımcı olur. Daha fazla temayı {store} üzerinde bulabilirsiniz.","ui.setup.create-project.coreOnly":"En küçük kurulum (yalnızca çekirdek)","ui.setup.create-project.noUpdate":"Kurulumu atla (yalnızca uzmanlar)","ui.setup.create-project.theme":"Contao teması","ui.setup.create-project.themeInstall":"Bir Contao teması kurmak için arama girişini kullanın ya da Contao Manager ile kurulabilen bir tema dosyası (.cto/.zip) yükleyin.","ui.setup.create-project.themeBuy":"Resmi {store} adresini açtığınızdan emin olun.","ui.setup.create-project.themeStore":"Contao tema mağazası","ui.setup.create-project.themeUpload":"Tema dosyasını yükle (.cto/.zip)","ui.setup.create-project.themeInvalid":"Yüklenen dosya bir Contao teması değil ya da Contao Manager uygulamasını desteklemiyor.","ui.setup.create-project.themeWarning":"Contao Manager bu temanın sunucunuzla uyumlu olup olmadığını söyleyemez. Sorularınız varsa lütfen tema satıcısına sorun.","ui.setup.create-project.themeTitle":"Tema bilgilerini gözden geçir","ui.setup.create-project.themeDetails":"Bu temayla birlikte şu bağımlılıklar ve dosyalar yüklenecek.","ui.setup.create-project.themeRequire":"{count} bağımlılık | {count} bağımlılık","ui.setup.create-project.themeFiles":"{count} dosya | {count} dosya","ui.setup.create-project.theme.or":"ya da herkese açık temalar arayın","ui.setup.create-project.theme.search":"Tema ara","ui.setup.create-project.theme.more":"Diğer temalar","ui.setup.create-project.theme.empty":"{query} ile eşleşen bir tema yok","ui.setup.create-project.theme.uploaded":"Tema dosyası yüklendi.","ui.setup.create-project.theme.packageName":"Paket adı","ui.setup.create-project.theme.version":"Sürüm","ui.setup.create-project.theme.authors":"Geliştirici(ler)","ui.setup.create-project.theme.upload":"{name} yükleniyor ({size})","ui.setup.create-project.install":"Kur","ui.setup.create-project.cancel":"İptal","ui.setup.create-project.fileError":"{file} içinde composer.json bulunamadı.","ui.setup.create-project.jsonError":"composer.json içindeki JSON geçersiz.","ui.setup.create-project.schemaError":"composer.json şeması doğrulanamadı.","ui.setup.database-connection.headline":"Veri tabanı bağlantısı","ui.setup.database-connection.description":"Contao, sayfaları, içerikleri, kullanıcıları ve diğer ilişkisel verileri depolamak için bir MySQL veri tabanı (ya da MariaDB gibi uyumlu bir dalı) kullanır. Bağlantı parametreleri, Contao kurulumunuzun proje kök klasöründeki {env} dosyasında bulunur.","ui.setup.database-connection.formTitle":"Bağlantı parametreleri","ui.setup.database-connection.formText":"Bir veri tabanı adresi yazın ya da tek tek kullanıcı adı, parola, sunucu ve veri tabanı alanlarını doldurun.","ui.setup.database-connection.url":"Veri tabanı adresi","ui.setup.database-connection.validUrl":"Veri tabanı adresi geçersiz ya da sunucu bağlantısı kurulamadı.","ui.setup.database-connection.or":"ya da","ui.setup.database-connection.user":"Kullanıcı adı","ui.setup.database-connection.password":"Parola","ui.setup.database-connection.server":"Sunucu (:bağlantı noktası)","ui.setup.database-connection.database":"Veri tabanı adı","ui.setup.database-connection.connected":"{server} üzerindeki {database} veri tabanı ile bağlantı kuruldu.","ui.setup.database-connection.error":"Veri tabanı bağlantısı kurulurken sorun çıktı.","ui.setup.database-connection.problem":"Contao veri tabanı sunucunuzda bir sorunla karşılaştı.","ui.setup.database-connection.schemaTitle":"Veri tabanı şeması","ui.setup.database-connection.migration":"Bekleyen bir aktarım var. | Bekleyen {count} aktarım var.","ui.setup.database-connection.schema":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var.","ui.setup.database-connection.noChanges":"Veri tabanı şemanız güncel","ui.setup.database-connection.check":"Veri tabanını denetle","ui.setup.database-connection.skip":"Atla","ui.setup.database-connection.save":"Kaydet","ui.setup.database-connection.change":"Kimlik doğrulama bilgilerini değiştir","ui.setup.database-connection.restoreTitle":"Veri tabanı içe aktarma","ui.setup.database-connection.restoreText":"Yeni kurduğunuz temada bir veri tabanı yedeği var. Tema verilerini içe aktarmak için veri tabanını geri yükleyin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın. | Yeni kurduğunuz temada birkaç veri tabanı yedeği var. Tema verilerini içe aktarmak için bir yedekleme dosyası seçin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın.","ui.setup.database-connection.backup":"İçe aktarma işleminden önce geçerli veri tabanının yedeğini alın","ui.setup.database-connection.backupWarning":"İçe aktarım işlemi sırasında veri tabanındaki tüm verilerin üzerine yazılır! Veri tabanı boş değilse öncelikle bir yedeğini alın.","ui.setup.database-connection.restore":"Tema veri tabanını içe aktar","ui.setup.database-connection.restoreOption":"{date} yedeği ({size})","ui.setup.database-connection.restored":"Tema veri tabanınız içe aktarıldı. Veri tabanı şemanızı doğrulamak için ilerleyin.","ui.setup.backend-user.success":"Veri tabanınızda Contao yönetim bölümü için bir yönetici hesabı bulundu. Daha fazla kullanıcı eklemek için Contao yönetim bölümünü kullanın.","ui.setup.backend-user.error":"Kullanıcı listesi alınamadı. Ayrıntılar için konsol çıktısına bakın.","ui.setup.backend-user.headline":"Yönetim bölümü hesabı","ui.setup.backend-user.description":"Sitenizi yönetmek için Contao yönetim bölümüne erişebilecek en az bir yönetici hesabınızın olması gerekir. Bu hesabın Contao Manager ile ilgili olmadığını unutmayın.","ui.setup.backend-user.formTitle":"Hesap aç","ui.setup.backend-user.formText":"Yeni yönetim bölümü hesabının ayrıntılarını yazın.","ui.setup.backend-user.username":"Kullanıcı adı","ui.setup.backend-user.name":"Ad","ui.setup.backend-user.email":"E-posta adresi","ui.setup.backend-user.emailInvalid":"Lütfen geçerli bir e-posta adresi yazın","ui.setup.backend-user.password":"Parola","ui.setup.backend-user.passwordPlaceholder":"en az 8 karakter","ui.setup.backend-user.passwordLength":"Lütfen en az 8 karakter yazın.","ui.setup.backend-user.create":"Hesap ekle","ui.task.headline":"Arka plan görevi","ui.task.loading":"Ayrıntılar yükleniyor…","ui.task.created":"Ayrıntılar yükleniyor…","ui.task.active":"Lütfen Contao Manager arka planda görev işlemlerini yürütürken bekleyin.","ui.task.complete":"Tüm işlemler tamamlandı. Ayrıntılı bilgi almak için konsol çıktısına bakın.","ui.task.paused":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.aborting":"Lütfen arka plan işlemleri iptal edilirken bekleyin.","ui.task.stopped":"Bazı arka plan görevleri iptal edildi. Lütfen konsol çıktısını denetleyin.","ui.task.error":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.failed":"Contao Manager bir arka plan görevini başlatamadı!","ui.task.failedDescription1":"İşlemler arka planda yürütülmeye çalışılırken bir sorun çıktı.","ui.task.failedDescription2":"Bu sorun yeniden yaşanırsa sunucunuz desteklenmiyor olabilir.","ui.task.reportProblem":"Sorun bildir","ui.task.pausedDescription":"Hatayı yok saymak ve kalan işlemleri gerçekleştirmek istiyorsanız \\"İlerle\\" üzerine tıklayın.","ui.task.sponsor":"Composer Cloud {sponsor} tarafından destekleniyor","ui.task.buttonAudit":"Veri tabanını güncelle","ui.task.buttonClose":"Kapat","ui.task.buttonConfirm":"Onaylayıp kapat","ui.task.buttonContinue":"İlerle","ui.task.buttonCancel":"İptal","ui.task.confirmCancel":"Bu görevi iptal etmek istediğinize emin misiniz? Bu durum Contoa kurulumunuzu bozuk bir durumda bırakabilir!","ui.task.autoclose":"Başarılı işlemlerin görev ayrıntıları kapatılsın","ui.console.toggle":"Konsol çıktısını görüntüle/gizle","ui.console.showLog":"Tüm konsol günlüğünü görüntüle","ui.console.copyLog":"Günlüğü panoya kopyala","ui.migrate.headline":"Veri tabanı güncellemeleri","ui.migrate.migrationsOnly":"(yalnızca aktarımlar)","ui.migrate.schemaOnly":"(yalnızca şema)","ui.migrate.loading":"Lütfen veri tabanınız incelenirken bekleyin…","ui.migrate.empty":"Bekleyen bir aktarım ya da şema güncellemesi bulunamadı. Veri tabanınız güncel.","ui.migrate.emptyMigrations":"Bekleyen bir aktarım bulunamadı. Şema güncellemelerini de denetlediğinizden emin olun.","ui.migrate.emptySchema":"Bekleyen bir şema güncellemesi bulunamadı. Aktarımları da denetlediğinizden emin olun.","ui.migrate.pending":"Veri tabanınız güncel değil. Lütfen aşağıdaki konsol çıktısını denetleyip istenilen değişiklikleri yapın.","ui.migrate.previousChanges":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.previousComplete":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış. Lütfen aşağıdaki konsol çıktısını denetleyin. Bekleyen başka bir değişiklik yok.","ui.migrate.appliedChanges":"Veri tabanı güncellemeleri yapıldı.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.appliedComplete":"Veri tabanı güncellemeleri yapıldı.\\nBekleyen başka bir aktarım ya da şema güncellemesi yok. Veri tabanınız güncel.","ui.migrate.problem":"Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin. | Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin.","ui.migrate.warning":"Contao, veri tabanı sunucunuzun yanlış yapılandırıldığını algıladı.\\nUyarıları geçici olarak atlayabilirsiniz. Ancak en iyi başarım ve veri bütünlüğü için bu sorunları düzeltmelisiniz.","ui.migrate.error":"Değişiklikler uygulanamadı. Veri tabanınız değişmiş olabilir. Lütfen yeniden denetleyin.","ui.migrate.execute":"Yürüt","ui.migrate.close":"Kapat","ui.migrate.confirm":"Onaylayıp kapat","ui.migrate.cancel":"İptal","ui.migrate.continue":"İlerle","ui.migrate.setup":"Kurulum","ui.migrate.skip":"Atla","ui.migrate.retry":"Yeniden denetle","ui.migrate.retryAll":"Tümünü denetle","ui.migrate.withDeletes":"DROP sorguları ile birlikte tüm veri tabanı değişikliklerini yürütür.","ui.migrate.migrationTitle":"Veri tabanı aktarımları","ui.migrate.schemaTitle":"Şema güncellemeleri","ui.migrate.problemTitle":"Veri tabanı sorunları","ui.migrate.warningTitle":"Veri tabanı uyarıları","ui.migrate.addTable":"{table} tablosunu ekle","ui.migrate.dropTable":"{table} tablosunu sil","ui.migrate.addField":"{table}.{field} alanını ekle","ui.migrate.changeField":"{table}.{field} alanını değiştir","ui.migrate.dropField":"{table}.{field} alanını sil","ui.migrate.createIndex":"{table} tablosuna \\"{name}\\" dizinini ekle ","ui.migrate.dropIndex":"{table} tablosundan \\"{name}\\" dizinini kaldır","ui.widget.mandatory":"Bu alan boş bırakılamaz.","ui.widget.blankOption":"Lütfen seçin…","ui.widget.showPassword":"Parolayı görüntüle","ui.widget.hidePassword":"Parolayı gizle","ui.error.title":"\\"{method} {url}\\" için HTTP isteği başarısız oldu.","ui.error.server500":"Sunucunuzda beklenmeyen bir sorun çıkmış gibi görünüyor. Lütfen site sunucunuzun (Apache/Nginx) günlük dosyalarını ve \\"contao-manager/logs\\" konumundaki Contao Manager günlüklerini denetleyin.","ui.error.response":"Sunucu, {status} durum koduyla bir yanıt verdi.","ui.error.moreLink":"Ayrıntılı bilgiler","ui.error.support":"Contao desteği","ui.error.permission":"Bu özelliği kullanma izniniz yok.","ui.footer.help":"Yardım","ui.footer.reportProblem":"Sorun bildir","ui.navigation.discover":"Keşfet","ui.navigation.packages":"Paketler","ui.navigation.tools":"Araçlar","ui.navigation.installTool":"Kurulum aracı","ui.navigation.backend":"Contao yönetim bölümü","ui.navigation.debug":"Contao hata ayıklama kipi","ui.navigation.logViewer":"Günlük görüntüleyici","ui.navigation.phpinfo":"PHP bilgileri","ui.navigation.phpinfoLoading":"PHP bilgileri yükleniyor…","ui.navigation.maintenance":"Bakım","ui.navigation.rebuildCache":"Ön belleği yeniden oluştur","ui.navigation.users":"Hesaplar","ui.navigation.systemCheck":"Sistem denetimi","ui.navigation.advanced":"Gelişmiş","ui.navigation.logout":"Oturumu kapat","ui.maintenance.database.title":"Veri tabanı aktarımları ve yedekler","ui.maintenance.database.description":"Veri tabanı aktarımları verilerin ve tablo şemalarının tutarlı olduğundan emin olur.","ui.maintenance.database.migrations":"Bekleyen bir veri tabanı aktarımı var | Bekleyen {count} veri tabanı aktarımı var","ui.maintenance.database.schemaUpdates":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var","ui.maintenance.database.error":"Veri tabanı sorunu bulundu.","ui.maintenance.database.warning":"Veri tabanı uyarıları bulundu.","ui.maintenance.database.button":"Veri tabanını denetle","ui.maintenance.database.migrationOnly":"Yalnızca aktarımları denetle","ui.maintenance.database.schemaOnly":"Yalnızca şemayı denetle","ui.maintenance.database.installTool":"Kurulum aracını aç","ui.maintenance.database.createBackup":"Yedek oluştur","ui.maintenance.database.backupUnsupported":"Contao sürümünüzde veri tabanı yedekleri desteklenmiyor.","ui.maintenance.database.backupList":"{date} tarihinde oluşturulmuş bir veri tabanı yedeğiniz var. | {count} veri tabanı yedeğiniz var. En sonuncusu {date} tarihinde oluşturulmuş.","ui.maintenance.database.backupEmpty":"Şu anda herhangi bir veri tabanı yedeğiniz yok.","ui.maintenance.rebuildCache.title":"Uygulama ön belleği","ui.maintenance.rebuildCache.description":"Yapılandırma dosyalarında bir değişiklik yapıldığında uygulama ön belleğinin yeniden oluşturulması gerekir.","ui.maintenance.rebuildCache.rebuildProd":"Üretim ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.rebuildDev":"Geliştirme ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.clearProd":"Üretim ön belleğini temizle","ui.maintenance.rebuildCache.clearDev":"Geliştirme ön belleğini temizle","ui.maintenance.installTool.title":"Contao kurulum aracı","ui.maintenance.installTool.description":"Arka arkaya üç kez yanlış parola yazarsanız Contao kurulum aracı otomatik olarak kilitlenir.","ui.maintenance.installTool.unlock":"Kurulum aracının kilidini aç","ui.maintenance.installTool.lock":"Kurulum aracını kilitle","ui.maintenance.dumpAutoload.title":"Composer sınıf yükleyicisi","ui.maintenance.dumpAutoload.description":"Composer otomatik yükleyici, PHP sınıfının yüklenmesinden sorumludur. Kök klasördeki composer.json dıosyasına özel ad alanları eklendikten sonra otomatik yükleyici indirilmelidir.","ui.maintenance.dumpAutoload.button":"Otomatik yükleyiciyi indir","ui.maintenance.composerInstall.title":"Composer bağımlılıkları","ui.maintenance.composerInstall.description":"Composer bağımlılıkları uygulama kök klasörünüzün altındaki [vendor] klasöründe bulunur. [composerLock] dosyası değiştirildikten ya da el ile yüklendikten sonra bağımlılıkları yeniden kurmak gerekebilir.","ui.maintenance.composerInstall.button":"Kurucuyu başlat","ui.maintenance.composerInstall.update":"Composer güncellemesini başlat","ui.maintenance.composerCache.title":"Composer ön belleği","ui.maintenance.composerCache.description":"Composer, daha iyi başarım sağlamak için indirilen paketleri ön belleğe alır. Ön bellekte bozuk dosyalar gibi sorunlarınız varsa, paketlerin yeniden indirilmesini dayatmak için Composer ön belleğini silmeyi deneyin.","ui.maintenance.composerCache.button":"Ön belleği temizle","ui.maintenance.maintenanceMode.title":"Bakım kipi","ui.maintenance.maintenanceMode.description":"Contao bakım kipine geçirildiğinde, sitede \\"503 Hizmet Kullanılamıyor\\" kalıbı görüntülenir.","ui.maintenance.maintenanceMode.enable":"Etkinleştir","ui.maintenance.maintenanceMode.disable":"Etkisizleştir","ui.maintenance.debugMode.title":"Hata ayıklama kipi","ui.maintenance.debugMode.description":"[appDevPhp] giriş noktası için bir kullanıcı adı ve parola ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.descriptionJwt":"Geçerli etki alanı için hata ayıklama çerezini ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.activate":"Etkinleştir","ui.maintenance.debugMode.deactivate":"Etkisizleştir","ui.maintenance.debugMode.credentials":"Kimlik doğrulama bilgileri","ui.maintenance.debugMode.user":"Lütfen hata ayıklama kipi için bir kullanıcı adı yazın.","ui.maintenance.debugMode.password":"Lütfen hata ayıklama kipi için bir parola yazın.","ui.maintenance.opcodeCache.title":"Opcode ön belleği","ui.maintenance.opcodeCache.description":"Opcode, daha hızlı işlem yapmak için PHP dosyalarını site işleminde ön belleğe alır. Dosyaların değiştirildikten sonra tanınmaması gibi belirli durumlarda silinmelidir.","ui.maintenance.opcodeCache.button":"Ön belleği buda","ui.maintenance.safeMode":"Güvenli kipte kullanılamaz","ui.maintenance.unsupported":"Contao sürümünüz tarafından desteklenmiyor","ui.packages.updateButton":"Paketleri güncelle","ui.packages.searchButton":"Paket arama","ui.packages.searchPlaceholder":"Paketleri ara…","ui.packages.uploadOverlay":"Yüklemek için dosyaları sürükleyip buraya bırakın","ui.packages.uploadButton":"Paketleri yükle","ui.packages.uploadMessage":"Bir onaylanmamış yüklemeniz var. | {count} onaylanmamış yüklemeniz var.","ui.packages.uploadApply":"Yüklemeleri onayla","ui.packages.uploadReset":"Yüklemeleri sil","ui.packages.uploadIncomplete":"Bu dosya tam olarak yüklenmedi. Lütfen kaldırıp yeniden deneyin.","ui.packages.uploadDuplicate":"Bu dosya birden çok kez yüklenmiş gibi görünüyor. Lütfen kopyaları kaldırın.","ui.packages.uploadInstalled":"Bu dosya zaten kurulmuş. Lütfen kopyaları kaldırın.","ui.packages.uploadUnsupported":"Kurulumunuzda yükleme özelliği desteklenmiyor. Lütfen PHP ZIP eklentisinin kurulmuş olduğundan ve bağımlılıklarınızı güncellediğinizden emin olun.","ui.packages.changesMessage":"Bir onaylanmamış değişikliğiniz var. | {count} onaylanmamış değişikliğiniz var.","ui.packages.changesDryrun":"Değişiklik yapmadan dene","ui.packages.changesApply":"Değişiklikleri uygula","ui.packages.changesApplyAll":"Tüm paketleri güncelle","ui.packages.changesDryrunAll":"Tüm paketleri değişiklik yapmadan dene","ui.packages.changesReset":"Değişiklikleri sıfırla","ui.packages.changesReview":"Değişiklikleri gözden geçir","ui.packagelist.loading":"Yükleniyor…","ui.packagelist.uploads":"Yüklemeler","ui.packagelist.added":"Yeni paketler","ui.packagelist.installed":"Kurulmuş paketler","ui.package.hintRevert":"Değişiklikleri geri al","ui.package.hintNoupdate":"Güncelleme","ui.package.hintConstraint":"Değişiklikleri uyguladığınızda, bu paket {constraint} kısıtlaması ile kurulacak.","ui.package.hintConstraintBest":"Değişiklikleri uyguladığınızda, bu paket kullanılabilecek en iyi sürüm ile kurulacak.","ui.package.hintConstraintChange":"Değişiklikleri uyguladığınızda, bu paketin kısıtlamaları \\"{from}\\" yerine \\"{to}\\" olarak değiştirilecek.","ui.package.hintConstraintUpdate":"Değişiklikleri uyguladığınızda, bu paket güncellenecek.","ui.package.hintAdded":"Değişiklikleri uyguladığınızda, bu paket kurulacak.","ui.package.hintRemoved":"Değişiklikleri uyguladığınızda, bu paket kaldırılacak.","ui.package.requiredTitle":"el ile eklendi","ui.package.requiredText":"Bu paket composer.json dosyanızda gerekli olarak belirtilmiş ancak kurulmamış.","ui.package.removedTitle":"el ile kaldırıldı","ui.package.removedText":"Bu paket composer.json dosyanızdan kaldırılmış.","ui.package.installed":"Şu anda kurulu olan:","ui.package.version":"{version} sürümü","ui.package.additionalDownloads":"{count} indirme | {count} indirme","ui.package.additionalStars":"{count} yıldız | {count} yıldız","ui.package.editConstraint":"Düzenle","ui.package.uploadConstraint":"Bu kısıtlama yüklenen paket tarafından tanımlandı.","ui.package.updateButton":"Güncelle","ui.package.removeButton":"Kaldır","ui.package.installButton":"Paket ekle","ui.package.installButtonShort":"Ekle","ui.package.detailsButton":"Ayrıntılar","ui.package.latestConstraint":"güncel sürüm","ui.package.update":"Güncelleme yayınlanmış","ui.package.updateLatest":"güncel sürüm","ui.package.updateAvailable":"{version} yayınlanmış","ui.package.updateUnknown":"sürüm bilinmiyor","ui.package.updateConstraint":"Sürüm kısıtlamanızın dışında yeni bir sürüm yayınlanmış.","ui.package.incompatible":"{package} Contao {constraint} ile çalışmayacak.","ui.package.incompatibleWarning":"{package} does not work with Contao {constraint} in any of its stable releases. Do you want to add the package and set a version constraint to try installing a development branch?","ui.package.incompatibleConstraint":"This package does not have a stable release for Contao {constraint}. Set a version constraint to try installing a development branch.","ui.package.incompatibleButton":"Kur","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"{version} sürümü","ui.cloudStatus.waitingTime":"Bekleme zamanı","ui.cloudStatus.jobs":"Geçerli görevler","ui.cloudStatus.workers":"İşlemler","ui.cloudStatus.approx":"{minutes} dakika","ui.cloudStatus.none":"yok","ui.cloudStatus.short":"ca. {minutes} dakika","ui.cloudStatus.long":"ca. {minutes} dakika {seconds} saniye","ui.cloudStatus.error":"Composer Resolver Cloud durumu alınamıyor. Kaynak bakım yüzünden kapalı ya da sorunlar nedeniyle erişilemiyor olabilir.","ui.cloudStatus.button":"Cloud durumu","ui.cloudStatus.refresh":"Cloud durumunu yenile","ui.log-viewer.loading":"Yükleniyor…","ui.log-viewer.empty":"Sunucunuzda herhangi bir günlük dosyası yok.","ui.log-viewer.reload":"Yeniden yükle","ui.log-viewer.file":"Günlük dosyası","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Bu iletinin günlüğe kaydedileceği kanal.","ui.log-viewer.level":"Düzey","ui.log-viewer.levelTitle":"Günlük iletisinin önem düzeyi.","ui.log-viewer.timeHeader":"Zaman","ui.log-viewer.messageHeader":"İleti","ui.log-viewer.showContext":"Bağlamı görüntüle","ui.log-viewer.hideContext":"Bağlamı gizle","ui.log-viewer.showExtra":"Ekleri görüntüle","ui.log-viewer.hideExtra":"Ekleri gizle","ui.log-viewer.more":"Sonrakileri yükle…","ui.log-viewer.download":"İndir","ui.log-viewer.downloadTitle":"\\"{file}\\" dosyasını indir","ui.log-viewer.prodEnvironment":"Üretim ortamı","ui.log-viewer.devEnvironment":"Geliştirme ortamı (hata ayıklama kipi)","ui.user-manager.loading":"Kullanıcılar yükleniyor…","ui.user-manager.changePassword":"Parolayı değiştir","ui.user-manager.setupTotp":"İki adımlı doğrulamayı kur","ui.user-manager.disableTotp":"İki adımlı doğrulamayı kapat","ui.user-manager.invite":"Kullanıcı davet et","ui.user-manager.delete":"Sil","ui.user-manager.deleteConfirm":"\\"{username}\\" kullanıcısını silmek istediğinize emin misiniz?","ui.user-manager.deleted":"{username} kullanıcı adı silindi","ui.user-manager.passwordHeadline":"Parolayı değiştir","ui.user-manager.passwordText":"Parolanızı değiştirmek için, ilgili alanlara geçerli ve yeni parolayı yazın.","ui.user-manager.currentPassword":"Geçerli parola","ui.user-manager.newPassword":"Yeni parola","ui.user-manager.passwordPlaceholder":"en az 8 karakter","ui.user-manager.submitPassword":"Gönder","ui.user-manager.passwordChanged":"Parolanız değiştirildi.","ui.user-manager.passwordError":"Parola yanlış.","ui.user-manager.inviteHeadline":"Kullanıcı davet et","ui.user-manager.inviteText":"Contao Manager için birden fazla oturum açmaya gerek duyuyorsanız, buradan bir davet bağlantısı oluşturabilirsiniz. Bu bağlantıyı biriyle paylaşın veya verilen izinlerle yeni bir hesap açmak için başka bir aygıt üzerinde kullanın.","ui.user-manager.inviteSuccess1":"Yeni bir davet bağlantısı oluşturuldu. Aşağıdaki adres, bu Contao Manager üzerinde yeni bir kullanıcı hesabı oluşturmak için kullanılabilir. Davetiyenin geçerliliği {expires} tarihinde sona erecek (bir hafta sonra).","ui.user-manager.inviteSuccess2":"Lütfen bağlantıyı panonuza kopyalayın. Yalnızca bir kez çalışacak ve bu pencereyi kapattıktan sonra yeniden göremeyeceksiniz.","ui.user-manager.createInvitation":"Davet bağlantısı oluştur","ui.user-manager.clipboard":"Panoya kopyala","ui.user-manager.permissions":"İzinler hakkında bilgi alın","ui.user-manager.cancel":"İptal","ui.user-manager.close":"Kapat","ui.user-manager.you":"Siz","ui.user-manager.2fa":"İki adımlı doğrulama","ui.user-manager.2faEnabled":"Bu hesap iki adımlı doğrulama ile korunuyor.","ui.user-manager.2faDisabled":"Bu hesap iki adımlı doğrulama kullanmadığından güvende değil.","ui.user-manager.passkey":"Geçiş anahtarı","ui.user-manager.passkeyTitle":"Bu hesap bir geçiş anahtarı ile korunuyor.","ui.totp.headline":"İki adımlı doğrulama","ui.totp.setupQr":"Lütfen kare kodu iki adımlı doğrulama uygulamanızla tarayın.","ui.totp.setupCode":"Kare kodu tarayamıyorsanız şu anahtarı yazabilirsiniz:","ui.totp.codeLabel":"Doğrulama kodu","ui.totp.codeDescription":"Lütfen iki adımlı doğrulama uygulamanızın ürettiği doğrulama kodunu yazın.","ui.totp.disableText":"İki adımlı doğrulamayı kapatmak için lütfen doğrulama kodunu yazın.","ui.totp.invalid":"Doğrulama kodu geçersiz.","ui.totp.enable":"Etkinleştir","ui.totp.disable":"Etkisizleştir","ui.totp.cancel":"İptal","ui.totp.enabled":"İki adımlı doğrulama açıldı.","ui.totp.disabled":"İki adımlı doğrulama kapatıldı.","ui.totp.setup":"İki adımlı doğrulamayı kur","ui.totp.skip":"İki adımlı doğrulamayı atla"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[553],{5553:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Insecure Connection !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"More Info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.limitedHeadline":"Remote Authentication","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"Unexpected API status","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"User Account","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"Username","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 characters","ui.account.passwordLength":"Please enter at least 8 characters.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Create Account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Sign In","ui.login.description":"Login to manage your installation.","ui.login.username":"Username","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Forgot your password?","ui.login.button":"Sign In","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Cancel","ui.login.or":"or","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Logout","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.boot.safeMode":"Launch in Safe Mode","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Details","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.cancel":"Cancel","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.config.cloudEnabled":"Package dependencies will be resolved using the Composer Resolver Cloud.","ui.server.config.cloudDisabled":"The Composer Resolver Cloud is disabled.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Install","ui.server.contao.title":"Contao Installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Check database","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continue","ui.setup.manager":"Launch Contao Manager","ui.setup.cancel":"Cancel","ui.setup.welcome":"Welcome","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao Installation","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Latest","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimal Installation (Core only)","ui.setup.create-project.noUpdate":"Skip Installation (Expert Only!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Cancel","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Username","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Save","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Create Account","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Username","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 characters","ui.setup.backend-user.passwordLength":"Please enter at least 8 characters.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.paused":"A background operation stopped unexpectedly. Please check the console output.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Report a Problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Close","ui.task.buttonConfirm":"Confirm & Close","ui.task.buttonContinue":"Continue","ui.task.buttonCancel":"Cancel","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Close","ui.migrate.confirm":"Confirm & Close","ui.migrate.cancel":"Cancel","ui.migrate.continue":"Continue","ui.migrate.setup":"Setup","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"This field must not be empty.","ui.widget.blankOption":"Please select …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"More Information","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Help","ui.footer.reportProblem":"Report a Problem","ui.navigation.discover":"Discover","ui.navigation.packages":"Packages","ui.navigation.tools":"Tools","ui.navigation.installTool":"Install Tool","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP Information","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Rebuild Cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"Advanced","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Update Packages","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"Loading …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Revert Changes","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Edit","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Remove","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Details","ui.package.latestConstraint":"latest version","ui.package.update":"Update available","ui.package.updateLatest":"latest version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.package.incompatibleWarning":"{package} does not work with Contao {constraint} in any of its stable releases. Do you want to add the package and set a version constraint to try installing a development branch?","ui.package.incompatibleConstraint":"This package does not have a stable release for Contao {constraint}. Set a version constraint to try installing a development branch.","ui.package.incompatibleButton":"Install","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Loading …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 characters","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Cancel","ui.user-manager.close":"Close","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Enable","ui.totp.disable":"Disable","ui.totp.cancel":"Cancel","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{7542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[874],{2874:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozšíření Contaa","ui.app.loading":"Načítání seznamu rozšíření...","ui.app.language":"Změnit jazyk Správce Contaa","ui.app.colorDark":"Tmavé zobrazení","ui.app.colorDarkTitle":"Změnit na tmavé prostředí","ui.app.colorLight":"Světlé zobrazení","ui.app.colorLightTitle":"Změnit na světlé prostředí","ui.discover.advertisement":"Reklama v seznamu rozšíření","ui.discover.loading":"Spouštění…","ui.discover.offline":"Nemůžu načíst žádné výsledky.","ui.discover.offlineExplain":"Zkontrolujte prosím Vaše internetové připojení a deaktivujte blokování JavaScriptu ve Vašem prohlížeči.","ui.discover.offlineButton":"Zkusit znovu","ui.discover.searchPlaceholder":"Prohledat {count} rozšíření...","ui.discover.empty":"Žádné výsledky pro {query}","ui.discover.more":"Více výsledků","ui.discover.sortBy":"Seřadit podle","ui.discover.sortReleased":"Zveřejněno","ui.discover.sortReleasedTitle":"Seřadit výsledky podle zveřejnění","ui.discover.sortLatest":"Zaktualizované","ui.discover.sortLatestTitle":"Seřadit výsledky podle naposledy zaktualizovaných","ui.discover.sortDownloads":"Stažení","ui.discover.sortDownloadsTitle":"Seřadit výsledky podle počtu stažení","ui.discover.sortFavers":"Hodnocení","ui.discover.sortFaversTitle":"Seřadit výsledky podle hodnocení","ui.discover.detailsButton":"Podrobnosti","ui.discover.latestPackages":"Poslední a naposledy zaktualizovaná rozšíření","ui.discover.faversPackages":"Nejlépe hodnocená rozšíření","ui.discover.downloadsPackages":"Nejvíce stahovaná rozšíření","ui.discover.exactHit":"Přesný souhlas query","ui.discover.results":"Více výsledků vyhledávání","ui.package.homepage":"Stránka projektu","ui.package.private":"Soukromý balíček","ui.package.privateTitle":"Soukromé balíčky jsou dostupné pouze z vendoru (např. jako soubor ZIP). Více informací získáte na následujícím webu. ","ui.package.abandoned":"nepřijatý","ui.package.abandonedText":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí.","ui.package.abandonedReplace":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí. Autor místo něho doporučuje použít {replacement}. ","ui.package.contaoVersion":"Dostupné pro Contao","ui.package-details.previous":"Předešlé podrobné informace k rozšíření","ui.package-details.close":"Zavřít podrobné informace k rozšíření","ui.package-details.loading":"Spouštění…","ui.package-details.tabDescription":"Popis","ui.package-details.tabRequire":"Požadavky","ui.package-details.tabFeatures":"Funkce","ui.package-details.tabSuggest":"Doporučení","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Závislosti","ui.package-details.linkRequires":"vyžaduje","ui.package-details.linkReplaces":"nahrazuje","ui.package-details.linkProvides":"poskytuje","ui.package-details.linkConflicts":"konflikty","ui.package-details.funding":"Nalezen vyvíjený balíček!","ui.package-details.contaoVersions":"Podporováno verzí Contaa","ui.package-details.latest":"Poslední verze","ui.package-details.released":"Zveřejněno","ui.package-details.license":"Licence","ui.package-details.authors":"od","ui.package-details.more":"Více","ui.package-details.packagist":"Podrobnosti k balíčku","ui.package-details.metadata":"Upravit meta informace","ui.package-details.support_docs":"Dokumentace","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Podpora ve fóru","ui.package-details.support_issues":"Chyby / nahlášení chyb","ui.package-details.support_source":"Zdrojový kód","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Mail podpory","ui.package-details.support_rss":"Kanál RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[139],{4139:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! اتصال ناامن !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"اطلاعات بیشتر","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"وضعیت API غیرمنتظره","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"حساب کاربری","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"نام کاربری","ui.account.password":"گذرواژه","ui.account.passwordConfirm":"تایپ مجدد گذرواژه","ui.account.passwordPlaceholder":"حداقل ۸ نویسه","ui.account.passwortLength":"لطفا حداقل ۸ نویسه وارد نمایید.","ui.account.passwortDifferent":"The password does not match the confirmation.","ui.account.submit":"ایجاد حساب","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"ورود","ui.login.description":"برای مدیریت نصب‌تان وارد شوید.","ui.login.username":"نام کاربری","ui.login.password":"گذرواژه","ui.login.forgotPassword":"گذرواژه‌ی خود را فراموش کرده‌اید؟","ui.login.button":"ورود","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"خروج","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"جزئیات","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.blankOption":"Please select …","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"لطفا مسیر باینری PHP‌ تان را وارد نمایید. مطمئن شوید که باینری همان نسخه‌ی PHP روند وب‌تان باشد.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Run Composer","ui.server.composer.safeMode":"Run Safe Mode","ui.server.contao.title":"نصب کانتائو","ui.server.contao.setup":"Setup","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.headline":"Contao Setup","ui.server.contao.description":"Welcome to the setup process of your Contao Open Source CMS. You can choose between two versions to install.","ui.server.contao.publicDir":"Use {dir} for public files (for Contao {version})","ui.server.contao.ltsTitle":"Long Term Support","ui.server.contao.ltsText":"The LTS version has an extended support period of up to four years.","ui.server.contao.latestTitle":"Latest","ui.server.contao.latestText":"A new latest version is released every six months in February and August.","ui.server.contao.noLatest":"Requires at least PHP {version}.","ui.server.contao.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.server.contao.releaseplanLink":"Contao Release Plan","ui.server.contao.formTitle":"نصب کانتائو","ui.server.contao.formText":"نسخه‌ی کانتائو برای نصب را انتخاب کنید.","ui.server.contao.version":"نسخه","ui.server.contao.coreOnly":"Initial Setup","ui.server.contao.coreOnlyNo":"Full Installation (News, Calendar, etc.)","ui.server.contao.coreOnlyYes":"Minimal Installation (Core only)","ui.server.contao.coreOnlyFeatures":"What\'s the difference?","ui.server.contao.noUpdate":"Skip Installation (Expert Only!)","ui.server.contao.install":"Finish","ui.server.docroot.headline":"Webserver Setup","ui.server.docroot.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.server.docroot.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed right now, because your folder structure is not correct or the folders are not empty.","ui.server.docroot.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.server.docroot.documentation":"Read the Documentation","ui.server.docroot.conflictsTitle":"Installation directory not empty","ui.server.docroot.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and reload the page if you are sure they are unused.","ui.server.docroot.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.server.docroot.create":"Create directories","ui.server.docroot.formTitle":"Directory Setup","ui.server.docroot.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.server.docroot.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.server.docroot.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.server.docroot.directory":"New Directory","ui.server.docroot.currentRoot":"Current Document Root","ui.server.docroot.newRoot":"New Document Root","ui.server.docroot.finish":"Setup Directories","ui.server.docroot.directoryInvalid":"Please enter a valid directory name.","ui.server.docroot.directoryExists":"The target directory already exists. Please enter a different name.","ui.server.docroot.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.server.docroot.reload":"Reload Page","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"گزارش یک مشکل","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"بستن","ui.task.buttonConfirm":"تایید و بستن","ui.task.buttonCancel":"لغو","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.widget.mandatory":"این فیلد نباید خالی باشد.","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"اطلاعات بیشتر","ui.error.support":"Contao Support","ui.footer.help":"کمک","ui.footer.reportProblem":"گزارش یک مشکل","ui.navigation.discover":"Discover","ui.navigation.packages":"بسته‌ها","ui.navigation.tools":"ابزارها","ui.navigation.installTool":"ابزار نصب","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.phpinfo":"PHP Information","ui.navigation.maintenance":"نگهداشت","ui.navigation.rebuildCache":"بازسازی نهان‌گاه","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"پیشرفته","ui.navigation.logout":"خروج","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"بروزرسانی بسته‌ها","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure to update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"بارگذاری ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"بازگرداندن تغییرات","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"این بسته با محدودیت بهترین {constraint} نصب خواهد شد وقتی شما تغییرات را اعمال کنید.","ui.package.hintConstraintBest":"این بسته در بهترین نسخه‌ی موجود نصب خواهد شد وقتی شما تغییرات را اعمال کنید.","ui.package.hintConstraintChange":"محدودیت برای این بسته از «{from}» به «{to}» وقتی شما تغییرات را اعمال کنید تغییر داده خواهد شد.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"این بسته حذف خواهد وقتی شما تغییرات را اعمال کنید.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"نسخه {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"ویرایش","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"حذف","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"جزئیات","ui.package.latestConstraint":"آخرین نسخه","ui.package.update":"Update available","ui.package.updateLatest":"آخرین نسخه","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"نسخه {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[638],{3638:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Niebezpieczne połączenie !!","ui.app.httpsDescription":"Bez HTTPS twoje poufne dane będą wysyłane bez szyfrowania.","ui.app.httpsLink":"Więcej informacji","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Bezpieczny Tryb włączony !!","ui.app.safeModeDescription":"Niektóre funkcje Contao Manager nie są dostępne.","ui.app.safeModeExit":"Wyłącz Bezpieczny Tryb","ui.app.limitedHeadline":"Zdalne Poświadczenie","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Instalacja","ui.app.loading":"Ładowanie Contao Manager …","ui.app.apiError":"Nieoczekiwany status API","ui.app.configSecurity1":"ALERT BEZPIECZEŃSTWA !!! Wykryto niezabezpieczony folder konfiguracji","ui.app.configSecurity2":"Contao Manager wykrył, że pliki konfiguracji są dostępne publicznie. Wszystkie operacje zostały zablokowane do czasu, aż folder zostanie zabezpieczony. W przeciwnym wypadku atakujący mógłby uzyskać dostęp do wrażliwych danych twojej instalacji.\\n\\nAby naprawić ten problem, zabezpiecz dostęp do katalogu \\"contao-manager\\" na serwerze. Jeśli nie wiesz jak to zrobić, odwołaj się dokumentacji twojego serwera lub skontaktuj z dostawcą usług.","ui.account.welcome":"Witaj","ui.account.intro1":"Witaj w Contao Manager, uniwersalnym narzędziu do instalacji i zarządzania Contao Open Source CMS. Jeśli jesteś tu nowy, proszę {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, żeby zacząć","ui.account.introManual":"przeczytaj instrukcję","ui.account.intro2":"Jeśli masz jakiekolwiek problemy, sprawdź {ourGithubIssues} i utwórz nowe zgłoszenie na dowolny temat, który nie był jeszcze raportowany.","ui.account.introIssues":"naszą listę problemów na GitHub","ui.account.headline":"Konto użytkownika","ui.account.description":"Aby zarządzać twoją instalacją, utwórz konto w Contao Manager. Uwaga – to konto nie jest powiązane z kontem w backendzie ani frontendzie Contao!","ui.account.username":"Nazwa użytkownika","ui.account.password":"Hasło","ui.account.passwordPlaceholder":"min 8 znaków","ui.account.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Utwórz konto","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao i Contao Manager są sponsorowane przez charytatywną organizację Contao Association.","ui.account.contribute2":"Rozważ uczestnictwo w projektach open source poprzez {donate}.","ui.account.contributeDonate":"przekazanie darowizny","ui.login.headline":"Zaloguj się","ui.login.description":"Zaloguj się, aby zarządzać instalacją.","ui.login.username":"Nazwa użytkownika","ui.login.password":"Hasło","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Zapomniałeś hasła?","ui.login.button":"Zaloguj się","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Anuluj","ui.login.or":"lub","ui.login.locked":"Odmówiono dostępu, ponieważ Contao Manager jest zablokowany. Aby odblokować, usuń plik {lockFile} w folderze głównym instalacji Contao.","ui.logout.headline":"Limit czasu sesji","ui.logout.warning":"Byłeś nieaktywny przez więcej niż 25 minut. Z powodu bezpieczeństwa twoja sesja zostanie wkrótce zakończona.","ui.logout.expired":"Twoja sesja została zakończona, ponieważ byłeś nieaktywny przez więcej niż 30 minut.","ui.logout.renew":"Nie wylogowuj się","ui.logout.logout":"Wyloguj","ui.logout.login":"Powrót do logowania","ui.oauth.error":"Nieudana próba OAuth. Sprawdź parametry żądania.","ui.oauth.https":"URI przekierowania MUSI używać bezpiecznego protokołu (https:), aby nie przesyłać tokena poświadczenia otwartym tekstem.","ui.oauth.headline":"Zdalne Poświadczenie","ui.oauth.description":"Następująca aplikacja lub usługa żąda zdalnego dostępu do twojej instancji Contao Manager.","ui.oauth.domain":"Zanim zezwolisz na dostęp, upewnij się, że znasz ten adres URL i ufasz jego właścicielowi!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Zezwól na dostęp","ui.oauth.deny":"Odmów dostępu","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sprawdzenie Systemu","ui.boot.description":"Proszę czekać, analizujemy twój serwer …","ui.boot.issue1":"Wykryto nieprawidłowości instalacji","ui.boot.issue2":"Twoja instalacja zawiera błędy, które muszą być rozwiązane, zanim zaczniesz używać Contao Manager.","ui.boot.run":"Otwórz Contao Manager","ui.boot.safeMode":"Uruchom w Bezpiecznym Trybie","ui.recovery.headline":"Odzyskiwanie Systemu","ui.recovery.description":"Contao Manager wykrył pliki, które wyglądają jak z Contao, ale interfejs linii komend (CLI) nie działa tak jak powinien.","ui.recovery.console":"Wyjście Konsolie","ui.recovery.repairOptions":"Wybierz opcję naprawy twojej instalacji.","ui.recovery.repairHeadline":"Automatyczna Naprawa","ui.recovery.repairDescription":"Próba automatycznego naprawienia instalacji poprzez przebudowanie pamięci cache aplikacji i ponownej instalacji pakietów Composera.","ui.recovery.repairWarning":"Jakakolwiek modyfikacja plików vendor może zostać skasowana podczas tego procesu!","ui.recovery.repairFailed":"Automatyczna naprawa nie zakończyła się sukcesem. Spróbuj Bezpiecznego Trybu w celu naprawy instalacji.","ui.recovery.repairButton":"Uruchom naprawę systemu","ui.recovery.safeModeHeadline":"Bezpieczny Tryb","ui.recovery.safeModeDescription":"Uruchamianie Contao Managera w Bezpiecznym Trybie pozwala na zarządzanie pakietami i wykonywanie określonych czynności konserwacyjnych, ale funkcje, które wymagają działającego Contao będą niedostępne.","ui.recovery.safeModeButton":"Uruchom w Bezpiecznym Trybie","ui.server.pending":"Czekam …","ui.server.running":"Analizuję …","ui.server.error":"Sprawdzenie nie powiodło się z powodu niespodziewanej odpowiedzi serwera.","ui.server.details":"Szczegóły","ui.server.prerequisite":"Sprawdzenie anulowane z powodu brakującego warunku wstępnego.","ui.server.selfUpdate.title":"Aktualizacje Contao Managera","ui.server.selfUpdate.update":"Nowa wersja Contao Managera {latest} jest dostępna.","ui.server.selfUpdate.manualUpdate":"Nowa wersja Contao Managera {latest} jest dostępna. Twój serwer nie wspiera automatycznych aktualizacji, nową wersję możesz pobrać z {download}.","ui.server.selfUpdate.latest":"Używasz najnowszej wersji {current}.","ui.server.selfUpdate.dev":"Buildy deweloperskie nie wspierają automatycznych aktualizacji.","ui.server.selfUpdate.unsupported":"Nowa wersja jest dostępna, ale nie wspiera ona twojej wersji PHP.","ui.server.selfUpdate.button":"Uruchom Aktualizację","ui.server.selfUpdate.continue":"Kontynuuj","ui.server.config.title":"Konfiguracja Serwera","ui.server.config.setup":"Konfiguruj","ui.server.config.change":"Zmień","ui.server.config.save":"Zapisz","ui.server.config.cancel":"Anuluj","ui.server.config.customOption":"Inne …","ui.server.config.description":"Aby zadania w tle poprawnie działały, Contao Manager musi wiedzieć, gdzie znaleźć wykonywalny plik PHP linii komend i jak uruchamiać działania niezależnie od procesów serwera www.","ui.server.config.formTitle":"Konfiguracja Serwera","ui.server.config.formText":"Wprowadź ścieżkę do PHP binary. Upewnij się, że wersja PHP binary jest taka sama jak w procesie web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud pozwala na instalowanie pakietów Composera nawet jeśli twój serwer nie posiada wystarczającej ilości pamięci. Informacja o twoich pakietach będzie przesłana na serwer operowany przez Contao Association.","ui.server.config.cloud":"Użyj Composer Resolver Cloud","ui.server.config.cli":"Plik binarny PHP","ui.server.config.stateErrorCli":"Nie znaleziono poprawnego pliku binarnego PHP na serwerze.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud jest niewspierany.","ui.server.config.stateSuccess":"Plik binarny PHP pod {php_cli}.","ui.server.config.cloudEnabled":"Package dependencies will be resolved using the Composer Resolver Cloud.","ui.server.config.cloudDisabled":"The Composer Resolver Cloud is disabled.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Znaleziono wersję PHP {version}. Zaktualizuj ją do PHP 7 tak szybko, jak to możliwe!","ui.server.php_web.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.composer.title":"Środowisko Composera","ui.server.composer.success":"Brak nieprawidłowości.","ui.server.composer.install":"Pakiety Composera nie są zainstalowane.","ui.server.composer.button":"Instalacja","ui.server.contao.title":"Instalacja Contao","ui.server.contao.setup":"Instalacja","ui.server.contao.check":"Sprawdź bazę danych","ui.server.contao.empty":"Nie znaleziono instalacji Contao.","ui.server.contao.old":"Wersja Contao {version} jest niekompatybilna z Contao Manager, aktualizuj swoją instalację ręcznie.","ui.server.contao.found":"Znaleziono Contao {version} (wersja API {api}).","ui.server.contao.connectionError":"Brak połączenia z serwerem bazy danych.","ui.server.contao.connectionProblem":"Problem z bazą danych został znaleziony.","ui.server.contao.missingUser":"Nie znaleziono konta administratora.","ui.setup.continue":"Kontynuuj","ui.setup.manager":"Otwórz Contao Manager","ui.setup.cancel":"Anuluj","ui.setup.welcome":"Witaj","ui.setup.welcome1":"Ten kreator przeprowadzi Cię przez niezbędne kroki, aby skonfigurować instalację Contao Open Source CMS.","ui.setup.welcome2":"Jeśli masz jakieś pytania, odwiedź dokumentację, fora, kanał Slack i więcej na stronie {support}.","ui.setup.support":"wsparcie społeczności","ui.setup.start":"Rozpocznij","ui.setup.complete":"Gratulacje!","ui.setup.complete1":"Contao {version} zostało zainstalowane pomyślnie.","ui.setup.complete2":"Aby zakończyć proces konfiguracji, otwórz narzędzie instalacyjne, aby skonfigurować połączenie z bazą danych i utworzyć użytkownika.","ui.setup.complete3":"Możesz teraz rozpocząć tworzenie swojej strony internetowej w Contao. Jeśli potrzebujesz dodatkowych rozszerzeń, przejdź dalej do Contao Manager.","ui.setup.installTool":"Otwórz instalator","ui.setup.login":"Zaloguj się do Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Dowiedz się więcej","ui.setup.document-root.headline":"Konfiguracja serwera www","ui.setup.document-root.warning":"Aby zainstalować Contao przez Contao Manager, musisz poprawić ustawienie katalogu głównego - document root - w konfiguracji serwera www.","ui.setup.document-root.description1":"Contao używa osobnego folderu dla plików publicznych, a pliki aplikacji są instalowane w folderze nadrzędnym. Contao nie może być zainstalowany, jeśli struktura folderów nie jest poprawna lub foldery nie są puste.","ui.setup.document-root.description2":"Jeśli wiesz, jak skonfigurować katalog główny - document root, zapoznaj się z dokumentacją Contao lub skontaktuj się z administratorem serwera.","ui.setup.document-root.documentation":"Przeczytaj Dokumentację","ui.setup.document-root.conflictsTitle":"Katalog instalacyjny nie jest pusty","ui.setup.document-root.conflictsDirectory":"Katalog główny Twojej przyszłej instalacji Contao nie jest pusty, znaleźliśmy {count} plik(i), które mogą zostać nadpisane przez proces instalacji. Zaleca się utworzenie pustej struktury katalogów dla Contao, ale możesz również usunąć następujące pliki i sprawdzić ponownie, jeśli jesteś pewien, że są one nieużywane.","ui.setup.document-root.ignoreConflicts":"Chcę zainstalować Contao w katalogu, który nie jest pusty. Rozumiem, że może to spowodować nadpisanie wszelkich istniejących plików na mojej przestrzeni dyskowej.","ui.setup.document-root.check":"Sprawdź ponownie","ui.setup.document-root.create":"Utwórz katalogi","ui.setup.document-root.change":"Zmień katalogi","ui.setup.document-root.formTitle":"Konfiguracja Katalogu","ui.setup.document-root.formText1":"Contao Manager może automatycznie utworzyć nową strukturę katalogów na serwerze.","ui.setup.document-root.formText2":"Będziesz musiał ręcznie skonfigurować nowy katalog główny - document root (np. przez panel administracyjny serwera).","ui.setup.document-root.autoconfig":"Rozumiem, że muszę zmienić konfigurację mojego serwera. Niepoprawne ustawienie katalogu głównego może uniemożliwić działanie Contao Manager i uwidocznić publicznie pliki konfiguracyjne (włącznie ze szczegółami konta i hasłami)!","ui.setup.document-root.directory":"Nowy Katalog","ui.setup.document-root.currentRoot":"Aktualny Katalog Główny","ui.setup.document-root.newRoot":"Nowy Katalog Główny","ui.setup.document-root.finish":"Ustawienia Katalogów","ui.setup.document-root.publicDir":"Użyj {dir} dla plików publicznych (dla Contao {version})","ui.setup.document-root.directoryInvalid":"Wprowadź prawidłową nazwę katalogu.","ui.setup.document-root.directoryExists":"Docelowy katalog już istnieje. Podaj inną nazwę.","ui.setup.document-root.confirmation":"Contao Manager utworzył potrzebne katalogi dla twojej instalacji Contao. Teraz powinieneś skonfigurować główny katalog serwera www - document root. Nie przeładowuj wcześniej tej strony.","ui.setup.document-root.reload":"Przeładuj Stronę","ui.setup.document-root.success":"Struktura katalogów na Twoim serwerze jest ustawiona prawidłowo!","ui.setup.document-root.installingProjectDir":"Pliki aplikacji zostaną zainstalowane w {dir}.","ui.setup.document-root.installingPublicDir":"Pliki publiczne zostaną zainstalowane do {dir}.","ui.setup.document-root.installedProjectDir":"Pliki aplikacji są zainstalowane w {dir}.","ui.setup.document-root.installedPublicDir":"Pliki publiczne są instalowane w {dir}.","ui.setup.create-project.headline":"Instalacja Contao","ui.setup.create-project.description":"Rozwój Contao odbywa się zgodnie z zasadą {semver}, co pół roku wydawana jest nowa wersja minor. Obecnie wspierane wydania to:","ui.setup.create-project.semver":"Wersjonowanie semantyczne","ui.setup.create-project.latestTitle":"Najnowsza","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Nasza najnowsza wersja, oferuje najwięcej funkcji ze wsparciem do lutego {year}.","ui.setup.create-project.latestQ3":"Nasza najnowsza wersja oferuje najwięcej funkcji z wsparciem do sierpnia {year}.","ui.setup.create-project.ltsText":"Nasza aktualna wersja LTS, jeśli stawiasz na stabilność. Oferuje długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.pltsText":"Poprzednia wersja LTS, nadal posiada długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.requiresPHP":"Wymaga co najmniej PHP {version}, ty masz PHP {current}.","ui.setup.create-project.releaseplan":"Zobacz {contaoReleasePlan}, aby uzyskać szczegółowe informacje.","ui.setup.create-project.releaseplanLink":"Plan Rozwoju Contao","ui.setup.create-project.installed":"Contao {version} zostało pomyślnie zainstalowane na serwerze. Kontynuuj konfigurację bazy danych lub uruchom Contao Manager, aby zainstalować inną wersję.","ui.setup.create-project.formTitle":"Wybierz dystrybucję","ui.setup.create-project.formText":"Wybierz, która wersja ma być zainstalowana.","ui.setup.create-project.version":"Wersja","ui.setup.create-project.demo":"Zainstaluj witrynę demonstracyjną Contao","ui.setup.create-project.demoDescription":"Strona demonstracyjna pomaga Ci zapoznać się z Contao i wszystkimi jego podstawowymi funkcjami. Więcej motywów można znaleźć w {store}.","ui.setup.create-project.coreOnly":"Minimalna Instalacja (tylko Core)","ui.setup.create-project.noUpdate":"Pomiń Instalację (tylko dla ekspertów!)","ui.setup.create-project.theme":"Motyw Contao","ui.setup.create-project.themeInstall":"Aby zainstalować motyw Contao, użyj pola wyszukiwania lub załaduj plik motywu (.cto/.zip), który obsługuje instalację za pośrednictwem menedżera Contao.","ui.setup.create-project.themeBuy":"Upewnij się, że odwiedzisz oficjalny {sklep}.","ui.setup.create-project.themeStore":"Sklep z motywami Contao","ui.setup.create-project.themeUpload":"Prześlij plik motywu (.cto/.zip)","ui.setup.create-project.themeInvalid":"Przesłany plik nie jest motywem Contao lub nie obsługuje Contao Managera.","ui.setup.create-project.themeWarning":"Contao Manager nie może stwierdzić, czy ten motyw jest kompatybilny z Twoim serwerem. Prosimy skontaktować się z dostawcą motywu, jeśli masz jakiekolwiek pytania.","ui.setup.create-project.themeTitle":"Przejrzyj szczegóły motywu","ui.setup.create-project.themeDetails":"Następujące zależności i pliki zostaną zainstalowane wraz z tym motywem.","ui.setup.create-project.themeRequire":"{count} Zależności | {count} Zależności","ui.setup.create-project.themeFiles":"{count} Plik | {count} Pliki","ui.setup.create-project.theme.or":"lub wyszukaj publiczne motywy","ui.setup.create-project.theme.search":"Wyszukiwanie motywów","ui.setup.create-project.theme.more":"Więcej motywów","ui.setup.create-project.theme.empty":"Brak motywów pasujących do {query}","ui.setup.create-project.theme.uploaded":"Plik motywu został pomyślnie przesłany.","ui.setup.create-project.theme.packageName":"Nazwa pakietu","ui.setup.create-project.theme.version":"Wersja","ui.setup.create-project.theme.authors":"Autor(zy)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Instalacja","ui.setup.create-project.cancel":"Anuluj","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Połączenie z bazą danych","ui.setup.database-connection.description":"Contao wymaga bazy danych MySQL (lub kompatybilnego forka jak MariaDB) do przechowywania stron, treści, użytkowników i innych danych relacyjnych. Parametry połączenia są przechowywane w pliku {env} w katalogu głównym twojej instalacji Contao.","ui.setup.database-connection.formTitle":"Parametry połączenia","ui.setup.database-connection.formText":"Podaj adres URL bazy danych lub wypełnij osobno pola nazwa użytkownika, hasło, serwer i baza danych.","ui.setup.database-connection.url":"URL bazy danych","ui.setup.database-connection.validUrl":"URL bazy danych jest nieprawidłowy lub połączenie z serwerem nie powiodło się.","ui.setup.database-connection.or":"lub","ui.setup.database-connection.user":"Nazwa użytkownika","ui.setup.database-connection.password":"Hasło","ui.setup.database-connection.server":"Serwer (:Port)","ui.setup.database-connection.database":"Nazwa bazy danych","ui.setup.database-connection.connected":"Pomyślnie połączono z bazą danych {database} na {server}.","ui.setup.database-connection.error":"Błąd połączenia z bazą danych.","ui.setup.database-connection.problem":"Contao wykrył problem z serwerem bazy danych.","ui.setup.database-connection.schemaTitle":"Schemat bazy danych","ui.setup.database-connection.migration":"Jest jedna oczekująca migracja. | Jest {count} oczekujących migracji.","ui.setup.database-connection.schema":"Istnieje jedna oczekująca aktualizacja schematu. | Istnieje {count} oczekujących aktualizacji schematu.","ui.setup.database-connection.noChanges":"Schemat Twojej bazy danych jest aktualny.","ui.setup.database-connection.check":"Sprawdź bazę danych","ui.setup.database-connection.skip":"Pomiń","ui.setup.database-connection.save":"Zapisz","ui.setup.database-connection.change":"Zmień dane dostępowe","ui.setup.database-connection.restoreTitle":"Import bazy danych","ui.setup.database-connection.restoreText":"Temat, który właśnie zainstalowałeś, zawiera kopię zapasową bazy danych. Przywróć bazę danych, aby zaimportować dane motywu, lub pomini ten krok, aby rozpocząć instalację Contao od nowa. | Temat, który właśnie zainstalowałeś, zawiera wiele kopii zapasowych bazy danych. Wybierz plik kopii zapasowej do zaimportowania danych motywu lub pomiń ten krok, aby rozpocząć instalację Contao od nowa.","ui.setup.database-connection.backup":"Zrób kopię zapasową bieżącej bazy danych przed importem","ui.setup.database-connection.backupWarning":"Wszystkie dane w bazie danych zostaną nadpisane podczas importu! Jeśli baza danych nie jest pusta, utwórz najpierw kopię zapasową.","ui.setup.database-connection.restore":"Importuj bazę danych motywu","ui.setup.database-connection.restoreOption":"Kopia zapasowa z {date} ({size})","ui.setup.database-connection.restored":"Twoja baza danych motywu została pomyślnie zaimportowana. Kontynuuj walidację schematu bazy danych.","ui.setup.backend-user.success":"W Twojej bazie danych znaleziono konto administratora Contao. Użyj Contao, aby dodać więcej użytkowników.","ui.setup.backend-user.error":"Nie można pobrać listy użytkowników. Sprawdź wynik konsoli w celu uzyskania szczegółów.","ui.setup.backend-user.headline":"Konto użytkownika","ui.setup.backend-user.description":"Aby zarządzać swoją stroną internetową, musisz mieć co najmniej jedno konto administratora w Contao. Należy pamiętać, że to konto nie jest powiązane z Contao Manager.","ui.setup.backend-user.formTitle":"Utwórz konto","ui.setup.backend-user.formText":"Proszę wprowadzić dane dla nowego konta backend.","ui.setup.backend-user.username":"Nazwa użytkownika","ui.setup.backend-user.name":"Nazwa","ui.setup.backend-user.email":"Adres e-mail","ui.setup.backend-user.emailInvalid":"Wprowadź prawidłowy adres e-mail","ui.setup.backend-user.password":"Hasło","ui.setup.backend-user.passwordPlaceholder":"min 8 znaków","ui.setup.backend-user.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.setup.backend-user.create":"Dodaj konto","ui.task.headline":"Zadanie w Tle","ui.task.loading":"Ładowanie szczegółów ...","ui.task.created":"Ładowanie szczegółów ...","ui.task.active":"Czekaj, dopóki trwa wykonywanie zadań w tle przez Contao Manager.","ui.task.complete":"Wszystkie operacje wykonane poprawnie. Sprawdź szczegóły w treści konsoli.","ui.task.paused":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.aborting":"Czekaj, dopóki trwa anulowanie operacji w tle.","ui.task.stopped":"Niektóre operacje w tle zostały anulowane. Zobacz szczegóły w konsoli.","ui.task.error":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.failed":"Contao Manager nie mógł uruchomić zadania w tle!","ui.task.failedDescription1":"Coś poszło źle podczas próby wykonania operacji w tle.","ui.task.failedDescription2":"Jeśli sytuacja się powtórzy, być może twój serwer nie ma wsparcia.","ui.task.reportProblem":"Zgłoś problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorowane przez {sponsor}","ui.task.buttonAudit":"Aktualizacja Bazy Danych","ui.task.buttonClose":"Zamknij","ui.task.buttonConfirm":"Potwierdź i zamknij","ui.task.buttonContinue":"Kontynuuj","ui.task.buttonCancel":"Anuluj","ui.task.confirmCancel":"Czy na pewno chcesz anulować to zadanie? To może pozostawić twoją instalację w nieznanym stanie.","ui.task.autoclose":"Zamknij szczegóły zadania, gdy udane","ui.console.toggle":"Pokaż/Ukryj Konsolę","ui.console.showLog":"Pokaż pełny dziennik konsoli","ui.console.copyLog":"Skopiuj dziennik do schowka","ui.migrate.headline":"Aktualizacje bazy danych","ui.migrate.migrationsOnly":"(tylko migracje)","ui.migrate.schemaOnly":"(tylko struktura)","ui.migrate.loading":"Proszę czekać, sprawdzamy twoją bazę danych …","ui.migrate.empty":"Nie znaleziono żadnych oczekujących migracji ani aktualizacji schematów. Twoja baza danych jest aktualna.","ui.migrate.emptyMigrations":"Nie znaleziono żadnych oczekujących migracji. Upewnij się, że sprawdziłeś również aktualizacje schematu.","ui.migrate.emptySchema":"Nie znaleziono oczekujących aktualizacji schematu. Upewnij się, że sprawdzisz również migracje.","ui.migrate.pending":"Twoja baza danych nie jest aktualna. Proszę przejrzyj poniższe wyjście konsoli i wykonaj zmiany.","ui.migrate.previousChanges":"Poprzednia migracja bazy danych nie została potwierdzona.\\nProszę przejrzeć poniższe wyniki konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.previousComplete":"Poprzednia migracja bazy danych nie została potwierdzona, proszę sprawdzić poniższe wyniki konsoli.\\nNie ma więcej oczekujących zmian.","ui.migrate.appliedChanges":"Aktualizacje bazy danych zostały zastosowane.\\nProszę przejrzeć poniższe wyjście konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.appliedComplete":"Baza danych została zaktualizowana.\\nNie ma więcej oczekujących migracji ani aktualizacji schematu. Twoja baza danych jest aktualna.","ui.migrate.problem":"Contao wykrył problem z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić. | Contao wykrył problemy z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić.","ui.migrate.warning":"Contao wykrył błędną konfigurację serwera bazy danych.\\nOstrzeżenia można tymczasowo pominąć, ale należy je naprawić dla optymalnej wydajności i integralności danych.","ui.migrate.error":"Zmiany nie mogły zostać zastosowane. Twoja baza danych mogła zostać zmieniona, sprawdź ponownie, aby ponowić próbę.","ui.migrate.execute":"Wykonaj","ui.migrate.close":"Zamknij","ui.migrate.confirm":"Potwierdź i zamknij","ui.migrate.cancel":"Anuluj","ui.migrate.continue":"Kontynuuj","ui.migrate.setup":"Instalacja","ui.migrate.skip":"Pomiń","ui.migrate.retry":"Sprawdź ponownie","ui.migrate.retryAll":"Sprawdź wszystkie","ui.migrate.withDeletes":"Wykonaj wszystkie zmiany w bazie danych, włączając zapytania DROP.","ui.migrate.migrationTitle":"Migracje baz danych","ui.migrate.schemaTitle":"Aktualizacje schematu","ui.migrate.problemTitle":"Problemy z bazą danych","ui.migrate.warningTitle":"Ostrzeżenia bazy danych","ui.migrate.addTable":"Dodaj tabelę {table}","ui.migrate.dropTable":"Usuń tabelę {table}","ui.migrate.addField":"Dodaj pole {table}.{field}","ui.migrate.changeField":"Zmień pole {table}.{field}","ui.migrate.dropField":"Usuń pole {table}.{field}","ui.migrate.createIndex":"Utwórz indeks \\"{name}\\" w {table}","ui.migrate.dropIndex":"Usuń indeks \\"{name}\\" w {table}","ui.widget.mandatory":"To pole nie może być puste.","ui.widget.blankOption":"Proszę wybrać …","ui.widget.showPassword":"Pokaż hasło","ui.widget.hidePassword":"Ukryj hasło","ui.error.title":"Żądanie HTTP dla \\"{method}{url}\\" nie powiodło się.","ui.error.server500":"Wygląda na to, że wystąpił nieoczekiwany błąd na twoim serwerze. Sprawdź dziennik zdarzeń serwera www (Apache/Nginx) oraz dziennik Contao Manager w \\"contao-manager/logs\\".","ui.error.response":"Serwer zwrócił odpowiedź z kodem {status}.","ui.error.moreLink":"Więcej informacji","ui.error.support":"Wsparcie Contao","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Pomoc","ui.footer.reportProblem":"Zgłoś problem","ui.navigation.discover":"Odkrywaj","ui.navigation.packages":"Pakiety","ui.navigation.tools":"Narzędzia","ui.navigation.installTool":"Instalator","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Tryb Debug","ui.navigation.logViewer":"Czytnik logów","ui.navigation.phpinfo":"Informacja PHP","ui.navigation.phpinfoLoading":"Ładowanie informacji PHP…","ui.navigation.maintenance":"Konserwacja","ui.navigation.rebuildCache":"Przebuduj cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Sprawdzenie Systemu","ui.navigation.advanced":"Zaawansowane","ui.navigation.logout":"Wyloguj","ui.maintenance.database.title":"Bazy danych Migracje i Kopie Zapasowe","ui.maintenance.database.description":"Migracje baz danych zapewniają spójność danych i schematów tabel.","ui.maintenance.database.migrations":"Jedna oczekująca migracja bazy danych | {count} oczekujących migracji bazy danych","ui.maintenance.database.schemaUpdates":"Jedna oczekująca aktualizacja schematu | {count} oczekujące aktualizacje schematu","ui.maintenance.database.error":"Problem z bazą danych został znaleziony.","ui.maintenance.database.warning":"Wykryto ostrzeżenia w bazie danych.","ui.maintenance.database.button":"Sprawdź bazę danych","ui.maintenance.database.migrationOnly":"Sprawdź tylko migracje","ui.maintenance.database.schemaOnly":"Sprawdź tylko strukturę","ui.maintenance.database.installTool":"Otwórz instalator","ui.maintenance.database.createBackup":"Utwórz kopię zapasową","ui.maintenance.database.backupUnsupported":"Kopie zapasowe bazy danych nie są obsługiwane przez Twoją wersję Contao.","ui.maintenance.database.backupList":"Masz jedno kopię zapasową bazy danych, utworzoną {date}. | Masz {count} kopii zapasowych bazy danych, najnowsza została utworzona {date}.","ui.maintenance.database.backupEmpty":"Nie masz obecnie żadnych kopii zapasowych bazy danych.","ui.maintenance.rebuildCache.title":"Cache Aplikacji","ui.maintenance.rebuildCache.description":"Przebudowanie cache\'u aplikacji jest wymagane po jakichkolwiek modyfikacjach plików konfiguracyjnych.","ui.maintenance.rebuildCache.rebuildProd":"Przebuduj Cache Production","ui.maintenance.rebuildCache.rebuildDev":"Przebuduj Cache Development","ui.maintenance.rebuildCache.clearProd":"Wyczyść Cache Production","ui.maintenance.rebuildCache.clearDev":"Wyczyść Cache Development","ui.maintenance.installTool.title":"Instalator Contao","ui.maintenance.installTool.description":"Instalator Contao jest automatycznie blokowany jeśli wprowadzisz błędne hasło trzy razy z rzędu.","ui.maintenance.installTool.unlock":"Odblokuj instalator","ui.maintenance.installTool.lock":"Zablokuj instalator","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Autoloader Composera jest odpowiedzialny za ładowanie klas PHP. Autoloader musi być odświeżony po dodaniu własnych namespace\'ów do pliku composer.json.","ui.maintenance.dumpAutoload.button":"Odśwież Autoloader","ui.maintenance.composerInstall.title":"Pakiety Composera","ui.maintenance.composerInstall.description":"Zależności Composer\'a są umieszczone w folderze {vendor} w głównym katalogu aplikacji. Przeinstalowanie zależności może być konieczne po zmianach lub ręcznym wgraniu pliku {composerLock}.","ui.maintenance.composerInstall.button":"Uruchom Instalator","ui.maintenance.composerInstall.update":"Uruchom Composer Update","ui.maintenance.composerCache.title":"Cache Composera","ui.maintenance.composerCache.description":"Composer cache\'uje pobrane pakiety w celu lepszej wydajności. Jeśli masz problemy z zepsutymi plikami, spróbuj usunąć cache Composera, aby wymusić nowe pobranie plików.","ui.maintenance.composerCache.button":"Wyczyść Cache","ui.maintenance.maintenanceMode.title":"Tryb konserwacji","ui.maintenance.maintenanceMode.description":"Przełączenie Contao w tryb konserwacji spowoduje wyświetlenie szablonu \\"503 Service Unavailable\\" dla strony internetowej.","ui.maintenance.maintenanceMode.enable":"Włącz","ui.maintenance.maintenanceMode.disable":"Wyłącz","ui.maintenance.debugMode.title":"Tryb Debug","ui.maintenance.debugMode.description":"Aktywuj tryb diagnostyczny podając nazwę użytkownika i hasło do {appDevPhp} punktu dostępowego.","ui.maintenance.debugMode.descriptionJwt":"Aktywuj tryb debug poprzez ustawienie ciasteczka debug dla obecnej domeny.","ui.maintenance.debugMode.activate":"Aktywuj","ui.maintenance.debugMode.deactivate":"Deaktywuj","ui.maintenance.debugMode.credentials":"Uwierzytelnianie","ui.maintenance.debugMode.user":"Proszę wprowadzić nazwę użytkownika dla trybu debug.","ui.maintenance.debugMode.password":"Proszę wprowadzić hasło dla trybu debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode cache\'uje pliki PHP procesu web w celu szybszego ich wykonywania. Cache musi zostać usunięty w pewnych okolicznościach, jeśli pliki nie są rozpoznawane po ich zmianie.","ui.maintenance.opcodeCache.button":"Wyczyść Cache","ui.maintenance.safeMode":"Niedostępne w Bezpiecznym Trybie","ui.maintenance.unsupported":"Niewspierane przez twoją wersję Contao","ui.packages.updateButton":"Zaktualizuj pakiety","ui.packages.searchButton":"Szukaj Pakietów","ui.packages.searchPlaceholder":"Szukaj pakietów …","ui.packages.uploadOverlay":"Przeciągnij i upuść pliki","ui.packages.uploadButton":"Wgraj pakiety","ui.packages.uploadMessage":"Masz jedną niepotwierdzoną wysyłkę. | Masz {count} niepotwierdzonych wysyłek.","ui.packages.uploadApply":"Potwierdź pliki","ui.packages.uploadReset":"Usuń pliki","ui.packages.uploadIncomplete":"Ten plik nie został wgrany całkowicie. Usuń go i spróbuj ponownie.","ui.packages.uploadDuplicate":"Ten plik wygląda na wgrany kilka razy. Usuń duplikaty.","ui.packages.uploadInstalled":"Ten plik jest już zainstalowany. Usuń duplikaty.","ui.packages.uploadUnsupported":"Przesyłki nie są obsługiwane w Twojej instalacji. Upewnij się, że rozszerzenie PHP ZIP jest zainstalowane i zaktualizuj swoje zależności.","ui.packages.changesMessage":"Masz jedną niepotwierdzoną zmianę. | Masz {count} niepotwierdzonych zmian.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Zapisz zmiany","ui.packages.changesApplyAll":"Zaktualizuj wszystkie pakiety","ui.packages.changesDryrunAll":"Próbnie zaktualizuj wszystkie pakiety","ui.packages.changesReset":"Zresetuj zmiany","ui.packages.changesReview":"Zapisz Zmiany","ui.packagelist.loading":"Ładowanie …","ui.packagelist.uploads":"Wgrane pliki","ui.packagelist.added":"Nowe pakiety","ui.packagelist.installed":"Zainstalowane pakiety","ui.package.hintRevert":"Cofnij zmiany","ui.package.hintNoupdate":"Nie aktualizuj","ui.package.hintConstraint":"Ten pakiet zostanie zainstalowany z wymogiem {constraint} kiedy zapiszesz zmiany.","ui.package.hintConstraintBest":"Ten pakiet zostanie zainstalowany w najlepszej możliwej wersji kiedy zapiszesz zmiany.","ui.package.hintConstraintChange":"Wymóg dla tego pakietu zostanie zmieniony z \\"{from}\\" do \\"{to}\\" kiedy zapiszesz zmiany.","ui.package.hintConstraintUpdate":"Ten pakiet zostanie zaktualizowany, kiedy zapiszesz zmiany.","ui.package.hintAdded":"Ten pakiet zostanie zainstalowana, kiedy zapiszesz zmiany.","ui.package.hintRemoved":"Ten pakiet zostanie usunięty kiedy zapiszesz zmiany.","ui.package.requiredTitle":"dodane ręcznie","ui.package.requiredText":"Ten pakiet jest jako wymagany w pliku composer.json, ale nie jest zainstalowany.","ui.package.removedTitle":"usunięte ręcznie","ui.package.removedText":"Ten pakiet został usunięty z twojego composer.json.","ui.package.installed":"Obecnie zainstalowane:","ui.package.version":"Wersja {version}","ui.package.additionalDownloads":"{count} Pobranie | {count} Pobrania","ui.package.additionalStars":"{count} Gwiazdka | {count} Gwiazdki","ui.package.editConstraint":"Edytuj","ui.package.uploadConstraint":"To ograniczenie zdefiniowane jest przez przesłany pakiet.","ui.package.updateButton":"Aktualizuj","ui.package.removeButton":"Usuń","ui.package.installButton":"Dodaj Pakiet","ui.package.installButtonShort":"Dodaj","ui.package.detailsButton":"Szczegóły","ui.package.latestConstraint":"ostatnia wersja","ui.package.update":"Dostępna aktualizacja","ui.package.updateLatest":"ostatnia wersja","ui.package.updateAvailable":"{version} dostępna","ui.package.updateUnknown":"nieznana wersja","ui.package.updateConstraint":"Dostępna jest nowsza wersja spoza ograniczenia wersji Twojego oprogramowania.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.package.incompatibleWarning":"{package} does not work with Contao {constraint} in any of its stable releases. Do you want to add the package and set a version constraint to try installing a development branch?","ui.package.incompatibleConstraint":"This package does not have a stable release for Contao {constraint}. Set a version constraint to try installing a development branch.","ui.package.incompatibleButton":"Instalacja","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Wersja {version}","ui.cloudStatus.waitingTime":"Czas Oczekiwania","ui.cloudStatus.jobs":"Aktualne Zadania","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"żaden","ui.cloudStatus.short":"ok. {minutes} min","ui.cloudStatus.long":"ok. {minutes} min {seconds} sek","ui.cloudStatus.error":"Nie udało się uzyskać stanu Composer Resolver Cloud. Może być w trakcie serwisowania lub ma awarię.","ui.cloudStatus.button":"Status Chmury","ui.cloudStatus.refresh":"Odśwież Status Chmury","ui.log-viewer.loading":"Ładowanie …","ui.log-viewer.empty":"Nie ma plików dziennika na Twoim serwerze.","ui.log-viewer.reload":"Odśwież","ui.log-viewer.file":"Plik logów","ui.log-viewer.channel":"Kanał","ui.log-viewer.channelTitle":"Kanał, do którego została zapisana ta wiadomość.","ui.log-viewer.level":"Poziom","ui.log-viewer.levelTitle":"Ważność wiadomości log.","ui.log-viewer.timeHeader":"Czas","ui.log-viewer.messageHeader":"Wiadomość","ui.log-viewer.showContext":"Pokaż kontekst","ui.log-viewer.hideContext":"Ukryj kontekst","ui.log-viewer.showExtra":"Pokaż Dodatkowe","ui.log-viewer.hideExtra":"Ukryj Dodatkowe","ui.log-viewer.more":"Wczytaj więcej ...","ui.log-viewer.download":"Pobierz","ui.log-viewer.downloadTitle":"Pobierz plik \\"{file}\\"","ui.log-viewer.prodEnvironment":"Środowisko produkcyjne","ui.log-viewer.devEnvironment":"Środowisko deweloperskie (tryb debugowania)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min 8 znaków","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Anuluj","ui.user-manager.close":"Zamknij","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Włącz","ui.totp.disable":"Wyłącz","ui.totp.cancel":"Anuluj","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[560],{1560:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Nedrošs savienojums !!","ui.app.httpsDescription":"Bez HTTPS jūsu konfidenciālie dati tiks pārsūtīti nešifrēti.","ui.app.httpsLink":"Vairāk informācijas","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Ieslēgts drošais režīms !!","ui.app.safeModeDescription":"Dažas Contao Manager funkcijas nav pieejamas.","ui.app.safeModeExit":"Iziet no drošā režīma","ui.app.limitedHeadline":"Attālā autentifikācija","ui.app.limitedDescription":"Jums ir ierobežotas atļaujas, jo pieslēgšanās notiek bez paroles.","ui.app.limitedLogout":"Atkārtoti autentificēties","ui.app.totpHeadline":"Drošības paziņojums","ui.app.totpDescription":"Konfigurējiet divfaktoru autentifikāciju, lai aizsargātu savu kontu.","ui.app.totpSetup":"Uzstādīt","ui.app.loading":"Ielādē Contao pārvaldnieku ...","ui.app.apiError":"Negaidīts API statuss","ui.app.configSecurity1":"DROŠĪBAS BRĪDINĀJUMS !!! Konstatēts neaizsargāts konfigurācijas direktorijs","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Laipni lūdzam","ui.account.intro1":"Laipni lūgti Contao pārvaldniekā, kas ir universāls rīks Contao atvērtā koda CMS instalēšanai un pārvaldībai. Ja esat jauns lietotājs, lūdzu, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, lai sāktu","ui.account.introManual":"izlasiet rokasgrāmatu","ui.account.intro2":"Ja jums rodas kādas problēmas, pārbaudiet {ourGithubIssues} un nekautrējieties izveidot jaunu problēmu, ja par to vēl nav ziņots.","ui.account.introIssues":"mūsu GitHub problēmas","ui.account.headline":"Lietotāja konts","ui.account.description":"Lai pārvaldītu savu instalāciju, lūdzu, izveidojiet Contao pārvaldnieka kontu. Ņemiet vērā, ka šis konts nav saistīts ar Contao aizmuguri vai priekšu.","ui.account.username":"Lietotājvārds","ui.account.password":"Parole","ui.account.passwordPlaceholder":"min. 8 rakstzīmes","ui.account.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Izveidot kontu","ui.account.usePassword":"Izmantot paroli, lai pieslēgtos","ui.account.usePasskey":"Pieslēdzoties izmantot Passkey","ui.account.totpHeadline":"Divu faktoru autentifikācija","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Konfigurēt tagad","ui.account.totpSkip":"Konfigurēt vēlāk","ui.account.login":"Noraidīt ielūgumu","ui.account.contribute1":"Contao un Contao Manager sponsorē bezpeļņas organizācija Contao Association.","ui.account.contribute2":"Lūdzu, apsveriet iespēju sniegt ieguldījumu atvērtajā pirmkodā {donate}.","ui.account.contributeDonate":"ziedojuma veikšana","ui.login.headline":"Pierakstīties","ui.login.description":"Pierakstīties, lai pārvaldītu savu instalāciju.","ui.login.username":"Lietotājvārds","ui.login.password":"Parole","ui.login.totpHeadline":"Divu faktoru autentifikācija","ui.login.totpDescription":"Lūdzu, ievadiet verifikācijas kodu, lai pabeigtu pieslēgšanās procesu.","ui.login.totp":"Verifikācijas kods","ui.login.forgotPassword":"Aizmirsāt paroli?","ui.login.button":"Pierakstīties","ui.login.passkey":"Pieslēgties ar Passkey","ui.login.cancel":"Atcelt","ui.login.or":"vai","ui.login.locked":"Piekļuve ir liegta, jo Contao Manager ir bloķēts. Lai atbloķētu, izdzēsiet {lockFile} datni Contao galvenajā direktorijā.","ui.logout.headline":"Sesijas laika limits","ui.logout.warning":"Jūs esat bijis neaktīvs ilgāk par 25 minūtēm. Drošības apsvērumu dēļ jūsu sesija drīz tiks pārtraukta.","ui.logout.expired":"Jūsu sesija tika automātiski pārtraukta, jo esat bijis neaktīvs ilgāk par 30 minūtēm.","ui.logout.renew":"Palikt pieteikušamies","ui.logout.logout":"Izrakstīties","ui.logout.login":"Atpakaļ uz pieteikšanos","ui.oauth.error":"Nederīgs OAuth mēģinājums. Pārbaudiet pieprasījuma parametrus.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Attālā autentifikācija","ui.oauth.description":"Šāda lietojumprogramma vai pakalpojums pieprasa attālo piekļuvi jūsu Contao Manager instancei.","ui.oauth.domain":"Pirms atļaujat piekļuvi, pārliecinieties, ka zināt šo URL un uzticaties tā īpašniekam!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Atļaut piekļuvi","ui.oauth.deny":"Liegt piekļuvi","ui.oauth.switchUser":"Pārslēgt lietotāju","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sistēmas pārbaude","ui.boot.description":"Lūdzu, uzgaidiet, mēs analizējam jūsu serveri ...","ui.boot.issue1":"Konstatētās  instalēšanas problēmas","ui.boot.issue2":"Jūsu instalācijā ir problēmas, kas jānovērš, pirms var izmantot Contao Manager.","ui.boot.run":"Palaist Contao pārvaldnieku","ui.boot.safeMode":"Palaist drošajā režīmā","ui.recovery.headline":"Sistēmas atkopšana","ui.recovery.description":"Contao Manager atklāja datnes, kas izskatās kā Contao, bet komandrindas saskarne nedarbojas, kā paredzēts.","ui.recovery.console":"Konsoles izvade","ui.recovery.repairOptions":"Lūdzu, izvēlieties iespēju, lai salabotu instalāciju.","ui.recovery.repairHeadline":"Automātiskā izlabošana","ui.recovery.repairDescription":"Mēģina automātiski labot instalāciju, atjaunojot lietojumprogrammu kešatmiņu un atkārtoti instalējot Composer paketes.","ui.recovery.repairWarning":"Procesa laikā var tikt dzēstas visas piegādātāja datņu izmaiņas!","ui.recovery.repairFailed":"Automātiskā labošana nebija veiksmīga. Izmēģiniet instalāciju labot manuāli drošajā režīmā.","ui.recovery.repairButton":"Palaist sistēmas izlabošanu","ui.recovery.safeModeHeadline":"Drošais režīms","ui.recovery.safeModeDescription":"Programmas Contao Manager palaišana drošajā režīmā ļauj pārvaldīt paketes un veikt dažus uzturēšanas uzdevumus, taču funkcijas, kas ir atkarīgas no darbojošās Contao instalācijas, nebūs pieejamas.","ui.recovery.safeModeButton":"Palaist drošajā režīmā","ui.server.pending":"Gaida ...","ui.server.running":"Analizē ...","ui.server.error":"Pārbaude neizdevās, jo no servera saņemta neparedzēta atbilde.","ui.server.details":"Sīkāka informācija","ui.server.prerequisite":"Pārbaude atcelta trūkstošā priekšnosacījuma dēļ.","ui.server.selfUpdate.title":"Contao pārvaldnieka atjauninājumi","ui.server.selfUpdate.update":"Ir pieejama jauna Contao pārvaldnieka versija {latest}.","ui.server.selfUpdate.manualUpdate":"Ir pieejama jauna Contao Manager versija {latest}. Jūsu serveris neatbalsta automātiskus atjauninājumus, lūdzu, lejupielādējiet jauno versiju no {download}.","ui.server.selfUpdate.latest":"Jūs izmantojat jaunāko versiju {current}.","ui.server.selfUpdate.dev":"Izstrādes būves neatbalsta automātiskus atjauninājumus.","ui.server.selfUpdate.unsupported":"Ir pieejama jauna versija, taču tā neatbalsta jūsu PHP versiju.","ui.server.selfUpdate.button":"Palaist pašatjauninājumu","ui.server.selfUpdate.continue":"Turpināt","ui.server.config.title":"Servera konfigurācija","ui.server.config.setup":"Konfigurēt","ui.server.config.change":"Mainīt","ui.server.config.save":"Saglabāt","ui.server.config.cancel":"Atcelt","ui.server.config.customOption":"Cits ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Servera konfigurācija","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Izmantot Composer Resolver Cloud","ui.server.config.cli":"PHP binārs","ui.server.config.stateErrorCli":"Serverī netika atrasts derīgs PHP binārs.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud netiek atbalstīts.","ui.server.config.stateSuccess":"PHP binārais kodols {php_cli}.","ui.server.config.cloudEnabled":"Package dependencies will be resolved using the Composer Resolver Cloud.","ui.server.config.cloudDisabled":"The Composer Resolver Cloud is disabled.","ui.server.php_web.title":"PHP Web process","ui.server.php_web.below7":"Atrasta PHP versija {versija}. Lūdzu, pēc iespējas ātrāk pārejiet uz PHP 7!","ui.server.php_web.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.php_cli.title":"PHP komandrindas saskarne","ui.server.php_cli.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.composer.title":"Composer vide","ui.server.composer.success":"Netika atrastas zināmas problēmas.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Uzstādīt","ui.server.contao.title":"Contao instalācija","ui.server.contao.setup":"Uzstādīt","ui.server.contao.check":"Pārbaudīt datubāzi","ui.server.contao.empty":"Neviena Contao instalācija nav atrasta.","ui.server.contao.old":"Contao versija {versija} nav savietojama ar Contao pārvaldnieku, lūdzu, manuāli atjauniniet instalāciju.","ui.server.contao.found":"Atrasts Contao {versija} (API versija {api}).","ui.server.contao.connectionError":"Nevar izveidot savienojumu ar datubāzes serveri.","ui.server.contao.connectionProblem":"Atrasta datubāzes problēma.","ui.server.contao.missingUser":"Administratora konts nav atrasts.","ui.setup.continue":"Turpināt","ui.setup.manager":"Palaist Contao pārvaldnieku","ui.setup.cancel":"Atcelt","ui.setup.welcome":"Laipni lūdzam","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"kopienas atbalsts","ui.setup.start":"Sākt","ui.setup.complete":"Apsveicam!","ui.setup.complete1":"Contao {versija} ir veiksmīgi instalēta.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Atveriet instalēšanas rīku","ui.setup.login":"Pieslēgties Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Uzzināt vairāk","ui.setup.document-root.headline":"Tīmekļa servera iestatīšana","ui.setup.document-root.warning":"Lai instalētu Contao, izmantojot Contao Manager, tīmekļa serverī ir jānosaka dokumenta sakne.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ja nezināt, kā konfigurēt dokumentu sakni, izlasiet Contao dokumentāciju vai sazinieties ar savu hostinga pakalpojumu sniedzēju.","ui.setup.document-root.documentation":"Izlasiet dokumentāciju","ui.setup.document-root.conflictsTitle":"Instalācijas direktorijs nav tukšs","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Pārbaudiet vēlreiz","ui.setup.document-root.create":"Izveidot direktorijus","ui.setup.document-root.change":"Mainīt direktorijus","ui.setup.document-root.formTitle":"Direktoriju iestatīšana","ui.setup.document-root.formText1":"Contao Manager var automātiski izveidot jaunu direktoriju struktūru serverī.","ui.setup.document-root.formText2":"Jums būs manuāli jākonfigurē jaunā dokumenta sakne (piemēram, izmantojot hostinga administratora paneli).","ui.setup.document-root.autoconfig":"Es saprotu, ka man ir jāmaina servera konfigurācija. Dokumenta saknes nekonfigurēšana sabojās Contao Manager un atklās konfigurācijas failus (tostarp konta informāciju un paroles)!","ui.setup.document-root.directory":"Jauns direktorijs","ui.setup.document-root.currentRoot":"Pašreizējā dokumenta sakne","ui.setup.document-root.newRoot":"Jauna dokumenta sakne","ui.setup.document-root.finish":"Direktoriju iestatīšana","ui.setup.document-root.publicDir":"Izmantojiet {dir} publiskajām datnēm (Contao {version})","ui.setup.document-root.directoryInvalid":"Lūdzu, ievadiet derīgu direktorija nosaukumu.","ui.setup.document-root.directoryExists":"Mērķa direktorijs jau pastāv. Lūdzu, ievadiet citu nosaukumu.","ui.setup.document-root.confirmation":"Contao pārvaldnieks ir veiksmīgi izveidojis nepieciešamo direktoriju jūsu Contao instalācijai. Tagad jums ir jākonfigurē dokumenta sakne tīmekļa serverī. Līdz tam nepārlādējiet šo lapu no jauna.","ui.setup.document-root.reload":"Pārlādēt lapu","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Lietojumprogrammas datnes tiks instalētas {dir}.","ui.setup.document-root.installingPublicDir":"Publiskās datnes tiks instalētas {dir}.","ui.setup.document-root.installedProjectDir":"Lietojumprogrammas datnes ir instalētas {dir}.","ui.setup.document-root.installedPublicDir":"Publiskās datnes ir instalētas {dir}.","ui.setup.create-project.headline":"Contao instalācija","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Jaunākais","ui.setup.create-project.ltsTitle":"Ilgtermiņa atbalsts","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Sīkāku informāciju skatiet {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao izlaišanas plāns","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Izvēlēties distribūciju","ui.setup.create-project.formText":"Lūdzu, izvēlieties, kura versija jāuzstāda.","ui.setup.create-project.version":"Versija","ui.setup.create-project.demo":"Instalēt Contao demo vietni","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimāla instalācija (tikai Core)","ui.setup.create-project.noUpdate":"Izlaist instalāciju (tikai eksperts!)","ui.setup.create-project.theme":"Contao tēma","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Noteikti apmeklējiet oficiālo {store}.","ui.setup.create-project.themeStore":"Contao tēmu veikals","ui.setup.create-project.themeUpload":"Augšupielādēt tēmas datni (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Meklēt tēmas","ui.setup.create-project.theme.more":"Vairāk tēmas","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"Tēmas datne tika veiksmīgi augšupielādēta.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versija","ui.setup.create-project.theme.authors":"Autors(i)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Uzstādīt","ui.setup.create-project.cancel":"Atcelt","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Datubāzes savienojums","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Savienojuma parametri","ui.setup.database-connection.formText":"Ievadiet datubāzes URL vai atsevišķi aizpildiet lietotājvārdu, paroli, serveri un datubāzes laukus.","ui.setup.database-connection.url":"Datubāzes URL","ui.setup.database-connection.validUrl":"Datubāzes URL ir nederīgs vai neizdevās izveidot savienojumu ar serveri.","ui.setup.database-connection.or":"vai","ui.setup.database-connection.user":"Lietotājvārds","ui.setup.database-connection.password":"Parole","ui.setup.database-connection.server":"Serveris (:ports)","ui.setup.database-connection.database":"Datubāzes nosaukums","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Kļūda, savienojoties ar datubāzi.","ui.setup.database-connection.problem":"Contao ir atklājis problēmu ar jūsu datubāzes serveri.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Jūsu datubāzes shēma ir aktuāla.","ui.setup.database-connection.check":"Pārbaudīt datubāzi","ui.setup.database-connection.skip":"Izlaist","ui.setup.database-connection.save":"Saglabāt","ui.setup.database-connection.change":"Mainīt akreditācijas datus","ui.setup.database-connection.restoreTitle":"Datubāzes imports","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Dublējiet pašreizējo datu bāzi pirms importēšanas","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Importēt tēmas datubāzi","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Aizmugures konts","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Izveidot kontu","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Lietotājvārds","ui.setup.backend-user.name":"Vārds","ui.setup.backend-user.email":"E-pasta adrese","ui.setup.backend-user.emailInvalid":"Lūdzu, ievadiet derīgu e-pasta adresi","ui.setup.backend-user.password":"Parole","ui.setup.backend-user.passwordPlaceholder":"min. 8 rakstzīmes","ui.setup.backend-user.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.setup.backend-user.create":"Pievienot kontu","ui.task.headline":"Fona uzdevums","ui.task.loading":"Ielādē informāciju ...","ui.task.created":"Ielādē informāciju ...","ui.task.active":"Lūdzu, pagaidiet, kamēr Contao Manager fona režīmā tiek veiktas uzdevumu operācijas.","ui.task.complete":"Visas operācijas ir veiksmīgi pabeigtas. Sīkāku informāciju skatiet konsoles izvades failā.","ui.task.paused":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.aborting":"Lūdzu, uzgaidiet, kamēr tiek atceltas fona operācijas.","ui.task.stopped":"Dažas fona darbības tika atceltas. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.error":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.failed":"Contao pārvaldniekam neizdevās palaist fona uzdevumu!","ui.task.failedDescription1":"Mēģinot izpildīt operācijas fonā, kaut kas notika nepareizi.","ui.task.failedDescription2":"Ja tas atkārtojas, iespējams, ka jūsu serveris netiek atbalstīts.","ui.task.reportProblem":"Ziņot par problēmu","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Atjaunināt datubāzi","ui.task.buttonClose":"Aizvērt","ui.task.buttonConfirm":"Apstiprināt & aizvērt","ui.task.buttonContinue":"Turpināt","ui.task.buttonCancel":"Atcelt","ui.task.confirmCancel":"Vai noteikti vēlaties atcelt šo uzdevumu? Tas var atstāt jūsu Contao instalāciju bojātā stāvoklī!","ui.task.autoclose":"Aizvērt uzdevuma informāciju pēc izdošanās","ui.console.toggle":"Rādīt/slēpt konsoles izvadi","ui.console.showLog":"Rādīt pilnu konsoles žurnālu","ui.console.copyLog":"Kopēt žurnālu uz starpliktuvi","ui.migrate.headline":"Datubāzes atjauninājumi","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Lūdzu, uzgaidiet, mēs pārbaudām jūsu datubāzi...","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Izpildīt","ui.migrate.close":"Aizvērt","ui.migrate.confirm":"Apstiprināt & aizvērt","ui.migrate.cancel":"Atcelt","ui.migrate.continue":"Turpināt","ui.migrate.setup":"Uzstādīt","ui.migrate.skip":"Izlaist","ui.migrate.retry":"Pārbaudiet vēlreiz","ui.migrate.retryAll":"Atzīmēt visus","ui.migrate.withDeletes":"Izpildīt visas datubāzes izmaiņas, tostarp DROP vaicājumus.","ui.migrate.migrationTitle":"Datubāzu migrācija","ui.migrate.schemaTitle":"Shēmas atjauninājumi","ui.migrate.problemTitle":"Datubāzes problēmas","ui.migrate.warningTitle":"Datubāzes brīdinājumi","ui.migrate.addTable":"Pievienot tabulu {table}","ui.migrate.dropTable":"Nomest tabulu {table}","ui.migrate.addField":"Pievienot lauku {table}.{field}","ui.migrate.changeField":"Mainīt lauku {table}.{field}","ui.migrate.dropField":"Nomest lauku {table}.{field}","ui.migrate.createIndex":"Izveidot indeksu \\"{name}\\" uz {table}","ui.migrate.dropIndex":"Nomest indeksu \\"{name}\\" uz {table}","ui.widget.mandatory":"Šis lauks nedrīkst būt tukšs.","ui.widget.blankOption":"Lūdzu, izvēlieties ...","ui.widget.showPassword":"Rādīt paroli","ui.widget.hidePassword":"Slēpt paroli","ui.error.title":"HTTP pieprasījums \\"{metod} {url}\\" neizdevās.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"Serveris atbildēja ar statusa kodu {status}.","ui.error.moreLink":"Vairāk informācijas","ui.error.support":"Contao atbalsts","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Palīdzība","ui.footer.reportProblem":"Ziņot par problēmu","ui.navigation.discover":"Atklāt","ui.navigation.packages":"Pakotnes","ui.navigation.tools":"Rīki","ui.navigation.installTool":"Instalēšanas rīks","ui.navigation.backend":"Contao aizmugure","ui.navigation.debug":"Contao atkļūdošanas režīms","ui.navigation.logViewer":"Žurnāla skatītājs","ui.navigation.phpinfo":"PHP informācija","ui.navigation.phpinfoLoading":"PHP informācijas ielāde...","ui.navigation.maintenance":"Uzturēšana","ui.navigation.rebuildCache":"Pārbūvēt kešatmiņu","ui.navigation.users":"Konti","ui.navigation.systemCheck":"Sistēmas pārbaude","ui.navigation.advanced":"Papildu","ui.navigation.logout":"Izrakstīties","ui.maintenance.database.title":"Datubāžu migrācija un dublējumi","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Atrasta datubāzes problēma.","ui.maintenance.database.warning":"Atrasti datubāzes brīdinājumi.","ui.maintenance.database.button":"Pārbaudīt datubāzi","ui.maintenance.database.migrationOnly":"Pārbaudīt tikai migrācijas","ui.maintenance.database.schemaOnly":"Pārbaudīt tikai shēmu","ui.maintenance.database.installTool":"Atvērt instalēšanas rīku","ui.maintenance.database.createBackup":"Izveidot dublējumu","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Lietojumprogrammas kešatmiņa","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Ražošanas kešatmiņas pārbūve","ui.maintenance.rebuildCache.rebuildDev":"Izstrādes kešatmiņas pārbūve","ui.maintenance.rebuildCache.clearProd":"Notīrīt ražošanas kešatmiņu","ui.maintenance.rebuildCache.clearDev":"Notīrīt izstrādes kešatmiņu","ui.maintenance.installTool.title":"Contao instalēšanas rīks","ui.maintenance.installTool.description":"Contao instalēšanas rīks tiek automātiski bloķēts, ja trīs reizes pēc kārtas ievadāt nepareizu paroli.","ui.maintenance.installTool.unlock":"Atbloķēt instalēšanas rīku","ui.maintenance.installTool.lock":"Bloķēt instalēšanas rīku","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Palaist instalētāju","ui.maintenance.composerInstall.update":"Palaist Composer jauninājumu","ui.maintenance.composerCache.title":"Composer kešatmiņa","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Iztīrīt kešatmiņu","ui.maintenance.maintenanceMode.title":"Uzturēšanas režīms","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Iespējot","ui.maintenance.maintenanceMode.disable":"Atspējot","ui.maintenance.debugMode.title":"Atkļūdošanas režīms","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Aktivizēt","ui.maintenance.debugMode.deactivate":"Deaktivizēt","ui.maintenance.debugMode.credentials":"Akreditācijas dati","ui.maintenance.debugMode.user":"Lūdzu, ievadiet atkļūdošanas režīma lietotājvārdu.","ui.maintenance.debugMode.password":"Lūdzu, ievadiet paroli atkļūdošanas režīmam.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Saīsināt kešatmiņu","ui.maintenance.safeMode":"Nav pieejams drošajā režīmā","ui.maintenance.unsupported":"Neatbalsta jūsu Contao versija","ui.packages.updateButton":"Atjaunināt pakotnes","ui.packages.searchButton":"Meklēt pakotnes","ui.packages.searchPlaceholder":"Meklēt pakotnes ...","ui.packages.uploadOverlay":"Lai augšupielādētu, velciet un nometiet failus","ui.packages.uploadButton":"Augšupielādēt pakotnes","ui.packages.uploadMessage":"Jums ir viena neapstiprināta augšupielāde. | Jums ir {count} neapstiprināta/u augšupielāde/žu.","ui.packages.uploadApply":"Apstiprināt augšupielādi","ui.packages.uploadReset":"Dzēst augšupielādes","ui.packages.uploadIncomplete":"Šis datne netika augšupielādēts pilnībā. Lūdzu, noņemiet to un mēģiniet vēlreiz.","ui.packages.uploadDuplicate":"Šķiet, ka šī datne ir augšupielādēts vairākas reizes. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadInstalled":"Šis datne jau ir instalēta. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Pielietot izmaiņas","ui.packages.changesApplyAll":"Atjaunināt visas pakotnes","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Atiestatīt izmaiņas","ui.packages.changesReview":"Pārskatīt izmaiņas","ui.packagelist.loading":"Ielādē ...","ui.packagelist.uploads":"Augšupielādes","ui.packagelist.added":"Jaunas pakotnes","ui.packagelist.installed":"Instalētās pakotnes","ui.package.hintRevert":"Atgriezt izmaiņas","ui.package.hintNoupdate":"Neatjaunināt","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"Šī pakotne tiks atjaunināta, kad piemērosiet izmaiņas.","ui.package.hintAdded":"Šī pakotne tiks instalēta, kad piemērosiet izmaiņas.","ui.package.hintRemoved":"Šī pakotne tiks noņemta, kad piemērosiet izmaiņas.","ui.package.requiredTitle":"manuāli pievienots","ui.package.requiredText":"Šī pakotne ir nepieciešama jūsu composer.json, bet nav instalēta.","ui.package.removedTitle":"manuāli noņemts","ui.package.removedText":"Šī pakotne tika noņemta no jūsu composer.json.","ui.package.installed":"Pašlaik instalēts:","ui.package.version":"Versija {version}","ui.package.additionalDownloads":"{count} Lejupielāde | {count} Lejupielādes","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Rediģēt","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Jaunināt","ui.package.removeButton":"Noņemt","ui.package.installButton":"Pievienot pakotni","ui.package.installButtonShort":"Pievienot","ui.package.detailsButton":"Sīkāka informācija","ui.package.latestConstraint":"jaunākā versija","ui.package.update":"Pieejams atjauninājums","ui.package.updateLatest":"jaunākā versija","ui.package.updateAvailable":"Pieejama {versija}","ui.package.updateUnknown":"nezināma versija","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.package.incompatibleWarning":"{package} does not work with Contao {constraint} in any of its stable releases. Do you want to add the package and set a version constraint to try installing a development branch?","ui.package.incompatibleConstraint":"This package does not have a stable release for Contao {constraint}. Set a version constraint to try installing a development branch.","ui.package.incompatibleButton":"Uzstādīt","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versija {version}","ui.cloudStatus.waitingTime":"Gaidīšanas laiks","ui.cloudStatus.jobs":"Pašreizējie darbi","ui.cloudStatus.workers":"Strādnieki","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nav","ui.cloudStatus.short":"apt. {minutes} min","ui.cloudStatus.long":"apt. {minutes} min {seconds} sek","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Mākoņa statuss","ui.cloudStatus.refresh":"Atjaunināt mākoņa statusu","ui.log-viewer.loading":"Ielādē ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Pārlādēt","ui.log-viewer.file":"Žurnāla datne","ui.log-viewer.channel":"Kanāls","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Līmenis","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Laiks","ui.log-viewer.messageHeader":"Ziņa","ui.log-viewer.showContext":"Rādīt kontekstu","ui.log-viewer.hideContext":"Slēpt kontekstu","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Lejupielādēt","ui.log-viewer.downloadTitle":"Lejupielādēt datni \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Mainīt paroli","ui.user-manager.setupTotp":"Divfaktoru autentifikācijas iestatīšana","ui.user-manager.disableTotp":"Atspējot divfaktoru autentifikāciju","ui.user-manager.invite":"Uzaicināt lietotāju","ui.user-manager.delete":"Dzēst","ui.user-manager.deleteConfirm":"Vai tiešām vēlaties dzēst lietotāju “{username}”?","ui.user-manager.deleted":"Lietotājs {username} veiksmīgi dzēsts","ui.user-manager.passwordHeadline":"Mainīt paroli","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Pašreizējā parole","ui.user-manager.newPassword":"Jauna parole","ui.user-manager.passwordPlaceholder":"min. 8 rakstzīmes","ui.user-manager.submitPassword":"Iesniegt","ui.user-manager.passwordChanged":"Jūsu parole ir veiksmīgi nomainīta.","ui.user-manager.passwordError":"Šī parole ir nepareiza.","ui.user-manager.inviteHeadline":"Uzaicināt lietotāju","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Izveidot ielūguma saiti","ui.user-manager.clipboard":"Kopēt uz starpliktuvi","ui.user-manager.permissions":"Uzzināt par atļaujām","ui.user-manager.cancel":"Atcelt","ui.user-manager.close":"Aizvērt","ui.user-manager.you":"Jūs","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Divfaktoru autentifikācija","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verifikācijas kods","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"Verifikācijas kods ir nederīgs.","ui.totp.enable":"Iespējot","ui.totp.disable":"Atspējot","ui.totp.cancel":"Atcelt","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Iestatīt divfaktoru autentifikāciju","ui.totp.skip":"Izlaist divfaktoru autentifikāciju"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[551],{2551:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! この接続は安全ではありません !!","ui.app.httpsDescription":"HTTPSでないと秘密のデータも暗号化しないで送信してしまいます。","ui.app.httpsLink":"詳細な情報","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! セーフモードが有効です !!","ui.app.safeModeDescription":"Contao Managerの一部の機能は利用できません。","ui.app.safeModeExit":"セーフモードを終了","ui.app.limitedHeadline":"リモート認証","ui.app.limitedDescription":"パスワードなしのログインのため限れた権限になっています。","ui.app.limitedLogout":"再認証","ui.app.totpHeadline":"セキュリティの注意","ui.app.totpDescription":"すぐに2ファクタ認証を構成してアカウントを安全にします。","ui.app.totpSetup":"セットアップ","ui.app.loading":"Contao Managerを読み込み中…","ui.app.apiError":"予期しないAPIの状態","ui.app.configSecurity1":"セキュリティ警告!!!  保護していない設定ディレクトリを検出","ui.app.configSecurity2":"Contao Managerは設定ファイルが公開してアクセスできる状態を検出しました。ディレクトリを安全な状態にするまで、すべての操作は動作しません、そうしないとインストールに含まれている極秘データを攻撃者がアクセスできる可能性があるためです。\\n\\nこれを修正するには\\"contao-manager\\"のディレクトリへのアクセスを禁止してください。この方法を学ぶには、ウェブサーバーのマニュアルを参照するかホスティング提供者に連絡してください。","ui.account.welcome":"ようこそ","ui.account.intro1":"Contao Managerにようこそ。Contao ManagerはContaoオープンソースCMSのインストールと管理を行う多才なツールです。Contao Managerを初めて利用する場合は{readTheManualToGetStarted}","ui.account.introGetStarted":"最初に{readTheManual} ","ui.account.introManual":"マニュアルを読んでください","ui.account.intro2":"何か問題があった場合は、{ourGithubIssues} を確認して、まだ報告されていない新しいどの様な問題は自由に新しいIssueを作成してください。","ui.account.introIssues":"GitHubのIssue","ui.account.headline":"ユーザーアカウント","ui.account.description":"インストールしたContaoを管理するには新しいアカウントを作成してください。このアカウントはContaoのバックエンドやフロントエンドとはまったく関係ないことに注意してください。","ui.account.username":"ユーザー名","ui.account.password":"パスワード","ui.account.passwordPlaceholder":"最小で8文字","ui.account.passwordLength":"少なくとも8文字を入力してください。","ui.account.loginInvalid":"アカウントの作成でエラーとなりました。異なるユーザー名で試してください。","ui.account.submit":"アカウントを作成","ui.account.usePassword":"ログインにパスワードを使用","ui.account.usePasskey":"パスキーをログインに使用","ui.account.totpHeadline":"2ファクター認証","ui.account.totpDescription":"2ファクター認証を有効にしてセキュリティレベルを高めてください。ユーザー名とパスワードに加えて、1Password、Authy、Google Authenticator、LastPass Authenticatorや他のTOTP(Time-based One-Time Password)アプリの確認コードの入力が必要となります。","ui.account.totpSetup":"すぐに設定","ui.account.totpSkip":"後で設定","ui.account.login":"申し出を拒否","ui.account.contribute1":"ContaoとContao Managerは非営利のContao Associationが支援しています。","ui.account.contribute2":"{donate}でオープンソースに貢献することをご検討ください。","ui.account.contributeDonate":"寄付をする","ui.login.headline":"サインイン","ui.login.description":"インストールを管理するにはログインします。","ui.login.username":"ユーザー名","ui.login.password":"パスワード","ui.login.totpHeadline":"2ファクター認証","ui.login.totpDescription":"確認コードを入力してログイン処理を完了してください。","ui.login.totp":"確認コード","ui.login.forgotPassword":"パスワードを忘れましたか?","ui.login.button":"サインイン","ui.login.passkey":"パスキーでサインイン","ui.login.cancel":"取り止め","ui.login.or":"または","ui.login.locked":"Contao Managerはロック状態のためアクセスを拒否しました。ロックを解除するには、Contaoのルートディレクトリにあるファイル: {lockFile}を削除してください。","ui.logout.headline":"セッションタイムアウト","ui.logout.warning":"25分以上アクセスがありません。セキュリティ上の理由から、セッションを間もなく終了します。","ui.logout.expired":"30分以上アクセスがなかったため自動的にセッションを終了しました。","ui.logout.renew":"ログインを維持","ui.logout.logout":"ログアウト","ui.logout.login":"ログイン画面に戻る","ui.oauth.error":"不正なOAuthの試みです。リクエストのパラメーターを確認してください。","ui.oauth.https":"平文で認証トークンが転送されることを防ぐため、リダイレクトのURIは安全なプロトコル(https:)を*使用*しなければなりません。","ui.oauth.headline":"リモート認証","ui.oauth.description":"以下のアプリケーションやサービスが、このContao Managerへのリモートアクセスを要求しています。","ui.oauth.domain":"アクセスを許可する前に、このURLのことを知っていて所有者を信頼できることを確認してください!","ui.oauth.outOfScope":"残念ですが、このアクセスを許可するのに十分な権限がありません。","ui.oauth.allow":"アクセスを許可","ui.oauth.deny":"アクセスを拒否","ui.oauth.switchUser":"ユーザーを切り替え","ui.scope.admin":"ユーザー管理を含んだ管理者アクセス","ui.scope.install":"新しいパッケージのインストールとContaoの構成の変更","ui.scope.update":"パッケージの更新と保守の作業の実行","ui.scope.read":"パッケージと構成の読み取り","ui.boot.headline":"システム検査","ui.boot.description":"しばらくお待ちください、サーバーを解析中です...","ui.boot.issue1":"インストール上の問題を検出","ui.boot.issue2":"Contao Managerを使用できるようにする前に修正しなければならない問題があります。","ui.boot.run":"Contao Managerを開始","ui.boot.safeMode":"セーフモードで開始","ui.recovery.headline":"システム回復","ui.recovery.description":"Contao ManagerはContaoと思われるファイルを検出しましたが、コマンド行のインターフェイスは期待した様に動作しませんでした。","ui.recovery.console":"コンソール出力","ui.recovery.repairOptions":"インストールしたContaoを修正する方法を選択してください。","ui.recovery.repairHeadline":"自動修復","ui.recovery.repairDescription":"アプリケーションキャッシュの再構築とComposerパッケージを再インストールすることで、自動的にインストールの修復を試みます。","ui.recovery.repairWarning":"この処理でベンダーのファイルに行った変更は取り消されるかもしれません!","ui.recovery.repairFailed":"自動修復できませんでした。セーフモードで手作業でインストールを修復してみてください。","ui.recovery.repairButton":"システム修復を実行","ui.recovery.safeModeHeadline":"セーフモード","ui.recovery.safeModeDescription":"Contao Managerをセーフモードで開始するとパッケージの管理と特定の保守のタスクを実行できます。しかし、インストールしたContaoの動作に依存した機能は利用できません。","ui.recovery.safeModeButton":"セーフモードで開始","ui.server.pending":"待機中...","ui.server.running":"解析中…","ui.server.error":"サーバーからの予期しない応答のため検査に失敗しました。","ui.server.details":"詳細","ui.server.prerequisite":"前提条件を満たせていないため検査を取り止めました。","ui.server.selfUpdate.title":"Contao Managerを更新","ui.server.selfUpdate.update":"新しいContao Managerのバージョン {latest} を利用できます。","ui.server.selfUpdate.manualUpdate":"新しいContao Managerバージョン{latest}を利用できます。使用しているサーバーは自動的な更新をサポートしていません、新しいバージョンを {download} からダウンロードしてください。","ui.server.selfUpdate.latest":"最新のバージョン: {current}を使用しています。","ui.server.selfUpdate.dev":"開発版は自動的な更新をサポートしていません。","ui.server.selfUpdate.unsupported":"新しいバージョンを利用できますが、使用しているPHPのバージョンをサポートしていません。","ui.server.selfUpdate.button":"自己更新を実行","ui.server.selfUpdate.continue":"続ける","ui.server.config.title":"サーバーの構成","ui.server.config.setup":"構成","ui.server.config.change":"変更","ui.server.config.save":"保存","ui.server.config.cancel":"取り止め","ui.server.config.customOption":"その他…","ui.server.config.description":"バックグラウンドのタスクを正しく実行するため、Contao ManagerはPHPのコマンド行の実行ファイルがある場所と、ウェブのプロセスから切り離してコマンドを実行する方法を知る必要があります。","ui.server.config.formTitle":"サーバーの構成","ui.server.config.formText":"PHPの実行ファイルのパスを入力してください。Webのプロセスと同じバージョンのPHPであることを忘れずに確認してください。","ui.server.config.cloudTitle":"Composerリゾルバークラウド","ui.server.config.cloudText":"Composerリゾルバークラウドによって、サーバーが十分なローカルのメモリを提供しない場合でもComposerの依存関係のインストールが可能になります。パッケージの情報がContao Associationが運用するクラウドに送信されることに注意してください。","ui.server.config.cloud":"Composerリゾルバークラウドを使用","ui.server.config.cli":"PHPの実行ファイル","ui.server.config.stateErrorCli":"有効なPHPの実行ファイルをサーバー上に見つけられませんでした。","ui.server.config.stateErrorCloud":"Composerリゾルバークラウドをサポートしていません。","ui.server.config.stateSuccess":"PHPの実行ファイルは{php_cli}です。","ui.server.config.cloudEnabled":"パッケージの依存関係はComposerリゾルバークラウドを使用して解決します。","ui.server.config.cloudDisabled":"Composerリゾルバークラウドは無効です。","ui.server.php_web.title":"PHPのWebプロセス","ui.server.php_web.below7":"PHPのバージョン {version} を検出しました。可能な限りPHP 7に切り替えてください!","ui.server.php_web.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.php_cli.title":"PHPコマンド行インターフェイス","ui.server.php_cli.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.composer.title":"Composer環境","ui.server.composer.success":"既知の問題はありませんでした。","ui.server.composer.install":"Composerの依存関係はインストールしていません。","ui.server.composer.button":"インストール","ui.server.contao.title":"Contaoのインストール","ui.server.contao.setup":"セットアップ","ui.server.contao.check":"データベースを検査","ui.server.contao.empty":"インストールしているContaoは見つかりませんでした。","ui.server.contao.old":"Contaoのバージョン{version}はContao Managerと互換性がありません。インストールしているContaoを手作業で更新してください。","ui.server.contao.found":"Contao {version} (APIバージョン {api})を検出しました。","ui.server.contao.connectionError":"データベースサーバーに接続できません。","ui.server.contao.connectionProblem":"データベースの問題が見つかりました。","ui.server.contao.missingUser":"管理者のアカウントがありません。","ui.setup.continue":"続ける","ui.setup.manager":"Contao Managerを開始","ui.setup.cancel":"取り止め","ui.setup.welcome":"ようこそ","ui.setup.welcome1":"このウィザードはContaoオープンソースCMSを設定するのに必要な段階を案内します。","ui.setup.welcome2":"もし質問がありましたらドキュメント、フォーラム、Slackのチャンネル、さらに多くの情報を{support}のページから探してください。","ui.setup.support":"コミュニティサポート","ui.setup.start":"始める","ui.setup.complete":"おめでとうございます!","ui.setup.complete1":"Contao {version}をうまくインストールしました。","ui.setup.complete2":"設定の処理を終えるには、インストールツールを開いて、データベース接続を構成し、バックエンドのユーザーを作成してください。","ui.setup.complete3":"Contaoのバックエンドでウェブサイトを作成できるようになりました。追加の機能拡張が必要な場合は、Contao Managerを続けてください。","ui.setup.installTool":"インストールツールを開く","ui.setup.login":"Contaoにログイン","ui.setup.funding":"フリーソフトウェアの「フリー」は「言論の自由」の自由であって、「無料のビール」の「無料」ではありません。Contaoのようなオープンソースのプロジェクトは一人の個人や1つの会社では集められない資金を必要とします。\\nContaoでウェブサイトを構築したり、構築したウェブサイトを販売される場合は、ビジネスが依存する製品に金銭的に貢献されることを期待しています。","ui.setup.fundingLink":"さらに学ぶ","ui.setup.document-root.headline":"Webサーバーの設定","ui.setup.document-root.warning":"Contao ManagerからContaoをインストールするには、Webサーバーのドキュメントルートを修正しなければなりません。","ui.setup.document-root.description1":"Contaoは公開するファイルに別のフォルダーを使用し、その親のフォルダーにアプリケーションのファイルをインストールします。フォルダーの構造が正しくないか、またはフォルダーが空でない場合はContaoをインストールできません。","ui.setup.document-root.description2":"ドキュメントルートを構成する方法を知らない場合は、Contaoのドキュメントを読むかホスティングサービスの提供者に連絡してください。","ui.setup.document-root.documentation":"ドキュメントを読む","ui.setup.document-root.conflictsTitle":"インストール先のディレクトリが空ではありません","ui.setup.document-root.conflictsDirectory":"Contaoをインストールしようとしているルートのディレクトリが空ではありません、インストールの処理で{count}個のファイルを上書きするかもしれません。Contaoのために空のディレクトリ構造の作成を推奨しますが、以下のファイルを使用していないことが確かな場合は、これらを削除して再検査することもできます。","ui.setup.document-root.ignoreConflicts":"空でないディレクトリにContaoをインストールしようとしています。Web領域の既存のファイルを上書きする可能性を理解しています。","ui.setup.document-root.check":"再検査","ui.setup.document-root.create":"ディレクトリを作成","ui.setup.document-root.change":"ディレクトリを変更","ui.setup.document-root.formTitle":"ディレクトリ設定","ui.setup.document-root.formText1":"Contao Managerはサーバー上に新しいディレクトリ構成を自動的に作成できます。","ui.setup.document-root.formText2":"手作業で(例えば、ホスティングの管理パネルから)新しいドキュメントルートを構成する必要があります。","ui.setup.document-root.autoconfig":"サーバーの構成を変更しなければならないことを理解しました。ドキュメントルートを構成しないとContao Managerは壊れ、(アカウントの詳細とパスワードを含んだ)構成ファイルを剥き出しの状態にしてしまいます。","ui.setup.document-root.directory":"新しいディレクトリ","ui.setup.document-root.currentRoot":"現在のドキュメントルート","ui.setup.document-root.newRoot":"新しいドキュメントルート","ui.setup.document-root.finish":"ディレクトリの設定","ui.setup.document-root.publicDir":"{dir}を(Contao {version}の)公開ファイルの場所として使用","ui.setup.document-root.directoryInvalid":"有効なディレクトリの名前を入力してください。","ui.setup.document-root.directoryExists":"目的のディレクトリは既に存在します。異なる名前を入力してください。","ui.setup.document-root.confirmation":"Contao ManagerはContaoのインストールに必要なディレクトリを作成しました。次にウェブサーバーのドキュメントルートを構成しなければなりません。このページをそれまで再読み込みしないでください。","ui.setup.document-root.reload":"ページを再読み込み","ui.setup.document-root.success":"ウェブサーバーにディレクトリ構造を正しく設定できました!","ui.setup.document-root.installingProjectDir":"{dir}にアプリケーションのファイルをインストールします。","ui.setup.document-root.installingPublicDir":"{dir}に公開するファイルをインストールします。","ui.setup.document-root.installedProjectDir":"{dir}にアプリケーションのファイルをインストールしました。","ui.setup.document-root.installedPublicDir":"{dir}に公開するファイルをインストールしました。","ui.setup.create-project.headline":"Contaoのインストール","ui.setup.create-project.description":"Contaoの開発は{semver}の概念にしたがっていて、新しいマイナーバージョンを6か月毎にリリースします。現在サポートしているリリース:","ui.setup.create-project.semver":"セマンティックバージョニング","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"長期サポート版","ui.setup.create-project.latestQ1":"最新のバージョン、もっとも多くの機能を提供して{year}年2月までサポートします。","ui.setup.create-project.latestQ3":"最新のバージョン、もっとも多くの機能を提供して{year}年8月までサポートします。","ui.setup.create-project.ltsText":"現在のLTSバージョン、安定性を重視する場合に選んでください。さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.pltsText":"以前のLTSバージョン、さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.requiresPHP":"少なくともPHP {version}が必要です、現在はPHP {current}です。","ui.setup.create-project.releaseplan":"詳細な情報は{contaoReleasePlan}を参照してください。","ui.setup.create-project.releaseplanLink":"Contaoのリリース計画","ui.setup.create-project.installed":"サーバーにContao {version}のインストールに成功しました。データベースの設定を続けるか、異なるバージョンをインストールするにはContao Managerを起動してください。","ui.setup.create-project.formTitle":"配布の選択","ui.setup.create-project.formText":"インストールするバージョンを選択してください。","ui.setup.create-project.version":"バージョン","ui.setup.create-project.demo":"Contaoのデモ版のWebサイトをインストール","ui.setup.create-project.demoDescription":"デモ版のWebサイトはContaoと、その基本的な特徴を知る助けとなります。テーマはさらに{store}で入手できます。","ui.setup.create-project.coreOnly":"最小のインストール(コアだけ)","ui.setup.create-project.noUpdate":"インストールを省く(専門家だけ!)","ui.setup.create-project.theme":"Contaoのテーマ","ui.setup.create-project.themeInstall":"Contaoのテーマをインストールするには、検索入力を使用するか、Contao Managerからのインストールをサポートしたテーマのファイル(.ctoまたは.zip)をアップロードしてください。","ui.setup.create-project.themeBuy":"必ず公式の{store}にアクセスしてください。","ui.setup.create-project.themeStore":"Contaoのテーマのストア","ui.setup.create-project.themeUpload":"テーマのファイル(.cto/.zip)をアップロード","ui.setup.create-project.themeInvalid":"アップロードしたファイルはContaoのテーマではないか、Contao Managerをサポートしていません。","ui.setup.create-project.themeWarning":"このテーマがサーバーと互換性があるかどうか、COntao Managerは判断できません。何か疑問がある場合はテーマのベンダーに相談してください。","ui.setup.create-project.themeTitle":"テーマの詳細を調査","ui.setup.create-project.themeDetails":"このテーマは以下の依存関係とファイルもインストールします。","ui.setup.create-project.themeRequire":"{count} 依存関係 | {count} 依存関係","ui.setup.create-project.themeFiles":"{count} ファイル | {count} ファイル","ui.setup.create-project.theme.or":"または公開テーマを検索","ui.setup.create-project.theme.search":"テーマを検索","ui.setup.create-project.theme.more":"さらにテーマ","ui.setup.create-project.theme.empty":"{query}に一致するテーマがありません。","ui.setup.create-project.theme.uploaded":"テーマのファイルのアップロードに成功しました。","ui.setup.create-project.theme.packageName":"パッケージ名","ui.setup.create-project.theme.version":"バージョン","ui.setup.create-project.theme.authors":"作成者","ui.setup.create-project.theme.upload":"{name} ({size})をアップロード中","ui.setup.create-project.install":"インストール","ui.setup.create-project.cancel":"取り止め","ui.setup.create-project.fileError":"{file}にcomposer.jsonがありません。","ui.setup.create-project.jsonError":"composer.jsonが不正なJSONを含んでいます。","ui.setup.create-project.schemaError":"composer.jsonのスキーマの検証に失敗しました。","ui.setup.database-connection.headline":"データベース接続","ui.setup.database-connection.description":"Contaoはページ、コンテント、ユーザー、他の関係のあるデータを保管するためにMySQLデータベース(またはMariaDBの様な互換性のある分岐)を必要とします。接続のパラメーターは、Contaoをインストールしたプロジェクトのルートにある{env}ファイルに保存します。","ui.setup.database-connection.formTitle":"接続パラメーター","ui.setup.database-connection.formText":"データベースのURLを入力するか、ユーザー名、パスワード、サーバー、データベースの欄を別々に入力してください。","ui.setup.database-connection.url":"データベースのURL","ui.setup.database-connection.validUrl":"データベースのURLが正しくないか、サーバーへの接続に失敗しました。","ui.setup.database-connection.or":"または","ui.setup.database-connection.user":"ユーザー名","ui.setup.database-connection.password":"パスワード","ui.setup.database-connection.server":"サーバー(:ポート)","ui.setup.database-connection.database":"データベース名","ui.setup.database-connection.connected":"{server}のデータベース{database}に接続しました。","ui.setup.database-connection.error":"データベースの接続のエラーです。","ui.setup.database-connection.problem":"Contaoはデータベースサーバーの問題を検出しました。","ui.setup.database-connection.schemaTitle":"データベーススキーマ","ui.setup.database-connection.migration":"未解決の移行が1件あります。 | 未解決の移行が{count}件あります。","ui.setup.database-connection.schema":"未解決のスキーマの更新が1件あります。 | 未解決のスキーマの更新が{count}件あります。","ui.setup.database-connection.noChanges":"データベースのスキーマは最新です。","ui.setup.database-connection.check":"データベースを検査","ui.setup.database-connection.skip":"飛ばす","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"認証情報を変更","ui.setup.database-connection.restoreTitle":"データベースをインポート","ui.setup.database-connection.restoreText":"先ほどインストールしたテーマはデータベースのバックアップを含んでいます。データベースを復元してテーマのデータを取り込むか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。 | 先ほどインストールしたテーマは複数のデータベースのバックアップを含んでいます。バックアップのファイルを選択してテーマのデータをインポートするか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。","ui.setup.database-connection.backup":"インポート前に現在のデータベースをバックアップ","ui.setup.database-connection.backupWarning":"データベースのすべてのデータを上書きします。データベースが空でない場合は最初にバックアップを作成してください。","ui.setup.database-connection.restore":"テーマのデータベースをインポート","ui.setup.database-connection.restoreOption":"{date} ({size})からバックアップ","ui.setup.database-connection.restored":"テーマのデータベースのインポートに成功しました。データベースのスキーマの検証に進んでください。","ui.setup.backend-user.success":"データベースにContaoのバックエンドの管理者のアカウントがあります。さらにユーザーを追加するにはContaoのバックエンドを使用してください。","ui.setup.backend-user.error":"ユーザーのリストを取り出せません。詳細はコンソールの出力を確認してください。","ui.setup.backend-user.headline":"バックエンドのアカウント","ui.setup.backend-user.description":"ウェブサイトを管理するには、少なくともContaoのバックエンドの管理者のアカウントが1つ必要です。このアカウントはContao Managerと無関係なことに注意してください。","ui.setup.backend-user.formTitle":"アカウントを作成","ui.setup.backend-user.formText":"新しいバックエンドのアカウントの詳細を入力してください。","ui.setup.backend-user.username":"ユーザー名","ui.setup.backend-user.name":"名前","ui.setup.backend-user.email":"電子メールアドレス","ui.setup.backend-user.emailInvalid":"有効な電子メールアドレスを入力してください。","ui.setup.backend-user.password":"パスワード","ui.setup.backend-user.passwordPlaceholder":"最小で8文字","ui.setup.backend-user.passwordLength":"少なくとも8文字を入力してください。","ui.setup.backend-user.create":"アカウントを追加","ui.task.headline":"バックグランドのタスク","ui.task.loading":"詳細を読み込み中...","ui.task.created":"詳細を読み込み中...","ui.task.active":"Contao Managerがバックグラウンドでタスクの処理を実行を開始するまで、しばらくお待ちください。","ui.task.complete":"すべての処理を正常に完了しました。詳細はコンソールの出力を確認してください。","ui.task.paused":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.aborting":"バックグラウンドの処理を取り消すまで、しばらくお待ちください。","ui.task.stopped":"バックグラウンドの処理の一部を取り消しました。コンソールの出力を確認してください。","ui.task.error":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.failed":"Contao Managerはバックグラウンドのタスクを開始できませんでした!","ui.task.failedDescription1":"バックグラウンドで処理を実行しようとするときに何か問題がありました。","ui.task.failedDescription2":"これが再度起きる場合は、サーバーはサポートされていないかもしれません。","ui.task.reportProblem":"問題を報告","ui.task.pausedDescription":"エラーを無視して残る作業を実行したい場合は「続ける」をクリックしてください。","ui.task.sponsor":"{sponsor}が後援のComposer Cloud","ui.task.buttonAudit":"データベースを更新","ui.task.buttonClose":"閉じる","ui.task.buttonConfirm":"確認して閉じる","ui.task.buttonContinue":"続ける","ui.task.buttonCancel":"取り止め","ui.task.confirmCancel":"このタスクを本当に取り止めて良いですか?  取り止めるとContaoのインストールを壊れた状態のままにするかもしれません。","ui.task.autoclose":"正常に終了したときにタスクの詳細を閉じる","ui.console.toggle":"コンソールの出力を表示・非表示","ui.console.showLog":"完全なコンソールのログを表示","ui.console.copyLog":"ログをクリップボードにコピー","ui.migrate.headline":"データベースの更新","ui.migrate.migrationsOnly":"(移行だけ)","ui.migrate.schemaOnly":"(スキーマだけ)","ui.migrate.loading":"しばらくお待ちください、データベースを検査中です...","ui.migrate.empty":"未解決な移行やスキーマの更新はありません。データベースは最新です。","ui.migrate.emptyMigrations":"未解決な移行はありません。スキーマの更新も忘れずにしてください。","ui.migrate.emptySchema":"未解決なスキーマの更新はありません。移行の確認も忘れずにしてください。","ui.migrate.pending":"データベースが最新ではありません。以下のコンソール出力を再確認して変更を実行してください。","ui.migrate.previousChanges":"以前のデータベース移行を確認できませんでした。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.previousComplete":"以前のデータベース移行を確認できませんでしたので、以下のコンソール出力を再確認してください。\\nこれ以上の未解決な変更はありません。","ui.migrate.appliedChanges":"データベースの更新を適用しました。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.appliedComplete":"データベースの更新を適用しました。\\n未確認の移行やスキーマの更新はありません。データベースは最新の状態です。","ui.migrate.problem":"Contaoはデータベースサーバーの問題を検出しました。\\n下のコンソール出力を再確認して修正しなければならない事項を調査してください!","ui.migrate.warning":"Contaoはデータベースサーバーの誤った設定を検出しました。\\n一時的に警告は無視できますが、最適な性能とデータの一貫性のためには修正しなければなりません。","ui.migrate.error":"変更を適用できませんでした。データベースは変更されているかもしれません、再確認して再実行してください。","ui.migrate.execute":"実行","ui.migrate.close":"閉じる","ui.migrate.confirm":"確認して閉じる","ui.migrate.cancel":"取り止め","ui.migrate.continue":"続ける","ui.migrate.setup":"セットアップ","ui.migrate.skip":"飛ばす","ui.migrate.retry":"再検査","ui.migrate.retryAll":"すべて検査","ui.migrate.withDeletes":"DROPの処理を含む、すべてのデータベースの変更を実行します。","ui.migrate.migrationTitle":"データベースの移行","ui.migrate.schemaTitle":"スキーマの更新","ui.migrate.problemTitle":"データベースの問題","ui.migrate.warningTitle":"データベースの警告","ui.migrate.addTable":"テーブルを追加","ui.migrate.dropTable":"テーブルを削除","ui.migrate.addField":"項目{table}.{field}を追加","ui.migrate.changeField":"項目{table}.{field}を変更","ui.migrate.dropField":"項目{table}.{field}を削除","ui.migrate.createIndex":"{table}にインデックス\\"{name}\\"を作成","ui.migrate.dropIndex":"{table}のインデックス\\"{name}\\"を削除","ui.widget.mandatory":"この欄の入力は必須です。","ui.widget.blankOption":"選択してください…","ui.widget.showPassword":"パスワードを表示","ui.widget.hidePassword":"パスワードを非表示","ui.error.title":"\\"{method} {url}\\"というHTTPの要求に失敗しました。","ui.error.server500":"予期しないエラーがサーバーで発生したようです。Webサーバー(Apache/Nginx)のログファイルと、Contao Managerの\\"contao-manager/logs\\"へのログを確認してください。","ui.error.response":"サーバーは{status}という応答コードを返しました。","ui.error.moreLink":"詳細な情報","ui.error.support":"Contaoサポート","ui.error.permission":"この機能を使用する権限がありません。","ui.footer.help":"ヘルプ","ui.footer.reportProblem":"問題を報告","ui.navigation.discover":"発見","ui.navigation.packages":"パッケージ","ui.navigation.tools":"ツール","ui.navigation.installTool":"インストールツール","ui.navigation.backend":"Contaoのバックエンド","ui.navigation.debug":"Contaoのデバッグモード","ui.navigation.logViewer":"ログ表示","ui.navigation.phpinfo":"PHPの情報","ui.navigation.phpinfoLoading":"PHPの情報を読み込み中...","ui.navigation.maintenance":"保守","ui.navigation.rebuildCache":"キャッシュを再作成","ui.navigation.users":"アカウント","ui.navigation.systemCheck":"システム検査","ui.navigation.advanced":"詳細","ui.navigation.logout":"ログアウト","ui.maintenance.database.title":"データベースの移行とバックアップ","ui.maintenance.database.description":"データベースの移行はデータとテーブルのスキーマの一貫性を確保します。","ui.maintenance.database.migrations":"未解決のデータベース移行が1件 | 未解決のデータベース移行が{count}件","ui.maintenance.database.schemaUpdates":"未解決のスキーマの更新が1件 | 未解決のスキーマの更新が{count}件","ui.maintenance.database.error":"データベースの問題が見つかりました。","ui.maintenance.database.warning":"データベースの警告が見つかりました。","ui.maintenance.database.button":"データベースを検査","ui.maintenance.database.migrationOnly":"移行だけを検査","ui.maintenance.database.schemaOnly":"スキーマだけを検査","ui.maintenance.database.installTool":"インストールツールを開く","ui.maintenance.database.createBackup":"バックアップを作成","ui.maintenance.database.backupUnsupported":"このContaoのバージョンではデータベースのバックアップをサポートしていません。","ui.maintenance.database.backupList":"データベースのバックアップが1個あって、{date}に作成されています。 | データベースのバックアップが{count}個あって、最新のものは{date}に作成されています。","ui.maintenance.database.backupEmpty":"現在データベースのバックアップはありません。","ui.maintenance.rebuildCache.title":"アプリケーションキャッシュ","ui.maintenance.rebuildCache.description":"構成ファイルのいずれかを修正した後はアプリケーションキャッシュの再構築が必要です。","ui.maintenance.rebuildCache.rebuildProd":"実稼働用のキャッシュを再構築","ui.maintenance.rebuildCache.rebuildDev":"開発用のキャッシュを再構築","ui.maintenance.rebuildCache.clearProd":"実稼働用のキャッシュを消去","ui.maintenance.rebuildCache.clearDev":"開発用のキャッシュを消去","ui.maintenance.installTool.title":"Contaoインストールツール","ui.maintenance.installTool.description":"連続して3回誤ったパスワードを入力すると、Contaoのインストールツールは自動的にロック状態となります。","ui.maintenance.installTool.unlock":"インストールツールのロックを解除","ui.maintenance.installTool.lock":"インストールツールをロック","ui.maintenance.dumpAutoload.title":"Composerクラスローダー","ui.maintenance.dumpAutoload.description":"ComposerのオートローダーがPHPのクラスの読み込み担当します。rootのcomposer.jsonに独自のネームスペースを追加した後は、オートローダーを書き出さなければなりません。","ui.maintenance.dumpAutoload.button":"オートローダーを書き出し","ui.maintenance.composerInstall.title":"Composerの依存関係","ui.maintenance.composerInstall.description":"Composerの依存関係はアプリケーションのルートの{vendor}フォルダーに配置されています。{composerLock}ファイルを操作や手動でアップロードした後は依存関係の再インストールが必要な場合があります。","ui.maintenance.composerInstall.button":"インストーラーを実行","ui.maintenance.composerInstall.update":"Composerで更新を実行","ui.maintenance.composerCache.title":"Composerキャッシュ","ui.maintenance.composerCache.description":"Composerは性能向上のためにダウンロードしたパッケージをキャッシュします。壊れたファイルのような問題がある場合は、Composerキャッシュを削除して強制的に新しいダウンロードを行ってみてください。","ui.maintenance.composerCache.button":"キャッシュを消去","ui.maintenance.maintenanceMode.title":"保守モード","ui.maintenance.maintenanceMode.description":"Contaoを保守モードにするとウェブサイトでは\\"503 Service Unavailable\\"のテンプレートを表示します。","ui.maintenance.maintenanceMode.enable":"有効","ui.maintenance.maintenanceMode.disable":"無効","ui.maintenance.debugMode.title":"デバッグモード","ui.maintenance.debugMode.description":"{appDevPhp}のエントリーポイントにユーザーとパスワードを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.descriptionJwt":"現在のドメインにデバッグ用のクッキーを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.activate":"有効化","ui.maintenance.debugMode.deactivate":"無効化","ui.maintenance.debugMode.credentials":"認証情報","ui.maintenance.debugMode.user":"デバッグモードのユーザー名を入力してください。","ui.maintenance.debugMode.password":"デバッグモードのパスワードを入力してください。","ui.maintenance.opcodeCache.title":"Opcodeキャッシュ","ui.maintenance.opcodeCache.description":"Opcodeは高速な実行のためにPHPのファイルをウェブプロセス常にキャッシュします。変更後にファイルの変化を認識していないといった、特定の状況では削除しなければなりません。","ui.maintenance.opcodeCache.button":"キャッシュを切り詰め","ui.maintenance.safeMode":"セーフモードでは利用不可","ui.maintenance.unsupported":"このContaoのバージョンでは非サポート","ui.packages.updateButton":"パッケージを更新","ui.packages.searchButton":"パッケージを検索","ui.packages.searchPlaceholder":"パッケージを検索中…","ui.packages.uploadOverlay":"アップロードするファイルをドラッグアンドドロップ","ui.packages.uploadButton":"パッケージをアップロード","ui.packages.uploadMessage":"未確認の1個のアップロードがあります。 | 未確認の{count}個のアップロードがあります。","ui.packages.uploadApply":"アップロードを実行","ui.packages.uploadReset":"アップロードを削除","ui.packages.uploadIncomplete":"このファイルは完全にアップロードできていません。一旦削除削除してもう一度アップロードしてください。","ui.packages.uploadDuplicate":"このファイルを複数回アップロードした様です。重複しているファイルを削除してください。","ui.packages.uploadInstalled":"このファイルを既にインストールしています。重複しているファイルを削除してください。","ui.packages.uploadUnsupported":"インストールしたContaoはアップロードをサポートしていません。PHPのzip拡張のインストールと依存関係の更新を確認してください。","ui.packages.changesMessage":"未確認の1個の変更があります。 | 未確認の{count}個の変更があります。","ui.packages.changesDryrun":"変更を試行","ui.packages.changesApply":"変更を適用","ui.packages.changesApplyAll":"すべてのパッケージを更新","ui.packages.changesDryrunAll":"すべてのパッケージの変更を試行","ui.packages.changesReset":"変更をリセット","ui.packages.changesReview":"変更を見直し","ui.packagelist.loading":"読み込み中...","ui.packagelist.uploads":"アップロード","ui.packagelist.added":"新しいパッケージ","ui.packagelist.installed":"インストール済みのパッケージ","ui.package.hintRevert":"変更を取り消す","ui.package.hintNoupdate":"更新しない","ui.package.hintConstraint":"この変更を適用すると、このパッケージを{constraint}の制約によりインストールします。","ui.package.hintConstraintBest":"変更を適用すると、このパッケージの利用できる一番良いバージョンをインストールします。","ui.package.hintConstraintChange":"変更を適用すると、このパッケージへの制約は\\"{from}\\"から\\"{to}\\"に変更します。","ui.package.hintConstraintUpdate":"変更を適用すると、このパッケージを更新します。","ui.package.hintAdded":"変更を適用すると、このパッケージをインストールします。","ui.package.hintRemoved":"変更を適用すると、このパッケージを削除します。","ui.package.requiredTitle":"手作業で追加済み","ui.package.requiredText":"このパッケージはcomposer.jsonで必要としていますが、インストールされていません。","ui.package.removedTitle":"手作業で削除済み","ui.package.removedText":"このパッケージはcomposer.jsonから削除されています。","ui.package.installed":"インストール済み:","ui.package.version":"バージョン{version}","ui.package.additionalDownloads":"{count}個のダウンロード | {count}個のダウンロード","ui.package.additionalStars":"{count}のスター | {count}のスター","ui.package.editConstraint":"編集","ui.package.uploadConstraint":"この定数はアップロードしたパッケージで定義されています。","ui.package.updateButton":"更新","ui.package.removeButton":"削除","ui.package.installButton":"パッケージを追加","ui.package.installButtonShort":"追加","ui.package.detailsButton":"詳細","ui.package.latestConstraint":"最新のバージョン","ui.package.update":"更新を利用可能","ui.package.updateLatest":"最新のバージョン","ui.package.updateAvailable":"バージョン{version}を利用可能","ui.package.updateUnknown":"不明なバージョン","ui.package.updateConstraint":"バージョンの制約外に利用できる新しいバージョンがあります。","ui.package.incompatible":"{package}はContao {constraint}では動作しません。","ui.package.incompatibleWarning":"どの安定版のリリースの{package}もContao {constraint}では動作しません。パッケージの追加とバージョンの制約を設定して、開発ブランチのインストールを試しますか?","ui.package.incompatibleConstraint":"このパッケージにはContao {constraint}のための安定版のリリースがありません。開発ブランチのインストールを試すには、バージョンの制約を設定してください。","ui.package.incompatibleButton":"インストール","ui.cloudStatus.headline":"Composerリゾルバークラウド","ui.cloudStatus.version":"バージョン{version}","ui.cloudStatus.waitingTime":"待ち時間","ui.cloudStatus.jobs":"現在のジョブ","ui.cloudStatus.workers":"ワーカー","ui.cloudStatus.approx":"{minutes}分","ui.cloudStatus.none":"なし","ui.cloudStatus.short":"ca. {minutes}分","ui.cloudStatus.long":"ca. {minutes}分{seconds}秒","ui.cloudStatus.error":"Composerリゾルバークラウドの状態を取得できません。保守または技術的な問題のため停止しているかもしれません。","ui.cloudStatus.button":"クラウドの状態","ui.cloudStatus.refresh":"クラウドの状態を更新","ui.log-viewer.loading":"読み込み中...","ui.log-viewer.empty":"サーバーにログファイルはありません。","ui.log-viewer.reload":"際読み込み","ui.log-viewer.file":"ログファイル","ui.log-viewer.channel":"チャネル","ui.log-viewer.channelTitle":"このメッセージを記録する先のチャネルです。","ui.log-viewer.level":"レベル","ui.log-viewer.levelTitle":"ログメッセージの深刻さです。","ui.log-viewer.timeHeader":"時刻","ui.log-viewer.messageHeader":"メッセージ","ui.log-viewer.showContext":"コンテキストを表示","ui.log-viewer.hideContext":"コンテキストを非表示","ui.log-viewer.showExtra":"追加を表示","ui.log-viewer.hideExtra":"追加を非表示","ui.log-viewer.more":" さらに読み込む...","ui.log-viewer.download":"ダウンロード","ui.log-viewer.downloadTitle":"\\"{file}\\"をダウンロード","ui.log-viewer.prodEnvironment":"実運用環境","ui.log-viewer.devEnvironment":"開発環境(デバッグモード)","ui.user-manager.loading":"ユーザーを読み込み中...","ui.user-manager.changePassword":"パスワードを変更","ui.user-manager.setupTotp":"2ファクター認証を設定","ui.user-manager.disableTotp":"2ファクター認証を無効","ui.user-manager.invite":"ユーザーを招待","ui.user-manager.delete":"削除","ui.user-manager.deleteConfirm":"ほんとうにユーザー: \\"{username}\\"を削除しますか?","ui.user-manager.deleted":"ユーザー: {username}を削除しました。","ui.user-manager.passwordHeadline":"パスワードを変更","ui.user-manager.passwordText":"パスワードを変更するには、現在のパスワードと新しいパスワードをそれぞれの欄に入力してください。","ui.user-manager.currentPassword":"現在のパスワード","ui.user-manager.newPassword":"新しいパスワード","ui.user-manager.passwordPlaceholder":"最小で8文字","ui.user-manager.submitPassword":"送信","ui.user-manager.passwordChanged":"パスワードを変更しました。","ui.user-manager.passwordError":"このパスワードは間違っています。","ui.user-manager.inviteHeadline":"ユーザーを招待","ui.user-manager.inviteText":"Contao Managerに複数のログイン情報が必要な場合、ここで招待のリンクを作成できます。このリンクを誰か、または他の機器で使用して、指定した権限の新しいアカウントを作成してください。","ui.user-manager.inviteSuccess1":"新しい招待のリンクを作成しました。以下のURLを使用して、このContao Managerの新しいユーザーを作成できます。この招待は(今から1週間後の){expires}に期限が切れます。","ui.user-manager.inviteSuccess2":"リンクをクリップボードにコピーしてください。一度だけ動作し、このダイアログを閉じた後に再び見ることはできません。","ui.user-manager.createInvitation":"招待のリンクを作成","ui.user-manager.clipboard":"クリップボードにコピー","ui.user-manager.permissions":"権限について学ぶ","ui.user-manager.cancel":"取り止め","ui.user-manager.close":"閉じる","ui.user-manager.you":"あなた","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"このアカウントは2ファクター認証により安全です。","ui.user-manager.2faDisabled":"このアカウントはに2ファクター認証が設定されていないため安全ではありません。","ui.user-manager.passkey":"パスキー","ui.user-manager.passkeyTitle":"このアカウントはパスキーにより安全です。","ui.totp.headline":"2ファクター認証","ui.totp.setupQr":"2FA/TOTPアプリでQRコードを読み取ってください。","ui.totp.setupCode":"QRコードを読み取れない場合は、このキーを代わりに入力してください: ","ui.totp.codeLabel":"確認コード","ui.totp.codeDescription":"2FA/TOTPアプリが生成した確認コードを入力してください。","ui.totp.disableText":"2ファクター認証を無効にするには確認コードを入力してください。","ui.totp.invalid":"確認コードが無効です。","ui.totp.enable":"有効","ui.totp.disable":"無効","ui.totp.cancel":"取り止め","ui.totp.enabled":"2ファクター認証を有効にしました。","ui.totp.disabled":"2ファクター認証を無効にしました。","ui.totp.setup":"2ファクター認証を設定","ui.totp.skip":"2ファクター認証を飛ばす"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[830],{4830:function(a,e,t){t.r(e),t.d(e,{default:function(){return Ba}});var s=t(641),n=t(33);const i={class:"package-popup__installed"},l=["dateTime","title"],o=["href"],p={key:3},c={class:"package-popup__update"},r={class:"package-popup__incompatible"};function u(a,e,t,u,d,k){const g=(0,s.g2)("package-constraint"),m=(0,s.g2)("install-button"),h=(0,s.g2)("package-details",!0);return(0,s.uX)(),(0,s.Wv)(h,{local:k.data,dependents:k.dependents},(0,s.eX)({"package-actions":(0,s.k6)(()=>[(0,s.RG)(a.$slots,"package-actions",{},()=>[a.isInstalled?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[!a.isFeature&&a.isVisible?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0),(0,s.Lk)("p",i,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.installed")),1),a.installedTime?((0,s.uX)(),(0,s.CE)("time",{key:0,dateTime:a.installedTime,title:k.datimFormat(a.installedTime)},(0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),9,l)):((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.eW)((0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),1)],64))])],64)):a.canBeInstalled&&a.isCompatible||a.isAdded||a.isRequired?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.bF)(m,{data:k.data},null,8,["data"]),a.isAdded||a.isRequired?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0)],64)):a.isPrivate?((0,s.uX)(),(0,s.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,o)):((0,s.uX)(),(0,s.CE)("div",p))])]),"suggest-actions":(0,s.k6)(({name:e})=>[a.packageSuggested(e)?((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:e}},null,8,["data"])):(0,s.Q3)("",!0)]),"features-actions":(0,s.k6)(({name:e})=>[!a.hasRoot||a.packageInstalled(e)||a.packageRoot(e)?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:e}},null,8,["data"]))]),_:2},[a.metadata.update&&a.metadata.update.valid&&!a.metadata.update.latest?{name:"package-update",fn:(0,s.k6)(()=>[(0,s.Lk)("p",c,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.update"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.$t("ui.package.version",{version:a.metadata.update.version}))+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(k.datimFormat(a.metadata.update.time,"short","long"))+") ",1)])]),key:"0"}:a.isCompatible?void 0:{name:"package-update",fn:(0,s.k6)(()=>[(0,s.Lk)("p",r,[(0,s.eW)((0,n.v_)(a.$t("ui.package.incompatible",{package:k.data.name,constraint:a.packageConstraint("contao/manager-bundle")}))+" ",1),!a.canBeInstalled||a.isRootInstalled||a.isAdded||a.isRequired?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("button",{key:0,type:"button",class:"widget-button widget-button--small widget-button--transparent widget-button--add",onClick:e[0]||(e[0]=(...e)=>a.install&&a.install(...e))},(0,n.v_)(a.$t("ui.package.incompatibleButton")),1))])]),key:"1"}]),1032,["local","dependents"])}t(8111),t(7588);var d=t(6278),k=t(4210),g=t(8200);const m={class:"package-popup__headline"},h=["title"],_=["title"],v={key:0,class:"package-popup__loader"},b={class:"package-popup__summary"},f={class:"package-popup__text"},y={class:"package-popup__title"},$={key:0,class:"package-popup__authors"},C=["href"],X={class:"package-popup__statistics"},E=["title"],L={key:1,class:"package-popup__stats package-popup__stats--updated"},w={key:2,class:"package-popup__stats package-popup__stats--downloads"},F={key:3,class:"package-popup__stats package-popup__stats--favers"},A={class:"package-popup__actions"},W=["href"],Q=["href"],T={class:"package-popup__tabs"},x={class:"package-popup__tabs-list"},R={key:0,class:"package-popup__abandoned"},q={key:2},P={key:3},B={key:4},I={class:"package-popup__description"};function G(a,e,t,i,l,o){const p=(0,s.g2)("loading-spinner"),c=(0,s.g2)("package-logo"),r=(0,s.g2)("more-links"),u=(0,s.g2)("details-tab"),d=(0,s.g2)("router-link"),k=(0,s.g2)("i18n-t"),g=(0,s.g2)("package-funding"),G=(0,s.g2)("details-content"),O=(0,s.g2)("popup-overlay");return(0,s.uX)(),(0,s.Wv)(O,{fixed:!0,"popup-class":"package-popup",tabindex:"-1",onClear:e[8]||(e[8]=e=>a.clearCurrent())},{content:(0,s.k6)(()=>[(0,s.Lk)("div",m,[a.hasPrevious?((0,s.uX)(),(0,s.CE)("button",{key:0,class:"package-popup__button package-popup__button--previous",title:a.$t("ui.package-details.previous"),onClick:e[0]||(e[0]=e=>a.$router.go(-1))},[...e[9]||(e[9]=[(0,s.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",fill:"#fff",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,s.Lk)("path",{d:"M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21z"})],-1)])],8,h)):(0,s.Q3)("",!0),(0,s.eW)(" "+(0,n.v_)(o.data.name)+" ",1),(0,s.Lk)("button",{class:"package-popup__button package-popup__button--close",title:a.$t("ui.package-details.close"),onClick:e[1]||(e[1]=e=>a.clearCurrent())},[...e[10]||(e[10]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",fill:"#fff",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("path",{d:"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"}),(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"})],-1)])],8,_)]),a.metadata&&a.metadata.hasOwnProperty("name")?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.Lk)("div",b,[(0,s.bF)(c,{class:"package-popup__logo","component-class":"package-popup__icon",src:a.metadata.logo},null,8,["src"]),(0,s.Lk)("div",f,[(0,s.Lk)("h1",y,(0,n.v_)(a.metadata.title||o.data.name),1),o.authors?((0,s.uX)(),(0,s.CE)("p",$,[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.authors"))+" ",1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(o.authors,(a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,[a.homepage?((0,s.uX)(),(0,s.CE)("a",{class:"package-popup__author",key:e,href:a.homepage,target:"_blank",rel:"noreferrer noopener"},(0,n.v_)(a.name),9,C)):((0,s.uX)(),(0,s.CE)("span",{class:"package-popup__author",key:e},(0,n.v_)(a.name),1))],64))),256))])):(0,s.Q3)("",!0),(0,s.Lk)("p",X,[a.metadata.private?((0,s.uX)(),(0,s.CE)("span",{key:0,class:"package-popup__stats package-popup__stats--private",title:a.$t("ui.package.privateTitle")},(0,n.v_)(a.$t("ui.package.private")),9,E)):(0,s.Q3)("",!0),a.metadata.updated?((0,s.uX)(),(0,s.CE)("span",L,(0,n.v_)(o.datimFormat(a.metadata.updated,!1)),1)):(0,s.Q3)("",!0),a.metadata.downloads>0?((0,s.uX)(),(0,s.CE)("span",w,(0,n.v_)(o.numberFormat(a.metadata.downloads)),1)):(0,s.Q3)("",!0),a.metadata.favers>0?((0,s.uX)(),(0,s.CE)("span",F,(0,n.v_)(o.numberFormat(a.metadata.favers)),1)):(0,s.Q3)("",!0),(0,s.bF)(r,{name:a.metadata.name,homepage:a.metadata.homepage,support:Object.assign({},a.metadata.support),metadata:a.metadata.metadata,"hide-packagist":a.metadata.private},null,8,["name","homepage","support","metadata","hide-packagist"])])]),(0,s.Lk)("div",A,[(0,s.RG)(a.$slots,"package-actions",(0,n._B)((0,s.Ng)({data:a.metadata})),()=>[a.metadata&&a.metadata.homepage?((0,s.uX)(),(0,s.CE)("a",{key:0,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,W)):a.metadata.private?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${o.data.name}`},(0,n.v_)(a.$t("ui.package-details.packagist")),9,Q))])])]),(0,s.Lk)("div",T,[(0,s.Lk)("ul",x,[(0,s.bF)(u,{"show-empty":"",links:!1,active:""===o.tab,onClick:e[2]||(e[2]=a=>o.setTab(""))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDescription")),1)]),_:1},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(u,{key:0,highlight:"",links:a.metadata.features,active:"features"===o.tab,onClick:e[3]||(e[3]=a=>o.setTab("features"))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabFeatures")),1)]),_:1},8,["links","active"])):(0,s.Q3)("",!0),(0,s.bF)(u,{highlight:"",active:"suggest"===o.tab,links:a.metadata.suggest,onClick:e[4]||(e[4]=a=>o.setTab("suggest"))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabSuggest")),1)]),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"require"===o.tab,links:a.metadata.require,onClick:e[5]||(e[5]=a=>o.setTab("require"))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabRequire")),1)]),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"conflict"===o.tab,links:a.metadata.conflict,onClick:e[6]||(e[6]=a=>o.setTab("conflict"))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabConflict")),1)]),_:1},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(u,{key:1,active:"dependents"===o.tab,links:t.dependents,onClick:e[7]||(e[7]=a=>o.setTab("dependents"))},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDependents")),1)]),_:1},8,["active","links"])):(0,s.Q3)("",!0)])]),(0,s.bF)(G,{active:""===o.tab},{default:(0,s.k6)(()=>[a.metadata.abandoned?((0,s.uX)(),(0,s.CE)("div",R,[!0===a.metadata.abandoned?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[(0,s.eW)((0,n.v_)(a.$t("ui.package.abandonedText")),1)],64)):((0,s.uX)(),(0,s.Wv)(k,{key:1,keypath:"ui.package.abandonedReplace"},{replacement:(0,s.k6)(()=>[(0,s.bF)(d,{to:{query:{p:a.metadata.abandoned}}},{default:(0,s.k6)(()=>[(0,s.eW)((0,n.v_)(a.metadata.abandoned),1)]),_:1},8,["to"])]),_:1}))])):(0,s.Q3)("",!0),a.metadata.funding?((0,s.uX)(),(0,s.Wv)(g,{key:1,class:"package-popup__funding",items:a.metadata.funding},null,8,["items"])):(0,s.Q3)("",!0),(0,s.RG)(a.$slots,"package-update"),a.metadata.contaoVersions?((0,s.uX)(),(0,s.CE)("p",q,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.contaoVersions"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.contaoVersions.join(", ")),1)])):(0,s.Q3)("",!0),a.metadata.latest?((0,s.uX)(),(0,s.CE)("p",P,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.latest"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.latest.version)+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(o.datimFormat(a.metadata.latest.time,"short","long"))+")",1)])):(0,s.Q3)("",!0),a.metadata.license?((0,s.uX)(),(0,s.CE)("p",B,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.license"))+":",1),(0,s.eW)(" "+(0,n.v_)(o.license),1)])):(0,s.Q3)("",!0),(0,s.Lk)("p",I,(0,n.v_)(a.metadata.description),1)]),_:3},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(G,{key:0,active:"features"===o.tab,links:a.metadata.features},{actions:(0,s.k6)(({name:e})=>[(0,s.RG)(a.$slots,"features-actions",(0,n._B)((0,s.Ng)({name:e})))]),_:3},8,["active","links"])):(0,s.Q3)("",!0),(0,s.bF)(G,{active:"suggest"===o.tab,links:a.metadata.suggest},{actions:(0,s.k6)(({name:e})=>[(0,s.RG)(a.$slots,"suggest-actions",(0,n._B)((0,s.Ng)({name:e})))]),_:3},8,["active","links"]),(0,s.bF)(G,{active:"require"===o.tab,links:a.metadata.require},{actions:(0,s.k6)(({name:e})=>[(0,s.RG)(a.$slots,"require-actions",(0,n._B)((0,s.Ng)({name:e})))]),_:3},8,["active","links"]),(0,s.bF)(G,{active:"conflict"===o.tab,links:a.metadata.conflict},{actions:(0,s.k6)(({name:e})=>[(0,s.RG)(a.$slots,"conflict-actions",(0,n._B)((0,s.Ng)({name:e})))]),_:3},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(G,{key:1,active:"dependents"===o.tab,links:t.dependents},{actions:(0,s.k6)(({name:e})=>[(0,s.RG)(a.$slots,"dependents-actions",(0,n._B)((0,s.Ng)({name:e})))]),_:3},8,["active","links"])):(0,s.Q3)("",!0)],64)):((0,s.uX)(),(0,s.CE)("div",v,[(0,s.bF)(p,{horizontal:""}),(0,s.Lk)("p",null,(0,n.v_)(a.$t("ui.package-details.loading")),1)]))]),_:3})}var O=t(9376),S=t(416),j=t(266),K=t(7423),V=t(9045);const D={key:0,class:"link-more"};function H(a,e,t,i,l,o){const p=(0,s.g2)("link-menu");return o.linkItems.length?((0,s.uX)(),(0,s.CE)("div",D,[(0,s.Lk)("button",{onClick:e[0]||(e[0]=(...a)=>o.toggle&&o.toggle(...a))},(0,n.v_)(a.$t("ui.package-details.more")),1),a.visible?((0,s.uX)(),(0,s.CE)("div",{key:0,ref:"menu",class:"link-more__menu",tabindex:"-1",onFocusout:e[1]||(e[1]=(...a)=>o.close&&o.close(...a)),onClick:e[2]||(e[2]=(...a)=>o.close&&o.close(...a))},[(0,s.bF)(p,{items:o.linkItems,color:"contao"},null,8,["items"])],544)):(0,s.Q3)("",!0)])):(0,s.Q3)("",!0)}var M=t(4758),N={components:{LinkMenu:M.A},props:{name:String,homepage:String,support:Object,metadata:String,hidePackagist:Boolean},data:()=>({visible:!1}),computed:{linkItems(){const a=[];return this.homepage&&a.push({label:this.$t("ui.package.homepage"),href:this.homepage,target:"_blank"}),this.name&&!this.hidePackagist&&a.push({label:this.$t("ui.package-details.packagist"),href:`https://packagist.org/packages/${this.name}`,target:"_blank"}),this.support&&Object.keys(this.support).forEach(e=>{const t=`ui.package-details.support_${e}`;let s=this.$t(`ui.package-details.support_${e}`);s===t&&(s=e),"email"===e?a.push({label:s,href:`mailto:${this.support[e]}`}):a.push({label:s,href:this.support[e],target:"_blank"})}),this.metadata&&a.push({label:this.$t("ui.package-details.metadata"),href:this.metadata,target:"_blank"}),a}},methods:{open(){this.visible=!0,setTimeout(()=>this.$refs.menu?.focus(),0)},close(a){a&&this.$refs.menu?.contains(a.relatedTarget)||(this.$refs.menu.blur(),setTimeout(()=>{this.visible=!1},100))},toggle(){this.visible?this.close():this.open()}}},z=t(6262);const U=(0,z.A)(N,[["render",H]]);var Y=U;const J=["disabled"];function Z(a,e,t,i,l,o){return t.showEmpty||o.count>0?((0,s.uX)(),(0,s.CE)("li",{key:0,class:(0,n.C4)(["package-popup__tab",{"package-popup__tab--active":t.active}])},[(0,s.Lk)("button",{onClick:e[0]||(e[0]=e=>a.$emit("click")),disabled:0===o.count&&!1!==t.links},[(0,s.RG)(a.$slots,"default"),!1!==t.links?((0,s.uX)(),(0,s.CE)("span",{key:0,class:(0,n.C4)({"package-popup__pill":!0,"package-popup__pill--highlight":t.highlight&&o.count>0})},(0,n.v_)(o.count),3)):(0,s.Q3)("",!0)],8,J)],2)):(0,s.Q3)("",!0)}var aa={emits:["click"],props:{active:Boolean,showEmpty:Boolean,highlight:Boolean,links:[Object,Array,Boolean]},computed:{count(){return this.links?this.links instanceof Array?this.links.length:Object.values(this.links).length:0}}};const ea=(0,z.A)(aa,[["render",Z]]);var ta=ea,sa=t(3751);const na={class:"package-popup__tabcontent",tabindex:"-1"},ia={key:0,class:"package-popup__packagelist"};function la(a,e,t,n,i,l){const o=(0,s.g2)("package-link");return(0,s.bo)(((0,s.uX)(),(0,s.CE)("div",na,[(0,s.RG)(a.$slots,"default",{},()=>[t.links?((0,s.uX)(),(0,s.CE)("div",ia,[((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(l.iterableLinks,(e,t)=>(0,s.RG)(a.$slots,"links",(0,s.v6)({ref_for:!0},{name:t,text:e}),()=>[((0,s.uX)(),(0,s.Wv)(o,{name:t,key:t,text:e},{default:(0,s.k6)(()=>[(0,s.RG)(a.$slots,"actions",(0,s.v6)({ref_for:!0},{name:t}))]),_:2},1032,["name","text"]))])),256))])):(0,s.Q3)("",!0)])],512)),[[sa.aG,t.active]])}const oa={class:"package-link__details"},pa=["title"],ca={class:"package-link__text"},ra={class:"package-link__actions"};function ua(a,e,t,i,l,o){const p=(0,s.g2)("details-button");return(0,s.uX)(),(0,s.CE)("article",{class:(0,n.C4)(["package-link",{"package-link--limit":!t.text}])},[(0,s.Lk)("div",oa,[(0,s.Lk)("p",{class:"package-link__name",title:t.name},(0,n.v_)(a.metadata&&a.metadata.title||t.name),9,pa),(0,s.Lk)("p",ca,(0,n.v_)(t.text||a.metadata&&a.metadata.description),1)]),(0,s.Lk)("div",ra,[(0,s.RG)(a.$slots,"default"),(0,s.bF)(p,{small:"",name:t.name},null,8,["name"])])],2)}var da=t(9071),ka={mixins:[S.A],components:{DetailsButton:da.A},props:{name:String,text:String},computed:{data:a=>({name:a.name})}};const ga=(0,z.A)(ka,[["render",ua]]);var ma=ga,ha={components:{PackageLink:ma},props:{active:Boolean,links:[Object,Array]},computed:{iterableLinks(){if(this.links instanceof Array){const a={};return this.links.forEach(e=>{a[e]=null}),a}return this.links}},watch:{active(){setTimeout(()=>{this.$el.focus()},0)}}};const _a=(0,z.A)(ha,[["render",la]]);var va=_a,ba=t(1687);const fa={key:0,class:"package-funding"},ya=["href"],$a=["href"],Ca=["href"],Xa=["href"],Ea=["href"];function La(a,e,t,i,l,o){return t.items&&t.items.length?((0,s.uX)(),(0,s.CE)("div",fa,[(0,s.Lk)("div",null,[(0,s.Lk)("span",null,(0,n.v_)(a.$t("ui.package-details.funding")),1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(t.items,(a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,["github"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:o.githubUrl(a),target:"_blank",rel:"noreferrer noopener",key:e},"GitHub",8,ya)):"tidelift"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Tidelift",8,$a)):"patreon"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Patreon",8,Ca)):"opencollective"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"OpenCollective",8,Xa)):((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},(0,n.v_)(a.url.replace(/^https?:\/\/(www.)?([^/]+).*$/,"$2")),9,Ea))],64))),256))])])):(0,s.Q3)("",!0)}var wa={name:"PackageFunding",props:{items:{type:Array,required:!0}},computed:{githubUrl:()=>a=>a.url.replace(/^https:\/\/github.com\/([^/]+)$/,"https://github.com/sponsors/$1")}};const Fa=(0,z.A)(wa,[["render",La],["__scopeId","data-v-5a8fd14b"]]);var Aa=Fa,Wa={mixins:[S.A],components:{PopupOverlay:ba.A,MoreLinks:Y,LoadingSpinner:V.A,PackageLogo:K.A,PackageFunding:Aa,DetailsTab:ta,DetailsContent:va},props:{local:{type:Object},dependents:{type:Object}},data:()=>({appTitle:"",links:[],hasPrevious:!1}),computed:{current:a=>a.$route.query.p,tab:a=>String(a.$route.hash).substring(1),exists:a=>a.metadata,data:a=>a.local||{name:a.current},authors:a=>a.metadata.authors&&a.metadata.authors.length?a.metadata.authors.filter(a=>!!a.name):null,license:a=>a.metadata.license?a.metadata.license instanceof Array?a.metadata.license.join(", "):a.metadata.license:"–",contaoVersions:a=>a.metadata.contaoVersions||null},methods:{datimFormat:k.A,numberFormat:j.A,...(0,d.PY)("packages/details",["clearCurrent"]),setTab(a){this.$router.replace({query:this.$route.query,hash:`#${a}`,append:!0})},updatePage(){let a=`${this.current} - ${this.appTitle}`,e="";this.metadata&&(this.metadata.title&&(a=`${this.metadata.title} (${this.current}) - ${this.appTitle}`),e=this.metadata.description||""),document.title=a,document.head.querySelector('meta[name="description"]').setAttribute("content",e)},addLink(a,e,t=null){const s=new URL(location.pathname,location);s.search=a;const n=document.createElement("link");n.setAttribute("rel",e),n.setAttribute("href",s.toString()),t&&n.setAttribute("hrefLang",t),document.head.appendChild(n),this.links.push(n)}},watch:{current(){this.updatePage(),this.hasPrevious=/[?&]p=/.test(window.history.state?.back)},exists(a){a||this.clearCurrent()},metadata(){this.updatePage()}},created(){this.appTitle=document.title},mounted(){document.head.querySelector('meta[name="robots"]').setAttribute("content","index,follow"),this.updatePage(),this.addLink(`?p=${this.current}&_locale=${this.$i18n.locale}`,"canonical"),Object.keys(O.A).forEach(a=>{this.addLink(`?p=${this.current}&_locale=${a}`,"alternate",a)})},beforeUnmount(){document.title=this.appTitle,document.head.querySelector('meta[name="description"]').setAttribute("content",""),this.links.forEach(a=>{document.head.removeChild(a)})}};const Qa=(0,z.A)(Wa,[["render",G]]);var Ta=Qa,xa=t(8875),Ra=t(3100),qa={mixins:[g.A],components:{PackageConstraint:Ra.A,PackageDetails:Ta,InstallButton:xa.A},computed:{...(0,d.aH)("packages",{allInstalled:"installed"}),...(0,d.L8)("packages",["packageConstraint"]),current:a=>a.$route.query.p,data:a=>a.add[a.current]||a.allInstalled&&a.allInstalled[a.current]||{name:a.current},dependents(){if(!this.allInstalled||!this.allInstalled[this.data.name]?.dependents)return null;const a={},e=["requires","replaces","provides","conflicts"];return Object.values(this.allInstalled[this.data.name].dependents).forEach(t=>{if("__root__"===t.source||!e.includes(t.description)||t.source===this.data.name&&"replaces"===t.description)return;const s=this.$t(`ui.package-details.link${t.description[0].toUpperCase()}${t.description.slice(1)}`);let n=t.target;n===this.data.name&&this.metadata&&this.metadata.title&&(n=this.metadata.title),a[t.source]=`${s} ${n} ${t.constraint}`}),a}},methods:{datimFormat:k.A}};const Pa=(0,z.A)(qa,[["render",u]]);var Ba=Pa}}]);(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[710],{1710:function(e,t,r){
/*!

JSZip v3.10.1 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/main/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/main/LICENSE
*/
!function(t){e.exports=t()}(function(){return function e(t,r,n){function i(a,o){if(!r[a]){if(!t[a]){var h=void 0;if(!o&&h)return require(a,!0);if(s)return s(a,!0);var u=new Error("Cannot find module '"+a+"'");throw u.code="MODULE_NOT_FOUND",u}var l=r[a]={exports:{}};t[a][0].call(l.exports,function(e){var r=t[a][1][e];return i(r||e)},l,l.exports,e,t,r,n)}return r[a].exports}for(var s=void 0,a=0;a<n.length;a++)i(n[a]);return i}({1:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./support"),s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";r.encode=function(e){for(var t,r,i,a,o,h,u,l=[],f=0,c=e.length,d=c,p="string"!==n.getTypeOf(e);f<e.length;)d=c-f,i=p?(t=e[f++],r=f<c?e[f++]:0,f<c?e[f++]:0):(t=e.charCodeAt(f++),r=f<c?e.charCodeAt(f++):0,f<c?e.charCodeAt(f++):0),a=t>>2,o=(3&t)<<4|r>>4,h=1<d?(15&r)<<2|i>>6:64,u=2<d?63&i:64,l.push(s.charAt(a)+s.charAt(o)+s.charAt(h)+s.charAt(u));return l.join("")},r.decode=function(e){var t,r,n,a,o,h,u=0,l=0,f="data:";if(e.substr(0,f.length)===f)throw new Error("Invalid base64 input, it looks like a data url.");var c,d=3*(e=e.replace(/[^A-Za-z0-9+/=]/g,"")).length/4;if(e.charAt(e.length-1)===s.charAt(64)&&d--,e.charAt(e.length-2)===s.charAt(64)&&d--,d%1!=0)throw new Error("Invalid base64 input, bad content length.");for(c=i.uint8array?new Uint8Array(0|d):new Array(0|d);u<e.length;)t=s.indexOf(e.charAt(u++))<<2|(a=s.indexOf(e.charAt(u++)))>>4,r=(15&a)<<4|(o=s.indexOf(e.charAt(u++)))>>2,n=(3&o)<<6|(h=s.indexOf(e.charAt(u++))),c[l++]=t,64!==o&&(c[l++]=r),64!==h&&(c[l++]=n);return c}},{"./support":30,"./utils":32}],2:[function(e,t,r){"use strict";var n=e("./external"),i=e("./stream/DataWorker"),s=e("./stream/Crc32Probe"),a=e("./stream/DataLengthProbe");function o(e,t,r,n,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=r,this.compression=n,this.compressedContent=i}o.prototype={getContentWorker:function(){var e=new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")),t=this;return e.on("end",function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")}),e},getCompressedWorker:function(){return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},o.createWorkerFrom=function(e,t,r){return e.pipe(new s).pipe(new a("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new a("compressedSize")).withStreamInfo("compression",t)},t.exports=o},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(e,t,r){"use strict";var n=e("./stream/GenericWorker");r.STORE={magic:"\0\0",compressWorker:function(){return new n("STORE compression")},uncompressWorker:function(){return new n("STORE decompression")}},r.DEFLATE=e("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(e,t,r){"use strict";var n=e("./utils"),i=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t){return void 0!==e&&e.length?"string"!==n.getTypeOf(e)?function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}(0|t,e,e.length,0):function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t.charCodeAt(o))];return-1^e}(0|t,e,e.length,0):0}},{"./utils":32}],5:[function(e,t,r){"use strict";r.base64=!1,r.binary=!1,r.dir=!1,r.createFolders=!0,r.date=null,r.compression=null,r.compressionOptions=null,r.comment=null,r.unixPermissions=null,r.dosPermissions=null},{}],6:[function(e,t,r){"use strict";var n=null;n="undefined"!=typeof Promise?Promise:e("lie"),t.exports={Promise:n}},{lie:37}],7:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,i=e("pako"),s=e("./utils"),a=e("./stream/GenericWorker"),o=n?"uint8array":"array";function h(e,t){a.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={}}r.magic="\b\0",s.inherits(h,a),h.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(s.transformTo(o,e.data),!1)},h.prototype.flush=function(){a.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},h.prototype.cleanUp=function(){a.prototype.cleanUp.call(this),this._pako=null},h.prototype._createPako=function(){this._pako=new i[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta})}},r.compressWorker=function(e){return new h("Deflate",e)},r.uncompressWorker=function(){return new h("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(e,t,r){"use strict";function n(e,t){var r,n="";for(r=0;r<t;r++)n+=String.fromCharCode(255&e),e>>>=8;return n}function i(e,t,r,i,a,l){var f,c,d=e.file,p=e.compression,m=l!==o.utf8encode,_=s.transformTo("string",l(d.name)),g=s.transformTo("string",o.utf8encode(d.name)),b=d.comment,v=s.transformTo("string",l(b)),y=s.transformTo("string",o.utf8encode(b)),w=g.length!==d.name.length,k=y.length!==b.length,x="",S="",z="",C=d.dir,E=d.date,A={crc32:0,compressedSize:0,uncompressedSize:0};t&&!r||(A.crc32=e.crc32,A.compressedSize=e.compressedSize,A.uncompressedSize=e.uncompressedSize);var I=0;t&&(I|=8),m||!w&&!k||(I|=2048);var O=0,B=0;C&&(O|=16),"UNIX"===a?(B=798,O|=function(e,t){var r=e;return e||(r=t?16893:33204),(65535&r)<<16}(d.unixPermissions,C)):(B=20,O|=function(e){return 63&(e||0)}(d.dosPermissions)),f=E.getUTCHours(),f<<=6,f|=E.getUTCMinutes(),f<<=5,f|=E.getUTCSeconds()/2,c=E.getUTCFullYear()-1980,c<<=4,c|=E.getUTCMonth()+1,c<<=5,c|=E.getUTCDate(),w&&(S=n(1,1)+n(h(_),4)+g,x+="up"+n(S.length,2)+S),k&&(z=n(1,1)+n(h(v),4)+y,x+="uc"+n(z.length,2)+z);var R="";return R+="\n\0",R+=n(I,2),R+=p.magic,R+=n(f,2),R+=n(c,2),R+=n(A.crc32,4),R+=n(A.compressedSize,4),R+=n(A.uncompressedSize,4),R+=n(_.length,2),R+=n(x.length,2),{fileRecord:u.LOCAL_FILE_HEADER+R+_+x,dirRecord:u.CENTRAL_FILE_HEADER+n(B,2)+R+n(v.length,2)+"\0\0\0\0"+n(O,4)+n(i,4)+_+x+v}}var s=e("../utils"),a=e("../stream/GenericWorker"),o=e("../utf8"),h=e("../crc32"),u=e("../signature");function l(e,t,r,n){a.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}s.inherits(l,a),l.prototype.push=function(e){var t=e.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,a.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:r?(t+100*(r-n-1))/r:100}}))},l.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var r=i(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}})}else this.accumulate=!0},l.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,r=i(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),t)this.push({data:function(e){return u.DATA_DESCRIPTOR+n(e.crc32,4)+n(e.compressedSize,4)+n(e.uncompressedSize,4)}(e),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},l.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var r=this.bytesWritten-e,i=function(e,t,r,i,a){var o=s.transformTo("string",a(i));return u.CENTRAL_DIRECTORY_END+"\0\0\0\0"+n(e,2)+n(e,2)+n(t,4)+n(r,4)+n(o.length,2)+o}(this.dirRecords.length,r,e,this.zipComment,this.encodeFileName);this.push({data:i,meta:{percent:100}})},l.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},l.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",function(e){t.processChunk(e)}),e.on("end",function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end()}),e.on("error",function(e){t.error(e)}),this},l.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},l.prototype.error=function(e){var t=this._sources;if(!a.prototype.error.call(this,e))return!1;for(var r=0;r<t.length;r++)try{t[r].error(e)}catch(e){}return!0},l.prototype.lock=function(){a.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock()},t.exports=l},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(e,t,r){"use strict";var n=e("../compressions"),i=e("./ZipFileWorker");r.generateWorker=function(e,t,r){var s=new i(t.streamFiles,r,t.platform,t.encodeFileName),a=0;try{e.forEach(function(e,r){a++;var i=function(e,t){var r=e||t,i=n[r];if(!i)throw new Error(r+" is not a valid compression method !");return i}(r.options.compression,t.compression),o=r.options.compressionOptions||t.compressionOptions||{},h=r.dir,u=r.date;r._compressWorker(i,o).withStreamInfo("file",{name:e,dir:h,date:u,comment:r.comment||"",unixPermissions:r.unixPermissions,dosPermissions:r.dosPermissions}).pipe(s)}),s.entriesCount=a}catch(e){s.error(e)}return s}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(e,t,r){"use strict";function n(){if(!(this instanceof n))return new n;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files=Object.create(null),this.comment=null,this.root="",this.clone=function(){var e=new n;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e}}(n.prototype=e("./object")).loadAsync=e("./load"),n.support=e("./support"),n.defaults=e("./defaults"),n.version="3.10.1",n.loadAsync=function(e,t){return(new n).loadAsync(e,t)},n.external=e("./external"),t.exports=n},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./external"),s=e("./utf8"),a=e("./zipEntries"),o=e("./stream/Crc32Probe"),h=e("./nodejsUtils");function u(e){return new i.Promise(function(t,r){var n=e.decompressed.getContentWorker().pipe(new o);n.on("error",function(e){r(e)}).on("end",function(){n.streamInfo.crc32!==e.decompressed.crc32?r(new Error("Corrupted zip : CRC32 mismatch")):t()}).resume()})}t.exports=function(e,t){var r=this;return t=n.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:s.utf8decode}),h.isNode&&h.isStream(e)?i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):n.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then(function(e){var r=new a(t);return r.load(e),r}).then(function(e){var r=[i.Promise.resolve(e)],n=e.files;if(t.checkCRC32)for(var s=0;s<n.length;s++)r.push(u(n[s]));return i.Promise.all(r)}).then(function(e){for(var i=e.shift(),s=i.files,a=0;a<s.length;a++){var o=s[a],h=o.fileNameStr,u=n.resolve(o.fileNameStr);r.file(u,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:t.createFolders}),o.dir||(r.file(u).unsafeOriginalName=h)}return i.zipComment.length&&(r.comment=i.zipComment),r})}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../stream/GenericWorker");function s(e,t){i.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t)}n.inherits(s,i),s.prototype._bindStream=function(e){var t=this;(this._stream=e).pause(),e.on("data",function(e){t.push({data:e,meta:{percent:0}})}).on("error",function(e){t.isPaused?this.generatedError=e:t.error(e)}).on("end",function(){t.isPaused?t._upstreamEnded=!0:t.end()})},s.prototype.pause=function(){return!!i.prototype.pause.call(this)&&(this._stream.pause(),!0)},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},t.exports=s},{"../stream/GenericWorker":28,"../utils":32}],13:[function(e,t,r){"use strict";var n=e("readable-stream").Readable;function i(e,t,r){n.call(this,t),this._helper=e;var i=this;e.on("data",function(e,t){i.push(e)||i._helper.pause(),r&&r(t)}).on("error",function(e){i.emit("error",e)}).on("end",function(){i.push(null)})}e("../utils").inherits(i,n),i.prototype._read=function(){this._helper.resume()},t.exports=i},{"../utils":32,"readable-stream":16}],14:[function(e,t,r){"use strict";t.exports={isNode:"undefined"!=typeof Buffer,newBufferFrom:function(e,t){if(Buffer.from&&Buffer.from!==Uint8Array.from)return Buffer.from(e,t);if("number"==typeof e)throw new Error('The "data" argument must not be a number');return new Buffer(e,t)},allocBuffer:function(e){if(Buffer.alloc)return Buffer.alloc(e);var t=new Buffer(e);return t.fill(0),t},isBuffer:function(e){return Buffer.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}}},{}],15:[function(e,t,r){"use strict";function n(e,t,r){var n,i=s.getTypeOf(t),o=s.extend(r||{},h);o.date=o.date||new Date,null!==o.compression&&(o.compression=o.compression.toUpperCase()),"string"==typeof o.unixPermissions&&(o.unixPermissions=parseInt(o.unixPermissions,8)),o.unixPermissions&&16384&o.unixPermissions&&(o.dir=!0),o.dosPermissions&&16&o.dosPermissions&&(o.dir=!0),o.dir&&(e=m(e)),o.createFolders&&(n=p(e))&&_.call(this,n,!0);var f="string"===i&&!1===o.binary&&!1===o.base64;r&&void 0!==r.binary||(o.binary=!f),(t instanceof u&&0===t.uncompressedSize||o.dir||!t||0===t.length)&&(o.base64=!1,o.binary=!0,t="",o.compression="STORE",i="string");var g=null;g=t instanceof u||t instanceof a?t:c.isNode&&c.isStream(t)?new d(e,t):s.prepareContent(e,t,o.binary,o.optimizedBinaryString,o.base64);var b=new l(e,g,o);this.files[e]=b}var i=e("./utf8"),s=e("./utils"),a=e("./stream/GenericWorker"),o=e("./stream/StreamHelper"),h=e("./defaults"),u=e("./compressedObject"),l=e("./zipObject"),f=e("./generate"),c=e("./nodejsUtils"),d=e("./nodejs/NodejsStreamInputAdapter"),p=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return 0<t?e.substring(0,t):""},m=function(e){return"/"!==e.slice(-1)&&(e+="/"),e},_=function(e,t){return t=void 0!==t?t:h.createFolders,e=m(e),this.files[e]||n.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function g(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var b={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,r,n;for(t in this.files)n=this.files[t],(r=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(r,n)},filter:function(e){var t=[];return this.forEach(function(r,n){e(r,n)&&t.push(n)}),t},file:function(e,t,r){if(1!==arguments.length)return e=this.root+e,n.call(this,e,t,r),this;if(g(e)){var i=e;return this.filter(function(e,t){return!t.dir&&i.test(e)})}var s=this.files[this.root+e];return s&&!s.dir?s:null},folder:function(e){if(!e)return this;if(g(e))return this.filter(function(t,r){return r.dir&&e.test(t)});var t=this.root+e,r=_.call(this,t),n=this.clone();return n.root=r.name,n},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var r=this.filter(function(t,r){return r.name.slice(0,e.length)===e}),n=0;n<r.length;n++)delete this.files[r[n].name];return this},generate:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,r={};try{if((r=s.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");s.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";t=f.generateWorker(this,r,n)}catch(e){(t=new a("error")).error(e)}return new o(t,r.type||"string",r.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return(e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};t.exports=b},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(e,t,r){"use strict";t.exports=e("stream")},{stream:void 0}],17:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t]}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data[this.zero+e]},i.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.length-4;0<=s;--s)if(this.data[s]===t&&this.data[s+1]===r&&this.data[s+2]===n&&this.data[s+3]===i)return s-this.zero;return-1},i.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.readData(4);return t===s[0]&&r===s[1]&&n===s[2]&&i===s[3]},i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return[];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],18:[function(e,t,r){"use strict";var n=e("../utils");function i(e){this.data=e,this.length=e.length,this.index=0,this.zero=0}i.prototype={checkOffset:function(e){this.checkIndex(this.index+e)},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e},skip:function(e){this.setIndex(this.index+e)},byteAt:function(){},readInt:function(e){var t,r=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)r=(r<<8)+this.byteAt(t);return this.index+=e,r},readString:function(e){return n.transformTo("string",this.readData(e))},readData:function(){},lastIndexOfSignature:function(){},readAndCheckSignature:function(){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},t.exports=i},{"../utils":32}],19:[function(e,t,r){"use strict";var n=e("./Uint8ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},i.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},i.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],21:[function(e,t,r){"use strict";var n=e("./ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./ArrayReader":17}],22:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../support"),s=e("./ArrayReader"),a=e("./StringReader"),o=e("./NodeBufferReader"),h=e("./Uint8ArrayReader");t.exports=function(e){var t=n.getTypeOf(e);return n.checkSupport(t),"string"!==t||i.uint8array?"nodebuffer"===t?new o(e):i.uint8array?new h(n.transformTo("uint8array",e)):new s(n.transformTo("array",e)):new a(e)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(e,t,r){"use strict";r.LOCAL_FILE_HEADER="PK",r.CENTRAL_FILE_HEADER="PK",r.CENTRAL_DIRECTORY_END="PK",r.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",r.ZIP64_CENTRAL_DIRECTORY_END="PK",r.DATA_DESCRIPTOR="PK\b"},{}],24:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../utils");function s(e){n.call(this,"ConvertWorker to "+e),this.destType=e}i.inherits(s,n),s.prototype.processChunk=function(e){this.push({data:i.transformTo(this.destType,e.data),meta:e.meta})},t.exports=s},{"../utils":32,"./GenericWorker":28}],25:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../crc32");function s(){n.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}e("../utils").inherits(s,n),s.prototype.processChunk=function(e){this.streamInfo.crc32=i(e.data,this.streamInfo.crc32||0),this.push(e)},t.exports=s},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0)}n.inherits(s,i),s.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length}i.prototype.processChunk.call(this,e)},t.exports=s},{"../utils":32,"./GenericWorker":28}],27:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then(function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=n.getTypeOf(e),t.isPaused||t._tickAndRepeat()},function(e){t.error(e)})}n.inherits(s,i),s.prototype.cleanUp=function(){i.prototype.cleanUp.call(this),this.data=null},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,n.delay(this._tickAndRepeat,[],this)),!0)},s.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(n.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},s.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t)}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},t.exports=s},{"../utils":32,"./GenericWorker":28}],28:[function(e,t,r){"use strict";function n(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}n.prototype={push:function(e){this.emit("data",e)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(e){this.emit("error",e)}return!0},error:function(e){return!this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(e,t){if(this._listeners[e])for(var r=0;r<this._listeners[e].length;r++)this._listeners[e][r].call(this,t)},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",function(e){t.processChunk(e)}),e.on("end",function(){t.end()}),e.on("error",function(e){t.error(e)}),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;var e=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e)},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)Object.prototype.hasOwnProperty.call(this.extraStreamInfo,e)&&(this.streamInfo[e]=this.extraStreamInfo[e])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},t.exports=n},{}],29:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./ConvertWorker"),s=e("./GenericWorker"),a=e("../base64"),o=e("../support"),h=e("../external"),u=null;if(o.nodestream)try{u=e("../nodejs/NodejsStreamOutputAdapter")}catch(e){}function l(e,t){return new h.Promise(function(r,i){var s=[],o=e._internalType,h=e._outputType,u=e._mimeType;e.on("data",function(e,r){s.push(e),t&&t(r)}).on("error",function(e){s=[],i(e)}).on("end",function(){try{var e=function(e,t,r){switch(e){case"blob":return n.newBlob(n.transformTo("arraybuffer",t),r);case"base64":return a.encode(t);default:return n.transformTo(e,t)}}(h,function(e,t){var r,n=0,i=null,s=0;for(r=0;r<t.length;r++)s+=t[r].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(i=new Uint8Array(s),r=0;r<t.length;r++)i.set(t[r],n),n+=t[r].length;return i;case"nodebuffer":return Buffer.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(o,s),u);r(e)}catch(e){i(e)}s=[]}).resume()})}function f(e,t,r){var a=t;switch(t){case"blob":case"arraybuffer":a="uint8array";break;case"base64":a="string"}try{this._internalType=a,this._outputType=t,this._mimeType=r,n.checkSupport(a),this._worker=e.pipe(new i(a)),e.lock()}catch(e){this._worker=new s("error"),this._worker.error(e)}}f.prototype={accumulate:function(e){return l(this,e)},on:function(e,t){var r=this;return"data"===e?this._worker.on(e,function(e){t.call(r,e.data,e.meta)}):this._worker.on(e,function(){n.delay(t,arguments,r)}),this},resume:function(){return n.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(n.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new u(this,{objectMode:"nodebuffer"!==this._outputType},e)}},t.exports=f},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(e,t,r){"use strict";if(r.base64=!0,r.array=!0,r.string=!0,r.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,r.nodebuffer="undefined"!=typeof Buffer,r.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)r.blob=!1;else{var n=new ArrayBuffer(0);try{r.blob=0===new Blob([n],{type:"application/zip"}).size}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);i.append(n),r.blob=0===i.getBlob("application/zip").size}catch(e){r.blob=!1}}}try{r.nodestream=!!e("readable-stream").Readable}catch(e){r.nodestream=!1}},{"readable-stream":16}],31:[function(e,t,r){"use strict";for(var n=e("./utils"),i=e("./support"),s=e("./nodejsUtils"),a=e("./stream/GenericWorker"),o=new Array(256),h=0;h<256;h++)o[h]=252<=h?6:248<=h?5:240<=h?4:224<=h?3:192<=h?2:1;function u(){a.call(this,"utf-8 decode"),this.leftOver=null}function l(){a.call(this,"utf-8 encode")}o[254]=o[254]=1,r.utf8encode=function(e){return i.nodebuffer?s.newBufferFrom(e,"utf-8"):function(e){var t,r,n,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=i.uint8array?new Uint8Array(h):new Array(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t}(e)},r.utf8decode=function(e){return i.nodebuffer?n.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,r,i,s,a=e.length,h=new Array(2*a);for(t=r=0;t<a;)if((i=e[t++])<128)h[r++]=i;else if(4<(s=o[i]))h[r++]=65533,t+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&t<a;)i=i<<6|63&e[t++],s--;1<s?h[r++]=65533:i<65536?h[r++]=i:(i-=65536,h[r++]=55296|i>>10&1023,h[r++]=56320|1023&i)}return h.length!==r&&(h.subarray?h=h.subarray(0,r):h.length=r),n.applyFromCharCode(h)}(e=n.transformTo(i.uint8array?"uint8array":"array",e))},n.inherits(u,a),u.prototype.processChunk=function(e){var t=n.transformTo(i.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(i.uint8array){var s=t;(t=new Uint8Array(s.length+this.leftOver.length)).set(this.leftOver,0),t.set(s,this.leftOver.length)}else t=this.leftOver.concat(t);this.leftOver=null}var a=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+o[e[r]]>t?r:t}(t),h=t;a!==t.length&&(i.uint8array?(h=t.subarray(0,a),this.leftOver=t.subarray(a,t.length)):(h=t.slice(0,a),this.leftOver=t.slice(a,t.length))),this.push({data:r.utf8decode(h),meta:e.meta})},u.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:r.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},r.Utf8DecodeWorker=u,n.inherits(l,a),l.prototype.processChunk=function(e){this.push({data:r.utf8encode(e.data),meta:e.meta})},r.Utf8EncodeWorker=l},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(e,t,r){"use strict";var n=e("./support"),i=e("./base64"),s=e("./nodejsUtils"),a=e("./external");function o(e){return e}function h(e,t){for(var r=0;r<e.length;++r)t[r]=255&e.charCodeAt(r);return t}e("setimmediate"),r.newBlob=function(t,n){r.checkSupport("blob");try{return new Blob([t],{type:n})}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return i.append(t),i.getBlob(n)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var u={stringifyByChunk:function(e,t,r){var n=[],i=0,s=e.length;if(s<=r)return String.fromCharCode.apply(null,e);for(;i<s;)"array"===t||"nodebuffer"===t?n.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+r,s)))):n.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+r,s)))),i+=r;return n.join("")},stringifyByChar:function(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return t},applyCanBeUsed:{uint8array:function(){try{return n.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return!1}}(),nodebuffer:function(){try{return n.nodebuffer&&1===String.fromCharCode.apply(null,s.allocBuffer(1)).length}catch(e){return!1}}()}};function l(e){var t=65536,n=r.getTypeOf(e),i=!0;if("uint8array"===n?i=u.applyCanBeUsed.uint8array:"nodebuffer"===n&&(i=u.applyCanBeUsed.nodebuffer),i)for(;1<t;)try{return u.stringifyByChunk(e,n,t)}catch(e){t=Math.floor(t/2)}return u.stringifyByChar(e)}function f(e,t){for(var r=0;r<e.length;r++)t[r]=e[r];return t}r.applyFromCharCode=l;var c={};c.string={string:o,array:function(e){return h(e,new Array(e.length))},arraybuffer:function(e){return c.string.uint8array(e).buffer},uint8array:function(e){return h(e,new Uint8Array(e.length))},nodebuffer:function(e){return h(e,s.allocBuffer(e.length))}},c.array={string:l,array:o,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(e)}},c.arraybuffer={string:function(e){return l(new Uint8Array(e))},array:function(e){return f(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:o,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(new Uint8Array(e))}},c.uint8array={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:o,nodebuffer:function(e){return s.newBufferFrom(e)}},c.nodebuffer={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return c.nodebuffer.uint8array(e).buffer},uint8array:function(e){return f(e,new Uint8Array(e.length))},nodebuffer:o},r.transformTo=function(e,t){if(t=t||"",!e)return t;r.checkSupport(e);var n=r.getTypeOf(t);return c[n][e](t)},r.resolve=function(e){for(var t=e.split("/"),r=[],n=0;n<t.length;n++){var i=t[n];"."===i||""===i&&0!==n&&n!==t.length-1||(".."===i?r.pop():r.push(i))}return r.join("/")},r.getTypeOf=function(e){return"string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":n.nodebuffer&&s.isBuffer(e)?"nodebuffer":n.uint8array&&e instanceof Uint8Array?"uint8array":n.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},r.checkSupport=function(e){if(!n[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},r.MAX_VALUE_16BITS=65535,r.MAX_VALUE_32BITS=-1,r.pretty=function(e){var t,r,n="";for(r=0;r<(e||"").length;r++)n+="\\x"+((t=e.charCodeAt(r))<16?"0":"")+t.toString(16).toUpperCase();return n},r.delay=function(e,t,r){setImmediate(function(){e.apply(r||null,t||[])})},r.inherits=function(e,t){function r(){}r.prototype=t.prototype,e.prototype=new r},r.extend=function(){var e,t,r={};for(e=0;e<arguments.length;e++)for(t in arguments[e])Object.prototype.hasOwnProperty.call(arguments[e],t)&&void 0===r[t]&&(r[t]=arguments[e][t]);return r},r.prepareContent=function(e,t,s,o,u){return a.Promise.resolve(t).then(function(e){return n.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new a.Promise(function(t,r){var n=new FileReader;n.onload=function(e){t(e.target.result)},n.onerror=function(e){r(e.target.error)},n.readAsArrayBuffer(e)}):e}).then(function(t){var l=r.getTypeOf(t);return l?("arraybuffer"===l?t=r.transformTo("uint8array",t):"string"===l&&(u?t=i.decode(t):s&&!0!==o&&(t=function(e){return h(e,n.uint8array?new Uint8Array(e.length):new Array(e.length))}(t))),t):a.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))})}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,setimmediate:54}],33:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./signature"),a=e("./zipEntry"),o=e("./support");function h(e){this.files=[],this.loadOptions=e}h.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+i.pretty(t)+", expected "+i.pretty(e)+")")}},isSignature:function(e,t){var r=this.reader.index;this.reader.setIndex(e);var n=this.reader.readString(4)===t;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=o.uint8array?"uint8array":"array",r=i.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(r)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,r,n=this.zip64EndOfCentralSize-44;0<n;)e=this.reader.readInt(2),t=this.reader.readInt(4),r=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:r}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(s.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes()},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);)(e=new a({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);if(e<0)throw this.isSignature(0,s.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(e);var t=e;if(this.checkSignature(s.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===i.MAX_VALUE_16BITS||this.diskWithCentralDirStart===i.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===i.MAX_VALUE_16BITS||this.centralDirRecords===i.MAX_VALUE_16BITS||this.centralDirSize===i.MAX_VALUE_32BITS||this.centralDirOffset===i.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,s.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=t-r;if(0<n)this.isSignature(t,s.CENTRAL_FILE_HEADER)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(e){this.reader=n(e)},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},t.exports=h},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utils":32,"./zipEntry":34}],34:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./compressedObject"),a=e("./crc32"),o=e("./utf8"),h=e("./compressions"),u=e("./support");function l(e,t){this.options=e,this.loadOptions=t}l.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,r;if(e.skip(22),this.fileNameLength=e.readInt(2),r=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in h)if(Object.prototype.hasOwnProperty.call(h,t)&&h[t].magic===e)return h[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+i.pretty(this.compressionMethod)+" unknown (inner file : "+i.transformTo("string",this.fileName)+")");this.decompressed=new s(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize))},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==e&&(this.dosPermissions=63&this.externalFileAttributes),3==e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var e=n(this.extraFields[1].value);this.uncompressedSize===i.MAX_VALUE_32BITS&&(this.uncompressedSize=e.readInt(8)),this.compressedSize===i.MAX_VALUE_32BITS&&(this.compressedSize=e.readInt(8)),this.localHeaderOffset===i.MAX_VALUE_32BITS&&(this.localHeaderOffset=e.readInt(8)),this.diskNumberStart===i.MAX_VALUE_32BITS&&(this.diskNumberStart=e.readInt(4))}},readExtraFields:function(e){var t,r,n,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index+4<i;)t=e.readInt(2),r=e.readInt(2),n=e.readData(r),this.extraFields[t]={id:t,length:r,value:n};e.setIndex(i)},handleUTF8:function(){var e=u.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=o.utf8decode(this.fileName),this.fileCommentStr=o.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var r=i.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r)}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else{var s=i.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(s)}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileName)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileComment)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null}},t.exports=l},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(e,t,r){"use strict";function n(e,t,r){this.name=e,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=t,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions}}var i=e("./stream/StreamHelper"),s=e("./stream/DataWorker"),a=e("./utf8"),o=e("./compressedObject"),h=e("./stream/GenericWorker");n.prototype={internalStream:function(e){var t=null,r="string";try{if(!e)throw new Error("No output type specified.");var n="string"===(r=e.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),t=this._decompressWorker();var s=!this._dataBinary;s&&!n&&(t=t.pipe(new a.Utf8EncodeWorker)),!s&&n&&(t=t.pipe(new a.Utf8DecodeWorker))}catch(e){(t=new h("error")).error(e)}return new i(t,r,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof o&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new a.Utf8EncodeWorker)),o.createWorkerFrom(r,e,t)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof h?this._data:new s(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],l=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},f=0;f<u.length;f++)n.prototype[u[f]]=l;t.exports=n},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(e,t,n){(function(e){"use strict";var r,n,i=e.MutationObserver||e.WebKitMutationObserver;if(i){var s=0,a=new i(l),o=e.document.createTextNode("");a.observe(o,{characterData:!0}),r=function(){o.data=s=++s%2}}else if(e.setImmediate||void 0===e.MessageChannel)r="document"in e&&"onreadystatechange"in e.document.createElement("script")?function(){var t=e.document.createElement("script");t.onreadystatechange=function(){l(),t.onreadystatechange=null,t.parentNode.removeChild(t),t=null},e.document.documentElement.appendChild(t)}:function(){setTimeout(l,0)};else{var h=new e.MessageChannel;h.port1.onmessage=l,r=function(){h.port2.postMessage(0)}}var u=[];function l(){var e,t;n=!0;for(var r=u.length;r;){for(t=u,u=[],e=-1;++e<r;)t[e]();r=u.length}n=!1}t.exports=function(e){1!==u.push(e)||n||r()}}).call(this,"undefined"!=typeof r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],37:[function(e,t,r){"use strict";var n=e("immediate");function i(){}var s={},a=["REJECTED"],o=["FULFILLED"],h=["PENDING"];function u(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=h,this.queue=[],this.outcome=void 0,e!==i&&d(this,e)}function l(e,t,r){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected)}function f(e,t,r){n(function(){var n;try{n=t(r)}catch(n){return s.reject(e,n)}n===e?s.reject(e,new TypeError("Cannot resolve promise with itself")):s.resolve(e,n)})}function c(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments)}}function d(e,t){var r=!1;function n(t){r||(r=!0,s.reject(e,t))}function i(t){r||(r=!0,s.resolve(e,t))}var a=p(function(){t(i,n)});"error"===a.status&&n(a.value)}function p(e,t){var r={};try{r.value=e(t),r.status="success"}catch(e){r.status="error",r.value=e}return r}(t.exports=u).prototype.finally=function(e){if("function"!=typeof e)return this;var t=this.constructor;return this.then(function(r){return t.resolve(e()).then(function(){return r})},function(r){return t.resolve(e()).then(function(){throw r})})},u.prototype.catch=function(e){return this.then(null,e)},u.prototype.then=function(e,t){if("function"!=typeof e&&this.state===o||"function"!=typeof t&&this.state===a)return this;var r=new this.constructor(i);return this.state!==h?f(r,this.state===o?e:t,this.outcome):this.queue.push(new l(r,e,t)),r},l.prototype.callFulfilled=function(e){s.resolve(this.promise,e)},l.prototype.otherCallFulfilled=function(e){f(this.promise,this.onFulfilled,e)},l.prototype.callRejected=function(e){s.reject(this.promise,e)},l.prototype.otherCallRejected=function(e){f(this.promise,this.onRejected,e)},s.resolve=function(e,t){var r=p(c,t);if("error"===r.status)return s.reject(e,r.value);var n=r.value;if(n)d(e,n);else{e.state=o,e.outcome=t;for(var i=-1,a=e.queue.length;++i<a;)e.queue[i].callFulfilled(t)}return e},s.reject=function(e,t){e.state=a,e.outcome=t;for(var r=-1,n=e.queue.length;++r<n;)e.queue[r].callRejected(t);return e},u.resolve=function(e){return e instanceof this?e:s.resolve(new this(i),e)},u.reject=function(e){var t=new this(i);return s.reject(t,e)},u.all=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a=new Array(r),o=0,h=-1,u=new this(i);++h<r;)l(e[h],h);return u;function l(e,i){t.resolve(e).then(function(e){a[i]=e,++o!==r||n||(n=!0,s.resolve(u,a))},function(e){n||(n=!0,s.reject(u,e))})}},u.race=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a,o=-1,h=new this(i);++o<r;)a=e[o],t.resolve(a).then(function(e){n||(n=!0,s.resolve(h,e))},function(e){n||(n=!0,s.reject(h,e))});return h}},{immediate:36}],38:[function(e,t,r){"use strict";var n={};(0,e("./lib/utils/common").assign)(n,e("./lib/deflate"),e("./lib/inflate"),e("./lib/zlib/constants")),t.exports=n},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(e,t,r){"use strict";var n=e("./zlib/deflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/messages"),o=e("./zlib/zstream"),h=Object.prototype.toString,u=0,l=-1,f=0,c=8;function d(e){if(!(this instanceof d))return new d(e);this.options=i.assign({level:l,method:c,chunkSize:16384,windowBits:15,memLevel:8,strategy:f,to:""},e||{});var t=this.options;t.raw&&0<t.windowBits?t.windowBits=-t.windowBits:t.gzip&&0<t.windowBits&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new o,this.strm.avail_out=0;var r=n.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(r!==u)throw new Error(a[r]);if(t.header&&n.deflateSetHeader(this.strm,t.header),t.dictionary){var p;if(p="string"==typeof t.dictionary?s.string2buf(t.dictionary):"[object ArrayBuffer]"===h.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(r=n.deflateSetDictionary(this.strm,p))!==u)throw new Error(a[r]);this._dict_set=!0}}function p(e,t){var r=new d(t);if(r.push(e,!0),r.err)throw r.msg||a[r.err];return r.result}d.prototype.push=function(e,t){var r,a,o=this.strm,l=this.options.chunkSize;if(this.ended)return!1;a=t===~~t?t:!0===t?4:0,"string"==typeof e?o.input=s.string2buf(e):"[object ArrayBuffer]"===h.call(e)?o.input=new Uint8Array(e):o.input=e,o.next_in=0,o.avail_in=o.input.length;do{if(0===o.avail_out&&(o.output=new i.Buf8(l),o.next_out=0,o.avail_out=l),1!==(r=n.deflate(o,a))&&r!==u)return this.onEnd(r),!(this.ended=!0);0!==o.avail_out&&(0!==o.avail_in||4!==a&&2!==a)||("string"===this.options.to?this.onData(s.buf2binstring(i.shrinkBuf(o.output,o.next_out))):this.onData(i.shrinkBuf(o.output,o.next_out)))}while((0<o.avail_in||0===o.avail_out)&&1!==r);return 4===a?(r=n.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===u):2!==a||(this.onEnd(u),!(o.avail_out=0))},d.prototype.onData=function(e){this.chunks.push(e)},d.prototype.onEnd=function(e){e===u&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Deflate=d,r.deflate=p,r.deflateRaw=function(e,t){return(t=t||{}).raw=!0,p(e,t)},r.gzip=function(e,t){return(t=t||{}).gzip=!0,p(e,t)}},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(e,t,r){"use strict";var n=e("./zlib/inflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/constants"),o=e("./zlib/messages"),h=e("./zlib/zstream"),u=e("./zlib/gzheader"),l=Object.prototype.toString;function f(e){if(!(this instanceof f))return new f(e);this.options=i.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&0<=t.windowBits&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(0<=t.windowBits&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),15<t.windowBits&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new h,this.strm.avail_out=0;var r=n.inflateInit2(this.strm,t.windowBits);if(r!==a.Z_OK)throw new Error(o[r]);this.header=new u,n.inflateGetHeader(this.strm,this.header)}function c(e,t){var r=new f(t);if(r.push(e,!0),r.err)throw r.msg||o[r.err];return r.result}f.prototype.push=function(e,t){var r,o,h,u,f,c,d=this.strm,p=this.options.chunkSize,m=this.options.dictionary,_=!1;if(this.ended)return!1;o=t===~~t?t:!0===t?a.Z_FINISH:a.Z_NO_FLUSH,"string"==typeof e?d.input=s.binstring2buf(e):"[object ArrayBuffer]"===l.call(e)?d.input=new Uint8Array(e):d.input=e,d.next_in=0,d.avail_in=d.input.length;do{if(0===d.avail_out&&(d.output=new i.Buf8(p),d.next_out=0,d.avail_out=p),(r=n.inflate(d,a.Z_NO_FLUSH))===a.Z_NEED_DICT&&m&&(c="string"==typeof m?s.string2buf(m):"[object ArrayBuffer]"===l.call(m)?new Uint8Array(m):m,r=n.inflateSetDictionary(this.strm,c)),r===a.Z_BUF_ERROR&&!0===_&&(r=a.Z_OK,_=!1),r!==a.Z_STREAM_END&&r!==a.Z_OK)return this.onEnd(r),!(this.ended=!0);d.next_out&&(0!==d.avail_out&&r!==a.Z_STREAM_END&&(0!==d.avail_in||o!==a.Z_FINISH&&o!==a.Z_SYNC_FLUSH)||("string"===this.options.to?(h=s.utf8border(d.output,d.next_out),u=d.next_out-h,f=s.buf2string(d.output,h),d.next_out=u,d.avail_out=p-u,u&&i.arraySet(d.output,d.output,h,u,0),this.onData(f)):this.onData(i.shrinkBuf(d.output,d.next_out)))),0===d.avail_in&&0===d.avail_out&&(_=!0)}while((0<d.avail_in||0===d.avail_out)&&r!==a.Z_STREAM_END);return r===a.Z_STREAM_END&&(o=a.Z_FINISH),o===a.Z_FINISH?(r=n.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===a.Z_OK):o!==a.Z_SYNC_FLUSH||(this.onEnd(a.Z_OK),!(d.avail_out=0))},f.prototype.onData=function(e){this.chunks.push(e)},f.prototype.onEnd=function(e){e===a.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Inflate=f,r.inflate=c,r.inflateRaw=function(e,t){return(t=t||{}).raw=!0,c(e,t)},r.ungzip=c},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;r.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var r=t.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n])}}return e},r.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var i={arraySet:function(e,t,r,n,i){if(t.subarray&&e.subarray)e.set(t.subarray(r,r+n),i);else for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){var t,r,n,i,s,a;for(t=n=0,r=e.length;t<r;t++)n+=e[t].length;for(a=new Uint8Array(n),t=i=0,r=e.length;t<r;t++)s=e[t],a.set(s,i),i+=s.length;return a}},s={arraySet:function(e,t,r,n,i){for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){return[].concat.apply([],e)}};r.setTyped=function(e){e?(r.Buf8=Uint8Array,r.Buf16=Uint16Array,r.Buf32=Int32Array,r.assign(r,i)):(r.Buf8=Array,r.Buf16=Array,r.Buf32=Array,r.assign(r,s))},r.setTyped(n)},{}],42:[function(e,t,r){"use strict";var n=e("./common"),i=!0,s=!0;try{String.fromCharCode.apply(null,[0])}catch(e){i=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(e){s=!1}for(var a=new n.Buf8(256),o=0;o<256;o++)a[o]=252<=o?6:248<=o?5:240<=o?4:224<=o?3:192<=o?2:1;function h(e,t){if(t<65537&&(e.subarray&&s||!e.subarray&&i))return String.fromCharCode.apply(null,n.shrinkBuf(e,t));for(var r="",a=0;a<t;a++)r+=String.fromCharCode(e[a]);return r}a[254]=a[254]=1,r.string2buf=function(e){var t,r,i,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=new n.Buf8(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t},r.buf2binstring=function(e){return h(e,e.length)},r.binstring2buf=function(e){for(var t=new n.Buf8(e.length),r=0,i=t.length;r<i;r++)t[r]=e.charCodeAt(r);return t},r.buf2string=function(e,t){var r,n,i,s,o=t||e.length,u=new Array(2*o);for(r=n=0;r<o;)if((i=e[r++])<128)u[n++]=i;else if(4<(s=a[i]))u[n++]=65533,r+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&r<o;)i=i<<6|63&e[r++],s--;1<s?u[n++]=65533:i<65536?u[n++]=i:(i-=65536,u[n++]=55296|i>>10&1023,u[n++]=56320|1023&i)}return h(u,n)},r.utf8border=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+a[e[r]]>t?r:t}},{"./common":41}],43:[function(e,t,r){"use strict";t.exports=function(e,t,r,n){for(var i=65535&e,s=e>>>16&65535,a=0;0!==r;){for(r-=a=2e3<r?2e3:r;s=s+(i=i+t[n++]|0)|0,--a;);i%=65521,s%=65521}return i|s<<16}},{}],44:[function(e,t,r){"use strict";t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],45:[function(e,t,r){"use strict";var n=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t,r,i){var s=n,a=i+r;e^=-1;for(var o=i;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}},{}],46:[function(e,t,r){"use strict";var n,i=e("../utils/common"),s=e("./trees"),a=e("./adler32"),o=e("./crc32"),h=e("./messages"),u=0,l=4,f=0,c=-2,d=-1,p=4,m=2,_=8,g=9,b=286,v=30,y=19,w=2*b+1,k=15,x=3,S=258,z=S+x+1,C=42,E=113,A=1,I=2,O=3,B=4;function R(e,t){return e.msg=h[t],t}function T(e){return(e<<1)-(4<e?9:0)}function D(e){for(var t=e.length;0<=--t;)e[t]=0}function F(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),0!==r&&(i.arraySet(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,0===t.pending&&(t.pending_out=0))}function N(e,t){s._tr_flush_block(e,0<=e.block_start?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,F(e.strm)}function U(e,t){e.pending_buf[e.pending++]=t}function P(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t}function L(e,t){var r,n,i=e.max_chain_length,s=e.strstart,a=e.prev_length,o=e.nice_match,h=e.strstart>e.w_size-z?e.strstart-(e.w_size-z):0,u=e.window,l=e.w_mask,f=e.prev,c=e.strstart+S,d=u[s+a-1],p=u[s+a];e.prev_length>=e.good_match&&(i>>=2),o>e.lookahead&&(o=e.lookahead);do{if(u[(r=t)+a]===p&&u[r+a-1]===d&&u[r]===u[s]&&u[++r]===u[s+1]){s+=2,r++;do{}while(u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&s<c);if(n=S-(c-s),s=c-S,a<n){if(e.match_start=t,o<=(a=n))break;d=u[s+a-1],p=u[s+a]}}}while((t=f[t&l])>h&&0!=--i);return a<=e.lookahead?a:e.lookahead}function j(e){var t,r,n,s,h,u,l,f,c,d,p=e.w_size;do{if(s=e.window_size-e.lookahead-e.strstart,e.strstart>=p+(p-z)){for(i.arraySet(e.window,e.window,p,p,0),e.match_start-=p,e.strstart-=p,e.block_start-=p,t=r=e.hash_size;n=e.head[--t],e.head[t]=p<=n?n-p:0,--r;);for(t=r=p;n=e.prev[--t],e.prev[t]=p<=n?n-p:0,--r;);s+=p}if(0===e.strm.avail_in)break;if(u=e.strm,l=e.window,f=e.strstart+e.lookahead,c=s,d=void 0,d=u.avail_in,c<d&&(d=c),r=0===d?0:(u.avail_in-=d,i.arraySet(l,u.input,u.next_in,d,f),1===u.state.wrap?u.adler=a(u.adler,l,d,f):2===u.state.wrap&&(u.adler=o(u.adler,l,d,f)),u.next_in+=d,u.total_in+=d,d),e.lookahead+=r,e.lookahead+e.insert>=x)for(h=e.strstart-e.insert,e.ins_h=e.window[h],e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+x-1])&e.hash_mask,e.prev[h&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=h,h++,e.insert--,!(e.lookahead+e.insert<x)););}while(e.lookahead<z&&0!==e.strm.avail_in)}function Z(e,t){for(var r,n;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==r&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r)),e.match_length>=x)if(n=s._tr_tally(e,e.strstart-e.match_start,e.match_length-x),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=x){for(e.match_length--;e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart,0!=--e.match_length;);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function W(e,t){for(var r,n,i;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=x-1,0!==r&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r),e.match_length<=5&&(1===e.strategy||e.match_length===x&&4096<e.strstart-e.match_start)&&(e.match_length=x-1)),e.prev_length>=x&&e.match_length<=e.prev_length){for(i=e.strstart+e.lookahead-x,n=s._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-x),e.lookahead-=e.prev_length-1,e.prev_length-=2;++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!=--e.prev_length;);if(e.match_available=0,e.match_length=x-1,e.strstart++,n&&(N(e,!1),0===e.strm.avail_out))return A}else if(e.match_available){if((n=s._tr_tally(e,0,e.window[e.strstart-1]))&&N(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return A}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(n=s._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function M(e,t,r,n,i){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=i}function H(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=_,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new i.Buf16(2*w),this.dyn_dtree=new i.Buf16(2*(2*v+1)),this.bl_tree=new i.Buf16(2*(2*y+1)),D(this.dyn_ltree),D(this.dyn_dtree),D(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new i.Buf16(k+1),this.heap=new i.Buf16(2*b+1),D(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new i.Buf16(2*b+1),D(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function G(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=m,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?C:E,e.adler=2===t.wrap?0:1,t.last_flush=u,s._tr_init(t),f):R(e,c)}function K(e){var t=G(e);return t===f&&function(e){e.window_size=2*e.w_size,D(e.head),e.max_lazy_match=n[e.level].max_lazy,e.good_match=n[e.level].good_length,e.nice_match=n[e.level].nice_length,e.max_chain_length=n[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=x-1,e.match_available=0,e.ins_h=0}(e.state),t}function Y(e,t,r,n,s,a){if(!e)return c;var o=1;if(t===d&&(t=6),n<0?(o=0,n=-n):15<n&&(o=2,n-=16),s<1||g<s||r!==_||n<8||15<n||t<0||9<t||a<0||p<a)return R(e,c);8===n&&(n=9);var h=new H;return(e.state=h).strm=e,h.wrap=o,h.gzhead=null,h.w_bits=n,h.w_size=1<<h.w_bits,h.w_mask=h.w_size-1,h.hash_bits=s+7,h.hash_size=1<<h.hash_bits,h.hash_mask=h.hash_size-1,h.hash_shift=~~((h.hash_bits+x-1)/x),h.window=new i.Buf8(2*h.w_size),h.head=new i.Buf16(h.hash_size),h.prev=new i.Buf16(h.w_size),h.lit_bufsize=1<<s+6,h.pending_buf_size=4*h.lit_bufsize,h.pending_buf=new i.Buf8(h.pending_buf_size),h.d_buf=1*h.lit_bufsize,h.l_buf=3*h.lit_bufsize,h.level=t,h.strategy=a,h.method=r,K(e)}n=[new M(0,0,0,0,function(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(j(e),0===e.lookahead&&t===u)return A;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((0===e.strstart||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,N(e,!1),0===e.strm.avail_out))return A;if(e.strstart-e.block_start>=e.w_size-z&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):(e.strstart>e.block_start&&(N(e,!1),e.strm.avail_out),A)}),new M(4,4,8,4,Z),new M(4,5,16,8,Z),new M(4,6,32,32,Z),new M(4,4,16,16,W),new M(8,16,32,32,W),new M(8,16,128,128,W),new M(8,32,128,256,W),new M(32,128,258,1024,W),new M(32,258,258,4096,W)],r.deflateInit=function(e,t){return Y(e,t,_,15,8,0)},r.deflateInit2=Y,r.deflateReset=K,r.deflateResetKeep=G,r.deflateSetHeader=function(e,t){return e&&e.state?2!==e.state.wrap?c:(e.state.gzhead=t,f):c},r.deflate=function(e,t){var r,i,a,h;if(!e||!e.state||5<t||t<0)return e?R(e,c):c;if(i=e.state,!e.output||!e.input&&0!==e.avail_in||666===i.status&&t!==l)return R(e,0===e.avail_out?-5:c);if(i.strm=e,r=i.last_flush,i.last_flush=t,i.status===C)if(2===i.wrap)e.adler=0,U(i,31),U(i,139),U(i,8),i.gzhead?(U(i,(i.gzhead.text?1:0)+(i.gzhead.hcrc?2:0)+(i.gzhead.extra?4:0)+(i.gzhead.name?8:0)+(i.gzhead.comment?16:0)),U(i,255&i.gzhead.time),U(i,i.gzhead.time>>8&255),U(i,i.gzhead.time>>16&255),U(i,i.gzhead.time>>24&255),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,255&i.gzhead.os),i.gzhead.extra&&i.gzhead.extra.length&&(U(i,255&i.gzhead.extra.length),U(i,i.gzhead.extra.length>>8&255)),i.gzhead.hcrc&&(e.adler=o(e.adler,i.pending_buf,i.pending,0)),i.gzindex=0,i.status=69):(U(i,0),U(i,0),U(i,0),U(i,0),U(i,0),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,3),i.status=E);else{var d=_+(i.w_bits-8<<4)<<8;d|=(2<=i.strategy||i.level<2?0:i.level<6?1:6===i.level?2:3)<<6,0!==i.strstart&&(d|=32),d+=31-d%31,i.status=E,P(i,d),0!==i.strstart&&(P(i,e.adler>>>16),P(i,65535&e.adler)),e.adler=1}if(69===i.status)if(i.gzhead.extra){for(a=i.pending;i.gzindex<(65535&i.gzhead.extra.length)&&(i.pending!==i.pending_buf_size||(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending!==i.pending_buf_size));)U(i,255&i.gzhead.extra[i.gzindex]),i.gzindex++;i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),i.gzindex===i.gzhead.extra.length&&(i.gzindex=0,i.status=73)}else i.status=73;if(73===i.status)if(i.gzhead.name){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.name.length?255&i.gzhead.name.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.gzindex=0,i.status=91)}else i.status=91;if(91===i.status)if(i.gzhead.comment){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.comment.length?255&i.gzhead.comment.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.status=103)}else i.status=103;if(103===i.status&&(i.gzhead.hcrc?(i.pending+2>i.pending_buf_size&&F(e),i.pending+2<=i.pending_buf_size&&(U(i,255&e.adler),U(i,e.adler>>8&255),e.adler=0,i.status=E)):i.status=E),0!==i.pending){if(F(e),0===e.avail_out)return i.last_flush=-1,f}else if(0===e.avail_in&&T(t)<=T(r)&&t!==l)return R(e,-5);if(666===i.status&&0!==e.avail_in)return R(e,-5);if(0!==e.avail_in||0!==i.lookahead||t!==u&&666!==i.status){var p=2===i.strategy?function(e,t){for(var r;;){if(0===e.lookahead&&(j(e),0===e.lookahead)){if(t===u)return A;break}if(e.match_length=0,r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):3===i.strategy?function(e,t){for(var r,n,i,a,o=e.window;;){if(e.lookahead<=S){if(j(e),e.lookahead<=S&&t===u)return A;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=x&&0<e.strstart&&(n=o[i=e.strstart-1])===o[++i]&&n===o[++i]&&n===o[++i]){a=e.strstart+S;do{}while(n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&i<a);e.match_length=S-(a-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=x?(r=s._tr_tally(e,1,e.match_length-x),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):n[i.level].func(i,t);if(p!==O&&p!==B||(i.status=666),p===A||p===O)return 0===e.avail_out&&(i.last_flush=-1),f;if(p===I&&(1===t?s._tr_align(i):5!==t&&(s._tr_stored_block(i,0,0,!1),3===t&&(D(i.head),0===i.lookahead&&(i.strstart=0,i.block_start=0,i.insert=0))),F(e),0===e.avail_out))return i.last_flush=-1,f}return t!==l?f:i.wrap<=0?1:(2===i.wrap?(U(i,255&e.adler),U(i,e.adler>>8&255),U(i,e.adler>>16&255),U(i,e.adler>>24&255),U(i,255&e.total_in),U(i,e.total_in>>8&255),U(i,e.total_in>>16&255),U(i,e.total_in>>24&255)):(P(i,e.adler>>>16),P(i,65535&e.adler)),F(e),0<i.wrap&&(i.wrap=-i.wrap),0!==i.pending?f:1)},r.deflateEnd=function(e){var t;return e&&e.state?(t=e.state.status)!==C&&69!==t&&73!==t&&91!==t&&103!==t&&t!==E&&666!==t?R(e,c):(e.state=null,t===E?R(e,-3):f):c},r.deflateSetDictionary=function(e,t){var r,n,s,o,h,u,l,d,p=t.length;if(!e||!e.state)return c;if(2===(o=(r=e.state).wrap)||1===o&&r.status!==C||r.lookahead)return c;for(1===o&&(e.adler=a(e.adler,t,p,0)),r.wrap=0,p>=r.w_size&&(0===o&&(D(r.head),r.strstart=0,r.block_start=0,r.insert=0),d=new i.Buf8(r.w_size),i.arraySet(d,t,p-r.w_size,r.w_size,0),t=d,p=r.w_size),h=e.avail_in,u=e.next_in,l=e.input,e.avail_in=p,e.next_in=0,e.input=t,j(r);r.lookahead>=x;){for(n=r.strstart,s=r.lookahead-(x-1);r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+x-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++,--s;);r.strstart=n,r.lookahead=x-1,j(r)}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=x-1,r.match_available=0,e.next_in=u,e.input=l,e.avail_in=h,r.wrap=o,f},r.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(e,t,r){"use strict";t.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}},{}],48:[function(e,t,r){"use strict";t.exports=function(e,t){var r,n,i,s,a,o,h,u,l,f,c,d,p,m,_,g,b,v,y,w,k,x,S,z,C;r=e.state,n=e.next_in,z=e.input,i=n+(e.avail_in-5),s=e.next_out,C=e.output,a=s-(t-e.avail_out),o=s+(e.avail_out-257),h=r.dmax,u=r.wsize,l=r.whave,f=r.wnext,c=r.window,d=r.hold,p=r.bits,m=r.lencode,_=r.distcode,g=(1<<r.lenbits)-1,b=(1<<r.distbits)-1;e:do{p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=m[d&g];t:for(;;){if(d>>>=y=v>>>24,p-=y,0===(y=v>>>16&255))C[s++]=65535&v;else{if(!(16&y)){if(0==(64&y)){v=m[(65535&v)+(d&(1<<y)-1)];continue t}if(32&y){r.mode=12;break e}e.msg="invalid literal/length code",r.mode=30;break e}w=65535&v,(y&=15)&&(p<y&&(d+=z[n++]<<p,p+=8),w+=d&(1<<y)-1,d>>>=y,p-=y),p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=_[d&b];r:for(;;){if(d>>>=y=v>>>24,p-=y,!(16&(y=v>>>16&255))){if(0==(64&y)){v=_[(65535&v)+(d&(1<<y)-1)];continue r}e.msg="invalid distance code",r.mode=30;break e}if(k=65535&v,p<(y&=15)&&(d+=z[n++]<<p,(p+=8)<y&&(d+=z[n++]<<p,p+=8)),h<(k+=d&(1<<y)-1)){e.msg="invalid distance too far back",r.mode=30;break e}if(d>>>=y,p-=y,(y=s-a)<k){if(l<(y=k-y)&&r.sane){e.msg="invalid distance too far back",r.mode=30;break e}if(S=c,(x=0)===f){if(x+=u-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}}else if(f<y){if(x+=u+f-y,(y-=f)<w){for(w-=y;C[s++]=c[x++],--y;);if(x=0,f<w){for(w-=y=f;C[s++]=c[x++],--y;);x=s-k,S=C}}}else if(x+=f-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}for(;2<w;)C[s++]=S[x++],C[s++]=S[x++],C[s++]=S[x++],w-=3;w&&(C[s++]=S[x++],1<w&&(C[s++]=S[x++]))}else{for(x=s-k;C[s++]=C[x++],C[s++]=C[x++],C[s++]=C[x++],2<(w-=3););w&&(C[s++]=C[x++],1<w&&(C[s++]=C[x++]))}break}}break}}while(n<i&&s<o);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,e.next_in=n,e.next_out=s,e.avail_in=n<i?i-n+5:5-(n-i),e.avail_out=s<o?o-s+257:257-(s-o),r.hold=d,r.bits=p}},{}],49:[function(e,t,r){"use strict";var n=e("../utils/common"),i=e("./adler32"),s=e("./crc32"),a=e("./inffast"),o=e("./inftrees"),h=1,u=2,l=0,f=-2,c=1,d=852,p=592;function m(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function _(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new n.Buf16(320),this.work=new n.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function g(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=c,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new n.Buf32(d),t.distcode=t.distdyn=new n.Buf32(p),t.sane=1,t.back=-1,l):f}function b(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,g(e)):f}function v(e,t){var r,n;return e&&e.state?(n=e.state,t<0?(r=0,t=-t):(r=1+(t>>4),t<48&&(t&=15)),t&&(t<8||15<t)?f:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=r,n.wbits=t,b(e))):f}function y(e,t){var r,n;return e?(n=new _,(e.state=n).window=null,(r=v(e,t))!==l&&(e.state=null),r):f}var w,k,x=!0;function S(e){if(x){var t;for(w=new n.Buf32(512),k=new n.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(o(h,e.lens,0,288,w,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;o(u,e.lens,0,32,k,0,e.work,{bits:5}),x=!1}e.lencode=w,e.lenbits=9,e.distcode=k,e.distbits=5}function z(e,t,r,i){var s,a=e.state;return null===a.window&&(a.wsize=1<<a.wbits,a.wnext=0,a.whave=0,a.window=new n.Buf8(a.wsize)),i>=a.wsize?(n.arraySet(a.window,t,r-a.wsize,a.wsize,0),a.wnext=0,a.whave=a.wsize):(i<(s=a.wsize-a.wnext)&&(s=i),n.arraySet(a.window,t,r-i,s,a.wnext),(i-=s)?(n.arraySet(a.window,t,r-i,i,0),a.wnext=i,a.whave=a.wsize):(a.wnext+=s,a.wnext===a.wsize&&(a.wnext=0),a.whave<a.wsize&&(a.whave+=s))),0}r.inflateReset=b,r.inflateReset2=v,r.inflateResetKeep=g,r.inflateInit=function(e){return y(e,15)},r.inflateInit2=y,r.inflate=function(e,t){var r,d,p,_,g,b,v,y,w,k,x,C,E,A,I,O,B,R,T,D,F,N,U,P,L=0,j=new n.Buf8(4),Z=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return f;12===(r=e.state).mode&&(r.mode=13),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,k=b,x=v,N=l;e:for(;;)switch(r.mode){case c:if(0===r.wrap){r.mode=13;break}for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(2&r.wrap&&35615===y){j[r.check=0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0),w=y=0,r.mode=2;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&y)<<8)+(y>>8))%31){e.msg="incorrect header check",r.mode=30;break}if(8!=(15&y)){e.msg="unknown compression method",r.mode=30;break}if(w-=4,F=8+(15&(y>>>=4)),0===r.wbits)r.wbits=F;else if(F>r.wbits){e.msg="invalid window size",r.mode=30;break}r.dmax=1<<F,e.adler=r.check=1,r.mode=512&y?10:12,w=y=0;break;case 2:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.flags=y,8!=(255&r.flags)){e.msg="unknown compression method",r.mode=30;break}if(57344&r.flags){e.msg="unknown header flags set",r.mode=30;break}r.head&&(r.head.text=y>>8&1),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=3;case 3:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.time=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,j[2]=y>>>16&255,j[3]=y>>>24&255,r.check=s(r.check,j,4,0)),w=y=0,r.mode=4;case 4:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.xflags=255&y,r.head.os=y>>8),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=5;case 5:if(1024&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length=y,r.head&&(r.head.extra_len=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0}else r.head&&(r.head.extra=null);r.mode=6;case 6:if(1024&r.flags&&(b<(C=r.length)&&(C=b),C&&(r.head&&(F=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),n.arraySet(r.head.extra,d,_,C,F)),512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,r.length-=C),r.length))break e;r.length=0,r.mode=7;case 7:if(2048&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.name+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.name=null);r.length=0,r.mode=8;case 8:if(4096&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.comment+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.comment=null);r.mode=9;case 9:if(512&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(65535&r.check)){e.msg="header crc mismatch",r.mode=30;break}w=y=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),e.adler=r.check=0,r.mode=12;break;case 10:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}e.adler=r.check=m(y),w=y=0,r.mode=11;case 11:if(0===r.havedict)return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,2;e.adler=r.check=1,r.mode=12;case 12:if(5===t||6===t)break e;case 13:if(r.last){y>>>=7&w,w-=7&w,r.mode=27;break}for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}switch(r.last=1&y,w-=1,3&(y>>>=1)){case 0:r.mode=14;break;case 1:if(S(r),r.mode=20,6!==t)break;y>>>=2,w-=2;break e;case 2:r.mode=17;break;case 3:e.msg="invalid block type",r.mode=30}y>>>=2,w-=2;break;case 14:for(y>>>=7&w,w-=7&w;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if((65535&y)!=(y>>>16^65535)){e.msg="invalid stored block lengths",r.mode=30;break}if(r.length=65535&y,w=y=0,r.mode=15,6===t)break e;case 15:r.mode=16;case 16:if(C=r.length){if(b<C&&(C=b),v<C&&(C=v),0===C)break e;n.arraySet(p,d,_,C,g),b-=C,_+=C,v-=C,g+=C,r.length-=C;break}r.mode=12;break;case 17:for(;w<14;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.nlen=257+(31&y),y>>>=5,w-=5,r.ndist=1+(31&y),y>>>=5,w-=5,r.ncode=4+(15&y),y>>>=4,w-=4,286<r.nlen||30<r.ndist){e.msg="too many length or distance symbols",r.mode=30;break}r.have=0,r.mode=18;case 18:for(;r.have<r.ncode;){for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.lens[Z[r.have++]]=7&y,y>>>=3,w-=3}for(;r.have<19;)r.lens[Z[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,U={bits:r.lenbits},N=o(0,r.lens,0,19,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid code lengths set",r.mode=30;break}r.have=0,r.mode=19;case 19:for(;r.have<r.nlen+r.ndist;){for(;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(B<16)y>>>=I,w-=I,r.lens[r.have++]=B;else{if(16===B){for(P=I+2;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y>>>=I,w-=I,0===r.have){e.msg="invalid bit length repeat",r.mode=30;break}F=r.lens[r.have-1],C=3+(3&y),y>>>=2,w-=2}else if(17===B){for(P=I+3;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=3+(7&(y>>>=I)),y>>>=3,w-=3}else{for(P=I+7;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=11+(127&(y>>>=I)),y>>>=7,w-=7}if(r.have+C>r.nlen+r.ndist){e.msg="invalid bit length repeat",r.mode=30;break}for(;C--;)r.lens[r.have++]=F}}if(30===r.mode)break;if(0===r.lens[256]){e.msg="invalid code -- missing end-of-block",r.mode=30;break}if(r.lenbits=9,U={bits:r.lenbits},N=o(h,r.lens,0,r.nlen,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid literal/lengths set",r.mode=30;break}if(r.distbits=6,r.distcode=r.distdyn,U={bits:r.distbits},N=o(u,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,U),r.distbits=U.bits,N){e.msg="invalid distances set",r.mode=30;break}if(r.mode=20,6===t)break e;case 20:r.mode=21;case 21:if(6<=b&&258<=v){e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,a(e,x),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,12===r.mode&&(r.back=-1);break}for(r.back=0;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(O&&0==(240&O)){for(R=I,T=O,D=B;O=(L=r.lencode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,r.length=B,0===O){r.mode=26;break}if(32&O){r.back=-1,r.mode=12;break}if(64&O){e.msg="invalid literal/length code",r.mode=30;break}r.extra=15&O,r.mode=22;case 22:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=23;case 23:for(;O=(L=r.distcode[y&(1<<r.distbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(0==(240&O)){for(R=I,T=O,D=B;O=(L=r.distcode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,64&O){e.msg="invalid distance code",r.mode=30;break}r.offset=B,r.extra=15&O,r.mode=24;case 24:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.offset+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){e.msg="invalid distance too far back",r.mode=30;break}r.mode=25;case 25:if(0===v)break e;if(C=x-v,r.offset>C){if((C=r.offset-C)>r.whave&&r.sane){e.msg="invalid distance too far back",r.mode=30;break}E=C>r.wnext?(C-=r.wnext,r.wsize-C):r.wnext-C,C>r.length&&(C=r.length),A=r.window}else A=p,E=g-r.offset,C=r.length;for(v<C&&(C=v),v-=C,r.length-=C;p[g++]=A[E++],--C;);0===r.length&&(r.mode=21);break;case 26:if(0===v)break e;p[g++]=r.length,v--,r.mode=21;break;case 27:if(r.wrap){for(;w<32;){if(0===b)break e;b--,y|=d[_++]<<w,w+=8}if(x-=v,e.total_out+=x,r.total+=x,x&&(e.adler=r.check=r.flags?s(r.check,p,x,g-x):i(r.check,p,x,g-x)),x=v,(r.flags?y:m(y))!==r.check){e.msg="incorrect data check",r.mode=30;break}w=y=0}r.mode=28;case 28:if(r.wrap&&r.flags){for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(4294967295&r.total)){e.msg="incorrect length check",r.mode=30;break}w=y=0}r.mode=29;case 29:N=1;break e;case 30:N=-3;break e;case 31:return-4;case 32:default:return f}return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,(r.wsize||x!==e.avail_out&&r.mode<30&&(r.mode<27||4!==t))&&z(e,e.output,e.next_out,x-e.avail_out)?(r.mode=31,-4):(k-=e.avail_in,x-=e.avail_out,e.total_in+=k,e.total_out+=x,r.total+=x,r.wrap&&x&&(e.adler=r.check=r.flags?s(r.check,p,x,e.next_out-x):i(r.check,p,x,e.next_out-x)),e.data_type=r.bits+(r.last?64:0)+(12===r.mode?128:0)+(20===r.mode||15===r.mode?256:0),(0==k&&0===x||4===t)&&N===l&&(N=-5),N)},r.inflateEnd=function(e){if(!e||!e.state)return f;var t=e.state;return t.window&&(t.window=null),e.state=null,l},r.inflateGetHeader=function(e,t){var r;return e&&e.state?0==(2&(r=e.state).wrap)?f:((r.head=t).done=!1,l):f},r.inflateSetDictionary=function(e,t){var r,n=t.length;return e&&e.state?0!==(r=e.state).wrap&&11!==r.mode?f:11===r.mode&&i(1,t,n,0)!==r.check?-3:z(e,t,n,n)?(r.mode=31,-4):(r.havedict=1,l):f},r.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(e,t,r){"use strict";var n=e("../utils/common"),i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],s=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],a=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],o=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,r,h,u,l,f,c){var d,p,m,_,g,b,v,y,w,k=c.bits,x=0,S=0,z=0,C=0,E=0,A=0,I=0,O=0,B=0,R=0,T=null,D=0,F=new n.Buf16(16),N=new n.Buf16(16),U=null,P=0;for(x=0;x<=15;x++)F[x]=0;for(S=0;S<h;S++)F[t[r+S]]++;for(E=k,C=15;1<=C&&0===F[C];C--);if(C<E&&(E=C),0===C)return u[l++]=20971520,u[l++]=20971520,c.bits=1,0;for(z=1;z<C&&0===F[z];z++);for(E<z&&(E=z),x=O=1;x<=15;x++)if(O<<=1,(O-=F[x])<0)return-1;if(0<O&&(0===e||1!==C))return-1;for(N[1]=0,x=1;x<15;x++)N[x+1]=N[x]+F[x];for(S=0;S<h;S++)0!==t[r+S]&&(f[N[t[r+S]]++]=S);if(b=0===e?(T=U=f,19):1===e?(T=i,D-=257,U=s,P-=257,256):(T=a,U=o,-1),x=z,g=l,I=S=R=0,m=-1,_=(B=1<<(A=E))-1,1===e&&852<B||2===e&&592<B)return 1;for(;;){for(v=x-I,w=f[S]<b?(y=0,f[S]):f[S]>b?(y=U[P+f[S]],T[D+f[S]]):(y=96,0),d=1<<x-I,z=p=1<<A;u[g+(R>>I)+(p-=d)]=v<<24|y<<16|w,0!==p;);for(d=1<<x-1;R&d;)d>>=1;if(0!==d?(R&=d-1,R+=d):R=0,S++,0==--F[x]){if(x===C)break;x=t[r+f[S]]}if(E<x&&(R&_)!==m){for(0===I&&(I=E),g+=z,O=1<<(A=x-I);A+I<C&&!((O-=F[A+I])<=0);)A++,O<<=1;if(B+=1<<A,1===e&&852<B||2===e&&592<B)return 1;u[m=R&_]=E<<24|A<<16|g-l}}return 0!==R&&(u[g+R]=x-I<<24|64<<16),c.bits=E,0}},{"../utils/common":41}],51:[function(e,t,r){"use strict";t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],52:[function(e,t,r){"use strict";var n=e("../utils/common"),i=0,s=1;function a(e){for(var t=e.length;0<=--t;)e[t]=0}var o=0,h=29,u=256,l=u+1+h,f=30,c=19,d=2*l+1,p=15,m=16,_=7,g=256,b=16,v=17,y=18,w=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],k=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],x=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],S=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],z=new Array(2*(l+2));a(z);var C=new Array(2*f);a(C);var E=new Array(512);a(E);var A=new Array(256);a(A);var I=new Array(h);a(I);var O,B,R,T=new Array(f);function D(e,t,r,n,i){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=e&&e.length}function F(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function N(e){return e<256?E[e]:E[256+(e>>>7)]}function U(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255}function P(e,t,r){e.bi_valid>m-r?(e.bi_buf|=t<<e.bi_valid&65535,U(e,e.bi_buf),e.bi_buf=t>>m-e.bi_valid,e.bi_valid+=r-m):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r)}function L(e,t,r){P(e,r[2*t],r[2*t+1])}function j(e,t){for(var r=0;r|=1&e,e>>>=1,r<<=1,0<--t;);return r>>>1}function Z(e,t,r){var n,i,s=new Array(p+1),a=0;for(n=1;n<=p;n++)s[n]=a=a+r[n-1]<<1;for(i=0;i<=t;i++){var o=e[2*i+1];0!==o&&(e[2*i]=j(s[o]++,o))}}function W(e){var t;for(t=0;t<l;t++)e.dyn_ltree[2*t]=0;for(t=0;t<f;t++)e.dyn_dtree[2*t]=0;for(t=0;t<c;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*g]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function M(e){8<e.bi_valid?U(e,e.bi_buf):0<e.bi_valid&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function H(e,t,r,n){var i=2*t,s=2*r;return e[i]<e[s]||e[i]===e[s]&&n[t]<=n[r]}function G(e,t,r){for(var n=e.heap[r],i=r<<1;i<=e.heap_len&&(i<e.heap_len&&H(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!H(t,n,e.heap[i],e.depth));)e.heap[r]=e.heap[i],r=i,i<<=1;e.heap[r]=n}function K(e,t,r){var n,i,s,a,o=0;if(0!==e.last_lit)for(;n=e.pending_buf[e.d_buf+2*o]<<8|e.pending_buf[e.d_buf+2*o+1],i=e.pending_buf[e.l_buf+o],o++,0===n?L(e,i,t):(L(e,(s=A[i])+u+1,t),0!==(a=w[s])&&P(e,i-=I[s],a),L(e,s=N(--n),r),0!==(a=k[s])&&P(e,n-=T[s],a)),o<e.last_lit;);L(e,g,t)}function Y(e,t){var r,n,i,s=t.dyn_tree,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,h=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=d,r=0;r<h;r++)0!==s[2*r]?(e.heap[++e.heap_len]=u=r,e.depth[r]=0):s[2*r+1]=0;for(;e.heap_len<2;)s[2*(i=e.heap[++e.heap_len]=u<2?++u:0)]=1,e.depth[i]=0,e.opt_len--,o&&(e.static_len-=a[2*i+1]);for(t.max_code=u,r=e.heap_len>>1;1<=r;r--)G(e,s,r);for(i=h;r=e.heap[1],e.heap[1]=e.heap[e.heap_len--],G(e,s,1),n=e.heap[1],e.heap[--e.heap_max]=r,e.heap[--e.heap_max]=n,s[2*i]=s[2*r]+s[2*n],e.depth[i]=(e.depth[r]>=e.depth[n]?e.depth[r]:e.depth[n])+1,s[2*r+1]=s[2*n+1]=i,e.heap[1]=i++,G(e,s,1),2<=e.heap_len;);e.heap[--e.heap_max]=e.heap[1],function(e,t){var r,n,i,s,a,o,h=t.dyn_tree,u=t.max_code,l=t.stat_desc.static_tree,f=t.stat_desc.has_stree,c=t.stat_desc.extra_bits,m=t.stat_desc.extra_base,_=t.stat_desc.max_length,g=0;for(s=0;s<=p;s++)e.bl_count[s]=0;for(h[2*e.heap[e.heap_max]+1]=0,r=e.heap_max+1;r<d;r++)_<(s=h[2*h[2*(n=e.heap[r])+1]+1]+1)&&(s=_,g++),h[2*n+1]=s,u<n||(e.bl_count[s]++,a=0,m<=n&&(a=c[n-m]),o=h[2*n],e.opt_len+=o*(s+a),f&&(e.static_len+=o*(l[2*n+1]+a)));if(0!==g){do{for(s=_-1;0===e.bl_count[s];)s--;e.bl_count[s]--,e.bl_count[s+1]+=2,e.bl_count[_]--,g-=2}while(0<g);for(s=_;0!==s;s--)for(n=e.bl_count[s];0!==n;)u<(i=e.heap[--r])||(h[2*i+1]!==s&&(e.opt_len+=(s-h[2*i+1])*h[2*i],h[2*i+1]=s),n--)}}(e,t),Z(s,u,e.bl_count)}function X(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),t[2*(r+1)+1]=65535,n=0;n<=r;n++)i=a,a=t[2*(n+1)+1],++o<h&&i===a||(o<u?e.bl_tree[2*i]+=o:0!==i?(i!==s&&e.bl_tree[2*i]++,e.bl_tree[2*b]++):o<=10?e.bl_tree[2*v]++:e.bl_tree[2*y]++,s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4))}function V(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),n=0;n<=r;n++)if(i=a,a=t[2*(n+1)+1],!(++o<h&&i===a)){if(o<u)for(;L(e,i,e.bl_tree),0!=--o;);else 0!==i?(i!==s&&(L(e,i,e.bl_tree),o--),L(e,b,e.bl_tree),P(e,o-3,2)):o<=10?(L(e,v,e.bl_tree),P(e,o-3,3)):(L(e,y,e.bl_tree),P(e,o-11,7));s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4)}}a(T);var q=!1;function J(e,t,r,i){P(e,(o<<1)+(i?1:0),3),function(e,t,r,i){M(e),i&&(U(e,r),U(e,~r)),n.arraySet(e.pending_buf,e.window,t,r,e.pending),e.pending+=r}(e,t,r,!0)}r._tr_init=function(e){q||(function(){var e,t,r,n,i,s=new Array(p+1);for(n=r=0;n<h-1;n++)for(I[n]=r,e=0;e<1<<w[n];e++)A[r++]=n;for(A[r-1]=n,n=i=0;n<16;n++)for(T[n]=i,e=0;e<1<<k[n];e++)E[i++]=n;for(i>>=7;n<f;n++)for(T[n]=i<<7,e=0;e<1<<k[n]-7;e++)E[256+i++]=n;for(t=0;t<=p;t++)s[t]=0;for(e=0;e<=143;)z[2*e+1]=8,e++,s[8]++;for(;e<=255;)z[2*e+1]=9,e++,s[9]++;for(;e<=279;)z[2*e+1]=7,e++,s[7]++;for(;e<=287;)z[2*e+1]=8,e++,s[8]++;for(Z(z,l+1,s),e=0;e<f;e++)C[2*e+1]=5,C[2*e]=j(e,5);O=new D(z,w,u+1,l,p),B=new D(C,k,0,f,p),R=new D(new Array(0),x,0,c,_)}(),q=!0),e.l_desc=new F(e.dyn_ltree,O),e.d_desc=new F(e.dyn_dtree,B),e.bl_desc=new F(e.bl_tree,R),e.bi_buf=0,e.bi_valid=0,W(e)},r._tr_stored_block=J,r._tr_flush_block=function(e,t,r,n){var a,o,h=0;0<e.level?(2===e.strm.data_type&&(e.strm.data_type=function(e){var t,r=4093624447;for(t=0;t<=31;t++,r>>>=1)if(1&r&&0!==e.dyn_ltree[2*t])return i;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return s;for(t=32;t<u;t++)if(0!==e.dyn_ltree[2*t])return s;return i}(e)),Y(e,e.l_desc),Y(e,e.d_desc),h=function(e){var t;for(X(e,e.dyn_ltree,e.l_desc.max_code),X(e,e.dyn_dtree,e.d_desc.max_code),Y(e,e.bl_desc),t=c-1;3<=t&&0===e.bl_tree[2*S[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),a=e.opt_len+3+7>>>3,(o=e.static_len+3+7>>>3)<=a&&(a=o)):a=o=r+5,r+4<=a&&-1!==t?J(e,t,r,n):4===e.strategy||o===a?(P(e,2+(n?1:0),3),K(e,z,C)):(P(e,4+(n?1:0),3),function(e,t,r,n){var i;for(P(e,t-257,5),P(e,r-1,5),P(e,n-4,4),i=0;i<n;i++)P(e,e.bl_tree[2*S[i]+1],3);V(e,e.dyn_ltree,t-1),V(e,e.dyn_dtree,r-1)}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,h+1),K(e,e.dyn_ltree,e.dyn_dtree)),W(e),n&&M(e)},r._tr_tally=function(e,t,r){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&r,e.last_lit++,0===t?e.dyn_ltree[2*r]++:(e.matches++,t--,e.dyn_ltree[2*(A[r]+u+1)]++,e.dyn_dtree[2*N(t)]++),e.last_lit===e.lit_bufsize-1},r._tr_align=function(e){P(e,2,3),L(e,g,z),function(e){16===e.bi_valid?(U(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):8<=e.bi_valid&&(e.pending_buf[e.pending++]=255&e.bi_buf,e.bi_buf>>=8,e.bi_valid-=8)}(e)}},{"../utils/common":41}],53:[function(e,t,r){"use strict";t.exports=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}},{}],54:[function(e,t,n){(function(e){!function(e,t){"use strict";if(!e.setImmediate){var r,n,i,s,a=1,o={},h=!1,u=e.document,l=Object.getPrototypeOf&&Object.getPrototypeOf(e);l=l&&l.setTimeout?l:e,r="[object process]"==={}.toString.call(e.process)?function(e){process.nextTick(function(){c(e)})}:function(){if(e.postMessage&&!e.importScripts){var t=!0,r=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=r,t}}()?(s="setImmediate$"+Math.random()+"$",e.addEventListener?e.addEventListener("message",d,!1):e.attachEvent("onmessage",d),function(t){e.postMessage(s+t,"*")}):e.MessageChannel?((i=new MessageChannel).port1.onmessage=function(e){c(e.data)},function(e){i.port2.postMessage(e)}):u&&"onreadystatechange"in u.createElement("script")?(n=u.documentElement,function(e){var t=u.createElement("script");t.onreadystatechange=function(){c(e),t.onreadystatechange=null,n.removeChild(t),t=null},n.appendChild(t)}):function(e){setTimeout(c,0,e)},l.setImmediate=function(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var i={callback:e,args:t};return o[a]=i,r(a),a++},l.clearImmediate=f}function f(e){delete o[e]}function c(e){if(h)setTimeout(c,0,e);else{var r=o[e];if(r){h=!0;try{!function(e){var r=e.callback,n=e.args;switch(n.length){case 0:r();break;case 1:r(n[0]);break;case 2:r(n[0],n[1]);break;case 3:r(n[0],n[1],n[2]);break;default:r.apply(t,n)}}(r)}finally{f(e),h=!1}}}}function d(t){t.source===e&&"string"==typeof t.data&&0===t.data.indexOf(s)&&c(+t.data.slice(s.length))}}("undefined"==typeof self?void 0===e?this:e:self)}).call(this,"undefined"!=typeof r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[10])(10)})}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[669],{9669:function(e){e.exports=JSON.parse('{"ui.app.title":"افزونه‌های کنتائو","ui.app.loading":"بارگذاری لیست افزونه...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"بارگذاری ...","ui.discover.offline":"Could not fetch any results.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"دوباره تلاش کنید","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"هیچ نتیجه‌ای برای {query}","ui.discover.more":"نتایج بیشتر","ui.discover.sortBy":"مرتب‌سازی براساس","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"بروزرسانی شده","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"دانلودها","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"امتیاز","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"جزئیات","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"افزونه‌های با امتیاز بالا","ui.discover.downloadsPackages":"Most downloaded extensions","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"وب‌سایت پروژه","ui.package.private":"بسته اختصاصی","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"منع شده","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"جزئیات افزونه قبلی","ui.package-details.close":"بستن جزئیات افزونه","ui.package-details.loading":"بارگذاری ...","ui.package-details.tabDescription":"توضیح","ui.package-details.tabRequire":"نیازمندی‌ها","ui.package-details.tabFeatures":"ویژگی‌ها","ui.package-details.tabSuggest":"پیشنهادها","ui.package-details.tabConflict":"ناسازگاری‌ها","ui.package-details.tabDependents":"وابسته‌ها","ui.package-details.linkRequires":"نیاز دارد","ui.package-details.linkReplaces":"جایگزین می‌کند","ui.package-details.linkProvides":"فراهم می‌کند","ui.package-details.linkConflicts":"ناسازگار است","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"آخرین نسخه","ui.package-details.released":"منتشر شده در","ui.package-details.license":"مجوز(ها)","ui.package-details.authors":"از","ui.package-details.more":"بیشتر","ui.package-details.packagist":"جژئیات بسته","ui.package-details.metadata":"ویرایش فرداده","ui.package-details.support_docs":"مستندات","ui.package-details.support_wiki":"ویکی","ui.package-details.support_forum":"انجمن پشتیبانی","ui.package-details.support_issues":"مشکلات / گزارش باگ","ui.package-details.support_source":"کد منبع","ui.package-details.support_irc":"IRC / چت","ui.package-details.support_email":"ایمیل پشتیبانی","ui.package-details.support_rss":"خوراک RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[581],{4581:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao проширења","ui.app.loading":"Учитавам листу проширења...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Оглашавање у листи екстензија","ui.discover.loading":"Учитавам ...","ui.discover.offline":"Нема пронађених резултата.","ui.discover.offlineExplain":"Проверите вашу интернет конекцију и искључите блокаду JavaScript-а у вашем прегледачу.","ui.discover.offlineButton":"Покушајте поново","ui.discover.searchPlaceholder":"Претражи у {count} екстензија ...","ui.discover.empty":"Нема резултата за {query}","ui.discover.more":"Више резултата","ui.discover.sortBy":"Сортирај по","ui.discover.sortReleased":"Објављено","ui.discover.sortReleasedTitle":"Поредај резултате по датуму објаве","ui.discover.sortLatest":"Ажурирано","ui.discover.sortLatestTitle":"Поредај резултате по датуму ажурирања","ui.discover.sortDownloads":"Преузимања","ui.discover.sortDownloadsTitle":"Поредај резултате по броју преузимања","ui.discover.sortFavers":"Оцене","ui.discover.sortFaversTitle":"Поредај резултате по оцени","ui.discover.detailsButton":"Детаљи","ui.discover.latestPackages":"Последње и ажуриране екстензије","ui.discover.faversPackages":"Најбоље оцењене екстензије","ui.discover.downloadsPackages":"Екстензије са највише преузимања","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Вебсајт пројекта","ui.package.private":"Приватни пакети","ui.package.privateTitle":"Приватни пакети су доступни само од вендора (нпр. као ZIP преузимање). Посетите сајт ради више информација.","ui.package.abandoned":"напуштено","ui.package.abandonedText":"Овај пакет је напуштен и више се не одржава.","ui.package.abandonedReplace":"Овај пакет је напуштен и више се не одржава. Аутор предлаже да користите {replacement} као замену.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Детаљи претходне екстензије","ui.package-details.close":"Затвори детаље екстензије","ui.package-details.loading":"Учитавам ...","ui.package-details.tabDescription":"Опис","ui.package-details.tabRequire":"Захтеви","ui.package-details.tabFeatures":"Могућности","ui.package-details.tabSuggest":"Предлози","ui.package-details.tabConflict":"Конфликти","ui.package-details.tabDependents":"Зависности","ui.package-details.linkRequires":"захтева","ui.package-details.linkReplaces":"мења","ui.package-details.linkProvides":"пружа","ui.package-details.linkConflicts":"сукобљава се са","ui.package-details.funding":"Спонзорирајте одржавање пакета!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Последња верзија","ui.package-details.released":"објављено","ui.package-details.license":"Лиценца(е)","ui.package-details.authors":"од","ui.package-details.more":"Детаљније","ui.package-details.packagist":"Детаљи пакета","ui.package-details.metadata":"Уреди мета податке","ui.package-details.support_docs":"Документација","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Форум за подршку","ui.package-details.support_issues":"Пријава проблема/Баг","ui.package-details.support_source":"Изворни код","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Имејл подршке","ui.package-details.support_rss":"RSS сажетак"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[851],{6851:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Connessione non sicura !!","ui.app.httpsDescription":"Senza protocollo HTTPS i tuoi dati riservati saranno trasferiti in chiaro.","ui.app.httpsLink":"Maggiori informazioni","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode abilitato!!","ui.app.safeModeDescription":"Alcune funzionalità di Contao Manager non sono disponibili.","ui.app.safeModeExit":"Esci da Safe Mode","ui.app.limitedHeadline":"Autenticazione remota","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Caricamento Contao Manager ....","ui.app.apiError":"Stato API inaspettato","ui.app.configSecurity1":"ALLARME DI SICUREZZA! La cartella di configurazione non è protetta","ui.app.configSecurity2":"Contao Manager ha rilevato che i tuoi file di configurazione sono accessibili al pubblico. Tutte le operazioni sono disabilitate fino a quando la cartella non viene protetta e messa in sicurezza, altrimenti un malintenzionato potrebbe accedere ai dati sensibili della tua installazione.\\n\\nPer risolvere questo problema, assicurati di impedire l\'accesso alla cartella \\"contao-manager\\" sul tuo server. Per sapere come farlo, fai riferimento al manuale del tuo webserver o contatta il tuo fornitore di hosting.","ui.account.welcome":"Benvenuto","ui.account.intro1":"Benvenuto in Contao Manager, uno strumento universale per installare e gestire CMS Open Source di Contao 4. Se sei nuovo, per favore {leggiTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} per iniziare","ui.account.introManual":"leggi il manuale","ui.account.intro2":"In caso di problemi, controlla {ourGithubIssues}. Nel caso sentiti libero di creare un nuovo problema per tutto ciò che non è stato ancora segnalato.","ui.account.introIssues":"segnalazioni in GitHub","ui.account.headline":"Account utente","ui.account.description":"Per gestire l\'installazione, crea un account specifico per Contao Manager. Tieni presente che questo account non è correlato al back end o al front end di Contao.","ui.account.username":"Nome utente","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 caratteri","ui.account.passwordLength":"Inserisci almeno 8 caratteri.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Crea account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao e il Contao Manager sono sponsorizzati dalla Contao Association senza scopo di lucro.","ui.account.contribute2":"Si prega di considerare di contribuire all\'open source con {donate}.","ui.account.contributeDonate":"Fare una donazione","ui.login.headline":"Registrati","ui.login.description":"Accedi per gestire la tua installazione","ui.login.username":"Nome utente","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Password dimenticata?","ui.login.button":"Registrati","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annulla","ui.login.or":"oppure","ui.login.locked":"L\'accesso è stato negato perché il Contao Manager è bloccato. Per sbloccare, cancella il file {lockFile} nella directory principale di Contao.","ui.logout.headline":"Timeout sessione","ui.logout.warning":"Sei stato inattivo per più di 25 minuti. Per motivi di sicurezza, la sessione verrà chiusa a breve.","ui.logout.expired":"La sessione è stata chiusa automaticamente perché sei stato inattivo per più di 30 minuti.","ui.logout.renew":"Mantieni il login","ui.logout.logout":"Logout","ui.logout.login":"Torna al login","ui.oauth.error":"Tentativo di OAuth non valido. Controllare i parametri della richiesta.","ui.oauth.https":"L\'URI di reindirizzamento DEVE usare un protocollo sicuro (https:) per evitare che il token di autenticazione sia trasmesso in chiaro.","ui.oauth.headline":"Autenticazione remota","ui.oauth.description":"La seguente applicazione o servizio richiede l\'accesso remoto all\'istanza di Contao Manager.","ui.oauth.domain":"Prima di permettere l\'accesso, assicurati di conoscere questo URL e di fidarti del suo proprietario!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Consenti accesso","ui.oauth.deny":"Accesso negato","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Verifica del sistema","ui.boot.description":"Per favore attendi, stiamo analizzando il tuo server...","ui.boot.issue1":"Problemi di installazione rilevati","ui.boot.issue2":"L\'installazione presenta problemi che devono essere risolti prima di poter utilizzare Contao Manager.","ui.boot.run":"Avvia Contao Manager","ui.boot.safeMode":"Avvio in modalità sicura","ui.recovery.headline":"Sistema di recupero","ui.recovery.description":"Contao Manager ha rilevato file che assomigliano a Contao, ma l\'interfaccia della riga di comando non funziona come previsto.","ui.recovery.console":"Uscita console","ui.recovery.repairOptions":"Scegliere un\'opzione per riparare l\'installazione.","ui.recovery.repairHeadline":"Riparazione automatica","ui.recovery.repairDescription":"Tentativi di riparare automaticamente l\'installazione ricostruendo la cache dell\'applicazione e reinstallando i pacchetti Composer.","ui.recovery.repairWarning":"Qualsiasi modifica ai file del fornitore potrebbe essere cancellata durante il processo!","ui.recovery.repairFailed":"La riparazione automatica non ha avuto successo. Provare la modalità provvisoria per riparare manualmente l\'installazione.","ui.recovery.repairButton":"Esegui la riparazione del sistema","ui.recovery.safeModeHeadline":"Modalità Sicura","ui.recovery.safeModeDescription":"L\'avvio di Contao Manager in modalità provvisoria consente di gestire i pacchetti ed eseguire alcune operazioni di manutenzione, ma le funzioni che si basano su un\'installazione di Contao funzionante non saranno disponibili.","ui.recovery.safeModeButton":"Avvio in modalità sicura","ui.server.pending":"In attesa ...","ui.server.running":"Analizzando ...","ui.server.error":"Verifica non riuscita a causa di una risposta imprevista dal server.","ui.server.details":"Dettagli","ui.server.prerequisite":"Verifica annullata a causa di un prerequisito mancante.","ui.server.selfUpdate.title":"Aggiornamenti di Contao Manager","ui.server.selfUpdate.update":"È disponibile una nuova versione, la {latest} di Contao Manager.","ui.server.selfUpdate.manualUpdate":"È disponibile una nuova versione di Contao Manager {latest}. Il tuo server non supporta gli aggiornamenti automatici, scarica la nuova versione da {download}.","ui.server.selfUpdate.latest":"Stai usando l\'ultima versione disponibile {current}.","ui.server.selfUpdate.dev":"Il build di sviluppo non supportano gli aggiornamenti automatici.","ui.server.selfUpdate.unsupported":"Una nuova versione è disponibile ma non supporta la versione di PHP.","ui.server.selfUpdate.button":"Eseguire l\'auto-aggiornamento","ui.server.selfUpdate.continue":"Continuare","ui.server.config.title":"Configurazione del server","ui.server.config.setup":"Configura","ui.server.config.change":"Cambiamento","ui.server.config.save":"Salva","ui.server.config.cancel":"Annulla","ui.server.config.customOption":"Altri ...","ui.server.config.description":"Per eseguire correttamente le attività in background, Contao Manager deve sapere dove trovare il binario della riga di comando PHP e come eseguire i comandi separati dal processo web.","ui.server.config.formTitle":"Configurazione del server","ui.server.config.formText":"Inserisci il percorso del file binario PHP. Assicurati che il file binario PHP sia la stessa versione del processo del web server.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud consente di installare le dipendenze di Composer anche se il server non fornisce memoria locale sufficiente. Si noti che le informazioni del pacchetto verranno trasmesse a un server cloud gestito dalla Contao Association.","ui.server.config.cloud":"Utilizza Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"Nessun binario PHP valido è stato trovato sul server.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud  non è supportato.","ui.server.config.stateSuccess":"Binario PHP in {php_cli}.","ui.server.config.cloudEnabled":"Package dependencies will be resolved using the Composer Resolver Cloud.","ui.server.config.cloudDisabled":"The Composer Resolver Cloud is disabled.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Trovata la versione di PHP {version}. Si prega di passare a PHP 7 il più presto possibile!","ui.server.php_web.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.php_cli.title":"Interfaccia a riga di comando PHP","ui.server.php_cli.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Non sono stati trovati problemi noti.","ui.server.composer.install":"Le dipendenze del Composer non sono installate.","ui.server.composer.button":"Installa","ui.server.contao.title":"Installazione Contao","ui.server.contao.setup":"Setup","ui.server.contao.check":"Verifica il database","ui.server.contao.empty":"Non è stata trovata alcuna installazione di Contao.","ui.server.contao.old":"La versione {version} di Contao non è compatibile con Contao Manager, aggiorna manualmente l\'installazione.","ui.server.contao.found":"Trovato Contao {version} (versione API {api}).","ui.server.contao.connectionError":"Impossibile connettersi al server del database.","ui.server.contao.connectionProblem":"È stato trovato problema con il database.","ui.server.contao.missingUser":"Account amministratore non trovato.","ui.setup.continue":"Continuare","ui.setup.manager":"Avvia Contao Manager","ui.setup.cancel":"Annulla","ui.setup.welcome":"Benvenuto","ui.setup.welcome1":"Questa procedura guidata ti guiderà attraverso i passaggi necessari per configurare l\'installazione del tuo Contao CMS Open Source.","ui.setup.welcome2":"In caso di domande, puoi consultare la documentazione, forum, un canale Slack e altro nella pagina {support}.","ui.setup.support":"Supporto dalla comunità","ui.setup.start":"Iniziamo","ui.setup.complete":"Congratulazioni!","ui.setup.complete1":"Contao {version} è stato installato correttamente.","ui.setup.complete2":"Per completare il processo d\'installazione, apri lo strumento di installazione per configurare la connessione al database e creare un utente back-end.","ui.setup.complete3":"Ora puoi iniziare a creare il tuo sito web nel back-end di Contao. Se hai bisogno di ulteriori estensioni, vai su Contao Manager.","ui.setup.installTool":"Apri l\'Install Tool","ui.setup.login":"Effettua il login in Contao","ui.setup.funding":"Il software libero è \\"libero\\" come in \\"libertà di parola\\", non come in \\"birra gratis\\". Un progetto Open Source come Contao richiede somme di denaro che non possono essere raccolte da una singola persona o azienda.\\nSe hai un sito web o vendi siti web realizzati con Contao, ci piacerebbe vederti contribuire finanziariamente al prodotto su cui fa affidamento la tua attività.","ui.setup.fundingLink":"Scopri di più","ui.setup.document-root.headline":"Setup Webserver ","ui.setup.document-root.warning":"Per installare Contao tramite Contao Manager, è necessario correggere la document root sul server Web.","ui.setup.document-root.description1":"Contao utilizza una cartella separata per i file pubblici, i file dell\'applicazione vengono installati nella sua cartella principale. Contao non può essere installato se la struttura delle cartelle non è corretta o le cartelle non sono vuote.","ui.setup.document-root.description2":"Se non sai come configurare la document root, leggi la documentazione Contao o contatta il tuo provider di hosting.","ui.setup.document-root.documentation":"Leggi la documentazione","ui.setup.document-root.conflictsTitle":"La directory di installazione non è vuota","ui.setup.document-root.conflictsDirectory":"La directory principale della tua futura installazione di Contao non è vuota, abbiamo trovato {count} files che potrebbero essere sovrascritti dal processo di installazione. Si consiglia di creare una struttura di directory vuota per Contao, ma puoi anche rimuovere i seguenti file e ricontrollare se sei sicuro che non siano utilizzati.","ui.setup.document-root.ignoreConflicts":"Voglio installare Contao nella directory non vuota. Capisco che questo potrebbe sovrascrivere qualsiasi file esistente sul mio spazio web.","ui.setup.document-root.check":"Controlla nuovamente","ui.setup.document-root.create":"Creare elenchi","ui.setup.document-root.change":"Cambia directory","ui.setup.document-root.formTitle":"Setup cartella","ui.setup.document-root.formText1":"Contao Manager può creare automaticamente una nuova struttura di directory sul server.","ui.setup.document-root.formText2":"Dovrai configurare manualmente la nuova root document (ad es. Tramite un pannello di amministrazione di hosting).","ui.setup.document-root.autoconfig":"Comprendo che devo modificare la configurazione del mio server. La mancata configurazione della document root  interromperà Contao Manager ed esporrà i file di configurazione (inclusi i dettagli dell\'account e le password)!","ui.setup.document-root.directory":"Nuova directory","ui.setup.document-root.currentRoot":"Document root corrente","ui.setup.document-root.newRoot":"Nuova document root","ui.setup.document-root.finish":"Cartella di installazione","ui.setup.document-root.publicDir":"Usare {dir} per i file pubblici (per Contao {versione})","ui.setup.document-root.directoryInvalid":"Inserisci un nome di directory valido.","ui.setup.document-root.directoryExists":"La cartella di destinazione esiste già. Per favore, inserisci un nome diverso.","ui.setup.document-root.confirmation":"Contao Manager ha creato correttamente la cartella necessaria per l\'installazione di Contao. Ora devi configurare la radice del documento sul tuo server web. Non ricaricare questa pagina fino ad allora.","ui.setup.document-root.reload":"Ricarica pagina","ui.setup.document-root.success":"La struttura delle directory sul tuo server web è impostata correttamente!","ui.setup.document-root.installingProjectDir":"I file dell\'applicazione verranno installati in {dir}.","ui.setup.document-root.installingPublicDir":"I file pubblici verranno installati in {dir}.","ui.setup.document-root.installedProjectDir":"I file dell\'applicazione vengono installati in {dir}.","ui.setup.document-root.installedPublicDir":"I file pubblici vengono installati in {dir}.","ui.setup.create-project.headline":"Installazione Contao","ui.setup.create-project.description":"Lo sviluppo di Contao segue il principio di {semver}, una nuova versione minore viene rilasciata ogni sei mesi. Le versioni attualmente supportate sono:","ui.setup.create-project.semver":"Versione semantica","ui.setup.create-project.latestTitle":"Più recente","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino a febbraio {anno}.","ui.setup.create-project.latestQ3":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino ad agosto {year}.","ui.setup.create-project.ltsText":"La nostra attuale versione LTS, è focalizzata al mantenimento della stabilità. Offre supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.pltsText":"La precedente versione LTS ha ancora il supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.requiresPHP":"Richiede almeno PHP {version}, tu hai PHP {current}.","ui.setup.create-project.releaseplan":"Vedi {contaoReleasePlan} per informazioni dettagliate.","ui.setup.create-project.releaseplanLink":"Piano di rilascio Contao","ui.setup.create-project.installed":"Contao  {version}  è stato installato correttamente sul server. Continua a configurare il tuo database o avvia Contao Manager per installare una versione diversa.","ui.setup.create-project.formTitle":"Seleziona una distribuzione","ui.setup.create-project.formText":"Scegliere quale versione deve essere installata.","ui.setup.create-project.version":"Versione","ui.setup.create-project.demo":"Installa il sito Web demo di Contao","ui.setup.create-project.demoDescription":"Il sito Web demo ti aiuta a familiarizzare con Contao e tutte le sue funzionalità principali. Altri temi possono essere trovati in {store}.","ui.setup.create-project.coreOnly":"Installazione minima (solo core)","ui.setup.create-project.noUpdate":"Salta l\'installazione (soltanto per esperti!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"Per installare un tema Contao, utilizza l\'input di ricerca o carica un file del tema (.cto/.zip) che supporti l\'installazione tramite Contao Manager.","ui.setup.create-project.themeBuy":"Assicurati di visitare lo {store} ufficiale.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"Il file caricato non è un tema Contao o non supporta Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager non è in grado di stabilire se questo tema è compatibile con il tuo server. Per eventuali domande, contatta il fornitore del tema.","ui.setup.create-project.themeTitle":"Esamina i dettagli del tema","ui.setup.create-project.themeDetails":"Con questo tema verranno installati le seguenti dipendenze e file.","ui.setup.create-project.themeRequire":"{count} Dipendenze | {count} Dipendenze","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"oppure cerca dei temi pubblici","ui.setup.create-project.theme.search":"Cerca un tema","ui.setup.create-project.theme.more":"Più temi","ui.setup.create-project.theme.empty":"Nessun tema corrispondente {query}","ui.setup.create-project.theme.uploaded":"Il file del tema è stato caricato correttamente.","ui.setup.create-project.theme.packageName":"Nome Package","ui.setup.create-project.theme.version":"Versione","ui.setup.create-project.theme.authors":"Autore/i","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Installa","ui.setup.create-project.cancel":"Annulla","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Connessione al database","ui.setup.database-connection.description":"Contao richiede un database MySQL (o un fork compatibile come MariaDB) per memorizzare pagine, contenuti, utenti e altri dati relazionali. I parametri di connessione sono memorizzati nel file {env} nella radice del progetto dell\'installazione di Contao.","ui.setup.database-connection.formTitle":"Parametri connessione","ui.setup.database-connection.formText":"Immettere l\'URL di un database o compilare separatamente i campi nome utente, password, server e database.","ui.setup.database-connection.url":"URL Database","ui.setup.database-connection.validUrl":"URL Database non valido o connessione al server fallita.","ui.setup.database-connection.or":"oppure","ui.setup.database-connection.user":"Nome utente","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Nome del database","ui.setup.database-connection.connected":"Connessione riuscita al database {database} sul {server}.","ui.setup.database-connection.error":"Errore di connessione al database","ui.setup.database-connection.problem":"Contao ha rilevato un problema con il database server.","ui.setup.database-connection.schemaTitle":"Schema Database ","ui.setup.database-connection.migration":"C\'è una migrazione in sospeso. | Ci sono {count} migrazioni in sospeso.","ui.setup.database-connection.schema":"È presente un aggiornamento dello schema in sospeso. | Ci sono {count} aggiornamenti dello schema in sospeso.","ui.setup.database-connection.noChanges":"Lo schema del database è aggiornato.","ui.setup.database-connection.check":"Verifica il database","ui.setup.database-connection.skip":"Salta","ui.setup.database-connection.save":"Salva","ui.setup.database-connection.change":"Modifica le credenziali","ui.setup.database-connection.restoreTitle":"Importazione del database","ui.setup.database-connection.restoreText":"Il tema che hai appena installato contiene un backup del database. Ripristina il database per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao. | Il tema che hai appena installato contiene più backup di database. Seleziona un file di backup per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao.","ui.setup.database-connection.backup":"Eseguire il backup del database corrente prima dell\'importazione","ui.setup.database-connection.backupWarning":"Tutti i dati nel database verranno sovrascritti durante l\'importazione! Creare prima un backup se il database non è vuoto.","ui.setup.database-connection.restore":"Importa il database dei temi","ui.setup.database-connection.restoreOption":"Backup del {date} ({size})","ui.setup.database-connection.restored":"Il database del tuo tema è stato importato con successo. Continua con la convalida dello schema del database.","ui.setup.backend-user.success":"Nel tuo database è stato trovato un account amministratore per il back-end Contao. Usa il back-end Contao per aggiungere più utenti.","ui.setup.backend-user.error":"Impossibile recuperare l\'elenco degli utenti. Controlla l\'output della console per i dettagli.","ui.setup.backend-user.headline":"Utente di backend ","ui.setup.backend-user.description":"Per gestire il tuo sito web, devi avere almeno un account amministratore per il back-end di Contao. Tieni presente che questo account non è correlato a Contao Manager.","ui.setup.backend-user.formTitle":"Crea account","ui.setup.backend-user.formText":"Inserisci i dettagli per il nuovo account back-end.","ui.setup.backend-user.username":"Nome utente","ui.setup.backend-user.name":"Nome","ui.setup.backend-user.email":"Indirizzo e-mail","ui.setup.backend-user.emailInvalid":"Inserisci un indirizzo email valido","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 caratteri","ui.setup.backend-user.passwordLength":"Inserisci almeno 8 caratteri.","ui.setup.backend-user.create":"Aggiungi account","ui.task.headline":"Task in background ","ui.task.loading":"Caricamento dettagli…","ui.task.created":"Caricamento dettagli…","ui.task.active":"Attendere che Contao Manager esegua operazioni in background.","ui.task.complete":"Tutte le operazioni sono state completate correttamente. Controllare l\'output della console per i dettagli.","ui.task.paused":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.aborting":"Attendi mentre le operazioni in background vengono annullate.","ui.task.stopped":"Alcune operazioni in background sono state annullate. Controlla l\'output della console.","ui.task.error":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.failed":"Il Contao Manager non è riuscito ad avviare un\'attività in background!","ui.task.failedDescription1":"Qualcosa è andato storto durante il tentativo di eseguire operazioni in background.","ui.task.failedDescription2":"In questo caso, il tuo server potrebbe non essere supportato.","ui.task.reportProblem":"Segnala un problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorizzato da {sponsor}","ui.task.buttonAudit":"Aggiorna il database","ui.task.buttonClose":"Chiudi","ui.task.buttonConfirm":"Conferma e chiudi","ui.task.buttonContinue":"Continuare","ui.task.buttonCancel":"Annulla","ui.task.confirmCancel":"Sei sicuro di annullare questo compito? Questo potrebbe lasciare l\'installazione di Contao in uno stato danneggiato!","ui.task.autoclose":"Chiudi i dettagli dell\'attività in caso di successo","ui.console.toggle":"Visualizza/nasconde l\'uscita console","ui.console.showLog":"Mostra il registro completo della console","ui.console.copyLog":"Copia il registro negli appunti","ui.migrate.headline":"Aggiornamenti del database","ui.migrate.migrationsOnly":"(solo migrazioni)","ui.migrate.schemaOnly":"(solo schema)","ui.migrate.loading":"Attendi, stiamo controllando il database...","ui.migrate.empty":"Non è stato trovato nessuna migrazione in sospeso o aggiornamento dello schema. Il tuo database è aggiornato.","ui.migrate.emptyMigrations":"Non è stata trovata nessuna migrazione in sospeso. Controlla anche gli aggiornamenti dello schema.","ui.migrate.emptySchema":"Non è stato trovato nessun aggiornamento dello schema in sospeso. Assicurati di controllare anche le migrazioni.","ui.migrate.pending":"Il tuo database non è aggiornato. Si prega di rivedere l\'output della console di seguito ed eseguire le modifiche.","ui.migrate.previousChanges":"Una precedente migrazione del database non è stata confermata.\\nRivedi l\'output della console di seguito, quindi continua per vedere le modifiche successive.","ui.migrate.previousComplete":"Una precedente migrazione del database non è stata confermata, controlla l\'output della console di seguito.\\nNon ci sono più modifiche in sospeso.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Gli aggiornamenti del database sono stati applicati.\\nNon ci sono più migrazioni in sospeso o aggiornamenti dello schema. Il tuo database è aggiornato.","ui.migrate.problem":"Contao ha rilevato un problema con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto. | Contao ha rilevato problemi con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto.","ui.migrate.warning":"Contao ha rilevato una configurazione errata del database server.\\nGli avvisi possono essere ignorati temporaneamente, ma dovrebbero essere corretti per prestazioni e integrità dei dati ottimali.","ui.migrate.error":"Impossibile applicare le modifiche. Il tuo database potrebbe essere stato modificato, controlla di nuovo per riprovare.","ui.migrate.execute":"Esegui","ui.migrate.close":"Chiudi","ui.migrate.confirm":"Conferma e chiudi","ui.migrate.cancel":"Annulla","ui.migrate.continue":"Continuare","ui.migrate.setup":"Setup","ui.migrate.skip":"Salta","ui.migrate.retry":"Controlla nuovamente","ui.migrate.retryAll":"Seleziona tutto","ui.migrate.withDeletes":"Esegui tutte le modifiche al database comprese le query DROP.","ui.migrate.migrationTitle":"Migrazioni del database","ui.migrate.schemaTitle":"Aggiornamenti dello schema","ui.migrate.problemTitle":"Problemi al database","ui.migrate.warningTitle":"Avvisi sul database","ui.migrate.addTable":"Aggiungi tabella {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Aggiungi campo {table}.{field}","ui.migrate.changeField":"Cambia campo  {table}.{field}","ui.migrate.dropField":"Elimina campo {table}.{field}","ui.migrate.createIndex":"Crea indice \\"{name}\\" in {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" in {table}","ui.widget.mandatory":"Questo campo non deve essere vuoto.","ui.widget.blankOption":"Selezionare ...","ui.widget.showPassword":"Mostra password","ui.widget.hidePassword":"Nascondi password","ui.error.title":"Richiesta HTTP per \\"{metodo} {url}\\" fallita.","ui.error.server500":"Sembra che si sia verificato un errore imprevisto sul server. Controllare i file di log del proprio server web (Apache/Nginx) e i log di Contao Manager in \\"contao-manager/logs\\".","ui.error.response":"Il server ha restituito una risposta con il codice di stato {status}.","ui.error.moreLink":"Maggiori informazioni","ui.error.support":"Supporto Contao ","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Supporto","ui.footer.reportProblem":"Segnala un problema","ui.navigation.discover":"Scopri","ui.navigation.packages":"Pacchetti","ui.navigation.tools":"Strumenti","ui.navigation.installTool":"Strumento di installazione","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Modalità Debug Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informazioni PHP","ui.navigation.phpinfoLoading":"Caricamento informazioni PHP","ui.navigation.maintenance":"Manutenzione","ui.navigation.rebuildCache":"Ricostruisci la cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Verifica del sistema","ui.navigation.advanced":"Avanzato","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations e Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"Una migrazione del database in sospeso | {count} migrazioni database in sospeso","ui.maintenance.database.schemaUpdates":"Un aggiornamento dello schema in sospeso | {count} aggiornamenti dello schema in attesa","ui.maintenance.database.error":"È stato trovato problema con il database.","ui.maintenance.database.warning":"Sono stati trovati degli avvisi del database","ui.maintenance.database.button":"Verifica il database","ui.maintenance.database.migrationOnly":"Controlla solo le migrazioni","ui.maintenance.database.schemaOnly":"Controlla solo lo schema","ui.maintenance.database.installTool":"Apri l\'Install Tool","ui.maintenance.database.createBackup":"Creare il backup","ui.maintenance.database.backupUnsupported":"I backup del database non sono supportati dalla tua versione di Contao.","ui.maintenance.database.backupList":"Hai un backup del database, creato il {date}. | Hai {count} backup del database, l\'ultimo è stato creato il {date}.","ui.maintenance.database.backupEmpty":"Al momento non hai backup del database.","ui.maintenance.rebuildCache.title":"Cache applicazione ","ui.maintenance.rebuildCache.description":"La ricostruzione della cache dell\'applicazione è necessaria dopo aver modificato uno qualsiasi dei file di configurazione.","ui.maintenance.rebuildCache.rebuildProd":"Ricostruire la cache di produzione","ui.maintenance.rebuildCache.rebuildDev":"Ricostruire la cache di sviluppo","ui.maintenance.rebuildCache.clearProd":"Cancella cache di produzione","ui.maintenance.rebuildCache.clearDev":"Cancella cache di sviluppo","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"Lo strumento di installazione Contao viene bloccato automaticamente se si immette una password errata per tre volte di seguito.","ui.maintenance.installTool.unlock":"Sblocca Install Tool","ui.maintenance.installTool.lock":"Blocca Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Il Composer autoloader è responsabile del caricamento della classe PHP. L\'autoloader deve essere scaricato solo dopo aver aggiunto i namespaces personalizzati nella root del composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dipendenze Composer","ui.maintenance.composerInstall.description":"Le dipendenze del Composer si trovano nella cartella {vendor} nella radice dell\'applicazione. La reinstallazione delle dipendenze può essere necessaria dopo la modifica o il caricamento manuale del file {composerLock}.","ui.maintenance.composerInstall.button":"Esegui Installer","ui.maintenance.composerInstall.update":"Esegui l\'aggiornamento Composer","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer mette in cache i pacchetti scaricati per migliorare le prestazioni. Se hai problemi con i file rotti, prova a cancellare la cache del Composer per forzare un nuovo download.","ui.maintenance.composerCache.button":"Cancella cache","ui.maintenance.maintenanceMode.title":"Modalità di manutenzione","ui.maintenance.maintenanceMode.description":"Mettendo Contao in modalità manutenzione, verrà visualizzato un modello \\"503 Service Unavailable\\" per il sito web.","ui.maintenance.maintenanceMode.enable":"Attiva","ui.maintenance.maintenanceMode.disable":"Disattiva","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Attiva la modalità debug impostando un utente e una password per il punto di ingresso {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Attiva la modalità debug impostando il cookie di debug per il dominio corrente.","ui.maintenance.debugMode.activate":"Attivare","ui.maintenance.debugMode.deactivate":"Disattiva","ui.maintenance.debugMode.credentials":"Credenziali","ui.maintenance.debugMode.user":"Inserisci un nome utente per la modalità di debug.","ui.maintenance.debugMode.password":"Inserisci una password per la modalità di debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode mette in cache i file PHP sul processo web per un\'esecuzione più veloce. Deve essere cancellato in determinate circostanze se i file non vengono riconosciuti dopo la modifica.","ui.maintenance.opcodeCache.button":"Troncare la cache","ui.maintenance.safeMode":"Non disponibile in modalità Safe Mode","ui.maintenance.unsupported":"Non supportato dalla tua versione di Contao","ui.packages.updateButton":"Aggiorna pacchetti","ui.packages.searchButton":"Cerca pacchetti","ui.packages.searchPlaceholder":"Cerca pacchetti...","ui.packages.uploadOverlay":"Drag & drop files per caricarli","ui.packages.uploadButton":"Carica pacchetti","ui.packages.uploadMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.uploadApply":"Conferma uploads","ui.packages.uploadReset":"Elimina Uploads","ui.packages.uploadIncomplete":"Questo file non è stato caricato completamente. Rimuovilo e riprova.","ui.packages.uploadDuplicate":"Questo file sembra essere caricato più volte. Rimuovi i duplicati.","ui.packages.uploadInstalled":"Questo file è già installato. Rimuovi i duplicati.","ui.packages.uploadUnsupported":"I caricamenti non sono supportati nella tua installazione. Assicurati che l\'estensione PHP ZIP sia installata e aggiorna le dipendenze.","ui.packages.changesMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.changesDryrun":"Esecuzione a prova","ui.packages.changesApply":"Applicare le modifiche","ui.packages.changesApplyAll":"Aggiornare tutti i pacchetti","ui.packages.changesDryrunAll":"Esecuzione a prova di tutti i pacchetti","ui.packages.changesReset":"Ripristina modifiche","ui.packages.changesReview":"Revisione dei cambiamenti","ui.packagelist.loading":"Caricamento in corso ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Pacchetti nuovi","ui.packagelist.installed":"Pacchetti installati","ui.package.hintRevert":"Ripristina le modifiche","ui.package.hintNoupdate":"Non aggiornare","ui.package.hintConstraint":"Questo pacchetto sarà installato con vincolo {constraint} quando si applicano le modifiche.","ui.package.hintConstraintBest":"Questo pacchetto sarà installato nella migliore versione disponibile quando si applicano le modifiche.","ui.package.hintConstraintChange":"Il vincolo per questo pacchetto sarà cambiato da \\"{from}\\" a \\"{to}\\" quando si applicano le modifiche.","ui.package.hintConstraintUpdate":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintAdded":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintRemoved":"Questo pacchetto verrà rimosso quando si applicano le modifiche. ","ui.package.requiredTitle":"aggiunto manualmente","ui.package.requiredText":"Questo pacchetto è richiesto nel tuo composer.json ma non è installato.","ui.package.removedTitle":"rimosso manualmente","ui.package.removedText":"Questo pacchetto è stato rimosso dal tuo composer.json.","ui.package.installed":"Attualmente installato:","ui.package.version":"Versione {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stella | {count} Stelle","ui.package.editConstraint":"Modifica","ui.package.uploadConstraint":"Questo vincolo è definito dal pacchetto caricato.","ui.package.updateButton":"Aggiorna","ui.package.removeButton":"Rimuovi","ui.package.installButton":"Aggiungi pacchetto","ui.package.installButtonShort":"Aggiungi","ui.package.detailsButton":"Dettagli","ui.package.latestConstraint":"ultima versione","ui.package.update":"Aggiornamento disponibile","ui.package.updateLatest":"ultima versione","ui.package.updateAvailable":"{versione} disponibile","ui.package.updateUnknown":"versione sconosciuta","ui.package.updateConstraint":"È disponibile una versione più recente al di fuori del vincolo di versione.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.package.incompatibleWarning":"{package} does not work with Contao {constraint} in any of its stable releases. Do you want to add the package and set a version constraint to try installing a development branch?","ui.package.incompatibleConstraint":"This package does not have a stable release for Contao {constraint}. Set a version constraint to try installing a development branch.","ui.package.incompatibleButton":"Installa","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versione {version}","ui.cloudStatus.waitingTime":"Tempo di attesa","ui.cloudStatus.jobs":"Lavori correnti","ui.cloudStatus.workers":"Lavoratori","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nessuna","ui.cloudStatus.short":"circa {minutes} min","ui.cloudStatus.long":"circa {minutes} min {seconds} sec","ui.cloudStatus.error":"Impossibile ottenere lo stato del Composer Resolver Cloud. Potrebbe essere inattivo per problemi di manutenzione o di esercizio.","ui.cloudStatus.button":"Stato Cloud","ui.cloudStatus.refresh":"Aggiorna lo stato del cloud","ui.log-viewer.loading":"Caricamento in corso ...","ui.log-viewer.empty":"Non ci sono file di registro sul tuo server.","ui.log-viewer.reload":"Ricarica","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Canale","ui.log-viewer.channelTitle":"Il canale su cui è stato registrato questo messaggio.","ui.log-viewer.level":"Livello","ui.log-viewer.levelTitle":"Gravità del messaggio di log.","ui.log-viewer.timeHeader":"Tempo","ui.log-viewer.messageHeader":"Messaggio","ui.log-viewer.showContext":"Mostra contesto","ui.log-viewer.hideContext":"Nascondi contesto","ui.log-viewer.showExtra":"Mostra extra","ui.log-viewer.hideExtra":"Nascondi extra","ui.log-viewer.more":"Carica di più…","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Ambiente di produzione","ui.log-viewer.devEnvironment":"Ambiente di sviluppo (Modalità Debug)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 caratteri","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annulla","ui.user-manager.close":"Chiudi","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Attiva","ui.totp.disable":"Disattiva","ui.totp.cancel":"Annulla","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[335],{1035:function(e,s,c){c.r(s),c.d(s,{default:function(){return V}});var i=c(641),l=c(33),o=c(3751),t=c.p+"img/server-config.1a2d0888.svg";const n={class:"config-check__header"},r={class:"config-check__headline"},a={class:"config-check__description"},d={class:"config-check__form"},u={class:"config-check__fields"},g={class:"config-check__fieldtitle"},h={class:"config-check__fielddesc"},f={class:"config-check__fields"},_={class:"config-check__fieldtitle"},p={class:"config-check__fielddesc"},k={key:0,class:"config-check__issues"},v=["disabled"];function b(e,s,c,b,m,L){const $=(0,i.g2)("text-field"),w=(0,i.g2)("check-box"),C=(0,i.g2)("loading-button"),x=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(x,{wide:!0,slotClass:"config-check"},{default:(0,i.k6)(()=>[(0,i.Lk)("header",n,[s[4]||(s[4]=(0,i.Lk)("img",{src:t,width:"80",height:"80",class:"config-check__icon",alt:""},null,-1)),(0,i.Lk)("h1",r,(0,l.v_)(e.$t("ui.server.config.title")),1),(0,i.Lk)("p",a,(0,l.v_)(e.$t("ui.server.config.description")),1)]),(0,i.Lk)("main",d,[(0,i.Lk)("form",{onSubmit:s[3]||(s[3]=(0,o.D$)((...e)=>L.save&&L.save(...e),["prevent"]))},[(0,i.Lk)("fieldset",u,[(0,i.Lk)("legend",g,(0,l.v_)(e.$t("ui.server.config.formTitle")),1),(0,i.Lk)("p",h,(0,l.v_)(e.$t("ui.server.config.formText")),1),(0,i.bF)($,{ref:"cli",name:"php_cli",label:e.$t("ui.server.config.cli"),required:"",disabled:e.processing,error:e.error,modelValue:e.php_cli,"onUpdate:modelValue":s[0]||(s[0]=s=>e.php_cli=s)},null,8,["label","disabled","error","modelValue"])]),(0,i.Lk)("fieldset",f,[(0,i.Lk)("legend",_,(0,l.v_)(e.$t("ui.server.config.cloudTitle")),1),(0,i.Lk)("p",p,(0,l.v_)(e.$t("ui.server.config.cloudText")),1),e.cloudIssues&&e.cloudIssues.length?((0,i.uX)(),(0,i.CE)("div",k,[(0,i.Lk)("p",null,(0,l.v_)(e.$t("ui.server.config.stateErrorCloud")),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.cloudIssues,(e,s)=>((0,i.uX)(),(0,i.CE)("li",{key:s},(0,l.v_)(e),1))),128))])])):(0,i.Q3)("",!0),(0,i.bF)(w,{name:"cloud",label:e.$t("ui.server.config.cloud"),disabled:e.processing,modelValue:e.cloud,"onUpdate:modelValue":s[1]||(s[1]=s=>e.cloud=s)},null,8,["label","disabled","modelValue"])]),(0,i.bF)(C,{submit:"",color:"primary",disabled:!e.php_cli,loading:e.processing},{default:(0,i.k6)(()=>[(0,i.eW)((0,l.v_)(e.$t("ui.server.config.save")),1)]),_:1},8,["disabled","loading"]),(0,i.Lk)("button",{type:"button",class:"widget-button",disabled:e.processing,onClick:s[2]||(s[2]=(...e)=>L.cancel&&L.cancel(...e))},(0,l.v_)(e.$t("ui.server.config.cancel")),9,v)],32)])]),_:1})}var m=c(728),L=c(9757),$=c(3480),w=c(85),C=c(707),x={components:{BoxedLayout:m.A,TextField:L.A,CheckBox:$.A,LoadingButton:w.A},data:()=>({processing:!0,error:"",php_cli:"",cloud:!0,cloudIssues:[]}),methods:{async save(){this.processing=!0,this.error="";const e={php_cli:this.php_cli,cloud:this.cloud},s=await this.$store.dispatch("server/config/set",e);400===s.status&&s.detail?(this.error=s.detail,this.processing=!1,setTimeout(()=>{this.$refs.cli.focus()},0)):window.location.reload(!0)},cancel(){this.$store.commit("setView",C.A.BOOT)}},async mounted(){const e=await this.$store.dispatch("server/config/get");this.php_cli=e.php_cli,this.cloud=e.cloud.enabled,this.cloudIssues=e.cloud.issues,this.processing=!1}},y=c(6262);const T=(0,y.A)(x,[["render",b]]);var V=T}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpac