/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class FileDrop {
    public FileDrop(JComponent c, final Target target2) {
        DropTargetListener listener2 = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent event) {
            }

            @Override
            public void dragOver(DropTargetDragEvent event) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent event) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent event) {
                event.acceptDrop(event.getDropAction());
                List<File> fileList = FileCopyPasteUtil.getFileList(event.getTransferable());
                if (fileList == null) {
                    return;
                }
                ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                for (File file2 : fileList) {
                    VirtualFile vFile = fileSystem.findFileByIoFile(file2);
                    if (vFile == null || !vFile.exists() || !target2.getDescriptor().isFileVisible(vFile, target2.isHiddenShown())) continue;
                    files2.add(vFile);
                }
                if (files2.size() > 0) {
                    target2.dropFiles(files2);
                }
            }
        };
        new DropTarget(c, 3, listener2, true);
    }

    public static interface Target {
        public FileChooserDescriptor getDescriptor();

        public boolean isHiddenShown();

        public void dropFiles(List<VirtualFile> var1);
    }
}

