/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgRelationManager;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.properties.PgRelation;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgRelationManager;", "", "()V", "getDependentObjects", "", "Lcom/intellij/database/model/basic/BasicElement;", "owner", "getOwners", "dependent", "kind", "Lcom/intellij/database/model/ObjectKind;", "isDependsOn", "", "ownerKind", "ArrangedPart", "IdentifiedPart", "RelationPart", "intellij.database.dialects"})
public final class PgRelationManager {
    public static final PgRelationManager INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final boolean isDependsOn(@NotNull BasicElement dependent, @NotNull ObjectKind ownerKind) {
        boolean bl;
        block4: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)dependent, (String)"dependent");
            Intrinsics.checkParameterIsNotNull((Object)ownerKind, (String)"ownerKind");
            BasicDatabase basicDatabase = dependent.getDatabase();
            if (!(basicDatabase instanceof PgDatabase)) {
                basicDatabase = null;
            }
            PgDatabase pgDatabase = (PgDatabase)basicDatabase;
            if (pgDatabase == null) {
                return false;
            }
            PgDatabase database = pgDatabase;
            RelationPart relationPart = RelationPart.Companion.of(dependent);
            if (relationPart == null) {
                return false;
            }
            RelationPart part = relationPart;
            Set<PgRelation> set = database.getRelations();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"database.relations");
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<PgRelation, Boolean>(part){
                final /* synthetic */ RelationPart $part;

                public final boolean invoke(PgRelation relation) {
                    PgRelation pgRelation = relation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgRelation, (String)"relation");
                    return this.$part.isDependentIn(pgRelation);
                }
                {
                    this.$part = relationPart;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                PgRelation relation = (PgRelation)element$iv;
                if (!Intrinsics.areEqual((Object)relation.getOwnerKind(), (Object)ownerKind)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<BasicElement> getDependentObjects(@NotNull BasicElement owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        RelationPart relationPart = RelationPart.Companion.of(owner);
        if (relationPart == null) {
            return CollectionsKt.emptyList();
        }
        RelationPart part = relationPart;
        BasicDatabase basicDatabase = owner.getDatabase();
        if (!(basicDatabase instanceof PgDatabase)) {
            basicDatabase = null;
        }
        PgDatabase pgDatabase = (PgDatabase)basicDatabase;
        if (pgDatabase == null) {
            return CollectionsKt.emptyList();
        }
        PgDatabase database = pgDatabase;
        Set<PgRelation> set = database.getRelations();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"database.relations");
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<PgRelation, Boolean>(part){
            final /* synthetic */ RelationPart $part;

            public final boolean invoke(PgRelation relation) {
                PgRelation pgRelation = relation;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgRelation, (String)"relation");
                return this.$part.isOwnerIn(pgRelation);
            }
            {
                this.$part = relationPart;
                super(1);
            }
        })), (Function1)((Function1)new Function1<PgRelation, BasicIdentifiedElement>(database){
            final /* synthetic */ PgDatabase $database;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final BasicIdentifiedElement invoke(@NotNull PgRelation relation) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
                BasicDatabase basicDatabase = this.$database;
                long objectId$iv = relation.getDependentId();
                BasicIdentifiedElement basicIdentifiedElement = $receiver$iv.findIdentifiedElement(objectId$iv);
                if (!(basicIdentifiedElement instanceof BasicIdentifiedElement)) {
                    basicIdentifiedElement = null;
                }
                return basicIdentifiedElement;
            }
            {
                this.$database = pgDatabase;
                super(1);
            }
        }))));
    }

    @NotNull
    public final List<BasicElement> getOwners(@NotNull BasicElement dependent, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)dependent, (String)"dependent");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        RelationPart relationPart = RelationPart.Companion.of(dependent);
        if (relationPart == null) {
            return CollectionsKt.emptyList();
        }
        RelationPart part = relationPart;
        BasicDatabase basicDatabase = dependent.getDatabase();
        if (!(basicDatabase instanceof PgDatabase)) {
            basicDatabase = null;
        }
        PgDatabase pgDatabase = (PgDatabase)basicDatabase;
        if (pgDatabase == null) {
            return CollectionsKt.emptyList();
        }
        PgDatabase database = pgDatabase;
        Set<PgRelation> set = database.getRelations();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"database.relations");
        Sequence owners2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<PgRelation, Boolean>(part){
            final /* synthetic */ RelationPart $part;

            public final boolean invoke(PgRelation relation) {
                PgRelation pgRelation = relation;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgRelation, (String)"relation");
                return this.$part.isDependentIn(pgRelation);
            }
            {
                this.$part = relationPart;
                super(1);
            }
        })), (Function1)((Function1)new Function1<PgRelation, Boolean>(kind){
            final /* synthetic */ ObjectKind $kind;

            public final boolean invoke(PgRelation relation) {
                return Intrinsics.areEqual((Object)relation.getOwnerKind(), (Object)(Intrinsics.areEqual((Object)this.$kind, (Object)ObjectKind.COLUMN) ? ObjectKind.TABLE : this.$kind));
            }
            {
                this.$kind = objectKind;
                super(1);
            }
        }));
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN) ? SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)owners2, (Function1)getOwners.1.INSTANCE), (Function1)((Function1)new Function1<PgRelation, PgLocalTableColumn>(database){
            final /* synthetic */ PgDatabase $database;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final PgLocalTableColumn invoke(PgRelation it) {
                PgLocalTable table;
                BasicNode basicNode;
                void $receiver$iv;
                BasicDatabase basicDatabase = this.$database;
                long objectId$iv = it.getOwnerId();
                BasicIdentifiedElement basicIdentifiedElement = $receiver$iv.findIdentifiedElement(objectId$iv);
                if (!(basicIdentifiedElement instanceof PgLocalTable)) {
                    basicIdentifiedElement = null;
                }
                return (basicNode = (table = (PgLocalTable)basicIdentifiedElement)) != null && (basicNode = basicNode.getColumns()) != null ? (PgLocalTableColumn)basicNode.getByNaturalPosition((short)it.getOwnerSubId()) : null;
            }
            {
                this.$database = pgDatabase;
                super(1);
            }
        })))) : SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)owners2, (Function1)((Function1)new Function1<PgRelation, BasicIdentifiedElement>(database){
            final /* synthetic */ PgDatabase $database;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final BasicIdentifiedElement invoke(@NotNull PgRelation it) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                BasicDatabase basicDatabase = this.$database;
                long objectId$iv = it.getOwnerId();
                BasicIdentifiedElement basicIdentifiedElement = $receiver$iv.findIdentifiedElement(objectId$iv);
                if (!(basicIdentifiedElement instanceof BasicIdentifiedElement)) {
                    basicIdentifiedElement = null;
                }
                return basicIdentifiedElement;
            }
            {
                this.$database = pgDatabase;
                super(1);
            }
        }))));
    }

    private PgRelationManager() {
    }

    static {
        PgRelationManager pgRelationManager;
        INSTANCE = pgRelationManager = new PgRelationManager();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgRelationManager$RelationPart;", "", "isDependentIn", "", "relation", "Lcom/intellij/database/model/properties/PgRelation;", "isOwnerIn", "Companion", "intellij.database.dialects"})
    public static interface RelationPart {
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean isOwnerIn(@NotNull PgRelation var1);

        public boolean isDependentIn(@NotNull PgRelation var1);

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgRelationManager$RelationPart$Companion;", "", "()V", "of", "Lcom/intellij/database/dialects/postgres/model/PgRelationManager$RelationPart;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.dialects"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @Nullable
            public final RelationPart of(@NotNull BasicElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                BasicElement basicElement = element2;
                return basicElement instanceof PgTableColumn ? (RelationPart)new ArrangedPart((BasicArrangedElement)element2) : (basicElement instanceof BasicIdentifiedElement ? (RelationPart)new IdentifiedPart((BasicIdentifiedElement)element2) : null);
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgRelationManager$IdentifiedPart;", "Lcom/intellij/database/dialects/postgres/model/PgRelationManager$RelationPart;", "element", "Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "(Lcom/intellij/database/model/basic/BasicIdentifiedElement;)V", "isDependentIn", "", "relation", "Lcom/intellij/database/model/properties/PgRelation;", "isOwnerIn", "intellij.database.dialects"})
    private static final class IdentifiedPart
    implements RelationPart {
        private final BasicIdentifiedElement element;

        @Override
        public boolean isOwnerIn(@NotNull PgRelation relation) {
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            return Intrinsics.areEqual((Object)relation.getOwnerKind(), (Object)this.element.getKind()) && relation.getOwnerId() == this.element.getObjectId();
        }

        @Override
        public boolean isDependentIn(@NotNull PgRelation relation) {
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            return Intrinsics.areEqual((Object)relation.getDependentKind(), (Object)this.element.getKind()) && relation.getDependentId() == this.element.getObjectId();
        }

        public IdentifiedPart(@NotNull BasicIdentifiedElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.element = element2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgRelationManager$ArrangedPart;", "Lcom/intellij/database/dialects/postgres/model/PgRelationManager$RelationPart;", "element", "Lcom/intellij/database/model/basic/BasicArrangedElement;", "(Lcom/intellij/database/model/basic/BasicArrangedElement;)V", "parent", "Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "isDependentIn", "", "relation", "Lcom/intellij/database/model/properties/PgRelation;", "isOwnerIn", "intellij.database.dialects"})
    private static final class ArrangedPart
    implements RelationPart {
        private final BasicIdentifiedElement parent;
        private final BasicArrangedElement element;

        @Override
        public boolean isOwnerIn(@NotNull PgRelation relation) {
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            BasicIdentifiedElement basicIdentifiedElement = this.parent;
            return Intrinsics.areEqual((Object)relation.getOwnerKind(), (Object)(basicIdentifiedElement != null ? basicIdentifiedElement.getKind() : null)) && relation.getOwnerId() == this.parent.getObjectId() && (short)relation.getOwnerSubId() == this.element.getPosition();
        }

        @Override
        public boolean isDependentIn(@NotNull PgRelation relation) {
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            return false;
        }

        public ArrangedPart(@NotNull BasicArrangedElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.element = element2;
            BasicElement basicElement = this.element.getParent();
            if (!(basicElement instanceof BasicIdentifiedElement)) {
                basicElement = null;
            }
            this.parent = (BasicIdentifiedElement)basicElement;
        }
    }
}

