/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.AddToIgnoreListAction;
import org.jetbrains.idea.svn.actions.RemoveFromIgnoreListAction;
import org.jetbrains.idea.svn.ignore.FileGroupInfo;
import org.jetbrains.idea.svn.ignore.IgnoreGroupHelperAction;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class IgnoreActionGroup
extends DefaultActionGroup
implements DumbAware {
    private final IgnoreGroupHelperAction myHelperAction = new IgnoreGroupHelperAction();
    private final IgnoreInfoGetterStub myGetterStub = new IgnoreInfoGetterStub();
    private final RemoveFromIgnoreListAction myRemoveExactAction;
    private final RemoveFromIgnoreListAction myRemoveExtensionAction;
    private final AddToIgnoreListAction myAddExactAction = new AddToIgnoreListAction(this.myGetterStub, false);
    private final AddToIgnoreListAction myAddExtensionAction = new AddToIgnoreListAction(this.myGetterStub, true);

    public IgnoreActionGroup() {
        this.myRemoveExactAction = new RemoveFromIgnoreListAction(false, this.myGetterStub);
        this.myRemoveExtensionAction = new RemoveFromIgnoreListAction(true, this.myGetterStub);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreActionGroup.$$$reportNull$$$0(0);
        }
        FileGroupInfo fileGroupInfo = new FileGroupInfo();
        this.myHelperAction.setFileIterationListener(fileGroupInfo);
        this.myHelperAction.update(e);
        this.myGetterStub.setDelegate(fileGroupInfo);
        if (e.getPresentation().isEnabled()) {
            this.removeAll();
            if (this.myHelperAction.allAreIgnored()) {
                DataContext dataContext = e.getDataContext();
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                SvnVcs vcs = SvnVcs.getInstance(project);
                Ref filesOk = new Ref((Object)Boolean.FALSE);
                Ref extensionOk = new Ref((Object)Boolean.FALSE);
                SvnPropertyService.doCheckIgnoreProperty(vcs, null, fileGroupInfo, fileGroupInfo.getExtensionMask(), (Ref<? super Boolean>)filesOk, (Ref<? super Boolean>)extensionOk);
                if (Boolean.TRUE.equals(filesOk.get())) {
                    this.myRemoveExactAction.setActionText(fileGroupInfo.oneFileSelected() ? fileGroupInfo.getFileName() : SvnBundle.message("action.Subversion.UndoIgnore.text", new Object[0]));
                    this.add(this.myRemoveExactAction);
                }
                if (Boolean.TRUE.equals(extensionOk.get())) {
                    this.myRemoveExtensionAction.setActionText(fileGroupInfo.getExtensionMask());
                    this.add(this.myRemoveExtensionAction);
                }
                e.getPresentation().setText(SvnBundle.message("group.RevertIgnoreChoicesGroup.text", new Object[0]));
            } else if (this.myHelperAction.allCanBeIgnored()) {
                String ignoreExactlyName = fileGroupInfo.oneFileSelected() ? fileGroupInfo.getFileName() : SvnBundle.message("action.Subversion.Ignore.ExactMatch.text", new Object[0]);
                this.myAddExactAction.setActionText(ignoreExactlyName);
                this.add(this.myAddExactAction);
                if (fileGroupInfo.sameExtension()) {
                    this.myAddExtensionAction.setActionText(fileGroupInfo.getExtensionMask());
                    this.add(this.myAddExtensionAction);
                }
                e.getPresentation().setText(SvnBundle.message("group.IgnoreChoicesGroup.text", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/actions/IgnoreActionGroup", "update"));
    }

    private static class IgnoreInfoGetterStub
    implements IgnoreInfoGetter {
        private IgnoreInfoGetter myGetter;

        private IgnoreInfoGetterStub() {
        }

        private void setDelegate(IgnoreInfoGetter getter) {
            this.myGetter = getter;
        }

        @Override
        public Map<VirtualFile, Set<String>> getInfo(boolean useCommonExtension) {
            return this.myGetter.getInfo(useCommonExtension);
        }
    }
}

