/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.loop;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeParallelForInLoopsIntention
extends JSIntention {
    @NonNls
    private static final String FOR_IN_PREFIX = "for (";
    @NonNls
    private static final String FOR_IN_COLLECTION_PREFIX = " in ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeParallelForInLoopsPredicate mergeParallelForInLoopsPredicate = new MergeParallelForInLoopsPredicate();
        if (mergeParallelForInLoopsPredicate == null) {
            JSMergeParallelForInLoopsIntention.$$$reportNull$$$0(0);
        }
        return mergeParallelForInLoopsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSMergeParallelForInLoopsIntention.$$$reportNull$$$0(1);
        }
        PsiElement nextElement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
        assert (nextElement != null);
        JSForInStatement firstStatement = (JSForInStatement)element;
        JSForInStatement secondStatement = (JSForInStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        JSMergeParallelForInLoopsIntention.mergeForInStatements(statementBuffer, firstStatement, secondStatement);
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)firstStatement, (String)statementBuffer.toString());
        com.intellij.lang.javascript.psi.JSElementFactory.removeElement((PsiElement)secondStatement);
    }

    private static void mergeForInStatements(StringBuilder statementBuffer, JSForInStatement firstStatement, JSForInStatement secondStatement) {
        JSExpression variableExpression = firstStatement.getVariableExpression();
        JSVarStatement declaration = firstStatement.getDeclarationStatement();
        JSExpression collectionExpression = firstStatement.getCollectionExpression();
        JSStatement firstBody = firstStatement.getBody();
        JSStatement secondBody = secondStatement.getBody();
        statementBuffer.append(FOR_IN_PREFIX).append(declaration == null ? variableExpression.getText() : declaration.getText()).append(FOR_IN_COLLECTION_PREFIX).append(collectionExpression.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstBody, (JSStatement)secondBody);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergeParallelForInLoopsPredicate
    implements JSElementPredicate {
        private MergeParallelForInLoopsPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeParallelForInLoopsPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSForInStatement) || ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
            if (!(nextStatement instanceof JSForInStatement) || ErrorUtil.containsError((PsiElement)nextStatement)) {
                return false;
            }
            return MergeParallelForInLoopsPredicate.forInStatementsCanBeMerged((JSForInStatement)element, (JSForInStatement)nextStatement);
        }

        public static boolean forInStatementsCanBeMerged(JSForInStatement statement1, JSForInStatement statement2) {
            JSExpression secondCollection;
            JSVarStatement secondDeclaration;
            JSExpression secondVarExpression;
            JSExpression firstVarExpression = statement1.getVariableExpression();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstVarExpression, (JSExpression)(secondVarExpression = statement2.getVariableExpression()))) {
                return false;
            }
            JSVarStatement firstDeclaration = statement1.getDeclarationStatement();
            if (!EquivalenceChecker.statementsAreEquivalent((JSStatement)firstDeclaration, (JSStatement)(secondDeclaration = statement2.getDeclarationStatement()))) {
                return false;
            }
            JSExpression firstCollection = statement1.getCollectionExpression();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstCollection, (JSExpression)(secondCollection = statement2.getCollectionExpression()))) {
                return false;
            }
            JSStatement firstBody = statement1.getBody();
            JSStatement secondBody = statement2.getBody();
            return firstBody == null || secondBody == null || ControlFlowUtils.canBeMerged((JSStatement)firstBody, (JSStatement)secondBody);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention$MergeParallelForInLoopsPredicate", "satisfiedBy"));
        }
    }
}

