/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.wraptagcontents;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.psi.XMLMutationUtils;

class WrapTagContents
extends XRPUsageInfo {
    private final XmlTag tag;
    private final String wrapTagName;

    WrapTagContents(XmlTag tag, String wrapTagName) {
        super((PsiElement)tag);
        this.tag = tag;
        this.wrapTagName = wrapTagName;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newTag;
        if (XMLMutationUtils.tagHasContents(this.tag)) {
            String xmlTagStart = XMLMutationUtils.calculateStartTagString(this.tag);
            String xmlTagEnd = XMLMutationUtils.calculateEndTagString(this.tag);
            String xmlTagBody = XMLMutationUtils.calculateContentsString(this.tag);
            newTag = xmlTagStart + '<' + this.wrapTagName + '>' + xmlTagBody + "</" + this.wrapTagName + '>' + xmlTagEnd;
        } else {
            IElementType tokenType;
            PsiElement child;
            PsiElement[] children;
            int textLength = this.tag.getTextLength();
            StringBuilder newTagBuffer = new StringBuilder(textLength + 20);
            PsiElement[] psiElementArray = children = this.tag.getChildren();
            int n = psiElementArray.length;
            for (int i = 0; !(i >= n || (child = psiElementArray[i]) instanceof XmlToken && (tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_EMPTY_ELEMENT_END)); ++i) {
                String text = child.getText();
                newTagBuffer.append(text);
            }
            String name = this.tag.getName();
            newTagBuffer.append("><" + this.wrapTagName + "></" + this.wrapTagName + '>' + "</" + name + '>');
            newTag = newTagBuffer.toString();
        }
        XMLMutationUtils.replaceTag(this.tag, newTag);
    }
}

