/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.settings;

import com.intellij.docker.agent.fix.FixedBindParserBase;
import com.intellij.docker.agent.settings.DockerVolumeBinding;

public class DockerVolumeBindingImpl
implements DockerVolumeBinding {
    public static final String FLAG_READ_ONLY = "ro";
    private String myContainerPath;
    private String myHostPath;
    private boolean myReadOnly;
    private boolean myIsEditable = true;

    public static DockerVolumeBindingImpl fromString(String serialized) {
        if (serialized == null) {
            return null;
        }
        DockerVolumeBindingImpl result = new DockerVolumeBindingImpl();
        String[] pieces = FixedBindParserBase.fixedSplit(serialized);
        if (pieces.length < 2) {
            throw new IllegalArgumentException("Can not parse volume binding: " + serialized);
        }
        result.setHostPath(pieces[0]);
        result.setContainerPath(pieces[1]);
        result.setReadOnly(pieces.length == 3 && FLAG_READ_ONLY.equals(pieces[2]));
        return result;
    }

    public DockerVolumeBindingImpl() {
    }

    public DockerVolumeBindingImpl(String containerPath, String hostPath, boolean readOnly) {
        this.myContainerPath = containerPath;
        this.myHostPath = hostPath;
        this.myReadOnly = readOnly;
    }

    public DockerVolumeBindingImpl(DockerVolumeBinding source) {
        this.myContainerPath = source.getContainerPath();
        this.myHostPath = source.getHostPath();
        this.myReadOnly = source.isReadOnly();
        this.myIsEditable = source.isEditable();
    }

    @Override
    public boolean isEditable() {
        return this.myIsEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.myIsEditable = editable;
    }

    @Override
    public String getContainerPath() {
        return this.myContainerPath;
    }

    public void setContainerPath(String containerPath) {
        this.myContainerPath = containerPath;
    }

    @Override
    public String getHostPath() {
        return this.myHostPath;
    }

    public void setHostPath(String hostPath) {
        this.myHostPath = hostPath;
    }

    @Override
    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerVolumeBindingImpl binding = (DockerVolumeBindingImpl)o;
        if (this.myReadOnly != binding.myReadOnly) {
            return false;
        }
        if (this.myContainerPath != null ? !this.myContainerPath.equals(binding.myContainerPath) : binding.myContainerPath != null) {
            return false;
        }
        return !(this.myHostPath != null ? !this.myHostPath.equals(binding.myHostPath) : binding.myHostPath != null);
    }

    public int hashCode() {
        int result = this.myContainerPath != null ? this.myContainerPath.hashCode() : 0;
        result = 31 * result + (this.myHostPath != null ? this.myHostPath.hashCode() : 0);
        result = 31 * result + (this.myReadOnly ? 1 : 0);
        return result;
    }

    public String toCommandLineString() {
        String result;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.myHostPath == null ? "" : this.myHostPath);
        buffer.append(':');
        buffer.append(this.myContainerPath == null ? "" : this.myContainerPath);
        if (this.myReadOnly) {
            buffer.append(":ro");
        }
        return (result = buffer.toString()).contains(" ") ? "\"" + result + "\"" : result;
    }
}

