/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class CustomFieldValueReader9 {
    private final DirectoryEntry m_projectDir;
    private final ProjectProperties m_properties;
    private final Props m_projectProps;
    private final CustomFieldContainer m_container;
    private static final Integer VALUE = 1;
    private static final Integer DESCRIPTION = 2;

    public CustomFieldValueReader9(DirectoryEntry directoryEntry, ProjectProperties projectProperties, Props props, CustomFieldContainer customFieldContainer) {
        this.m_projectDir = directoryEntry;
        this.m_properties = projectProperties;
        this.m_projectProps = props;
        this.m_container = customFieldContainer;
    }

    public void process() throws IOException {
        this.processCustomFieldValues();
        this.processOutlineCodeValues();
    }

    private void processCustomFieldValues() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (byArray != null) {
            int n = 0;
            int n2 = MPPUtility.getInt(byArray, n);
            int n3 = MPPUtility.getInt(byArray, n += 4);
            n += 4;
            int n4 = 0;
            for (int i = 0; i < n3 && n < n2; ++i) {
                FieldType fieldType = FieldTypeHelper.getInstance(MPPUtility.getInt(byArray, n));
                n4 = MPPUtility.getInt(byArray, n += 4);
                n += 4;
                if (n4 >= byArray.length) continue;
                int n5 = n4;
                int n6 = MPPUtility.getInt(byArray, n5 += 8) + n4;
                int n7 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n8 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n9 = n7 - n6;
                byte[] byArray2 = new byte[n9];
                MPPUtility.getByteArray(byArray, n6, n9, byArray2, 0);
                int n10 = n8 - n7;
                byte[] byArray3 = new byte[n10];
                MPPUtility.getByteArray(byArray, n7, n10, byArray3, 0);
                this.populateContainer(fieldType, byArray2, byArray3);
            }
        }
    }

    private void processOutlineCodeValues() throws IOException {
        Object object;
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData")));
        HashMap<Integer, FieldType> hashMap = new HashMap<Integer, FieldType>();
        int n = fixedMeta.getItemCount();
        for (int i = 0; i < n; ++i) {
            object = fixedData.getByteArrayValue(i);
            if (((byte[])object).length < 18) continue;
            int n2 = MPPUtility.getShort(object, 0);
            int n3 = MPPUtility.getInt(object, 12);
            FieldType fieldType = FieldTypeHelper.getInstance(n3);
            if (fieldType.getFieldTypeClass() == FieldTypeClass.UNKNOWN) continue;
            hashMap.put(n2, fieldType);
        }
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        object = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        HashMap<FieldType, ArrayList<Pair<String, String>>> hashMap2 = new HashMap<FieldType, ArrayList<Pair<String, String>>>();
        for (Integer n4 : varMeta9.getUniqueIdentifierArray()) {
            FieldType fieldType = (FieldType)hashMap.get(n4);
            String string = object.getUnicodeString(n4, VALUE);
            String string2 = object.getUnicodeString(n4, DESCRIPTION);
            ArrayList<Pair<String, String>> arrayList = (ArrayList<Pair<String, String>>)hashMap2.get(fieldType);
            if (arrayList == null) {
                arrayList = new ArrayList<Pair<String, String>>();
                hashMap2.put(fieldType, arrayList);
            }
            arrayList.add(new Pair<String, String>(string, string2));
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.populateContainer((FieldType)entry.getKey(), (List)entry.getValue());
        }
    }

    private void populateContainer(FieldType fieldType, byte[] byArray, byte[] byArray2) {
        CustomField customField = this.m_container.getCustomField(fieldType);
        CustomFieldLookupTable customFieldLookupTable = customField.getLookupTable();
        List<Object> list = this.convertType(DataType.STRING, byArray2);
        List<Object> list2 = this.convertType(fieldType.getDataType(), byArray);
        for (int i = 0; i < list.size(); ++i) {
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(0);
            customFieldValueItem.setDescription((String)list.get(i));
            if (i < list2.size()) {
                customFieldValueItem.setValue(list2.get(i));
            }
            customFieldLookupTable.add(customFieldValueItem);
        }
    }

    private void populateContainer(FieldType fieldType, List<Pair<String, String>> list) {
        CustomField customField = this.m_container.getCustomField(fieldType);
        CustomFieldLookupTable customFieldLookupTable = customField.getLookupTable();
        for (Pair<String, String> pair : list) {
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(0);
            customFieldValueItem.setValue(pair.getFirst());
            customFieldValueItem.setDescription(pair.getSecond());
            customFieldLookupTable.add(customFieldValueItem);
        }
    }

    private List<Object> convertType(DataType dataType, byte[] byArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        block8: while (n < byArray.length) {
            switch (dataType) {
                case STRING: {
                    Object object = MPPUtility.getUnicodeString(byArray, n);
                    arrayList.add(object);
                    n += (((String)object).length() + 1) * 2;
                    continue block8;
                }
                case CURRENCY: {
                    Object object = MPPUtility.getDouble(byArray, n) / 100.0;
                    arrayList.add(object);
                    n += 8;
                    continue block8;
                }
                case NUMERIC: {
                    Object object = MPPUtility.getDouble(byArray, n);
                    arrayList.add(object);
                    n += 8;
                    continue block8;
                }
                case DATE: {
                    Object object = MPPUtility.getTimestamp(byArray, n);
                    arrayList.add(object);
                    n += 4;
                    continue block8;
                }
                case DURATION: {
                    Object object = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n + 4), this.m_properties.getDefaultDurationUnits());
                    Duration duration = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(byArray, n), (TimeUnit)object);
                    arrayList.add(duration);
                    n += 6;
                    continue block8;
                }
                case BOOLEAN: {
                    Object object = MPPUtility.getShort(byArray, n) == 1;
                    arrayList.add(object);
                    n += 2;
                    continue block8;
                }
            }
            n = byArray.length;
        }
        return arrayList;
    }
}

